/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;

public class IntersectionChooser {
    private boolean legacyMode_;
    private String genomeKey_;
    private Layout layout_;

    public IntersectionChooser(boolean legacyMode, String genomeKey, Layout layout) {
        this.legacyMode_ = legacyMode;
        this.genomeKey_ = genomeKey;
        this.layout_ = layout;
    }

    public Intersection intersectionRanker(List newSelections) {
        if (this.legacyMode_) {
            return this.legacyIntersectionRanker(newSelections);
        }
        throw new IllegalStateException();
    }

    public Intersection.AugmentedIntersection selectionRanker(List newSelections) {
        if (this.legacyMode_) {
            return this.legacySelectionRanker(newSelections);
        }
        return this.smarterSelectionRanker(newSelections, false);
    }

    public GenomePresentation.RunningMove runningMoveRanker(List newMoves) {
        if (this.legacyMode_) {
            return this.legacyMoveRanker(newMoves);
        }
        return this.smarterMoveRanker(newMoves);
    }

    private Intersection.AugmentedIntersection legacySelectionRanker(List newSelections) {
        if (newSelections == null || newSelections.isEmpty()) {
            return null;
        }
        return (Intersection.AugmentedIntersection)newSelections.get(0);
    }

    private Intersection.AugmentedIntersection smarterSelectionRanker(List newSelections, boolean usingForPads) {
        if (newSelections == null || newSelections.isEmpty()) {
            return null;
        }
        Intersection.AugmentedIntersection firstAug = (Intersection.AugmentedIntersection)newSelections.get(0);
        int numCand = newSelections.size();
        if (numCand == 1) {
            return firstAug;
        }
        Intersection.AugmentedIntersection secondAug = (Intersection.AugmentedIntersection)newSelections.get(1);
        if ((firstAug.type == 1 || firstAug.type == 2) && secondAug.type == 3) {
            LinkSegmentID nextID;
            if (usingForPads && firstAug.intersect.getPadCand() != null) {
                return firstAug;
            }
            Intersection selection = secondAug.intersect;
            BusProperties lp = this.layout_.getLinkProperties(selection.getObjectID());
            String src = lp.getSourceTag();
            if (!firstAug.intersect.getObjectID().equals(src)) {
                return firstAug;
            }
            LinkSegmentID[] segIDs = selection.segmentIDsFromIntersect();
            if (segIDs != null && segIDs.length == 1 && (nextID = segIDs[0]).isDirect()) {
                return secondAug;
            }
        }
        return firstAug;
    }

    private Intersection legacyIntersectionRanker(List newSelections) {
        if (newSelections == null || newSelections.isEmpty()) {
            return null;
        }
        return (Intersection)newSelections.get(0);
    }

    private GenomePresentation.RunningMove legacyMoveRanker(List newMoves) {
        if (newMoves == null || newMoves.isEmpty()) {
            return null;
        }
        return (GenomePresentation.RunningMove)newMoves.get(0);
    }

    private GenomePresentation.RunningMove smarterMoveRanker(List newMoves) {
        LinkSegmentID nextID;
        int j;
        LinkSegmentID[] segIDs;
        Intersection selection;
        GenomePresentation.RunningMove nextMove;
        ArrayList bySrc;
        String taggedSrc;
        if (newMoves == null || newMoves.isEmpty()) {
            return null;
        }
        GenomePresentation.RunningMove firstMove = (GenomePresentation.RunningMove)newMoves.get(0);
        int numCand = newMoves.size();
        if (numCand == 1) {
            return firstMove;
        }
        if (firstMove.notPermitted || firstMove.type != 3) {
            return firstMove;
        }
        if (firstMove.toMove.length > 1) {
            return firstMove;
        }
        if (firstMove.augInterType != 3) {
            return firstMove;
        }
        HashMap<String, ArrayList<GenomePresentation.RunningMove>> candBySource = new HashMap<String, ArrayList<GenomePresentation.RunningMove>>();
        HashSet<String> taggedBySource = new HashSet<String>();
        for (int i = 0; i < numCand; ++i) {
            ArrayList<GenomePresentation.RunningMove> bySrc2;
            GenomePresentation.RunningMove nextMove2 = (GenomePresentation.RunningMove)newMoves.get(i);
            if (nextMove2.augInterType != 3) continue;
            Intersection selection2 = nextMove2.toMove[0];
            BusProperties lp = this.layout_.getLinkProperties(selection2.getObjectID());
            String src = lp.getSourceTag();
            LinkSegmentID[] segIDs2 = selection2.segmentIDsFromIntersect();
            if (segIDs2 != null) {
                for (int j2 = 0; j2 < segIDs2.length; ++j2) {
                    LinkSegmentID nextID2 = segIDs2[j2];
                    if (!nextID2.isTaggedWithEndpoint()) continue;
                    taggedBySource.add(src);
                    break;
                }
            }
            if ((bySrc2 = (ArrayList<GenomePresentation.RunningMove>)candBySource.get(src)) == null) {
                bySrc2 = new ArrayList<GenomePresentation.RunningMove>();
                candBySource.put(src, bySrc2);
            }
            bySrc2.add(nextMove2);
        }
        int cbs = candBySource.size();
        int tbs = taggedBySource.size();
        if (cbs > 1 && tbs > 0 && tbs < cbs) {
            taggedSrc = (String)taggedBySource.iterator().next();
            bySrc = (ArrayList)candBySource.get(taggedSrc);
            int numMov = bySrc.size();
            for (int i = 0; i < numMov; ++i) {
                nextMove = (GenomePresentation.RunningMove)bySrc.get(i);
                selection = nextMove.toMove[0];
                segIDs = selection.segmentIDsFromIntersect();
                for (j = 0; j < segIDs.length; ++j) {
                    nextID = segIDs[j];
                    if (!nextID.isTaggedWithEndpoint()) continue;
                    return nextMove;
                }
            }
        }
        if (cbs == 1 && tbs == 1) {
            taggedSrc = (String)taggedBySource.iterator().next();
            bySrc = (ArrayList)candBySource.get(taggedSrc);
            int numMov = bySrc.size();
            for (int i = 0; i < numMov; ++i) {
                nextMove = (GenomePresentation.RunningMove)bySrc.get(i);
                selection = nextMove.toMove[0];
                segIDs = selection.segmentIDsFromIntersect();
                if (segIDs == null) continue;
                for (j = 0; j < segIDs.length; ++j) {
                    nextID = segIDs[j];
                    if (!nextID.isTaggedWithEndpoint()) continue;
                    return nextMove;
                }
            }
        }
        return firstMove;
    }
}

