/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutMetadata;
import org.systemsbiology.biotapestry.ui.LinkOptimizer;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleBusDrop;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetModuleShapeFixer;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.SpecialSegmentTracker;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.ui.freerender.MultiSubID;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleLinkageFree;
import org.systemsbiology.biotapestry.ui.freerender.NodeBounder;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridRenderer;
import org.systemsbiology.biotapestry.util.AffineCombination;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.PatternPlacerSpiral;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class Layout {
    public static final int BALL_LAYOUT = 0;
    public static final int GRID_LAYOUT = 1;
    public static final int FREE_LAYOUT = 2;
    public static final String DATE = "date";
    public static final String ATTRIB = "attrib";
    public static final String TITLE = "title";
    public static final String KEY = "key";
    private String name_;
    private String targetGenome_;
    private HashMap nodeProps_;
    private HashMap linkProps_;
    private HashMap groupProps_;
    private HashMap ovrProps_;
    private HashMap noteProps_;
    private HashMap dataProps_;
    private int layout_;
    private GenomeSource altGenomeSource_;
    private LayoutMetadata lmeta_;

    public Layout(String name, String targetGenome) {
        this.name_ = name;
        this.targetGenome_ = targetGenome;
        this.nodeProps_ = new HashMap();
        this.linkProps_ = new HashMap();
        this.groupProps_ = new HashMap();
        this.ovrProps_ = new HashMap();
        this.noteProps_ = new HashMap();
        this.dataProps_ = new HashMap();
        this.layout_ = 2;
        this.altGenomeSource_ = null;
        this.lmeta_ = new LayoutMetadata();
    }

    public Layout(String name, String targetGenome, int type) {
        this.name_ = name;
        this.targetGenome_ = targetGenome;
        this.nodeProps_ = new HashMap();
        this.linkProps_ = new HashMap();
        this.groupProps_ = new HashMap();
        this.ovrProps_ = new HashMap();
        this.noteProps_ = new HashMap();
        this.dataProps_ = new HashMap();
        this.altGenomeSource_ = null;
        this.layout_ = type;
        this.lmeta_ = new LayoutMetadata();
    }

    public Layout(Layout other) {
        this.copyCore(other, null);
    }

    public Layout(Layout other, String name, String targetGenome, Map groupIDMap) {
        this.copyCore(other, groupIDMap);
        this.name_ = name;
        this.targetGenome_ = targetGenome;
    }

    public void setAlternateGenomeSource(GenomeSource src) {
        this.altGenomeSource_ = src;
    }

    public void replaceContents(Layout other) {
        this.copyCore(other, null);
    }

    public Rectangle getLayoutBounds(Genome genome, FontRenderContext frc, boolean doLinks, boolean doModules, boolean doModuleLinks, boolean doNotes, boolean doLinkLabels, String overOwnerKey, String ovrKey, TaggedSet modSet, OverlayKeySet allKeys) {
        Rectangle noteBounds;
        Rectangle retval = null;
        retval = genome instanceof GenomeInstance ? this.getLayoutBoundsViaGroups((GenomeInstance)genome, frc, doLinks) : this.getPartialBounds(genome, frc, null, doLinks, doLinkLabels, null, null, true);
        if (doNotes && (noteBounds = this.getNoteBounds(genome, frc)) != null) {
            if (retval == null) {
                retval = noteBounds;
            } else {
                Bounds.tweakBounds(retval, noteBounds);
            }
        }
        if (!doModules) {
            return retval;
        }
        Rectangle nmBounds = null;
        if (ovrKey != null) {
            if (modSet != null && !modSet.set.isEmpty()) {
                NetOverlayOwner owner = Database.getDB().getOverlayOwnerWithOwnerKey(overOwnerKey);
                nmBounds = this.getLayoutBoundsForNetModules(genome, owner, ovrKey, modSet, frc, doModuleLinks);
            }
        } else if (allKeys != null) {
            nmBounds = this.getLayoutBoundsForAllOverlays(allKeys, genome, frc, doModuleLinks);
        }
        if (retval == null) {
            retval = nmBounds;
        } else if (nmBounds != null) {
            Bounds.tweakBounds(retval, nmBounds);
        }
        return retval;
    }

    public Rectangle getLayoutBoundsViaGroups(GenomeInstance gi, FontRenderContext frc, boolean doLinks) {
        Rectangle retval = null;
        Iterator grit = gi.getGroupIterator();
        while (grit.hasNext()) {
            Group grp = (Group)grit.next();
            GroupProperties gp = this.getGroupProperties(grp.getID());
            Rectangle bounds = this.getLayoutBoundsForGroup(gi, grp, frc, doLinks);
            if (retval == null) {
                retval = bounds;
                continue;
            }
            Bounds.tweakBounds(retval, bounds);
        }
        return retval;
    }

    public Rectangle getNoteBounds(Genome genome, FontRenderContext frc) {
        Rectangle retval = null;
        Iterator ntit = genome.getNoteIterator();
        while (ntit.hasNext()) {
            Note note = (Note)ntit.next();
            NoteProperties np = this.getNoteProperties(note.getID());
            IRenderer rend = np.getRenderer();
            Rectangle bounds = rend.getBounds(genome, note, this, frc, null);
            if (retval == null) {
                retval = bounds;
                continue;
            }
            Bounds.tweakBounds(retval, bounds);
        }
        return retval;
    }

    public Rectangle getPartialBounds(Genome genome, FontRenderContext frc, Set nodeIDs, boolean doLinks, boolean doLinkLabels, Set linkIDs, Map linkSubs, boolean legacySegs) {
        Rectangle retval = null;
        Iterator git = genome.getAllNodeIterator();
        while (git.hasNext()) {
            NodeProperties np;
            Node node = (Node)git.next();
            String nodeID = node.getID();
            if (nodeIDs != null && !nodeIDs.contains(nodeID) || (np = this.getNodeProperties(nodeID)) == null) continue;
            INodeRenderer rend = np.getRenderer();
            Rectangle bounds = rend.getBounds(genome, node, this, frc, null);
            if (retval == null) {
                retval = bounds;
                continue;
            }
            Bounds.tweakBounds(retval, bounds);
        }
        if (doLinks) {
            LinkageFree rend = new LinkageFree();
            Iterator lit = genome.getLinkageIterator();
            HashSet<BusProperties> seen = new HashSet<BusProperties>();
            while (lit.hasNext()) {
                BusProperties lprops;
                Linkage link = (Linkage)lit.next();
                String linkID = link.getID();
                if (linkIDs != null && !linkIDs.contains(linkID) || (lprops = this.getLinkProperties(linkID)) == null || seen.contains(lprops)) continue;
                MultiSubID si = null;
                if (linkSubs != null) {
                    si = (MultiSubID)linkSubs.get(linkID);
                }
                seen.add(lprops);
                Rectangle bounds = legacySegs ? rend.getBoundsOfSegments(genome, link, this, frc, si, doLinkLabels) : rend.getBoundsForSinglePath(genome, link, this, frc);
                if (bounds == null) continue;
                if (retval == null) {
                    retval = bounds;
                    continue;
                }
                Bounds.tweakBounds(retval, bounds);
            }
        }
        return retval;
    }

    public Rectangle getLayoutBoundsForGroup(GenomeInstance gi, Group grp, FontRenderContext frc, boolean doLinks) {
        Rectangle retval = null;
        GroupFree gRend = new GroupFree();
        retval = gRend.getBounds(gi, grp, this, frc, null);
        if (doLinks) {
            LinkageFree rend = new LinkageFree();
            Iterator glit = gi.getLinkageIterator();
            while (glit.hasNext()) {
                Rectangle bounds;
                String linkID;
                BusProperties lprops;
                Linkage link = (Linkage)glit.next();
                String src = link.getSource();
                String trg = link.getTarget();
                if (!grp.isInGroup(src, gi) || !grp.isInGroup(trg, gi) || (lprops = this.getLinkProperties(linkID = link.getID())) == null || (bounds = rend.getBoundsForSinglePath(gi, link, this, frc)) == null) continue;
                if (retval == null) {
                    retval = bounds;
                    continue;
                }
                Bounds.tweakBounds(retval, bounds);
            }
        }
        if (retval != null) {
            UiUtil.forceToGrid(retval, 10.0);
        }
        return retval;
    }

    public Map sliceModulesByAllBounds(Map boundsForGroups, Map groupZOrder, OverlayKeySet fullKeys, FontRenderContext frc) {
        if (fullKeys == null) {
            return null;
        }
        Database db = Database.getDB();
        HashMap<NetModule.FullModuleKey, NetModuleProperties.SliceResult> retval = new HashMap<NetModule.FullModuleKey, NetModuleProperties.SliceResult>();
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
            NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
            NetModule nmod = no.getModule(fullKey.modKey);
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
            if (nmp.getType() == 2) continue;
            Rectangle2D nameBounds = nmp.getRenderer().getNameBounds(nmp, nmod, frc);
            NetModuleProperties.SliceResult slices = nmp.sliceByAllBounds(boundsForGroups, groupZOrder, nameBounds);
            retval.put(fullKey, slices);
        }
        return retval;
    }

    public Map sliceModuleLinksByAllBounds(Map boundsForGroups, Map groupZOrder, OverlayKeySet fullKeys, FontRenderContext frc) {
        if (fullKeys == null) {
            return null;
        }
        HashSet<String> seenKeys = new HashSet<String>();
        HashMap retval = new HashMap();
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            if (seenKeys.contains(fullKey.ovrKey)) continue;
            seenKeys.add(fullKey.ovrKey);
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
            HashMap<String, Map> assignPerTree = new HashMap<String, Map>();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
                Map assignments = nmlp.mapSegmentsToBounds(boundsForGroups, groupZOrder);
                assignPerTree.put(lkey, assignments);
            }
            retval.put(fullKey.ovrKey, assignPerTree);
        }
        return retval;
    }

    public Point2D getApproxCenter(Iterator nit, Iterator git) {
        NodeProperties np;
        HashSet<Point2D> set = new HashSet<Point2D>();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            np = this.getNodeProperties(node.getID());
            set.add(np.getLocation());
        }
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            np = this.getNodeProperties(gene.getID());
            set.add(np.getLocation());
        }
        return set.size() == 0 ? null : AffineCombination.combination(set, 10.0);
    }

    public Point2D getApproxCenter(Iterator nit) {
        HashSet<Point2D> set = new HashSet<Point2D>();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            NodeProperties np = this.getNodeProperties(node.getID());
            set.add(np.getLocation());
        }
        return set.size() == 0 ? null : AffineCombination.combination(set, 10.0);
    }

    public Point2D getApproxCenterForIDs(Iterator nit) {
        HashSet<Point2D> set = new HashSet<Point2D>();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            NodeProperties np = this.getNodeProperties(nodeID);
            set.add(np.getLocation());
        }
        return set.size() == 0 ? null : AffineCombination.combination(set, 10.0);
    }

    public Point2D getApproxCenterForGroup(GenomeInstance gi, String groupID, boolean forRoot) {
        HashSet<Point2D> set = new HashSet<Point2D>();
        Group grp = gi.getGroup(groupID);
        Iterator grit = grp.getMemberIterator();
        while (grit.hasNext()) {
            GroupMember memb = (GroupMember)grit.next();
            String id = forRoot ? GenomeItemInstance.getBaseID(memb.getID()) : memb.getID();
            NodeProperties np = this.getNodeProperties(id);
            set.add(np.getLocation());
        }
        return set.isEmpty() ? null : AffineCombination.combination(set, 10.0);
    }

    public Rectangle getApproxBounds(Iterator nit, Iterator git, Genome genome) {
        Rectangle bounds;
        INodeRenderer rend;
        NodeProperties np;
        Rectangle retval = new Rectangle(0, 0, 0, 0);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            np = this.getNodeProperties(gene.getID());
            rend = np.getRenderer();
            bounds = rend.getBounds(genome, gene, this, frc, null);
            Bounds.tweakBounds(retval, bounds);
        }
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            np = this.getNodeProperties(node.getID());
            rend = np.getRenderer();
            bounds = rend.getBounds(genome, node, this, frc, null);
            Bounds.tweakBounds(retval, bounds);
        }
        Bounds.padBounds(retval, 100, 100);
        return retval;
    }

    public void groupTagToCorner(GenomeInstance gi, Group grp, FontRenderContext frc, boolean doLinks) {
        Rectangle bounds = this.getLayoutBoundsForGroup(gi, grp, frc, doLinks);
        GroupFree gRend = new GroupFree();
        Rectangle labelBounds = gRend.getLabelBounds(gi, grp, this, frc);
        if (labelBounds == null) {
            return;
        }
        GroupProperties gp = (GroupProperties)this.groupProps_.get(grp.getID());
        int leftPad = gp.getPadding(2);
        int bottomPad = gp.getPadding(1);
        int leftX = bounds.x + leftPad;
        int bottomY = bounds.y + bounds.height - bottomPad;
        int labelY = bottomY - labelBounds.height / 2 - 10;
        int labelX = leftX + labelBounds.width / 2 + 10;
        Point2D.Double tagCenter = new Point2D.Double(labelX, labelY);
        UiUtil.forceToGrid(tagCenter, 10.0);
        gp.setLabelLocation(tagCenter);
    }

    public Point2D getLayoutCenterAllOverlays(FontRenderContext frc, OverlayKeySet allKeys) {
        Genome myTarg = this.getGenomeTarget();
        Rectangle bounds = this.getLayoutBounds(myTarg, frc, true, true, true, true, true, null, null, null, allKeys);
        if (bounds == null) {
            return null;
        }
        int cx = bounds.x + bounds.width / 2;
        int cy = bounds.y + bounds.height / 2;
        Point2D.Double gridCenter = new Point2D.Double();
        UiUtil.forceToGrid(cx, cy, gridCenter, 10.0);
        return gridCenter;
    }

    public Point2D getLayoutCenter(FontRenderContext frc, boolean doModules, String overOwnerKey, String ovrKey, TaggedSet modSet, OverlayKeySet fullModKeys) {
        Genome myTarg = this.getGenomeTarget();
        Rectangle bounds = this.getLayoutBounds(myTarg, frc, true, doModules, doModules, true, true, overOwnerKey, ovrKey, modSet, fullModKeys);
        if (bounds == null) {
            return null;
        }
        int cx = bounds.x + bounds.width / 2;
        int cy = bounds.y + bounds.height / 2;
        Point2D.Double gridCenter = new Point2D.Double();
        UiUtil.forceToGrid(cx, cy, gridCenter, 10.0);
        return gridCenter;
    }

    public Vector2D alignToLayout(Layout other, FontRenderContext frc, boolean matchNodes, OverlayKeySet fullModKeys, OverlayKeySet otherFullModKeys, PadNeedsForLayout padReqs) {
        Point2D otherCenter;
        Genome myGenome = this.getGenomeTarget();
        if (matchNodes) {
            Genome rootGenome = this.getRootGenome();
            if (!other.getTarget().equals(rootGenome.getID()) || !(myGenome instanceof GenomeInstance)) {
                throw new IllegalArgumentException();
            }
            GenomeInstance gi = (GenomeInstance)myGenome;
            otherCenter = this.rootOverlay(other, rootGenome, gi, frc, otherFullModKeys != null, null, null, null, otherFullModKeys);
        } else {
            otherCenter = other.getLayoutCenter(frc, otherFullModKeys != null, null, null, null, otherFullModKeys);
        }
        if (otherCenter == null) {
            Rectangle rect = Database.getDB().getWorkspace().getWorkspace();
            otherCenter = new Point2D.Double(rect.getWidth() / 2.0, rect.getHeight() / 2.0);
        }
        Vector2D diff = this.recenterLayout(otherCenter, myGenome, frc, true, fullModKeys != null, fullModKeys != null, null, null, null, fullModKeys, padReqs);
        return diff;
    }

    public Point2D rootOverlay(Layout rootLayout, Genome rootGenome, GenomeInstance gi, FontRenderContext frc, boolean doModules, String overOwnerKey, String ovrKey, TaggedSet modSet, OverlayKeySet fullModKeys) {
        Point2D myCenter = this.getLayoutCenter(frc, doModules, overOwnerKey, ovrKey, modSet, fullModKeys);
        if (myCenter == null) {
            return null;
        }
        double maxArea = 0.0;
        double minDist = Double.POSITIVE_INFINITY;
        Group matchGroup = null;
        Iterator git = gi.getGroupIterator();
        if (gi.groupCount() == 1) {
            matchGroup = (Group)git.next();
        } else {
            while (git.hasNext()) {
                double centerY;
                double centerX;
                double cDiff;
                Rectangle bounds;
                Group grp = (Group)git.next();
                if (grp.isASubset(gi) || (bounds = this.getLayoutBoundsForGroup(gi, grp, frc, true)) == null || (cDiff = myCenter.distance(centerX = (double)bounds.x + (double)bounds.width / 2.0, centerY = (double)bounds.y + (double)bounds.height / 2.0)) > minDist) continue;
                double area = (double)bounds.height * (double)bounds.width;
                if (!(cDiff < minDist) && !(area > maxArea)) continue;
                minDist = cDiff;
                maxArea = area;
                matchGroup = grp;
            }
        }
        if (matchGroup == null) {
            return null;
        }
        Vector2D maxCountOff = null;
        int maxCount = 0;
        HashMap<Vector2D, Integer> offsetCounts = new HashMap<Vector2D, Integer>();
        Iterator memit = matchGroup.getMemberIterator();
        while (memit.hasNext()) {
            GroupMember gm = (GroupMember)memit.next();
            String memberID = gm.getID();
            NodeProperties myNp = this.getNodeProperties(memberID);
            String baseID = GenomeItemInstance.getBaseID(memberID);
            NodeProperties rootNp = rootLayout.getNodeProperties(baseID);
            Vector2D diff = new Vector2D(myNp.getLocation(), rootNp.getLocation());
            Integer count = (Integer)offsetCounts.get(diff);
            if (count == null) {
                offsetCounts.put(diff, new Integer(1));
                if (maxCount != 0) continue;
                maxCount = 1;
                maxCountOff = diff;
                continue;
            }
            int countVal = count;
            if (++countVal > maxCount) {
                maxCount = countVal;
                maxCountOff = diff;
            }
            offsetCounts.put(diff, new Integer(countVal));
        }
        if (maxCountOff == null) {
            return null;
        }
        Point2D shiftCenter = maxCountOff.add(myCenter);
        return shiftCenter;
    }

    public Vector2D recenterLayout(Point2D center, Genome genome, FontRenderContext frc, boolean doLinks, boolean doModules, boolean doModuleLinks, String overOwnerKey, String ovrKey, TaggedSet modSet, OverlayKeySet fullModKeys, PadNeedsForLayout padReqs) {
        Rectangle bounds = this.getLayoutBounds(genome, frc, doLinks, doModules, doModuleLinks, true, true, overOwnerKey, ovrKey, modSet, fullModKeys);
        if (bounds == null) {
            return null;
        }
        int cx = bounds.x + bounds.width / 2;
        int cy = bounds.y + bounds.height / 2;
        Point2D.Double oldCenter = new Point2D.Double();
        UiUtil.forceToGrid(cx, cy, oldCenter, 10.0);
        Vector2D diff = new Vector2D(oldCenter, center);
        this.shiftLayout(diff, padReqs);
        return diff;
    }

    public void shiftLayout(Vector2D diff, PadNeedsForLayout padReqs) {
        double dx = UiUtil.forceToGridValue(diff.getX(), 10.0);
        double dy = UiUtil.forceToGridValue(diff.getY(), 10.0);
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties props = (GroupProperties)gpit.next();
            Point2D loc = props.getLabelLocation();
            if (loc == null) continue;
            props.setLabelLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        }
        Iterator npit = this.nodeProps_.keySet().iterator();
        while (npit.hasNext()) {
            String nodeID = (String)npit.next();
            NodeProperties props = (NodeProperties)this.nodeProps_.get(nodeID);
            Point2D loc = props.getLocation();
            this.rigidPadFixes(nodeID, dx, dy, padReqs);
            props.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        }
        HashSet<BusProperties> seen = new HashSet<BusProperties>();
        Iterator lpit = this.linkProps_.values().iterator();
        while (lpit.hasNext()) {
            BusProperties props = (BusProperties)lpit.next();
            if (seen.contains(props)) continue;
            props.fullShift(dx, dy);
            seen.add(props);
        }
        Iterator ntit = this.noteProps_.values().iterator();
        while (ntit.hasNext()) {
            NoteProperties np = (NoteProperties)ntit.next();
            Point2D loc = np.getLocation();
            np.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        }
        Iterator dpit = this.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            String key = (String)dpit.next();
            Point2D pt = (Point2D)this.dataProps_.get(key);
            if (pt == null) continue;
            Point2D.Double newLoc = new Point2D.Double(pt.getX() + dx, pt.getY() + dy);
            this.dataProps_.put(key, newLoc);
        }
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String key = (String)opit.next();
            NetOverlayProperties nop = (NetOverlayProperties)this.ovrProps_.get(key);
            Iterator mpit = nop.getNetModulePropertiesKeys();
            while (mpit.hasNext()) {
                String mkey = (String)mpit.next();
                NetModuleProperties nmp = nop.getNetModuleProperties(mkey);
                nmp.shift(dx, dy);
            }
            Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
                nmlp.fullShift(dx, dy);
            }
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getTarget() {
        return this.targetGenome_;
    }

    public void setMetadata(LayoutMetadata lmeta) {
        this.lmeta_ = lmeta;
    }

    public boolean haveNodeMetadataDependency(String modelID, String nodeID) {
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            return false;
        }
        return ld.haveNodeDependency(modelID, nodeID);
    }

    public PropChange dropNodeMetadataDependency(String modelID, String nodeID) {
        PropChange retval = new PropChange();
        retval.layoutKey = this.name_;
        retval.metaOrig = (LayoutMetadata)this.lmeta_.clone();
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            throw new IllegalStateException();
        }
        ld.removeNodeDependency(modelID, nodeID);
        retval.newMeta = (LayoutMetadata)this.lmeta_.clone();
        return retval;
    }

    public boolean haveGroupMetadataDependency(String modelID, String groupID) {
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            return false;
        }
        return ld.haveGroupDependency(modelID, groupID);
    }

    public PropChange dropGroupMetadataDependency(String modelID, String groupID) {
        PropChange retval = new PropChange();
        retval.layoutKey = this.name_;
        retval.metaOrig = (LayoutMetadata)this.lmeta_.clone();
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            throw new IllegalStateException();
        }
        ld.removeGroupDependency(modelID, groupID);
        retval.newMeta = (LayoutMetadata)this.lmeta_.clone();
        return retval;
    }

    public boolean haveModelMetadataDependency(String modelID) {
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            return false;
        }
        return ld.haveModelDependency(modelID);
    }

    public PropChange dropModelMetadataDependency(String modelID) {
        PropChange retval = new PropChange();
        retval.layoutKey = this.name_;
        retval.metaOrig = (LayoutMetadata)this.lmeta_.clone();
        LayoutDerivation ld = this.lmeta_.getDerivation();
        if (ld == null) {
            throw new IllegalStateException();
        }
        ld.removeModelDependency(modelID);
        retval.newMeta = (LayoutMetadata)this.lmeta_.clone();
        return retval;
    }

    public LayoutDerivation getDerivation() {
        return this.lmeta_.getDerivation();
    }

    public PropChange setDerivation(LayoutDerivation ld) {
        PropChange retval = new PropChange();
        retval.layoutKey = this.name_;
        retval.metaOrig = (LayoutMetadata)this.lmeta_.clone();
        this.lmeta_.setDerivation(ld);
        retval.newMeta = (LayoutMetadata)this.lmeta_.clone();
        return retval;
    }

    public PropChange setNodeProperties(String itemId, NodeProperties props) {
        PropChange retval = new PropChange();
        retval.nOrig = null;
        retval.nNewProps = props;
        retval.layoutKey = this.name_;
        this.nodeProps_.put(itemId, props);
        return retval;
    }

    public void hideAllMinorNodeNames() {
        Genome genome = Database.getDB().getGenome();
        this.nodeProps_.keySet().iterator();
        Iterator npit = this.nodeProps_.keySet().iterator();
        while (npit.hasNext()) {
            String pKey = (String)npit.next();
            Node node = genome.getNode(GenomeItemInstance.getBaseID(pKey));
            NodeProperties props = (NodeProperties)this.nodeProps_.get(pKey);
            if (!NodeProperties.canHideName(node.getNodeType())) continue;
            props.setHideName(true);
        }
    }

    public PropChange removeNodeProperties(String itemId) {
        PropChange retval = new PropChange();
        retval.nOrig = (NodeProperties)this.nodeProps_.get(itemId);
        retval.layoutKey = this.name_;
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        retval.nNewProps = null;
        this.nodeProps_.remove(itemId);
        return retval;
    }

    public void setLinkProperties(String itemId, BusProperties props) {
        this.linkProps_.put(itemId, props);
    }

    public PropChange setLinkPropertiesForUndo(String itemId, BusProperties props, BusProperties commonClone) {
        PropChange retval = new PropChange();
        retval.orig = null;
        retval.newProps = commonClone == null ? (BusProperties)props.clone() : commonClone;
        retval.layoutKey = this.name_;
        this.linkProps_.put(itemId, props);
        retval.linkIDs = new HashSet();
        retval.linkIDs.add(itemId);
        return retval;
    }

    public void removeLinkPropertiesAndRemember(String itemId, Map rememberProps, Genome genome, FontRenderContext frc) {
        BusProperties lp = this.getLinkProperties(itemId);
        if (lp == null) {
            return;
        }
        BusProperties.RememberProps rp = new BusProperties.RememberProps(lp, genome, this, frc);
        rememberProps.put(itemId, rp);
        lp.removeLinkSupport(itemId);
        this.linkProps_.remove(itemId);
    }

    public PropChange removeLinkProperties(String itemId) {
        BusProperties lp = this.getLinkProperties(itemId);
        if (lp == null) {
            return null;
        }
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, lp, null);
        retval.linkIDs.remove(itemId);
        retval.removedLinkID = itemId;
        retval.addedLinkID = null;
        if (!retval.linkIDs.isEmpty()) {
            lp.removeLinkSupport(itemId);
            this.undoPostProcess(retval, lp, null);
        }
        this.linkProps_.remove(itemId);
        return retval;
    }

    public void dropAllLinkProperties() {
        this.linkProps_.clear();
    }

    public Map dropPropertiesIncludingOverlays(Genome genome, FontRenderContext frc) {
        Map retval = this.dropProperties(genome, frc);
        this.ovrProps_.clear();
        return retval;
    }

    public Map dropProperties(Genome genome, FontRenderContext frc) {
        Map retval = this.dropNodeAndLinkProperties(genome, frc);
        this.groupProps_.clear();
        return retval;
    }

    public Map dropNodeAndLinkProperties(Genome genome, FontRenderContext frc) {
        Map retval = this.buildRememberProps(genome, frc);
        this.nodeProps_.clear();
        this.linkProps_.clear();
        return retval;
    }

    public Map buildRememberProps(Genome genome, FontRenderContext frc) {
        HashMap<String, BusProperties.RememberProps> retval = new HashMap<String, BusProperties.RememberProps>();
        Iterator lpkit = this.linkProps_.keySet().iterator();
        while (lpkit.hasNext()) {
            String lid = (String)lpkit.next();
            BusProperties lp = (BusProperties)this.linkProps_.get(lid);
            BusProperties.RememberProps rp = new BusProperties.RememberProps(lp, genome, this, frc);
            retval.put(lid, rp);
        }
        return retval;
    }

    public Map buildInheritedRememberProps(Map rootProps, GenomeInstance gi) {
        HashMap<String, BusProperties.RememberProps> retval = new HashMap<String, BusProperties.RememberProps>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            Linkage lnk = (Linkage)glit.next();
            String lid = lnk.getID();
            BusProperties.RememberProps rp = (BusProperties.RememberProps)rootProps.get(GenomeItemInstance.getBaseID(lid));
            rp = rp.buildInheritedProps(gi);
            retval.put(lid, rp);
        }
        return retval;
    }

    public Map rememberSpecialLinks(Genome genome) {
        HashMap<String, SpecialSegmentTracker> retval = new HashMap<String, SpecialSegmentTracker>();
        HashSet<String> seen = new HashSet<String>();
        Iterator lpkit = this.linkProps_.values().iterator();
        while (lpkit.hasNext()) {
            BusProperties bp = (BusProperties)lpkit.next();
            String ref = bp.getSourceTag();
            if (seen.contains(ref)) continue;
            seen.add(ref);
            SpecialSegmentTracker sst = new SpecialSegmentTracker();
            sst.analyzeSpecialLinks(bp, genome);
            if (!sst.hasSpecialLinks()) continue;
            retval.put(ref, sst);
        }
        return retval;
    }

    public Map buildInheritedSpecialLinks(Map rootSpecials, GenomeInstance gi) {
        HashMap<String, SpecialSegmentTracker> retval = new HashMap<String, SpecialSegmentTracker>();
        HashSet<String> seen = new HashSet<String>();
        Iterator lpkit = this.linkProps_.values().iterator();
        while (lpkit.hasNext()) {
            BusProperties lp = (BusProperties)lpkit.next();
            String ref = lp.getSourceTag();
            if (seen.contains(ref)) continue;
            seen.add(ref);
            NodeInstance ni = (NodeInstance)gi.getNode(ref);
            String baseID = GenomeItemInstance.getBaseID(ref);
            SpecialSegmentTracker sst = (SpecialSegmentTracker)rootSpecials.get(baseID);
            if (sst == null) continue;
            SpecialSegmentTracker inheritSst = sst.buildInheritedSpecialLinks(lp, gi, ni);
            retval.put(ref, inheritSst);
        }
        return retval;
    }

    public void restoreSpecialLinks(Map guide, Genome genome) {
        HashSet<String> seen = new HashSet<String>();
        Iterator lpkit = this.linkProps_.values().iterator();
        while (lpkit.hasNext()) {
            BusProperties bp = (BusProperties)lpkit.next();
            String ref = bp.getSourceTag();
            if (seen.contains(ref)) continue;
            seen.add(ref);
            SpecialSegmentTracker sst = (SpecialSegmentTracker)guide.get(ref);
            if (sst == null) continue;
            sst.reapplySpecialLinks(bp, genome);
        }
    }

    public void restoreLabelLocations(Map rememberProps, Genome genome, FontRenderContext frc, Rectangle2D rect) {
        HashSet<String> seen = new HashSet<String>();
        Iterator lpkit = this.linkProps_.keySet().iterator();
        while (lpkit.hasNext()) {
            String key = (String)lpkit.next();
            BusProperties bp = (BusProperties)this.linkProps_.get(key);
            String ref = bp.getSourceTag();
            if (seen.contains(ref)) continue;
            seen.add(ref);
            BusProperties.RememberProps rp = (BusProperties.RememberProps)rememberProps.get(key);
            rp.restoreLabelPosition(bp, this, genome, frc, rect);
        }
    }

    public Map dropSelectedLinkProperties(Set toDrop, Genome genome, FontRenderContext frc) {
        if (toDrop == null) {
            Map retval = this.buildRememberProps(genome, frc);
            this.dropAllLinkProperties();
            return retval;
        }
        HashMap<String, BusProperties.RememberProps> retval = new HashMap<String, BusProperties.RememberProps>();
        Iterator tdit = toDrop.iterator();
        while (tdit.hasNext()) {
            String linkID = (String)tdit.next();
            BusProperties lp = (BusProperties)this.linkProps_.get(linkID);
            if (this.linkProps_.get(linkID) == null) continue;
            BusProperties.RememberProps rp = new BusProperties.RememberProps(lp, genome, this, frc);
            retval.put(linkID, rp);
            this.linkProps_.remove(linkID);
        }
        return retval;
    }

    public void dropUselessCorners(Genome genome, FontRenderContext frc, OverlayStateOracle oso, String overID, double startFrac, double maxFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LinkOptimizer opt = new LinkOptimizer();
        List toProcess = this.listOfProps(genome, overID, null);
        double progFrac = (maxFrac - startFrac) / (double)toProcess.size();
        double currFrac = startFrac;
        int numTP = toProcess.size();
        for (int i = 0; i < numTP; ++i) {
            boolean keepGoing;
            LinkProperties lp = (LinkProperties)toProcess.get(i);
            opt.eliminateUselessCornersGridless(lp, genome, this, frc, oso, overID, currFrac, currFrac + progFrac, monitor);
            if (monitor == null || (keepGoing = monitor.updateProgress((int)((currFrac += progFrac) * 100.0)))) continue;
            throw new AsynchExitRequestException();
        }
    }

    public List listOfProps(Genome genome, String overID, Set onlyLinks) {
        ArrayList<LinkProperties> toProcess = new ArrayList<LinkProperties>();
        if (overID == null) {
            Iterator lit = genome.getLinkageIterator();
            HashSet<BusProperties> seen = new HashSet<BusProperties>();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String linkID = link.getID();
                BusProperties lprops = this.getLinkProperties(linkID);
                if (lprops == null || seen.contains(lprops) || onlyLinks != null && !onlyLinks.contains(linkID)) continue;
                toProcess.add(lprops);
                seen.add(lprops);
            }
        } else {
            NetOverlayProperties nop = this.getNetOverlayProperties(overID);
            Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
                toProcess.add(nmlp);
            }
        }
        return toProcess;
    }

    public void eliminateStaggeredRuns(int staggerBound, Genome genome, FontRenderContext frc, OverlayStateOracle oso, String overID, Set pinnedPoints, double startFrac, double maxFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid grid = router.initGrid(genome, this, frc, null, 1, monitor);
        LinkOptimizer opt = new LinkOptimizer();
        List toProcess = this.listOfProps(genome, overID, null);
        double progFrac = (maxFrac - startFrac) / (double)toProcess.size();
        double currFrac = startFrac;
        int numTP = toProcess.size();
        for (int i = 0; i < numTP; ++i) {
            boolean keepGoing;
            LinkProperties lp = (LinkProperties)toProcess.get(i);
            opt.eliminateStaggeredRuns(lp, grid, staggerBound, genome, this, frc, oso, overID, pinnedPoints, currFrac, currFrac + progFrac, monitor);
            if (monitor == null || (keepGoing = monitor.updateProgress((int)((currFrac += progFrac) * 100.0)))) continue;
            throw new AsynchExitRequestException();
        }
    }

    public void optimizeLinks(Set newLinks, LinkPlacementGrid grid, Genome genome, FontRenderContext frc, OverlayStateOracle oso, String overID, Set pinnedPoints, boolean allowReroutes, BTProgressMonitor monitor, int rounds, double startFrac, double maxFrac) throws AsynchExitRequestException {
        if (rounds == 0) {
            return;
        }
        LinkOptimizer opt = new LinkOptimizer();
        int[] opts = opt.getOptimizations(allowReroutes);
        double[] perLink = new double[opts.length];
        double currProg = startFrac;
        double midFrac = startFrac + (maxFrac - startFrac) * 0.95;
        List toProcess = this.listOfProps(genome, overID, newLinks);
        int linkCount = toProcess.size();
        if (monitor != null) {
            double progFrac = midFrac - startFrac;
            for (int i = 0; i < opts.length; ++i) {
                perLink[i] = linkCount > 0 ? progFrac * opt.relativeDifficulty(i, allowReroutes) / ((double)opts.length * (double)linkCount * (double)rounds) : progFrac;
            }
        }
        for (int j = 0; j < rounds; ++j) {
            for (int i = 0; i < opts.length; ++i) {
                for (int k = 0; k < linkCount; ++k) {
                    boolean keepGoing;
                    LinkProperties lp = (LinkProperties)toProcess.get(k);
                    double nextProg = currProg + perLink[i];
                    opt.optimizeLinks(i, lp, grid, genome, this, frc, oso, overID, pinnedPoints, currProg, nextProg, monitor);
                    currProg = nextProg;
                    if (monitor == null || (keepGoing = monitor.updateProgress((int)(currProg * 100.0)))) continue;
                    throw new AsynchExitRequestException();
                }
            }
        }
        this.dropUselessCorners(genome, frc, oso, overID, midFrac, maxFrac, monitor);
    }

    public PropChange setGroupProperties(String itemId, GroupProperties props) {
        PropChange retval = new PropChange();
        retval.grOrig = null;
        retval.grNewProps = props;
        retval.layoutKey = this.name_;
        this.groupProps_.put(itemId, props);
        return retval;
    }

    public PropChange removeGroupProperties(String itemId) {
        PropChange retval = new PropChange();
        retval.grOrig = (GroupProperties)this.groupProps_.remove(itemId);
        retval.grNewProps = null;
        retval.layoutKey = this.name_;
        return retval;
    }

    public PropChange setNoteProperties(String itemId, NoteProperties props) {
        PropChange retval = new PropChange();
        retval.ntOrig = null;
        retval.ntNewProps = props;
        retval.layoutKey = this.name_;
        this.noteProps_.put(itemId, props);
        return retval;
    }

    public PropChange[] mapNoteProperties(Map keyMap, boolean doAdd) {
        ArrayList<PropChange> pcs = new ArrayList<PropChange>();
        Iterator kit = keyMap.keySet().iterator();
        while (kit.hasNext()) {
            String oldID = (String)kit.next();
            String newID = (String)keyMap.get(oldID);
            NoteProperties oldProps = (NoteProperties)this.noteProps_.get(oldID);
            NoteProperties newProps = new NoteProperties(oldProps, newID);
            PropChange pc = new PropChange();
            if (doAdd) {
                pc.ntOrig = null;
                pc.ntNewProps = (NoteProperties)newProps.clone();
                pc.layoutKey = this.name_;
                this.noteProps_.put(newID, newProps);
            } else {
                pc.ntOrig = (NoteProperties)oldProps.clone();
                pc.ntNewProps = (NoteProperties)newProps.clone();
                pc.layoutKey = this.name_;
                this.noteProps_.remove(oldID);
                this.noteProps_.put(newID, newProps);
            }
            pcs.add(pc);
        }
        PropChange[] retval = new PropChange[pcs.size()];
        pcs.toArray(retval);
        return retval;
    }

    public PropChange[] mapOverlayProperties(Map ovrIDMap, Map modIDMap, Map modLinkIDMap, boolean doAdd) {
        ArrayList<PropChange> pcs = new ArrayList<PropChange>();
        Iterator oit = ovrIDMap.keySet().iterator();
        while (oit.hasNext()) {
            String oldID = (String)oit.next();
            String newID = (String)ovrIDMap.get(oldID);
            NetOverlayProperties oldProps = (NetOverlayProperties)this.ovrProps_.get(oldID);
            NetOverlayProperties newProps = new NetOverlayProperties(oldProps, newID, modIDMap, modLinkIDMap, false);
            PropChange pc = new PropChange();
            if (doAdd) {
                pc.nopOrig = null;
                pc.nopNew = (NetOverlayProperties)newProps.clone();
                pc.layoutKey = this.name_;
                this.ovrProps_.put(newID, newProps);
            } else {
                pc.nopOrig = (NetOverlayProperties)oldProps.clone();
                pc.nopNew = (NetOverlayProperties)newProps.clone();
                pc.layoutKey = this.name_;
                this.ovrProps_.remove(oldID);
                this.ovrProps_.put(newID, newProps);
            }
            pcs.add(pc);
        }
        PropChange[] retval = new PropChange[pcs.size()];
        pcs.toArray(retval);
        return retval;
    }

    public PropChange removeNoteProperties(String itemId) {
        PropChange retval = new PropChange();
        retval.ntOrig = (NoteProperties)this.noteProps_.get(itemId);
        retval.layoutKey = this.name_;
        retval.ntNewProps = null;
        this.noteProps_.remove(itemId);
        return retval;
    }

    public Set getNotePropertiesKeys() {
        return this.noteProps_.keySet();
    }

    public PropChange setDataLocation(String key, Point2D loc) {
        Point2D currLoc = this.getDataLocation(key);
        PropChange retval = new PropChange();
        retval.dLocKey = key;
        retval.dLocOrig = currLoc != null ? (Point2D)currLoc.clone() : null;
        retval.layoutKey = this.name_;
        Point2D newLoc = (Point2D)loc.clone();
        this.dataProps_.put(key, newLoc);
        retval.dLocNew = (Point2D)newLoc.clone();
        return retval;
    }

    public Point2D getDataLocation(String key) {
        return (Point2D)this.dataProps_.get(key);
    }

    public void setLayoutType(int layout) {
        this.layout_ = layout;
    }

    public NodeProperties getNodeProperties(String itemId) {
        return (NodeProperties)this.nodeProps_.get(itemId);
    }

    public BusProperties getLinkProperties(String itemId) {
        return (BusProperties)this.linkProps_.get(itemId);
    }

    public GroupProperties getGroupProperties(String groupId) {
        return (GroupProperties)this.groupProps_.get(groupId);
    }

    public NetOverlayProperties getNetOverlayProperties(String ovrId) {
        return (NetOverlayProperties)this.ovrProps_.get(ovrId);
    }

    public PropChange setNetOverlayProperties(String itemId, NetOverlayProperties props) {
        PropChange retval = new PropChange();
        retval.nopOrig = null;
        retval.nopNew = (NetOverlayProperties)props.clone();
        retval.layoutKey = this.name_;
        this.ovrProps_.put(itemId, props);
        return retval;
    }

    public PropChange replaceNetOverlayProperties(String itemId, NetOverlayProperties props) {
        PropChange retval = new PropChange();
        retval.nopOrig = (NetOverlayProperties)((NetOverlayProperties)this.ovrProps_.get(itemId)).clone();
        retval.nopNew = (NetOverlayProperties)props.clone();
        retval.layoutKey = this.name_;
        this.ovrProps_.put(itemId, props);
        return retval;
    }

    public PropChange removeNetOverlayProperties(String itemId) {
        PropChange retval = new PropChange();
        retval.nopOrig = (NetOverlayProperties)((NetOverlayProperties)this.ovrProps_.remove(itemId)).clone();
        retval.nopNew = null;
        retval.layoutKey = this.name_;
        return retval;
    }

    public void overlayChangeUndo(PropChange undo) {
        if (undo.nopOrig != null && undo.nopNew != null) {
            this.ovrProps_.put(undo.nopOrig.getReference(), undo.nopOrig.clone());
        } else if (undo.nopNew != null) {
            this.ovrProps_.remove(undo.nopNew.getReference());
        } else if (undo.nopOrig != null) {
            this.ovrProps_.put(undo.nopOrig.getReference(), undo.nopOrig.clone());
        } else {
            throw new IllegalArgumentException();
        }
        if (undo.droppedTreeID != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(undo.droppedTreeID);
        }
    }

    public void overlayChangeRedo(PropChange redo) {
        if (redo.nopOrig != null && redo.nopNew != null) {
            this.ovrProps_.put(redo.nopNew.getReference(), redo.nopNew.clone());
        } else if (redo.nopNew != null) {
            this.ovrProps_.put(redo.nopNew.getReference(), redo.nopNew.clone());
        } else if (redo.nopOrig != null) {
            this.ovrProps_.remove(redo.nopOrig.getReference());
        } else {
            throw new IllegalArgumentException();
        }
        if (redo.droppedTreeID != null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(redo.droppedTreeID);
        }
    }

    public NetModuleLinkageProperties getNetModuleLinkagePropertiesFromTreeID(String treeId, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeId);
        return nmlp;
    }

    public PropChange setNetModuleLinkageProperties(String treeId, NetModuleLinkageProperties props, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.nmlpOrig = null;
        retval.nmlpNew = (NetModuleLinkageProperties)props.clone();
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.setNetModuleLinkageProperties(treeId, props);
        return retval;
    }

    public PropChange replaceNetModuleLinkageProperties(String treeId, NetModuleLinkageProperties props, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeId);
        PropChange retval = new PropChange();
        retval.nmlpOrig = (NetModuleLinkageProperties)nmlp.clone();
        retval.nmlpNew = (NetModuleLinkageProperties)props.clone();
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.setNetModuleLinkageProperties(treeId, props);
        return retval;
    }

    public PropChange removeNetModuleLinkageProperties(String linkID, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        retval.nopOrig = (NetOverlayProperties)nop.clone();
        retval.droppedTreeID = nop.removeNetModuleLinkageProperties(linkID);
        retval.nopNew = (NetOverlayProperties)nop.clone();
        return retval;
    }

    public PropChange tieNetModuleLinkToProperties(String linkId, String treeId, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.nmlpTieLinkIDOrig = linkId;
        retval.nmlpTieTreeIDOrig = nop.getNetModuleLinkagePropertiesID(linkId);
        retval.nmlpTieLinkIDNew = linkId;
        retval.nmlpTieTreeIDNew = treeId;
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.tieNetModuleLinkagePropertiesForLink(linkId, treeId);
        return retval;
    }

    public PropChange mergeNewModuleLinkToTreeAtSegment(NetModuleLinkageProperties newNmlp, String treeID, String linkId, String ovrRef, LinkSegmentID sid, FontRenderContext frc) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        NetModuleLinkageProperties currNmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
        this.undoPreProcess(retval, currNmlp, ovrRef);
        currNmlp.mergeSingleToTreeAtSegment(newNmlp, this.getGenomeTarget(), this, frc, sid);
        retval.nmlpTieLinkIDOrig = linkId;
        retval.nmlpTieTreeIDOrig = nop.getNetModuleLinkagePropertiesID(linkId);
        retval.nmlpTieLinkIDNew = linkId;
        retval.nmlpTieTreeIDNew = treeID;
        nop.tieNetModuleLinkagePropertiesForLink(linkId, treeID);
        this.undoPostProcess(retval, currNmlp, ovrRef);
        return retval;
    }

    public PropChange setNetModuleProperties(String itemId, NetModuleProperties props, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.nmpOrig = null;
        retval.nmpNew = (NetModuleProperties)props.clone();
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.setNetModuleProperties(itemId, props);
        return retval;
    }

    public PropChange replaceNetModuleProperties(String itemId, NetModuleProperties props, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.nmpOrig = (NetModuleProperties)nop.getNetModuleProperties(itemId).clone();
        retval.nmpNew = (NetModuleProperties)props.clone();
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.setNetModuleProperties(itemId, props);
        return retval;
    }

    public PropChange removeNetModuleProperties(String itemId, String ovrRef) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrRef);
        PropChange retval = new PropChange();
        retval.nmpOrig = (NetModuleProperties)nop.getNetModuleProperties(itemId).clone();
        retval.nmpNew = null;
        retval.layoutKey = this.name_;
        retval.nopRef = ovrRef;
        nop.removeNetModuleProperties(itemId);
        return retval;
    }

    public PropChange sizeCoreToRegionBounds(String genomeKey, String ovrKey, String modKey, FontRenderContext frc) {
        Genome genome;
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        if (nmp.getType() != 0) {
            return null;
        }
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        if (!modProps.hasOneShape()) {
            throw new IllegalStateException();
        }
        Rectangle2D.Double outerRect = new Rectangle2D.Double();
        Database db = Database.getDB();
        Genome useGenome = genome = db.getGenome(genomeKey);
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        Set useGroups = db.getOverlayOwnerFromGenomeKey(genomeKey).getGroupsForOverlayRendering();
        modProps.getRenderer().getModuleShapes(genome, useGenome, useGroups, this, ovrKey, modKey, frc, outerRect);
        Rectangle2D oldRect = (Rectangle2D)modProps.getShapeIterator().next();
        modProps.replaceShape(oldRect, outerRect);
        PropChange pc = this.replaceNetModuleProperties(modKey, modProps, ovrKey);
        return pc;
    }

    public PropChange sizeCoreToGivenBounds(String genomeKey, String ovrKey, String modKey, Rectangle2D newRect) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        if (nmp.getType() != 0) {
            return null;
        }
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        if (!modProps.hasOneShape()) {
            throw new IllegalStateException();
        }
        Rectangle2D oldRect = (Rectangle2D)modProps.getShapeIterator().next();
        Point2D oldLabelLoc = modProps.getNameLoc();
        if (oldLabelLoc != null) {
            Point2D newLabelLoc;
            Point2D[] points = new Point2D[]{new Point2D.Double(oldRect.getMinX(), oldRect.getMinY()), new Point2D.Double(oldRect.getMaxX(), oldRect.getMinY()), new Point2D.Double(oldRect.getMaxX(), oldRect.getMaxY())};
            double[] weights = new double[3];
            boolean spans = AffineCombination.getWeights(oldLabelLoc, points, weights);
            if (spans) {
                ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
                pointList.add(new Point2D.Double(newRect.getMinX(), newRect.getMinY()));
                pointList.add(new Point2D.Double(newRect.getMaxX(), newRect.getMinY()));
                pointList.add(new Point2D.Double(newRect.getMaxX(), newRect.getMaxY()));
                newLabelLoc = AffineCombination.combination(pointList, weights, 10.0);
            } else {
                newLabelLoc = (Point2D)oldLabelLoc.clone();
            }
            modProps.setNameLocation(newLabelLoc);
        }
        modProps.replaceShape(oldRect, newRect);
        PropChange pc = this.replaceNetModuleProperties(modKey, modProps, ovrKey);
        return pc;
    }

    public PropChange[] shiftModLinksToNewPositions(String genomeKey, String ovrKey, Map mappedPositions, boolean forceToGrid) {
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrKey);
        ArrayList changes = new ArrayList();
        Iterator trit = nop.getNetModuleLinkagePropertiesKeys();
        while (trit.hasNext()) {
            String treeID = (String)trit.next();
            PropChange retval = new PropChange();
            NetModuleLinkageProperties currNmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
            this.undoPreProcess(retval, currNmlp, ovrKey);
            currNmlp.shiftPerMap(mappedPositions, forceToGrid);
            this.undoPostProcess(retval, currNmlp, ovrKey);
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public boolean coreDefDoesNotMatchVisible(String genomeKey, String ovrKey, String modKey, FontRenderContext frc) {
        Genome genome;
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        if (nmp.getType() != 0) {
            return true;
        }
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        if (!modProps.hasOneShape()) {
            throw new IllegalStateException();
        }
        Rectangle2D.Double outerRect = new Rectangle2D.Double();
        Database db = Database.getDB();
        Genome useGenome = genome = db.getGenome(genomeKey);
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        Set useGroups = db.getOverlayOwnerFromGenomeKey(genomeKey).getGroupsForOverlayRendering();
        modProps.getRenderer().getModuleShapes(genome, useGenome, useGroups, this, ovrKey, modKey, frc, outerRect);
        Rectangle2D oldRect = (Rectangle2D)modProps.getShapeIterator().next();
        return !oldRect.equals(outerRect);
    }

    public PropChange[] moveNetModuleName(String genomeKey, Intersection modIntersect, String ovrKey, FontRenderContext frc, double dx, double dy) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        String modKey = modIntersect.getObjectID();
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        modProps.moveName(dx, dy);
        PropChange pc = this.replaceNetModuleProperties(modKey, modProps, ovrKey);
        PropChange[] retval = new PropChange[]{pc};
        return retval;
    }

    private void rigidPadFixes(String nodeID, double dx, double dy, PadNeedsForLayout padReqs) {
        if (padReqs == null) {
            return;
        }
        Database db = Database.getDB();
        Vector2D moveVec = new Vector2D(dx, dy);
        Iterator kit = padReqs.keyIterator();
        while (kit.hasNext()) {
            NetOverlayOwner noo;
            NetworkOverlay no;
            NetModule mod;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)kit.next();
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
            if (nmp.getType() != 2 && nmp.getType() != 1 || !(mod = (no = (noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey)).getNetworkOverlay(fullKey.ovrKey)).getModule(fullKey.modKey)).isAMember(nodeID)) continue;
            NetModuleLinkPadRequirements lpreq = padReqs.getPadRequire(fullKey);
            Iterator pnpit = lpreq.linkPadInfo.keySet().iterator();
            while (pnpit.hasNext()) {
                PointNoPoint pt = (PointNoPoint)pnpit.next();
                NetModuleFree.LinkPad lp = (NetModuleFree.LinkPad)lpreq.linkPadInfo.get(pt);
                if (!nodeID.equals(lp.nodeID)) continue;
                Vector2D prevVec = (Vector2D)lpreq.rigidMoves.get(pt);
                if (prevVec != null) {
                    Vector2D sumVec = prevVec.add(moveVec);
                    lpreq.rigidMoves.put(pt, sumVec);
                    continue;
                }
                lpreq.rigidMoves.put(pt, moveVec);
            }
        }
    }

    public PropChange[] moveNetModule(String genomeKey, Intersection modIntersect, String ovrKey, FontRenderContext frc, double dx, double dy, PadNeedsForLayout padReqs) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        String nmpKey = modIntersect.getObjectID();
        NetModuleProperties nmp = noProps.getNetModuleProperties(nmpKey);
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        NetModuleFree.IntersectionExtraInfo iexi = (NetModuleFree.IntersectionExtraInfo)modIntersect.getSubID();
        NetOverlayOwner noo = Database.getDB().getOverlayOwnerFromGenomeKey(genomeKey);
        int ownerMode = noo.overlayModeForOwner();
        NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerMode, noo.getID(), ovrKey, nmpKey);
        NetModuleLinkPadRequirements lpreq = padReqs.getPadRequire(fullKey);
        HashSet padNeeds = new HashSet(lpreq.linkPadInfo.keySet());
        lpreq.rigidMoves = modProps.moveShape(iexi, dx, dy, padNeeds);
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        changes.add(this.replaceNetModuleProperties(nmpKey, modProps, ovrKey));
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public NetModuleLinkPadRequirements getCurrentNetModuleLinkPadState(NetModule.FullModuleKey fullKey, NetModuleLinkPadRequirements needPads, FontRenderContext frc) {
        NetModuleLinkPadRequirements currPads = new NetModuleLinkPadRequirements();
        NetOverlayProperties noProps = this.getNetOverlayProperties(fullKey.ovrKey);
        HashMap<PointNoPoint, PointNoPoint> oldToNew = new HashMap<PointNoPoint, PointNoPoint>();
        Iterator tidit = needPads.treeIDToStarts.keySet().iterator();
        while (tidit.hasNext()) {
            String treeID = (String)tidit.next();
            PointNoPoint neededPnp = (PointNoPoint)needPads.treeIDToStarts.get(treeID);
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            if (nmlp == null) continue;
            PointNoPoint currPnp = (PointNoPoint)neededPnp.clone();
            currPnp.point = nmlp.getSourceStart(0.0);
            currPads.treeIDToStarts.put(treeID, currPnp);
            oldToNew.put(neededPnp, currPnp);
        }
        Iterator lidit = needPads.linkIDToEnds.keySet().iterator();
        while (lidit.hasNext()) {
            String linkID = (String)lidit.next();
            PointNoPoint neededPnp = (PointNoPoint)needPads.linkIDToEnds.get(linkID);
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkageProperties(linkID);
            if (nmlp == null) continue;
            PointNoPoint currPnp = (PointNoPoint)neededPnp.clone();
            currPnp.point = nmlp.getTargetEnd(linkID, 0.0);
            if (neededPnp.noPoint != null) {
                currPnp.noPoint = nmlp.getSourceStart(0.0);
            }
            currPads.linkIDToEnds.put(linkID, currPnp);
            oldToNew.put(neededPnp, currPnp);
        }
        Iterator lpit = needPads.linkPadInfo.keySet().iterator();
        while (lpit.hasNext()) {
            PointNoPoint nextPoint = (PointNoPoint)lpit.next();
            NetModuleFree.LinkPad padData = (NetModuleFree.LinkPad)needPads.linkPadInfo.get(nextPoint);
            PointNoPoint currNextPoint = (PointNoPoint)oldToNew.get(nextPoint);
            if (currNextPoint == null) continue;
            NetModuleFree.LinkPad currPadData = (NetModuleFree.LinkPad)padData.clone();
            currPadData.point = (Point2D)currNextPoint.point.clone();
            currPads.linkPadInfo.put(nextPoint, currPadData);
        }
        return currPads;
    }

    public boolean netModuleLinksPadCollisions(String ovrKey) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        HashSet<Point2D> globalPoints = new HashSet<Point2D>();
        Iterator tidit = noProps.getNetModuleLinkagePropertiesKeys();
        while (tidit.hasNext()) {
            String treeID = (String)tidit.next();
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            Point2D ss = nmlp.getSourceStart(0.0);
            if (globalPoints.contains(ss)) {
                return true;
            }
            globalPoints.add(ss);
            Iterator drit = nmlp.getDrops();
            while (drit.hasNext()) {
                NetModuleBusDrop drop = (NetModuleBusDrop)drit.next();
                if (drop.getDropType() != 1) continue;
                Point2D de = drop.getEnd(0.0);
                if (globalPoints.contains(de)) {
                    return true;
                }
                globalPoints.add(de);
            }
        }
        return false;
    }

    public NetModuleLinkPadRequirements findNetModuleLinkPadRequirements(String ownerKey, String ovrKey, String modKey, FontRenderContext frc) {
        NetModuleLinkPadRequirements retval = new NetModuleLinkPadRequirements();
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        Database db = Database.getDB();
        NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(ownerKey);
        NetworkOverlay no = noo.getNetworkOverlay(ovrKey);
        HashSet inLinks = new HashSet();
        HashSet outLinks = new HashSet();
        no.getNetModuleLinkagesForModule(modKey, inLinks, outLinks);
        if (inLinks.isEmpty() && outLinks.isEmpty()) {
            return retval;
        }
        retval.feedBacks = new HashSet(inLinks);
        retval.feedBacks.retainAll(outLinks);
        HashSet<String> treeIDs = new HashSet<String>();
        Iterator olit = outLinks.iterator();
        while (olit.hasNext()) {
            String linkID = (String)olit.next();
            treeIDs.add(noProps.getNetModuleLinkagePropertiesID(linkID));
        }
        Iterator tidit = treeIDs.iterator();
        while (tidit.hasNext()) {
            String treeID = (String)tidit.next();
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            PointNoPoint pnp = new PointNoPoint(nmlp.getSourceStart(0.0), null, null);
            retval.treeIDToStarts.put(treeID, pnp);
        }
        Iterator ilit = inLinks.iterator();
        while (ilit.hasNext()) {
            String linkID = (String)ilit.next();
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkageProperties(linkID);
            Point2D te = nmlp.getTargetEnd(linkID, 0.0);
            Point2D noPoint = null;
            if (retval.feedBacks.contains(linkID)) {
                noPoint = nmlp.getSourceStart(0.0);
            }
            PointNoPoint pnp = new PointNoPoint(te, noPoint, null);
            retval.linkIDToEnds.put(linkID, pnp);
        }
        NetModule mod = no.getModule(modKey);
        FontRenderContext fixedFrc = new FontRenderContext(null, true, true);
        Genome useGenome = db.getGenome(this.targetGenome_);
        DynamicInstanceProxy dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
        Set useGroups = noo.getGroupsForOverlayRendering();
        Set padsForModule = nmp.getRenderer().padsForModule(useGenome, dip, useGroups, mod, this, ovrKey, nmp, fixedFrc);
        HashMap<Point2D, ArrayList<NetModuleFree.LinkPad>> ptToPadLists = new HashMap<Point2D, ArrayList<NetModuleFree.LinkPad>>();
        Iterator pfmit = padsForModule.iterator();
        while (pfmit.hasNext()) {
            NetModuleFree.LinkPad padData = (NetModuleFree.LinkPad)pfmit.next();
            ArrayList<NetModuleFree.LinkPad> padList = (ArrayList<NetModuleFree.LinkPad>)ptToPadLists.get(padData.point);
            if (padList == null) {
                padList = new ArrayList<NetModuleFree.LinkPad>();
                ptToPadLists.put(padData.point, padList);
            }
            padList.add(padData);
        }
        ArrayList allPoints = new ArrayList();
        allPoints.addAll(retval.treeIDToStarts.values());
        allPoints.addAll(retval.linkIDToEnds.values());
        Iterator apit = allPoints.iterator();
        while (apit.hasNext()) {
            NetModuleFree.LinkPad padData;
            PointNoPoint nextPoint = (PointNoPoint)apit.next();
            ArrayList padList = (ArrayList)ptToPadLists.get(nextPoint.point);
            if (padList == null || padList.isEmpty()) {
                padData = this.emergencyClosestExistingPad(ptToPadLists, nextPoint.point);
            } else {
                padData = (NetModuleFree.LinkPad)padList.get(0);
                if (padList.size() > 1) {
                    padList.remove(0);
                }
            }
            if (padData == null) continue;
            if (padData.nodeID != null) {
                nextPoint.nodeID = padData.nodeID;
            }
            retval.linkPadInfo.put(nextPoint, padData);
        }
        return retval;
    }

    private NetModuleFree.LinkPad emergencyClosestExistingPad(Map ptToPadLists, Point2D myPoint) {
        double minDist = Double.POSITIVE_INFINITY;
        ArrayList minList = null;
        Point2D minPoint = null;
        Iterator it = ptToPadLists.keySet().iterator();
        while (it.hasNext()) {
            Point2D key = (Point2D)it.next();
            double distSq = key.distanceSq(myPoint);
            if (!(distSq < minDist)) continue;
            minDist = distSq;
            minList = (ArrayList)ptToPadLists.get(key);
            minPoint = key;
        }
        if (minPoint == null) {
            return null;
        }
        NetModuleFree.LinkPad padData = (NetModuleFree.LinkPad)minList.get(0);
        padData = (NetModuleFree.LinkPad)padData.clone();
        padData.point = (Point2D)myPoint.clone();
        if (minList.size() > 1) {
            minList.remove(0);
        }
        return padData;
    }

    public PadNeedsForLayout findAllNetModuleLinkPadRequirements(FontRenderContext frc, Map layoutToFullKeys) {
        OverlayKeySet myKeys = (OverlayKeySet)layoutToFullKeys.get(this.name_);
        HashMap<NetModule.FullModuleKey, NetModuleLinkPadRequirements> retval = new HashMap<NetModule.FullModuleKey, NetModuleLinkPadRequirements>();
        if (myKeys != null) {
            Iterator mkit = myKeys.iterator();
            while (mkit.hasNext()) {
                NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
                NetModuleLinkPadRequirements needPads = this.findNetModuleLinkPadRequirements(fullKey.ownerKey, fullKey.ovrKey, fullKey.modKey, frc);
                retval.put(fullKey, needPads);
            }
        }
        return new PadNeedsForLayout(retval);
    }

    public Map stashMemberOnlyGeometry(FontRenderContext frc, Map layoutToFullKeys) {
        OverlayKeySet myKeys = (OverlayKeySet)layoutToFullKeys.get(this.name_);
        HashMap<NetModule.FullModuleKey, Map> retval = new HashMap<NetModule.FullModuleKey, Map>();
        if (myKeys != null) {
            Iterator mkit = myKeys.iterator();
            while (mkit.hasNext()) {
                NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
                NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
                NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
                if (nmp.getType() != 2) continue;
                Map memberOnlyGeom = this.memberOnlyGeom(fullKey.ownerKey, fullKey.ovrKey, fullKey.modKey, frc);
                retval.put(fullKey, memberOnlyGeom);
            }
        }
        return retval;
    }

    private Map memberOnlyGeom(String ownerKey, String ovrKey, String modKey, FontRenderContext frc) {
        Database db = Database.getDB();
        NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(ownerKey);
        NetworkOverlay no = noo.getNetworkOverlay(ovrKey);
        NetModule nMod = no.getModule(modKey);
        HashSet<String> nodes = new HashSet<String>();
        Iterator memit = nMod.getMemberIterator();
        while (memit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)memit.next();
            nodes.add(nmm.getID());
        }
        Genome rootInstance = db.getGenome(this.targetGenome_);
        Map rects = NodeBounder.nodeRects(nodes, rootInstance, this, frc, 10);
        return rects;
    }

    public PadNeedsForLayout findAllNetModuleLinkPadRequirementsForOverlay(FontRenderContext frc, String ownerKey, String ovrKey) {
        if (ovrKey == null) {
            return null;
        }
        HashMap<NetModule.FullModuleKey, NetModuleLinkPadRequirements> retval = new HashMap<NetModule.FullModuleKey, NetModuleLinkPadRequirements>();
        NetOverlayOwner noo = Database.getDB().getOverlayOwnerWithOwnerKey(ownerKey);
        int ownerType = noo.overlayModeForOwner();
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrKey);
        Iterator nmpkit = nop.getNetModulePropertiesKeys();
        while (nmpkit.hasNext()) {
            String modKey = (String)nmpkit.next();
            NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerType, ownerKey, ovrKey, modKey);
            NetModuleLinkPadRequirements needPads = this.findNetModuleLinkPadRequirements(ownerKey, ovrKey, fullKey.modKey, frc);
            retval.put(fullKey, needPads);
        }
        return new PadNeedsForLayout(retval);
    }

    public PadNeedsForLayout findAllNetModuleLinkPadRequirements(FontRenderContext frc) {
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        return this.findAllNetModuleLinkPadRequirements(frc, allKeys);
    }

    public Set getAllOverlayKeys() {
        return new HashSet(this.ovrProps_.keySet());
    }

    public Map orphansOnlyForAll(boolean val) {
        Boolean valObj = new Boolean(val);
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String key = (String)opit.next();
            retval.put(key, valObj);
        }
        return retval;
    }

    public PropChange[] repairAllNetModuleLinkPadRequirements(FontRenderContext frc, PadNeedsForLayout needsForLayout, Map orphansOnlyPerOverlay) {
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        Iterator mkit = needsForLayout.keyIterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetModuleLinkPadRequirements padNeeds = needsForLayout.getPadRequire(fullKey);
            Boolean orphansOnlyObj = (Boolean)orphansOnlyPerOverlay.get(fullKey.ovrKey);
            PropChange[] lpc = this.fixNetModuleLinkPads(fullKey, padNeeds, frc, orphansOnlyObj);
            changes.addAll(Arrays.asList(lpc));
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange[] repairAllEmptyMemberOnlyNetModules(Map retainedRectsPerLayout) {
        Database db = Database.getDB();
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        Map keysToRects = (Map)retainedRectsPerLayout.get(this.name_);
        if (keysToRects != null) {
            Iterator mkit = keysToRects.keySet().iterator();
            while (mkit.hasNext()) {
                NetOverlayOwner noo;
                NetworkOverlay no;
                NetModule nMod;
                NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
                NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
                NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
                if (nmp == null || nmp.getType() != 2 || (nMod = (no = (noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey)).getNetworkOverlay(fullKey.ovrKey)).getModule(fullKey.modKey)).getMemberCount() != 0) continue;
                NetModuleProperties changedProps = (NetModuleProperties)nmp.clone();
                Map eachRect = (Map)keysToRects.get(fullKey);
                changedProps.convertEmptyMemberOnly(eachRect);
                PropChange lpc = this.replaceNetModuleProperties(fullKey.modKey, changedProps, fullKey.ovrKey);
                if (lpc == null) continue;
                changes.add(lpc);
            }
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange[] fixNetModuleLinkPads(NetModule.FullModuleKey fullKey, NetModuleLinkPadRequirements padNeeds, FontRenderContext frc, boolean orphansOnly) {
        NetModuleLinkageProperties modLProps;
        NetOverlayProperties noProps = this.getNetOverlayProperties(fullKey.ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(fullKey.modKey);
        if (nmp == null) {
            return new PropChange[0];
        }
        if (padNeeds.treeIDToStarts.isEmpty() && padNeeds.linkIDToEnds.isEmpty()) {
            return new PropChange[0];
        }
        Database db = Database.getDB();
        NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
        DynamicInstanceProxy dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
        NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
        NetModule mod = no.getModule(fullKey.modKey);
        HashMap currState = null;
        if (orphansOnly) {
            NetModuleLinkPadRequirements currReq = this.getCurrentNetModuleLinkPadState(fullKey, padNeeds, frc);
            currState = currReq.linkPadInfo;
        }
        Genome useGenome = db.getGenome(this.targetGenome_);
        Set useGroups = noo.getGroupsForOverlayRendering();
        Map bestFits = nmp.getRenderer().closestRemainingPads(useGenome, dip, useGroups, mod, this, fullKey.ovrKey, nmp, frc, padNeeds.rigidMoves, padNeeds.linkPadInfo, currState, orphansOnly);
        HashMap<Point2D, ShiftAndSide> newPadShifts = new HashMap<Point2D, ShiftAndSide>();
        Iterator lpkit = padNeeds.linkPadInfo.keySet().iterator();
        while (lpkit.hasNext()) {
            PointNoPoint oldPNP = (PointNoPoint)lpkit.next();
            NetModuleFree.LinkPad bestFit = (NetModuleFree.LinkPad)bestFits.get(oldPNP);
            if (bestFit == null) {
                System.err.println("Could not find a new module link pad for " + oldPNP);
                continue;
            }
            Vector2D bestFitShift = new Vector2D(oldPNP.point, bestFit.point);
            if (bestFitShift.isZero()) continue;
            newPadShifts.put(oldPNP.point, new ShiftAndSide(bestFitShift, bestFit.getNormal().scaled(-1.0)));
        }
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        Iterator tidit = padNeeds.treeIDToStarts.keySet().iterator();
        while (tidit.hasNext()) {
            String treeID = (String)tidit.next();
            PointNoPoint oldStart = (PointNoPoint)padNeeds.treeIDToStarts.get(treeID);
            ShiftAndSide shift = (ShiftAndSide)newPadShifts.get(oldStart.point);
            if (shift == null) continue;
            NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
            modLProps = (NetModuleLinkageProperties)nmlp.clone();
            Point2D newStart = shift.shift.add(oldStart.point);
            modLProps.setSourceStart(newStart, shift.toSide);
            changes.add(this.replaceNetModuleLinkageProperties(treeID, modLProps, fullKey.ovrKey));
        }
        HashMap<String, NetModuleLinkageProperties> modTrees = new HashMap<String, NetModuleLinkageProperties>();
        Iterator lidit = padNeeds.linkIDToEnds.keySet().iterator();
        while (lidit.hasNext()) {
            String linkID = (String)lidit.next();
            PointNoPoint oldEnd = (PointNoPoint)padNeeds.linkIDToEnds.get(linkID);
            ShiftAndSide shift = (ShiftAndSide)newPadShifts.get(oldEnd.point);
            if (shift == null) continue;
            String treeID = noProps.getNetModuleLinkagePropertiesID(linkID);
            NetModuleLinkageProperties modLProps2 = (NetModuleLinkageProperties)modTrees.get(treeID);
            if (modLProps2 == null) {
                NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkageProperties(linkID);
                modLProps2 = (NetModuleLinkageProperties)nmlp.clone();
                modTrees.put(treeID, modLProps2);
            }
            Point2D newEnd = shift.shift.add(oldEnd.point);
            modLProps2.setTargetEnd(linkID, newEnd, shift.toSide);
        }
        Iterator mtkit = modTrees.keySet().iterator();
        while (mtkit.hasNext()) {
            String treeID = (String)mtkit.next();
            modLProps = (NetModuleLinkageProperties)modTrees.get(treeID);
            changes.add(this.replaceNetModuleLinkageProperties(treeID, modLProps, fullKey.ovrKey));
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange moveNetModuleLinks(Intersection modIntersect, String ovrKey, double dx, double dy) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        String treeID = modIntersect.getObjectID();
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
        LinkSegmentID[] segIDs = modIntersect.segmentIDsFromIntersect();
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, nmlp, ovrKey);
        dx = UiUtil.forceToGridValue(dx, 10.0);
        dy = UiUtil.forceToGridValue(dy, 10.0);
        nmlp.moveBusLinkSegments(segIDs, null, dx, dy);
        this.undoPostProcess(retval, nmlp, ovrKey);
        return retval;
    }

    public PropChange changeNetModuleTarget(String ovrKey, String linkID, Point2D newTarget, Vector2D toSide) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkageProperties(linkID);
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, nmlp, ovrKey);
        nmlp.setTargetEnd(linkID, newTarget, toSide);
        this.undoPostProcess(retval, nmlp, ovrKey);
        return retval;
    }

    public PropChange changeNetModuleSource(String ovrKey, String treeID, Point2D newSource, Vector2D toSide) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, nmlp, ovrKey);
        nmlp.setSourceStart(newSource, toSide);
        this.undoPostProcess(retval, nmlp, ovrKey);
        return retval;
    }

    public PropChange[] convertAllModulesToMemberOnly(OverlayKeySet fullKeys, FontRenderContext frc) {
        if (fullKeys == null) {
            return null;
        }
        Database db = Database.getDB();
        HashSet<String> nodeSet = new HashSet<String>();
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        Genome useGenome = db.getGenome(this.targetGenome_);
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            List convert;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
            NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
            NetModule nmod = no.getModule(fullKey.modKey);
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
            nodeSet.clear();
            Iterator memit = nmod.getMemberIterator();
            while (memit.hasNext()) {
                NetModuleMember nmm = (NetModuleMember)memit.next();
                nodeSet.add(nmm.getID());
            }
            if (nmp.getType() == 2 || nodeSet.isEmpty() || (convert = nmp.convertShapes(2, nodeSet, frc, useGenome, this)) == null) continue;
            NetModuleProperties changedProps = (NetModuleProperties)nmp.clone();
            changedProps.replaceTypeAndShapes(2, convert);
            PropChange lpc = this.replaceNetModuleProperties(fullKey.modKey, changedProps, fullKey.ovrKey);
            if (lpc == null) continue;
            changes.add(lpc);
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public Map getModuleShapeParams(OverlayKeySet fullKeys, FontRenderContext frc, Point2D wsCenter) {
        HashMap<NetModule.FullModuleKey, NetModuleShapeFixer.ModuleRelocateInfo> retval = new HashMap<NetModule.FullModuleKey, NetModuleShapeFixer.ModuleRelocateInfo>();
        if (fullKeys == null) {
            return retval;
        }
        NetModuleShapeFixer fixer = new NetModuleShapeFixer();
        Database db = Database.getDB();
        Genome useGenome = db.getGenome(this.targetGenome_);
        Rectangle bounds = this.getLayoutBounds(useGenome, frc, false, false, false, false, false, null, null, null, null);
        Point2D center = bounds == null ? wsCenter : new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetModuleShapeFixer.ModuleRelocateInfo mri = fixer.getModuleRelocInfo(useGenome, this, fullKey, center, frc);
            retval.put(fullKey, mri);
        }
        return retval;
    }

    public PropChange[] shiftModuleShapesPerParams(OverlayKeySet fullKeys, Map relocInfoMap, FontRenderContext frc) {
        if (fullKeys == null) {
            return null;
        }
        NetModuleShapeFixer fixer = new NetModuleShapeFixer();
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        Database db = Database.getDB();
        Genome useGenome = db.getGenome(this.targetGenome_);
        Rectangle bounds = this.getLayoutBounds(useGenome, frc, false, false, false, false, false, null, null, null, null);
        Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            PropChange lpc;
            NetModuleShapeFixer.ModuleRelocateInfo relocInfo;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetModuleProperties changedProps = fixer.shiftModuleShapesPerParams(useGenome, this, fullKey, relocInfo = (NetModuleShapeFixer.ModuleRelocateInfo)relocInfoMap.get(fullKey), frc, center);
            if (changedProps == null || (lpc = this.replaceNetModuleProperties(fullKey.modKey, changedProps, fullKey.ovrKey)) == null) continue;
            changes.add(lpc);
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange[] applySameColorToModuleAndLinks(String overKey, String modKey, String colName, boolean doModule, String skipTree) {
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        NetOverlayProperties nop = this.getNetOverlayProperties(overKey);
        Iterator trit = nop.getNetModuleLinkagePropertiesKeys();
        while (trit.hasNext()) {
            NetModuleLinkageProperties nmlp;
            String treeID = (String)trit.next();
            if (skipTree != null && treeID.equals(skipTree) || !modKey.equals((nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID)).getSourceTag())) continue;
            NetModuleLinkageProperties changedNmlp = (NetModuleLinkageProperties)nmlp.clone();
            changedNmlp.setColor(colName);
            PropChange lpc = this.replaceNetModuleLinkageProperties(treeID, changedNmlp, overKey);
            if (lpc == null) continue;
            changes.add(lpc);
        }
        if (doModule) {
            NetModuleProperties nmp = nop.getNetModuleProperties(modKey);
            NetModuleProperties changedProps = (NetModuleProperties)nmp.clone();
            changedProps.setColorTag(colName);
            PropChange lpc = this.replaceNetModuleProperties(modKey, changedProps, overKey);
            if (lpc != null) {
                changes.add(lpc);
            }
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public Rectangle getLayoutBoundsForNetModules(Genome genome, NetOverlayOwner owner, String ovrKey, TaggedSet modSet, FontRenderContext frc, boolean doModuleLinks) {
        Set linkSet;
        Rectangle linkRect;
        Rectangle retval = null;
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        DynamicInstanceProxy dip = owner.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)owner : null;
        Set useGroups = owner.getGroupsForOverlayRendering();
        NetworkOverlay novr = owner.getNetworkOverlay(ovrKey);
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrKey);
        Iterator mit = novr.getModuleIterator();
        HashSet modKeys = modSet.set;
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String id = mod.getID();
            if (!modKeys.contains(id)) continue;
            NetModuleProperties nmp = nop.getNetModuleProperties(id);
            Rectangle nmBounds = nmp.getRenderer().bounds(useGenome, dip, useGroups, mod, this, ovrKey, frc);
            if (retval == null) {
                retval = nmBounds;
                continue;
            }
            Bounds.tweakBounds(retval, nmBounds);
        }
        if (doModuleLinks && (linkRect = this.getLayoutBoundsForModuleLinks(frc, ovrKey, linkSet = novr.getNetModuleLinkagesBetweenModules(modKeys))) != null) {
            if (retval == null) {
                retval = linkRect;
            } else {
                Bounds.tweakBounds(retval, linkRect);
            }
        }
        if (retval != null) {
            UiUtil.forceToGrid(retval, 10.0);
        }
        return retval;
    }

    public Map getLayoutBoundsForEachNetModule(Genome genome, NetOverlayOwner owner, String ovrKey, FontRenderContext frc) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        DynamicInstanceProxy dip = owner.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)owner : null;
        Set useGroups = owner.getGroupsForOverlayRendering();
        NetworkOverlay novr = owner.getNetworkOverlay(ovrKey);
        NetOverlayProperties nop = this.getNetOverlayProperties(ovrKey);
        Iterator mit = novr.getModuleIterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String id = mod.getID();
            NetModuleProperties nmp = nop.getNetModuleProperties(id);
            Rectangle nmBounds = nmp.getRenderer().bounds(useGenome, dip, useGroups, mod, this, ovrKey, frc);
            UiUtil.forceToGrid(nmBounds, 10.0);
            retval.put(id, nmBounds);
        }
        return retval;
    }

    public Rectangle getLayoutBoundsForAllOverlays(OverlayKeySet allKeys, Genome genome, FontRenderContext frc, boolean doModuleLinks) {
        Rectangle retval = null;
        Database db = Database.getDB();
        if (allKeys != null) {
            Genome useGenome = genome;
            if (genome instanceof GenomeInstance) {
                GenomeInstance gi = (GenomeInstance)genome;
                GenomeInstance rootGI = gi.getVfgParentRoot();
                useGenome = rootGI == null ? gi : rootGI;
            }
            HashSet<String> overKeys = new HashSet<String>();
            Iterator mkit = allKeys.iterator();
            while (mkit.hasNext()) {
                NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
                NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
                DynamicInstanceProxy dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
                Set useGroups = noo.getGroupsForOverlayRendering();
                NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
                overKeys.add(fullKey.ovrKey);
                NetModule mod = no.getModule(fullKey.modKey);
                NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
                NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
                Rectangle nmBounds = nmp.getRenderer().bounds(useGenome, dip, useGroups, mod, this, fullKey.ovrKey, frc);
                if (retval == null) {
                    retval = nmBounds;
                    continue;
                }
                Bounds.tweakBounds(retval, nmBounds);
            }
            if (doModuleLinks) {
                Iterator okit = overKeys.iterator();
                while (okit.hasNext()) {
                    String ovrKey = (String)okit.next();
                    Rectangle linkRect = this.getLayoutBoundsForModuleLinks(frc, ovrKey, null);
                    if (linkRect == null) continue;
                    if (retval == null) {
                        retval = linkRect;
                        continue;
                    }
                    Bounds.tweakBounds(retval, linkRect);
                }
            }
        }
        if (retval != null) {
            UiUtil.forceToGrid(retval, 10.0);
        }
        return retval;
    }

    public Rectangle getLayoutBoundsForModuleLinks(FontRenderContext frc, String overKey, Set linkIDs) {
        Iterator trit;
        Rectangle retval = null;
        NetModuleLinkageFree nmlf = new NetModuleLinkageFree();
        NetOverlayProperties nop = this.getNetOverlayProperties(overKey);
        Iterator iterator = trit = linkIDs == null ? nop.getNetModuleLinkagePropertiesLinkKeys() : linkIDs.iterator();
        while (trit.hasNext()) {
            String linkID = (String)trit.next();
            NetModuleLinkageProperties nmlp = nop.getNetModuleLinkageProperties(linkID);
            Rectangle rect = nmlf.getBoundsForSinglePath(nmlp, linkID, frc);
            if (rect == null) continue;
            if (retval == null) {
                retval = rect;
                continue;
            }
            Bounds.tweakBounds(retval, rect);
        }
        return retval;
    }

    public void netModChangeUndo(PropChange undo) {
        NetOverlayProperties nop = this.getNetOverlayProperties(undo.nopRef);
        if (undo.nmpOrig != null && undo.nmpNew != null) {
            nop.setNetModuleProperties(undo.nmpOrig.getID(), (NetModuleProperties)undo.nmpOrig.clone());
        } else if (undo.nmpNew != null) {
            nop.removeNetModuleProperties(undo.nmpNew.getID());
        } else if (undo.nmpOrig != null) {
            nop.setNetModuleProperties(undo.nmpOrig.getID(), (NetModuleProperties)undo.nmpOrig.clone());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void netModChangeRedo(PropChange redo) {
        NetOverlayProperties nop = this.getNetOverlayProperties(redo.nopRef);
        if (redo.nmpOrig != null && redo.nmpNew != null) {
            nop.setNetModuleProperties(redo.nmpNew.getID(), (NetModuleProperties)redo.nmpNew.clone());
        } else if (redo.nmpNew != null) {
            nop.setNetModuleProperties(redo.nmpNew.getID(), (NetModuleProperties)redo.nmpNew.clone());
        } else if (redo.nmpOrig != null) {
            nop.removeNetModuleProperties(redo.nmpOrig.getID());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void netModLinkChangeUndo(PropChange undo) {
        NetOverlayProperties nop = this.getNetOverlayProperties(undo.nopRef);
        if (undo.nmlpOrig != null && undo.nmlpNew != null) {
            nop.setNetModuleLinkageProperties(undo.nmlpOrig.getID(), (NetModuleLinkageProperties)undo.nmlpOrig.clone());
        } else if (undo.nmlpNew != null) {
            nop.removeNetModuleLinkagePropertiesWithTreeID(undo.nmlpNew.getID());
        } else if (undo.nmlpOrig != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(undo.nmlpOrig.getID());
            nop.setNetModuleLinkageProperties(undo.nmlpOrig.getID(), (NetModuleLinkageProperties)undo.nmlpOrig.clone());
        } else if (undo.nmlpTieLinkIDOrig != null) {
            if (undo.nmlpTieTreeIDOrig == null) {
                nop.untieNetModuleLinkagePropertiesForLink(undo.nmlpTieLinkIDOrig);
            } else {
                nop.tieNetModuleLinkagePropertiesForLink(undo.nmlpTieLinkIDOrig, undo.nmlpTieTreeIDOrig);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void netModLinkChangeRedo(PropChange redo) {
        NetOverlayProperties nop = this.getNetOverlayProperties(redo.nopRef);
        if (redo.nmlpOrig != null && redo.nmlpNew != null) {
            nop.setNetModuleLinkageProperties(redo.nmlpNew.getID(), (NetModuleLinkageProperties)redo.nmlpNew.clone());
        } else if (redo.nmlpNew != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(redo.nmlpNew.getID());
            nop.setNetModuleLinkageProperties(redo.nmlpNew.getID(), (NetModuleLinkageProperties)redo.nmlpNew.clone());
        } else if (redo.nmlpOrig != null) {
            nop.removeNetModuleLinkagePropertiesWithTreeID(redo.nmlpOrig.getID());
        } else if (redo.nmlpTieLinkIDNew != null) {
            nop.tieNetModuleLinkagePropertiesForLink(redo.nmlpTieLinkIDNew, redo.nmlpTieTreeIDNew);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public NoteProperties getNoteProperties(String noteId) {
        return (NoteProperties)this.noteProps_.get(noteId);
    }

    public int getLayoutType() {
        return this.layout_;
    }

    public boolean segmentSynonymousWithStartDrop(String linkId, LinkSegmentID segID, Genome genome) {
        BusProperties bp = this.getLinkProperties(linkId);
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            useGenome = gi.getVfgParent() == null ? gi : gi.getVfgParentRoot();
        }
        Set throughSeg = bp.resolveLinkagesThroughSegment(segID, useGenome);
        Set shared = this.getSharedItems(linkId);
        return ((Object)shared).equals(throughSeg);
    }

    public String segmentSynonymousWithTargetDrop(String linkId, LinkSegmentID segID, Genome genome) {
        Set throughSeg;
        BusProperties bp = this.getLinkProperties(linkId);
        Genome useGenome = genome;
        if (genome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            Genome genome2 = useGenome = gi.getVfgParent() == null ? gi : gi.getVfgParentRoot();
        }
        if ((throughSeg = bp.resolveLinkagesThroughSegment(segID, useGenome)).size() == 1) {
            return (String)throughSeg.iterator().next();
        }
        return null;
    }

    public String segmentSynonymousWithModLinkTargetDrop(String treeID, LinkSegmentID segID, String ovrKey) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
        Set throughSeg = nmlp.resolveLinkagesThroughSegment(segID, null);
        if (throughSeg.size() == 1) {
            return (String)throughSeg.iterator().next();
        }
        return null;
    }

    public Set segmentSynonymousWithModLinkStartDrop(String treeID, LinkSegmentID segID, String ovrKey) {
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(treeID);
        Set throughSeg = nmlp.resolveLinkagesThroughSegment(segID, null);
        HashSet shared = new HashSet(nmlp.getLinkageList());
        return shared.equals(throughSeg) ? shared : null;
    }

    public Set getSharedItems(String itemId) {
        HashSet<String> retval = new HashSet<String>();
        BusProperties lp = this.getLinkProperties(itemId);
        Iterator lpit = this.linkProps_.keySet().iterator();
        while (lpit.hasNext()) {
            String key = (String)lpit.next();
            if (lp != this.getLinkProperties(key)) continue;
            retval.add(key);
        }
        return retval;
    }

    public BusProperties getBusForSource(String itemId) {
        Iterator lpit = this.linkProps_.values().iterator();
        while (lpit.hasNext()) {
            BusProperties bp = (BusProperties)lpit.next();
            String srcID = bp.getSourceTag();
            if (!srcID.equals(itemId)) continue;
            return bp;
        }
        return null;
    }

    public BusProperties getLinkPropertiesForSource(String itemId) {
        return this.getBusForSource(itemId);
    }

    public BusProperties getLinkPropertyForSource(String itemId, int launchPad) {
        Iterator lpit = this.linkProps_.values().iterator();
        Genome genome = this.getGenomeTarget();
        while (lpit.hasNext()) {
            BusProperties bp = (BusProperties)lpit.next();
            String srcID = bp.getSourceTag();
            int srcPad = bp.getLaunchPad(genome, this);
            if (!itemId.equals(srcID) || launchPad != srcPad) continue;
            return bp;
        }
        return null;
    }

    public TopoRepairInfo repairAllTopology(FontRenderContext frc, OverlayStateOracle oso, String overID, BTProgressMonitor monitor, double minFrac, double maxFrac) throws AsynchExitRequestException {
        Genome genome = this.getGenomeTarget();
        List lop = this.listOfProps(genome, overID, null);
        int numLop = lop.size();
        if (numLop == 0) {
            return null;
        }
        double perTree = (maxFrac - minFrac) / (double)numLop;
        double currProg = minFrac;
        TopoRepairInfo tri = null;
        for (int i = 0; i < numLop; ++i) {
            LinkProperties lp = (LinkProperties)lop.get(i);
            PropChange retval = new PropChange();
            this.undoPreProcess(retval, lp, overID);
            double nextProg = currProg + perTree;
            TopoRepairInfo nextTri = this.repairTreeTopologyGuts(lp, frc, genome, oso, overID, monitor, currProg, nextProg);
            currProg = nextProg;
            if (nextTri.haveAChange()) {
                this.undoPostProcess(retval, lp, overID);
                nextTri.addPropChange(retval);
            }
            if (tri == null) {
                tri = nextTri;
                continue;
            }
            tri.merge(nextTri);
        }
        return tri;
    }

    public TopoRepairInfo repairTreeTopology(LinkProperties lp, FontRenderContext frc, OverlayStateOracle oso, String overID, BTProgressMonitor monitor, double minFrac, double maxFrac) throws AsynchExitRequestException {
        Genome genome = this.getGenomeTarget();
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, lp, overID);
        TopoRepairInfo tri = this.repairTreeTopologyGuts(lp, frc, genome, oso, overID, monitor, minFrac, maxFrac);
        if (tri.haveAChange()) {
            this.undoPostProcess(retval, lp, overID);
            tri.addPropChange(retval);
        }
        return tri;
    }

    private TopoRepairInfo repairTreeTopologyGuts(LinkProperties lp, FontRenderContext frc, Genome genome, OverlayStateOracle oso, String overID, BTProgressMonitor monitor, double minFrac, double maxFrac) throws AsynchExitRequestException {
        boolean keepGoing;
        boolean someRepaired;
        double delFrac = maxFrac - minFrac;
        double delFrac3 = delFrac / 3.0;
        boolean dropped = lp.dropAllZeroSegments();
        boolean elim = false;
        LinkOptimizer opt = new LinkOptimizer();
        double frac1 = minFrac + delFrac3;
        elim = opt.eliminateUselessCornersGridless(lp, genome, this, frc, oso, overID, minFrac, frac1, monitor);
        double frac2 = minFrac + 2.0 * delFrac3;
        int repairState = lp.repairLinkTree(genome, this, frc, monitor, frac1, frac2);
        boolean bl = someRepaired = repairState == 1 || repairState == 2;
        if (someRepaired) {
            lp.dropAllZeroSegments();
            opt.eliminateUselessCornersGridless(lp, genome, this, frc, oso, overID, frac2, maxFrac, monitor);
        }
        if (monitor != null && !(keepGoing = monitor.updateProgress((int)(maxFrac * 100.0)))) {
            throw new AsynchExitRequestException();
        }
        return new TopoRepairInfo(dropped, elim, repairState);
    }

    public PropChange relocateSegmentOnTree(LinkProperties lp, LinkSegmentID targID, LinkSegmentID moveID, String ovrKey) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, lp, ovrKey);
        if (!lp.moveSegmentOnTree(moveID, targID)) {
            return null;
        }
        this.undoPostProcess(retval, lp, ovrKey);
        return retval;
    }

    public boolean canRelocateSegmentOnTree(LinkProperties lp, LinkSegmentID moveID) {
        return lp.canRelocateSegmentOnTree(moveID);
    }

    public PropChange mergeNewLinkToTreeAtSegment(FontRenderContext frc, String treeID, BusProperties newBp, LinkSegmentID sid) {
        String slpTag = newBp.getSingleLinkage();
        if (this.getLinkProperties(slpTag) != null) {
            // empty if block
        }
        BusProperties bp = this.getLinkProperties(treeID);
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, null);
        bp.mergeSingleToTreeAtSegment(newBp, this.getGenomeTarget(), this, frc, sid);
        this.linkProps_.put(slpTag, bp);
        retval.addedLinkID = slpTag;
        retval.removedLinkID = null;
        this.undoPostProcess(retval, bp, null);
        return retval;
    }

    public PropChange setSpecialPropsForSegment(BusProperties bp, LinkSegmentID lsid, SuggestedDrawStyle sds, String ovrKey) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, ovrKey);
        bp.setDrawStyleForID(lsid, sds);
        this.undoPostProcess(retval, bp, ovrKey);
        return retval;
    }

    public PropChange moveNode(String selection, Genome genome, double dx, double dy, PadNeedsForLayout padReqs) {
        NodeProperties props = this.getNodeProperties(selection);
        PropChange retval = new PropChange();
        retval.nOrig = (NodeProperties)props.clone();
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        retval.layoutKey = this.name_;
        Point2D loc = props.getLocation();
        props.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        retval.nNewProps = (NodeProperties)props.clone();
        this.rigidPadFixes(selection, dx, dy, padReqs);
        return retval;
    }

    public PropChange replaceNodeProperties(NodeProperties oldProp, NodeProperties newProp) {
        PropChange retval = new PropChange();
        retval.nOrig = (NodeProperties)oldProp.clone();
        retval.layoutKey = this.name_;
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        this.nodeProps_.put(newProp.getReference(), newProp);
        retval.nNewProps = (NodeProperties)newProp.clone();
        return retval;
    }

    public PropChange changeNodePropertiesType(String nodeID, int oldType, int newType) {
        NodeProperties existing = (NodeProperties)this.nodeProps_.get(nodeID);
        PropChange retval = new PropChange();
        retval.nOrig = (NodeProperties)existing.clone();
        retval.layoutKey = this.name_;
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        retval.nNewProps = new NodeProperties(existing, oldType, newType);
        this.nodeProps_.put(existing.getReference(), (NodeProperties)retval.nNewProps.clone());
        return retval;
    }

    public void nodeChangeUndo(PropChange unmove) {
        if (unmove.nOrig != null && unmove.nNewProps != null) {
            this.setNodeProperties(unmove.nOrig.getReference(), unmove.nOrig);
            Iterator olit = unmove.origLinks.iterator();
            while (olit.hasNext()) {
                BusProperties nextLink = (BusProperties)olit.next();
                List linkages = nextLink.getLinkageList();
                Iterator lit = linkages.iterator();
                while (lit.hasNext()) {
                    String refTag = (String)lit.next();
                    this.linkProps_.put(refTag, nextLink);
                }
            }
        } else if (unmove.nOrig == null) {
            this.nodeProps_.remove(unmove.nNewProps.getReference());
        } else {
            this.nodeProps_.put(unmove.nOrig.getReference(), unmove.nOrig);
        }
    }

    public void nodeChangeRedo(PropChange unmove) {
        if (unmove.nOrig != null && unmove.nNewProps != null) {
            this.setNodeProperties(unmove.nNewProps.getReference(), unmove.nNewProps);
            Iterator nlit = unmove.newLinks.iterator();
            while (nlit.hasNext()) {
                BusProperties nextLink = (BusProperties)nlit.next();
                List linkages = nextLink.getLinkageList();
                Iterator lit = linkages.iterator();
                while (lit.hasNext()) {
                    String refTag = (String)lit.next();
                    this.linkProps_.put(refTag, nextLink);
                }
            }
        } else if (unmove.nOrig == null) {
            this.nodeProps_.put(unmove.nNewProps.getReference(), unmove.nNewProps);
        } else {
            this.nodeProps_.remove(unmove.nOrig.getReference());
        }
    }

    public PropChange deleteCornerForNetModuleLinkTree(NetModuleLinkageProperties nmlp, LinkSegmentID segID, String ovrKey) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, nmlp, ovrKey);
        nmlp.removeCorner(segID);
        this.undoPostProcess(retval, nmlp, ovrKey);
        return retval;
    }

    public PropChange deleteLinkageCornerForTree(LinkProperties bp, LinkSegmentID segID, String overID) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, overID);
        bp.removeCorner(segID);
        this.undoPostProcess(retval, bp, overID);
        return retval;
    }

    public OrthoRepairInfo fixAllNonOrthoForLayout(List nonOrtho, Genome genome, FontRenderContext frc, boolean minCorners, OverlayStateOracle oso, String overID, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        int treeCount = 0;
        TreeMap worstFirst = new TreeMap(Collections.reverseOrder());
        int nno = nonOrtho.size();
        NetOverlayProperties nop = overID != null ? this.getNetOverlayProperties(overID) : null;
        for (int i = 0; i < nno; ++i) {
            String stable;
            LinkProperties lp;
            Intersection in = (Intersection)nonOrtho.get(i);
            String objID = in.getObjectID();
            String treeID = null;
            if (overID != null) {
                treeID = nop.getNetModuleLinkagePropertiesID(objID);
                lp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
            } else {
                lp = this.getLinkProperties(objID);
            }
            Map geoms = lp.getAllSegmentGeometries(genome, this, frc, false);
            double nonOrthoArea = LinkProperties.getNonOrthogonalArea(geoms);
            Double noaVal = new Double(nonOrthoArea);
            TreeSet<String> perNoa = (TreeSet<String>)worstFirst.get(noaVal);
            if (perNoa == null) {
                perNoa = new TreeSet<String>();
                worstFirst.put(noaVal, perNoa);
            }
            String string = stable = overID == null ? ((BusProperties)lp).getAStableLinkID(genome) : treeID;
            if (perNoa.contains(stable)) continue;
            perNoa.add(stable);
            ++treeCount;
        }
        double progFrac = (endFrac - startFrac) / (double)treeCount;
        double currFrac = startFrac;
        int failCount = 0;
        ArrayList<PropChange> retList = new ArrayList<PropChange>();
        Iterator wfvit = worstFirst.values().iterator();
        while (wfvit.hasNext()) {
            TreeSet perNoa = (TreeSet)wfvit.next();
            Iterator pnit = perNoa.iterator();
            while (pnit.hasNext()) {
                boolean keepGoing;
                String nextID = (String)pnit.next();
                LinkProperties lp = overID != null ? nop.getNetModuleLinkagePropertiesFromTreeID(nextID) : this.getLinkProperties(nextID);
                OrthoRepairInfo ori = this.fixAllNonOrthoForTree(lp, genome, frc, minCorners, oso, overID, monitor, currFrac, currFrac + progFrac);
                if (monitor != null && !(keepGoing = monitor.updateProgress((int)((currFrac += progFrac) * 100.0)))) {
                    throw new AsynchExitRequestException();
                }
                List<PropChange> al = Arrays.asList(ori.chgs);
                retList.addAll(al);
                failCount += ori.failCount;
            }
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        OrthoRepairInfo retval = new OrthoRepairInfo(failCount, false);
        PropChange[] retArr = new PropChange[retList.size()];
        retList.toArray(retArr);
        retval.addPropChanges(retArr);
        return retval;
    }

    public OrthoRepairInfo fixAllNonOrthoForTree(LinkProperties lp, Genome genome, FontRenderContext frc, boolean minCorners, OverlayStateOracle oso, String overID, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        Object retval;
        HashSet<LinkSegmentID> skipFails = new HashSet<LinkSegmentID>();
        ArrayList<Object> retList = new ArrayList<Object>();
        Set nonOrtho = lp.getNonOrthoSegments(genome, this, frc);
        if (nonOrtho.isEmpty()) {
            OrthoRepairInfo retval2 = new OrthoRepairInfo(0, false);
            PropChange[] retArr = new PropChange[]{};
            retval2.addPropChanges(retArr);
            return retval2;
        }
        double progFrac = (endFrac - startFrac) / (double)nonOrtho.size();
        double currFrac = startFrac;
        boolean first = true;
        while (true) {
            retval = new PropChange();
            this.undoPreProcess((PropChange)retval, lp, overID);
            if (first) {
                first = false;
                TopoRepairInfo tri = this.repairTreeTopologyGuts(lp, frc, genome, oso, overID, monitor, currFrac, currFrac);
                if (tri.topoFix == 3) {
                    skipFails.addAll(nonOrtho);
                    OrthoRepairInfo ori = new OrthoRepairInfo(skipFails.size(), false);
                    PropChange[] retArr = new PropChange[]{};
                    ori.addPropChanges(retArr);
                    return ori;
                }
            }
            LinkSegmentID lsid = lp.getDeepestNonOrtho(genome, this, frc, skipFails);
            if ((currFrac += progFrac) > endFrac) {
                currFrac = endFrac;
            }
            if (monitor != null) {
                boolean keepGoing;
                if (lsid == null) {
                    currFrac = endFrac;
                }
                if (!(keepGoing = monitor.updateProgress((int)(currFrac * 100.0)))) {
                    throw new AsynchExitRequestException();
                }
            }
            if (lsid == null) break;
            if (!lp.fixNonOrtho(lsid, genome, this, frc, minCorners, oso, overID, monitor)) {
                skipFails.add(lsid);
                continue;
            }
            double nextFrac = currFrac + progFrac;
            TopoRepairInfo tri = this.repairTreeTopologyGuts(lp, frc, genome, oso, overID, monitor, currFrac, nextFrac);
            this.undoPostProcess((PropChange)retval, lp, overID);
            retList.add(retval);
        }
        retval = new OrthoRepairInfo(skipFails.size(), false);
        PropChange[] retArr = new PropChange[retList.size()];
        retList.toArray(retArr);
        ((OrthoRepairInfo)retval).addPropChanges(retArr);
        return retval;
    }

    public OrthoRepairInfo fixNonOrtho(LinkProperties bp, LinkSegmentID segID, Genome genome, FontRenderContext frc, boolean minCorners, OverlayStateOracle oso, String ovrKey, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        boolean keepGoing;
        PropChange pch = new PropChange();
        this.undoPreProcess(pch, bp, ovrKey);
        double midFrac = (endFrac - startFrac) / 2.0;
        this.repairTreeTopologyGuts(bp, frc, genome, oso, ovrKey, monitor, startFrac, midFrac);
        boolean success = bp.fixNonOrtho(segID, genome, this, frc, minCorners, oso, ovrKey, monitor);
        OrthoRepairInfo retval = new OrthoRepairInfo(success ? 0 : 1, true);
        if (!success) {
            return retval;
        }
        if (monitor != null && !(keepGoing = monitor.updateProgress((int)(endFrac * 100.0)))) {
            throw new AsynchExitRequestException();
        }
        this.repairTreeTopologyGuts(bp, frc, genome, oso, ovrKey, monitor, midFrac, endFrac);
        this.undoPostProcess(pch, bp, ovrKey);
        PropChange[] retArr = new PropChange[]{pch};
        retval.addPropChanges(retArr);
        return retval;
    }

    public PropChange makeLinkageDirect(BusProperties bp) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, null);
        bp.makeDirect();
        this.undoPostProcess(retval, bp, null);
        return retval;
    }

    public PropChange makeLinkageDirectForLink(String linkID, Genome genome, NodeInsertionDirective nid) {
        BusProperties bp = this.getLinkProperties(linkID);
        if (!bp.isSingleDropTree()) {
            return null;
        }
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, null);
        bp.makeDirect();
        if (nid != null && nid.landingCorners != null) {
            int numLand = nid.landingCorners.size();
            for (int i = 0; i < numLand; ++i) {
                Point2D newPt = (Point2D)nid.landingCorners.get(i);
                int idType = bp.isDirect() ? 2 : 1;
                LinkSegmentID dropSegID = LinkSegmentID.buildIDForType(linkID, idType);
                this.splitBusLink(dropSegID, newPt, bp, null);
            }
        }
        this.undoPostProcess(retval, bp, null);
        return retval;
    }

    public PropChange splitBusLink(LinkSegmentID segID, Point2D pt, LinkProperties lp, String ovrKey) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, lp, ovrKey);
        if (lp.linkSplitSupport(segID, pt) == null) {
            return null;
        }
        this.undoPostProcess(retval, lp, ovrKey);
        return retval;
    }

    public PropChange splitDirectLinkInHalf(Genome genome, String srcID, FontRenderContext frc) {
        BusProperties bp = this.getBusForSource(srcID);
        if (!bp.isDirect()) {
            return null;
        }
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, bp, null);
        bp.splitNoSegmentBus(genome, this, frc);
        this.undoPostProcess(retval, bp, null);
        return retval;
    }

    public PropChange[] supportLinkSourceBreakoff(LinkSegmentID segID, Set resolved, String newSourceID, LinkSegmentID newConnectionID, Genome genome, FontRenderContext frc) {
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        if (resolved.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String oneID = (String)resolved.iterator().next();
        BusProperties bp = this.getLinkProperties(oneID);
        BusProperties newProps = (BusProperties)bp.breakTreePortionToNewSource(segID, resolved, newSourceID, null);
        Iterator alit = resolved.iterator();
        while (alit.hasNext()) {
            String nextLinkID = (String)alit.next();
            PropChange pc = this.removeLinkProperties(nextLinkID);
            changes.add(pc);
        }
        PropChange pc2 = null;
        if (newConnectionID != null) {
            BusProperties newbp = this.getBusForSource(newSourceID);
            pc2 = new PropChange();
            this.undoPreProcess(pc2, newbp, null);
            newbp.mergeTreeToTreeAtSegment(newProps, genome, frc, newConnectionID);
            this.undoPostProcess(pc2, newbp, null);
            changes.add(pc2);
            newProps = newbp;
        }
        PropChange pc3 = new PropChange();
        pc3.orig = null;
        pc3.newProps = pc2 != null ? pc2.newProps : (BusProperties)newProps.clone();
        pc3.layoutKey = this.name_;
        pc3.linkIDs = new HashSet();
        Iterator lmvit = resolved.iterator();
        while (lmvit.hasNext()) {
            String linkID = (String)lmvit.next();
            this.linkProps_.put(linkID, newProps);
            pc3.linkIDs.add(linkID);
        }
        changes.add(pc3);
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange[] supportModuleLinkTreeSwitch(LinkSegmentID segID, Set resolved, String ovrKey, String oldTreeID, String newTreeID, LinkSegmentID newConnectionID, Genome genome, FontRenderContext frc, Point2D padPoint, Vector2D sideDir) {
        String newKey;
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        NetOverlayProperties noProps = this.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = noProps.getNetModuleLinkagePropertiesFromTreeID(oldTreeID);
        if (newConnectionID == null) {
            newTreeID = newKey = ((DBGenome)Database.getDB().getGenome()).getNextKey();
        } else {
            newKey = "fakeID";
            padPoint = new Point2D.Double(0.0, 0.0);
            sideDir = new Vector2D(0.0, 0.0);
        }
        NetModuleLinkageProperties.DirectLinkExtraInfo dlei = new NetModuleLinkageProperties.DirectLinkExtraInfo(newKey, padPoint, sideDir);
        NetModuleLinkageProperties newProps = (NetModuleLinkageProperties)nmlp.breakTreePortionToNewSource(segID, resolved, nmlp.getSourceTag(), dlei);
        Iterator alit = resolved.iterator();
        while (alit.hasNext()) {
            String nextLinkID = (String)alit.next();
            PropChange pc = this.removeNetModuleLinkageProperties(nextLinkID, ovrKey);
            changes.add(pc);
        }
        PropChange pc2 = null;
        if (newConnectionID != null) {
            NetModuleLinkageProperties nmlpNew = noProps.getNetModuleLinkagePropertiesFromTreeID(newTreeID);
            pc2 = new PropChange();
            this.undoPreProcess(pc2, nmlpNew, ovrKey);
            nmlpNew.mergeTreeToTreeAtSegment(newProps, genome, frc, newConnectionID);
            this.undoPostProcess(pc2, nmlpNew, ovrKey);
        } else {
            pc2 = this.setNetModuleLinkageProperties(newKey, newProps, ovrKey);
        }
        changes.add(pc2);
        Iterator lmvit = resolved.iterator();
        while (lmvit.hasNext()) {
            String linkID = (String)lmvit.next();
            PropChange pc3 = new PropChange();
            pc3.nmlpTieLinkIDOrig = linkID;
            pc3.nmlpTieTreeIDOrig = null;
            pc3.nmlpTieLinkIDNew = linkID;
            pc3.nmlpTieTreeIDNew = newTreeID;
            pc3.layoutKey = this.name_;
            pc3.nopRef = ovrKey;
            noProps.tieNetModuleLinkagePropertiesForLink(linkID, newTreeID);
            changes.add(pc3);
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public PropChange[] supportLinkNodeInsertion(LinkSegmentID segID, Set resolved, String newNodeID, String firstLinkID, Map linkMap, Genome genome, FontRenderContext frc, Map needDirectFixup, NodeInsertionDirective nid) {
        LinkSegmentID dropSegID;
        int idType;
        Point2D newPt;
        int i;
        BusProperties bp2;
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        if (resolved.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String oneID = (String)resolved.iterator().next();
        BusProperties bp = this.getLinkProperties(oneID);
        PropChange pc = new PropChange();
        this.undoPreProcess(pc, bp, null);
        BusProperties newProps = bp.insertNodeInTree(segID, resolved, newNodeID, firstLinkID, linkMap, genome, this, frc, needDirectFixup, nid);
        this.undoPostProcess(pc, bp, null);
        changes.add(pc);
        PropChange pc2 = new PropChange();
        pc2.orig = null;
        pc2.newProps = pc.newProps;
        pc2.layoutKey = this.name_;
        this.linkProps_.put(firstLinkID, bp);
        pc2.linkIDs = new HashSet();
        pc2.linkIDs.add(firstLinkID);
        changes.add(pc2);
        PropChange pc3 = new PropChange();
        pc3.orig = null;
        pc3.newProps = (BusProperties)newProps.clone();
        pc3.layoutKey = this.name_;
        pc3.linkIDs = new HashSet();
        String mappedOneLink = null;
        Iterator lmvit = linkMap.values().iterator();
        while (lmvit.hasNext()) {
            String linkID = (String)lmvit.next();
            if (mappedOneLink == null) {
                mappedOneLink = linkID;
            }
            this.linkProps_.put(linkID, newProps);
            pc3.linkIDs.add(linkID);
        }
        changes.add(pc3);
        if (nid != null && nid.landingCorners != null) {
            bp2 = this.getLinkProperties(firstLinkID);
            int numLand = nid.landingCorners.size();
            for (i = 0; i < numLand; ++i) {
                newPt = (Point2D)nid.landingCorners.get(i);
                idType = bp2.isDirect() ? 2 : 1;
                dropSegID = LinkSegmentID.buildIDForType(firstLinkID, idType);
                changes.add(this.splitBusLink(dropSegID, newPt, bp2, null));
            }
        }
        if (nid != null && nid.launchCorners != null) {
            bp2 = this.getLinkProperties(mappedOneLink);
            int numLau = nid.launchCorners.size();
            for (i = 0; i < numLau; ++i) {
                newPt = (Point2D)nid.launchCorners.get(i);
                idType = bp2.isDirect() ? 2 : 0;
                dropSegID = LinkSegmentID.buildIDForType(mappedOneLink, idType);
                changes.add(this.splitBusLink(dropSegID, newPt, bp2, null));
            }
        }
        PropChange[] retval = new PropChange[changes.size()];
        return changes.toArray(retval);
    }

    public InheritedLinkNodeInsertionResult supportInheritedLinkNodeInsertion(LinkSegmentID rootSegID, Set resolved, BusProperties rootProps, Point2D rootSplit, Layout rootLayout, Genome rootGenome, Genome myGenome, FontRenderContext frc, String newNodeID, String firstLinkID, Map linkMap, Map needDirectFixup) {
        InheritedInsertionInfo iii = this.findInheritedMatchingLinkSegment(rootSegID, resolved, rootProps, rootSplit, rootLayout, rootGenome, myGenome, frc);
        if (iii == null) {
            return null;
        }
        NodeProperties props = this.getNodeProperties(newNodeID);
        String oneID = (String)resolved.iterator().next();
        BusProperties bp = this.getLinkProperties(oneID);
        LinkSegment segGeom = bp.getSegmentGeometryForID(iii.segID, myGenome, this, frc, true);
        Vector2D travel = segGeom.getRun();
        NodeInsertionDirective nid = props.getRenderer().getInsertionDirective(travel, iii.pt);
        PropChange retval = new PropChange();
        retval.nOrig = new NodeProperties(props);
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        retval.layoutKey = this.name_;
        double xCoord = UiUtil.forceToGridValue(iii.pt.getX() + nid.offset.getX(), 10.0);
        double yCoord = UiUtil.forceToGridValue(iii.pt.getY() + nid.offset.getY(), 10.0);
        Point2D.Double nodeLoc = new Point2D.Double(xCoord, yCoord);
        props.setLocation(nodeLoc);
        props.setOrientation(nid.orientation);
        retval.nNewProps = (NodeProperties)props.clone();
        PropChange[] slnPC = this.supportLinkNodeInsertion(iii.segID, resolved, newNodeID, firstLinkID, linkMap, myGenome, frc, needDirectFixup, nid);
        PropChange[] newRetval = new PropChange[slnPC.length + 1];
        System.arraycopy(slnPC, 0, newRetval, 0, slnPC.length);
        newRetval[slnPC.length] = retval;
        HashMap<String, PadCalculatorToo.PadResult> padChanges = new HashMap<String, PadCalculatorToo.PadResult>();
        Linkage link = myGenome.getLinkage(firstLinkID);
        PadCalculatorToo.PadResult pres = new PadCalculatorToo.PadResult(link.getLaunchPad(), nid.landingPad);
        padChanges.put(firstLinkID, pres);
        Iterator lmvit = linkMap.values().iterator();
        while (lmvit.hasNext()) {
            String linkID = (String)lmvit.next();
            link = myGenome.getLinkage(linkID);
            pres = new PadCalculatorToo.PadResult(nid.launchPad, link.getLandingPad());
            padChanges.put(linkID, pres);
        }
        return new InheritedLinkNodeInsertionResult(newRetval, padChanges, nid);
    }

    public PropChange bestFitNodePlacementForInsertion(Layout rootLayout, GenomeInstance gi, String newNodeID, FontRenderContext frc) {
        String rootNewNode = GenomeItemInstance.getBaseID(newNodeID);
        Point2D newRootPos = rootLayout.getNodeProperties(rootNewNode).getLocation();
        NodeInstance newInstance = (NodeInstance)gi.getNode(newNodeID);
        GroupMembership newNodeGroupMemb = gi.getNodeGroupMembership(newInstance);
        if (newNodeGroupMemb.mainGroups.isEmpty()) {
            throw new IllegalStateException();
        }
        String newNodeGrpID = (String)newNodeGroupMemb.mainGroups.iterator().next();
        HashSet<Point2D> candPosSet = new HashSet<Point2D>();
        HashSet<Point2D> backupCandPosSet = new HashSet<Point2D>();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            String otherNodeID;
            Linkage link = (Linkage)lit.next();
            String target = link.getTarget();
            String source = link.getSource();
            if (target.equals(newNodeID)) {
                otherNodeID = source;
            } else {
                if (!source.equals(newNodeID)) continue;
                otherNodeID = target;
            }
            String rootOtherNode = GenomeItemInstance.getBaseID(otherNodeID);
            Point2D otherRootPos = rootLayout.getNodeProperties(rootOtherNode).getLocation();
            Point2D otherPos = this.getNodeProperties(otherNodeID).getLocation();
            NodeInstance otherInstance = (NodeInstance)gi.getNode(otherNodeID);
            GroupMembership otherNodeGroupMemb = gi.getNodeGroupMembership(otherInstance);
            if (otherNodeGroupMemb.mainGroups.isEmpty()) {
                throw new IllegalStateException();
            }
            String otherNodeGrpID = (String)otherNodeGroupMemb.mainGroups.iterator().next();
            Vector2D rootOffset = new Vector2D(otherRootPos, newRootPos);
            Point2D candPos = rootOffset.add(otherPos);
            backupCandPosSet.add(candPos);
            if (!otherNodeGrpID.equals(newNodeGrpID)) continue;
            candPosSet.add(candPos);
        }
        HashSet<Point2D> usePos = candPosSet.isEmpty() ? backupCandPosSet : candPosSet;
        Point2D newPoint = AffineCombination.combination(usePos, 10.0);
        newPoint = this.spiralNodePlacement(gi, frc, newNodeID, newPoint);
        NodeProperties props = this.getNodeProperties(newNodeID);
        PropChange retval = new PropChange();
        retval.nOrig = (NodeProperties)props.clone();
        retval.origLinks = new HashSet();
        retval.newLinks = new HashSet();
        retval.layoutKey = this.name_;
        props.setLocation(newPoint);
        retval.nNewProps = (NodeProperties)props.clone();
        return retval;
    }

    private Point2D spiralNodePlacement(Genome genome, FontRenderContext frc, String nodeID, Point2D guessPt) {
        LinkPlacementGrid targLinkGrid;
        LinkRouter router = new LinkRouter();
        try {
            targLinkGrid = router.initGrid(genome, this, frc, null, 1, null);
        }
        catch (AsynchExitRequestException ex) {
            throw new IllegalStateException();
        }
        PatternGrid targGrid = targLinkGrid.extractPatternGrid(true);
        Node node = genome.getNode(nodeID);
        NodeProperties props = this.getNodeProperties(nodeID);
        PatternGrid nodeGrid = new PatternGrid();
        props.getRenderer().renderToPatternGrid(genome, node, this, frc, nodeGrid);
        Pattern pat = nodeGrid.generatePattern();
        Point startPt = new Point((int)guessPt.getX() / 10, (int)guessPt.getY() / 10);
        PatternPlacerSpiral pps = new PatternPlacerSpiral(targGrid, pat, startPt, 0, 10);
        Point retval = pps.locatePattern();
        pps.sinkPattern(retval);
        Point2D.Double retval10 = new Point2D.Double(retval.getX() * 10.0, retval.getY() * 10.0);
        return retval10;
    }

    public InheritedInsertionInfo findInheritedMatchingLinkSegment(LinkSegmentID rootSegID, Set resolved, BusProperties rootBus, Point2D rootSplit, Layout rootLayout, Genome rootGenome, Genome myGenome, FontRenderContext frc) {
        if (resolved.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String oneID = (String)resolved.iterator().next();
        BusProperties bp = this.getLinkProperties(oneID);
        LinkSegmentID lsid = bp.findSegmentSupportingLinkSet(rootBus, rootSegID, rootLayout, rootGenome, resolved, this, myGenome, frc);
        if (lsid == null) {
            return null;
        }
        Point2D splitPt = (Point2D)rootSplit.clone();
        LinkSegment rseg = rootBus.getSegmentGeometryForID(rootSegID, rootGenome, rootLayout, frc, true);
        double rFrac = rseg.fractionOfRun(splitPt);
        LinkSegment lseg = bp.getSegmentGeometryForID(lsid, myGenome, this, frc, true);
        splitPt = lseg.pointAtFraction(rFrac);
        return new InheritedInsertionInfo(lsid, splitPt);
    }

    public PropChange moveLinkLabel(BusProperties lp, double dx, double dy) {
        PropChange retval = new PropChange();
        this.undoPreProcess(retval, lp, null);
        Point2D pt = lp.getTextPosition();
        if (pt == null) {
            pt = new Point2D.Double(0.0, 0.0);
        }
        Point2D.Double newPt = new Point2D.Double(pt.getX() + dx, pt.getY() + dy);
        lp.setTextPosition(newPt);
        this.undoPostProcess(retval, lp, null);
        return retval;
    }

    public PropChange moveBusLink(LinkSegmentID[] segIDs, double dx, double dy, Point2D strt, BusProperties bp) {
        if (segIDs == null) {
            return null;
        }
        PropChange retval = new PropChange();
        retval.orig = new BusProperties(bp);
        retval.layoutKey = this.name_;
        retval.linkIDs = new HashSet();
        Iterator lpit = this.linkProps_.keySet().iterator();
        while (lpit.hasNext()) {
            String nextKey = (String)lpit.next();
            BusProperties lp = (BusProperties)this.linkProps_.get(nextKey);
            if (lp != bp) continue;
            retval.linkIDs.add(nextKey);
        }
        dx = (double)Math.round(dx / 10.0) * 10.0;
        dy = (double)Math.round(dy / 10.0) * 10.0;
        bp.moveBusLinkSegments(segIDs, strt, dx, dy);
        retval.newProps = new BusProperties(bp);
        return retval;
    }

    public PropChange replaceLinkProperties(BusProperties oldProp, BusProperties newProp) {
        PropChange retval = new PropChange();
        retval.orig = new BusProperties(oldProp);
        retval.newProps = new BusProperties(newProp);
        retval.layoutKey = this.name_;
        retval.linkIDs = new HashSet();
        Iterator lpit = this.linkProps_.keySet().iterator();
        while (lpit.hasNext()) {
            String nextKey = (String)lpit.next();
            BusProperties lp = (BusProperties)this.linkProps_.get(nextKey);
            if (lp != oldProp) continue;
            retval.linkIDs.add(nextKey);
        }
        Iterator rtvit = retval.linkIDs.iterator();
        while (rtvit.hasNext()) {
            String nextKey = (String)rtvit.next();
            this.linkProps_.put(nextKey, newProp);
        }
        return retval;
    }

    public void linkChangeUndo(PropChange undo) {
        Iterator lidit = undo.linkIDs.iterator();
        while (lidit.hasNext()) {
            String nextKey = (String)lidit.next();
            if (undo.orig != null) {
                this.linkProps_.put(nextKey, undo.orig);
                continue;
            }
            this.linkProps_.remove(nextKey);
        }
        if (undo.removedLinkID != null) {
            this.linkProps_.put(undo.removedLinkID, undo.orig);
        }
        if (undo.addedLinkID != null) {
            this.linkProps_.remove(undo.addedLinkID);
        }
    }

    public void linkChangeRedo(PropChange redo) {
        Iterator lidit = redo.linkIDs.iterator();
        while (lidit.hasNext()) {
            String nextKey = (String)lidit.next();
            if (redo.newProps != null) {
                this.linkProps_.put(nextKey, redo.newProps);
                continue;
            }
            this.linkProps_.remove(nextKey);
        }
        if (redo.removedLinkID != null) {
            this.linkProps_.remove(redo.removedLinkID);
        }
        if (redo.addedLinkID != null) {
            this.linkProps_.put(redo.addedLinkID, redo.newProps);
        }
    }

    public PropChange moveNote(String selection, Genome genome, double dx, double dy) {
        NoteProperties props = this.getNoteProperties(selection);
        PropChange retval = new PropChange();
        retval.ntOrig = (NoteProperties)props.clone();
        retval.layoutKey = this.name_;
        Point2D loc = props.getLocation();
        props.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        retval.ntNewProps = (NoteProperties)props.clone();
        return retval;
    }

    public PropChange replaceNoteProperties(String noteID, NoteProperties newProps) {
        NoteProperties oldProps = this.getNoteProperties(noteID);
        PropChange retval = new PropChange();
        retval.ntOrig = (NoteProperties)oldProps.clone();
        retval.layoutKey = this.name_;
        this.noteProps_.put(noteID, newProps);
        retval.ntNewProps = (NoteProperties)newProps.clone();
        return retval;
    }

    public PropChange moveDataLocation(String key, Genome genome, double dx, double dy) {
        Point2D loc = this.getDataLocation(key);
        PropChange retval = new PropChange();
        retval.dLocKey = key;
        retval.dLocOrig = (Point2D)loc.clone();
        retval.layoutKey = this.name_;
        Point2D.Double newLoc = new Point2D.Double(loc.getX() + dx, loc.getY() + dy);
        this.dataProps_.put(key, newLoc);
        retval.dLocNew = (Point2D)newLoc.clone();
        return retval;
    }

    public void noteChangeUndo(PropChange unmove) {
        if (unmove.ntOrig == null) {
            this.noteProps_.remove(unmove.ntNewProps.getReference());
        } else if (unmove.ntNewProps == null) {
            this.noteProps_.put(unmove.ntOrig.getReference(), unmove.ntOrig);
        } else {
            String oldRef = unmove.ntOrig.getReference();
            String newRef = unmove.ntNewProps.getReference();
            this.noteProps_.put(oldRef, unmove.ntOrig);
            if (!oldRef.equals(newRef)) {
                this.noteProps_.remove(newRef);
            }
        }
    }

    public void noteChangeRedo(PropChange unmove) {
        if (unmove.ntNewProps == null) {
            this.noteProps_.remove(unmove.ntOrig.getReference());
        } else if (unmove.ntOrig == null) {
            this.noteProps_.put(unmove.ntNewProps.getReference(), unmove.ntNewProps);
        } else {
            String oldRef = unmove.ntOrig.getReference();
            String newRef = unmove.ntNewProps.getReference();
            this.noteProps_.put(newRef, unmove.ntNewProps);
            if (!oldRef.equals(newRef)) {
                this.noteProps_.remove(oldRef);
            }
        }
    }

    public void dataPosChangeUndo(PropChange unmove) {
        Point2D loc = unmove.dLocOrig;
        if (loc == null) {
            this.dataProps_.remove(unmove.dLocKey);
        } else {
            this.dataProps_.put(unmove.dLocKey, loc.clone());
        }
    }

    public void dataPosChangeRedo(PropChange unmove) {
        Point2D loc = unmove.dLocNew;
        if (loc == null) {
            this.dataProps_.remove(unmove.dLocKey);
        } else {
            this.dataProps_.put(unmove.dLocKey, loc.clone());
        }
    }

    public void metaChangeUndo(PropChange undo) {
        this.lmeta_ = (LayoutMetadata)undo.metaOrig.clone();
    }

    public void metaChangeRedo(PropChange redo) {
        this.lmeta_ = (LayoutMetadata)redo.newMeta.clone();
    }

    public PropChange moveGroup(String selection, Genome genome, double dx, double dy) {
        GroupProperties props = this.getGroupProperties(selection);
        PropChange retval = new PropChange();
        retval.grOrig = new GroupProperties(props);
        retval.layoutKey = this.name_;
        Point2D loc = props.getLabelLocation();
        if (loc == null) {
            return null;
        }
        props.setLabelLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        retval.grNewProps = new GroupProperties(props);
        return retval;
    }

    public int getTopGroupOrder() {
        if (this.groupProps_.size() == 0) {
            return 0;
        }
        int retval = Integer.MIN_VALUE;
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            if (chkOrder <= retval) continue;
            retval = chkOrder;
        }
        return retval;
    }

    public int getBottomGroupOrder() {
        if (this.groupProps_.size() == 0) {
            return 0;
        }
        int retval = Integer.MAX_VALUE;
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            if (chkOrder >= retval) continue;
            retval = chkOrder;
        }
        return retval;
    }

    public List getGroupDrawingOrder() {
        TreeMap<GroupProperties.GroupOrdering, String> goMap = new TreeMap<GroupProperties.GroupOrdering, String>();
        Iterator gpit = this.groupProps_.keySet().iterator();
        while (gpit.hasNext()) {
            String gpKey = (String)gpit.next();
            GroupProperties chkProps = (GroupProperties)this.groupProps_.get(gpKey);
            GroupProperties.GroupOrdering gOrd = chkProps.getGroupOrdering();
            goMap.put(gOrd, gpKey);
        }
        return new ArrayList(goMap.values());
    }

    public List getGroupIntersectionOrder() {
        List drawOrder = this.getGroupDrawingOrder();
        Collections.reverse(drawOrder);
        return drawOrder;
    }

    public PropChange[] raiseGroup(String selection) {
        GroupProperties props = this.getGroupProperties(selection);
        int oldOrder = props.getOrder();
        int flipOrder = Integer.MAX_VALUE;
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            if (chkOrder <= oldOrder || chkOrder >= flipOrder) continue;
            flipOrder = chkOrder;
        }
        if (flipOrder == Integer.MAX_VALUE) {
            return null;
        }
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            boolean lower;
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            boolean raise = chkOrder == oldOrder;
            boolean bl = lower = chkOrder == flipOrder;
            if (!raise && !lower) continue;
            PropChange retval = new PropChange();
            retval.grOrig = new GroupProperties(chkProps);
            retval.layoutKey = this.name_;
            chkProps.setOrder(raise ? flipOrder : oldOrder);
            retval.grNewProps = new GroupProperties(chkProps);
            changes.add(retval);
        }
        PropChange[] retval = new PropChange[changes.size()];
        changes.toArray(retval);
        return retval;
    }

    public PropChange[] lowerGroup(String selection) {
        GroupProperties props = this.getGroupProperties(selection);
        int oldOrder = props.getOrder();
        int flipOrder = Integer.MIN_VALUE;
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            if (chkOrder >= oldOrder || chkOrder <= flipOrder) continue;
            flipOrder = chkOrder;
        }
        if (flipOrder == Integer.MIN_VALUE) {
            return null;
        }
        ArrayList<PropChange> changes = new ArrayList<PropChange>();
        gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            boolean lower;
            GroupProperties chkProps = (GroupProperties)gpit.next();
            int chkOrder = chkProps.getOrder();
            boolean raise = chkOrder == flipOrder;
            boolean bl = lower = chkOrder == oldOrder;
            if (!raise && !lower) continue;
            PropChange retval = new PropChange();
            retval.grOrig = new GroupProperties(chkProps);
            retval.layoutKey = this.name_;
            chkProps.setOrder(raise ? oldOrder : flipOrder);
            retval.grNewProps = new GroupProperties(chkProps);
            changes.add(retval);
        }
        PropChange[] retval = new PropChange[changes.size()];
        changes.toArray(retval);
        return retval;
    }

    public PropChange replaceGroupProperties(GroupProperties oldProp, GroupProperties newProp) {
        PropChange retval = new PropChange();
        retval.grOrig = new GroupProperties(oldProp);
        retval.layoutKey = this.name_;
        this.groupProps_.put(newProp.getReference(), newProp);
        retval.grNewProps = new GroupProperties(newProp);
        return retval;
    }

    public void groupChangeUndo(PropChange undo) {
        if (undo.grOrig != null && undo.grNewProps != null) {
            this.groupProps_.put(undo.grOrig.getReference(), undo.grOrig);
        } else if (undo.grOrig == null) {
            this.groupProps_.remove(undo.grNewProps.getReference());
        } else {
            this.groupProps_.put(undo.grOrig.getReference(), undo.grOrig);
        }
    }

    public void groupChangeRedo(PropChange undo) {
        if (undo.grOrig != null && undo.grNewProps != null) {
            this.groupProps_.put(undo.grNewProps.getReference(), undo.grNewProps);
        } else if (undo.grOrig == null) {
            this.groupProps_.put(undo.grNewProps.getReference(), undo.grNewProps);
        } else {
            this.groupProps_.remove(undo.grOrig.getReference());
        }
    }

    public PropChange foldInNewProperty(Linkage newLink, Genome genome, BusProperties spTree, FontRenderContext frc) {
        String linkID = newLink.getID();
        String source = newLink.getSource();
        int launchPad = newLink.getLaunchPad();
        PropChange retval = new PropChange();
        BusProperties useProp = this.getLinkPropertyForSource(source, launchPad);
        if (useProp == null) {
            this.linkProps_.put(linkID, spTree);
            retval.layoutKey = this.name_;
            retval.linkIDs = new HashSet();
            retval.addedLinkID = linkID;
            retval.removedLinkID = null;
            this.undoPostProcess(retval, spTree, null);
        } else {
            this.undoPreProcess(retval, useProp, null);
            retval.addedLinkID = linkID;
            retval.removedLinkID = null;
            useProp.mergeSinglePathTree(spTree, genome, this, frc);
            this.linkProps_.put(linkID, useProp);
            this.undoPostProcess(retval, useProp, null);
        }
        return retval;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<layout ");
        out.print("name=\"");
        out.print(this.name_);
        out.print("\" genome=\"");
        out.print(this.targetGenome_);
        out.print("\" type=\"");
        switch (this.layout_) {
            case 1: {
                out.print("grid");
                break;
            }
            case 0: {
                out.print("ball");
                break;
            }
            case 2: {
                out.print("free");
            }
        }
        out.println("\" >");
        ind.up();
        this.lmeta_.writeXML(out, ind);
        ind.down();
        ind.up().indent();
        out.println("<props>");
        this.writeNodeProps(out, ind.up());
        this.writeLinkProps(out, ind);
        this.writeGroupProps(out, ind);
        this.writeNoteProps(out, ind);
        this.writeOverlayProps(out, ind);
        this.writeDataProps(out, ind);
        ind.down().indent();
        out.println("</props>");
        ind.down().indent();
        out.println("</layout>");
    }

    public PropChange[] replaceColor(String oldID, String newID) {
        ArrayList<PropChange> retList = new ArrayList<PropChange>();
        PropChange pending = new PropChange();
        pending.layoutKey = this.name_;
        Iterator npi = this.nodeProps_.values().iterator();
        while (npi.hasNext()) {
            NodeProperties np = (NodeProperties)npi.next();
            pending.nOrig = (NodeProperties)np.clone();
            if (!np.replaceColor(oldID, newID)) continue;
            pending.nNewProps = (NodeProperties)np.clone();
            pending.origLinks = new HashSet();
            pending.newLinks = new HashSet();
            retList.add(pending);
            pending = new PropChange();
            pending.layoutKey = this.name_;
        }
        Iterator gpi = this.groupProps_.values().iterator();
        while (gpi.hasNext()) {
            GroupProperties gp = (GroupProperties)gpi.next();
            pending.grOrig = new GroupProperties(gp);
            if (!gp.replaceColor(oldID, newID)) continue;
            pending.grNewProps = new GroupProperties(gp);
            retList.add(pending);
            pending = new PropChange();
            pending.layoutKey = this.name_;
        }
        Iterator ntit = this.noteProps_.values().iterator();
        while (ntit.hasNext()) {
            NoteProperties np = (NoteProperties)ntit.next();
            pending.ntOrig = (NoteProperties)np.clone();
            if (!np.replaceColor(oldID, newID)) continue;
            pending.ntNewProps = (NoteProperties)np.clone();
            retList.add(pending);
            pending = new PropChange();
            pending.layoutKey = this.name_;
        }
        HashSet<BusProperties> treeLinks = new HashSet<BusProperties>();
        Iterator lpi = this.linkProps_.values().iterator();
        while (lpi.hasNext()) {
            BusProperties lp = (BusProperties)lpi.next();
            if (treeLinks.contains(lp)) continue;
            treeLinks.add(lp);
        }
        Iterator tlit = treeLinks.iterator();
        while (tlit.hasNext()) {
            BusProperties lp = (BusProperties)tlit.next();
            this.undoPreProcess(pending, lp, null);
            if (!lp.replaceColor(oldID, newID)) continue;
            this.undoPostProcess(pending, lp, null);
            retList.add(pending);
            pending = new PropChange();
        }
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String ovrKey = (String)opit.next();
            NetOverlayProperties nop = (NetOverlayProperties)this.ovrProps_.get(ovrKey);
            pending.nopOrig = (NetOverlayProperties)nop.clone();
            if (!nop.replaceColor(oldID, newID)) continue;
            pending.nopNew = (NetOverlayProperties)nop.clone();
            retList.add(pending);
            pending = new PropChange();
            pending.layoutKey = this.name_;
        }
        return retList.isEmpty() ? null : retList.toArray(new PropChange[retList.size()]);
    }

    public void fillOverlayIdentityMaps(OverlayKeySet fullKeys, Map keyMap, Map modIDMap, Map modLinkIDMap) {
        if (fullKeys == null) {
            return;
        }
        HashSet<String> overKeys = new HashSet<String>();
        Iterator mkit = fullKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            keyMap.put(fullKey, fullKey);
            overKeys.add(fullKey.ovrKey);
        }
        Iterator oit = overKeys.iterator();
        while (oit.hasNext()) {
            String key = (String)oit.next();
            NetOverlayProperties oProps = (NetOverlayProperties)this.ovrProps_.get(key);
            oProps.fillModAndLinkIdentityMaps(modIDMap, modLinkIDMap);
        }
    }

    public void transferLayoutFromLegacy(Map nodeMap, Map linkMap, Map groupMap, Map keyMap, Map modLinkIDMap, Map diceMap, Layout legacy, boolean dataOnly, Map rememberMap, Genome genome, FontRenderContext frc) {
        this.name_ = legacy.name_;
        this.targetGenome_ = legacy.targetGenome_;
        Iterator dpit = legacy.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            String key = (String)dpit.next();
            Point2D pt = (Point2D)legacy.dataProps_.get(key);
            if (pt == null) continue;
            this.dataProps_.put(key, pt.clone());
        }
        if (dataOnly) {
            Iterator ntit = legacy.noteProps_.keySet().iterator();
            while (ntit.hasNext()) {
                String key = (String)ntit.next();
                NoteProperties np = (NoteProperties)legacy.noteProps_.get(key);
                this.noteProps_.put(key, (NoteProperties)np.clone());
            }
            this.transferOverlayCore(keyMap, modLinkIDMap, diceMap, legacy);
            return;
        }
        this.transferLayoutCore(nodeMap, linkMap, groupMap, true, keyMap, modLinkIDMap, diceMap, legacy, rememberMap, genome, frc);
    }

    public Rectangle2D applySupplementalDataCoords(SupplementalDataCoords sdc, Genome genome, FontRenderContext frc, OverlayKeySet fullModKeys) {
        Rectangle2D rect;
        if (sdc == null) {
            return null;
        }
        Rectangle lob = this.getLayoutBounds(genome, frc, true, fullModKeys != null, fullModKeys != null, false, false, null, null, null, fullModKeys);
        if (lob == null) {
            rect = this.getSupplementalBounds();
            if (rect == null) {
                return null;
            }
        } else {
            rect = new Rectangle2D.Double(lob.x, lob.y, lob.width, lob.height);
        }
        double x0 = rect.getX();
        double y0 = rect.getY();
        double xlen = rect.getWidth();
        double ylen = rect.getHeight();
        Iterator dpit = this.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            Point2D sdcPt;
            String key = (String)dpit.next();
            Point2D pt = (Point2D)this.dataProps_.get(key);
            if (pt == null || (sdcPt = (Point2D)sdc.dataProps.get(key)) == null) continue;
            double x = sdcPt.getX() * xlen + x0;
            double y = sdcPt.getY() * ylen + y0;
            Point2D.Double newPt = new Point2D.Double(x, y);
            UiUtil.forceToGrid(x, y, newPt, 10.0);
            this.dataProps_.put(key, newPt);
        }
        Iterator ntit = this.noteProps_.keySet().iterator();
        while (ntit.hasNext()) {
            Point2D sdcPt;
            String key = (String)ntit.next();
            NoteProperties np = (NoteProperties)this.noteProps_.get(key);
            Point2D pt = np.getLocation();
            if (pt == null || (sdcPt = (Point2D)sdc.noteProps.get(key)) == null) continue;
            double x = sdcPt.getX() * xlen + x0;
            double y = sdcPt.getY() * ylen + y0;
            Point2D.Double newPt = new Point2D.Double(x, y);
            UiUtil.forceToGrid(x, y, newPt, 10.0);
            np.setLocation(newPt);
        }
        return rect;
    }

    public SupplementalDataCoords getSupplementalCoordsAllOverlays(Genome genome, FontRenderContext frc, OverlayKeySet allKeys) {
        Rectangle lob = this.getLayoutBounds(genome, frc, true, true, true, true, true, null, null, null, allKeys);
        return this.getSupplementalCoordsGuts(lob);
    }

    public SupplementalDataCoords getSupplementalCoords(Genome genome, FontRenderContext frc, OverlayKeySet allKeys) {
        Rectangle lob = this.getLayoutBounds(genome, frc, true, true, true, true, true, null, null, null, allKeys);
        return this.getSupplementalCoordsGuts(lob);
    }

    private SupplementalDataCoords getSupplementalCoordsGuts(Rectangle lob) {
        Rectangle2D rect = lob == null ? this.getSupplementalBounds() : new Rectangle2D.Double(lob.x, lob.y, lob.width, lob.height);
        if (rect == null) {
            return null;
        }
        SupplementalDataCoords retval = new SupplementalDataCoords();
        double x0 = rect.getX();
        double y0 = rect.getY();
        double xlen = rect.getWidth();
        double ylen = rect.getHeight();
        Iterator dpit = this.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            String key = (String)dpit.next();
            Point2D pt = (Point2D)this.dataProps_.get(key);
            if (pt == null) continue;
            double x = (pt.getX() - x0) / xlen;
            double y = (pt.getY() - y0) / ylen;
            retval.dataProps.put(key, new Point2D.Double(x, y));
        }
        Iterator ntit = this.noteProps_.keySet().iterator();
        while (ntit.hasNext()) {
            String key = (String)ntit.next();
            NoteProperties np = (NoteProperties)this.noteProps_.get(key);
            Point2D pt = np.getLocation();
            if (pt == null) continue;
            double x = (pt.getX() - x0) / xlen;
            double y = (pt.getY() - y0) / ylen;
            retval.noteProps.put(key, new Point2D.Double(x, y));
        }
        return retval;
    }

    public Rectangle2D getSupplementalBounds() {
        RectangularShape retval = null;
        Iterator dpit = this.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            String key = (String)dpit.next();
            Point2D pt = (Point2D)this.dataProps_.get(key);
            if (pt == null) continue;
            if (retval == null) {
                retval = Bounds.initBoundsWithPoint(pt);
                continue;
            }
            Bounds.tweakBoundsWithPoint((Rectangle2D)retval, pt);
        }
        Iterator ntit = this.noteProps_.keySet().iterator();
        while (ntit.hasNext()) {
            String key = (String)ntit.next();
            NoteProperties np = (NoteProperties)this.noteProps_.get(key);
            Point2D pt = np.getLocation();
            if (pt == null) continue;
            if (retval == null) {
                retval = Bounds.initBoundsWithPoint(pt);
                continue;
            }
            Bounds.tweakBoundsWithPoint((Rectangle2D)retval, pt);
        }
        if (retval == null) {
            return null;
        }
        double height = retval.getHeight();
        double width = retval.getWidth();
        boolean change = false;
        if (height == 0.0) {
            height = 100.0;
            change = true;
        }
        if (width == 0.0) {
            width = 100.0;
            change = true;
        }
        if (change) {
            ((Rectangle2D)retval).setRect(retval.getX(), retval.getY(), width, height);
        }
        return retval;
    }

    public void extractPartialLayout(Map nodeMap, Map linkMap, Map groupMap, Map keyMap, Map modLinkIDMap, Map diceMap, boolean transferNotes, boolean transferSuppData, Layout other, Map rememberMap, Genome genome, FontRenderContext frc) {
        this.transferLayoutCore(nodeMap, linkMap, groupMap, transferNotes, keyMap, modLinkIDMap, diceMap, other, rememberMap, genome, frc);
        if (transferSuppData) {
            this.dataProps_ = new HashMap();
            Iterator dpit = other.dataProps_.keySet().iterator();
            while (dpit.hasNext()) {
                String key = (String)dpit.next();
                Point2D pt = (Point2D)other.dataProps_.get(key);
                if (pt == null) continue;
                this.dataProps_.put(key, pt.clone());
            }
        }
    }

    public void extractPartialLayoutForGroup(GenomeInstance gi, Group group, Layout other, Map rememberMap, FontRenderContext frc, Map keyMap, Map modLinkIDMap, Map diceMap) {
        HashMap<String, String> linkMap = new HashMap<String, String>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            String linkID;
            Linkage link = (Linkage)glit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (!group.isInGroup(src, gi) || !group.isInGroup(trg, gi) || other.getLinkProperties(linkID = link.getID()) == null) continue;
            linkMap.put(linkID, linkID);
        }
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        Iterator gmit = group.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember memb = (GroupMember)gmit.next();
            String mid = memb.getID();
            if (other.getNodeProperties(mid) == null) continue;
            nodeMap.put(mid, mid);
        }
        HashMap<String, String> groupMap = new HashMap<String, String>();
        String grid = group.getID();
        if (other.getGroupProperties(grid) != null) {
            groupMap.put(grid, grid);
        }
        this.transferLayoutCore(nodeMap, linkMap, groupMap, true, keyMap, modLinkIDMap, diceMap, other, rememberMap, gi, frc);
    }

    public void mergeLayoutOfRegion(Layout other, Vector2D offset, boolean foldOverlays, boolean doName, int baseGroupOrder, Map moduleLinkFragShifts, String regionID) {
        double dx = offset.getX();
        double dy = offset.getY();
        Iterator npit = other.nodeProps_.keySet().iterator();
        while (npit.hasNext()) {
            String pKey = (String)npit.next();
            NodeProperties props = (NodeProperties)other.getNodeProperties(pKey).clone();
            Point2D loc = props.getLocation();
            props.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
            this.setNodeProperties(pKey, props);
        }
        HashMap<BusProperties, BusProperties> seen = new HashMap<BusProperties, BusProperties>();
        Iterator lpit = other.linkProps_.keySet().iterator();
        while (lpit.hasNext()) {
            String pKey = (String)lpit.next();
            BusProperties props = other.getLinkProperties(pKey);
            BusProperties newProps = (BusProperties)seen.get(props);
            if (newProps != null) {
                this.setLinkProperties(pKey, newProps);
                continue;
            }
            newProps = (BusProperties)props.clone();
            newProps.fullShift(dx, dy);
            seen.put(props, newProps);
            this.setLinkProperties(pKey, newProps);
        }
        Iterator gpit = other.groupProps_.keySet().iterator();
        while (gpit.hasNext()) {
            String grKey = (String)gpit.next();
            GroupProperties grProp = other.getGroupProperties(grKey);
            GroupProperties newProp = new GroupProperties(grProp);
            newProp.setOrder(baseGroupOrder + newProp.getOrder());
            Point2D loc = newProp.getLabelLocation();
            if (loc != null) {
                newProp.setLabelLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
            }
            this.groupProps_.put(grKey, newProp);
        }
        Iterator opit = other.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            Map shiftMap;
            String oID = (String)opit.next();
            NetOverlayProperties oop = (NetOverlayProperties)other.ovrProps_.get(oID);
            NetOverlayProperties top = (NetOverlayProperties)this.ovrProps_.get(oID);
            Iterator nmpkit = oop.getNetModulePropertiesKeys();
            while (nmpkit.hasNext()) {
                String modID = (String)nmpkit.next();
                NetModuleProperties onmp = oop.getNetModuleProperties(modID);
                NetModuleProperties nnmp = (NetModuleProperties)onmp.clone();
                nnmp.shift(dx, dy);
                NetModuleProperties tnmp = top.getNetModuleProperties(modID);
                if (foldOverlays && tnmp != null) {
                    HashSet tshapes = new HashSet(tnmp.initSliceList());
                    tshapes.addAll(nnmp.initSliceList());
                    tnmp.replaceTypeAndShapes(tnmp.getType(), new ArrayList(tshapes));
                    Point2D nameLoc = nnmp.getNameLoc();
                    if (nameLoc == null || !doName) continue;
                    tnmp.setNameLocation((Point2D)nameLoc.clone());
                    continue;
                }
                top.setNetModuleProperties(modID, nnmp);
            }
            if (moduleLinkFragShifts == null || (shiftMap = (Map)moduleLinkFragShifts.get(oID)) == null) continue;
            Iterator lmpit = top.getNetModuleLinkagePropertiesKeys();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = top.getNetModuleLinkagePropertiesFromTreeID(lkey);
                Map fragShiftsForAllRegions = (Map)shiftMap.get(lkey);
                LinkProperties.LinkFragmentShifts fragShift = (LinkProperties.LinkFragmentShifts)fragShiftsForAllRegions.get(regionID);
                if (fragShift == null) continue;
                nmlp.shiftSelectedSegmentsAndDrops(dx, dy, fragShift);
            }
        }
    }

    public void clipExpandedModulesToGroup(Rectangle2D overlayClipper, Map shapeMap) {
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String oID = (String)opit.next();
            NetOverlayProperties top = (NetOverlayProperties)this.ovrProps_.get(oID);
            Map oldToNewPerOverlay = shapeMap != null ? (Map)shapeMap.get(oID) : null;
            top.clipOverlay(overlayClipper, oldToNewPerOverlay);
        }
    }

    public void shiftContentsOfRegion(GenomeInstance gi, Group group, Vector2D offset) {
        Point2D loc;
        double dx = offset.getX();
        double dy = offset.getY();
        Iterator mit = group.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            NodeProperties props = this.getNodeProperties(nodeID);
            loc = props.getLocation();
            props.setLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        }
        HashSet<BusProperties> seen = new HashSet<BusProperties>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            String linkID;
            BusProperties props;
            Linkage link = (Linkage)glit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (!group.isInGroup(src, gi) || !group.isInGroup(trg, gi) || seen.contains(props = this.getLinkProperties(linkID = link.getID()))) continue;
            props.fullShift(dx, dy);
            seen.add(props);
        }
        GroupProperties grProp = this.getGroupProperties(group.getID());
        loc = grProp.getLabelLocation();
        if (loc != null) {
            grProp.setLabelLocation(new Point2D.Double(loc.getX() + dx, loc.getY() + dy));
        }
    }

    private void transferLayoutCore(Map nodeMap, Map linkMap, Map groupMap, boolean transferNotes, Map keyMap, Map modLinkIDMap, Map diceMap, Layout legacy, Map rememberMap, Genome genome, FontRenderContext frc) {
        BusProperties lp;
        Iterator nmit = nodeMap.keySet().iterator();
        while (nmit.hasNext()) {
            String newNode = (String)nmit.next();
            String oldNode = (String)nodeMap.get(newNode);
            if (oldNode == null) continue;
            NodeProperties np = new NodeProperties(newNode, legacy.getNodeProperties(oldNode));
            this.setNodeProperties(newNode, np);
        }
        HashMap<String, String> invertLink = new HashMap<String, String>();
        Iterator kit = linkMap.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            String val = (String)linkMap.get(key);
            if (val == null) continue;
            invertLink.put(val, key);
        }
        HashMap<String, String> invertNode = new HashMap<String, String>();
        kit = nodeMap.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            String val = (String)nodeMap.get(key);
            if (val == null) continue;
            invertNode.put(val, key);
        }
        Iterator lmit = linkMap.keySet().iterator();
        HashMap<BusProperties, BusProperties> seen = new HashMap<BusProperties, BusProperties>();
        while (lmit.hasNext()) {
            String newLink = (String)lmit.next();
            String oldLink = (String)linkMap.get(newLink);
            if (oldLink == null) continue;
            lp = legacy.getLinkProperties(oldLink);
            BusProperties newLp = (BusProperties)seen.get(lp);
            if (newLp != null) {
                this.setLinkProperties(newLink, newLp);
                continue;
            }
            newLp = (BusProperties)lp.clone();
            newLp.mapToNewLink(invertLink, invertNode);
            this.setLinkProperties(newLink, newLp);
            seen.put(lp, newLp);
        }
        if (rememberMap != null) {
            Iterator legit = legacy.linkProps_.keySet().iterator();
            while (legit.hasNext()) {
                String linkKey = (String)legit.next();
                lp = legacy.getLinkProperties(linkKey);
                BusProperties.RememberProps rp = new BusProperties.RememberProps(lp, genome, legacy, frc);
                rememberMap.put(linkKey, rp);
            }
        }
        if (groupMap != null) {
            Iterator gmit = groupMap.keySet().iterator();
            while (gmit.hasNext()) {
                String newGroup = (String)gmit.next();
                String oldGroup = (String)groupMap.get(newGroup);
                if (oldGroup == null) continue;
                GroupProperties oldProp = legacy.getGroupProperties(oldGroup);
                GroupProperties gp = new GroupProperties(newGroup, oldProp.getOrder(), oldProp);
                this.setGroupProperties(newGroup, gp);
            }
        }
        if (transferNotes) {
            this.noteProps_ = new HashMap();
            Iterator ntpit = legacy.noteProps_.keySet().iterator();
            while (ntpit.hasNext()) {
                String key = (String)ntpit.next();
                NoteProperties np = (NoteProperties)legacy.noteProps_.get(key);
                this.noteProps_.put(key, (NoteProperties)np.clone());
            }
        }
        this.transferOverlayCore(keyMap, modLinkIDMap, diceMap, legacy);
    }

    public void reduceToUnclaimedSlices(OverlayKeySet loModKeys, Map unclaimedSlices) {
        if (loModKeys == null) {
            return;
        }
        Iterator mkit = loModKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
            if (nmp.getType() == 2) continue;
            DicedModuleInfo dmi = (DicedModuleInfo)unclaimedSlices.get(fullKey);
            if (dmi == null || dmi.dicedRectByRects.isEmpty()) {
                nop.removeNetModuleProperties(fullKey.modKey);
                continue;
            }
            ArrayList<Object> shapes = new ArrayList<Object>();
            int numdrbr = dmi.dicedRectByRects.size();
            for (int i = 0; i < numdrbr; ++i) {
                NetModuleShapeFixer.RectResolution rr = (NetModuleShapeFixer.RectResolution)dmi.dicedRectByRects.get(i);
                NetModuleShapeFixer.GroupTRKey gtrk = (NetModuleShapeFixer.GroupTRKey)rr.tag;
                if (gtrk.isName()) continue;
                shapes.add(rr.rect.clone());
            }
            if (nmp.getType() == 0 && shapes.size() == 1) {
                nmp.replaceTypeAndShapes(0, shapes);
                continue;
            }
            nmp.replaceTypeAndShapes(1, shapes);
        }
    }

    public void shiftUnclaimedSlices(OverlayKeySet loModKeys, Map unclaimedSlices) {
        if (loModKeys == null) {
            return;
        }
        Iterator mkit = loModKeys.iterator();
        while (mkit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
            if (nmp.getType() == 2) continue;
            DicedModuleInfo dmi = (DicedModuleInfo)unclaimedSlices.get(fullKey);
            HashMap<Rectangle2D, Rectangle2D> oldToNew = new HashMap<Rectangle2D, Rectangle2D>();
            int numDS = dmi.dicedShapes.size();
            Rectangle2D nameShape = null;
            for (int i = 0; i < numDS; ++i) {
                NetModuleProperties.TaggedShape ts = (NetModuleProperties.TaggedShape)dmi.dicedShapes.get(i);
                if (ts.isName) {
                    nameShape = ts.shape;
                    continue;
                }
                oldToNew.put(ts.oldShape, ts.shape);
            }
            List shapes = nmp.initSliceList();
            int numShapes = shapes.size();
            for (int i = 0; i < numShapes; ++i) {
                Rectangle2D shape = (Rectangle2D)shapes.get(i);
                Rectangle2D newShape = (Rectangle2D)oldToNew.get(shape);
                if (newShape == null) continue;
                shapes.set(i, newShape);
            }
            if (nmp.getType() == 0 && shapes.size() == 1) {
                nmp.replaceTypeAndShapes(0, shapes);
            } else {
                nmp.replaceTypeAndShapes(1, shapes);
                nmp.reassembleSlices();
            }
            if (nameShape == null) continue;
            double centerX = UiUtil.forceToGridValueMin(nameShape.getCenterX(), 10.0);
            double centerY = UiUtil.forceToGridValueMin(nameShape.getCenterY(), 10.0);
            Point2D.Double newLoc = new Point2D.Double(centerX, centerY);
            nmp.setNameLocation(newLoc);
        }
    }

    private void transferOverlayCore(Map keyMap, Map modLinkIDMap, Map diceShapeMap, Layout legacy) {
        NetModule.FullModuleKey oldFullKey;
        if (keyMap == null && diceShapeMap == null) {
            return;
        }
        this.ovrProps_ = new HashMap();
        if (keyMap != null) {
            HashMap<String, String> overMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> modsPerOverlay = new HashMap<String, HashMap<String, String>>();
            Iterator kmit = keyMap.keySet().iterator();
            while (kmit.hasNext()) {
                oldFullKey = (NetModule.FullModuleKey)kmit.next();
                NetModule.FullModuleKey newFullKey = (NetModule.FullModuleKey)keyMap.get(oldFullKey);
                if (overMap.get(oldFullKey.ovrKey) == null) {
                    overMap.put(oldFullKey.ovrKey, newFullKey.ovrKey);
                }
                if (oldFullKey.modKey == null) continue;
                HashMap<String, String> modMap = (HashMap<String, String>)modsPerOverlay.get(oldFullKey.ovrKey);
                if (modMap == null) {
                    modMap = new HashMap<String, String>();
                    modsPerOverlay.put(oldFullKey.ovrKey, modMap);
                }
                modMap.put(oldFullKey.modKey, newFullKey.modKey);
            }
            Iterator oit = overMap.keySet().iterator();
            while (oit.hasNext()) {
                String oldOvr = (String)oit.next();
                String newID = (String)overMap.get(oldOvr);
                HashMap modMap = (HashMap)modsPerOverlay.get(oldOvr);
                NetOverlayProperties oldProps = (NetOverlayProperties)legacy.ovrProps_.get(oldOvr);
                NetOverlayProperties newProps = new NetOverlayProperties(oldProps, newID, modMap, modLinkIDMap, true);
                this.ovrProps_.put(newID, newProps);
            }
        }
        if (diceShapeMap != null) {
            HashMap<String, String> diceOverMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, DicedModuleInfo>> dicePerOverlay = new HashMap<String, HashMap<String, DicedModuleInfo>>();
            Iterator dsmit = diceShapeMap.keySet().iterator();
            while (dsmit.hasNext()) {
                HashMap<String, DicedModuleInfo> diceMap;
                oldFullKey = (NetModule.FullModuleKey)dsmit.next();
                DicedModuleInfo dmi = (DicedModuleInfo)diceShapeMap.get(oldFullKey);
                NetModule.FullModuleKey newFullKey = dmi.fullKey;
                if (diceOverMap.get(oldFullKey.ovrKey) == null) {
                    diceOverMap.put(oldFullKey.ovrKey, newFullKey.ovrKey);
                }
                if ((diceMap = (HashMap<String, DicedModuleInfo>)dicePerOverlay.get(oldFullKey.ovrKey)) == null) {
                    diceMap = new HashMap<String, DicedModuleInfo>();
                    dicePerOverlay.put(oldFullKey.ovrKey, diceMap);
                }
                diceMap.put(oldFullKey.modKey, dmi);
            }
            HashMap junkMap = new HashMap();
            Iterator oit = diceOverMap.keySet().iterator();
            while (oit.hasNext()) {
                String oldOvr = (String)oit.next();
                String newID = (String)diceOverMap.get(oldOvr);
                HashMap diceMap = (HashMap)dicePerOverlay.get(oldOvr);
                NetOverlayProperties oldProps = (NetOverlayProperties)legacy.ovrProps_.get(oldOvr);
                NetOverlayProperties justAdded = (NetOverlayProperties)this.ovrProps_.get(newID);
                if (justAdded == null) {
                    justAdded = new NetOverlayProperties(oldProps, newID, junkMap, junkMap, true);
                    this.ovrProps_.put(newID, justAdded);
                }
                Iterator dmit = diceMap.keySet().iterator();
                while (dmit.hasNext()) {
                    String oldModKey = (String)dmit.next();
                    DicedModuleInfo dmi = (DicedModuleInfo)diceMap.get(oldModKey);
                    String newModKey = dmi.fullKey.modKey;
                    NetModuleProperties nmp = justAdded.getNetModuleProperties(newModKey);
                    if (nmp != null) continue;
                    NetModuleProperties oldNmp = oldProps.getNetModuleProperties(oldModKey);
                    NetModuleProperties newNmp = new NetModuleProperties(oldNmp, newModKey, null);
                    int numDS = dmi.dicedShapes.size();
                    ArrayList<Rectangle2D> shapesOnly = new ArrayList<Rectangle2D>();
                    RectangularShape nameShape = null;
                    for (int i = 0; i < numDS; ++i) {
                        NetModuleProperties.TaggedShape ts = (NetModuleProperties.TaggedShape)dmi.dicedShapes.get(i);
                        if (ts.isName) {
                            nameShape = ts.shape;
                            continue;
                        }
                        shapesOnly.add(ts.shape);
                    }
                    if (newNmp.getType() == 0 && shapesOnly.size() == 1) {
                        newNmp.replaceTypeAndShapes(0, shapesOnly);
                    } else {
                        newNmp.replaceTypeAndShapes(1, shapesOnly);
                    }
                    if (nameShape != null) {
                        double centerX = UiUtil.forceToGridValueMin(nameShape.getCenterX(), 10.0);
                        double centerY = UiUtil.forceToGridValueMin(nameShape.getCenterY(), 10.0);
                        Point2D.Double newLoc = new Point2D.Double(centerX, centerY);
                        newNmp.setNameLocation(newLoc);
                    }
                    justAdded.setNetModuleProperties(newModKey, newNmp);
                }
            }
        }
    }

    public void reverseExpansion(Genome genome, FontRenderContext frc, ExpansionReversal reversal, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid routerGrid = router.initGrid(genome, this, frc, null, 1, monitor);
        SortedSet filledRows = routerGrid.getAddedCornerRows(reversal.origGrid, monitor);
        SortedSet filledCols = routerGrid.getAddedCornerCols(reversal.origGrid, monitor);
        reversal.reduce(filledRows, filledCols);
        this.compress(genome, reversal.expandedRows, reversal.expandedCols, null, null, null, null, monitor, startFrac, endFrac);
    }

    public void chooseCompressionRows(Genome genome, FontRenderContext frc, double fracV, double fracH, Rectangle bounds, boolean makeRegionsOpaque, OverlayKeySet fullKeysForLayout, SortedSet useEmptyRows, SortedSet useEmptyCols, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.chooseCompressionRows(genome, frc, fracV, fracH, bounds, makeRegionsOpaque, fullKeysForLayout, useEmptyRows, useEmptyCols, monitor, null);
    }

    private void calcOverlayRequiredRowsAndCols(FontRenderContext frc, OverlayKeySet fullKeysForLayout, Rectangle bounds, SortedSet needRows, SortedSet needCols, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (fullKeysForLayout == null) {
            return;
        }
        Database db = Database.getDB();
        Genome useGenome = db.getGenome(this.targetGenome_);
        HashMap<String, Map> padCache = new HashMap<String, Map>();
        Iterator fkit = fullKeysForLayout.iterator();
        while (fkit.hasNext()) {
            NetModuleProperties nmp;
            DynamicInstanceProxy dip;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)fkit.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
            DynamicInstanceProxy dynamicInstanceProxy = dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            if (nop == null || (nmp = nop.getNetModuleProperties(fullKey.modKey)) == null) continue;
            NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
            NetModule module = no.getModule(fullKey.modKey);
            Map pads = (Map)padCache.get(fullKey.ovrKey);
            boolean firstTime = false;
            if (pads == null) {
                pads = this.getPadEndsForModules(nop, no);
                padCache.put(fullKey.ovrKey, pads);
                firstTime = true;
            }
            NetModuleFree nmf = nmp.getRenderer();
            Set usedPads = (Set)pads.get(fullKey.modKey);
            nmf.needRowsAndCols(useGenome, dip, module, this, fullKey.ovrKey, nmp, frc, bounds, needRows, needCols, usedPads);
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!firstTime) continue;
            Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
                nmlp.needRowsAndCols(needRows, needCols);
                if (monitor == null || monitor.keepGoing()) continue;
                throw new AsynchExitRequestException();
            }
        }
    }

    private void calcOverlayNonExpansion(FontRenderContext frc, Rectangle bounds, SortedSet excludeRows, SortedSet excludeCols, OverlayKeySet fullKeysForLayout, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (fullKeysForLayout == null) {
            return;
        }
        Database db = Database.getDB();
        Genome useGenome = db.getGenome(this.targetGenome_);
        HashMap<String, Map> padCache = new HashMap<String, Map>();
        Iterator fkit = fullKeysForLayout.iterator();
        while (fkit.hasNext()) {
            NetModuleProperties nmp;
            DynamicInstanceProxy dip;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)fkit.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
            DynamicInstanceProxy dynamicInstanceProxy = dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
            NetOverlayProperties nop = this.getNetOverlayProperties(fullKey.ovrKey);
            if (nop == null || (nmp = nop.getNetModuleProperties(fullKey.modKey)) == null) continue;
            NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
            NetModule module = no.getModule(fullKey.modKey);
            Map pads = (Map)padCache.get(fullKey.ovrKey);
            if (pads == null) {
                pads = this.getPadEndsForModules(nop, no);
                padCache.put(fullKey.ovrKey, pads);
            }
            NetModuleFree nmf = nmp.getRenderer();
            Set usedPads = (Set)pads.get(fullKey.modKey);
            nmf.expansionExcludedRowsAndCols(useGenome, dip, module, this, fullKey.ovrKey, nmp, frc, bounds, excludeRows, excludeCols, usedPads);
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
    }

    private Map getPadEndsForModules(NetOverlayProperties nop, NetworkOverlay no) {
        HashMap retval = new HashMap();
        Iterator mpit = nop.getNetModulePropertiesKeys();
        while (mpit.hasNext()) {
            String mkey = (String)mpit.next();
            HashSet inLinks = new HashSet();
            HashSet outLinks = new HashSet();
            no.getNetModuleLinkagesForModule(mkey, inLinks, outLinks);
            HashSet<Point2D> padsForModule = new HashSet<Point2D>();
            Iterator ilit = inLinks.iterator();
            while (ilit.hasNext()) {
                String linkID = (String)ilit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkageProperties(linkID);
                padsForModule.add(nmlp.getTargetEnd(linkID, 0.0));
            }
            Iterator olit = outLinks.iterator();
            while (olit.hasNext()) {
                String linkID = (String)olit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkageProperties(linkID);
                padsForModule.add(nmlp.getSourceStart(0.0));
            }
            retval.put(mkey, padsForModule);
        }
        return retval;
    }

    public void chooseCompressionRows(Genome genome, FontRenderContext frc, double fracV, double fracH, Rectangle bounds, boolean makeRegionsOpaque, OverlayKeySet fullKeysForLayout, SortedSet useEmptyRows, SortedSet useEmptyCols, BTProgressMonitor monitor, Set ignoreNodes) throws AsynchExitRequestException {
        double frac;
        Double floor;
        Object obj;
        int counter;
        int i;
        SortedSet emptyCols;
        SortedSet emptyRows;
        LinkRouter router = new LinkRouter();
        int strictness = fullKeysForLayout == null || fullKeysForLayout.isEmpty() ? 1 : 0;
        LinkPlacementGrid routerGrid = router.initGrid(genome, this, frc, null, strictness, monitor);
        MinMax testedRowRange = new MinMax(Integer.MAX_VALUE, Integer.MIN_VALUE);
        MinMax testedColRange = new MinMax(Integer.MAX_VALUE, Integer.MIN_VALUE);
        if (bounds != null) {
            MinMax xBounds = new MinMax(bounds.x, bounds.x + bounds.width);
            emptyRows = routerGrid.getEmptyRows(xBounds, makeRegionsOpaque, monitor, ignoreNodes, testedRowRange);
            MinMax yBounds = new MinMax(bounds.y, bounds.y + bounds.height);
            emptyCols = routerGrid.getEmptyColumns(yBounds, makeRegionsOpaque, monitor, ignoreNodes, testedColRange);
        } else {
            emptyRows = routerGrid.getEmptyRows(null, makeRegionsOpaque, monitor, ignoreNodes, testedRowRange);
            emptyCols = routerGrid.getEmptyColumns(null, makeRegionsOpaque, monitor, ignoreNodes, testedColRange);
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        TreeSet needRows = new TreeSet();
        TreeSet needCols = new TreeSet();
        this.calcOverlayRequiredRowsAndCols(frc, fullKeysForLayout, bounds, needRows, needCols, monitor);
        if (!needRows.isEmpty()) {
            int minRow = (Integer)needRows.first();
            int maxRow = (Integer)needRows.last();
            for (i = minRow; i <= maxRow; ++i) {
                if (i >= testedRowRange.min && i <= testedRowRange.max) continue;
                emptyRows.add(new Integer(i));
            }
        }
        if (!needCols.isEmpty()) {
            int minCol = (Integer)needCols.first();
            int maxCol = (Integer)needCols.last();
            for (i = minCol; i <= maxCol; ++i) {
                if (i >= testedColRange.min && i <= testedColRange.max) continue;
                emptyCols.add(new Integer(i));
            }
        }
        emptyRows.removeAll(needRows);
        emptyCols.removeAll(needCols);
        HashSet<Double> seenVals = new HashSet<Double>();
        if (fracV != 0.0) {
            Iterator eit = emptyRows.iterator();
            counter = 0;
            while (eit.hasNext()) {
                obj = eit.next();
                if (seenVals.contains(floor = new Double(Math.floor(frac = (double)counter++ * fracV)))) continue;
                useEmptyRows.add(obj);
                seenVals.add(floor);
            }
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        if (fracH != 0.0) {
            Iterator eit = emptyCols.iterator();
            seenVals.clear();
            counter = 0;
            while (eit.hasNext()) {
                obj = eit.next();
                if (seenVals.contains(floor = new Double(Math.floor(frac = (double)counter++ * fracH)))) continue;
                useEmptyCols.add(obj);
                seenVals.add(floor);
            }
        }
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
    }

    public void compress(Genome genome, SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds, Map shapeMap, Map fragMap, String gid, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        Iterator nit = genome.getAllNodeIterator();
        this.compressNodes(emptyRows, emptyCols, nit, bounds, monitor);
        List toProcess = this.listOfProps(genome, null, null);
        int linkCount = toProcess.size();
        double perLink = (endFrac - startFrac) / (double)linkCount;
        double currProg = startFrac;
        for (int i = 0; i < linkCount; ++i) {
            LinkProperties lp = (LinkProperties)toProcess.get(i);
            lp.compress(emptyRows, emptyCols, bounds);
            if (monitor == null || monitor.updateProgress((int)((currProg += perLink) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        this.compressGroupAndNoteProps(emptyRows, emptyCols, bounds);
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String okey = (String)opit.next();
            NetOverlayProperties nop = (NetOverlayProperties)this.ovrProps_.get(okey);
            HashMap oldToNewPerOverlay = null;
            if (shapeMap != null) {
                oldToNewPerOverlay = new HashMap();
                shapeMap.put(okey, oldToNewPerOverlay);
            }
            Map fragForOverlay = fragMap != null && gid != null ? (Map)fragMap.get(okey) : null;
            nop.compressOverlay(emptyRows, emptyCols, bounds, oldToNewPerOverlay, fragForOverlay, gid);
        }
    }

    public void chooseExpansionRows(Genome genome, FontRenderContext frc, double fracV, double fracH, Rectangle bounds, OverlayKeySet fullKeysForLayout, SortedSet insertRows, SortedSet insertCols, boolean reversable, BTProgressMonitor monitor) throws AsynchExitRequestException {
        SortedSet expandCols;
        SortedSet expandRows;
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid routerGrid = router.initGrid(genome, this, frc, null, 1, monitor);
        if (bounds != null) {
            MinMax xBounds = new MinMax(bounds.x, bounds.x + bounds.width);
            expandRows = routerGrid.getExpandableRows(xBounds, reversable, monitor);
            MinMax yBounds = new MinMax(bounds.y, bounds.y + bounds.height);
            expandCols = routerGrid.getExpandableColumns(yBounds, reversable, monitor);
        } else {
            expandRows = routerGrid.getExpandableRows(null, reversable, monitor);
            expandCols = routerGrid.getExpandableColumns(null, reversable, monitor);
        }
        TreeSet<Integer> doNotExpandCols = new TreeSet<Integer>();
        TreeSet<Integer> doNotExpandRows = new TreeSet<Integer>();
        if (!reversable) {
            Iterator nit = genome.getAllNodeIterator();
            while (nit.hasNext()) {
                int i;
                INodeRenderer render;
                Rectangle rect;
                Node node = (Node)nit.next();
                NodeProperties np = this.getNodeProperties(node.getID());
                if (np == null || (rect = (render = np.getRenderer()).getNonExpansionRegion(genome, node, this, frc)) == null) continue;
                for (i = 0; i < rect.width; i += 10) {
                    doNotExpandCols.add(new Integer((rect.x + i) / 10));
                }
                for (i = 0; i < rect.height; i += 10) {
                    doNotExpandRows.add(new Integer((rect.y + i) / 10));
                }
            }
            expandRows.removeAll(doNotExpandRows);
            expandCols.removeAll(doNotExpandCols);
        }
        if (fullKeysForLayout != null) {
            int i;
            int maxEmpty;
            int minEmpty;
            TreeSet excludeRows = new TreeSet();
            TreeSet excludeCols = new TreeSet();
            Rectangle nmBounds = this.getLayoutBoundsForAllOverlays(fullKeysForLayout, genome, frc, true);
            this.calcOverlayNonExpansion(frc, bounds, excludeRows, excludeCols, fullKeysForLayout, monitor);
            if (nmBounds != null) {
                int minRow = nmBounds.y / 10;
                int maxRow = (nmBounds.y + nmBounds.height) / 10;
                TreeSet useVals = new TreeSet();
                if (!expandRows.isEmpty()) {
                    useVals.add(expandRows.first());
                    useVals.add(expandRows.last());
                }
                if (!doNotExpandRows.isEmpty()) {
                    useVals.add(doNotExpandRows.first());
                    useVals.add(doNotExpandRows.last());
                }
                minEmpty = useVals.isEmpty() ? Integer.MAX_VALUE : (Integer)useVals.first();
                maxEmpty = useVals.isEmpty() ? Integer.MIN_VALUE : (Integer)useVals.last();
                for (i = minRow; i <= maxRow; ++i) {
                    if (i >= minEmpty && i <= maxEmpty) continue;
                    expandRows.add(new Integer(i));
                }
            }
            if (nmBounds != null) {
                int minCol = nmBounds.x / 10;
                int maxCol = (nmBounds.x + nmBounds.width) / 10;
                TreeSet useVals = new TreeSet();
                if (!expandCols.isEmpty()) {
                    useVals.add(expandCols.first());
                    useVals.add(expandCols.last());
                }
                if (!doNotExpandCols.isEmpty()) {
                    useVals.add(doNotExpandCols.first());
                    useVals.add(doNotExpandCols.last());
                }
                minEmpty = useVals.isEmpty() ? Integer.MAX_VALUE : (Integer)useVals.first();
                maxEmpty = useVals.isEmpty() ? Integer.MIN_VALUE : (Integer)useVals.last();
                for (i = minCol; i <= maxCol; ++i) {
                    if (i >= minEmpty && i <= maxEmpty) continue;
                    expandCols.add(new Integer(i));
                }
            }
            expandRows.removeAll(excludeRows);
            expandCols.removeAll(excludeCols);
        }
        HashSet<Double> seenVals = new HashSet<Double>();
        Iterator eit = expandRows.iterator();
        int counter = 0;
        while (eit.hasNext()) {
            double frac;
            Double floor;
            Object obj = eit.next();
            if (seenVals.contains(floor = new Double(Math.floor(frac = (double)counter++ * fracV)))) continue;
            insertRows.add(obj);
            seenVals.add(floor);
        }
        eit = expandCols.iterator();
        seenVals.clear();
        counter = 0;
        while (eit.hasNext()) {
            double frac;
            Double floor;
            Object obj = eit.next();
            if (seenVals.contains(floor = new Double(Math.floor(frac = (double)counter++ * fracH)))) continue;
            insertCols.add(obj);
            seenVals.add(floor);
        }
    }

    public void pseudoExpand(Genome genome, SortedSet insertRows, SortedSet insertCols, int mult, FontRenderContext frc, Map shapeMap, Map fragMap, String gid) {
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String okey = (String)opit.next();
            NetOverlayProperties nop = (NetOverlayProperties)this.ovrProps_.get(okey);
            HashMap oldToNewPerOverlay = null;
            if (shapeMap != null) {
                oldToNewPerOverlay = new HashMap();
                shapeMap.put(okey, oldToNewPerOverlay);
            }
            Map fragForOverlay = fragMap != null && gid != null ? (Map)fragMap.get(okey) : null;
            nop.expandOverlay(insertRows, insertCols, mult, oldToNewPerOverlay, fragForOverlay, gid);
        }
        this.expandGroupAndNoteProps(insertRows, insertCols, mult);
    }

    public ExpansionReversal expand(Genome genome, SortedSet insertRows, SortedSet insertCols, int mult, boolean reversable, FontRenderContext frc, Map shapeMap, Map fragMap, String gid, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        Iterator nit = genome.getAllNodeIterator();
        this.expandNodes(genome, insertRows, insertCols, nit, mult, monitor);
        List toProcess = this.listOfProps(genome, null, null);
        int linkCount = toProcess.size();
        double perLink = (endFrac - startFrac) / (double)linkCount;
        double currProg = startFrac;
        for (int i = 0; i < linkCount; ++i) {
            LinkProperties lp = (LinkProperties)toProcess.get(i);
            lp.expand(insertRows, insertCols, mult);
            if (monitor == null || monitor.updateProgress((int)((currProg += perLink) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        Iterator opit = this.ovrProps_.keySet().iterator();
        while (opit.hasNext()) {
            String okey = (String)opit.next();
            NetOverlayProperties nop = (NetOverlayProperties)this.ovrProps_.get(okey);
            HashMap oldToNewPerOverlay = null;
            if (shapeMap != null) {
                oldToNewPerOverlay = new HashMap();
                shapeMap.put(okey, oldToNewPerOverlay);
            }
            Map fragForOverlay = fragMap != null && gid != null ? (Map)fragMap.get(okey) : null;
            nop.expandOverlay(insertRows, insertCols, mult, oldToNewPerOverlay, fragForOverlay, gid);
        }
        this.expandGroupAndNoteProps(insertRows, insertCols, mult);
        ExpansionReversal reverse = null;
        if (reversable) {
            LinkRouter router = new LinkRouter();
            LinkPlacementGrid routerGrid = router.initGrid(genome, this, frc, null, 1, monitor);
            reverse = new ExpansionReversal(insertRows, insertCols, mult, routerGrid);
        }
        return reverse;
    }

    private void compressNodes(SortedSet emptyRows, SortedSet emptyCols, Iterator nit, Rectangle bounds, BTProgressMonitor monitor) throws AsynchExitRequestException {
        double maxY;
        double dVal = 10.0;
        double minX = bounds == null ? 0.0 : (double)bounds.x;
        double maxX = bounds == null ? 0.0 : (double)(bounds.x + bounds.width);
        double minY = bounds == null ? 0.0 : (double)bounds.y;
        double d = maxY = bounds == null ? 0.0 : (double)(bounds.y + bounds.height);
        while (nit.hasNext()) {
            GenomeItem node = (GenomeItem)nit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            NodeProperties np = this.getNodeProperties(node.getID());
            if (np == null) continue;
            Point2D loc = np.getLocation();
            if (bounds != null) {
                double locY = loc.getY();
                double locX = loc.getX();
                if (locY < minY || locY > maxY || locX < minX || locX > maxX) continue;
            }
            Iterator rit = emptyRows.iterator();
            double delta = 0.0;
            while (rit.hasNext()) {
                Integer row = (Integer)rit.next();
                if (!((double)row.intValue() * 10.0 < loc.getY())) continue;
                delta += dVal;
            }
            np.compressRow(delta);
            delta = 0.0;
            Iterator cit = emptyCols.iterator();
            while (cit.hasNext()) {
                Integer col = (Integer)cit.next();
                if (!((double)col.intValue() * 10.0 < loc.getX())) continue;
                delta += dVal;
            }
            np.compressColumn(delta);
        }
    }

    private void compressGroupAndNoteProps(SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds) {
        Iterator nit = this.noteProps_.values().iterator();
        while (nit.hasNext()) {
            NoteProperties np = (NoteProperties)nit.next();
            Point2D loc = np.getLocation();
            Point2D newLoc = UiUtil.compressPoint(loc, emptyRows, emptyCols, bounds);
            if (newLoc == null) continue;
            np.setLocation(newLoc);
        }
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            Point2D newLoc;
            GroupProperties props = (GroupProperties)gpit.next();
            Point2D loc = props.getLabelLocation();
            if (loc == null || (newLoc = UiUtil.compressPoint(loc, emptyRows, emptyCols, bounds)) == null) continue;
            props.setLabelLocation(newLoc);
        }
    }

    private void expandNodes(Genome genome, SortedSet emptyRows, SortedSet emptyCols, Iterator nit, int mult, BTProgressMonitor monitor) throws AsynchExitRequestException {
        double dVal = 10.0 * (double)mult;
        while (nit.hasNext()) {
            GenomeItem node = (GenomeItem)nit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            NodeProperties np = this.getNodeProperties(node.getID());
            if (np == null) continue;
            Point2D loc = np.getLocation();
            Iterator rit = emptyRows.iterator();
            double delta = 0.0;
            while (rit.hasNext()) {
                Integer row = (Integer)rit.next();
                if (!((double)row.intValue() * 10.0 < loc.getY())) continue;
                delta += dVal;
            }
            np.expandRow(delta);
            delta = 0.0;
            Iterator cit = emptyCols.iterator();
            while (cit.hasNext()) {
                Integer col = (Integer)cit.next();
                if (!((double)col.intValue() * 10.0 < loc.getX())) continue;
                delta += dVal;
            }
            np.expandColumn(delta);
        }
    }

    private void expandGroupAndNoteProps(SortedSet emptyRows, SortedSet emptyCols, int mult) {
        Iterator nit = this.noteProps_.values().iterator();
        while (nit.hasNext()) {
            NoteProperties np = (NoteProperties)nit.next();
            Point2D loc = np.getLocation();
            np.setLocation(UiUtil.expandPoint(loc, emptyRows, emptyCols, mult));
        }
        Iterator gpit = this.groupProps_.values().iterator();
        while (gpit.hasNext()) {
            GroupProperties props = (GroupProperties)gpit.next();
            Point2D loc = props.getLabelLocation();
            if (loc == null) continue;
            props.setLabelLocation(UiUtil.expandPoint(loc, emptyRows, emptyCols, mult));
        }
    }

    public PatternGrid partialFillPatternGridWithNodes(Genome genome, FontRenderContext frc, Set useNodes) {
        INodeRenderer render;
        NodeProperties np;
        GenomeItem node;
        PatternGrid retval = new PatternGrid();
        Iterator nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            node = (GenomeItem)nit.next();
            if (useNodes != null && !useNodes.contains(node.getID()) || (np = this.getNodeProperties(node.getID())) == null) continue;
            render = np.getRenderer();
            render.renderToPatternGrid(genome, node, this, frc, retval);
        }
        nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            node = (GenomeItem)nit.next();
            if (useNodes != null && !useNodes.contains(node.getID()) || (np = this.getNodeProperties(node.getID())) == null) continue;
            render = np.getRenderer();
            render.renderToPatternGrid(genome, node, this, frc, retval);
        }
        return retval;
    }

    public PatternGrid fillPatternGridWithNodes(Genome genome, FontRenderContext frc) {
        return this.partialFillPatternGridWithNodes(genome, frc, null);
    }

    public Set discoverNonOrthoLinks(Genome genome, FontRenderContext frc) {
        Iterator lit = genome.getLinkageIterator();
        HashSet<String> linkIDs = new HashSet<String>();
        HashSet<BusProperties> orthoProps = new HashSet<BusProperties>();
        HashSet<BusProperties> nonOrthoProps = new HashSet<BusProperties>();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            BusProperties lp = this.getLinkProperties(link.getID());
            if (orthoProps.contains(lp)) continue;
            if (nonOrthoProps.contains(lp)) {
                linkIDs.add(link.getID());
                continue;
            }
            Set nonOrtho = lp.getNonOrthoSegments(genome, this, frc);
            if (!nonOrtho.isEmpty()) {
                linkIDs.add(link.getID());
                nonOrthoProps.add(lp);
                continue;
            }
            orthoProps.add(lp);
        }
        return linkIDs;
    }

    public Set getLimitedNonOrthoLinks(Genome genome, FontRenderContext frc) {
        HashSet retval = new HashSet();
        List nonOrth = this.getNonOrthoIntersections(genome, frc, null);
        int numNO = nonOrth.size();
        for (int i = 0; i < numNO; ++i) {
            Intersection in = (Intersection)nonOrth.get(i);
            BusProperties bp = this.getLinkProperties(in.getObjectID());
            LinkSegmentID[] segIDs = in.segmentIDsFromIntersect();
            int numSeg = segIDs.length;
            for (int j = 0; j < numSeg; ++j) {
                Set linksThru = bp.resolveLinkagesThroughSegment(segIDs[j], genome);
                retval.addAll(linksThru);
            }
        }
        return retval;
    }

    public void repairStackedCompressionErrors(Genome genome, FontRenderContext frc) {
        List needRepair = this.getNonOrthoIntersections(genome, frc, null);
        int numNR = needRepair.size();
        LinkSegmentID[] segIDs = new LinkSegmentID[1];
        for (int j = 0; j < numNR; ++j) {
            Intersection needit = (Intersection)needRepair.get(j);
            BusProperties bp = this.getLinkProperties(needit.getObjectID());
            MultiSubID msid = (MultiSubID)needit.getSubID();
            Iterator mpit = msid.getParts().iterator();
            while (mpit.hasNext()) {
                double move;
                Point2D mvStart;
                Point2D start;
                Point2D end;
                segIDs[0] = (LinkSegmentID)mpit.next();
                if (segIDs[0].isForSegment()) {
                    LinkSegment moveSeg = bp.getSegment(segIDs[0]);
                    end = moveSeg.getEnd();
                    start = moveSeg.getStart();
                    segIDs[0] = (LinkSegmentID)segIDs[0].clone();
                    if (start.getX() < end.getX()) {
                        segIDs[0].tagIDWithEndpoint("S");
                        mvStart = (Point2D)start.clone();
                        move = end.getY() - start.getY();
                    } else {
                        segIDs[0].tagIDWithEndpoint("E");
                        mvStart = (Point2D)end.clone();
                        move = start.getY() - end.getY();
                    }
                } else {
                    LinkSegment fake = bp.getSegmentGeometryForID(segIDs[0], genome, this, frc, true);
                    end = fake.getEnd();
                    start = fake.getStart();
                    LinkSegmentID parID = bp.getSegmentIDForParent(segIDs[0]);
                    if (parID == null) continue;
                    segIDs[0] = (LinkSegmentID)parID.clone();
                    segIDs[0].tagIDWithEndpoint("E");
                    mvStart = (Point2D)start.clone();
                    move = end.getY() - start.getY();
                }
                bp.moveBusLinkSegments(segIDs, mvStart, 0.0, move);
            }
        }
    }

    public List getNonOrthoIntersections(Genome genome, FontRenderContext frc, String overlayKey) {
        ArrayList retval = new ArrayList();
        if (overlayKey == null) {
            Iterator lit = genome.getLinkageIterator();
            HashSet<BusProperties> seenProps = new HashSet<BusProperties>();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String linkID = link.getID();
                BusProperties lp = this.getLinkProperties(linkID);
                if (seenProps.contains(lp)) continue;
                this.nonOrthoIntersections(genome, lp, frc, retval, linkID);
                seenProps.add(lp);
            }
        } else {
            NetOverlayProperties nop = this.getNetOverlayProperties(overlayKey);
            Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
            while (lmpit.hasNext()) {
                String lkey = (String)lmpit.next();
                NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
                this.nonOrthoIntersections(genome, nmlp, frc, retval, ((LinkProperties)nmlp).getALinkID(genome));
            }
        }
        return retval;
    }

    private void nonOrthoIntersections(Genome genome, LinkProperties lp, FontRenderContext frc, List buildList, String aLinkID) {
        MultiSubID retSub = null;
        Set segs = lp.getNonOrthoSegments(genome, this, frc);
        Iterator sit = segs.iterator();
        while (sit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)sit.next();
            MultiSubID si = new MultiSubID(lsid);
            if (retSub == null) {
                retSub = si;
                continue;
            }
            retSub.merge(si);
        }
        if (retSub != null) {
            buildList.add(new Intersection(aLinkID, retSub, 0.0, true));
        }
    }

    public List getIntersectionsForLinks(Genome genome, FontRenderContext frc, Set linkIDs, boolean uniqueBranchesOnly) {
        LinkageFree lf = new LinkageFree();
        ArrayList<Intersection> retval = new ArrayList<Intersection>();
        HashSet<String> analyzed = new HashSet<String>();
        Iterator lit = linkIDs.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            if (analyzed.contains(linkID)) continue;
            HashSet prohibitedSegs = new HashSet();
            Set shared = this.getSharedItems(linkID);
            HashSet setDiff = new HashSet(shared);
            setDiff.removeAll(linkIDs);
            if (setDiff.isEmpty()) {
                Intersection fullInt = new Intersection(linkID, null, 0.0, true);
                retval.add(fullInt);
                analyzed.addAll(shared);
                continue;
            }
            if (uniqueBranchesOnly) {
                Iterator sit = setDiff.iterator();
                while (sit.hasNext()) {
                    String unwantedID = (String)sit.next();
                    Linkage unwantedLink = genome.getLinkage(unwantedID);
                    Intersection unwantedInter = lf.pathIntersection(genome, unwantedLink, this, frc);
                    prohibitedSegs.addAll(((MultiSubID)unwantedInter.getSubID()).getParts());
                }
            }
            Intersection mergedInter = null;
            MultiSubID mergedMulti = null;
            Iterator sit = shared.iterator();
            while (sit.hasNext()) {
                String sharedID = (String)sit.next();
                if (!linkIDs.contains(sharedID)) continue;
                Linkage sharedLink = genome.getLinkage(sharedID);
                Intersection sharedInter = lf.pathIntersection(genome, sharedLink, this, frc);
                if (mergedInter == null) {
                    mergedInter = sharedInter;
                    mergedMulti = (MultiSubID)mergedInter.getSubID();
                } else {
                    mergedMulti.merge((MultiSubID)sharedInter.getSubID());
                }
                analyzed.add(sharedID);
            }
            if (!prohibitedSegs.isEmpty()) {
                HashSet reduced = new HashSet(mergedMulti.getParts());
                reduced.removeAll(prohibitedSegs);
                mergedInter = new Intersection(mergedInter, new MultiSubID(reduced));
            }
            retval.add(mergedInter);
        }
        return retval;
    }

    public LinkPlacementGrid moduleFillLinkPlacementGrid(Genome genome, FontRenderContext frc, Set skipLinks, OverlayStateOracle oso, String overID, BTProgressMonitor monitor) throws AsynchExitRequestException {
        NetOverlayOwner noo = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID());
        NetworkOverlay nov = noo.getNetworkOverlay(overID);
        DynamicInstanceProxy dip = noo.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)noo : null;
        LinkPlacementGrid retval = new LinkPlacementGrid();
        NetModuleFree nmf = new NetModuleFree();
        NetOverlayProperties nop = this.getNetOverlayProperties(overID);
        Iterator nmpit = nop.getNetModulePropertiesKeys();
        while (nmpit.hasNext()) {
            String key = (String)nmpit.next();
            NetModule module = nov.getModule(key);
            nmf.renderToPlacementGrid(genome, dip, this, module, overID, retval);
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
        PlacementGridRenderer pgr = null;
        Iterator lmpit = nop.getNetModuleLinkagePropertiesKeys();
        while (lmpit.hasNext()) {
            String lkey = (String)lmpit.next();
            NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(lkey);
            if (pgr == null) {
                pgr = (PlacementGridRenderer)nmlp.getRenderer();
            }
            pgr.renderToPlacementGrid(genome, nmlp, this, frc, retval, skipLinks, oso, overID);
            if (monitor == null || monitor.keepGoing()) continue;
            throw new AsynchExitRequestException();
        }
        return retval;
    }

    public LinkPlacementGrid limitedFillLinkPlacementGrid(Genome genome, FontRenderContext frc, Set useNodes, Set skipLinks, int strictness, BTProgressMonitor monitor) throws AsynchExitRequestException {
        INodeRenderer render;
        NodeProperties np;
        GenomeItem node;
        HashMap<String, Integer> targetCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> minPadForGenes = new HashMap<String, Integer>();
        LinkPlacementGrid retval = new LinkPlacementGrid();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            String trg = link.getTarget();
            Integer tcount = (Integer)targetCounts.get(trg);
            Integer newCount = tcount == null ? new Integer(1) : new Integer(tcount + 1);
            targetCounts.put(trg, newCount);
            Node node2 = genome.getNode(trg);
            if (node2.getNodeType() != 4) continue;
            int currPad = link.getLandingPad();
            Integer min = (Integer)minPadForGenes.get(trg);
            if (min != null && currPad >= min) continue;
            minPadForGenes.put(trg, new Integer(currPad));
        }
        Iterator nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            node = (GenomeItem)nit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (useNodes != null && !useNodes.contains(node.getID()) || (np = this.getNodeProperties(node.getID())) == null) continue;
            render = np.getRenderer();
            render.renderToPlacementGrid(genome, node, this, frc, retval, targetCounts, minPadForGenes, strictness);
        }
        nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            node = (GenomeItem)nit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (useNodes != null && !useNodes.contains(node.getID()) || (np = this.getNodeProperties(node.getID())) == null) continue;
            render = np.getRenderer();
            render.renderToPlacementGrid(genome, node, this, frc, retval, targetCounts, null, strictness);
        }
        lit = genome.getLinkageIterator();
        LinkageFree render2 = new LinkageFree();
        HashSet<String> srcs = new HashSet<String>();
        while (lit.hasNext()) {
            BusProperties lp;
            Linkage link = (Linkage)lit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            String src = link.getSource();
            String trg = link.getTarget();
            if (useNodes != null && (!useNodes.contains(src) || !useNodes.contains(trg)) || (lp = this.getLinkProperties(link.getID())) == null || srcs.contains(src)) continue;
            render2.renderToPlacementGrid(genome, lp, this, frc, retval, skipLinks, null, null);
            srcs.add(src);
        }
        if (genome instanceof DBGenome) {
            return retval;
        }
        GenomeInstance gi = (GenomeInstance)genome;
        Iterator git = gi.getGroupIterator();
        GroupFree renderer = new GroupFree();
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            GroupProperties gp = this.getGroupProperties(group.getID());
            if (gp == null || gp.getLayer() != 0) continue;
            renderer.renderToPlacementGrid(genome, group, this, frc, retval);
        }
        return retval;
    }

    public LinkPlacementGrid fillLinkPlacementGrid(Genome genome, FontRenderContext frc, Set skipLinks, int strictness, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return this.limitedFillLinkPlacementGrid(genome, frc, null, skipLinks, strictness, monitor);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("layout");
        return retval;
    }

    public static Layout buildFromXML(String elemName, Attributes attrs) throws IOException {
        int typeVal;
        if (!elemName.equals("layout")) {
            return null;
        }
        String name = null;
        String targGen = null;
        String type = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = val;
                    continue;
                }
                if (key.equals("genome")) {
                    targGen = val;
                    continue;
                }
                if (!key.equals("type")) continue;
                type = val;
            }
        }
        if ((type = type.trim()).equalsIgnoreCase("grid")) {
            typeVal = 1;
        } else if (type.equalsIgnoreCase("ball")) {
            typeVal = 0;
        } else if (type.equalsIgnoreCase("free")) {
            typeVal = 2;
        } else {
            throw new IOException();
        }
        if (name == null || name.trim().equals("")) {
            throw new IOException();
        }
        return new Layout(name, targGen, typeVal);
    }

    public static String getDataLocKeyword() {
        return "dprop";
    }

    public static void dataPropFromXML(Layout layout, Attributes attrs) throws IOException {
        String dKey = null;
        String x = null;
        String y = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals(KEY)) {
                    dKey = val;
                    continue;
                }
                if (key.equals("x")) {
                    x = val;
                    continue;
                }
                if (!key.equals("y")) continue;
                y = val;
            }
        }
        if (dKey == null || x == null || y == null) {
            throw new IOException();
        }
        if ((dKey = dKey.trim()).equals("")) {
            throw new IOException();
        }
        double xPos = 0.0;
        double yPos = 0.0;
        try {
            xPos = Double.parseDouble(x);
            yPos = Double.parseDouble(y);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        layout.dataProps_.put(dKey, new Point2D.Double(xPos, yPos));
    }

    private void copyCore(Layout other, Map groupIDMap) {
        this.name_ = other.name_;
        this.targetGenome_ = other.targetGenome_;
        this.altGenomeSource_ = other.altGenomeSource_;
        this.layout_ = other.layout_;
        this.lmeta_ = (LayoutMetadata)other.lmeta_.clone();
        this.nodeProps_ = new HashMap();
        Iterator npit = other.nodeProps_.keySet().iterator();
        while (npit.hasNext()) {
            String key = (String)npit.next();
            NodeProperties np = (NodeProperties)other.nodeProps_.get(key);
            this.nodeProps_.put(key, (NodeProperties)np.clone());
        }
        HashMap<BusProperties, BusProperties> copyMap = new HashMap<BusProperties, BusProperties>();
        this.linkProps_ = new HashMap();
        Iterator lpit = other.linkProps_.keySet().iterator();
        while (lpit.hasNext()) {
            String key = (String)lpit.next();
            BusProperties lp = (BusProperties)other.linkProps_.get(key);
            BusProperties newProp = (BusProperties)copyMap.get(lp);
            if (newProp == null) {
                newProp = (BusProperties)lp.clone();
                copyMap.put(lp, newProp);
            }
            this.linkProps_.put(key, newProp);
        }
        this.groupProps_ = new HashMap();
        Iterator gpit = other.groupProps_.keySet().iterator();
        while (gpit.hasNext()) {
            GroupProperties newGroup;
            String newKey;
            String key = (String)gpit.next();
            GroupProperties gp = (GroupProperties)other.groupProps_.get(key);
            if (groupIDMap != null) {
                newKey = (String)groupIDMap.get(key);
                newGroup = new GroupProperties(newKey, gp.getOrder(), gp);
            } else {
                newKey = key;
                newGroup = new GroupProperties(gp);
            }
            this.groupProps_.put(newKey, newGroup);
        }
        this.ovrProps_ = new HashMap();
        Iterator mpit = other.ovrProps_.keySet().iterator();
        while (mpit.hasNext()) {
            String key = (String)mpit.next();
            NetOverlayProperties np = (NetOverlayProperties)other.ovrProps_.get(key);
            this.ovrProps_.put(key, (NetOverlayProperties)np.clone());
        }
        this.noteProps_ = new HashMap();
        Iterator ntpit = other.noteProps_.keySet().iterator();
        while (ntpit.hasNext()) {
            String key = (String)ntpit.next();
            NoteProperties np = (NoteProperties)other.noteProps_.get(key);
            this.noteProps_.put(key, (NoteProperties)np.clone());
        }
        this.dataProps_ = new HashMap();
        Iterator dpit = other.dataProps_.keySet().iterator();
        while (dpit.hasNext()) {
            String key = (String)dpit.next();
            Point2D pt = (Point2D)other.dataProps_.get(key);
            if (pt == null) continue;
            this.dataProps_.put(key, pt.clone());
        }
    }

    private void writeNodeProps(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<nprops>");
        TreeSet tsk = new TreeSet(this.nodeProps_.keySet());
        Iterator tskit = tsk.iterator();
        ind.up();
        while (tskit.hasNext()) {
            String key = (String)tskit.next();
            NodeProperties np = (NodeProperties)this.nodeProps_.get(key);
            np.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</nprops>");
    }

    private void writeLinkProps(PrintWriter out, Indenter ind) {
        HashSet<BusProperties> pending = new HashSet<BusProperties>();
        ind.indent();
        out.println("<lprops>");
        TreeSet tsk = new TreeSet(this.linkProps_.keySet());
        Iterator tskit = tsk.iterator();
        ind.up();
        while (tskit.hasNext()) {
            String key = (String)tskit.next();
            BusProperties lp = (BusProperties)this.linkProps_.get(key);
            if (lp == null || pending.contains(lp)) continue;
            pending.add(lp);
            lp.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</lprops>");
    }

    private void writeGroupProps(PrintWriter out, Indenter ind) {
        if (this.groupProps_.size() == 0) {
            return;
        }
        ind.indent();
        out.println("<gprops>");
        TreeSet tsk = new TreeSet(this.groupProps_.keySet());
        Iterator tskit = tsk.iterator();
        ind.up();
        while (tskit.hasNext()) {
            String key = (String)tskit.next();
            GroupProperties gp = (GroupProperties)this.groupProps_.get(key);
            gp.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</gprops>");
    }

    private void writeNoteProps(PrintWriter out, Indenter ind) {
        if (this.noteProps_.size() == 0) {
            return;
        }
        ind.indent();
        out.println("<ntprops>");
        TreeSet tsk = new TreeSet(this.noteProps_.keySet());
        Iterator tskit = tsk.iterator();
        ind.up();
        while (tskit.hasNext()) {
            String key = (String)tskit.next();
            NoteProperties np = (NoteProperties)this.noteProps_.get(key);
            np.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</ntprops>");
    }

    private void writeOverlayProps(PrintWriter out, Indenter ind) {
        if (this.ovrProps_.size() == 0) {
            return;
        }
        ind.indent();
        out.println("<nOvrProps>");
        TreeSet tsk = new TreeSet(this.ovrProps_.keySet());
        Iterator tskit = tsk.iterator();
        ind.up();
        while (tskit.hasNext()) {
            String key = (String)tskit.next();
            NetOverlayProperties nmp = (NetOverlayProperties)this.ovrProps_.get(key);
            nmp.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</nOvrProps>");
    }

    private void writeDataProps(PrintWriter out, Indenter ind) {
        if (this.dataProps_.size() == 0) {
            return;
        }
        ind.indent();
        out.println("<dprops>");
        TreeSet tsk = new TreeSet(this.dataProps_.keySet());
        Iterator dit = tsk.iterator();
        ind.up();
        while (dit.hasNext()) {
            ind.indent();
            String key = (String)dit.next();
            Point2D pt = (Point2D)this.dataProps_.get(key);
            out.print("<dprop key=\"");
            out.print(key);
            out.print("\" x=\"");
            out.print(pt.getX());
            out.print("\" y=\"");
            out.print(pt.getY());
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</dprops>");
    }

    public void undoPreProcess(PropChange propchng, LinkProperties lp, String ovrKey) {
        propchng.layoutKey = this.name_;
        if (ovrKey == null) {
            propchng.orig = (BusProperties)lp.clone();
            propchng.linkIDs = new HashSet();
            Iterator lpit = this.linkProps_.keySet().iterator();
            while (lpit.hasNext()) {
                String nextKey = (String)lpit.next();
                BusProperties tp = (BusProperties)this.linkProps_.get(nextKey);
                if (tp != lp) continue;
                propchng.linkIDs.add(nextKey);
            }
        } else {
            propchng.nopRef = ovrKey;
            propchng.nmlpOrig = (NetModuleLinkageProperties)lp.clone();
        }
    }

    public void undoPostProcess(PropChange propchng, LinkProperties lp, String ovrKey) {
        if (ovrKey == null) {
            propchng.newProps = (BusProperties)lp.clone();
        } else {
            propchng.nmlpNew = (NetModuleLinkageProperties)lp.clone();
        }
    }

    private Genome getGenomeTarget() {
        if (this.altGenomeSource_ == null) {
            return Database.getDB().getGenome(this.targetGenome_);
        }
        return this.altGenomeSource_.getGenome(this.targetGenome_);
    }

    private Genome getRootGenome() {
        if (this.altGenomeSource_ == null) {
            return Database.getDB().getGenome();
        }
        return this.altGenomeSource_.getGenome();
    }

    private static class ShiftAndSide {
        Vector2D shift;
        Vector2D toSide;

        ShiftAndSide(Vector2D shift, Vector2D toSide) {
            this.shift = shift;
            this.toSide = toSide;
        }

        public String toString() {
            return "ShiftAndSide shift = " + this.shift + " side = " + this.toSide;
        }
    }

    public static class PadNeedsForLayout {
        private HashMap map_;

        public PadNeedsForLayout(Map map) {
            this.map_ = map == null ? null : new HashMap(map);
        }

        public Iterator keyIterator() {
            return this.map_ == null ? new HashSet().iterator() : this.map_.keySet().iterator();
        }

        public OverlayKeySet getFullModuleKeys() {
            return this.map_ == null ? null : new OverlayKeySet(this.map_.keySet());
        }

        public NetModuleLinkPadRequirements getPadRequire(NetModule.FullModuleKey key) {
            return this.map_ == null ? null : (NetModuleLinkPadRequirements)this.map_.get(key);
        }
    }

    public static class OverlayKeySet {
        private HashSet keys_;

        OverlayKeySet(OverlayMapForLayout overlayMap) {
            this.keys_ = new HashSet(overlayMap.getMap().keySet());
        }

        public OverlayKeySet() {
            this.keys_ = new HashSet();
        }

        OverlayKeySet(Set keys) {
            this.keys_ = new HashSet(keys);
        }

        public Iterator iterator() {
            return this.keys_.iterator();
        }

        public boolean isEmpty() {
            return this.keys_.isEmpty();
        }

        public void addKey(NetModule.FullModuleKey fmk) {
            this.keys_.add(fmk);
        }

        public OverlayKeySet dropOverlay(String dropOverKey) {
            if (dropOverKey == null) {
                return this;
            }
            OverlayKeySet retval = new OverlayKeySet();
            Iterator mkit = this.keys_.iterator();
            while (mkit.hasNext()) {
                NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)mkit.next();
                if (fullKey.ovrKey.equals(dropOverKey)) continue;
                retval.keys_.add(fullKey);
            }
            return retval;
        }
    }

    public static class OverlayMapForLayout {
        private HashMap map_;

        public OverlayMapForLayout(Map overlayMap) {
            this.map_ = new HashMap(overlayMap);
        }

        Map getMap() {
            return this.map_;
        }
    }

    public static class PointNoPoint
    implements Cloneable {
        public Point2D point;
        public Point2D noPoint;
        public String nodeID;

        PointNoPoint(Point2D point, Point2D noPoint, String nodeID) {
            this.point = (Point2D)point.clone();
            this.noPoint = noPoint == null ? null : (Point2D)noPoint.clone();
            this.nodeID = nodeID;
        }

        public String toString() {
            return "PointNoPoint " + this.point + " " + this.noPoint + " " + this.nodeID;
        }

        public int hashCode() {
            return (this.noPoint == null ? 0 : this.noPoint.hashCode()) + (this.nodeID == null ? 0 : this.nodeID.hashCode()) + this.point.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof PointNoPoint)) {
                return false;
            }
            PointNoPoint otherPNP = (PointNoPoint)other;
            if (!this.point.equals(otherPNP.point)) {
                return false;
            }
            if (this.noPoint == null ? otherPNP.noPoint != null : !this.noPoint.equals(otherPNP.noPoint)) {
                return false;
            }
            if (this.nodeID == null) {
                return otherPNP.nodeID == null;
            }
            return this.nodeID.equals(otherPNP.nodeID);
        }

        public Object clone() {
            try {
                PointNoPoint retval = (PointNoPoint)super.clone();
                retval.point = (Point2D)this.point.clone();
                retval.noPoint = this.noPoint == null ? null : (Point2D)this.noPoint.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }

    public static class NetModuleLinkPadRequirements {
        HashMap treeIDToStarts = new HashMap();
        HashMap linkIDToEnds = new HashMap();
        HashMap linkPadInfo = new HashMap();
        HashSet feedBacks;
        Map rigidMoves = new HashMap();

        NetModuleLinkPadRequirements() {
        }

        public String toString() {
            return "NetModuleLinkPadRequirements " + this.treeIDToStarts.size() + " " + this.linkIDToEnds.size() + " " + this.linkPadInfo.size();
        }
    }

    public class ExpansionReversal {
        public SortedSet expandedRows;
        public SortedSet expandedCols;
        public LinkPlacementGrid origGrid;

        public ExpansionReversal(SortedSet insertRows, SortedSet insertCols, int mult, LinkPlacementGrid grid) {
            this.origGrid = grid;
            this.expandedRows = new TreeSet();
            Iterator irit = insertRows.iterator();
            int counter = 0;
            while (irit.hasNext()) {
                Integer row = (Integer)irit.next();
                int rowVal = row;
                for (int i = 0; i < mult; ++i) {
                    this.expandedRows.add(new Integer(rowVal + counter));
                    ++counter;
                }
            }
            this.expandedCols = new TreeSet();
            Iterator icit = insertCols.iterator();
            counter = 0;
            while (icit.hasNext()) {
                Integer col = (Integer)icit.next();
                int colVal = col;
                for (int i = 0; i < mult; ++i) {
                    this.expandedCols.add(new Integer(colVal + counter));
                    ++counter;
                }
            }
        }

        public void reduce(SortedSet filledRows, SortedSet filledCols) {
            TreeSet<Integer> reducedRows = new TreeSet<Integer>();
            Iterator erit = this.expandedRows.iterator();
            while (erit.hasNext()) {
                Integer row = (Integer)erit.next();
                if (filledRows.contains(row)) continue;
                reducedRows.add(row);
            }
            this.expandedRows = reducedRows;
            TreeSet<Integer> reducedCols = new TreeSet<Integer>();
            Iterator ecit = this.expandedCols.iterator();
            while (ecit.hasNext()) {
                Integer col = (Integer)ecit.next();
                if (filledCols.contains(col)) continue;
                reducedCols.add(col);
            }
            this.expandedCols = reducedCols;
        }
    }

    public class PropChange {
        public NodeProperties nOrig;
        public NodeProperties nNewProps;
        public Set origLinks;
        public Set newLinks;
        public BusProperties orig;
        public BusProperties newProps;
        public String addedLinkID;
        public String removedLinkID;
        public NoteProperties ntOrig;
        public NoteProperties ntNewProps;
        public String dLocKey;
        public Point2D dLocOrig;
        public Point2D dLocNew;
        public GroupProperties grOrig;
        public GroupProperties grNewProps;
        public LayoutMetadata metaOrig;
        public LayoutMetadata newMeta;
        public Set linkIDs;
        public String layoutKey;
        public String nopRef;
        public NetModuleProperties nmpOrig;
        public NetModuleProperties nmpNew;
        public NetModuleLinkageProperties nmlpOrig;
        public NetModuleLinkageProperties nmlpNew;
        public String nmlpTieLinkIDOrig;
        public String nmlpTieTreeIDOrig;
        public String nmlpTieLinkIDNew;
        public String nmlpTieTreeIDNew;
        public NetOverlayProperties nopOrig;
        public NetOverlayProperties nopNew;
        public String droppedTreeID;
    }

    public static class DicedModuleInfo {
        public NetModule.FullModuleKey fullKey;
        public ArrayList dicedShapes;
        public ArrayList dicedRectByRects;

        DicedModuleInfo(NetModule.FullModuleKey fullKey) {
            this.fullKey = fullKey;
            this.dicedShapes = new ArrayList();
            this.dicedRectByRects = new ArrayList();
        }
    }

    public static class OrthoRepairInfo {
        public PropChange[] chgs = null;
        public int failCount;
        public boolean singleSeg;

        public OrthoRepairInfo(int failCount, boolean singleSeg) {
            this.failCount = failCount;
            this.singleSeg = singleSeg;
        }

        void addPropChanges(PropChange[] pc) {
            this.chgs = pc;
        }
    }

    public static class TopoRepairInfo {
        public List changes = new ArrayList();
        public boolean dropped;
        public boolean elim;
        public int topoFix;

        TopoRepairInfo(boolean dropped, boolean elim, int topoFix) {
            this.dropped = dropped;
            this.elim = elim;
            this.topoFix = topoFix;
        }

        public boolean haveAChange() {
            boolean someRepaired = this.topoFix == 1 || this.topoFix == 2;
            return this.dropped || this.elim || someRepaired;
        }

        void addPropChange(PropChange pc) {
            this.changes.add(pc);
        }

        void merge(TopoRepairInfo other) {
            this.dropped = this.dropped || other.dropped;
            this.elim = this.elim || other.elim;
            this.topoFix = LinkProperties.mergeRepairStates(this.topoFix, other.topoFix);
            this.changes.addAll(other.changes);
        }

        public boolean convergenceProblem() {
            return this.topoFix == 3 || this.topoFix == 2;
        }
    }

    public static class InheritedInsertionInfo {
        public LinkSegmentID segID;
        public Point2D pt;

        InheritedInsertionInfo(LinkSegmentID segID, Point2D pt) {
            this.segID = segID;
            this.pt = pt;
        }
    }

    public class InheritedLinkNodeInsertionResult {
        public PropChange[] changes;
        public Map padChanges;
        public NodeInsertionDirective nid;

        InheritedLinkNodeInsertionResult(PropChange[] changes, Map padChanges, NodeInsertionDirective nid) {
            this.changes = changes;
            this.padChanges = padChanges;
            this.nid = nid;
        }
    }

    public class SupplementalDataCoords {
        HashMap dataProps = new HashMap();
        HashMap noteProps = new HashMap();

        SupplementalDataCoords() {
        }
    }
}

