/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class LayoutDataSource
implements Cloneable {
    private String modelID_;
    private String groupID_;
    private HashSet nodeIDs_;
    private int xOffset_;
    private int yOffset_;
    private int xScale_;
    private int yScale_;

    public LayoutDataSource(String modelID, String groupID) {
        this.modelID_ = modelID;
        this.groupID_ = groupID;
        this.xOffset_ = 0;
        this.yOffset_ = 0;
        this.xScale_ = 0;
        this.yScale_ = 0;
        this.nodeIDs_ = new HashSet();
    }

    public LayoutDataSource(String modelID, String groupID, int xOffset, int yOffset, int xScale, int yScale) {
        this.modelID_ = modelID;
        this.groupID_ = groupID;
        this.xOffset_ = xOffset;
        this.yOffset_ = yOffset;
        this.xScale_ = xScale;
        this.yScale_ = yScale;
        this.nodeIDs_ = new HashSet();
    }

    public LayoutDataSource(String modelID, String groupID, String xOffsetStr, String yOffsetStr, String xScaleStr, String yScaleStr) throws IOException {
        this.modelID_ = modelID;
        this.groupID_ = groupID;
        try {
            this.xOffset_ = xOffsetStr == null ? 0 : Integer.parseInt(xOffsetStr);
            this.yOffset_ = yOffsetStr == null ? 0 : Integer.parseInt(yOffsetStr);
            this.xScale_ = xScaleStr == null ? 0 : Integer.parseInt(xScaleStr);
            this.yScale_ = yScaleStr == null ? 0 : Integer.parseInt(yScaleStr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        this.nodeIDs_ = new HashSet();
    }

    public Object clone() {
        try {
            LayoutDataSource retval = (LayoutDataSource)super.clone();
            retval.nodeIDs_ = (HashSet)this.nodeIDs_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getDisplayString() {
        Database db = Database.getDB();
        Genome rootGenome = db.getGenome();
        GenomeInstance gi = (GenomeInstance)db.getGenome(this.modelID_);
        Group newGrp = gi.getGroup(this.groupID_);
        String baseDisplayString = gi.getName() + ": " + newGrp.getInheritedDisplayName(gi);
        if (this.nodeIDs_.isEmpty()) {
            return baseDisplayString;
        }
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator nidit = this.nodeIDs_.iterator();
        while (nidit.hasNext()) {
            String nodeID = (String)nidit.next();
            NodeInstance node = (NodeInstance)gi.getNode(nodeID);
            Node rootNode = (Node)((Object)node.getBacking());
            String display = rootNode.getDisplayString(rootGenome, false);
            nodeNames.add(display);
        }
        int numNodes = nodeNames.size();
        Collections.sort(nodeNames);
        StringBuffer buf = new StringBuffer();
        buf.append(baseDisplayString);
        buf.append(":[");
        for (int i = 0; i < numNodes; ++i) {
            String nodeName = (String)nodeNames.get(i);
            buf.append(nodeName);
            if (i == numNodes - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        int retval = this.modelID_.hashCode() + this.groupID_.hashCode() + this.xOffset_ + this.yOffset_ + this.xScale_ + this.yScale_;
        if (this.nodeIDs_.isEmpty()) {
            return retval;
        }
        return retval += this.nodeIDs_.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof LayoutDataSource)) {
            return false;
        }
        LayoutDataSource otherLDS = (LayoutDataSource)other;
        if (this.xOffset_ != otherLDS.xOffset_ || this.yOffset_ != otherLDS.yOffset_ || this.xScale_ != otherLDS.xScale_ || this.yScale_ != otherLDS.yScale_) {
            return false;
        }
        if (!this.modelID_.equals(otherLDS.modelID_)) {
            return false;
        }
        if (!this.groupID_.equals(otherLDS.groupID_)) {
            return false;
        }
        return this.nodeIDs_.equals(otherLDS.nodeIDs_);
    }

    public boolean overlayCompatable(LayoutDataSource other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.modelID_.equals(other.modelID_)) {
            return false;
        }
        if (this.xScale_ == 0 && other.xScale_ == 0 && this.yScale_ == 0 && other.yScale_ == 0) {
            return this.xOffset_ == other.xOffset_ && this.yOffset_ == other.yOffset_;
        }
        if (this.xScale_ != other.xScale_ || this.yScale_ != other.yScale_) {
            return false;
        }
        return this.nodeIDs_.equals(other.nodeIDs_);
    }

    public boolean isScaled() {
        return this.xScale_ != 0 || this.yScale_ != 0;
    }

    public String getModelID() {
        return this.modelID_;
    }

    public String getGroupID() {
        return this.groupID_;
    }

    public void addNode(String nodeID) {
        this.nodeIDs_.add(nodeID);
    }

    public boolean isNodeSpecific() {
        return !this.nodeIDs_.isEmpty();
    }

    public void dropAllNodes() {
        this.nodeIDs_.clear();
    }

    public Iterator getNodes() {
        return this.nodeIDs_.iterator();
    }

    public int getXOffset() {
        return this.xOffset_;
    }

    public int getYOffset() {
        return this.yOffset_;
    }

    public int getXScale() {
        return this.xScale_;
    }

    public int getYScale() {
        return this.yScale_;
    }

    public void setXOffset(int xOffset) {
        this.xOffset_ = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset_ = yOffset;
    }

    public void setXScale(int xScale) {
        this.xScale_ = xScale;
    }

    public void setYScale(int yScale) {
        this.yScale_ = yScale;
    }

    public boolean haveModelDependency(String modelID) {
        return this.modelID_.equals(modelID);
    }

    public boolean haveGroupDependency(String modelID, String groupID) {
        if (!this.modelID_.equals(modelID)) {
            return false;
        }
        return this.groupID_.equals(groupID);
    }

    public boolean haveNodeDependency(String modelID, String nodeID) {
        if (!this.modelID_.equals(modelID)) {
            return false;
        }
        return this.nodeIDs_.contains(nodeID);
    }

    public boolean removeNodeDependency(String modelID, String nodeID) {
        if (!this.modelID_.equals(modelID)) {
            return false;
        }
        if (this.nodeIDs_.contains(nodeID)) {
            this.nodeIDs_.remove(nodeID);
            return this.nodeIDs_.isEmpty();
        }
        return false;
    }

    public boolean equalsExceptTransforms(LayoutDataSource otherLDS) {
        if (this == otherLDS) {
            return true;
        }
        if (otherLDS == null) {
            return false;
        }
        if (!this.modelID_.equals(otherLDS.modelID_)) {
            return false;
        }
        if (!this.groupID_.equals(otherLDS.groupID_)) {
            return false;
        }
        return this.nodeIDs_.equals(otherLDS.nodeIDs_);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<layoutDataSource");
        out.print(" model=\"");
        out.print(this.modelID_);
        out.print("\" group=\"");
        out.print(this.groupID_);
        if (this.xOffset_ != 0) {
            out.print("\" xOff=\"");
            out.print(this.xOffset_);
        }
        if (this.yOffset_ != 0) {
            out.print("\" yOff=\"");
            out.print(this.yOffset_);
        }
        if (this.xScale_ != 0) {
            out.print("\" xScale=\"");
            out.print(this.xScale_);
        }
        if (this.yScale_ != 0) {
            out.print("\" yScale=\"");
            out.print(this.yScale_);
        }
        if (this.nodeIDs_.isEmpty()) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up().indent();
        out.println("<ldsNodes>");
        ind.up();
        TreeSet sorted = new TreeSet(this.nodeIDs_);
        Iterator nidit = sorted.iterator();
        while (nidit.hasNext()) {
            String nID = (String)nidit.next();
            ind.indent();
            out.print("<ldsNode");
            out.print(" nodeID=\"");
            out.print(nID);
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</ldsNodes>");
        ind.down().indent();
        out.println("</layoutDataSource>");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("layoutDataSource");
        retval.add("ldsNodes");
        return retval;
    }

    public static String nodeIDKeyword() {
        return "ldsNode";
    }

    public static String extractNodeID(String elemName, Attributes attrs) throws IOException {
        return AttributeExtractor.extractAttribute(elemName, attrs, "ldsNode", "nodeID", true);
    }

    public static LayoutDataSource buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("layoutDataSource")) {
            return null;
        }
        String modelID = null;
        String groupID = null;
        String xOffsetStr = null;
        String yOffsetStr = null;
        String xScaleStr = null;
        String yScaleStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("model")) {
                    modelID = val;
                    continue;
                }
                if (key.equals("group")) {
                    groupID = val;
                    continue;
                }
                if (key.equals("xOff")) {
                    xOffsetStr = val;
                    continue;
                }
                if (key.equals("yOff")) {
                    yOffsetStr = val;
                    continue;
                }
                if (key.equals("xScale")) {
                    xScaleStr = val;
                    continue;
                }
                if (!key.equals("yScale")) continue;
                yScaleStr = val;
            }
        }
        if (modelID == null || groupID == null) {
            throw new IOException();
        }
        LayoutDataSource lds = new LayoutDataSource(modelID, groupID, xOffsetStr, yOffsetStr, xScaleStr, yScaleStr);
        return lds;
    }
}

