/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LayoutDataSource;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class LayoutDerivation
implements Cloneable {
    private ArrayList ldsList_ = new ArrayList();
    private boolean swapPads_;
    private boolean forceUniquePads_;
    private int overlayOption_;

    public LayoutDerivation() {
        this.swapPads_ = true;
        this.forceUniquePads_ = true;
        this.overlayOption_ = 1;
    }

    public LayoutDerivation(boolean swapPads, boolean forceUniquePads, int overlayOption) {
        this.swapPads_ = swapPads;
        this.forceUniquePads_ = forceUniquePads;
        this.overlayOption_ = overlayOption;
    }

    public Object clone() {
        try {
            LayoutDerivation retval = (LayoutDerivation)super.clone();
            int num = this.ldsList_.size();
            retval.ldsList_ = new ArrayList();
            for (int i = 0; i < num; ++i) {
                LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
                retval.ldsList_.add(lds.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public boolean haveModelDependency(String modelID) {
        int num = this.ldsList_.size();
        for (int i = 0; i < num; ++i) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (!lds.haveModelDependency(modelID)) continue;
            return true;
        }
        return false;
    }

    public void removeModelDependency(String modelID) {
        int i = 0;
        while (i < this.ldsList_.size()) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (lds.haveModelDependency(modelID)) {
                this.ldsList_.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean haveGroupDependency(String modelID, String groupID) {
        int num = this.ldsList_.size();
        for (int i = 0; i < num; ++i) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (!lds.haveGroupDependency(modelID, groupID)) continue;
            return true;
        }
        return false;
    }

    public void removeGroupDependency(String modelID, String groupID) {
        int i = 0;
        while (i < this.ldsList_.size()) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (lds.haveGroupDependency(modelID, groupID)) {
                this.ldsList_.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean haveNodeDependency(String modelID, String nodeID) {
        int num = this.ldsList_.size();
        for (int i = 0; i < num; ++i) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (!lds.haveNodeDependency(modelID, nodeID)) continue;
            return true;
        }
        return false;
    }

    public void removeNodeDependency(String modelID, String nodeID) {
        int i = 0;
        while (i < this.ldsList_.size()) {
            LayoutDataSource lds = (LayoutDataSource)this.ldsList_.get(i);
            if (lds.removeNodeDependency(modelID, nodeID)) {
                this.ldsList_.remove(i);
                continue;
            }
            ++i;
        }
    }

    public int numDirectives() {
        return this.ldsList_.size();
    }

    public void setDirectives(List ldsList) {
        this.ldsList_.clear();
        int num = ldsList.size();
        for (int i = 0; i < num; ++i) {
            this.ldsList_.add(((LayoutDataSource)ldsList.get(i)).clone());
        }
    }

    public void addDirective(LayoutDataSource lds) {
        this.ldsList_.add(lds);
    }

    public void removeDirective(int i) {
        this.ldsList_.remove(i);
    }

    public void replaceDirective(int i, LayoutDataSource lds) {
        this.ldsList_.remove(i);
        this.ldsList_.add(i, lds);
    }

    public LayoutDataSource getDirective(int i) {
        return (LayoutDataSource)this.ldsList_.get(i);
    }

    public void bumpDirectiveUp(int i) {
        Object selObj = this.ldsList_.remove(i);
        this.ldsList_.add(i - 1, selObj);
    }

    public void bumpDirectiveDown(int i) {
        Object selObj = this.ldsList_.remove(i);
        this.ldsList_.add(i + 1, selObj);
    }

    public boolean containsExactDirective(LayoutDataSource lds) {
        return this.ldsList_.contains(lds);
    }

    public boolean containsDirectiveModuloTransforms(LayoutDataSource lds) {
        int num = this.ldsList_.size();
        for (int i = 0; i < num; ++i) {
            LayoutDataSource chkLds = (LayoutDataSource)this.ldsList_.get(i);
            if (!chkLds.equalsExceptTransforms(lds)) continue;
            return true;
        }
        return false;
    }

    public boolean getSwitchPads() {
        return this.swapPads_;
    }

    public boolean getForceUnique() {
        return this.forceUniquePads_;
    }

    public int getOverlayOption() {
        return this.overlayOption_;
    }

    public void setSwitchPads(boolean swapPads) {
        this.swapPads_ = swapPads;
    }

    public void setForceUnique(boolean forceUniquePads) {
        this.forceUniquePads_ = forceUniquePads;
    }

    public void setOverlayOption(int overlayOption) {
        this.overlayOption_ = overlayOption;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<layoutDerivation");
        if (!this.swapPads_) {
            out.print(" swap=\"false\"");
        }
        if (!this.forceUniquePads_) {
            out.print(" unique=\"false\"");
        }
        out.print(" overlay=\"");
        out.print(NetOverlayProperties.mapToRelayoutTag(this.overlayOption_));
        out.print("\"");
        if (this.ldsList_.isEmpty()) {
            out.println("/>");
            return;
        }
        out.println(">");
        ind.up();
        Iterator ldsit = this.ldsList_.iterator();
        while (ldsit.hasNext()) {
            LayoutDataSource lds = (LayoutDataSource)ldsit.next();
            lds.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</layoutDerivation>");
    }

    public static String keywordOfInterest() {
        return "layoutDerivation";
    }

    public static LayoutDerivation buildFromXML(Attributes attrs) throws IOException {
        String swapPadsStr = "true";
        String forceUniquePadsStr = "true";
        String overlayStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("swap")) {
                    swapPadsStr = val;
                    continue;
                }
                if (key.equals("unique")) {
                    forceUniquePadsStr = val;
                    continue;
                }
                if (!key.equals("overlay")) continue;
                overlayStr = val;
            }
        }
        boolean doSwap = Boolean.valueOf(swapPadsStr);
        boolean doUnique = Boolean.valueOf(swapPadsStr);
        int overOpt = 1;
        if (overlayStr != null) {
            try {
                overOpt = NetOverlayProperties.mapFromRelayoutTag(overlayStr);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        LayoutDerivation ld = new LayoutDerivation(doSwap, doUnique, overOpt);
        return ld;
    }
}

