/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.io.IOException;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutDataSource;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutMetadata;
import org.systemsbiology.biotapestry.ui.NamedColor;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.SingleLinkProperties;
import org.xml.sax.Attributes;

public class LayoutFactory
extends AbstractFactoryClient {
    private String layoutKey_;
    private LayoutMetadata currLmd_;
    private LayoutDerivation currLd_;
    private LayoutDataSource currLds_;
    private Set layoutKeys_ = Layout.keywordsOfInterest();
    private String gPropKey_ = GroupProperties.keywordOfInterest();
    private String ntPropKey_ = NoteProperties.keywordOfInterest();
    private String dataLocKey_ = Layout.getDataLocKeyword();
    private String metadataKey_ = LayoutMetadata.keywordOfInterest();
    private String layoutDeriveKey_ = LayoutDerivation.keywordOfInterest();
    private Set layoutDataKeys_ = LayoutDataSource.keywordsOfInterest();
    private String layoutDataNodeIDKey_ = LayoutDataSource.nodeIDKeyword();

    public LayoutFactory() {
        super(new FactoryWhiteboard());
        FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
        this.installWorker(new NetOverlayProperties.NetOverlayPropertiesWorker(whiteboard), new MyGlue());
        this.installWorker(new BusProperties.BusPropertiesWorker(whiteboard), null);
        this.installWorker(new NodeProperties.NodePropertiesWorker(whiteboard), new MyNodePropsGlue());
        this.installWorker(new SingleLinkProperties.SingleLinkPropertiesWorker(whiteboard), new MySinglePropsGlue());
        this.myKeys_.addAll(this.layoutKeys_);
        this.myKeys_.add("color");
    }

    protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
        if (attrs == null || elemName == null) {
            return null;
        }
        if (elemName.equals("color")) {
            this.createColor(attrs);
            return null;
        }
        if (this.layoutKeys_.contains(elemName)) {
            Layout newLo = Layout.buildFromXML(elemName, attrs);
            if (newLo != null) {
                this.layoutKey_ = newLo.getName();
                Database db = Database.getDB();
                db.addLayout(this.layoutKey_, newLo);
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.layout = newLo;
                board.genome = db.getGenome(newLo.getTarget());
            }
            return null;
        }
        Layout layout = Database.getDB().getLayout(this.layoutKey_);
        if (elemName.equals(this.gPropKey_)) {
            GroupProperties gprop = GroupProperties.buildFromXML(layout, attrs);
            layout.setGroupProperties(gprop.getReference(), gprop);
        } else if (elemName.equals(this.ntPropKey_)) {
            NoteProperties ntprop = NoteProperties.buildFromXML(layout, attrs);
            layout.setNoteProperties(ntprop.getReference(), ntprop);
        } else if (elemName.equals(this.dataLocKey_)) {
            Layout.dataPropFromXML(layout, attrs);
        } else if (elemName.equals(this.metadataKey_)) {
            LayoutMetadata lmd = LayoutMetadata.buildFromXML(attrs);
            if (lmd != null) {
                this.currLmd_ = lmd;
                layout.setMetadata(this.currLmd_);
            }
        } else if (elemName.equals(this.layoutDeriveKey_)) {
            LayoutDerivation ld = LayoutDerivation.buildFromXML(attrs);
            if (ld != null) {
                this.currLd_ = ld;
                this.currLmd_.setDerivation(this.currLd_);
            }
        } else if (this.layoutDataKeys_.contains(elemName)) {
            LayoutDataSource lds = LayoutDataSource.buildFromXML(elemName, attrs);
            if (lds != null) {
                this.currLds_ = lds;
                this.currLd_.addDirective(lds);
            }
        } else if (elemName.equals(this.layoutDataNodeIDKey_)) {
            String nodeID = LayoutDataSource.extractNodeID(elemName, attrs);
            this.currLds_.addNode(nodeID);
        }
        return null;
    }

    private void createColor(Attributes attrs) throws IOException {
        String color = null;
        String name = null;
        String r = null;
        String g = null;
        String b = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("color")) {
                    color = val;
                    continue;
                }
                if (key.equals("name")) {
                    name = val;
                    continue;
                }
                if (key.equals("r")) {
                    r = val;
                    continue;
                }
                if (key.equals("g")) {
                    g = val;
                    continue;
                }
                if (!key.equals("b")) continue;
                b = val;
            }
        }
        if (color == null || r == null || g == null || b == null) {
            throw new IOException();
        }
        if ((color = color.trim()).equals("")) {
            throw new IOException();
        }
        if (name == null) {
            name = color;
        }
        int red = -1;
        int green = -1;
        int blue = -1;
        try {
            red = Integer.parseInt(r);
            green = Integer.parseInt(g);
            blue = Integer.parseInt(b);
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
        if (red < 0 || green < 0 || blue < 0 || red > 255 || green > 255 || blue > 255) {
            throw new IOException();
        }
        Database.getDB().setColor(color, new NamedColor(color, new Color(red, green, blue), name));
    }

    public static class MySinglePropsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            BusProperties bprop = board.busProps;
            String targetTag = bprop.getSingleLinkage();
            layout.setLinkProperties(targetTag, bprop);
            return null;
        }
    }

    public static class MyNodePropsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            NodeProperties nprop = board.nodeProps;
            layout.setNodeProperties(nprop.getReference(), nprop);
            return null;
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            NetOverlayProperties nop = board.netOvrProps;
            layout.setNetOverlayProperties(nop.getReference(), nop);
            return null;
        }
    }
}

