/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.GridElement;
import org.systemsbiology.biotapestry.analysis.GridGrower;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.PlacementElement;
import org.systemsbiology.biotapestry.analysis.RectangleFitter;
import org.systemsbiology.biotapestry.analysis.TopLeftPacker;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutDataSource;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetModuleShapeFixer;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.ui.layouts.LayoutFailureTracker;
import org.systemsbiology.biotapestry.util.AffineCombination;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.PatternPlacerSpiral;
import org.systemsbiology.biotapestry.util.PointAndVec;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LayoutRubberStamper {
    private static final int NO_APPROX_ = -1;
    private static final int X_APPROX_ = 0;
    private static final int Y_APPROX_ = 1;
    private static final int X_AND_Y_APPROX_ = 2;

    public LinkRouter.RoutingResult rubberStampLayout(Layout rootLayout, DBGenome rootGenome, Layout instanceLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, Map savedRegionBounds, Layout origLayout, boolean keepLayout, double startFrac, double maxFrac, Map rememberProps, Map globalPadNeeds) throws AsynchExitRequestException {
        boolean strictOKGroups = false;
        LinkRouter.RoutingResult res = !keepLayout ? this.freshLayout(rootLayout, rootGenome, instanceLayout, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, startFrac, maxFrac, rememberProps, globalPadNeeds, strictOKGroups) : this.incrementalLayout(rootLayout, rootGenome, instanceLayout, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, savedRegionBounds, origLayout, startFrac, maxFrac, rememberProps, strictOKGroups);
        return res;
    }

    public LinkRouter.RoutingResult synchronizeToRootLayout(Layout rootLayout, DBGenome rootGenome, Layout instanceLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, Map savedRegionBounds, Layout origLayout, boolean directCopy, boolean keepLayout, double startFrac, double maxFrac, Map rememberProps, Set targets, Map globalPadNeeds) throws AsynchExitRequestException {
        boolean strictOKGroups = false;
        LinkRouter.RoutingResult res = directCopy ? this.directCopy(rootLayout, instanceLayout, gi, frc, options, loModKeys, moduleShapeRecovery, monitor, startFrac, maxFrac) : (!keepLayout ? this.freshLayout(rootLayout, rootGenome, instanceLayout, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, startFrac, maxFrac, rememberProps, globalPadNeeds, strictOKGroups) : this.synchToExistingLayout(rootLayout, rootGenome, instanceLayout, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, savedRegionBounds, origLayout, startFrac, maxFrac, rememberProps, targets, strictOKGroups));
        return res;
    }

    public void undefinedLayout(LayoutDerivation ld, Set undefinedNodes, Set undefinedLinks, boolean dropFGOnly) {
        GenomeInstance gi;
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        LayoutManager lm = new LayoutManager();
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            undefinedNodes.add(node.getID());
        }
        int numLds = ld.numDirectives();
        HashMap placedBy = new HashMap();
        HashMap placedByInstance = new HashMap();
        HashMap usedGIs = new HashMap();
        HashMap<String, Point2D> nodePositions = new HashMap<String, Point2D>();
        HashSet allNodeSet = new HashSet();
        for (int i = 0; i < numLds; ++i) {
            LayoutDataSource lds = ld.getDirective(i);
            Map nodeMap = this.nodesPerDirective(db, lm, lds, usedGIs, allNodeSet, placedBy, placedByInstance, null);
            String modelID = lds.getModelID();
            gi = (GenomeInstance)db.getGenome(modelID);
            String loKey = lm.getLayout(modelID);
            Layout lo = db.getLayout(loKey);
            Iterator nmit = nodeMap.keySet().iterator();
            while (nmit.hasNext()) {
                String baseID = (String)nmit.next();
                String nodeID = (String)nodeMap.get(baseID);
                Point2D nodeLoc = lo.getNodeProperties(nodeID).getLocation();
                nodePositions.put(baseID, nodeLoc);
            }
        }
        undefinedNodes.removeAll(allNodeSet);
        HashSet orphanedLinks = this.buildOrphans(genome, null);
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            String src = link.getSource();
            String trg = link.getTarget();
            LayoutDataSource slds = (LayoutDataSource)placedBy.get(src);
            LayoutDataSource tlds = (LayoutDataSource)placedBy.get(trg);
            if (slds != null && tlds != null && this.findFoldInExactMatch(db, placedByInstance, slds, tlds, link, src, trg) != null) {
                orphanedLinks.remove(linkID);
                continue;
            }
            if (this.findFoldInRelativeMatch(null, nodePositions, db, lm, ld, link, src, trg) == null) continue;
            orphanedLinks.remove(linkID);
        }
        if (dropFGOnly) {
            HashSet origUndefinedNodes = new HashSet(undefinedNodes);
            undefinedNodes.clear();
            Iterator mit = db.getInstanceIterator();
            while (mit.hasNext()) {
                gi = (GenomeInstance)mit.next();
                if (gi.getVfgParent() != null) continue;
                Iterator unit = origUndefinedNodes.iterator();
                while (unit.hasNext()) {
                    String udnID = (String)unit.next();
                    Set niids = gi.getNodeInstances(udnID);
                    if (niids.isEmpty()) continue;
                    undefinedNodes.add(udnID);
                }
                Iterator olit = orphanedLinks.iterator();
                while (olit.hasNext()) {
                    String udlID = (String)olit.next();
                    Set liids = gi.returnLinkInstanceIDsForBacking(udlID);
                    if (liids.isEmpty()) continue;
                    undefinedLinks.add(udlID);
                }
            }
        } else {
            undefinedLinks.clear();
            undefinedLinks.addAll(orphanedLinks);
        }
    }

    public Set definedByLayout(LayoutDataSource lds) {
        Database db = Database.getDB();
        LayoutManager lm = new LayoutManager();
        HashSet<String> defined = new HashSet<String>();
        GenomeInstance gi = (GenomeInstance)db.getGenome(lds.getModelID());
        String loKey = lm.getLayout(lds.getModelID());
        Layout lo = db.getLayout(loKey);
        Group useGroup = gi.getGroup(lds.getGroupID());
        Iterator mit = useGroup.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember meb = (GroupMember)mit.next();
            String nodeID = meb.getID();
            String baseID = GenomeItemInstance.getBaseID(nodeID);
            NodeProperties np = lo.getNodeProperties(nodeID);
            if (np == null) continue;
            defined.add(baseID);
        }
        return defined;
    }

    public LinkRouter.RoutingResult upwardCopy(Layout rootLayout, DBGenome rootGenome, LayoutDerivation ld, FontRenderContext frc, Map rememberMap, ToolCommands tc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, double startFrac, double maxFrac, UndoSupport support) throws AsynchExitRequestException {
        Linkage link;
        if (monitor != null && !monitor.updateProgress((int)(startFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        int numGp = ld.numDirectives();
        if (numGp == 0) {
            if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return new LinkRouter.RoutingResult();
        }
        int overlayOption = ld.getOverlayOption();
        if (overlayOption == 0) {
            rootLayout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        PadCalculatorToo.UpwardPadSyncData upsd = new PadCalculatorToo.UpwardPadSyncData();
        Database db = Database.getDB();
        LayoutManager lm = new LayoutManager();
        HashMap placedBy = new HashMap();
        HashMap placedByInstance = new HashMap();
        HashMap usedGIs = new HashMap();
        HashMap scaledLayouts = new HashMap();
        HashMap linkMap = new HashMap();
        Layout rloCopy = new Layout(rootLayout);
        double currProg = startFrac;
        double maxAfterPref = (maxFrac - startFrac) * 0.5;
        double perPrefFrac = numGp == 0 ? 0.0 : (maxAfterPref - startFrac) / (double)numGp;
        HashSet allNodeSet = new HashSet();
        for (int i = 0; i < numGp; ++i) {
            LayoutDataSource lds = ld.getDirective(i);
            Map nodeMap = this.nodesPerDirective(db, lm, lds, usedGIs, allNodeSet, placedBy, placedByInstance, upsd);
            String loKey = lm.getLayout(lds.getModelID());
            GenomeInstance gi = (GenomeInstance)db.getGenome(lds.getModelID());
            Layout lo = db.getLayout(loKey);
            lo = this.scaleLayout(lds, lo, scaledLayouts, gi, frc, monitor, currProg, currProg + perPrefFrac);
            rootLayout.extractPartialLayout(nodeMap, linkMap, null, null, null, null, false, true, lo, null, null, null);
            if (monitor == null || monitor.updateProgress((int)((currProg += perPrefFrac) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        HashSet orphanedLinks = this.buildOrphans(rootGenome, rootLayout);
        Iterator lit = rootGenome.getLinkageIterator();
        while (lit.hasNext()) {
            link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            LayoutDataSource slds = (LayoutDataSource)placedBy.get(src);
            LayoutDataSource tlds = (LayoutDataSource)placedBy.get(trg);
            if ((slds == null || tlds == null || !this.foldInExactMatch(rootGenome, rootLayout, db, lm, placedByInstance, slds, tlds, scaledLayouts, link, src, trg, orphanedLinks, upsd, frc)) && !this.foldInRelativeMatch(rootGenome, rootLayout, db, lm, ld, scaledLayouts, link, src, trg, orphanedLinks, upsd, frc)) continue;
        }
        lit = rootGenome.getLinkageIterator();
        while (lit.hasNext()) {
            link = (Linkage)lit.next();
            String linkID = link.getID();
            if (!orphanedLinks.contains(linkID)) continue;
            String src = link.getSource();
            String trg = link.getTarget();
            this.recoverFromOldLayout(rootGenome, rootLayout, rloCopy, link, src, trg, orphanedLinks, upsd, frc);
        }
        if (monitor != null && !monitor.updateProgress((int)(maxAfterPref * 100.0))) {
            throw new AsynchExitRequestException();
        }
        Iterator oit = orphanedLinks.iterator();
        while (oit.hasNext()) {
            String orphanID = (String)oit.next();
            AddCommands.autoAddCrudeLinkProperties(rootGenome, rootLayout, orphanID, null, rememberMap, frc);
        }
        if (ld.getSwitchPads()) {
            tc.upwardSyncAllLinkPads(rootGenome, upsd, support, ld.getForceUnique(), orphanedLinks);
        }
        LayoutOptions options = LayoutOptionsManager.getMgr().getLayoutOptions();
        boolean strictOKGroups = false;
        AddCommands.relayoutLinks(rootGenome, null, rootLayout, frc, options, false, orphanedLinks, monitor, maxAfterPref, maxFrac, strictOKGroups);
        if (moduleShapeRecovery != null && overlayOption != 2) {
            rootLayout.shiftModuleShapesPerParams(loModKeys, moduleShapeRecovery, frc);
        }
        LayoutDerivation ldcopy = (LayoutDerivation)ld.clone();
        rootLayout.setDerivation(ldcopy);
        if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        return new LinkRouter.RoutingResult();
    }

    public Layout expandGroupForUpwardCopy(Layout layout, GenomeInstance gi, String groupID, double fracV, double fracH, FontRenderContext frc, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.33;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.33;
        double eFrac2 = eFrac1 + frac2;
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(gi, layout, linkColors);
        HashSet<String> allGroups = new HashSet<String>();
        allGroups.add(groupID);
        HashMap layouts = new HashMap();
        HashMap oldRegionBounds = new HashMap();
        this.buildGroupLayouts(layout, gi, frc, layouts, oldRegionBounds, allGroups, null, false, false, null, null, null, false, monitor, startFrac, eFrac1);
        Layout grpLo = (Layout)layouts.get(groupID);
        TreeSet insertRows = new TreeSet();
        TreeSet insertCols = new TreeSet();
        grpLo.chooseExpansionRows(gi, frc, fracV, fracH, null, null, insertRows, insertCols, false, monitor);
        grpLo.expand(gi, insertRows, insertCols, 1, false, frc, null, null, null, monitor, eFrac1, eFrac2);
        return grpLo;
    }

    public void expandRootInstanceLayout(Layout layout, GenomeInstance gi, Set groups, double fracV, double fracH, FontRenderContext frc, Layout.PadNeedsForLayout padNeeds, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        StandardExpander stdExp = new StandardExpander(fracV, fracH);
        this.generalizedExpandRootInstanceLayout(layout, gi, groups, stdExp, null, frc, padNeeds, loModKeys, moduleShapeRecovery, options, monitor, startFrac, endFrac, false);
    }

    public Vector2D generalizedExpandRootInstanceLayout(Layout layout, GenomeInstance gi, Set groups, RegionExpander regExp, Set ultimateFailures, FontRenderContext frc, Layout.PadNeedsForLayout padNeeds, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.25;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.25;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.25;
        double eFrac3 = eFrac2 + frac3;
        layout.repairAllTopology(frc, null, null, monitor, startFrac, startFrac);
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(gi, layout, linkColors);
        int overlayOption = options.overlayOption;
        if (overlayOption == 0) {
            layout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        HashSet crossRegion = new HashSet();
        HashSet allGroups = new HashSet();
        HashMap crossTuples = new HashMap();
        this.doGroupOrdering(gi, crossRegion, allGroups, crossTuples);
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid exceptionGrid = router.initGrid(gi, layout, frc, null, 1, monitor);
        Map exempt = exceptionGrid.buildExemptions();
        CrossLinkRecovery recovery = this.extractRecoveryPathsFromOldLayout(gi, crossTuples.keySet(), layout, null, exempt, regExp.getChopDeparts(), regExp.getChopArrives());
        HashMap layouts = new HashMap();
        HashMap oldRegionBounds = new HashMap();
        HashMap<String, Rectangle> newRegionBounds = new HashMap<String, Rectangle>();
        HashMap moduleLinkFragShifts = new HashMap();
        ClaimedAndUnclaimed cauSlices = this.buildGroupLayouts(layout, gi, frc, layouts, oldRegionBounds, allGroups, loModKeys, false, false, null, null, moduleLinkFragShifts, true, monitor, startFrac, eFrac1);
        String nameOwner = cauSlices.whoOwnName();
        HashMap oldToNewShapes = new HashMap();
        this.buildCrossPathRegionAssociations(gi, layout, frc, oldRegionBounds, crossTuples, recovery, null);
        regExp.setup(gi, layout, oldRegionBounds, oldToNewShapes, layouts, frc, moduleLinkFragShifts, loModKeys, recovery, monitor);
        int numG = allGroups.size();
        double fracInc = numG == 0 ? frac2 : frac2 / (double)numG;
        double cFrac = eFrac1;
        Iterator agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            if (groups == null || groups.contains(grpID)) {
                regExp.expandTheRegion(grpID, cFrac, cFrac + fracInc);
            }
            cFrac += fracInc;
            newRegionBounds.put(grpID, regExp.getGroupBounds(grpID));
        }
        this.clipGroupLayouts(newRegionBounds, layouts, oldToNewShapes);
        Map paddings = this.findNewRegionPaddings(crossTuples, 10, recovery, groups);
        Map rememberProps = layout.dropProperties(gi, frc);
        if (!allGroups.isEmpty()) {
            layout.reduceToUnclaimedSlices(loModKeys, cauSlices.unclaimedSlices);
        }
        Map deltas = this.mergeExpandedGroupLayouts(layout, newRegionBounds, oldRegionBounds, layouts, paddings, null, moduleLinkFragShifts, true, nameOwner);
        regExp.setDeltas(deltas);
        if (loModKeys != null && !loModKeys.isEmpty()) {
            NetModuleShapeFixer nmsf = new NetModuleShapeFixer();
            Point2D center = layout.getLayoutCenter(frc, false, null, null, null, null);
            nmsf.pinModuleShapesForGroups(oldToNewShapes, cauSlices.claimedSlices, cauSlices.unclaimedSlices, deltas, center);
            if (!allGroups.isEmpty()) {
                layout.shiftUnclaimedSlices(loModKeys, cauSlices.unclaimedSlices);
            }
        }
        if (groups != null) {
            Iterator lit = allGroups.iterator();
            while (lit.hasNext()) {
                String gpID = (String)lit.next();
                if (groups.contains(gpID)) continue;
                Vector2D delta = (Vector2D)deltas.get(gpID);
                this.pinUnchangedRecoveryPaths(layout, gpID, recovery, delta);
            }
        }
        Map shiftedRecoveryPaths = this.modifyCrossLinksForGrowthOrShrinkage(gi, layout, frc, recovery, newRegionBounds, deltas, paddings);
        LinkRouter.RoutingResult res = this.layoutSomeLinksCore(recovery.recoveredLinks, layout, gi, options, frc, linkColors, monitor, eFrac2, eFrac3, rememberProps, shiftedRecoveryPaths, strictOKGroups);
        HashSet remaining = new HashSet(crossTuples.keySet());
        remaining.removeAll(recovery.recoveredLinks);
        LayoutFailureTracker.reportFailedLinks(res.failedLinks);
        Iterator fit = res.failedLinks.iterator();
        while (fit.hasNext()) {
            String failID = (String)fit.next();
            layout.removeLinkProperties(failID);
        }
        remaining.addAll(res.failedLinks);
        if (remaining.size() > 0) {
            LinkRouter.RoutingResult resF = this.layoutSomeLinksCore(remaining, layout, gi, options, frc, linkColors, monitor, eFrac3, endFrac, rememberProps, null, strictOKGroups);
            if (ultimateFailures != null && !resF.failedLinks.isEmpty()) {
                ultimateFailures.addAll(resF.failedLinks);
            }
        }
        LayoutFailureTracker.postLayoutReport(gi, layout, frc);
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        String loKey = new LayoutManager().getLayout(genome.getID());
        Layout rootLayout = db.getLayout(loKey);
        Vector2D diff = layout.alignToLayout(rootLayout, frc, false, null, null, padNeeds);
        return diff;
    }

    public void compressRootInstanceLayout(Layout layout, GenomeInstance gi, Set groups, double fracV, double fracH, FontRenderContext frc, Layout.PadNeedsForLayout padNeeds, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.1;
        double eFrac1 = startFrac + frac1;
        double frac1a = fullFrac * 0.1;
        double eFrac1a = eFrac1 + frac1a;
        double frac2 = fullFrac * 0.2;
        double eFrac2 = eFrac1a + frac2;
        double frac3 = fullFrac * 0.3;
        double eFrac3 = eFrac2 + frac3;
        double frac4 = fullFrac * 0.2;
        double eFrac4 = eFrac3 + frac4;
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(gi, layout, linkColors);
        int overlayOption = options.overlayCpexOption;
        if (overlayOption == 0) {
            layout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        layout.dropUselessCorners(gi, frc, null, null, startFrac, eFrac1, monitor);
        HashSet crossRegion = new HashSet();
        HashSet allGroups = new HashSet();
        HashMap crossTuples = new HashMap();
        this.doGroupOrdering(gi, crossRegion, allGroups, crossTuples);
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid exceptionGrid = router.initGrid(gi, layout, frc, null, 1, monitor);
        Map exempt = exceptionGrid.buildExemptions();
        CrossLinkRecovery recovery = this.extractRecoveryPathsFromOldLayout(gi, crossTuples.keySet(), layout, null, exempt, null, null);
        HashMap layouts = new HashMap();
        HashMap oldRegionBounds = new HashMap();
        HashMap<String, Rectangle> newRegionBounds = new HashMap<String, Rectangle>();
        HashMap moduleLinkFragShifts = new HashMap();
        ClaimedAndUnclaimed cauSlices = this.buildGroupLayouts(layout, gi, frc, layouts, oldRegionBounds, allGroups, loModKeys, false, false, null, null, moduleLinkFragShifts, true, monitor, eFrac1, eFrac1a);
        String nameOwner = cauSlices.whoOwnName();
        HashMap oldToNewShapes = new HashMap();
        this.buildCrossPathRegionAssociations(gi, layout, frc, oldRegionBounds, crossTuples, recovery, null);
        int numG = allGroups.size();
        double fracInc = numG == 0 ? frac2 : frac2 / (double)numG;
        double cFrac = eFrac1a;
        Iterator agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            Layout grpLo = (Layout)layouts.get(grpID);
            Group grp = gi.getGroup(grpID);
            if (groups == null || groups.contains(grpID)) {
                TreeSet emptyRows = new TreeSet();
                TreeSet emptyCols = new TreeSet();
                Rectangle bounds = (Rectangle)oldRegionBounds.get(grpID);
                layout.chooseCompressionRows(gi, frc, fracV, fracH, bounds, false, loModKeys, emptyRows, emptyCols, monitor);
                HashMap oldToNewShapesPerGroup = new HashMap();
                oldToNewShapes.put(grpID, oldToNewShapesPerGroup);
                grpLo.compress(gi, emptyRows, emptyCols, null, oldToNewShapesPerGroup, moduleLinkFragShifts, grpID, monitor, cFrac, cFrac + fracInc);
                LayoutRubberStamper.expandOrCompressRecoveryPaths(false, grpLo, grpID, emptyRows, emptyCols, 1, recovery);
            }
            cFrac += fracInc;
            Rectangle newBounds = grpLo.getLayoutBoundsForGroup(gi, grp, frc, true);
            newRegionBounds.put(grpID, newBounds);
        }
        HashMap paddings = new HashMap();
        Map rememberProps = layout.dropProperties(gi, frc);
        if (!allGroups.isEmpty()) {
            layout.reduceToUnclaimedSlices(loModKeys, cauSlices.unclaimedSlices);
        }
        int baseGroupOrder = layout.getTopGroupOrder();
        HashMap<String, Vector2D> deltas = new HashMap<String, Vector2D>();
        agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            Layout grpLo = (Layout)layouts.get(grpID);
            Rectangle obounds = (Rectangle)oldRegionBounds.get(grpID);
            Rectangle nbounds = (Rectangle)newRegionBounds.get(grpID);
            double delx = obounds.x - nbounds.x;
            double dely = obounds.y - nbounds.y;
            Vector2D delta = new Vector2D(delx, dely);
            boolean doName = nameOwner != null && nameOwner.equals(grpID);
            layout.mergeLayoutOfRegion(grpLo, delta, true, doName, baseGroupOrder, moduleLinkFragShifts, grpID);
            deltas.put(grpID, delta);
        }
        if (loModKeys != null && !loModKeys.isEmpty()) {
            NetModuleShapeFixer nmsf = new NetModuleShapeFixer();
            Point2D center = layout.getLayoutCenter(frc, false, null, null, null, null);
            nmsf.pinModuleShapesForGroups(oldToNewShapes, cauSlices.claimedSlices, cauSlices.unclaimedSlices, deltas, center);
            if (!allGroups.isEmpty()) {
                layout.shiftUnclaimedSlices(loModKeys, cauSlices.unclaimedSlices);
            }
        }
        if (groups != null) {
            Iterator lit = allGroups.iterator();
            while (lit.hasNext()) {
                String gpID = (String)lit.next();
                if (groups.contains(gpID)) continue;
                Vector2D delta = (Vector2D)deltas.get(gpID);
                this.pinUnchangedRecoveryPaths(layout, gpID, recovery, delta);
            }
        }
        Map shiftedRecoveryPaths = this.modifyCrossLinksForGrowthOrShrinkage(gi, layout, frc, recovery, newRegionBounds, deltas, paddings);
        boolean strictOKGroups = false;
        LinkRouter.RoutingResult res = this.layoutSomeLinksCore(recovery.recoveredLinks, layout, gi, options, frc, linkColors, monitor, eFrac2, eFrac3, rememberProps, shiftedRecoveryPaths, strictOKGroups);
        HashSet remaining = new HashSet(crossTuples.keySet());
        remaining.removeAll(recovery.recoveredLinks);
        Iterator fit = res.failedLinks.iterator();
        while (fit.hasNext()) {
            String failID = (String)fit.next();
            layout.removeLinkProperties(failID);
        }
        remaining.addAll(res.failedLinks);
        if (remaining.size() > 0) {
            this.layoutSomeLinksCore(remaining, layout, gi, options, frc, linkColors, monitor, eFrac2, eFrac3, rememberProps, null, strictOKGroups);
        }
        if (groups == null || ((Object)groups).equals(allGroups)) {
            TreeSet useEmptyRows = new TreeSet();
            TreeSet useEmptyCols = new TreeSet();
            layout.chooseCompressionRows(gi, frc, fracV, fracH, null, true, loModKeys, useEmptyRows, useEmptyCols, monitor);
            layout.compress(gi, useEmptyRows, useEmptyCols, null, null, null, null, monitor, eFrac3, eFrac4);
        }
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        String loKey = new LayoutManager().getLayout(genome.getID());
        Layout rootLayout = db.getLayout(loKey);
        layout.alignToLayout(rootLayout, frc, false, null, null, padNeeds);
    }

    public boolean directCopyOptionAllowed() {
        Database db = Database.getDB();
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (!gi.isRootInstance() || gi.hasZeroOrOneInstancePerNode()) continue;
            return false;
        }
        return true;
    }

    private boolean foldInExactMatch(DBGenome rootGenome, Layout rootLayout, Database db, LayoutManager lm, Map placedByInstance, LayoutDataSource slds, LayoutDataSource tlds, Map scaledLayouts, Linkage link, String src, String trg, Set orphanedLinks, PadCalculatorToo.UpwardPadSyncData upsd, FontRenderContext frc) {
        FoldDirections fd = this.findFoldInExactMatch(db, placedByInstance, slds, tlds, link, src, trg);
        String linkID = link.getID();
        if (fd != null) {
            Layout sslo = (Layout)scaledLayouts.get(slds);
            Layout lo = sslo == null ? db.getLayout(lm.getLayout(slds.getModelID())) : sslo;
            upsd.setForSource(src, fd.giLink.getLaunchPad(), 1);
            upsd.setForTarget(linkID, trg, fd.giLink.getLandingPad());
            this.foldInLinkMatch(rootGenome, rootLayout, lo, fd.iid, fd.giLinkSrc, link, src, trg, orphanedLinks, frc);
            return true;
        }
        return false;
    }

    private FoldDirections findFoldInExactMatch(Database db, Map placedByInstance, LayoutDataSource slds, LayoutDataSource tlds, Linkage link, String src, String trg) {
        String sModelID = slds.getModelID();
        if (!slds.overlayCompatable(tlds)) {
            return null;
        }
        GenomeInstance gi = (GenomeInstance)db.getGenome(sModelID);
        String srcID = (String)placedByInstance.get(src);
        String trgID = (String)placedByInstance.get(trg);
        String linkID = link.getID();
        Set liids = gi.returnLinkInstanceIDsForBacking(linkID);
        Iterator liit = liids.iterator();
        while (liit.hasNext()) {
            String iid = (String)liit.next();
            Linkage giLink = gi.getLinkage(iid);
            String giLinkSrc = giLink.getSource();
            String giLinkTrg = giLink.getTarget();
            if (!giLinkSrc.equals(srcID) || !giLinkTrg.equals(trgID)) continue;
            return new FoldDirections(iid, giLink, giLinkSrc, slds);
        }
        return null;
    }

    private FoldDirections findFoldInRelativeMatch(Layout modifiedRootLayout, Map nodePositions, Database db, LayoutManager lm, LayoutDerivation ld, Linkage link, String src, String trg) {
        Point2D endLoc;
        Point2D startLoc;
        if (modifiedRootLayout != null) {
            NodeProperties snp = modifiedRootLayout.getNodeProperties(src);
            startLoc = snp.getLocation();
            NodeProperties tnp = modifiedRootLayout.getNodeProperties(trg);
            endLoc = tnp.getLocation();
        } else {
            startLoc = (Point2D)nodePositions.get(src);
            endLoc = (Point2D)nodePositions.get(trg);
            if (startLoc == null || endLoc == null) {
                return null;
            }
        }
        Vector2D rootOffset = new Vector2D(endLoc, startLoc);
        String linkID = link.getID();
        HashSet<String> seenGenomes = new HashSet<String>();
        int numld = ld.numDirectives();
        for (int i = 0; i < numld; ++i) {
            String modelID;
            LayoutDataSource lds = ld.getDirective(i);
            if (lds.isScaled() || seenGenomes.contains(modelID = lds.getModelID())) continue;
            seenGenomes.add(modelID);
            GenomeInstance gi = (GenomeInstance)db.getGenome(modelID);
            String loKey = lm.getLayout(modelID);
            Layout lo = db.getLayout(loKey);
            Set liids = gi.returnLinkInstanceIDsForBacking(linkID);
            Iterator liit = liids.iterator();
            while (liit.hasNext()) {
                String iid = (String)liit.next();
                Linkage giLink = gi.getLinkage(iid);
                String giLinkSrc = giLink.getSource();
                String giLinkTrg = giLink.getTarget();
                NodeProperties snp = lo.getNodeProperties(giLinkSrc);
                startLoc = snp.getLocation();
                NodeProperties tnp = lo.getNodeProperties(giLinkTrg);
                endLoc = tnp.getLocation();
                Vector2D instanceOffset = new Vector2D(endLoc, startLoc);
                Vector2D diff = rootOffset.add(instanceOffset.scaled(-1.0));
                if (!(diff.length() < 0.1)) continue;
                return new FoldDirections(iid, giLink, giLinkSrc, lds);
            }
        }
        return null;
    }

    private boolean foldInRelativeMatch(DBGenome rootGenome, Layout rootLayout, Database db, LayoutManager lm, LayoutDerivation ld, Map scaledLayouts, Linkage link, String src, String trg, Set orphanedLinks, PadCalculatorToo.UpwardPadSyncData upsd, FontRenderContext frc) {
        FoldDirections fd = this.findFoldInRelativeMatch(rootLayout, null, db, lm, ld, link, src, trg);
        String linkID = link.getID();
        if (fd != null) {
            Layout slo = (Layout)scaledLayouts.get(fd.lds);
            Layout lo = slo == null ? db.getLayout(lm.getLayout(fd.lds.getModelID())) : slo;
            upsd.setForSource(src, fd.giLink.getLaunchPad(), 1);
            upsd.setForTarget(linkID, trg, fd.giLink.getLandingPad());
            this.foldInLinkMatch(rootGenome, rootLayout, lo, fd.iid, fd.giLinkSrc, link, src, trg, orphanedLinks, frc);
            return true;
        }
        return false;
    }

    private boolean recoverFromOldLayout(Genome genome, Layout newLayout, Layout origLayout, Linkage link, String src, String trg, Set orphanedLinks, PadCalculatorToo.UpwardPadSyncData upsd, FontRenderContext frc) {
        String linkID = link.getID();
        NodeProperties osnp = origLayout.getNodeProperties(src);
        NodeProperties otnp = origLayout.getNodeProperties(trg);
        if (osnp == null || otnp == null) {
            return false;
        }
        Point2D origStartLoc = osnp.getLocation();
        Point2D origEndLoc = otnp.getLocation();
        NodeProperties nsnp = newLayout.getNodeProperties(src);
        Point2D newStartLoc = nsnp.getLocation();
        Vector2D origOffset = new Vector2D(origEndLoc, origStartLoc);
        NodeProperties ntnp = newLayout.getNodeProperties(trg);
        Point2D newEndLoc = ntnp.getLocation();
        Vector2D newOffset = new Vector2D(newEndLoc, newStartLoc);
        Vector2D diff = origOffset.add(newOffset.scaled(-1.0));
        if (diff.length() > 30.0) {
            return false;
        }
        BusProperties bp = origLayout.getLinkProperties(linkID);
        LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
        BusProperties spTree = new BusProperties(bp, (BusDrop)keepDrop);
        Vector2D offset = new Vector2D(origStartLoc, newStartLoc);
        spTree = new BusProperties(spTree, src, linkID, offset);
        if (upsd != null) {
            upsd.setForSource(src, link.getLaunchPad(), 1);
            upsd.setForTarget(linkID, trg, link.getLandingPad());
        }
        newLayout.foldInNewProperty(link, genome, spTree, frc);
        if (orphanedLinks != null) {
            orphanedLinks.remove(linkID);
        }
        return true;
    }

    private List extractPathFromOldLayout(Layout newLayout, Layout origLayout, Linkage link, String src, String trg) {
        String linkID = link.getID();
        NodeProperties osnp = origLayout.getNodeProperties(src);
        NodeProperties otnp = origLayout.getNodeProperties(trg);
        if (osnp == null || otnp == null) {
            return null;
        }
        Point2D origStartLoc = osnp.getLocation();
        Point2D origEndLoc = otnp.getLocation();
        NodeProperties nsnp = newLayout.getNodeProperties(src);
        Point2D newStartLoc = nsnp.getLocation();
        Vector2D origOffset = new Vector2D(origEndLoc, origStartLoc);
        NodeProperties ntnp = newLayout.getNodeProperties(trg);
        Point2D newEndLoc = ntnp.getLocation();
        Vector2D newOffset = new Vector2D(newEndLoc, newStartLoc);
        Vector2D diff = origOffset.add(newOffset.scaled(-1.0));
        if (diff.length() > 30.0) {
            return null;
        }
        BusProperties bp = origLayout.getLinkProperties(linkID);
        if (bp == null) {
            return null;
        }
        LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
        BusProperties spTree = new BusProperties(bp, (BusDrop)keepDrop);
        Vector2D offset = new Vector2D(origStartLoc, newStartLoc);
        spTree = new BusProperties(spTree, src, linkID, offset);
        return spTree.getPointListForSinglePath();
    }

    private CrossLinkRecovery extractRecoveryPathsFromOldLayout(Genome genome, Set todo, Layout origLayout, GenericBPSource bps, Map exemptions, Map chopDeparts, Map chopArrives) {
        if (bps == null) {
            bps = new GenericBPSource(origLayout);
        }
        Vector2D offset = new Vector2D(0.0, 0.0);
        HashSet<String> recoveredLinks = new HashSet<String>();
        Iterator tdit = todo.iterator();
        HashMap<String, PerSrcData> perSrcMap = new HashMap<String, PerSrcData>();
        while (tdit.hasNext()) {
            String linkID = (String)tdit.next();
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            BusProperties bp = bps.getLinkProperties(linkID);
            if (bp == null || bp.isDirect()) continue;
            NodeProperties osnp = origLayout.getNodeProperties(src);
            NodeProperties otnp = origLayout.getNodeProperties(trg);
            if (osnp == null || otnp == null) continue;
            PerSrcData psd = (PerSrcData)perSrcMap.get(src);
            if (psd == null) {
                Map perSrcCD = chopDeparts == null ? null : (Map)chopDeparts.get(src);
                Map perSrcCA = chopArrives == null ? null : (Map)chopArrives.get(src);
                psd = new PerSrcData(bp, perSrcCD, perSrcCA);
                perSrcMap.put(src, psd);
            }
            LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
            BusProperties spTree = new BusProperties(bp, (BusDrop)keepDrop);
            spTree = new BusProperties(spTree, src, linkID, offset);
            PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
            if (pld != null) {
                throw new IllegalStateException();
            }
            pld = new PerLinkData(spTree);
            psd.perLinkMap.put(linkID, pld);
            recoveredLinks.add(linkID);
        }
        return new CrossLinkRecovery(perSrcMap, recoveredLinks, exemptions);
    }

    private void foldInLinkMatch(DBGenome rootGenome, Layout rootLayout, Layout lo, String iid, String giLinkSrc, Linkage link, String src, String trg, Set orphanedLinks, FontRenderContext frc) {
        String linkID = link.getID();
        BusProperties bp = lo.getLinkProperties(iid);
        LinkBusDrop keepDrop = bp.getTargetDrop(iid);
        NodeProperties np = lo.getNodeProperties(giLinkSrc);
        NodeProperties rnps = rootLayout.getNodeProperties(src);
        Point2D startLoc = rnps.getLocation();
        NodeProperties rnpt = rootLayout.getNodeProperties(trg);
        Vector2D offset = new Vector2D(np.getLocation(), startLoc);
        BusProperties spTree = new BusProperties(bp, (BusDrop)keepDrop);
        spTree = new BusProperties(spTree, src, linkID, offset);
        rootLayout.foldInNewProperty(link, rootGenome, spTree, frc);
        orphanedLinks.remove(linkID);
    }

    private Map nodesPerDirective(Database db, LayoutManager lm, LayoutDataSource lds, HashMap usedGIs, HashSet allNodeSet, HashMap placedBy, HashMap placedByInstance, PadCalculatorToo.UpwardPadSyncData upsd) {
        String modelID = lds.getModelID();
        String groupID = lds.getGroupID();
        HashSet<String> usedGroupsForGI = (HashSet<String>)usedGIs.get(modelID);
        if (usedGroupsForGI == null) {
            usedGroupsForGI = new HashSet<String>();
            usedGIs.put(modelID, usedGroupsForGI);
        }
        usedGroupsForGI.add(groupID);
        GenomeInstance gi = (GenomeInstance)db.getGenome(modelID);
        String loKey = lm.getLayout(modelID);
        Layout lo = db.getLayout(loKey);
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        if (lds.isNodeSpecific()) {
            Iterator nit = lds.getNodes();
            while (nit.hasNext()) {
                Integer srcPad;
                String nodeID = (String)nit.next();
                String baseID = GenomeItemInstance.getBaseID(nodeID);
                NodeProperties np = lo.getNodeProperties(nodeID);
                if (np == null || allNodeSet.contains(baseID)) continue;
                allNodeSet.add(baseID);
                nodeMap.put(baseID, nodeID);
                placedBy.put(baseID, lds);
                placedByInstance.put(baseID, nodeID);
                if (upsd == null || (srcPad = gi.getSourcePad(nodeID)) == null) continue;
                upsd.setForSource(baseID, srcPad, Integer.MAX_VALUE);
            }
        } else {
            Group useGroup = gi.getGroup(groupID);
            Iterator mit = useGroup.getMemberIterator();
            while (mit.hasNext()) {
                Integer srcPad;
                GroupMember meb = (GroupMember)mit.next();
                String nodeID = meb.getID();
                String baseID = GenomeItemInstance.getBaseID(nodeID);
                NodeProperties np = lo.getNodeProperties(nodeID);
                if (np == null || allNodeSet.contains(baseID)) continue;
                allNodeSet.add(baseID);
                nodeMap.put(baseID, nodeID);
                placedBy.put(baseID, lds);
                placedByInstance.put(baseID, nodeID);
                if (upsd == null || (srcPad = gi.getSourcePad(nodeID)) == null) continue;
                upsd.setForSource(baseID, srcPad, Integer.MAX_VALUE);
            }
        }
        return nodeMap;
    }

    private Layout scaleLayout(LayoutDataSource lds, Layout origLayout, Map scaledLayouts, GenomeInstance gi, FontRenderContext frc, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        Layout retval = origLayout;
        int xOff = lds.getXOffset();
        int yOff = lds.getYOffset();
        int xSca = lds.getXScale();
        int ySca = lds.getYScale();
        if (xOff != 0 || yOff != 0) {
            retval = new Layout(retval);
            retval.shiftLayout(new Vector2D(xOff, yOff), null);
            scaledLayouts.put(lds, retval);
        }
        if ((double)xSca != 0.0 || (double)ySca != 0.0) {
            retval = this.expandGroupForUpwardCopy(retval, gi, lds.getGroupID(), xSca, ySca, frc, monitor, startFrac, maxFrac);
            scaledLayouts.put(lds, retval);
        }
        return retval;
    }

    private HashSet buildOrphans(Genome rootGenome, Layout rootLayout) {
        HashSet<String> orphanedLinks = new HashSet<String>();
        Iterator lrit = rootGenome.getLinkageIterator();
        while (lrit.hasNext()) {
            Linkage linkR = (Linkage)lrit.next();
            String rootLinkIDR = linkR.getID();
            if (rootLayout != null) {
                rootLayout.removeLinkProperties(rootLinkIDR);
            }
            orphanedLinks.add(rootLinkIDR);
        }
        return orphanedLinks;
    }

    private LinkRouter.RoutingResult directCopy(Layout rootLayout, Layout instanceLayout, GenomeInstance gi, FontRenderContext frc, LayoutOptions options, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        if (monitor != null && !monitor.updateProgress((int)(startFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        int overlayOption = options.overlayOption;
        if (overlayOption == 0) {
            instanceLayout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        Iterator nit = gi.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            String baseID = GenomeItemInstance.getBaseID(nodeID);
            NodeProperties np = rootLayout.getNodeProperties(baseID);
            if (np == null) continue;
            nodeMap.put(nodeID, baseID);
        }
        HashMap<String, String> linkMap = new HashMap<String, String>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            Linkage link = (Linkage)glit.next();
            String linkID = link.getID();
            String baseID = GenomeItemInstance.getBaseID(linkID);
            BusProperties lp = rootLayout.getLinkProperties(baseID);
            if (lp == null) continue;
            linkMap.put(linkID, baseID);
        }
        instanceLayout.extractPartialLayout(nodeMap, linkMap, null, null, null, null, false, true, rootLayout, null, gi, frc);
        if (moduleShapeRecovery != null && overlayOption != 2) {
            instanceLayout.shiftModuleShapesPerParams(loModKeys, moduleShapeRecovery, frc);
        }
        if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        return new LinkRouter.RoutingResult();
    }

    private LinkRouter.RoutingResult freshLayout(Layout rootLayout, DBGenome rootGenome, Layout instanceLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, Map globalPadNeeds, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.25;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.25;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.25;
        double eFrac3 = eFrac2 + frac2;
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(rootGenome, rootLayout, linkColors);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        int overlayOption = options.overlayOption;
        if (overlayOption == 0) {
            instanceLayout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        HashSet crossRegion = new HashSet();
        HashSet allGroups = new HashSet();
        HashMap crossTuples = new HashMap();
        Map regionsByColumn = this.doGroupOrdering(gi, crossRegion, allGroups, crossTuples);
        HashMap layouts = new HashMap();
        HashMap loBounds = new HashMap();
        HashMap moduleLinkFragShifts = new HashMap();
        this.buildGroupLayouts(rootLayout, gi, frc, layouts, loBounds, allGroups, loModKeys, true, false, null, null, moduleLinkFragShifts, false, monitor, startFrac, eFrac1);
        Layout useLayout = options.inheritanceSquash ? new Layout(instanceLayout) : instanceLayout;
        LinkRouter.RoutingResult res = this.iterativeFreshMerge(gi, crossRegion, loBounds, layouts, useLayout, frc, regionsByColumn, options, linkColors, loModKeys, moduleLinkFragShifts, monitor, eFrac1, eFrac2, rememberProps, strictOKGroups);
        if (options.inheritanceSquash) {
            HashMap newLayouts = new HashMap();
            HashMap newLoBounds = new HashMap();
            HashSet<String> oneGroup = new HashSet<String>();
            HashMap squModuleLinkFragShifts = new HashMap();
            int numG = allGroups.size();
            double fracInc = frac3 / (double)numG;
            double cFrac = eFrac2;
            double cfrac1 = fracInc * 0.33;
            double ceFrac1 = cFrac + cfrac1;
            double cfrac2 = fracInc * 0.33;
            double ceFrac2 = ceFrac1 + cfrac2;
            Iterator agit = allGroups.iterator();
            while (agit.hasNext()) {
                String grpID = (String)agit.next();
                Layout squashSource = new Layout(useLayout);
                squashSource.dropUselessCorners(gi, frc, null, null, cFrac, ceFrac1, monitor);
                Rectangle bounds = (Rectangle)loBounds.get(grpID);
                this.boundedSquash(squashSource, gi, frc, bounds, loBounds, monitor, ceFrac1, ceFrac2);
                oneGroup.clear();
                oneGroup.add(grpID);
                this.buildGroupLayouts(squashSource, gi, frc, newLayouts, newLoBounds, oneGroup, loModKeys, false, false, null, null, squModuleLinkFragShifts, true, monitor, ceFrac2, cFrac + fracInc);
                cFrac += fracInc;
            }
            Layout testLayout = new Layout(instanceLayout);
            LinkRouter.RoutingResult res2 = this.iterativeFreshMerge(gi, crossRegion, newLoBounds, newLayouts, testLayout, frc, regionsByColumn, options, linkColors, loModKeys, moduleLinkFragShifts, monitor, eFrac3, endFrac, rememberProps, strictOKGroups);
            if ((res2.linkResult & 2) == 0 || (res.linkResult & 2) != 0) {
                instanceLayout.replaceContents(testLayout);
            } else {
                instanceLayout.replaceContents(useLayout);
            }
        }
        if (moduleShapeRecovery != null && overlayOption != 2) {
            instanceLayout.shiftModuleShapesPerParams(loModKeys, moduleShapeRecovery, frc);
        }
        Layout.PadNeedsForLayout padNeedsForLayout = (Layout.PadNeedsForLayout)globalPadNeeds.get(instanceLayout.getName());
        instanceLayout.alignToLayout(rootLayout, frc, false, null, null, padNeedsForLayout);
        return res;
    }

    private Map doGroupOrdering(GenomeInstance gi, Set crossRegion, Set allGroups, Map crossTuples) {
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            if (!gi.isCrossRegionLink(linkID)) continue;
            GenomeInstance.GroupTuple tup = gi.getCrossRegionTuple(linkID);
            Link cfl = new Link(tup.getSourceGroup(), tup.getTargetGroup());
            crossTuples.put(linkID, cfl);
            crossRegion.add(linkID);
        }
        Iterator rit = gi.getGroupIterator();
        while (rit.hasNext()) {
            Group grp = (Group)rit.next();
            if (grp.isASubset(gi)) continue;
            String grpID = grp.getID();
            allGroups.add(grpID);
        }
        Map regionsByColumn = this.sortRegions(allGroups, crossTuples, gi);
        return regionsByColumn;
    }

    private LinkRouter.RoutingResult incrementalLayout(Layout rootLayout, DBGenome rootGenome, Layout instanceLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, Map savedRegionBounds, Layout origLayout, double startFrac, double endFrac, Map rememberProps, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.25;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.25;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.25;
        double eFrac3 = eFrac2 + frac2;
        int overlayOption = options.overlayOption;
        if (overlayOption == 0) {
            instanceLayout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(rootGenome, rootLayout, linkColors);
        this.buildLinkColorsMap(gi, instanceLayout, linkColors);
        HashSet crossRegion = new HashSet();
        HashSet allGroups = new HashSet();
        HashMap crossTuples = new HashMap();
        this.doGroupOrdering(gi, crossRegion, allGroups, crossTuples);
        HashMap<String, GroupProperties> gpMemory = new HashMap<String, GroupProperties>();
        HashSet<String> existingGroups = new HashSet<String>();
        Iterator agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            GroupProperties gp = instanceLayout.getGroupProperties(grpID);
            if (gp == null) continue;
            existingGroups.add(grpID);
            gpMemory.put(grpID, new GroupProperties(gp));
        }
        HashMap layoutsFromRoot = new HashMap();
        HashMap loFrRtBounds = new HashMap();
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        this.buildGroupLayouts(rootLayout, gi, frc, layoutsFromRoot, loFrRtBounds, allGroups, loModKeys, true, options.inheritanceSquash, gpMemory, null, null, false, monitor, startFrac, eFrac1);
        HashMap<String, Layout> layoutsFromInstance = new HashMap<String, Layout>();
        HashMap loFrInBounds = new HashMap();
        HashMap moduleLinkFragShifts = new HashMap();
        this.buildGroupLayouts(instanceLayout, gi, frc, layoutsFromInstance, loFrInBounds, existingGroups, loModKeys, false, false, null, null, moduleLinkFragShifts, true, monitor, eFrac1, eFrac2);
        HashMap<String, Rectangle> newRegionBounds = new HashMap<String, Rectangle>();
        int numG = allGroups.size();
        double fracInc = numG == 0 ? frac3 : frac3 / (double)numG;
        double cFrac = eFrac2;
        agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            Group grp = gi.getGroup(grpID);
            Layout grloRoot = (Layout)layoutsFromRoot.get(grpID);
            Layout grloInst = (Layout)layoutsFromInstance.get(grpID);
            if (grloInst == null) {
                grloInst = new Layout("junkID", gi.getID());
                layoutsFromInstance.put(grpID, grloInst);
            }
            this.addNewProperties(grloRoot, gi, grp, grloInst, origin, options, frc, linkColors, monitor, cFrac, cFrac + fracInc, rememberProps, strictOKGroups);
            cFrac += fracInc;
            Rectangle grpBounds = grloInst.getLayoutBoundsForGroup(gi, grp, frc, true);
            newRegionBounds.put(grpID, grpBounds);
        }
        LinkRouter router = new LinkRouter();
        HashSet<String> useNodes = new HashSet<String>();
        Iterator ncit = gi.getNodeIterator();
        while (ncit.hasNext()) {
            Node node = (Node)ncit.next();
            String nodeID = node.getID();
            if (origLayout.getNodeProperties(nodeID) == null) continue;
            useNodes.add(nodeID);
        }
        HashSet<String> skipLinks = new HashSet<String>();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            if (origLayout.getLinkProperties(linkID) != null) continue;
            skipLinks.add(linkID);
        }
        LinkPlacementGrid exceptionGrid = router.initLimitedGrid(gi, origLayout, frc, useNodes, skipLinks, 1);
        Map exempt = exceptionGrid.buildExemptions();
        LinkRouter.RoutingResult retval = this.iterativeIncrementalMerge(gi, crossRegion, crossTuples, newRegionBounds, savedRegionBounds, layoutsFromInstance, instanceLayout, frc, options, linkColors, origLayout, false, null, loModKeys, monitor, eFrac3, endFrac, rememberProps, exempt, null, null, moduleLinkFragShifts, strictOKGroups);
        if (moduleShapeRecovery != null && overlayOption != 2) {
            instanceLayout.shiftModuleShapesPerParams(loModKeys, moduleShapeRecovery, frc);
        }
        return retval;
    }

    private LinkRouter.RoutingResult synchToExistingLayout(Layout rootLayout, DBGenome rootGenome, Layout instanceLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Layout.OverlayKeySet loModKeys, Map moduleShapeRecovery, BTProgressMonitor monitor, Map savedRegionBounds, Layout origLayout, double startFrac, double endFrac, Map rememberProps, Set targets, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.25;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.25;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.25;
        double eFrac3 = eFrac2 + frac2;
        HashMap linkColors = new HashMap();
        this.buildLinkColorsMap(rootGenome, rootLayout, linkColors);
        this.buildLinkColorsMap(gi, instanceLayout, linkColors);
        int overlayOption = options.overlayOption;
        if (overlayOption == 0) {
            instanceLayout.convertAllModulesToMemberOnly(loModKeys, frc);
        }
        HashSet crossRegion = new HashSet();
        HashSet allGroups = new HashSet();
        HashMap crossTuples = new HashMap();
        this.doGroupOrdering(gi, crossRegion, allGroups, crossTuples);
        HashMap layoutsToUse = new HashMap();
        HashMap loBounds = new HashMap();
        HashMap<String, GroupProperties> gpMemory = new HashMap<String, GroupProperties>();
        Iterator tgit = targets.iterator();
        while (tgit.hasNext()) {
            String grpID = (String)tgit.next();
            GroupProperties gp = origLayout.getGroupProperties(grpID);
            if (gp == null) continue;
            gpMemory.put(grpID, new GroupProperties(gp));
        }
        HashMap<String, Empties> emptiesForGroup = null;
        if (options.inheritanceSquash) {
            emptiesForGroup = new HashMap<String, Empties>();
            tgit = targets.iterator();
            while (tgit.hasNext()) {
                String grpID = (String)tgit.next();
                Empties empties = new Empties();
                emptiesForGroup.put(grpID, empties);
                this.chooseReducedRootCompression(rootLayout, gi, grpID, frc, empties.emptyRows, empties.emptyCols, monitor);
            }
        }
        this.buildGroupLayouts(rootLayout, gi, frc, layoutsToUse, loBounds, targets, loModKeys, true, options.inheritanceSquash, gpMemory, emptiesForGroup, null, false, monitor, startFrac, eFrac1);
        allGroups.removeAll(targets);
        HashMap moduleLinkFragShifts = new HashMap();
        this.buildGroupLayouts(origLayout, gi, frc, layoutsToUse, loBounds, allGroups, loModKeys, false, false, null, null, moduleLinkFragShifts, true, monitor, eFrac1, eFrac2);
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid exceptionGrid = router.initGrid(gi, origLayout, frc, null, 1, monitor);
        Map exempt = exceptionGrid.buildExemptions();
        HashMap ctTargRecoveryLo = new HashMap();
        HashMap rootBounds = new HashMap();
        this.buildCrossLinkLayouts(rootLayout, gi, frc, ctTargRecoveryLo, crossTuples, targets, rootBounds, options.inheritanceSquash, emptiesForGroup, monitor, eFrac2, eFrac3);
        LinkRouter.RoutingResult retval = this.iterativeIncrementalMerge(gi, crossRegion, crossTuples, loBounds, savedRegionBounds, layoutsToUse, instanceLayout, frc, options, linkColors, origLayout, true, targets, loModKeys, monitor, eFrac3, endFrac, rememberProps, exempt, ctTargRecoveryLo, rootBounds, moduleLinkFragShifts, strictOKGroups);
        if (moduleShapeRecovery != null && overlayOption != 2) {
            instanceLayout.shiftModuleShapesPerParams(loModKeys, moduleShapeRecovery, frc);
        }
        return retval;
    }

    private Set linksIntoTargetRegion(GenomeInstance gi, String srcID, Map crossTuples, String trgRegID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator ctkit = crossTuples.keySet().iterator();
        while (ctkit.hasNext()) {
            Link cfl;
            String linkTargRegion;
            String linkID = (String)ctkit.next();
            Linkage link = gi.getLinkage(linkID);
            if (!link.getSource().equals(srcID) || !trgRegID.equals(linkTargRegion = (cfl = (Link)crossTuples.get(linkID)).getTrg())) continue;
            retval.add(linkID);
        }
        return retval;
    }

    private Point2D lsidToPoint(LinkSegmentID lsid, BusProperties bp) {
        Point2D retval;
        if (bp.isDirect() || lsid.isForEndDrop()) {
            throw new IllegalArgumentException();
        }
        if (lsid.isForStartDrop()) {
            LinkSegment lseg = bp.getRootSegment();
            retval = lseg.getStart();
        } else {
            LinkSegment lseg = bp.getSegment(lsid);
            retval = lseg.getEnd();
        }
        return retval;
    }

    private List lsidToPointList(LinkSegmentID lsid, BusProperties bp, GenomeInstance gi, FontRenderContext frc, Layout lo) {
        Point2D end;
        if (bp.isDirect() || lsid.isForEndDrop()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Point2D> retval = new ArrayList<Point2D>();
        LinkSegment useSeg = lsid.isForStartDrop() ? bp.getSegmentGeometryForID(lsid, gi, lo, frc, false) : bp.getSegment(lsid);
        double length = useSeg.getLength();
        double numPts = length / 10.0;
        double weightInc = 1.0 / numPts;
        Point2D start = useSeg.getStart();
        if (start.equals(end = useSeg.getEnd())) {
            retval.add(start);
            return retval;
        }
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        pts.add(start);
        pts.add(end);
        double[] weights = new double[2];
        weights[0] = 0.0;
        boolean haveEnd = false;
        while (weights[0] <= 1.0) {
            weights[1] = 1.0 - weights[0];
            Point2D combo = AffineCombination.combination(pts, weights, 10.0);
            if (combo.equals(end)) {
                haveEnd = true;
            }
            retval.add(combo);
            weights[0] = weights[0] + weightInc;
        }
        if (!haveEnd) {
            retval.add(end);
        }
        return retval;
    }

    private Set getTargetChopSegments(GenomeInstance gi, BusProperties bp, Layout lo, Rectangle bounds, Set linksToTarg, FontRenderContext frc) {
        double bMinX = bounds.getMinX();
        double bMinY = bounds.getMinY();
        double bMaxX = bounds.getMaxX();
        double bMaxY = bounds.getMaxY();
        Point2D[] boundPts = new Point2D[]{new Point2D.Double(bMinX, bMinY), new Point2D.Double(bMaxX, bMinY), new Point2D.Double(bMaxX, bMaxY), new Point2D.Double(bMinX, bMaxY)};
        if (bp.isDirect()) {
            bp.splitNoSegmentBus(gi, lo, frc);
        }
        HashSet<LinkSegmentID> retval = new HashSet<LinkSegmentID>();
        Iterator lttit = linksToTarg.iterator();
        while (lttit.hasNext()) {
            String linkID = (String)lttit.next();
            LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
            List sid2root = bp.getSegmentIDsToRootForEndDrop(keepDrop);
            int numSeg = sid2root.size();
            LinkSegmentID lastPoint = null;
            LinkSegmentID breakPoint = null;
            for (int i = 1; i < numSeg; ++i) {
                LinkSegmentID lsid = (LinkSegmentID)sid2root.get(i);
                Point2D chkLoc = this.lsidToPoint(lsid, bp);
                double clx = chkLoc.getX();
                double cly = chkLoc.getY();
                if (!(clx > bMinX && clx < bMaxX && cly > bMinY && cly < bMaxY)) {
                    breakPoint = lsid;
                    break;
                }
                lastPoint = lsid;
            }
            if (breakPoint != null && lastPoint != null) {
                LinkSegmentID[] splitIDs;
                LinkProperties.DistancedLinkSegID dsnlsid;
                int endIndex;
                Point2D interLoc = null;
                Point2D line1pt1 = this.lsidToPoint(breakPoint, bp);
                Point2D line1pt2 = this.lsidToPoint(lastPoint, bp);
                for (int i = 0; i < 4 && (interLoc = UiUtil.lineIntersection(line1pt1, line1pt2, boundPts[i], boundPts[endIndex = (i + 1) % 4])) == null; ++i) {
                }
                if (interLoc != null && (dsnlsid = bp.intersectBusSegment(gi, null, lo, interLoc, frc, null, 0.1)) != null && !dsnlsid.segID.isTaggedWithEndpoint() && (splitIDs = bp.linkSplitSupport(dsnlsid.segID, interLoc)) != null) {
                    breakPoint = splitIDs[0];
                }
            }
            if (breakPoint == null) {
                breakPoint = LinkSegmentID.buildIDForStartDrop();
            }
            retval.add(breakPoint);
        }
        return retval;
    }

    private boolean segInATargetRegion(Point2D chkLoc, Map allBounds, Set targRegions) {
        Iterator trit = targRegions.iterator();
        while (trit.hasNext()) {
            String trid = (String)trit.next();
            Rectangle bounds = (Rectangle)allBounds.get(trid);
            if (!bounds.contains(chkLoc)) continue;
            return true;
        }
        return false;
    }

    private List parameterizeSourceWhips(BusProperties bp, Rectangle bounds, Set linksForSource, Map allBounds, Set targRegions, GenomeInstance gi, FontRenderContext frc, Layout lo) {
        ArrayList<WhipCandidate> retval = new ArrayList<WhipCandidate>();
        if (bp.isDirect()) {
            System.err.println("Unexpected direct linkProp");
            return retval;
        }
        HashMap whipTracker = new HashMap();
        Iterator lttit = linksForSource.iterator();
        String linkID = null;
        while (lttit.hasNext()) {
            linkID = (String)lttit.next();
            LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
            List sid2root = bp.getSegmentIDsToRootForEndDrop(keepDrop);
            int numSeg = sid2root.size();
            for (int i = numSeg - 1; i > 0; --i) {
                LinkSegmentID lsid = (LinkSegmentID)sid2root.get(i);
                if (lsid.isForEndDrop()) continue;
                ArrayList<WhipCandidate> whipsForKey = (ArrayList<WhipCandidate>)whipTracker.get(lsid);
                if (whipsForKey != null) {
                    int numWhips = whipsForKey.size();
                    for (int j = 0; j < numWhips; ++j) {
                        WhipCandidate wc = (WhipCandidate)whipsForKey.get(j);
                        wc.addSupportedLink(linkID);
                    }
                    continue;
                }
                List chkList = this.lsidToPointList(lsid, bp, gi, frc, lo);
                int numChk = chkList.size();
                for (int j = 1; j < numChk; ++j) {
                    Point2D chkLoc = (Point2D)chkList.get(j);
                    if (this.segInATargetRegion(chkLoc, allBounds, targRegions)) continue;
                    RegionBasedPosition rbp = this.closestPointOnBoundary(chkLoc, bounds);
                    WhipCandidate wc = new WhipCandidate(chkLoc, lsid, rbp, linkID);
                    whipsForKey = new ArrayList<WhipCandidate>();
                    whipsForKey.add(wc);
                    whipTracker.put(lsid, whipsForKey);
                    retval.add(wc);
                }
            }
        }
        if (retval.isEmpty()) {
            LinkSegmentID lsid = LinkSegmentID.buildIDForStartDrop();
            Point2D chkLoc = this.lsidToPoint(lsid, bp);
            RegionBasedPosition rbp = this.closestPointOnBoundary(chkLoc, bounds);
            retval.add(new WhipCandidate(chkLoc, lsid, rbp, linkID));
        }
        return retval;
    }

    private void doTreeMerge(String srcID, GenomeInstance gi, Layout origLayout, BusProperties origBp, FontRenderContext frc, Map mergedSegsPerSource, Map allTmprs) {
        HashMap mergedSegs = (HashMap)mergedSegsPerSource.get(srcID);
        if (mergedSegs == null) {
            mergedSegs = new HashMap();
            mergedSegsPerSource.put(srcID, mergedSegs);
        }
        ArrayList<LinkProperties.GlueJob> glueJobs = new ArrayList<LinkProperties.GlueJob>();
        ArrayList<TreeSpliceData> stubTsds = new ArrayList<TreeSpliceData>();
        Iterator atkit = allTmprs.keySet().iterator();
        while (atkit.hasNext()) {
            String trgGrpID = (String)atkit.next();
            TreeMergePerRegion tmpr = (TreeMergePerRegion)allTmprs.get(trgGrpID);
            Iterator stubit = tmpr.targStubs.keySet().iterator();
            while (stubit.hasNext()) {
                LinkSegment lseg;
                LinkSegmentID targLsid = (LinkSegmentID)stubit.next();
                Point2D dicePt = (Point2D)tmpr.dicePts.get(targLsid);
                RegionBasedPosition targStubRbp = (RegionBasedPosition)tmpr.targStubs.get(targLsid);
                LinkProperties.DistancedLinkSegID dswhipSeg = origBp.intersectBusSegment(gi, null, origLayout, dicePt, frc, null, 10.0);
                if (dswhipSeg.segID.startEndpointIsTagged()) {
                    if (dswhipSeg.segID.isForSegment()) {
                        lseg = origBp.getSegment(dswhipSeg.segID);
                        String parent = lseg.getParent();
                        if (parent != null) {
                            origBp.getSegment(parent);
                            dswhipSeg.segID = LinkSegmentID.buildIDForSegment(parent);
                            dswhipSeg.segID.tagIDWithEndpoint("E");
                        }
                    } else if (dswhipSeg.segID.isForEndDrop()) {
                        LinkBusDrop drop = origBp.getDrop(dswhipSeg.segID);
                        dswhipSeg.segID = LinkSegmentID.buildIDForSegment(drop.getConnectionTag());
                        dswhipSeg.segID.tagIDWithEndpoint("E");
                        if (drop.getConnectionSense() == 0) {
                            throw new IllegalStateException();
                        }
                    }
                }
                lseg = origBp.getSegmentGeometryForID(dswhipSeg.segID, gi, origLayout, frc, false);
                String aLinkID = (String)tmpr.linksToTarg.iterator().next();
                Linkage aLink = gi.getLinkage(aLinkID);
                String aTrgID = aLink.getTarget();
                Vector2D run = lseg.getRun();
                boolean isCanonical = run == null ? false : run.isCanonical();
                TreeSpliceData stubTsd = new TreeSpliceData(isCanonical, run, targStubRbp, trgGrpID, aTrgID);
                Set resolved = tmpr.bp.resolveLinkagesThroughSegment(targLsid, gi);
                BusProperties newProps = (BusProperties)tmpr.bp.breakTreePortionToNewSource(targLsid, resolved, null, null);
                LinkSegmentID taggedWhip = (LinkSegmentID)dswhipSeg.segID.clone();
                glueJobs.add(new LinkProperties.GlueJob(newProps, taggedWhip));
                stubTsds.add(stubTsd);
            }
        }
        origBp.mergeReplacementSubTreesToTreeAtSegment(glueJobs, gi, frc);
        int numGlue = glueJobs.size();
        for (int i = 0; i < numGlue; ++i) {
            LinkProperties.GlueJob glueJob = (LinkProperties.GlueJob)glueJobs.get(i);
            TreeSpliceData stubTsd = (TreeSpliceData)stubTsds.get(i);
            HashSet resolved = new HashSet(glueJob.newProps.getLinkageList());
            LinkSegmentID whipSeg = (LinkSegmentID)glueJob.taggedWhip.clone();
            whipSeg.clearTaggedEndpoint();
            this.tagForRecovery(resolved, whipSeg, origBp, mergedSegs, stubTsd);
        }
    }

    private void tagForRecovery(Set resolved, LinkSegmentID srcLsid, BusProperties origBp, Map mergedSegs, TreeSpliceData stubTsd) {
        LinkSegmentID lastLsid = null;
        Iterator rit = resolved.iterator();
        while (rit.hasNext()) {
            LinkSegmentID lsid;
            String linkID = (String)rit.next();
            LinkBusDrop keepDrop = origBp.getTargetDrop(linkID);
            List sid2root = origBp.getSegmentIDsToRootForEndDrop(keepDrop);
            int num2root = sid2root.size();
            for (int i = 0; i < num2root && !(lsid = (LinkSegmentID)sid2root.get(i)).equals(srcLsid); ++i) {
                mergedSegs.put(lsid, new TreeSpliceData(stubTsd.trgGrpID, stubTsd.trgNodeID));
                lastLsid = lsid;
            }
        }
        if (lastLsid != null) {
            mergedSegs.put(lastLsid, stubTsd);
        }
    }

    private WhipCandidate bestWhipToStubSplice(RegionBasedPosition targStubRbp, List sourceWhips) {
        RegionBasedSorter rbs = new RegionBasedSorter(targStubRbp, sourceWhips);
        if (rbs.hasNext()) {
            return (WhipCandidate)rbs.next();
        }
        return null;
    }

    private void synthMergedTrees(GenomeInstance gi, Map crossTuples, Set srcsToDo, Layout origLayout, Map targetLayouts, Map rootBounds, Map targetBounds, Map synthLayouts, Map mergedSegsPerSource, FontRenderContext frc) {
        HashMap<String, Set> linksToTargForTarg = new HashMap<String, Set>();
        Iterator sit = srcsToDo.iterator();
        while (sit.hasNext()) {
            String srcID = (String)sit.next();
            linksToTargForTarg.clear();
            Set linksForSource = gi.getOutboundLinks(srcID);
            BusProperties origBp = (BusProperties)origLayout.getBusForSource(srcID).clone();
            if (origBp.isDirect()) {
                origBp.splitNoSegmentBus(gi, origLayout, frc);
            }
            Iterator grit = targetLayouts.keySet().iterator();
            while (grit.hasNext()) {
                String trgGrpID = (String)grit.next();
                Set linksToTarg = this.linksIntoTargetRegion(gi, srcID, crossTuples, trgGrpID);
                if (linksToTarg.isEmpty()) continue;
                linksToTargForTarg.put(trgGrpID, linksToTarg);
            }
            HashMap<String, TreeMergePerRegion> allTmprs = new HashMap<String, TreeMergePerRegion>();
            Iterator glrit = linksToTargForTarg.keySet().iterator();
            while (glrit.hasNext()) {
                String trgGrpID = (String)glrit.next();
                Set linksToTarg = (Set)linksToTargForTarg.get(trgGrpID);
                Layout loForTrgReg = (Layout)targetLayouts.get(trgGrpID);
                Rectangle rootBoundsForTrgReg = (Rectangle)rootBounds.get(trgGrpID);
                Rectangle targBoundsForTrgReg = (Rectangle)targetBounds.get(trgGrpID);
                String aLinkID = (String)linksToTarg.iterator().next();
                BusProperties bp = loForTrgReg.getLinkProperties(aLinkID);
                List actualLinks = bp.getLinkageList();
                if (!actualLinks.contains(aLinkID)) continue;
                Set targChopSegs = this.getTargetChopSegments(gi, bp, loForTrgReg, rootBoundsForTrgReg, linksToTarg, frc);
                HashMap<LinkSegmentID, RegionBasedPosition> targStubs = new HashMap<LinkSegmentID, RegionBasedPosition>();
                Iterator tcsit = targChopSegs.iterator();
                while (tcsit.hasNext()) {
                    LinkSegmentID segID = (LinkSegmentID)tcsit.next();
                    Point2D nextPt = this.lsidToPoint(segID, bp);
                    RegionBasedPosition rbp = this.closestPointOnBoundary(nextPt, rootBoundsForTrgReg);
                    targStubs.put(segID, rbp);
                }
                List sourceWhips = this.parameterizeSourceWhips(origBp, targBoundsForTrgReg, linksForSource, targetBounds, linksToTargForTarg.keySet(), gi, frc, origLayout);
                Map dicePts = this.sliceAndDiceWhips(origBp, sourceWhips, targStubs, gi, origLayout, frc);
                TreeMergePerRegion tmpr = new TreeMergePerRegion(bp, dicePts, targStubs, trgGrpID, linksToTarg);
                allTmprs.put(trgGrpID, tmpr);
            }
            this.doTreeMerge(srcID, gi, origLayout, origBp, frc, mergedSegsPerSource, allTmprs);
            synthLayouts.put(srcID, origBp);
        }
    }

    private Map sliceAndDiceWhips(BusProperties bp, List sourceWhips, Map targStubs, GenomeInstance gi, Layout lo, FontRenderContext frc) {
        HashMap<LinkSegmentID, Point2D> retval = new HashMap<LinkSegmentID, Point2D>();
        Iterator stubit = targStubs.keySet().iterator();
        while (stubit.hasNext()) {
            LinkSegmentID[] splitIDs;
            LinkSegmentID targLsid = (LinkSegmentID)stubit.next();
            RegionBasedPosition targStubRbp = (RegionBasedPosition)targStubs.get(targLsid);
            WhipCandidate whipCand = this.bestWhipToStubSplice(targStubRbp, sourceWhips);
            LinkProperties.DistancedLinkSegID dsnlsid = bp.intersectBusSegment(gi, null, lo, whipCand.point, frc, null, 10.0);
            boolean didSplit = false;
            if (dsnlsid != null && !dsnlsid.segID.isTaggedWithEndpoint() && (splitIDs = bp.linkSplitSupport(dsnlsid.segID, whipCand.point)) != null) {
                Point2D nextPt = this.lsidToPoint(splitIDs[0], bp);
                retval.put(targLsid, nextPt);
                didSplit = true;
            }
            if (didSplit) continue;
            retval.put(targLsid, whipCand.point);
        }
        return retval;
    }

    private LinkRouter.RoutingResult iterativeIncrementalMerge(GenomeInstance gi, Set crossRegion, Map crossTuples, Map newRegionBounds, Map savedRegionBounds, Map layoutsFromInstance, Layout targetLayout, FontRenderContext frc, LayoutOptions options, Map linkColors, Layout origLayout, boolean recoveryMerge, Set changingGroups, Layout.OverlayKeySet loModKeys, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, Map exemptions, Map syncLayouts, Map rootRegionBounds, Map moduleLinkFragShifts, boolean strictOKGroups) throws AsynchExitRequestException {
        HashSet<String> todo = new HashSet<String>();
        HashSet<String> srcsToDo = new HashSet<String>();
        Iterator ctit = crossRegion.iterator();
        while (ctit.hasNext()) {
            String linkID = (String)ctit.next();
            if (targetLayout.getLinkProperties(linkID) != null) continue;
            todo.add(linkID);
            Linkage link = gi.getLinkage(linkID);
            srcsToDo.add(link.getSource());
        }
        GenericBPSource gbps = null;
        HashMap mergedSegsPerSource = null;
        if (syncLayouts != null) {
            HashMap synthLayouts = new HashMap();
            mergedSegsPerSource = new HashMap();
            this.synthMergedTrees(gi, crossTuples, srcsToDo, origLayout, syncLayouts, rootRegionBounds, savedRegionBounds, synthLayouts, mergedSegsPerSource, frc);
            gbps = new GenericBPSource(synthLayouts, gi);
        }
        CrossLinkRecovery recovery = this.extractRecoveryPathsFromOldLayout(gi, crossTuples.keySet(), origLayout, gbps, exemptions, null, null);
        this.buildCrossPathRegionAssociations(gi, origLayout, frc, savedRegionBounds, crossTuples, recovery, mergedSegsPerSource);
        int numRegions = layoutsFromInstance.size();
        int numCross = crossRegion.size();
        double borderSizeD = (double)numCross / (double)numRegions * 2.0;
        int borderSizeBase = (int)Math.ceil(borderSizeD == 0.0 ? 2.0 : borderSizeD);
        int[][] passes = new int[][]{{0, 0}, {0, 1}, {2 * borderSizeBase, 0}, {3 * borderSizeBase, 0}, {3 * borderSizeBase, 1}, {3 * borderSizeBase, 2}};
        int numPasses = 1;
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / (double)numPasses;
        Layout holdFirstLayout = null;
        HashMap holdFirstBounds = null;
        LinkRouter.RoutingResult holdFirstRes = null;
        boolean basePass = true;
        for (int passNum = 0; passNum < numPasses; ++passNum) {
            Layout useLayout = new Layout("temp", gi.getID());
            HashMap useBounds = new HashMap();
            this.copyResultsBack(targetLayout, useLayout, newRegionBounds, useBounds);
            int border = passes[passNum][0];
            int mult = passes[passNum][1];
            LinkRouter.RoutingResult res = this.incrementalMerges(todo, crossTuples, border, mult, gi, useBounds, savedRegionBounds, layoutsFromInstance, useLayout, frc, options, linkColors, origLayout, recovery, recoveryMerge, changingGroups, loModKeys, moduleLinkFragShifts, monitor, currProg, currProg + progInc, rememberProps, gbps, strictOKGroups);
            currProg += progInc;
            if ((res.linkResult & 2) != 0) {
                if (!basePass) continue;
                basePass = false;
                Set targCollide = gi.hasLinkTargetPadCollisions();
                if (!targCollide.isEmpty()) {
                    this.copyResultsBack(useLayout, targetLayout, useBounds, newRegionBounds);
                    return res;
                }
                holdFirstLayout = useLayout;
                holdFirstBounds = useBounds;
                holdFirstRes = res;
                continue;
            }
            this.copyResultsBack(useLayout, targetLayout, useBounds, newRegionBounds);
            return res;
        }
        this.copyResultsBack(holdFirstLayout, targetLayout, holdFirstBounds, newRegionBounds);
        return holdFirstRes;
    }

    private LinkRouter.RoutingResult incrementalMerges(Set todo, Map crossTuples, int boundary, int mult, GenomeInstance gi, Map newRegionBounds, Map savedRegionBounds, Map layoutsFromInstance, Layout targetLayout, FontRenderContext frc, LayoutOptions options, Map linkColors, Layout origLayout, CrossLinkRecovery recovery, boolean recoveryMerge, Set changingGroups, Layout.OverlayKeySet loModKeys, Map moduleLinkFragShifts, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, GenericBPSource bps, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.33;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.33;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.33;
        double eFrac3 = eFrac2 + frac3;
        HashMap<String, Layout> useLayouts = layoutsFromInstance;
        HashMap<String, Rectangle> useBounds = newRegionBounds;
        HashMap<String, Integer> useBoundaries = new HashMap<String, Integer>();
        Iterator git = layoutsFromInstance.keySet().iterator();
        while (git.hasNext()) {
            String gpID = (String)git.next();
            useBoundaries.put(gpID, new Integer(boundary * 10));
        }
        if (mult > 0) {
            useLayouts = new HashMap<String, Layout>();
            useBounds = new HashMap<String, Rectangle>();
            Set lfiSet = layoutsFromInstance.keySet();
            int size = lfiSet.size();
            double currProg = startFrac;
            double progInc = frac1 / (double)size;
            Iterator lit = lfiSet.iterator();
            while (lit.hasNext()) {
                String gpID = (String)lit.next();
                Group grp = gi.getGroup(gpID);
                Layout currLO = (Layout)layoutsFromInstance.get(gpID);
                Layout etempLayout = new Layout(currLO);
                useLayouts.put(gpID, etempLayout);
                Rectangle bounds = (Rectangle)newRegionBounds.get(gpID);
                useBounds.put(gpID, bounds);
                TreeSet insertRows = new TreeSet();
                TreeSet insertCols = new TreeSet();
                etempLayout.chooseExpansionRows(gi, frc, 1.0, 1.0, null, loModKeys, insertRows, insertCols, false, monitor);
                etempLayout.expand(gi, insertRows, insertCols, mult, true, frc, null, moduleLinkFragShifts, gpID, monitor, currProg, currProg + progInc);
                LayoutRubberStamper.expandOrCompressRecoveryPaths(true, etempLayout, gpID, insertRows, insertCols, mult, recovery);
                currProg += progInc;
                bounds = etempLayout.getLayoutBoundsForGroup(gi, grp, frc, true);
                useBounds.put(gpID, bounds);
            }
        }
        ArrayList fixedElements = new ArrayList();
        Map deltas = this.mergeExpandedGroupLayouts(targetLayout, useBounds, savedRegionBounds, useLayouts, useBoundaries, fixedElements, moduleLinkFragShifts, false, null);
        Set lfiSet = layoutsFromInstance.keySet();
        Iterator lit = lfiSet.iterator();
        while (lit.hasNext()) {
            String gpID = (String)lit.next();
            Vector2D delta = (Vector2D)deltas.get(gpID);
            this.pinUnchangedRecoveryPaths(targetLayout, gpID, recovery, delta);
        }
        if (recoveryMerge) {
            this.recoveryMerge(recovery, gi, origLayout, targetLayout, frc, deltas, changingGroups, bps);
        }
        Set allRegions = useBounds.keySet();
        Set fixedRegions = savedRegionBounds.keySet();
        ArrayList<PlacementElement> floatingElems = new ArrayList<PlacementElement>();
        Iterator arit = allRegions.iterator();
        while (arit.hasNext()) {
            String gid = (String)arit.next();
            if (fixedRegions.contains(gid)) continue;
            Rectangle newBounds = (Rectangle)((Rectangle)useBounds.get(gid)).clone();
            UiUtil.forceToGrid(newBounds, 10.0);
            PlacementElement newPe = new PlacementElement(newBounds, gid);
            floatingElems.add(newPe);
        }
        RectangleFitter rfit = new RectangleFitter();
        ArrayList links = new ArrayList(crossTuples.values());
        rfit.placeElements(fixedElements, floatingElems, links, boundary, monitor);
        int baseGroupOrder = targetLayout.getTopGroupOrder();
        int flnum = floatingElems.size();
        for (int i = 0; i < flnum; ++i) {
            PlacementElement pe = (PlacementElement)floatingElems.get(i);
            Rectangle preShift = (Rectangle)useBounds.get(pe.id);
            double deltaX = UiUtil.forceToGridValue(pe.rect.x - preShift.x, 10.0);
            double deltaY = UiUtil.forceToGridValue(pe.rect.y - preShift.y, 10.0);
            Vector2D delta = new Vector2D(deltaX, deltaY);
            Layout currLO = (Layout)useLayouts.get(pe.id);
            targetLayout.mergeLayoutOfRegion(currLO, delta, false, false, baseGroupOrder, moduleLinkFragShifts, pe.id);
        }
        if (todo.isEmpty()) {
            if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return new LinkRouter.RoutingResult();
        }
        HashSet stillToDo = new HashSet(todo);
        HashSet stillToDoWithRecovery = new HashSet(recovery.recoveredLinks);
        Map shiftedRecoveryPaths = this.modifyCrossLinksForGrowthOrShrinkage(gi, targetLayout, frc, recovery, useBounds, deltas, useBoundaries);
        stillToDo.removeAll(stillToDoWithRecovery);
        LinkRouter.RoutingResult res1 = this.layoutSomeLinksCore(stillToDoWithRecovery, targetLayout, gi, options, frc, linkColors, monitor, eFrac1, eFrac2, rememberProps, shiftedRecoveryPaths, strictOKGroups);
        Iterator fit = res1.failedLinks.iterator();
        while (fit.hasNext()) {
            String failID = (String)fit.next();
            targetLayout.removeLinkProperties(failID);
        }
        stillToDo.addAll(res1.failedLinks);
        LinkRouter.RoutingResult res = this.layoutSomeLinksCore(stillToDo, targetLayout, gi, options, frc, linkColors, monitor, eFrac2, eFrac3, rememberProps, null, strictOKGroups);
        return res;
    }

    private void recoveryMerge(CrossLinkRecovery recovery, GenomeInstance gi, Layout origLayout, Layout newLayout, FontRenderContext frc, Map deltas, Set changingGroups, GenericBPSource bps) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            NodeProperties osnp = origLayout.getNodeProperties(srcID);
            NodeProperties nsnp = newLayout.getNodeProperties(srcID);
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            Iterator ppit = psd.perPointMap.keySet().iterator();
            while (ppit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)ppit.next();
                PerPointData ppd = (PerPointData)psd.perPointMap.get(lsid);
                if (ppd.fixedLinkID != null) {
                    LinkSegmentID[] splitIDs;
                    Vector2D delta;
                    Point2D oldLoc;
                    LinkSegment lseg;
                    BusProperties obp;
                    BusProperties nbp = newLayout.getLinkProperties(ppd.fixedLinkID);
                    BusProperties busProperties = obp = bps != null ? bps.getLinkProperties(ppd.fixedLinkID) : origLayout.getLinkProperties(ppd.fixedLinkID);
                    if (lsid.isForStartDrop()) {
                        lseg = obp.getRootSegment();
                        oldLoc = lseg.getStart();
                    } else {
                        lseg = obp.getSegment(lsid);
                        oldLoc = lseg.getEnd();
                        if (oldLoc == null) {
                            oldLoc = lseg.getStart();
                        }
                    }
                    Point2D movedLoc = (Point2D)oldLoc.clone();
                    if (deltas != null && (delta = (Vector2D)deltas.get(ppd.regionID)) != null) {
                        movedLoc = delta.add(oldLoc);
                    }
                    LinkProperties.DistancedLinkSegID dsnlsid = nbp.intersectBusSegment(gi, null, newLayout, movedLoc, frc, null, 0.1);
                    boolean didSplit = false;
                    if (dsnlsid != null && !dsnlsid.segID.isTaggedWithEndpoint() && (splitIDs = nbp.linkSplitSupport(dsnlsid.segID, movedLoc)) != null) {
                        ppd.newRef = splitIDs[0];
                        ppd.dof = null;
                        didSplit = true;
                    }
                    if (didSplit || dsnlsid != null) continue;
                    ppd.refNodeID = srcID;
                    ppd.offset = new Vector2D(osnp.getLocation(), movedLoc);
                    ppd.fixedLinkID = null;
                    Group grp = gi.getGroupForNode(srcID, 1);
                    ppd.regionID = grp.getID();
                    psd.assocRegions.add(grp.getID());
                    continue;
                }
                if (ppd.regionBased == null || ppd.regionBased.partialDefinition == null || changingGroups != null && !changingGroups.contains(ppd.regionID)) continue;
                ppd.regionBased.partialDefinition = null;
            }
        }
    }

    private LinkRouter.RoutingResult iterativeFreshMerge(GenomeInstance gi, Set crossRegion, Map loBounds, Map layouts, Layout targetLayout, FontRenderContext frc, Map regionsByColumn, LayoutOptions options, Map linkColors, Layout.OverlayKeySet loModKeys, Map moduleLinkFragShifts, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, boolean strictOKGroups) throws AsynchExitRequestException {
        HashSet<String> todo = new HashSet<String>();
        Iterator ctit = crossRegion.iterator();
        while (ctit.hasNext()) {
            String linkID = (String)ctit.next();
            if (targetLayout.getLinkProperties(linkID) != null) continue;
            todo.add(linkID);
        }
        int numRegions = layouts.size();
        int numCross = crossRegion.size();
        double borderSizeD = (double)numCross / (double)numRegions * 2.0;
        int borderSizeBase = (int)Math.ceil(borderSizeD == 0.0 ? 2.0 : borderSizeD);
        int[][] passes = new int[][]{{borderSizeBase, 0}, {borderSizeBase, 1}, {2 * borderSizeBase, 0}, {3 * borderSizeBase, 0}, {3 * borderSizeBase, 1}, {3 * borderSizeBase, 2}};
        int numPasses = 1;
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / (double)numPasses;
        Layout holdFirstLayout = null;
        HashMap holdFirstBounds = null;
        LinkRouter.RoutingResult holdFirstRes = null;
        boolean basePass = true;
        for (int passNum = 0; passNum < numPasses; ++passNum) {
            Layout useLayout = new Layout("temp", gi.getID());
            HashMap useBounds = new HashMap();
            this.copyResultsBack(targetLayout, useLayout, loBounds, useBounds);
            int border = passes[passNum][0];
            int mult = passes[passNum][1];
            LinkRouter.RoutingResult res = this.freshMerges(todo, border, mult, gi, useBounds, layouts, useLayout, frc, regionsByColumn, options, linkColors, loModKeys, moduleLinkFragShifts, monitor, currProg, currProg + progInc, rememberProps, strictOKGroups);
            currProg += progInc;
            if ((res.linkResult & 2) != 0) {
                if (!basePass) continue;
                basePass = false;
                Set targCollide = gi.hasLinkTargetPadCollisions();
                if (!targCollide.isEmpty()) {
                    this.copyResultsBack(useLayout, targetLayout, useBounds, loBounds);
                    return res;
                }
                holdFirstLayout = useLayout;
                holdFirstBounds = useBounds;
                holdFirstRes = res;
                continue;
            }
            this.copyResultsBack(useLayout, targetLayout, useBounds, loBounds);
            return res;
        }
        this.copyResultsBack(holdFirstLayout, targetLayout, holdFirstBounds, loBounds);
        return holdFirstRes;
    }

    private LinkRouter.RoutingResult freshMerges(Set todo, int boundary, int mult, GenomeInstance gi, Map loBounds, Map layouts, Layout targetLayout, FontRenderContext frc, Map regionsByColumn, LayoutOptions options, Map linkColors, Layout.OverlayKeySet loModKeys, Map moduleLinkFragShifts, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.5;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.5;
        double eFrac2 = eFrac1 + frac2;
        HashMap<String, Layout> useLayouts = layouts;
        HashMap<String, Rectangle> useBounds = loBounds;
        if (mult > 0) {
            useLayouts = new HashMap<String, Layout>();
            useBounds = new HashMap<String, Rectangle>();
            Set lSet = layouts.keySet();
            int size = lSet.size();
            double currProg = startFrac;
            double progInc = frac1 / (double)size;
            Iterator lit = lSet.iterator();
            while (lit.hasNext()) {
                String gpID = (String)lit.next();
                Group grp = gi.getGroup(gpID);
                Layout currLO = (Layout)layouts.get(gpID);
                Layout etempLayout = new Layout(currLO);
                useLayouts.put(gpID, etempLayout);
                Rectangle bounds = (Rectangle)loBounds.get(gpID);
                useBounds.put(gpID, bounds);
                TreeSet insertRows = new TreeSet();
                TreeSet insertCols = new TreeSet();
                etempLayout.chooseExpansionRows(gi, frc, 1.0, 1.0, null, loModKeys, insertRows, insertCols, false, monitor);
                etempLayout.expand(gi, insertRows, insertCols, mult, true, frc, null, moduleLinkFragShifts, gpID, monitor, currProg, currProg + progInc);
                currProg += progInc;
                bounds = etempLayout.getLayoutBoundsForGroup(gi, grp, frc, true);
                useBounds.put(gpID, bounds);
            }
        }
        this.mergeGroupLayouts(targetLayout, regionsByColumn, useLayouts, useBounds, moduleLinkFragShifts, boundary, monitor);
        if (todo.isEmpty()) {
            if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return new LinkRouter.RoutingResult();
        }
        LinkRouter.RoutingResult res = this.layoutSomeLinksCore(todo, targetLayout, gi, options, frc, linkColors, monitor, eFrac1, eFrac2, rememberProps, null, strictOKGroups);
        return res;
    }

    private void buildLinkColorsMap(Genome genome, Layout layout, Map colorMap) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            BusProperties lp = layout.getLinkProperties(link.getID());
            if (lp == null) continue;
            colorMap.put(link.getID(), lp.getColorName());
        }
    }

    private Map modifyCrossLinksForGrowthOrShrinkage(GenomeInstance gi, Layout lo, FontRenderContext frc, CrossLinkRecovery recovery, Map newRegionBounds, Map deltas, Map paddings) {
        PerSrcData psd;
        LinkPlacementGrid.RecoveryDataForSource rdfs;
        String srcID;
        HashMap<String, LinkPlacementGrid.RecoveryDataForSource> retval = new HashMap<String, LinkPlacementGrid.RecoveryDataForSource>();
        HashMap<String, Rectangle> guaranteed = new HashMap<String, Rectangle>();
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            srcID = (String)rpit.next();
            rdfs = new LinkPlacementGrid.RecoveryDataForSource();
            retval.put(srcID, rdfs);
            psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            Map segmentToKidsMap = psd.fullTree.invertTree();
            LinkSegmentID rootSegID = psd.fullTree.getRootSegmentID();
            rdfs.setTreeTopology(segmentToKidsMap, rootSegID, psd.fullTree.isDirect() ? psd.fullTree.getSingleLinkage() : null);
            Set exempt = (Set)recovery.exemptions.get(srcID);
            rdfs.setExemptions(exempt);
            Iterator fsit = psd.perLinkMap.keySet().iterator();
            while (fsit.hasNext()) {
                String linkID = (String)fsit.next();
                PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
                rdfs.setSegListPerLink(linkID, pld.segIDList);
                rdfs.setBoundPointPerLink(linkID, pld.srcBoundPt);
            }
            Iterator ppit = psd.perPointMap.keySet().iterator();
            while (ppit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)ppit.next();
                PerPointData ppd = (PerPointData)psd.perPointMap.get(lsid);
                if (ppd.fixedLinkID != null) {
                    LinkSegment lseg;
                    Point2D newLoc;
                    BusProperties bp = lo.getLinkProperties(ppd.fixedLinkID);
                    if (ppd.newRef != null) {
                        lsid = ppd.newRef;
                    }
                    if (bp == null) {
                        UiUtil.fixMePrintout("Seems to happen when one signal targets two bubbles, one in each of two targ regions, and one bubble has been dropped");
                        newLoc = new Point2D.Double(0.0, 0.0);
                    } else if (lsid.isForStartDrop()) {
                        lseg = bp.getRootSegment();
                        newLoc = lseg.getStart();
                    } else {
                        lseg = bp.getSegment(lsid);
                        newLoc = lseg != null ? lseg.getEnd() : new Point2D.Double(0.0, 0.0);
                    }
                    rdfs.putPointData(lsid, new LinkPlacementGrid.RecoveryPointData(newLoc, ppd.originalOrthoInbound, ppd.originalInboundRun, ppd.dof));
                    continue;
                }
                if (ppd.refNodeID == null) continue;
                Rectangle guarBds = (Rectangle)guaranteed.get(ppd.regionID);
                if (guarBds == null) {
                    Rectangle newBds = (Rectangle)newRegionBounds.get(ppd.regionID);
                    Vector2D delta = (Vector2D)deltas.get(ppd.regionID);
                    Integer paddingObj = (Integer)paddings.get(ppd.regionID);
                    int padding = paddingObj == null ? 0 : paddingObj;
                    guarBds = new Rectangle(newBds.x - padding + (int)delta.getX(), newBds.y - padding + (int)delta.getY(), newBds.width + 2 * padding, newBds.height + 2 * padding);
                    guaranteed.put(ppd.regionID, guarBds);
                }
                NodeProperties np = lo.getNodeProperties(ppd.refNodeID);
                Point2D loc = np.getLocation();
                Point2D newLoc = ppd.offset.add(loc);
                guarBds.add(newLoc);
                rdfs.putPointData(lsid, new LinkPlacementGrid.RecoveryPointData(newLoc, ppd.originalOrthoInbound, ppd.originalInboundRun, ppd.dof));
            }
        }
        rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            srcID = (String)rpit.next();
            rdfs = (LinkPlacementGrid.RecoveryDataForSource)retval.get(srcID);
            psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            Iterator ppit = psd.perPointMap.keySet().iterator();
            while (ppit.hasNext()) {
                LinkPlacementGrid.RecoveryPointData rpd;
                Point2D newLoc;
                LinkSegmentID lsid = (LinkSegmentID)ppit.next();
                PerPointData ppd = (PerPointData)psd.perPointMap.get(lsid);
                if (ppd.regionBased == null || (newLoc = this.getNewRegionBasedLoc(guaranteed, newRegionBounds, ppd.regionBased, ppd.regionID, deltas)) == null) continue;
                Point2D partialPos = null;
                if (ppd.regionBased.partialDefinitionByNodeID != null) {
                    String nodeID = ppd.regionBased.partialDefinitionByNodeID;
                    int padNum = ppd.regionBased.partialPadDefinition;
                    NodeProperties np = lo.getNodeProperties(nodeID);
                    Vector2D lpo = ppd.regionBased.partialIsLaunch ? np.getRenderer().getLaunchPadOffset(padNum, gi.getNode(nodeID), lo, frc) : np.getRenderer().getLandingPadOffset(padNum, gi.getNode(nodeID), 0, lo, frc);
                    partialPos = lpo.add(np.getLocation());
                } else if (ppd.regionBased.partialDefinition != null && (rpd = rdfs.getRpd(ppd.regionBased.partialDefinition)) != null) {
                    partialPos = rpd.point;
                }
                if (partialPos != null) {
                    if (ppd.regionBased.regionBasedApprox == 1) {
                        newLoc.setLocation(newLoc.getX(), partialPos.getY());
                    } else if (ppd.regionBased.regionBasedApprox == 0) {
                        newLoc.setLocation(partialPos.getX(), newLoc.getY());
                    }
                }
                UiUtil.forceToGrid(newLoc, 10.0);
                rdfs.putPointData(lsid, new LinkPlacementGrid.RecoveryPointData(newLoc, ppd.originalOrthoInbound, ppd.originalInboundRun, ppd.dof));
            }
        }
        rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            Point2D rbChop;
            EdgeMove em;
            String linkID;
            srcID = (String)rpit.next();
            rdfs = (LinkPlacementGrid.RecoveryDataForSource)retval.get(srcID);
            psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            rdfs.setDepartureRegionChops(psd.departChops);
            rdfs.setArrivalRegionChops(psd.arriveChops);
            if (psd.departChops != null) {
                Iterator dcit = psd.departChops.keySet().iterator();
                while (dcit.hasNext()) {
                    linkID = (String)dcit.next();
                    em = (EdgeMove)psd.departChops.get(linkID);
                    rbChop = this.getNewRegionBasedLoc(guaranteed, newRegionBounds, em.regPos, em.regionID, deltas);
                    UiUtil.forceToGrid(rbChop, 10.0);
                    em.pas.point = em.pas.outboundSideVec().scaled(-10.0).add(rbChop);
                }
            }
            if (psd.arriveChops == null) continue;
            Iterator acit = psd.arriveChops.keySet().iterator();
            while (acit.hasNext()) {
                linkID = (String)acit.next();
                em = (EdgeMove)psd.arriveChops.get(linkID);
                rbChop = this.getNewRegionBasedLoc(guaranteed, newRegionBounds, em.regPos, em.regionID, deltas);
                UiUtil.forceToGrid(rbChop, 10.0);
                em.pas.point = em.pas.outboundSideVec().scaled(-10.0).add(rbChop);
            }
        }
        return retval;
    }

    private Point2D getNewRegionBasedLoc(HashMap guaranteed, Map newRegionBounds, RegionBasedPosition rbp, String regionID, Map deltas) {
        boolean gotGuar;
        Rectangle newBds = (Rectangle)guaranteed.get(regionID);
        boolean bl = gotGuar = newBds != null;
        if (!gotGuar) {
            newBds = (Rectangle)newRegionBounds.get(regionID);
        }
        if (newBds == null) {
            return null;
        }
        Point2D newOrigin = new Point2D.Double(newBds.getX(), newBds.getY());
        if (!gotGuar) {
            Vector2D delta = (Vector2D)deltas.get(regionID);
            newOrigin = delta.add(newOrigin);
        }
        double newX = rbp.regionBasedDef.origin.getX() * newBds.getWidth();
        double newY = rbp.regionBasedDef.origin.getY() * newBds.getHeight();
        Vector2D toPtOnBounds = new Vector2D(newX, newY);
        Point2D newLocOnBounds = toPtOnBounds.add(newOrigin);
        Point2D newLoc = rbp.regionBasedDef.offset.add(newLocOnBounds);
        return newLoc;
    }

    private void buildCrossPathRegionAssociations(GenomeInstance gi, Layout lo, FontRenderContext frc, Map oldRegionBounds, Map crossTuples, CrossLinkRecovery recovery, Map mergedSegsPerSource) {
        this.buildClaimedCrossPathRegionAssociations(gi, lo, frc, oldRegionBounds, crossTuples, recovery, mergedSegsPerSource);
        this.buildRemainingCrossPathRegionAssociations(gi, lo, frc, oldRegionBounds, crossTuples, recovery);
        this.findSourceRegionBoundingPoints(crossTuples, recovery);
        this.buildChoppieRegionAssociations(oldRegionBounds, recovery);
    }

    private void buildClaimedCrossPathRegionAssociations(GenomeInstance gi, Layout lo, FontRenderContext frc, Map oldRegionBounds, Map crossTuples, CrossLinkRecovery recovery, Map mergedSegsPerSource) {
        Set ctLinks = crossTuples.keySet();
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            Map mergedSegs = mergedSegsPerSource == null ? null : (Map)mergedSegsPerSource.get(srcID);
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            TreeSet orderedKeys = new TreeSet(psd.perLinkMap.keySet());
            Iterator fsit = orderedKeys.iterator();
            while (fsit.hasNext()) {
                String linkID = (String)fsit.next();
                Link cfl = (Link)crossTuples.get(linkID);
                String srcRegID = cfl.getSrc();
                String trgRegID = cfl.getTrg();
                Linkage linkage = gi.getLinkage(linkID);
                String linkSrc = linkage.getSource();
                String linkTrg = linkage.getTarget();
                PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
                List existingSegs = pld.spTree.getSegIDListForSinglePath();
                int numSegs = existingSegs.size();
                block2: for (int i = 0; i < numSegs - 1; ++i) {
                    TreeSpliceData tsd;
                    LinkSegmentID nextSeg = (LinkSegmentID)existingSegs.get(i);
                    pld.segIDList.add(nextSeg);
                    PerPointData ppd = (PerPointData)psd.perPointMap.get(nextSeg);
                    if (ppd == null) {
                        ppd = new PerPointData();
                        LinkSegment lseg = pld.spTree.getSegmentGeometryForID(nextSeg, gi, lo, frc, false);
                        ppd.originalLoc = lseg.getEnd();
                        ppd.originalOrthoInbound = lseg.getRun().isCanonical();
                        ppd.originalInboundRun = (Vector2D)lseg.getRun().clone();
                        ppd.dof = psd.fullTree.getCornerDoF(nextSeg, gi, lo, frc, false);
                        psd.perPointMap.put(nextSeg, ppd);
                        ppd.refNodeID = null;
                    }
                    if (mergedSegs != null && (tsd = (TreeSpliceData)mergedSegs.get(nextSeg)) != null) {
                        if (!tsd.isBoundary) {
                            ppd.regionID = tsd.trgGrpID;
                            ppd.refNodeID = tsd.trgNodeID;
                            psd.assocRegions.add(tsd.trgGrpID);
                            ppd.originalLoc = null;
                        } else {
                            ppd.originalOrthoInbound = tsd.originalOrthoInbound;
                            ppd.originalInboundRun = tsd.originalInboundRun;
                            ppd.regionID = tsd.trgGrpID;
                            ppd.refNodeID = tsd.trgNodeID;
                            psd.assocRegions.add(tsd.trgGrpID);
                        }
                    }
                    Set linksThru = psd.fullTree.resolveLinkagesThroughSegment(nextSeg, gi);
                    Iterator ltit = linksThru.iterator();
                    while (ltit.hasNext()) {
                        String linkThruID = (String)ltit.next();
                        if (ctLinks.contains(linkThruID)) continue;
                        ppd.fixedLinkID = linkThruID;
                        ppd.regionID = srcRegID;
                        break;
                    }
                    if (ppd.fixedLinkID != null || ppd.refNodeID != null) continue;
                    Iterator orbit = oldRegionBounds.keySet().iterator();
                    while (orbit.hasNext()) {
                        String key = (String)orbit.next();
                        Rectangle rect = (Rectangle)oldRegionBounds.get(key);
                        double orbMinX = rect.getMinX();
                        double orbMinY = rect.getMinY();
                        double orbMaxX = rect.getMaxX();
                        double orbMaxY = rect.getMaxY();
                        double olx = ppd.originalLoc.getX();
                        double oly = ppd.originalLoc.getY();
                        if (!(olx >= orbMinX) || !(olx <= orbMaxX) || !(oly >= orbMinY) || !(oly <= orbMaxY)) continue;
                        String addID = null;
                        if (key.equals(srcRegID)) {
                            addID = linkSrc;
                        } else if (key.equals(trgRegID)) {
                            addID = linkTrg;
                        }
                        if (addID == null || mergedSegs != null) continue;
                        ppd.regionID = key;
                        ppd.refNodeID = addID;
                        psd.assocRegions.add(key);
                        continue block2;
                    }
                }
            }
        }
    }

    private void buildRemainingCrossPathRegionAssociations(Genome genome, Layout lo, FontRenderContext frc, Map oldRegionBounds, Map crossTuples, CrossLinkRecovery recovery) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            TreeSet orderedKeys = new TreeSet(psd.perLinkMap.keySet());
            Iterator fsit = orderedKeys.iterator();
            while (fsit.hasNext()) {
                String linkID = (String)fsit.next();
                Link cfl = (Link)crossTuples.get(linkID);
                String srcRegID = cfl.getSrc();
                String trgRegID = cfl.getTrg();
                PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
                int numSegs = pld.segIDList.size();
                for (int i = 0; i < numSegs; ++i) {
                    LinkSegmentID nextSeg = (LinkSegmentID)pld.segIDList.get(i);
                    PerPointData ppd = (PerPointData)psd.perPointMap.get(nextSeg);
                    if (ppd.refNodeID != null || ppd.fixedLinkID != null || ppd.regionBased != null) continue;
                    ppd.regionID = this.findClosestRegion(ppd.originalLoc, oldRegionBounds, srcRegID, trgRegID);
                    Rectangle rect = (Rectangle)oldRegionBounds.get(ppd.regionID);
                    ppd.regionBased = this.closestPointOnBoundary(ppd.originalLoc, rect);
                    this.fixDoFIfPossible(srcID, nextSeg, psd, ppd, genome, lo, frc);
                    psd.assocRegions.add(ppd.regionID);
                }
            }
        }
    }

    private void buildChoppieRegionAssociations(Map oldRegionBounds, CrossLinkRecovery recovery) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            Rectangle rect;
            EdgeMove em;
            String linkID;
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            if (psd.departChops != null) {
                Iterator dcit = psd.departChops.keySet().iterator();
                while (dcit.hasNext()) {
                    linkID = (String)dcit.next();
                    em = (EdgeMove)psd.departChops.get(linkID);
                    rect = (Rectangle)oldRegionBounds.get(em.regionID);
                    em.regPos = this.closestPointOnBoundary(em.getEdgePoint(), rect);
                    psd.assocRegions.add(em.regionID);
                }
            }
            if (psd.arriveChops == null) continue;
            Iterator acit = psd.arriveChops.keySet().iterator();
            while (acit.hasNext()) {
                linkID = (String)acit.next();
                em = (EdgeMove)psd.arriveChops.get(linkID);
                rect = (Rectangle)oldRegionBounds.get(em.regionID);
                em.regPos = this.closestPointOnBoundary(em.getEdgePoint(), rect);
                psd.assocRegions.add(em.regionID);
            }
        }
    }

    private void findSourceRegionBoundingPoints(Map crossTuples, CrossLinkRecovery recovery) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            Set keys = psd.perLinkMap.keySet();
            Iterator kit = keys.iterator();
            while (kit.hasNext()) {
                String linkID = (String)kit.next();
                Link cfl = (Link)crossTuples.get(linkID);
                String srcRegID = cfl.getSrc();
                PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
                pld.srcBoundPt = null;
                int numSegs = pld.segIDList.size();
                LinkSegmentID lastSeg = null;
                for (int i = numSegs - 1; i >= 0; --i) {
                    LinkSegmentID nextSeg = (LinkSegmentID)pld.segIDList.get(i);
                    PerPointData ppd = (PerPointData)psd.perPointMap.get(nextSeg);
                    if ((ppd.fixedLinkID != null || ppd.refNodeID != null) && srcRegID.equals(ppd.regionID)) {
                        pld.srcBoundPt = lastSeg == null ? nextSeg : lastSeg;
                        break;
                    }
                    lastSeg = nextSeg;
                }
                if (pld.srcBoundPt != null) continue;
                pld.srcBoundPt = lastSeg;
            }
        }
    }

    private void fixDoFIfPossible(String src, LinkSegmentID lsid, PerSrcData psd, PerPointData myPpd, Genome genome, Layout lo, FontRenderContext frc) {
        Vector2D myRun;
        List kidSegs = psd.fullTree.getChildSegs(lsid);
        int numKs = kidSegs.size();
        for (int i = 0; i < numKs; ++i) {
            LinkSegmentID nextSeg = (LinkSegmentID)kidSegs.get(i);
            LinkSegment geomSeg = psd.fullTree.getSegmentGeometryForID(nextSeg, genome, lo, frc, false);
            Vector2D kidRun = geomSeg.getRun();
            if (kidRun == null || !kidRun.isCanonical() || (kidRun.getY() != 0.0 || myPpd.regionBased.regionBasedApprox != 1) && (kidRun.getX() != 0.0 || myPpd.regionBased.regionBasedApprox != 0)) continue;
            if (nextSeg.isForEndDrop()) {
                String linkID = nextSeg.getEndDropLinkRef();
                Linkage link = genome.getLinkage(linkID);
                myPpd.regionBased.partialDefinitionByNodeID = link.getTarget();
                myPpd.regionBased.partialPadDefinition = link.getLandingPad();
                myPpd.regionBased.partialIsLaunch = false;
            } else {
                myPpd.regionBased.partialDefinition = nextSeg;
            }
            return;
        }
        LinkSegment myGeom = psd.fullTree.getSegmentGeometryForID(lsid, genome, lo, frc, false);
        if (myGeom != null && (myRun = myGeom.getRun()) != null && myRun.isCanonical() && (myRun.getY() == 0.0 && myPpd.regionBased.regionBasedApprox == 1 || myRun.getX() == 0.0 && myPpd.regionBased.regionBasedApprox == 0)) {
            if (lsid.isForStartDrop()) {
                myPpd.regionBased.partialDefinitionByNodeID = src;
                myPpd.regionBased.partialPadDefinition = genome.getSourcePad(src);
                myPpd.regionBased.partialIsLaunch = true;
            } else {
                myPpd.regionBased.partialDefinition = psd.fullTree.getSegmentIDForParent(lsid);
            }
            return;
        }
    }

    private String findClosestRegion(Point2D nextPt, Map oldRegionBounds, String srcRegID, String trgRegID) {
        Iterator orbit = oldRegionBounds.keySet().iterator();
        double minDist = Double.POSITIVE_INFINITY;
        double srcDist = Double.POSITIVE_INFINITY;
        double trgDist = Double.POSITIVE_INFINITY;
        String retval = null;
        while (orbit.hasNext()) {
            String key = (String)orbit.next();
            Rectangle rect = (Rectangle)oldRegionBounds.get(key);
            double dist = this.distanceToRegion(nextPt, rect);
            if (dist < minDist) {
                minDist = dist;
                retval = key;
            }
            if (key.equals(srcRegID)) {
                srcDist = dist;
            }
            if (!key.equals(trgRegID)) continue;
            trgDist = dist;
        }
        if (minDist == trgDist) {
            retval = trgRegID;
        }
        if (minDist == srcDist) {
            retval = srcRegID;
        }
        return retval;
    }

    private double distanceToRegion(Point2D nextPt, Rectangle regionRect) {
        if (regionRect.contains(nextPt)) {
            return 0.0;
        }
        Rectangle2D.Double bounds2D = new Rectangle2D.Double(regionRect.getX(), regionRect.getY(), regionRect.getWidth(), regionRect.getHeight());
        bounds2D.add(nextPt);
        double deltaW = ((RectangularShape)bounds2D).getWidth() - regionRect.getWidth();
        double deltaH = ((RectangularShape)bounds2D).getHeight() - regionRect.getHeight();
        return Math.sqrt(deltaW * deltaW + deltaH * deltaH);
    }

    private RegionBasedPosition closestPointOnBoundary(Point2D nextPt, Rectangle regionRect) {
        Point2D.Double origin = new Point2D.Double(regionRect.getX(), regionRect.getY());
        Point2D.Double urpt = new Point2D.Double(regionRect.getX() + regionRect.getWidth(), regionRect.getY());
        Point2D.Double llpt = new Point2D.Double(regionRect.getX(), regionRect.getY() + regionRect.getHeight());
        Point2D.Double lrpt = new Point2D.Double(regionRect.getX() + regionRect.getWidth(), regionRect.getY() + regionRect.getHeight());
        PointAndVec pavTop = this.closestPointOnSegment(origin, urpt, nextPt);
        double minDist = pavTop.offset.length();
        PointAndVec minPav = pavTop;
        PointAndVec pavBot = this.closestPointOnSegment(llpt, lrpt, nextPt);
        double currDist = pavBot.offset.length();
        if (currDist < minDist) {
            minDist = currDist;
            minPav = pavBot;
        }
        PointAndVec pavLeft = this.closestPointOnSegment(origin, llpt, nextPt);
        currDist = pavLeft.offset.length();
        if (currDist < minDist) {
            minDist = currDist;
            minPav = pavLeft;
        }
        PointAndVec pavRight = this.closestPointOnSegment(urpt, lrpt, nextPt);
        currDist = pavRight.offset.length();
        if (currDist < minDist) {
            minDist = currDist;
            minPav = pavRight;
        }
        int approxDir = -1;
        approxDir = minPav == pavTop || minPav == pavBot ? 0 : 1;
        double normX = (minPav.origin.getX() - regionRect.getX()) / regionRect.getWidth();
        double normY = (minPav.origin.getY() - regionRect.getY()) / regionRect.getHeight();
        RegionBasedPosition retval = new RegionBasedPosition();
        retval.regionBasedDef = new PointAndVec(new Point2D.Double(normX, normY), minPav.offset);
        retval.regionBasedApprox = approxDir;
        return retval;
    }

    private PointAndVec closestPointOnSegment(Point2D startPt, Point2D endPt, Point2D targ) {
        PointAndVec pav;
        Vector2D toPt;
        Vector2D run = new Vector2D(startPt, endPt);
        double length = run.length();
        double runDot = (run = run.normalized()).dot(toPt = new Vector2D(startPt, targ));
        if (runDot < 0.0) {
            Vector2D offset = new Vector2D(startPt, targ);
            pav = new PointAndVec((Point2D)startPt.clone(), offset);
        } else if (runDot > length) {
            Vector2D offset = new Vector2D(endPt, targ);
            pav = new PointAndVec((Point2D)endPt.clone(), offset);
        } else {
            Vector2D delta = run.scaled(runDot);
            Point2D closePt = delta.add(startPt);
            Vector2D offset = new Vector2D(closePt, targ);
            pav = new PointAndVec(closePt, offset);
        }
        return pav;
    }

    static void expandOrCompressRecoveryPaths(boolean doExpand, Layout lo, String grpID, SortedSet rows, SortedSet cols, int mult, CrossLinkRecovery recovery) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            if (!psd.assocRegions.contains(grpID)) continue;
            BusProperties treeCopy = (BusProperties)psd.fullTree.clone();
            if (doExpand) {
                treeCopy.expand(rows, cols, mult);
            } else {
                treeCopy.compress(rows, cols, null);
            }
            Iterator ppit = psd.perPointMap.keySet().iterator();
            while (ppit.hasNext()) {
                Point2D pt;
                LinkSegment lseg;
                LinkSegmentID segID = (LinkSegmentID)ppit.next();
                PerPointData ppd = (PerPointData)psd.perPointMap.get(segID);
                if (ppd.refNodeID == null || !ppd.regionID.equals(grpID)) continue;
                if (segID.isForStartDrop()) {
                    lseg = treeCopy.getRootSegment();
                    pt = lseg.getStart();
                } else {
                    lseg = treeCopy.getSegment(segID);
                    pt = lseg.getEnd();
                }
                NodeProperties np = lo.getNodeProperties(ppd.refNodeID);
                Point2D loc = np.getLocation();
                ppd.offset = new Vector2D(loc, pt);
            }
        }
    }

    private void pinUnchangedRecoveryPaths(Layout lo, String grpID, CrossLinkRecovery recovery, Vector2D delta) {
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            if (!psd.assocRegions.contains(grpID)) continue;
            BusProperties treeCopy = (BusProperties)psd.fullTree.clone();
            Iterator ppit = psd.perPointMap.keySet().iterator();
            while (ppit.hasNext()) {
                Point2D pt;
                LinkSegment lseg;
                LinkSegmentID segID = (LinkSegmentID)ppit.next();
                PerPointData ppd = (PerPointData)psd.perPointMap.get(segID);
                if (ppd.refNodeID == null || ppd.offset != null || !ppd.regionID.equals(grpID)) continue;
                if (segID.isForStartDrop()) {
                    lseg = treeCopy.getRootSegment();
                    pt = lseg.getStart();
                } else {
                    lseg = treeCopy.getSegment(segID);
                    pt = lseg.getEnd();
                }
                NodeProperties np = lo.getNodeProperties(ppd.refNodeID);
                Point2D loc = np.getLocation();
                if (delta != null) {
                    loc = delta.scaled(-1.0).add(loc);
                }
                ppd.offset = new Vector2D(loc, pt);
            }
        }
    }

    private Map calcRegionGrowthOffsets(Map newRegionBounds, Map savedRegionBounds, List fixedElements, Map newPaddings) {
        ArrayList<GridElement> gridElements = new ArrayList<GridElement>();
        Iterator nrbit = newRegionBounds.keySet().iterator();
        while (nrbit.hasNext()) {
            Integer newPaddingObj;
            String nextKey = (String)nrbit.next();
            Rectangle newBounds = (Rectangle)newRegionBounds.get(nextKey);
            Rectangle savedBounds = (Rectangle)savedRegionBounds.get(nextKey);
            if (savedBounds == null) continue;
            int hDiff = newBounds.height - savedBounds.height;
            int wDiff = newBounds.width - savedBounds.width;
            if (hDiff < 0) {
                hDiff = 0;
            }
            if (wDiff < 0) {
                wDiff = 0;
            }
            int newPadding = (newPaddingObj = (Integer)newPaddings.get(nextKey)) != null ? newPaddingObj : 0;
            GridElement ge = new GridElement((Rectangle2D)savedBounds, (Object)nextKey, (double)(wDiff += 2 * newPadding), (double)(hDiff += 2 * newPadding));
            gridElements.add(ge);
        }
        GridGrower grower = new GridGrower();
        List grown = grower.growGrid(gridElements, 2);
        HashMap<Object, Vector2D> retval = new HashMap<Object, Vector2D>();
        int geSize = gridElements.size();
        for (int i = 0; i < geSize; ++i) {
            GridElement origGe = (GridElement)gridElements.get(i);
            GridElement newGe = (GridElement)grown.get(i);
            Rectangle newBounds = (Rectangle)newRegionBounds.get(origGe.id);
            Integer newPaddingObj = (Integer)newPaddings.get(origGe.id);
            int newPadding = newPaddingObj != null ? newPaddingObj : 0;
            double deltaX = origGe.rect.getX() - (double)newBounds.x + (newGe.rect.getX() - origGe.rect.getX()) + (double)newPadding;
            deltaX = UiUtil.forceToGridValue(deltaX, 10.0);
            double deltaY = origGe.rect.getY() - (double)newBounds.y + (newGe.rect.getY() - origGe.rect.getY()) + (double)newPadding;
            deltaY = UiUtil.forceToGridValue(deltaY, 10.0);
            Vector2D delta = new Vector2D(deltaX, deltaY);
            retval.put(origGe.id, delta);
            if (fixedElements == null) continue;
            int x = (int)UiUtil.forceToGridValue(newBounds.x + (int)deltaX, 10.0);
            int y = (int)UiUtil.forceToGridValue(newBounds.y + (int)deltaY, 10.0);
            int w = (int)UiUtil.forceToGridValue(newBounds.width, 10.0);
            int h = (int)UiUtil.forceToGridValue(newBounds.height, 10.0);
            Rectangle fixedRect = new Rectangle(x, y, w, h);
            PlacementElement newPe = new PlacementElement(fixedRect, origGe.id.toString());
            fixedElements.add(newPe);
        }
        return retval;
    }

    private Map sortRegions(Set allGroups, Map linkTuples, GenomeInstance gi) {
        HashSet nodes = new HashSet(allGroups);
        HashSet<Link> links = new HashSet<Link>();
        Iterator xrit = linkTuples.keySet().iterator();
        while (xrit.hasNext()) {
            String linkID = (String)xrit.next();
            Link cfl = (Link)linkTuples.get(linkID);
            links.add(cfl);
            CycleFinder cf = new CycleFinder(nodes, links);
            if (!cf.hasACycle()) continue;
            links.remove(cfl);
        }
        GraphSearcher searcher = new GraphSearcher(nodes, links);
        Map topoSort = searcher.topoSort(false);
        TreeMap invert = new TreeMap();
        searcher.invertTopoSort(topoSort, invert);
        return invert;
    }

    private void squash(Layout instanceLayout, GenomeInstance gi, FontRenderContext frc, Map moduleLinkFragShifts, String grpID, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid routerGrid = router.initGrid(gi, instanceLayout, frc, null, 1, monitor);
        SortedSet emptyRows = routerGrid.getEmptyRows(null, false, monitor);
        SortedSet emptyCols = routerGrid.getEmptyColumns(null, false, monitor);
        instanceLayout.compress(gi, emptyRows, emptyCols, null, null, moduleLinkFragShifts, grpID, monitor, startFrac, endFrac);
    }

    private void boundedSquash(Layout instanceLayout, GenomeInstance gi, FontRenderContext frc, Rectangle bounds, Map allBounds, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        SortedSet emptyCols;
        SortedSet emptyRows;
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid routerGrid = router.initGrid(gi, instanceLayout, frc, null, 1, monitor);
        if (bounds != null) {
            MinMax xBounds = new MinMax(bounds.x, bounds.x + bounds.width);
            MinMax yBounds = new MinMax(bounds.y, bounds.y + bounds.height);
            emptyRows = routerGrid.getEmptyRowsWithYBounds(xBounds, yBounds, false, monitor);
            emptyCols = routerGrid.getEmptyColumnsWithXBounds(yBounds, xBounds, false, monitor);
        } else {
            emptyRows = routerGrid.getEmptyRows(null, false, monitor);
            emptyCols = routerGrid.getEmptyColumns(null, false, monitor);
        }
        instanceLayout.compress(gi, emptyRows, emptyCols, bounds, null, null, null, monitor, startFrac, endFrac);
    }

    private void chooseReducedRootCompression(Layout rootLayout, GenomeInstance gi, String grpID, FontRenderContext frc, SortedSet useEmptyRows, SortedSet useEmptyCols, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Database db = Database.getDB();
        Genome rootGenome = db.getGenome();
        String giID = gi.getID();
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        HashMap<String, String> linkMap = new HashMap<String, String>();
        Group grp = gi.getGroup(grpID);
        if (grp.isASubset(gi)) {
            throw new IllegalArgumentException();
        }
        HashSet pts = new HashSet();
        Iterator mit = grp.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            String baseID = GenomeItemInstance.getBaseID(nodeID);
            nodeMap.put(baseID, baseID);
        }
        HashSet<String> ignoreNodes = new HashSet<String>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            Linkage link = (Linkage)glit.next();
            String linkID = link.getID();
            String baseID = GenomeItemInstance.getBaseID(linkID);
            String src = link.getSource();
            String trg = link.getTarget();
            if (!grp.isInGroup(trg, gi)) continue;
            linkMap.put(baseID, baseID);
            if (grp.isInGroup(src, gi)) continue;
            String baseSrc = GenomeItemInstance.getBaseID(src);
            nodeMap.put(baseSrc, baseSrc);
            ignoreNodes.add(baseSrc);
        }
        Layout loForGrp = new Layout("junkID", giID);
        loForGrp.extractPartialLayout(nodeMap, linkMap, null, null, null, null, false, false, rootLayout, null, rootGenome, frc);
        loForGrp.chooseCompressionRows(rootGenome, frc, 1.0, 1.0, null, false, null, useEmptyRows, useEmptyCols, monitor, ignoreNodes);
    }

    private void sliceAndDiceModulesForGroups(Layout baseLayout, GenomeInstance gi, FontRenderContext frc, Set allGroups, Layout.OverlayKeySet loModKeys, Map claimedSlices, Map unclaimedSlices, Map moduleLinkFragShifts) {
        Point2D center = baseLayout.getLayoutCenter(frc, false, null, null, null, null);
        HashMap<String, Rectangle> forcedBounds = new HashMap<String, Rectangle>();
        HashMap<String, Integer> groupZOrder = new HashMap<String, Integer>();
        Iterator agit = allGroups.iterator();
        while (agit.hasNext()) {
            String grpID = (String)agit.next();
            groupZOrder.put(grpID, new Integer(baseLayout.getGroupProperties(grpID).getOrder()));
            Group grp = gi.getGroup(grpID);
            if (grp.isASubset(gi)) {
                throw new IllegalArgumentException();
            }
            Rectangle bounds = baseLayout.getLayoutBoundsForGroup(gi, grp, frc, false);
            if (bounds == null) continue;
            UiUtil.forceToGrid(bounds, 10.0);
            forcedBounds.put(grpID, bounds);
        }
        NetModuleShapeFixer nms = new NetModuleShapeFixer();
        Map sliceResults = baseLayout.sliceModulesByAllBounds(forcedBounds, groupZOrder, loModKeys, frc);
        Iterator slit = sliceResults.keySet().iterator();
        while (slit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)slit.next();
            NetModuleProperties.SliceResult sr = (NetModuleProperties.SliceResult)sliceResults.get(fullKey);
            Iterator oit = sr.ownedByGroup.keySet().iterator();
            while (oit.hasNext()) {
                Layout.DicedModuleInfo shapesPerKey;
                String ownerGrpID = (String)oit.next();
                HashMap<NetModule.FullModuleKey, Layout.DicedModuleInfo> perGroup = (HashMap<NetModule.FullModuleKey, Layout.DicedModuleInfo>)claimedSlices.get(ownerGrpID);
                if (perGroup == null) {
                    perGroup = new HashMap<NetModule.FullModuleKey, Layout.DicedModuleInfo>();
                    claimedSlices.put(ownerGrpID, perGroup);
                }
                if ((shapesPerKey = (Layout.DicedModuleInfo)perGroup.get(fullKey)) == null) {
                    shapesPerKey = new Layout.DicedModuleInfo(fullKey);
                    perGroup.put(fullKey, shapesPerKey);
                }
                List shapes = (List)sr.ownedByGroup.get(ownerGrpID);
                shapesPerKey.dicedShapes.addAll(shapes);
            }
            ArrayList<NetModuleProperties.TaggedShape> allUnclaimed = new ArrayList<NetModuleProperties.TaggedShape>();
            allUnclaimed.addAll(sr.unclaimed);
            int numMult = sr.multiClaimed.size();
            for (int i = 0; i < numMult; ++i) {
                NetModuleProperties.MultiClaim mc = (NetModuleProperties.MultiClaim)sr.multiClaimed.get(i);
                allUnclaimed.add(new NetModuleProperties.TaggedShape(null, mc.shape, mc.isName));
            }
            List relocInfo = nms.getModuleRelocInfoForRegions(claimedSlices, allUnclaimed, fullKey, center);
            Layout.DicedModuleInfo shapesPerKey = new Layout.DicedModuleInfo(fullKey);
            shapesPerKey.dicedRectByRects.addAll(relocInfo);
            unclaimedSlices.put(fullKey, shapesPerKey);
        }
        if (moduleLinkFragShifts != null) {
            moduleLinkFragShifts.putAll(baseLayout.sliceModuleLinksByAllBounds(forcedBounds, groupZOrder, loModKeys, frc));
        }
    }

    private ClaimedAndUnclaimed buildGroupLayouts(Layout baseLayout, GenomeInstance gi, FontRenderContext frc, Map layouts, Map loBounds, Set allGroups, Layout.OverlayKeySet loModKeys, boolean baseIsRoot, boolean doSquash, Map gpMemory, Map emptiesForGroups, Map moduleLinkFragShifts, boolean keepOverlays, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        HashMap claimedSlices = null;
        HashMap unclaimedSlices = null;
        if (!baseIsRoot && loModKeys != null && !loModKeys.isEmpty()) {
            claimedSlices = new HashMap();
            unclaimedSlices = new HashMap();
            this.sliceAndDiceModulesForGroups(baseLayout, gi, frc, allGroups, loModKeys, claimedSlices, unclaimedSlices, moduleLinkFragShifts);
        }
        HashMap<String, Integer> desiredOrders = new HashMap<String, Integer>();
        TreeSet<Integer> seenOrders = new TreeSet<Integer>();
        String giID = gi.getID();
        Iterator agit = allGroups.iterator();
        int count = 0;
        while (agit.hasNext()) {
            Integer wantOrder;
            String grpID = (String)agit.next();
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            HashMap<String, String> linkMap = new HashMap<String, String>();
            Group grp = gi.getGroup(grpID);
            if (grp.isASubset(gi)) {
                throw new IllegalArgumentException();
            }
            HashSet<Point2D> pts = new HashSet<Point2D>();
            Iterator mit = grp.getMemberIterator();
            while (mit.hasNext()) {
                GroupMember mem = (GroupMember)mit.next();
                String nodeID = mem.getID();
                String baseID = baseIsRoot ? GenomeItemInstance.getBaseID(nodeID) : nodeID;
                NodeProperties np = baseLayout.getNodeProperties(baseID);
                if (np == null) continue;
                nodeMap.put(nodeID, baseID);
                Point2D location = np.getLocation();
                pts.add(location);
            }
            Point2D center = pts.isEmpty() ? new Point2D.Double() : AffineCombination.combination(pts, 10.0);
            Iterator glit = gi.getLinkageIterator();
            while (glit.hasNext()) {
                Linkage link = (Linkage)glit.next();
                String linkID = link.getID();
                String baseID = baseIsRoot ? GenomeItemInstance.getBaseID(linkID) : linkID;
                BusProperties lp = baseLayout.getLinkProperties(baseID);
                if (lp == null) continue;
                String src = link.getSource();
                String trg = link.getTarget();
                if (!grp.isInGroup(src, gi) || !grp.isInGroup(trg, gi)) continue;
                linkMap.put(linkID, baseID);
            }
            HashMap keyMap = null;
            HashMap modLinkIDMap = null;
            if (keepOverlays) {
                keyMap = new HashMap();
                modLinkIDMap = new HashMap();
                new FullGenomeHierarchyOracle().fillMapsForGroupExtraction(gi, grpID, keyMap);
            }
            Layout loForGrp = new Layout("junkID", giID);
            GroupProperties newProp = null;
            if (baseIsRoot) {
                GroupProperties memory;
                newProp = new GroupProperties(count++, grpID, center, 0);
                if (gpMemory != null && (memory = (GroupProperties)gpMemory.get(grpID)) != null) {
                    newProp.setColor(true, memory.getColorTag(true));
                    newProp.setColor(false, memory.getColorTag(false));
                    wantOrder = new Integer(memory.getOrder());
                    if (!seenOrders.contains(wantOrder)) {
                        desiredOrders.put(grpID, wantOrder);
                        seenOrders.add(wantOrder);
                    }
                }
            } else {
                GroupProperties baseProp = baseLayout.getGroupProperties(grpID);
                if (baseProp != null) {
                    newProp = new GroupProperties(baseProp);
                    wantOrder = new Integer(newProp.getOrder());
                    if (!seenOrders.contains(wantOrder)) {
                        desiredOrders.put(grpID, wantOrder);
                        seenOrders.add(wantOrder);
                    }
                } else {
                    newProp = new GroupProperties(count++, grpID, center, 0);
                }
            }
            loForGrp.setGroupProperties(grpID, newProp);
            Set allsubs = grp.getSubsets(gi);
            Iterator asit = allsubs.iterator();
            while (asit.hasNext()) {
                String subGrpID = (String)asit.next();
                GroupProperties newSubProp = null;
                if (baseIsRoot) {
                    newSubProp = new GroupProperties(subGrpID, loForGrp, 1, center, newProp.getOrder());
                } else {
                    GroupProperties subProp = baseLayout.getGroupProperties(subGrpID);
                    newSubProp = new GroupProperties(subProp);
                    newSubProp.setOrder(newProp.getOrder());
                }
                loForGrp.setGroupProperties(subGrpID, newSubProp);
            }
            Map diceMap = claimedSlices == null ? null : (Map)claimedSlices.get(grpID);
            loForGrp.extractPartialLayout(nodeMap, linkMap, null, keyMap, modLinkIDMap, diceMap, true, false, baseLayout, null, gi, frc);
            if (doSquash) {
                if (emptiesForGroups == null || emptiesForGroups.get(grpID) == null) {
                    this.squash(loForGrp, gi, frc, moduleLinkFragShifts, grpID, monitor, startFrac, endFrac);
                } else {
                    Empties empties = (Empties)emptiesForGroups.get(grpID);
                    loForGrp.compress(gi, empties.emptyRows, empties.emptyCols, null, null, moduleLinkFragShifts, grpID, monitor, startFrac, endFrac);
                }
            }
            if (baseIsRoot) {
                loForGrp.groupTagToCorner(gi, grp, frc, true);
            }
            layouts.put(grpID, loForGrp);
            Rectangle bounds = loForGrp.getLayoutBoundsForGroup(gi, grp, frc, true);
            if (bounds != null) {
                UiUtil.forceToGrid(bounds, 10.0);
            }
            loBounds.put(grpID, bounds);
        }
        int topWanted = seenOrders.isEmpty() ? 0 : (Integer)seenOrders.last();
        Iterator lfgit = layouts.keySet().iterator();
        while (lfgit.hasNext()) {
            String grpID = (String)lfgit.next();
            Integer order = (Integer)desiredOrders.get(grpID);
            int installOrder = order == null ? topWanted++ : order;
            Layout lo2i = (Layout)layouts.get(grpID);
            GroupProperties gp = lo2i.getGroupProperties(grpID);
            gp.setOrder(installOrder);
        }
        return new ClaimedAndUnclaimed(claimedSlices, unclaimedSlices);
    }

    private void buildCrossLinkLayouts(Layout rootLayout, GenomeInstance gi, FontRenderContext frc, Map layouts, Map crossTuples, Set targetGroups, Map loBounds, boolean doSquash, Map emptiesForGroups, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        String giID = gi.getID();
        Iterator tgit = targetGroups.iterator();
        while (tgit.hasNext()) {
            Rectangle bounds;
            Layout rootCompress;
            String trgGroup = (String)tgit.next();
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            HashMap<String, String> linkMap = new HashMap<String, String>();
            Iterator ctkit = crossTuples.keySet().iterator();
            while (ctkit.hasNext()) {
                String linkID = (String)ctkit.next();
                Link cfl = (Link)crossTuples.get(linkID);
                String linkTargRegion = cfl.getTrg();
                if (!trgGroup.equals(linkTargRegion)) continue;
                Linkage link = gi.getLinkage(linkID);
                String srcNode = link.getSource();
                String baseID = GenomeItemInstance.getBaseID(srcNode);
                nodeMap.put(srcNode, baseID);
                String trgNode = link.getTarget();
                baseID = GenomeItemInstance.getBaseID(trgNode);
                nodeMap.put(trgNode, baseID);
                baseID = GenomeItemInstance.getBaseID(linkID);
                linkMap.put(linkID, baseID);
            }
            Layout loForGrp = new Layout("junkID", giID);
            loForGrp.extractPartialLayout(nodeMap, linkMap, null, null, null, null, false, false, rootLayout, null, gi, frc);
            if (doSquash) {
                if (emptiesForGroups == null || emptiesForGroups.get(trgGroup) == null) {
                    this.squash(loForGrp, gi, frc, null, null, monitor, startFrac, endFrac);
                } else {
                    Empties empties = (Empties)emptiesForGroups.get(trgGroup);
                    loForGrp.compress(gi, empties.emptyRows, empties.emptyCols, null, null, null, null, monitor, startFrac, endFrac);
                }
            }
            layouts.put(trgGroup, loForGrp);
            HashSet<String> trgNodes = new HashSet<String>();
            HashSet<String> rootTrgNodes = new HashSet<String>();
            Group group = gi.getGroup(trgGroup);
            Iterator mit = group.getMemberIterator();
            while (mit.hasNext()) {
                GroupMember mem = (GroupMember)mit.next();
                String nodeID = mem.getID();
                trgNodes.add(nodeID);
                rootTrgNodes.add(GenomeItemInstance.getBaseID(nodeID));
            }
            HashSet<String> trgLinks = new HashSet<String>();
            Iterator lit = gi.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                if (!trgNodes.contains(link.getSource()) || !trgNodes.contains(link.getTarget())) continue;
                trgLinks.add(GenomeItemInstance.getBaseID(link.getID()));
            }
            Genome genome = Database.getDB().getGenome();
            if (doSquash && emptiesForGroups != null && emptiesForGroups.get(trgGroup) != null) {
                rootCompress = new Layout(rootLayout);
                Empties empties = (Empties)emptiesForGroups.get(trgGroup);
                rootCompress.compress(genome, empties.emptyRows, empties.emptyCols, null, null, null, null, monitor, endFrac, endFrac);
            } else {
                rootCompress = rootLayout;
            }
            if ((bounds = rootCompress.getPartialBounds(genome, frc, rootTrgNodes, true, true, trgLinks, null, false)) == null) continue;
            UiUtil.forceToGrid(bounds, 10.0);
            loBounds.put(trgGroup, bounds);
        }
    }

    private void addNewProperties(Layout groupLayout, GenomeInstance gi, Group group, Layout targetLayout, Point2D origin, LayoutOptions options, FontRenderContext frc, Map linkColors, BTProgressMonitor monitor, double startFrac, double maxFrac, Map rememberProps, boolean strictOKGroups) throws AsynchExitRequestException {
        Point2D labLoc;
        int count = 0;
        String grpID = group.getID();
        boolean newGroup = false;
        GroupProperties gprop = targetLayout.getGroupProperties(grpID);
        if (gprop == null) {
            targetLayout.setGroupProperties(grpID, new GroupProperties(count++, grpID, targetLayout, origin, targetLayout.getTopGroupOrder() + 1));
            newGroup = true;
            labLoc = origin;
        } else {
            labLoc = gprop.getLabelLocation();
        }
        HashSet<String> missingNodes = new HashSet<String>();
        HashSet<String> refNodes = new HashSet<String>();
        Iterator mit = group.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            if (targetLayout.getNodeProperties(nodeID) == null) {
                missingNodes.add(nodeID);
                continue;
            }
            refNodes.add(nodeID);
        }
        Vector2D finalShift = new Vector2D(0.0, 0.0);
        if (missingNodes.size() != 0) {
            Vector2D labelTotal;
            Point2D newCentroid = this.getCentroid(missingNodes, groupLayout);
            if (refNodes.size() != 0) {
                Vector2D shiftCentroid = this.shiftNewNodesWithPolarCoords(refNodes, missingNodes, newCentroid, groupLayout, targetLayout);
                shiftCentroid.forceToGrid(10.0);
                finalShift = this.placeWithGrid(gi, groupLayout, missingNodes, refNodes, targetLayout, frc, shiftCentroid);
                finalShift.forceToGrid(10.0);
                Vector2D originToCent = new Vector2D(origin, newCentroid);
                labelTotal = originToCent.add(finalShift);
                labelTotal.forceToGrid(10.0);
            } else {
                labelTotal = new Vector2D(labLoc, newCentroid);
                labelTotal.forceToGrid(10.0);
                double xmov = labelTotal.getX();
                double ymov = labelTotal.getY();
                targetLayout.moveGroup(grpID, gi, xmov, ymov);
            }
            Iterator mnit = missingNodes.iterator();
            while (mnit.hasNext()) {
                String nodeID = (String)mnit.next();
                NodeProperties props = (NodeProperties)groupLayout.getNodeProperties(nodeID).clone();
                Point2D orig = props.getLocation();
                Point2D shift = finalShift.add(orig);
                UiUtil.forceToGrid(shift.getX(), shift.getY(), shift, 10.0);
                props.setLocation(shift);
                targetLayout.setNodeProperties(nodeID, props);
            }
        } else if (refNodes.size() > 0) {
            Point2D oldCentroid = this.getCentroid(refNodes, groupLayout);
            Point2D newCentroid = this.getCentroid(refNodes, targetLayout);
            finalShift = new Vector2D(oldCentroid, newCentroid);
            finalShift.forceToGrid(10.0);
        } else {
            finalShift = new Vector2D(0.0, 0.0);
        }
        Set todo = this.getNeededLinksForGroup(gi, group, targetLayout);
        if (!todo.isEmpty()) {
            this.inheritConsistentLinks(gi, group, groupLayout, targetLayout, todo, missingNodes, finalShift, frc);
        }
        todo = this.getNeededLinksForGroup(gi, group, targetLayout);
        this.layoutSomeLinks(todo, targetLayout, gi, options, frc, linkColors, monitor, startFrac, maxFrac, true, rememberProps, strictOKGroups);
    }

    private void inheritConsistentLinks(GenomeInstance gi, Group group, Layout groupLayout, Layout targetLayout, Set missingLinks, Set missingNodes, Vector2D shift, FontRenderContext frc) {
        HashSet<String> linkSet;
        LinkPlacementGrid routerGrid;
        LinkRouter router = new LinkRouter();
        Layout layoutKludge = new Layout("bogus", gi.getID());
        layoutKludge.extractPartialLayoutForGroup(gi, group, targetLayout, null, frc, null, null, null);
        try {
            routerGrid = router.initGrid(gi, layoutKludge, frc, null, 1, null);
        }
        catch (AsynchExitRequestException ex) {
            throw new IllegalStateException();
        }
        HashMap<String, HashSet<String>> linksForSrc = new HashMap<String, HashSet<String>>();
        HashMap<String, Vector2D> shiftForSrc = new HashMap<String, Vector2D>();
        Iterator mlit = missingLinks.iterator();
        while (mlit.hasNext()) {
            String linkID = (String)mlit.next();
            Linkage link = gi.getLinkage(linkID);
            Vector2D checkShift = this.nodesOkForLinkInherit(link, gi, groupLayout, layoutKludge, missingNodes, shift);
            String src = link.getSource();
            if (checkShift == null) continue;
            shiftForSrc.put(src, checkShift);
            linkSet = (Set)linksForSrc.get(src);
            if (linkSet == null) {
                linkSet = new HashSet<String>();
                linksForSrc.put(src, linkSet);
            }
            linkSet.add(linkID);
        }
        Set existingLinks = this.getExistingLinksForGroup(gi, group, targetLayout);
        LinkageFree render = new LinkageFree();
        Iterator lfsit = linksForSrc.keySet().iterator();
        while (lfsit.hasNext()) {
            String srcID = (String)lfsit.next();
            linkSet = (HashSet<String>)linksForSrc.get(srcID);
            String firstLink = (String)linkSet.iterator().next();
            BusProperties props = groupLayout.getLinkProperties(firstLink);
            Map ppMap = render.getPointPairMap(gi, props, groupLayout, frc, null, null);
            Vector2D okShift = (Vector2D)shiftForSrc.get(srcID);
            Set dropSet = this.prunePointPairMap(ppMap, existingLinks, okShift);
            props = (BusProperties)props.buildReducedProperties(linkSet);
            props.fullShift(okShift.getX(), okShift.getY());
            Iterator lsit = linkSet.iterator();
            HashSet<String> survivingLinks = new HashSet<String>();
            while (lsit.hasNext()) {
                String linkID = (String)lsit.next();
                if (!props.haveTargetDrop(linkID)) continue;
                layoutKludge.setLinkProperties(linkID, props);
                survivingLinks.add(linkID);
            }
            if (survivingLinks.isEmpty() || !render.canRenderToPlacementGrid(gi, props, layoutKludge, frc, routerGrid, dropSet, null, null)) continue;
            this.mergeInheritedLinks(survivingLinks, srcID, props, gi, targetLayout, frc);
            routerGrid.dropLink(srcID, gi, null);
            render.renderToPlacementGrid(gi, props, layoutKludge, frc, routerGrid, null, null, null);
        }
    }

    private void mergeInheritedLinks(Set linkSet, String srcID, BusProperties props, GenomeInstance gi, Layout targetLayout, FontRenderContext frc) {
        Iterator lsit = linkSet.iterator();
        while (lsit.hasNext()) {
            String linkID = (String)lsit.next();
            Linkage currLink = gi.getLinkage(linkID);
            BusProperties bp = props;
            LinkBusDrop keepDrop = bp.getTargetDrop(linkID);
            BusProperties spTree = new BusProperties(bp, (BusDrop)keepDrop);
            Vector2D offset = new Vector2D(0.0, 0.0);
            spTree = new BusProperties(spTree, srcID, linkID, offset);
            targetLayout.foldInNewProperty((LinkageInstance)currLink, gi, spTree, frc);
        }
    }

    private Vector2D nodesOkForLinkInherit(Linkage link, GenomeInstance gi, Layout sourceLayout, Layout targetLayout, Set missingNodes, Vector2D shift) {
        String src = link.getSource();
        String trg = link.getTarget();
        boolean srcMissing = missingNodes.contains(src);
        boolean trgMissing = missingNodes.contains(trg);
        if (srcMissing && trgMissing) {
            return shift;
        }
        NodeProperties np = sourceLayout.getNodeProperties(src);
        Point2D origSrcPos = np.getLocation();
        Point2D finalSrcPos = srcMissing ? shift.add(origSrcPos) : targetLayout.getNodeProperties(src).getLocation();
        np = sourceLayout.getNodeProperties(trg);
        Point2D origTrgPos = np.getLocation();
        Point2D finalTrgPos = trgMissing ? shift.add(origTrgPos) : targetLayout.getNodeProperties(trg).getLocation();
        Vector2D origDelta = new Vector2D(origSrcPos, origTrgPos);
        Vector2D finalDelta = new Vector2D(finalSrcPos, finalTrgPos);
        Vector2D retval = new Vector2D(origSrcPos, finalSrcPos);
        return origDelta.equals(finalDelta) ? retval : null;
    }

    private Set prunePointPairMap(Map ppMap, Set existingLinks, Vector2D shift) {
        HashSet<LinkPlacementGrid.PointPair> retval = new HashSet<LinkPlacementGrid.PointPair>();
        Iterator kit = ppMap.keySet().iterator();
        block0: while (kit.hasNext()) {
            LinkPlacementGrid.PointPair pp = (LinkPlacementGrid.PointPair)kit.next();
            List links = (List)ppMap.get(pp);
            int lnum = links.size();
            boolean gotIt = false;
            for (int i = 0; i < lnum; ++i) {
                String linkID = (String)links.get(i);
                if (!existingLinks.contains(linkID)) continue;
                pp.shift(shift);
                retval.add(pp);
                continue block0;
            }
        }
        return retval;
    }

    private Set getNeededLinksForGroup(GenomeInstance gi, Group group, Layout targetLayout) {
        HashSet<String> retval = new HashSet<String>();
        Set allLinks = this.getAllLinksForGroup(gi, group);
        Iterator alit = allLinks.iterator();
        while (alit.hasNext()) {
            String linkID = (String)alit.next();
            if (targetLayout.getLinkProperties(linkID) != null) continue;
            retval.add(linkID);
        }
        return retval;
    }

    private Set getExistingLinksForGroup(GenomeInstance gi, Group group, Layout targetLayout) {
        HashSet<String> retval = new HashSet<String>();
        Set allLinks = this.getAllLinksForGroup(gi, group);
        Iterator alit = allLinks.iterator();
        while (alit.hasNext()) {
            String linkID = (String)alit.next();
            if (targetLayout.getLinkProperties(linkID) == null) continue;
            retval.add(linkID);
        }
        return retval;
    }

    private Set getAllLinksForGroup(GenomeInstance gi, Group group) {
        HashSet<String> retval = new HashSet<String>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            Linkage link = (Linkage)glit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (!group.isInGroup(src, gi) || !group.isInGroup(trg, gi)) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    private void copyResultsBack(Layout sourceLayout, Layout targetLayout, Map sourceBounds, Map targetBounds) {
        targetLayout.replaceContents(sourceLayout);
        Iterator sbkit = sourceBounds.keySet().iterator();
        while (sbkit.hasNext()) {
            String key = (String)sbkit.next();
            Rectangle currBounds = (Rectangle)sourceBounds.get(key);
            targetBounds.put(key, new Rectangle(currBounds));
        }
    }

    private void mergeGroupLayouts(Layout instanceLayout, Map regionsByColumn, Map layouts, Map loBounds, Map moduleLinkFragShifts, int borderSize, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int baseGroupOrder = instanceLayout.getTopGroupOrder();
        boolean doDown = regionsByColumn.size() > 1;
        Iterator rbcit = regionsByColumn.keySet().iterator();
        int startX = 0;
        while (rbcit.hasNext()) {
            Integer col = (Integer)rbcit.next();
            List grpList = (List)regionsByColumn.get(col);
            int glSize = grpList.size();
            TopLeftPacker tlp = new TopLeftPacker();
            ArrayList<PlacementElement> packElems = new ArrayList<PlacementElement>();
            for (int i = 0; i < glSize; ++i) {
                String gpID = (String)grpList.get(i);
                Rectangle currBounds = (Rectangle)loBounds.get(gpID);
                packElems.add(new PlacementElement((Rectangle)currBounds.clone(), gpID));
            }
            HashMap points = new HashMap();
            int maxX = doDown ? tlp.placeElementsDownward(packElems, points, borderSize * 10, monitor) : tlp.placeElements(packElems, points, borderSize * 10, monitor);
            for (int i = 0; i < glSize; ++i) {
                String gpID = (String)grpList.get(i);
                Layout currLO = (Layout)layouts.get(gpID);
                Rectangle currBounds = (Rectangle)loBounds.get(gpID);
                Point topLeft = (Point)points.get(gpID);
                Vector2D toOrigin = new Vector2D(-currBounds.x, -currBounds.y);
                Vector2D offset = new Vector2D(startX + topLeft.x, topLeft.y);
                Vector2D total = toOrigin.add(offset);
                instanceLayout.mergeLayoutOfRegion(currLO, total, false, false, baseGroupOrder, moduleLinkFragShifts, gpID);
                currBounds.x += (int)total.getX();
                currBounds.y += (int)total.getY();
                if (monitor == null || monitor.keepGoing()) continue;
                throw new AsynchExitRequestException();
            }
            startX += maxX;
        }
    }

    private Map findNewRegionPaddings(Map crossTuples, int padPerLink, CrossLinkRecovery recovery, Set groups) {
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        Iterator rpit = recovery.perSrcMap.keySet().iterator();
        while (rpit.hasNext()) {
            String srcID = (String)rpit.next();
            PerSrcData psd = (PerSrcData)recovery.perSrcMap.get(srcID);
            HashSet<LinkSegmentID> seenMixedSegs = new HashSet<LinkSegmentID>();
            Iterator fsit = psd.perLinkMap.keySet().iterator();
            while (fsit.hasNext()) {
                String linkID = (String)fsit.next();
                Link cfl = (Link)crossTuples.get(linkID);
                String srcRegID = cfl.getSrc();
                String trgRegID = cfl.getTrg();
                if (groups != null && !groups.contains(srcRegID) && !groups.contains(trgRegID)) continue;
                String parentReg = null;
                PerLinkData pld = (PerLinkData)psd.perLinkMap.get(linkID);
                int numSegs = pld.segIDList.size();
                for (int i = 0; i < numSegs; ++i) {
                    String pointRegion;
                    LinkSegmentID nextSeg = (LinkSegmentID)pld.segIDList.get(i);
                    PerPointData ppd = (PerPointData)psd.perPointMap.get(nextSeg);
                    String string = pointRegion = ppd.regionID == null ? srcRegID : ppd.regionID;
                    if (pointRegion.equals(trgRegID)) {
                        boolean iAmMixed = false;
                        if (!seenMixedSegs.contains(nextSeg)) {
                            if (parentReg == null) {
                                if (!pointRegion.equals(srcRegID)) {
                                    iAmMixed = true;
                                }
                            } else if (!parentReg.equals(pointRegion)) {
                                iAmMixed = true;
                            }
                        }
                        if (iAmMixed) {
                            seenMixedSegs.add(nextSeg);
                            Integer countObj = (Integer)retval.get(trgRegID);
                            if (countObj == null) {
                                retval.put(trgRegID, new Integer(padPerLink));
                            } else {
                                retval.put(trgRegID, new Integer(countObj + padPerLink));
                            }
                        }
                    }
                    parentReg = pointRegion;
                }
            }
        }
        return retval;
    }

    private Map mergeExpandedGroupLayouts(Layout instanceLayout, Map newRegionBounds, Map savedRegionBounds, Map layouts, Map regionPads, List fixedElements, Map moduleLinkFragShifts, boolean foldOverlays, String nameOwner) {
        Map deltas = this.calcRegionGrowthOffsets(newRegionBounds, savedRegionBounds, fixedElements, regionPads);
        int baseGroupOrder = instanceLayout.getTopGroupOrder();
        Iterator lit = layouts.keySet().iterator();
        while (lit.hasNext()) {
            String key = (String)lit.next();
            Layout grpLo = (Layout)layouts.get(key);
            Vector2D delta = (Vector2D)deltas.get(key);
            if (delta == null) continue;
            boolean doName = nameOwner != null && nameOwner.equals(key);
            instanceLayout.mergeLayoutOfRegion(grpLo, delta, foldOverlays, doName, baseGroupOrder, moduleLinkFragShifts, key);
        }
        return deltas;
    }

    private void clipGroupLayouts(Map newRegionBounds, Map layouts, Map oldToNewShapes) {
        Iterator lit = layouts.keySet().iterator();
        while (lit.hasNext()) {
            String key = (String)lit.next();
            Layout grpLo = (Layout)layouts.get(key);
            Rectangle2D nrb = (Rectangle2D)newRegionBounds.get(key);
            Map oldToNewForGroup = (Map)oldToNewShapes.get(key);
            grpLo.clipExpandedModulesToGroup(nrb, oldToNewForGroup);
        }
    }

    private LinkRouter.RoutingResult layoutSomeLinks(Set toDo, Layout targLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Map linkColors, BTProgressMonitor monitor, double startFrac, double endFrac, boolean doExpandContract, Map rememberProps, boolean strictOKGroups) throws AsynchExitRequestException {
        TreeSet insertCols;
        TreeSet insertRows;
        Layout etempLayout;
        int mult;
        if (toDo.isEmpty()) {
            if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return new LinkRouter.RoutingResult();
        }
        if (!doExpandContract) {
            return this.layoutSomeLinksCore(toDo, targLayout, gi, options, frc, linkColors, monitor, startFrac, endFrac, rememberProps, null, strictOKGroups);
        }
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.33;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.33;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.33;
        double eFrac3 = eFrac2 + frac3;
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(targLayout.getName());
        Layout tempLayout = new Layout(targLayout);
        LinkRouter.RoutingResult res = this.layoutSomeLinksCore(toDo, tempLayout, gi, options, frc, linkColors, monitor, startFrac, eFrac1, rememberProps, null, strictOKGroups);
        if ((res.linkResult & 2) == 0) {
            targLayout.replaceContents(tempLayout);
            return res;
        }
        Set targCollide = gi.hasLinkTargetPadCollisions();
        if (!targCollide.isEmpty()) {
            targLayout.replaceContents(tempLayout);
            return res;
        }
        int maxPasses = 3;
        double currProg = eFrac1;
        double progFrac = frac2 / (double)maxPasses;
        double progFracFrac = progFrac / 2.0;
        for (mult = 1; mult <= maxPasses; ++mult) {
            etempLayout = new Layout(targLayout);
            insertRows = new TreeSet();
            insertCols = new TreeSet();
            etempLayout.chooseExpansionRows(gi, frc, 1.0, 1.0, null, loModKeys, insertRows, insertCols, true, monitor);
            Layout.ExpansionReversal er = etempLayout.expand(gi, insertRows, insertCols, mult, true, frc, null, null, null, monitor, currProg, currProg + progFracFrac);
            LinkRouter.RoutingResult eres = this.layoutSomeLinksCore(toDo, etempLayout, gi, options, frc, linkColors, monitor, currProg += progFracFrac, currProg + progFracFrac, rememberProps, null, strictOKGroups);
            currProg += progFracFrac;
            if ((eres.linkResult & 2) != 0) continue;
            etempLayout.reverseExpansion(gi, frc, er, monitor, currProg, eFrac3);
            targLayout.replaceContents(etempLayout);
            return eres;
        }
        currProg = eFrac2;
        progFrac = frac3 / (double)maxPasses;
        progFracFrac = progFrac / 2.0;
        for (mult = 1; mult <= maxPasses; ++mult) {
            etempLayout = new Layout(targLayout);
            insertRows = new TreeSet();
            insertCols = new TreeSet();
            etempLayout.chooseExpansionRows(gi, frc, 1.0, 1.0, null, loModKeys, insertRows, insertCols, false, monitor);
            etempLayout.expand(gi, insertRows, insertCols, mult, false, frc, null, null, null, monitor, currProg, currProg + progFracFrac);
            LinkRouter.RoutingResult eres = this.layoutSomeLinksCore(toDo, etempLayout, gi, options, frc, linkColors, monitor, currProg += progFracFrac, currProg + progFracFrac, rememberProps, null, strictOKGroups);
            currProg += progFracFrac;
            if ((eres.linkResult & 2) != 0) continue;
            targLayout.replaceContents(etempLayout);
            return eres;
        }
        targLayout.replaceContents(tempLayout);
        return res;
    }

    private LinkRouter.RoutingResult layoutSomeLinksCore(Set toDo, Layout tempLayout, GenomeInstance gi, LayoutOptions options, FontRenderContext frc, Map linkColors, BTProgressMonitor monitor, double startFrac, double endFrac, Map rememberProps, Map recoveryDataMap, boolean strictOKGroups) throws AsynchExitRequestException {
        LinkRouter router = new LinkRouter();
        router.initGrid(gi, tempLayout, frc, null, 1, monitor);
        Iterator xrit = toDo.iterator();
        while (xrit.hasNext()) {
            String linkID = (String)xrit.next();
            AddCommands.autoAddCrudeLinkProperties(gi, tempLayout, linkID, null, rememberProps, frc);
        }
        HashSet needColors = new HashSet();
        LinkRouter.RoutingResult retval = router.multiPassLayout(gi, toDo, tempLayout, frc, options, monitor, needColors, startFrac, endFrac, recoveryDataMap, strictOKGroups);
        Iterator ncit = needColors.iterator();
        while (ncit.hasNext()) {
            String linkID = (String)ncit.next();
            String linkCol = (String)linkColors.get(linkID);
            if (linkCol == null && (linkCol = (String)linkColors.get(GenomeItemInstance.getBaseID(linkID))) == null) continue;
            BusProperties lp = tempLayout.getLinkProperties(linkID);
            lp.setColor(linkCol);
        }
        return retval;
    }

    private Point2D shiftNewNodeWithAffineCombo(Layout groupLayout, String newNode, GenomeInstance gi, Group group, Layout targetLayout) {
        ArrayList<Point2D> origPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        Point2D origPoint = null;
        Iterator mit = group.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            NodeProperties nProp = targetLayout.getNodeProperties(nodeID);
            NodeProperties oProp = groupLayout.getNodeProperties(nodeID);
            if (nProp != null) {
                if (!nodeID.equals(newNode)) {
                    origPoints.add(oProp.getLocation());
                    newPoints.add(nProp.getLocation());
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (!nodeID.equals(newNode)) continue;
            origPoint = oProp.getLocation();
        }
        if (origPoint == null) {
            throw new IllegalArgumentException();
        }
        if (origPoints.size() < 3) {
            return new Point2D.Double(0.0, 0.0);
        }
        List weights = AffineCombination.getWeights(origPoints, origPoint);
        if (weights == null) {
            return new Point2D.Double(0.0, 0.0);
        }
        int numWeights = weights.size();
        double[] weightArray = new double[numWeights];
        for (int i = 0; i < numWeights; ++i) {
            weightArray[i] = (Double)weights.get(i);
        }
        return AffineCombination.combination(newPoints, weightArray, 10.0);
    }

    private Set prepareNodeCohort(String nodeID, GenomeInstance gi) {
        String trg;
        String src;
        Linkage link;
        HashSet retval = new HashSet();
        HashSet<String> parentIDs = new HashSet<String>();
        HashSet<String> childIDs = new HashSet<String>();
        HashSet<String> siblingIDs = new HashSet<String>();
        Iterator glit = gi.getLinkageIterator();
        while (glit.hasNext()) {
            link = (Linkage)glit.next();
            src = link.getSource();
            trg = link.getTarget();
            if (src.equals(nodeID)) {
                childIDs.add(trg);
            }
            if (!trg.equals(nodeID)) continue;
            parentIDs.add(src);
        }
        if (!parentIDs.isEmpty()) {
            glit = gi.getLinkageIterator();
            while (glit.hasNext()) {
                link = (Linkage)glit.next();
                src = link.getSource();
                trg = link.getTarget();
                if (!parentIDs.contains(src)) continue;
                siblingIDs.add(trg);
            }
        }
        retval.addAll(parentIDs);
        retval.addAll(childIDs);
        retval.addAll(siblingIDs);
        return retval;
    }

    private Set reduceNodeSetForGroup(Set nodeSet, String newNode, GenomeInstance gi, Group group, Layout targetLayout) {
        HashSet<String> retval = new HashSet<String>();
        Iterator mit = group.getMemberIterator();
        while (mit.hasNext()) {
            NodeProperties nProp;
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            if (!nodeSet.contains(nodeID) || (nProp = targetLayout.getNodeProperties(nodeID)) == null) continue;
            retval.add(nodeID);
        }
        return retval;
    }

    private Point2D getCentroid(Set newNodes, Layout groupLayout) {
        HashSet<Point2D> newNodePoints = new HashSet<Point2D>();
        Iterator nnit = newNodes.iterator();
        while (nnit.hasNext()) {
            String newNode = (String)nnit.next();
            Point2D origPoint = groupLayout.getNodeProperties(newNode).getLocation();
            if (origPoint == null) {
                throw new IllegalArgumentException();
            }
            newNodePoints.add(origPoint);
        }
        return AffineCombination.combination(newNodePoints, 0.0);
    }

    private Vector2D shiftNewNodesWithPolarCoords(Set refNodes, Set newNodes, Point2D newNodesCentroid, Layout groupLayout, Layout targetLayout) {
        HashSet<Point2D> origRefPoints = new HashSet<Point2D>();
        HashSet<Point2D> newRefPoints = new HashSet<Point2D>();
        Iterator mit = refNodes.iterator();
        while (mit.hasNext()) {
            String nodeID = (String)mit.next();
            NodeProperties nProp = targetLayout.getNodeProperties(nodeID);
            NodeProperties oProp = groupLayout.getNodeProperties(nodeID);
            if (nProp == null || newNodes.contains(nodeID)) {
                throw new IllegalArgumentException();
            }
            origRefPoints.add(oProp.getLocation());
            newRefPoints.add(nProp.getLocation());
        }
        Point2D finalPos = AffineCombination.radialPointPosition(origRefPoints, newNodesCentroid, newRefPoints);
        return new Vector2D(newNodesCentroid, finalPos);
    }

    private Vector2D placeWithGrid(GenomeInstance gi, Layout groupLayout, Set missingNodes, Set refNodes, Layout targetLayout, FontRenderContext frc, Vector2D seedVec) {
        LinkRouter router = new LinkRouter();
        Object corner = null;
        HashSet<String> skipLinks = new HashSet<String>();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            if (targetLayout.getLinkProperties(linkID) != null) continue;
            skipLinks.add(linkID);
        }
        LinkPlacementGrid targLinkGrid = router.initLimitedGrid(gi, targetLayout, frc, refNodes, skipLinks, 1);
        PatternGrid targGrid = targLinkGrid.extractPatternGrid(true);
        PatternGrid newGrid = groupLayout.partialFillPatternGridWithNodes(gi, frc, missingNodes);
        Pattern pat = newGrid.generatePattern();
        if (pat == null) {
            return seedVec;
        }
        MinMax yRange = newGrid.getMinMaxYForRange(null);
        MinMax xRange = newGrid.getMinMaxXForRange(null);
        Point2D.Double initialCorner = new Point2D.Double((double)xRange.min * 10.0, (double)yRange.min * 10.0);
        Point2D prefCorner = seedVec.add(initialCorner);
        UiUtil.forceToGrid(prefCorner.getX(), prefCorner.getY(), prefCorner, 10.0);
        Point startPt = new Point((int)prefCorner.getX() / 10, (int)prefCorner.getY() / 10);
        Point startPt10 = new Point((int)prefCorner.getX(), (int)prefCorner.getY());
        PatternPlacerSpiral pps = new PatternPlacerSpiral(targGrid, pat, startPt, 1, 10);
        Point retval = pps.locatePattern();
        pps.sinkPattern(retval);
        Point2D.Double retval10 = new Point2D.Double(retval.getX() * 10.0, retval.getY() * 10.0);
        return seedVec.add(new Vector2D(startPt10, retval10));
    }

    class ClaimedAndUnclaimed {
        Map claimedSlices;
        Map unclaimedSlices;

        ClaimedAndUnclaimed(Map claimedSlices, Map unclaimedSlices) {
            this.claimedSlices = claimedSlices;
            this.unclaimedSlices = unclaimedSlices;
        }

        String whoOwnName() {
            if (this.claimedSlices != null) {
                Iterator csit = this.claimedSlices.keySet().iterator();
                while (csit.hasNext()) {
                    String grpID = (String)csit.next();
                    Map diceMap = (Map)this.claimedSlices.get(grpID);
                    Iterator dmit = diceMap.keySet().iterator();
                    while (dmit.hasNext()) {
                        NetModule.FullModuleKey oldKey = (NetModule.FullModuleKey)dmit.next();
                        Layout.DicedModuleInfo dmi = (Layout.DicedModuleInfo)diceMap.get(oldKey);
                        int numDS = dmi.dicedShapes.size();
                        for (int i = 0; i < numDS; ++i) {
                            NetModuleProperties.TaggedShape ts = (NetModuleProperties.TaggedShape)dmi.dicedShapes.get(i);
                            if (!ts.isName) continue;
                            return grpID;
                        }
                    }
                }
            }
            return null;
        }
    }

    private class Empties {
        TreeSet emptyRows = new TreeSet();
        TreeSet emptyCols = new TreeSet();

        Empties() {
        }
    }

    private class TreeMergePerRegion {
        BusProperties bp;
        Map dicePts;
        Map targStubs;
        String trgGrpID;
        Set linksToTarg;

        TreeMergePerRegion(BusProperties bp, Map dicePts, Map targStubs, String trgGrpID, Set linksToTarg) {
            this.bp = bp;
            this.dicePts = dicePts;
            this.targStubs = targStubs;
            this.trgGrpID = trgGrpID;
            this.linksToTarg = linksToTarg;
        }
    }

    private class TreeSpliceData {
        boolean isBoundary;
        boolean originalOrthoInbound;
        Vector2D originalInboundRun;
        RegionBasedPosition spliceRbp;
        String trgGrpID;
        String trgNodeID;

        TreeSpliceData(String trgGrpID, String trgNodeID) {
            this.isBoundary = false;
            this.trgGrpID = trgGrpID;
            this.trgNodeID = trgNodeID;
        }

        TreeSpliceData(boolean originalOrthoInbound, Vector2D originalInboundRun, RegionBasedPosition spliceRbp, String trgGrpID, String trgNodeID) {
            this.isBoundary = true;
            this.originalOrthoInbound = originalOrthoInbound;
            this.originalInboundRun = originalInboundRun;
            this.spliceRbp = spliceRbp;
            this.trgGrpID = trgGrpID;
            this.trgNodeID = trgNodeID;
        }

        public String toString() {
            return "TreeSpliceData: isBoundary = " + this.isBoundary + " originalOrthoInbound = " + this.originalOrthoInbound + " originalInboundRun = " + this.originalInboundRun + " spliceRbp = " + this.spliceRbp + "trgGrpID = " + this.trgGrpID + " trgNodeID = " + this.trgNodeID;
        }
    }

    private class WhipCandidate {
        Point2D point;
        LinkSegmentID lsid;
        RegionBasedPosition rbp;
        HashSet links;

        WhipCandidate(Point2D point, LinkSegmentID lsid, RegionBasedPosition rbp, String currLink) {
            this.point = point;
            this.lsid = lsid;
            this.rbp = rbp;
            this.links = new HashSet();
            this.links.add(currLink);
        }

        void addSupportedLink(String linkID) {
            this.links.add(linkID);
        }

        public String toString() {
            return "WhipCandidate: point = " + this.point + " lsid = " + this.lsid + " rbp = " + this.rbp + " links = " + this.links;
        }
    }

    private class GenericBPSource {
        Layout useLayout;
        Map useMap;
        Genome genome;

        GenericBPSource(Layout useLayout) {
            this.useLayout = useLayout;
            this.useMap = null;
        }

        GenericBPSource(Map useMap, Genome genome) {
            this.useLayout = null;
            this.useMap = useMap;
            this.genome = genome;
        }

        BusProperties getLinkProperties(String linkID) {
            if (this.useLayout != null) {
                return this.useLayout.getLinkProperties(linkID);
            }
            Linkage link = this.genome.getLinkage(linkID);
            return (BusProperties)this.useMap.get(link.getSource());
        }
    }

    private static class RegionBasedSorter
    implements Iterator {
        TreeMap bins = new TreeMap();
        int currIndex = 0;
        ArrayList results;

        RegionBasedSorter(RegionBasedPosition home, List candidates) {
            int numCand = candidates.size();
            for (int i = 0; i < numCand; ++i) {
                Double circumObj;
                TreeMap<LinkSegmentID, WhipCandidate> lastMap;
                Double distObj;
                TreeMap<Double, TreeMap<LinkSegmentID, WhipCandidate>> perDist;
                Integer binObj;
                TreeMap rankings;
                WhipCandidate wc = (WhipCandidate)candidates.get(i);
                LinkSegmentID lsid = wc.lsid;
                RegionBasedPosition other = wc.rbp;
                int bin = home.distanceBin(other);
                if (bin == 1) {
                    bin = 0;
                }
                if ((rankings = (TreeMap)this.bins.get(binObj = new Integer(bin))) == null) {
                    rankings = new TreeMap();
                    this.bins.put(binObj, rankings);
                }
                if ((perDist = (TreeMap<Double, TreeMap<LinkSegmentID, WhipCandidate>>)rankings.get(distObj = new Double(other.regionBasedDef.offset.length()))) == null) {
                    perDist = new TreeMap<Double, TreeMap<LinkSegmentID, WhipCandidate>>();
                    rankings.put(distObj, perDist);
                }
                if ((lastMap = (TreeMap<LinkSegmentID, WhipCandidate>)perDist.get(circumObj = new Double(home.normDistance(other)))) == null) {
                    lastMap = new TreeMap<LinkSegmentID, WhipCandidate>();
                    perDist.put(circumObj, lastMap);
                }
                lastMap.put(lsid, wc);
            }
            this.results = new ArrayList();
            Iterator binit = this.bins.values().iterator();
            while (binit.hasNext()) {
                TreeMap rankings = (TreeMap)binit.next();
                Iterator rankit = rankings.values().iterator();
                while (rankit.hasNext()) {
                    TreeMap perDist = (TreeMap)rankit.next();
                    Iterator finit = perDist.values().iterator();
                    while (finit.hasNext()) {
                        TreeMap lastMap = (TreeMap)finit.next();
                        Iterator lastit = lastMap.values().iterator();
                        while (lastit.hasNext()) {
                            WhipCandidate result = (WhipCandidate)lastit.next();
                            this.results.add(result);
                        }
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.currIndex < this.results.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.results.get(this.currIndex++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RegionBasedPosition {
        static final int TOP = 0;
        static final int TOP_RIGHT = 1;
        static final int RIGHT = 2;
        static final int BOTTOM_RIGHT = 3;
        static final int BOTTOM = 4;
        static final int BOTTOM_LEFT = 5;
        static final int LEFT = 6;
        static final int TOP_LEFT = 7;
        PointAndVec regionBasedDef;
        int regionBasedApprox;
        LinkSegmentID partialDefinition;
        String partialDefinitionByNodeID;
        int partialPadDefinition;
        boolean partialIsLaunch;

        RegionBasedPosition() {
        }

        public String toString() {
            return "RegionBasedPosition: regionBasedDef = " + this.regionBasedDef + " and other data...";
        }

        int distanceBin(RegionBasedPosition other) {
            int otherPosition;
            int myPosition = this.getPosition();
            int diff = Math.abs(myPosition - (otherPosition = other.getPosition()));
            if (diff > 4) {
                diff = 8 - diff;
            }
            return diff;
        }

        boolean goClockwise(RegionBasedPosition other) {
            int myPosition = this.getPosition();
            int bin = this.distanceBin(other);
            if (bin == 0) {
                throw new IllegalArgumentException();
            }
            return bin + myPosition > 7;
        }

        double normDistance(RegionBasedPosition other) {
            int bin = this.distanceBin(other);
            if (bin == 0) {
                if (this.isOnCorner()) {
                    double myDot = this.cornerDot(true);
                    double otherDot = other.cornerDot(true);
                    return Math.abs(myDot - otherDot);
                }
                double myEdge = this.alongEdge(true);
                double otherEdge = other.alongEdge(true);
                return Math.abs(myEdge - otherEdge);
            }
            if (bin == 4) {
                double clockDist = 0.0;
                clockDist = this.isOnCorner() ? this.cornerDot(false) + other.cornerDot(true) : this.alongEdge(false) + other.alongEdge(true);
                double counterDist = 0.0;
                counterDist = this.isOnCorner() ? this.cornerDot(true) + other.cornerDot(false) : this.alongEdge(true) + other.alongEdge(false);
                return Math.max(clockDist, counterDist) + 3.0;
            }
            boolean goClock = this.goClockwise(other);
            double dist = this.isOnCorner() ? this.cornerDot(!goClock) : this.alongEdge(!goClock);
            dist += (double)(bin - 1);
            return dist += other.isOnCorner() ? other.cornerDot(goClock) : other.alongEdge(goClock);
        }

        double alongEdge(boolean doClockwise) {
            double clockDiff;
            int myPos = this.getPosition();
            switch (myPos) {
                case 0: {
                    clockDiff = this.regionBasedDef.origin.getX();
                    break;
                }
                case 2: {
                    clockDiff = this.regionBasedDef.origin.getY();
                    break;
                }
                case 4: {
                    clockDiff = 1.0 - this.regionBasedDef.origin.getX();
                    break;
                }
                case 6: {
                    clockDiff = 1.0 - this.regionBasedDef.origin.getY();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return doClockwise ? clockDiff : 1.0 - clockDiff;
        }

        double cornerDot(boolean doClockwise) {
            Vector2D testVec;
            int myPos = this.getPosition();
            switch (myPos) {
                case 1: {
                    testVec = new Vector2D(1.0, 0.0);
                    break;
                }
                case 3: {
                    testVec = new Vector2D(0.0, 1.0);
                    break;
                }
                case 5: {
                    testVec = new Vector2D(-1.0, 0.0);
                    break;
                }
                case 7: {
                    testVec = new Vector2D(0.0, -1.0);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Vector2D normVec = this.regionBasedDef.offset;
            if (normVec.isZero()) {
                return 0.0;
            }
            normVec = normVec.normalized();
            double clockDot = testVec.dot(normVec);
            return doClockwise ? clockDot : 1.0 - clockDot;
        }

        boolean isOnCorner() {
            int myPos = this.getPosition();
            return myPos == 1 || myPos == 3 || myPos == 5 || myPos == 7;
        }

        int getPosition() {
            double myY;
            Point2D myPoint = this.regionBasedDef.origin;
            double myX = myPoint.getX();
            if (Math.abs(myX) < 0.001) {
                myX = 0.0;
            }
            if (Math.abs(1.0 - myX) < 0.001) {
                myX = 1.0;
            }
            if (Math.abs(myY = myPoint.getY()) < 0.001) {
                myY = 0.0;
            }
            if (Math.abs(1.0 - myY) < 0.001) {
                myY = 1.0;
            }
            if (myX == 0.0) {
                if (myY == 0.0) {
                    return 7;
                }
                if (myY == 1.0) {
                    return 5;
                }
                return 6;
            }
            if (myX == 1.0) {
                if (myY == 0.0) {
                    return 1;
                }
                if (myY == 1.0) {
                    return 3;
                }
                return 2;
            }
            if (myY == 0.0) {
                return 0;
            }
            if (myY == 1.0) {
                return 4;
            }
            throw new IllegalStateException();
        }
    }

    private class PerPointData {
        String regionID;
        Point2D originalLoc;
        boolean originalOrthoInbound;
        Vector2D originalInboundRun;
        LinkProperties.CornerDoF dof;
        String fixedLinkID;
        LinkSegmentID newRef;
        Vector2D offset;
        String refNodeID;
        RegionBasedPosition regionBased;

        PerPointData() {
        }
    }

    private class PerLinkData {
        BusProperties spTree;
        ArrayList segIDList;
        LinkSegmentID srcBoundPt;
        LinkSegmentID trgBoundPt;

        PerLinkData(BusProperties spTree) {
            this.spTree = spTree;
            this.segIDList = new ArrayList();
            this.srcBoundPt = null;
            this.trgBoundPt = null;
        }
    }

    private class PerSrcData {
        BusProperties fullTree;
        HashMap perPointMap;
        HashMap perLinkMap;
        HashSet assocRegions;
        Map departChops;
        Map arriveChops;

        PerSrcData(BusProperties fullTree, Map departChops, Map arriveChops) {
            this.fullTree = fullTree;
            this.perPointMap = new HashMap();
            this.perLinkMap = new HashMap();
            this.assocRegions = new HashSet();
            this.departChops = departChops;
            this.arriveChops = arriveChops;
        }
    }

    public class CrossLinkRecovery {
        Map perSrcMap;
        Set recoveredLinks;
        Map exemptions;

        CrossLinkRecovery(Map perSrcMap, Set recoveredLinks, Map exemptions) {
            this.perSrcMap = perSrcMap;
            this.recoveredLinks = recoveredLinks;
            this.exemptions = exemptions;
        }

        void merge(Map targetClrs) {
        }
    }

    private class FoldDirections {
        String iid;
        Linkage giLink;
        String giLinkSrc;
        LayoutDataSource lds;

        FoldDirections(String iid, Linkage giLink, String giLinkSrc, LayoutDataSource lds) {
            this.iid = iid;
            this.giLink = giLink;
            this.giLinkSrc = giLinkSrc;
            this.lds = lds;
        }
    }

    private static class StandardExpander
    extends RegionExpander {
        private double fracV_;
        private double fracH_;

        StandardExpander(double fracV, double fracH) {
            this.fracV_ = fracV;
            this.fracH_ = fracH;
        }

        protected void customExpandTheRegion(String grpID, double startFrac, double endFrac) throws AsynchExitRequestException {
            this.layout.chooseExpansionRows(this.gi, this.frc, this.fracV_, this.fracH_, this.oldBounds, this.loModKeys, this.insertRows, this.insertCols, false, this.monitor);
            this.grpLo.expand(this.gi, this.insertRows, this.insertCols, 1, false, this.frc, this.oldToNewShapesPerGroup, this.moduleLinkFragShifts, grpID, this.monitor, startFrac, endFrac);
        }

        public Rectangle getGroupBounds(String grpID) {
            Group grp = this.gi.getGroup(grpID);
            this.grpLo = (Layout)this.layouts.get(grpID);
            return this.grpLo.getLayoutBoundsForGroup(this.gi, grp, this.frc, true);
        }
    }

    public static class EdgeMove {
        public UiUtil.PointAndSide pas;
        public String srcID;
        public LinkSegmentID lsid;
        public String regionID;
        RegionBasedPosition regPos;

        public EdgeMove(UiUtil.PointAndSide pas, String srcID, String regionID) {
            this.pas = pas;
            this.srcID = srcID;
            this.lsid = null;
            this.regionID = regionID;
        }

        public Vector2D getEdgeDirectionOutbound() {
            return this.pas.outboundSideVec();
        }

        public Point2D getEdgePoint() {
            return this.pas.point;
        }

        public String toString() {
            return "EdgeMove: pas:" + this.pas + " src = " + this.srcID + " lsid = " + this.lsid + " regID = " + this.regionID + " regPos = " + this.regPos;
        }
    }

    public static abstract class RegionExpander {
        protected GenomeInstance gi;
        protected Layout layout;
        protected Map oldRegionBounds;
        protected Map oldToNewShapes;
        protected Map layouts;
        protected FontRenderContext frc;
        protected Map moduleLinkFragShifts;
        protected Layout.OverlayKeySet loModKeys;
        protected CrossLinkRecovery recovery;
        protected BTProgressMonitor monitor;
        protected HashMap deltas;
        protected Map chopDeparts;
        protected Map chopArrives;
        protected HashMap oldToNewShapesPerGroup;
        protected Rectangle oldBounds;
        protected Layout grpLo;
        protected TreeSet insertRows;
        protected TreeSet insertCols;

        protected RegionExpander() {
        }

        protected RegionExpander(Map chopDeparts, Map chopArrives) {
            this.chopDeparts = chopDeparts;
            this.chopArrives = chopArrives;
        }

        public void setup(GenomeInstance gi, Layout layout, Map oldRegionBounds, Map oldToNewShapes, Map layouts, FontRenderContext frc, Map moduleLinkFragShifts, Layout.OverlayKeySet loModKeys, CrossLinkRecovery recovery, BTProgressMonitor monitor) {
            this.gi = gi;
            this.layout = layout;
            this.oldRegionBounds = oldRegionBounds;
            this.oldToNewShapes = oldToNewShapes;
            this.layouts = layouts;
            this.frc = frc;
            this.moduleLinkFragShifts = moduleLinkFragShifts;
            this.loModKeys = loModKeys;
            this.recovery = recovery;
            this.monitor = monitor;
        }

        public void expandTheRegion(String grpID, double startFrac, double endFrac) throws AsynchExitRequestException {
            this.oldToNewShapesPerGroup = new HashMap();
            this.oldToNewShapes.put(grpID, this.oldToNewShapesPerGroup);
            this.oldBounds = (Rectangle)this.oldRegionBounds.get(grpID);
            this.grpLo = (Layout)this.layouts.get(grpID);
            this.insertRows = new TreeSet();
            this.insertCols = new TreeSet();
            this.customExpandTheRegion(grpID, startFrac, endFrac);
            LayoutRubberStamper.expandOrCompressRecoveryPaths(true, this.grpLo, grpID, this.insertRows, this.insertCols, 1, this.recovery);
        }

        public void setDeltas(Map deltas) {
            this.deltas = new HashMap(deltas);
        }

        public Vector2D getDelta(String grpID) {
            if (this.deltas == null) {
                return null;
            }
            return (Vector2D)this.deltas.get(grpID);
        }

        public Map getChopDeparts() {
            return this.chopDeparts;
        }

        public Map getChopArrives() {
            return this.chopArrives;
        }

        protected abstract void customExpandTheRegion(String var1, double var2, double var4) throws AsynchExitRequestException;

        public abstract Rectangle getGroupBounds(String var1);
    }
}

