/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public abstract class LinkBusDrop
implements Cloneable {
    protected String targetRef_;
    protected String connectTag_;
    protected int connectSense_;
    protected int dropType_;
    protected SuggestedDrawStyle dropDrawStyle_;
    protected PerLinkDrawStyle linkDrawStyle_;
    protected static final String XML_TAG = "drop";
    public static final int START_DROP = 0;
    public static final int END_DROP = 1;
    public static final int CONNECT_TO_START = 0;
    public static final int CONNECT_TO_END = 1;
    public static final int NO_SEGMENT_CONNECTION = 2;

    protected LinkBusDrop(LinkBusDrop other) {
        if (other.dropDrawStyle_ != null) {
            this.dropDrawStyle_ = (SuggestedDrawStyle)other.dropDrawStyle_.clone();
        }
        if (other.linkDrawStyle_ != null) {
            this.linkDrawStyle_ = (PerLinkDrawStyle)other.linkDrawStyle_.clone();
        }
        this.targetRef_ = other.targetRef_;
        this.connectTag_ = other.connectTag_;
        this.connectSense_ = other.connectSense_;
        this.dropType_ = other.dropType_;
    }

    protected LinkBusDrop(String targetRef, String ourConnection, int dropType, int connectionEnd) {
        this.dropType_ = dropType;
        this.connectTag_ = ourConnection;
        this.connectSense_ = connectionEnd;
        this.targetRef_ = targetRef;
    }

    protected LinkBusDrop(Layout layout, Genome genome, String startID, Attributes attrs) throws IOException {
        String targetRef = null;
        String connect = null;
        int connectType = 1;
        int connectEnd = 2;
        String specialLine = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("ref")) {
                    targetRef = val;
                    if (!val.equals("*")) continue;
                    targetRef = startID;
                    connectType = 0;
                    continue;
                }
                if (key.equals("connectStart")) {
                    connect = val;
                    connectEnd = 0;
                    continue;
                }
                if (key.equals("connectEnd")) {
                    connect = val;
                    connectEnd = 1;
                    continue;
                }
                if (!key.equals("specialLine")) continue;
                specialLine = val;
            }
        }
        if (targetRef == null) {
            throw new IOException();
        }
        int style = -1;
        try {
            if (specialLine != null) {
                style = LinkProperties.mapFromStyleTag(specialLine);
            }
        }
        catch (IllegalArgumentException iaex) {
            throw new IOException();
        }
        this.targetRef_ = connectType == 0 ? null : targetRef;
        this.dropType_ = connectType;
        this.connectTag_ = connect;
        this.connectSense_ = connectEnd;
        if (style != -1) {
            this.dropDrawStyle_ = SuggestedDrawStyle.buildFromLegacy(style);
        }
    }

    public void transferSpecialStyles(LinkBusDrop other) {
        if (other.dropDrawStyle_ != null) {
            this.dropDrawStyle_ = (SuggestedDrawStyle)other.dropDrawStyle_.clone();
        }
        if (other.linkDrawStyle_ != null) {
            this.linkDrawStyle_ = (PerLinkDrawStyle)other.linkDrawStyle_.clone();
        }
    }

    public Object clone() {
        try {
            LinkBusDrop retval = (LinkBusDrop)super.clone();
            if (this.dropDrawStyle_ != null) {
                retval.dropDrawStyle_ = (SuggestedDrawStyle)this.dropDrawStyle_.clone();
            }
            if (this.linkDrawStyle_ != null) {
                retval.linkDrawStyle_ = (PerLinkDrawStyle)this.linkDrawStyle_.clone();
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public boolean mapToNewLink(Map linkMap, Map nodeMap) {
        if (this.targetRef_ != null) {
            String newRef = (String)linkMap.get(this.targetRef_);
            if (newRef != null) {
                this.targetRef_ = newRef;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setDrawStyleForDrop(SuggestedDrawStyle drawStyle) {
        this.dropDrawStyle_ = drawStyle;
    }

    public void setDrawStyleForLink(PerLinkDrawStyle drawStyle) {
        if (this.dropType_ == 0) {
            throw new IllegalStateException();
        }
        this.linkDrawStyle_ = drawStyle;
    }

    public PerLinkDrawStyle getDrawStyleForLink() {
        if (this.dropType_ == 0) {
            throw new IllegalStateException();
        }
        return this.linkDrawStyle_;
    }

    public String getConnectionTag() {
        return this.connectTag_;
    }

    public void setConnectionTag(String connectTag) {
        this.connectTag_ = connectTag;
    }

    public int getConnectionSense() {
        return this.connectSense_;
    }

    public void setConnectionSense(int connectSense) {
        this.connectSense_ = connectSense;
    }

    public SuggestedDrawStyle getSpecialDropDrawStyle() {
        return this.dropDrawStyle_;
    }

    public String getTargetRef() {
        return this.targetRef_;
    }

    public void setTargetRef(String ref) {
        if (this.dropType_ == 0) {
            throw new IllegalArgumentException();
        }
        this.targetRef_ = ref;
    }

    public int getDropType() {
        return this.dropType_;
    }

    public void setDropType(int dropType) {
        this.dropType_ = dropType;
    }

    public String toString() {
        String ddss = this.dropDrawStyle_ != null ? this.dropDrawStyle_.toString() : "(no Special Style)";
        return " type = " + this.dropType_ + " ref = " + this.targetRef_ + " sense = " + this.connectSense_ + " tag = " + this.connectTag_ + " drop special = " + ddss;
    }

    protected void writeExtraXML(PrintWriter out, Indenter ind) {
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        out.print(" ref=\"");
        if (this.dropType_ == 0) {
            out.print("*");
        } else {
            out.print(this.targetRef_);
        }
        this.writeExtraXML(out, ind);
        if (this.connectSense_ == 1) {
            out.print("\" connectEnd=\"");
            out.print(this.connectTag_);
        } else if (this.connectSense_ == 0) {
            out.print("\" connectStart=\"");
            out.print(this.connectTag_);
        }
        if (this.dropDrawStyle_ != null || this.linkDrawStyle_ != null) {
            out.println("\" >");
            ind.up();
            if (this.dropDrawStyle_ != null) {
                this.dropDrawStyle_.writeXML(out, ind);
            }
            if (this.linkDrawStyle_ != null) {
                this.linkDrawStyle_.writeXML(out, ind);
            }
            ind.down().indent();
            out.print("</");
            out.print(XML_TAG);
            out.println(">");
        } else {
            out.println("\" />");
        }
    }
}

