/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.SegmentWithKids;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridRenderer;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LinkOptimizer {
    private static final int USELESS_CORNERS_ = 0;
    private static final int ORTHO_RUNS_ = 1;
    private static final int STAGGERED_RUNS_ = 2;
    private static final int SHORTER_PATHS_ = 3;
    private static final int NUM_OPTIMIZATIONS_ = 4;
    private double[] difficultyFull_ = new double[]{0.1, 0.6, 0.1, 0.2};
    private double[] difficultyPartial_ = new double[]{0.25, 0.75, 0.25};

    public int[] getOptimizations(boolean includeShorterPaths) {
        int size = includeShorterPaths ? 4 : 3;
        int[] retval = new int[size];
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == 3 && !includeShorterPaths) continue;
            retval[count++] = i;
        }
        return retval;
    }

    public double relativeDifficulty(int optType, boolean includeShorterPaths) {
        double[] use = includeShorterPaths ? this.difficultyFull_ : this.difficultyPartial_;
        return (double)use.length * use[optType];
    }

    public void optimizeLinks(int optType, LinkProperties lp, LinkPlacementGrid grid, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, Set pinnedPoints, double startFrac, double maxFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (lp.isDirect()) {
            return;
        }
        switch (optType) {
            case 0: {
                this.eliminateUselessCorners(lp, grid, genome, lo, frc, oso, overID, startFrac, maxFrac, monitor);
                return;
            }
            case 1: {
                this.optimizeOrthoRuns(lp, grid, genome, lo, frc, oso, overID, pinnedPoints, startFrac, maxFrac, monitor);
                return;
            }
            case 2: {
                this.eliminateStaggeredRuns(lp, grid, 4, genome, lo, frc, oso, overID, pinnedPoints, startFrac, maxFrac, monitor);
                return;
            }
            case 3: {
                if (!pinnedPoints.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                this.findShorterPaths(lp, grid, genome, lo, frc, oso, overID, startFrac, maxFrac, monitor);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean eliminateUselessCornersGridless(LinkProperties bp, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, double startFrac, double maxFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (bp.isDirect() || bp.getSegmentCount() == 1) {
            return false;
        }
        SegmentWithKids rootSK = bp.buildSegmentTree(genome, lo, frc);
        if (rootSK == null || !this.isOrthogonal(rootSK)) {
            return false;
        }
        double currProg = startFrac;
        double progDelta = (maxFrac - startFrac) / 100.0;
        boolean dropped = false;
        while (true) {
            boolean keepGoing;
            LinkSegmentID uselessID;
            if (bp.getSegmentCount() == 1) {
                if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return dropped;
            }
            SegmentWithKids useless = this.getUselessCornerRecursive(rootSK, null);
            if (useless == null) {
                if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return dropped;
            }
            LinkSegment uselessSeg = useless.segment;
            if (uselessSeg.isDegenerate()) {
                uselessID = LinkSegmentID.buildIDForStartDrop();
                uselessID.tagIDWithEndpoint("E");
            } else {
                uselessID = LinkSegmentID.buildIDForSegment(uselessSeg.getID());
                uselessID.tagIDWithEndpoint("E");
            }
            lo.deleteLinkageCornerForTree(bp, uselessID, overID);
            dropped = true;
            rootSK = bp.buildSegmentTree(genome, lo, frc);
            if (monitor == null) continue;
            if ((currProg += progDelta) > maxFrac) {
                currProg = maxFrac;
            }
            if (!(keepGoing = monitor.updateProgress((int)(currProg * 100.0)))) break;
        }
        throw new AsynchExitRequestException();
    }

    public void eliminateUselessCorners(LinkProperties bp, LinkPlacementGrid grid, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, double startFrac, double maxFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (bp.isDirect() || bp.getSegmentCount() == 1) {
            if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return;
        }
        PlacementGridRenderer pgRender = (PlacementGridRenderer)bp.getRenderer();
        SegmentWithKids rootSK = bp.buildSegmentTree(genome, lo, frc);
        if (rootSK == null || !this.isOrthogonal(rootSK)) {
            if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return;
        }
        String src = bp.getSourceTag();
        double currProg = startFrac;
        double progDelta = maxFrac - startFrac / 100.0;
        while (true) {
            boolean keepGoing;
            LinkSegmentID uselessID;
            if (bp.getSegmentCount() == 1) {
                if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return;
            }
            SegmentWithKids useless = this.getUselessCornerRecursive(rootSK, null);
            if (useless == null) {
                if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return;
            }
            LinkSegment uselessSeg = useless.segment;
            if (uselessSeg.isDegenerate()) {
                uselessID = LinkSegmentID.buildIDForStartDrop();
                uselessID.tagIDWithEndpoint("E");
            } else {
                uselessID = LinkSegmentID.buildIDForSegment(uselessSeg.getID());
                uselessID.tagIDWithEndpoint("E");
            }
            lo.deleteLinkageCornerForTree(bp, uselessID, null);
            grid.dropLink(src, genome, overID);
            pgRender.renderToPlacementGrid(genome, bp, lo, frc, grid, null, oso, overID);
            rootSK = bp.buildSegmentTree(genome, lo, frc);
            if (monitor == null) continue;
            if ((currProg += progDelta) > maxFrac) {
                currProg = maxFrac;
            }
            if (!(keepGoing = monitor.updateProgress((int)(currProg * 100.0)))) break;
        }
        throw new AsynchExitRequestException();
    }

    public void eliminateStaggeredRuns(LinkProperties bp, LinkPlacementGrid grid, int staggerBound, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, Set pinnedPoints, double startFrac, double endFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        PlacementGridRenderer pgRender = (PlacementGridRenderer)bp.getRenderer();
        SegmentWithKids rootSK = bp.buildSegmentTree(genome, lo, frc);
        if (rootSK == null || !this.isOrthogonal(rootSK)) {
            return;
        }
        String src = bp.getSourceTag();
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / 300.0;
        HashSet<String> foundTurns = new HashSet<String>();
        while (true) {
            boolean keepGoing;
            StaggeredRunResult result;
            if ((result = this.getStaggeredRunRecursive(rootSK, null, foundTurns, staggerBound, pinnedPoints)) == null) {
                if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return;
            }
            foundTurns.add(result.runStart.segment.getID());
            LinkSegmentID lsid = LinkSegmentID.buildIDForSegment(result.runStart.segment.getID());
            Set throughLinks = bp.resolveLinkagesThroughSegment(lsid, genome);
            String trg = null;
            HashSet<String> okGroups = null;
            if (throughLinks.size() == 1) {
                String trgLinkID = (String)throughLinks.iterator().next();
                trg = bp.getLinkTarget(genome, trgLinkID);
                if (overID == null && genome instanceof GenomeInstance) {
                    okGroups = new HashSet<String>();
                    GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(trgLinkID);
                    okGroups.add(tup.getSourceGroup());
                    okGroups.add(tup.getTargetGroup());
                }
            }
            if ((currProg += progInc) > endFrac) {
                currProg = endFrac;
            }
            if (monitor != null && !(keepGoing = monitor.updateProgress((int)(currProg * 100.0)))) {
                throw new AsynchExitRequestException();
            }
            if (!this.rerouteAllowed(result, grid, src, trg, okGroups)) continue;
            SegmentWithKids elimSwk = result.firstDirection == 1 ? result.firstJunction.right : result.firstJunction.left;
            bp.cleanupStaggeredRun(Math.abs((double)result.slideAmount * 10.0), rootSK, result.straightRun, elimSwk);
            grid.dropLink(src, genome, overID);
            pgRender.renderToPlacementGrid(genome, bp, lo, frc, grid, null, oso, overID);
            rootSK = bp.buildSegmentTree(genome, lo, frc);
        }
    }

    public void optimizeOrthoRuns(LinkProperties bp, LinkPlacementGrid grid, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, Set pinnedPoints, double startFrac, double endFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        PlacementGridRenderer pgRender = (PlacementGridRenderer)bp.getRenderer();
        SegmentWithKids rootSK = bp.buildSegmentTree(genome, lo, frc);
        if (rootSK == null || !this.isOrthogonal(rootSK)) {
            if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            return;
        }
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / 800.0;
        String src = bp.getSourceTag();
        int currCount = grid.getLinkCrossingsForSource(src);
        LinkPlacementGrid.InkValues currInkVal = grid.getLinkInk(src);
        DispResult currResult = new DispResult(currInkVal, currCount, new Vector2D(0.0, 0.0), Double.POSITIVE_INFINITY);
        Map origSegments = bp.copySegments();
        List origDrops = bp.copyDrops();
        HashSet<String> foundTurns = new HashSet<String>();
        DispResult newResult = new DispResult();
        do {
            DispResult fullMinResult;
            DispResult minResult;
            OrthoRunResult result;
            if ((result = this.getOrthogonalRunRecursive(rootSK, null, foundTurns, pinnedPoints)) == null) {
                if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return;
            }
            foundTurns.add(result.runStart.segment.getID());
            LinkSegmentID lsid = LinkSegmentID.buildIDForSegment(result.runStart.segment.getID());
            Set throughLinks = bp.resolveLinkagesThroughSegment(lsid, genome);
            String trg = null;
            HashSet<String> okGroups = null;
            if (throughLinks.size() == 1) {
                String trgLinkID = (String)throughLinks.iterator().next();
                trg = bp.getLinkTarget(genome, trgLinkID);
                if (overID == null && genome instanceof GenomeInstance) {
                    okGroups = new HashSet<String>();
                    GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(trgLinkID);
                    okGroups.add(tup.getSourceGroup());
                    okGroups.add(tup.getTargetGroup());
                }
            }
            List rightStraight = result.rightRun == null ? null : result.rightRun.straightRun;
            List leftStraight = result.leftRun == null ? null : result.leftRun.straightRun;
            if ((currProg += progInc) > endFrac) {
                currProg = endFrac;
            }
            if (monitor != null && !monitor.updateProgress((int)(currProg * 100.0))) {
                throw new AsynchExitRequestException();
            }
            int min = result.combinedBounds.min;
            int max = result.combinedBounds.max;
            ArrayList<Integer> toDo = new ArrayList<Integer>();
            int largest = max > -min ? max : -min;
            int currMin = -1;
            int currMax = 1;
            for (int i = 0; i <= largest; ++i) {
                if (currMin >= min) {
                    toDo.add(new Integer(currMin--));
                }
                if (currMax > max) continue;
                toDo.add(new Integer(currMax++));
            }
            int numDo = toDo.size();
            ArrayList<Vector2D> okDisp = new ArrayList<Vector2D>();
            ArrayList<Rectangle> usedBounds = new ArrayList<Rectangle>();
            for (int i = 0; i < numDo; ++i) {
                Rectangle checkedBounds;
                int disp = (Integer)toDo.get(i);
                Vector2D dispVec = this.displacementAllowed(result, grid, src, trg, okGroups, disp, checkedBounds = new Rectangle());
                if (dispVec == null) continue;
                okDisp.add(dispVec);
                usedBounds.add(checkedBounds);
            }
            Rectangle union = null;
            int numUB = usedBounds.size();
            if (numUB > 0) {
                for (int i = 0; i < numUB; ++i) {
                    Rectangle used = (Rectangle)usedBounds.get(i);
                    union = union == null ? used : union.union(used);
                }
                union = UiUtil.rectFromRect2D(UiUtil.padTheRect(union, 2.0));
            }
            LinkPlacementGrid subGrid = union == null ? grid : grid.subset(union);
            int currCountDelta = subGrid.getLinkCrossingsForSource(src);
            DispResult currResultDelta = null;
            if (union != null) {
                LinkPlacementGrid.InkValues currInkValDelta = subGrid.getLinkInk(src);
                currResultDelta = new DispResult(currInkValDelta, currCountDelta, new Vector2D(0.0, 0.0), Double.POSITIVE_INFINITY);
                minResult = new DispResult(currResultDelta);
            } else {
                minResult = new DispResult(currResult);
            }
            currProg += progInc;
            if (currProg > endFrac) {
                currProg = endFrac;
            }
            if (monitor != null && !monitor.updateProgress((int)(currProg * 100.0))) {
                throw new AsynchExitRequestException();
            }
            int okDispNum = okDisp.size();
            boolean dropped = false;
            for (int i = 0; i < okDispNum; ++i) {
                Vector2D dispVec = (Vector2D)okDisp.get(i);
                bp.shiftStraightSegmentRunFromLists(rightStraight, leftStraight, dispVec, rootSK);
                subGrid.dropLink(src, genome, overID);
                dropped = true;
                pgRender.renderToPlacementGrid(genome, bp, lo, frc, subGrid, null, oso, overID);
                int newCount = subGrid.getLinkCrossingsForSource(src);
                LinkPlacementGrid.InkValues newInkVal = subGrid.getLinkInk(src);
                double dispLen = dispVec.length();
                newResult.setValues(newInkVal, newCount, dispVec, dispLen);
                bp.restoreSegments(origSegments, rootSK);
                bp.restoreDrops(origDrops);
                currProg += progInc;
                if (currProg > endFrac) {
                    currProg = endFrac;
                }
                if (monitor != null && !monitor.updateProgress((int)(currProg * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                this.haveReplacement(newResult, minResult, minResult);
            }
            DispResult dispResult = fullMinResult = currResultDelta != null ? DispResult.merge(currResult, currResultDelta, minResult) : minResult;
            if (this.haveReplacement(fullMinResult, currResult, currResult)) {
                grid.dropLink(src, genome, overID);
                bp.shiftStraightSegmentRunFromLists(rightStraight, leftStraight, minResult.dispVec, rootSK);
                pgRender.renderToPlacementGrid(genome, bp, lo, frc, grid, null, oso, overID);
                origSegments = bp.copySegments();
                origDrops = bp.copyDrops();
                rootSK = bp.buildSegmentTree(genome, lo, frc);
            } else if (dropped) {
                grid.dropLink(src, genome, overID);
                pgRender.renderToPlacementGrid(genome, bp, lo, frc, grid, null, oso, overID);
            }
            currProg += progInc;
            if (!(currProg > endFrac)) continue;
            currProg = endFrac;
        } while (monitor == null || monitor.updateProgress((int)(currProg * 100.0)));
        throw new AsynchExitRequestException();
    }

    private boolean haveReplacement(DispResult newResult, DispResult oldResult, DispResult replaceResult) {
        boolean smallShift;
        boolean fewerCorners;
        boolean lessInk;
        boolean fewerCrossings;
        double smallDisp = 30.0;
        boolean bl = fewerCrossings = newResult.crossingCount < oldResult.crossingCount;
        if (fewerCrossings) {
            if (replaceResult != null) {
                replaceResult.copy(newResult);
            }
            return true;
        }
        boolean equalCrossings = newResult.crossingCount == oldResult.crossingCount;
        boolean bl2 = lessInk = newResult.inkVals.ink < oldResult.inkVals.ink;
        if (equalCrossings && lessInk) {
            if (replaceResult != null) {
                replaceResult.copy(newResult);
            }
            return true;
        }
        boolean sameInk = newResult.inkVals.ink == oldResult.inkVals.ink;
        int totalNewCorners = newResult.inkVals.simpleCorners + newResult.inkVals.complexCorners;
        int totalOldCorners = oldResult.inkVals.simpleCorners + oldResult.inkVals.complexCorners;
        boolean bl3 = fewerCorners = totalNewCorners < totalOldCorners;
        if (equalCrossings && sameInk && fewerCorners) {
            if (replaceResult != null) {
                replaceResult.copy(newResult);
            }
            return true;
        }
        boolean bl4 = smallShift = newResult.dispLen <= smallDisp;
        if (equalCrossings && smallShift && fewerCorners) {
            if (replaceResult != null) {
                replaceResult.copy(newResult);
            }
            return true;
        }
        return false;
    }

    public void findShorterPaths(LinkProperties bp, LinkPlacementGrid grid, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, double startFrac, double endFrac, BTProgressMonitor monitor) throws AsynchExitRequestException {
        PlacementGridRenderer pgRender = (PlacementGridRenderer)bp.getRenderer();
        String src = bp.getSourceTag();
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / 8.0;
        for (int i = 0; i < 8; ++i) {
            boolean keepGoing;
            if (!this.shortenAPath(bp, grid, genome, lo, frc, overID)) {
                if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                    throw new AsynchExitRequestException();
                }
                return;
            }
            grid.dropLink(src, genome, overID);
            pgRender.renderToPlacementGrid(genome, bp, lo, frc, grid, null, oso, overID);
            currProg += progInc;
            if (currProg > endFrac) {
                currProg = endFrac;
            }
            if (monitor == null || (keepGoing = monitor.updateProgress((int)(currProg * 100.0)))) continue;
            throw new AsynchExitRequestException();
        }
    }

    private boolean shortenAPath(LinkProperties bp, LinkPlacementGrid grid, Genome genome, Layout lo, FontRenderContext frc, String overID) {
        SegmentWithKids rootSK = bp.buildSegmentTree(genome, lo, frc);
        if (rootSK == null || !this.isOrthogonal(rootSK)) {
            return false;
        }
        Map skMap = this.buildSKMap(rootSK);
        Map progress = this.buildProgressMap(rootSK);
        String src = bp.getSourceTag();
        Iterator dit = bp.getDrops();
        while (dit.hasNext()) {
            BridgeResult bridge;
            List branch;
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() == 0 || (branch = this.findLowestSegmentWithSiblings(bd, skMap)) == null) continue;
            String highestSegID = (String)branch.get(branch.size() - 1);
            LinkSegment highestSeg = bp.getSegment(highestSegID);
            String hsParent = highestSeg.getParent();
            if (hsParent != null) {
                List kidList = (List)progress.get(hsParent);
                kidList.remove(highestSegID);
            }
            String trg = bp.getLinkTarget(genome, bd.getTargetRef());
            HashSet<String> okGroups = null;
            if (overID == null && genome instanceof GenomeInstance) {
                okGroups = new HashSet<String>();
                GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(bd.getTargetRef());
                okGroups.add(tup.getSourceGroup());
                okGroups.add(tup.getTargetGroup());
            }
            if ((bridge = this.findClosestBridge(bp, grid, highestSeg, branch, src, trg, okGroups)) == null || !this.createClosestBridge(bridge, bp)) continue;
            return true;
        }
        while (progress.size() > 0) {
            String nextSeg = null;
            Iterator pkit = progress.keySet().iterator();
            while (pkit.hasNext()) {
                String key = (String)pkit.next();
                List kidList = (List)progress.get(key);
                if (!kidList.isEmpty()) continue;
                nextSeg = key;
            }
            if (nextSeg == null) {
                throw new IllegalStateException();
            }
            progress.remove(nextSeg);
            List branch = this.findNextHighestWithSiblings(nextSeg, skMap);
            if (branch == null) continue;
            String highestSegID = (String)branch.get(branch.size() - 1);
            LinkSegment highestSeg = bp.getSegment(highestSegID);
            String hsParent = highestSeg.getParent();
            if (hsParent != null) {
                List kidList = (List)progress.get(hsParent);
                kidList.remove(highestSegID);
            }
            SegmentWithKids hsSwk = (SegmentWithKids)skMap.get(highestSegID);
            List kids = this.getRealKids(hsSwk);
            branch.remove(branch.size() - 1);
            branch.addAll(kids);
            BridgeResult bridge = this.findClosestBridge(bp, grid, highestSeg, branch, src, null, null);
            if (bridge == null || !this.createClosestBridge(bridge, bp)) continue;
            return true;
        }
        return false;
    }

    private BridgeResult findClosestBridge(LinkProperties bp, LinkPlacementGrid grid, LinkSegment checkSeg, List ignore, String src, String trg, Set okGroups) {
        double segLength = checkSeg.getLength();
        Point2D startPt = checkSeg.getEnd();
        Point2D stopPt = checkSeg.getStart();
        if (startPt == null) {
            return null;
        }
        BridgeResult retval = new BridgeResult();
        retval.segment = checkSeg;
        Vector2D checkBase = checkSeg.getRun().scaled(-10.0);
        int checkNum = 0;
        retval.segPoint = checkBase.scaled(checkNum).add(startPt);
        while (!retval.segPoint.equals(stopPt)) {
            retval.ca = bp.findClosestSegment(retval.segPoint, ignore);
            if (retval.ca != null && retval.ca.distance < segLength - (double)checkNum * 10.0) {
                if (retval.segPoint.getX() != retval.ca.point.getX() && retval.segPoint.getY() != retval.ca.point.getY()) {
                    retval.segPoint = checkBase.scaled(checkNum++).add(startPt);
                    continue;
                }
                if (retval.segPoint.equals(retval.ca.point)) {
                    retval.segPoint = checkBase.scaled(checkNum++).add(startPt);
                    continue;
                }
                if (grid.routeAllowed(src, trg, retval.segPoint, retval.ca.point, okGroups, false)) {
                    retval.splitMe = checkNum != 0;
                    LinkSegment him = bp.getSegment(retval.ca.segID);
                    retval.splitHim = !retval.ca.point.equals(him.getStart()) && !retval.ca.point.equals(him.getEnd());
                    return retval;
                }
            }
            retval.segPoint = checkBase.scaled(checkNum++).add(startPt);
        }
        return null;
    }

    private boolean createClosestBridge(BridgeResult bridge, LinkProperties bp) {
        LinkSegment myBridge = bridge.segment;
        LinkSegment hisBridge = bp.getSegment(bridge.ca.segID);
        if (myBridge.isDegenerate()) {
            return false;
        }
        if (bridge.splitMe) {
            LinkSegment[] newSegs = myBridge.split(bridge.segPoint);
            if (newSegs.length != 1) {
                bp.replaceSegment(myBridge, newSegs[0], newSegs[1]);
            }
            myBridge = newSegs[0];
        }
        boolean useEnd = true;
        if (bridge.splitHim) {
            LinkSegment[] newSegs = hisBridge.split(bridge.ca.point);
            if (newSegs.length != 1) {
                bp.replaceSegment(hisBridge, newSegs[0], newSegs[1]);
            }
            hisBridge = newSegs[0];
        } else {
            useEnd = hisBridge.isDegenerate() ? false : bridge.ca.point.equals(hisBridge.getEnd());
        }
        bp.moveSegmentOnTree(myBridge, hisBridge, useEnd);
        return true;
    }

    private List findLowestSegmentWithSiblings(LinkBusDrop bd, Map skMap) {
        ArrayList<String> retval = new ArrayList<String>();
        String conn = bd.getConnectionTag();
        SegmentWithKids swk = (SegmentWithKids)skMap.get(conn);
        int sibCount = swk.kids.size() - 1;
        if (sibCount < 0) {
            throw new IllegalStateException();
        }
        if (sibCount > 0) {
            return null;
        }
        SegmentWithKids highestSeg = null;
        while (highestSeg == null) {
            LinkSegment seg = swk.segment;
            String parent = seg.getParent();
            if (parent == null) {
                return null;
            }
            retval.add(swk.segment.getID());
            SegmentWithKids parentSwk = (SegmentWithKids)skMap.get(parent);
            sibCount = parentSwk.kids.size() - 1;
            if (sibCount < 0) {
                throw new IllegalStateException();
            }
            if (sibCount > 0) {
                highestSeg = swk;
                continue;
            }
            swk = parentSwk;
        }
        return retval;
    }

    private List findNextHighestWithSiblings(String segID, Map skMap) {
        ArrayList<String> retval = new ArrayList<String>();
        SegmentWithKids swk = (SegmentWithKids)skMap.get(segID);
        SegmentWithKids highestSeg = null;
        while (highestSeg == null) {
            LinkSegment seg = swk.segment;
            String parent = seg.getParent();
            if (parent == null) {
                return null;
            }
            retval.add(swk.segment.getID());
            SegmentWithKids parentSwk = (SegmentWithKids)skMap.get(parent);
            int sibCount = parentSwk.kids.size() - 1;
            if (sibCount < 0) {
                throw new IllegalStateException();
            }
            if (sibCount > 0) {
                highestSeg = swk;
                continue;
            }
            swk = parentSwk;
        }
        return retval;
    }

    public boolean rerouteAllowed(StaggeredRunResult result, LinkPlacementGrid grid, String src, String trg, Set okGroups) {
        LinkSegment startSeg = result.firstDirection == 0 ? result.firstJunction.left.segment : result.firstJunction.right.segment;
        Point2D rerouteStart = startSeg.getStart();
        double offsetLen = startSeg.getLength();
        Vector2D offsetRun = startSeg.getRun();
        Vector2D scaled = offsetRun.scaled(-offsetLen);
        Point2D oldEnd = result.thirdJunction.right == null ? result.thirdJunction.left.segment.getStart() : result.thirdJunction.right.segment.getStart();
        Point2D newEnd = scaled.add(oldEnd);
        ArrayList<Point2D> branchAwayPts = new ArrayList<Point2D>();
        int numBA = result.branchAways.size();
        for (int i = 0; i < numBA; ++i) {
            SegmentWithKids currSwk = (SegmentWithKids)result.branchAways.get(i);
            branchAwayPts.add(currSwk.segment.getStart());
        }
        ArrayList<Point2D> branchBackPts = new ArrayList<Point2D>();
        int numBB = result.branchBacks.size();
        for (int i = 0; i < numBB; ++i) {
            SegmentWithKids currSwk = (SegmentWithKids)result.branchBacks.get(i);
            branchBackPts.add(currSwk.segment.getStart());
        }
        return grid.rerouteAllowed(src, rerouteStart, oldEnd, newEnd, trg, okGroups, branchAwayPts, branchBackPts, false);
    }

    private Vector2D displacementAllowed(OrthoRunResult ortho, LinkPlacementGrid grid, String src, String trg, Set okGroups, int displacement, Rectangle boundsUsed) {
        LinkSegment parSeg;
        Point2D parPt;
        Point2D end;
        Point2D start;
        if (ortho.leftRun == null && ortho.rightRun == null) {
            throw new IllegalArgumentException();
        }
        if (ortho.leftRun == null) {
            start = ortho.rightRun.terminalPoint;
            end = ortho.rightRun.orthoStart.segment.getStart();
        } else if (ortho.rightRun == null) {
            start = ortho.leftRun.orthoStart.segment.getStart();
            end = ortho.leftRun.terminalPoint;
        } else {
            start = ortho.rightRun.terminalPoint;
            end = ortho.leftRun.terminalPoint;
        }
        Vector2D fullRun = new Vector2D(start, end).normalized();
        Vector2D forward = LinkPlacementGrid.getTurn(fullRun, 1);
        forward.scale((double)displacement * 10.0);
        start = forward.add(start);
        end = forward.add(end);
        ArrayList<Point2D> shorterStarts = new ArrayList<Point2D>();
        ArrayList<Point2D> longerStarts = new ArrayList<Point2D>();
        if (ortho.rightRun != null) {
            this.branchTransfer(ortho.rightRun, shorterStarts, longerStarts, displacement);
        }
        Point2D point2D = parPt = (parSeg = ortho.runStart.segment).isDegenerate() ? parSeg.getStart() : parSeg.getEnd();
        if (displacement > 0) {
            if (ortho.firstJunction.forward != null) {
                shorterStarts.add(ortho.firstJunction.forward.segment.getStart());
            }
            longerStarts.add(parPt);
        } else {
            shorterStarts.add(parPt);
            if (ortho.firstJunction.forward != null) {
                longerStarts.add(ortho.firstJunction.forward.segment.getStart());
            }
        }
        if (ortho.leftRun != null) {
            this.branchTransfer(ortho.leftRun, shorterStarts, longerStarts, displacement);
        }
        ArrayList<Point2D> longerLoneStarts = new ArrayList<Point2D>();
        int numLs = longerStarts.size();
        for (int i = 0; i < numLs; ++i) {
            Point2D longer = (Point2D)longerStarts.get(i);
            if (shorterStarts.contains(longer)) continue;
            longerLoneStarts.add(longer);
        }
        ArrayList<Point2D> dispShorterStarts = new ArrayList<Point2D>();
        int numSs = shorterStarts.size();
        for (int i = 0; i < numSs; ++i) {
            Point2D shorter = (Point2D)shorterStarts.get(i);
            dispShorterStarts.add(forward.add(shorter));
        }
        boundsUsed.setBounds(grid.displacementRange(start, end, forward, dispShorterStarts, longerLoneStarts));
        if (grid.displacementAllowed(src, start, end, forward, trg, okGroups, dispShorterStarts, longerLoneStarts, false)) {
            return forward;
        }
        return null;
    }

    private void branchTransfer(OrthoSubrun ortho, List shorterStarts, List longerStarts, int displacement) {
        SegmentWithKids currSwk;
        int i;
        List targList = displacement > 0 ? shorterStarts : longerStarts;
        List srcList = ortho.branchAways;
        int num = srcList.size();
        for (i = 0; i < num; ++i) {
            currSwk = (SegmentWithKids)srcList.get(i);
            targList.add(currSwk.segment.getStart());
        }
        targList = displacement > 0 ? longerStarts : shorterStarts;
        srcList = ortho.branchBacks;
        num = srcList.size();
        for (i = 0; i < num; ++i) {
            currSwk = (SegmentWithKids)srcList.get(i);
            targList.add(currSwk.segment.getStart());
        }
    }

    private int[] calculateSlides(SortedSet slides1, SortedSet slides2, int firstDirection, int jaggedOffset) {
        int[] retval = new int[2];
        int sign = firstDirection == 0 ? 1 : -1;
        int signedOffset = sign * jaggedOffset;
        Integer signedOffsetObj = new Integer(signedOffset);
        if (slides1.contains(signedOffsetObj)) {
            retval[0] = signedOffset;
            retval[1] = 0;
            return retval;
        }
        if (slides2.contains(signedOffsetObj)) {
            retval[0] = 0;
            retval[1] = signedOffset;
            return retval;
        }
        Iterator s1it = slides1.iterator();
        while (s1it.hasNext()) {
            Integer s1 = (Integer)s1it.next();
            int s1val = s1;
            Iterator s2it = slides2.iterator();
            while (s2it.hasNext()) {
                Integer s2 = (Integer)s2it.next();
                int s2val = s2;
                if (s1val + s2val != signedOffset) continue;
                retval[0] = s1val;
                retval[1] = s2val;
                return retval;
            }
        }
        return null;
    }

    private SegmentWithKids getUselessCornerRecursive(SegmentWithKids skids, SegmentWithKids parent) {
        if (this.startsUselessCorner(skids, parent)) {
            return skids;
        }
        int kidCount = skids.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)skids.kids.get(i);
            SegmentWithKids recurse = this.getUselessCornerRecursive(kidSk, skids);
            if (recurse == null) continue;
            return recurse;
        }
        return null;
    }

    private boolean isOrthogonal(SegmentWithKids skids) {
        Vector2D run = skids.segment.getRun();
        if (!skids.segment.isDegenerate() && !this.isOrtho(run)) {
            return false;
        }
        int kidCount = skids.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)skids.kids.get(i);
            if (this.isOrthogonal(kidSk)) continue;
            return false;
        }
        return true;
    }

    private StaggeredRunResult getStaggeredRunRecursive(SegmentWithKids skids, SegmentWithKids parent, Set foundTurns, int bound, Set pinnedPoints) {
        StaggeredRunResult result;
        String segID = skids.segment.getID();
        if (segID != null && !foundTurns.contains(segID) && (result = this.startsStaggeredRun(skids, parent, bound, pinnedPoints)) != null) {
            return result;
        }
        int kidCount = skids.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)skids.kids.get(i);
            StaggeredRunResult recurse = this.getStaggeredRunRecursive(kidSk, skids, foundTurns, bound, pinnedPoints);
            if (recurse == null) continue;
            return recurse;
        }
        return null;
    }

    private OrthoRunResult getOrthogonalRunRecursive(SegmentWithKids skids, SegmentWithKids parent, Set foundTurns, Set pinnedPoints) {
        OrthoRunResult result;
        String segID = skids.segment.getID();
        if (segID != null && !foundTurns.contains(segID) && (result = this.startsOrthogonalRun(skids, parent, pinnedPoints)) != null) {
            return result;
        }
        int kidCount = skids.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)skids.kids.get(i);
            OrthoRunResult recurse = this.getOrthogonalRunRecursive(kidSk, skids, foundTurns, pinnedPoints);
            if (recurse == null) continue;
            return recurse;
        }
        return null;
    }

    private Map buildSKMap(SegmentWithKids swk) {
        HashMap retval = new HashMap();
        this.buildSKMapRecursive(swk, retval);
        return retval;
    }

    private void buildSKMapRecursive(SegmentWithKids swk, Map skMap) {
        String id = swk.segment.getID();
        if (id != null) {
            skMap.put(id, swk);
        }
        int kidCount = swk.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)swk.kids.get(i);
            this.buildSKMapRecursive(kidSk, skMap);
        }
    }

    private List getRealKids(SegmentWithKids swk) {
        ArrayList retval = new ArrayList();
        this.getRealKidsRecursive(swk, retval);
        return retval;
    }

    private void getRealKidsRecursive(SegmentWithKids swk, List realKids) {
        String id = swk.segment.getID();
        if (id != null) {
            realKids.add(id);
        }
        int kidCount = swk.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)swk.kids.get(i);
            this.getRealKidsRecursive(kidSk, realKids);
        }
    }

    private Map buildProgressMap(SegmentWithKids swk) {
        HashMap retval = new HashMap();
        this.buildProgressMapRecursive(swk, retval);
        return retval;
    }

    private void buildProgressMapRecursive(SegmentWithKids swk, Map progMap) {
        String id = swk.segment.getID();
        int kidCount = swk.kids.size();
        ArrayList<String> kids = null;
        if (kidCount > 1 && id != null) {
            kids = new ArrayList<String>();
            progMap.put(id, kids);
        }
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSk = (SegmentWithKids)swk.kids.get(i);
            String kidID = kidSk.segment.getID();
            if (kids != null && kidID != null) {
                kids.add(kidID);
            }
            this.buildProgressMapRecursive(kidSk, progMap);
        }
    }

    private boolean startsUselessCorner(SegmentWithKids skids, SegmentWithKids parent) {
        if (skids.kids.size() != 1) {
            return false;
        }
        SegmentDirections dir = this.getDirections(skids, parent);
        return dir != null && dir.forward != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StaggeredRunResult startsStaggeredRun(SegmentWithKids skids, SegmentWithKids parent, int bound, Set pinnedPoints) {
        SegmentWithKids secondSegment;
        boolean nextTurnDir;
        SegmentWithKids firstSegment;
        StaggeredRunResult retval = new StaggeredRunResult();
        retval.runStart = skids;
        retval.firstJunction = this.getDirections(skids, parent);
        if (retval.firstJunction == null) {
            return null;
        }
        if (retval.firstJunction.forward != null) return null;
        if (retval.firstJunction.left != null) {
            firstSegment = retval.firstJunction.left;
            nextTurnDir = true;
            retval.firstDirection = 0;
        } else {
            if (retval.firstJunction.right == null) return null;
            firstSegment = retval.firstJunction.right;
            nextTurnDir = false;
            retval.firstDirection = 1;
        }
        LinkSegment turnSeg = firstSegment.segment;
        double turnLength = turnSeg.getLength();
        int staggeredOffset = (int)(turnLength / 10.0);
        if (staggeredOffset > bound) {
            return null;
        }
        retval.secondJunction = this.getDirections(firstSegment, null);
        if (retval.secondJunction == null) {
            return null;
        }
        if (!nextTurnDir) {
            if (retval.secondJunction.left == null || retval.secondJunction.right != null) {
                return null;
            }
            secondSegment = retval.secondJunction.left;
        } else {
            if (!nextTurnDir) throw new IllegalStateException();
            if (retval.secondJunction.left != null || retval.secondJunction.right == null) {
                return null;
            }
            secondSegment = retval.secondJunction.right;
        }
        MinMax moves = this.freeLateralMovement(secondSegment, pinnedPoints);
        if (moves == null) {
            return null;
        }
        if (retval.firstDirection == 1) {
            if (moves.min != Integer.MAX_VALUE && moves.min > -staggeredOffset) return null;
            retval.slideAmount = -staggeredOffset;
        } else {
            if (retval.firstDirection != 0) throw new IllegalStateException();
            if (moves.max != Integer.MIN_VALUE && moves.max <= staggeredOffset) return null;
            retval.slideAmount = staggeredOffset;
        }
        retval.straightRun = this.getStraightRun(secondSegment);
        if (retval.straightRun == null) {
            return null;
        }
        int numStr = retval.straightRun.size();
        int last = numStr - 1;
        retval.branchAways = new ArrayList();
        retval.branchBacks = new ArrayList();
        for (int i = 0; i < numStr; ++i) {
            SegmentWithKids currSwk = (SegmentWithKids)retval.straightRun.get(i);
            SegmentDirections directions = this.getDirections(currSwk, null);
            if (directions == null) {
                return null;
            }
            if (retval.firstDirection == 1) {
                if (directions.right != null) {
                    retval.branchAways.add(directions.right);
                }
                if (directions.left != null) {
                    retval.branchBacks.add(directions.left);
                }
            } else if (retval.firstDirection == 0) {
                if (directions.right != null) {
                    retval.branchBacks.add(directions.right);
                }
                if (directions.left != null) {
                    retval.branchAways.add(directions.left);
                }
            }
            if (i != last) continue;
            retval.thirdJunction = directions;
        }
        return retval;
    }

    private OrthoRunResult startsOrthogonalRun(SegmentWithKids skids, SegmentWithKids parent, Set pinnedPoints) {
        int backBound;
        int pad;
        OrthoRunResult retval = new OrthoRunResult();
        retval.runStart = skids;
        retval.firstJunction = this.getDirections(skids, parent);
        if (retval.firstJunction == null) {
            return null;
        }
        if (retval.firstJunction.left == null && retval.firstJunction.right == null) {
            return null;
        }
        if (retval.firstJunction.left != null) {
            retval.leftRun = new OrthoSubrun();
            retval.leftRun.orthoStart = retval.firstJunction.left;
            retval.leftRun.subrunDirection = 0;
            retval.leftRun.straightRun = this.getStraightRun(retval.leftRun.orthoStart);
            if (retval.leftRun.straightRun == null) {
                return null;
            }
            this.analyzeOrthoSubrun(retval.leftRun, pinnedPoints);
        }
        if (retval.firstJunction.right != null) {
            retval.rightRun = new OrthoSubrun();
            retval.rightRun.orthoStart = retval.firstJunction.right;
            retval.rightRun.subrunDirection = 1;
            retval.rightRun.straightRun = this.getStraightRun(retval.rightRun.orthoStart);
            if (retval.rightRun.straightRun == null) {
                return null;
            }
            this.analyzeOrthoSubrun(retval.rightRun, pinnedPoints);
        }
        if (retval.leftRun != null && retval.leftRun.bounds == null || retval.rightRun != null && retval.rightRun.bounds == null) {
            return null;
        }
        int maximumUnboundTravel = 20;
        SegmentWithKids forwardRun = retval.firstJunction.forward;
        int forwardBound = Integer.MAX_VALUE;
        if (forwardRun != null) {
            LinkSegment forSeg = forwardRun.segment;
            pad = forSeg.getID() == null ? 1 : 0;
            forwardBound = (int)(forSeg.getLength() / 10.0) - pad;
        }
        if (forwardBound < 0) {
            forwardBound = 0;
        }
        LinkSegment parSeg = skids.segment;
        pad = 0;
        if (parSeg.isDegenerate()) {
            parSeg = parent.segment;
            pad = 1;
        }
        if ((backBound = -((int)(parSeg.getLength() / 10.0) - pad)) > 0) {
            backBound = 0;
        }
        retval.combinedBounds = this.combineOrthoBounds(retval.leftRun == null ? null : retval.leftRun.bounds, retval.rightRun == null ? null : retval.rightRun.bounds, maximumUnboundTravel, forwardBound, backBound);
        if (retval.combinedBounds == null) {
            return null;
        }
        return retval;
    }

    private boolean analyzeOrthoSubrun(OrthoSubrun subrun, Set pinnedPoints) {
        int numStr = subrun.straightRun.size();
        int last = numStr - 1;
        subrun.branchAways = new ArrayList();
        subrun.branchBacks = new ArrayList();
        for (int i = 0; i < numStr; ++i) {
            SegmentWithKids currSwk = (SegmentWithKids)subrun.straightRun.get(i);
            SegmentDirections directions = this.getDirections(currSwk, null);
            if (directions == null) {
                return false;
            }
            if (subrun.subrunDirection == 1) {
                if (directions.right != null) {
                    subrun.branchBacks.add(directions.right);
                }
                if (directions.left != null) {
                    subrun.branchAways.add(directions.left);
                }
            } else if (subrun.subrunDirection == 0) {
                if (directions.right != null) {
                    subrun.branchAways.add(directions.right);
                }
                if (directions.left != null) {
                    subrun.branchBacks.add(directions.left);
                }
            }
            if (i != last) continue;
            subrun.terminalJunction = directions;
            subrun.terminalPoint = (Point2D)currSwk.segment.getEnd().clone();
        }
        subrun.bounds = this.freeLateralMovement(subrun.orthoStart, pinnedPoints);
        return true;
    }

    private MinMax combineOrthoBounds(MinMax left, MinMax right, int unboundedLimit, int forwardBound, int backwardBound) {
        MinMax retval;
        if (left == null && right == null) {
            return null;
        }
        if (left != null) {
            if (left.max == Integer.MAX_VALUE && forwardBound == Integer.MAX_VALUE) {
                left.max = unboundedLimit;
            }
            if (left.min == Integer.MIN_VALUE && backwardBound == Integer.MIN_VALUE) {
                left.min = -unboundedLimit;
            }
        }
        if (right != null) {
            if (right.max == Integer.MAX_VALUE && backwardBound == Integer.MIN_VALUE) {
                right.max = unboundedLimit;
            }
            if (right.min == Integer.MIN_VALUE && forwardBound == Integer.MAX_VALUE) {
                right.min = -unboundedLimit;
            }
        }
        if (right == null) {
            MinMax retval2 = new MinMax(left);
            if (retval2.min < backwardBound) {
                retval2.min = backwardBound;
            }
            if (retval2.max > forwardBound) {
                retval2.max = forwardBound;
            }
            return retval2;
        }
        MinMax minMax = retval = right.min == Integer.MIN_VALUE ? new MinMax(-right.max, Integer.MAX_VALUE) : new MinMax(-right.max, -right.min);
        if (retval.min < backwardBound) {
            retval.min = backwardBound;
        }
        if (retval.max > forwardBound) {
            retval.max = forwardBound;
        }
        if (left == null) {
            return retval;
        }
        if (left.max < retval.max) {
            retval.max = left.max;
        }
        if (left.min > retval.min) {
            retval.min = left.min;
        }
        return retval;
    }

    private MinMax freeLateralMovementWorldCoord(SegmentWithKids skids, Set pinnedPoints) {
        if (skids.kids.size() == 0) {
            return null;
        }
        LinkSegment mySeg = skids.segment;
        if (pinnedPoints != null) {
            if (pinnedPoints.contains(mySeg.getStart())) {
                return null;
            }
            if (!mySeg.isDegenerate() && pinnedPoints.contains(mySeg.getEnd())) {
                return null;
            }
        }
        Vector2D myRun = mySeg.getRun();
        MinMax retval = new MinMax(Integer.MIN_VALUE, Integer.MAX_VALUE);
        int kidCount = skids.kids.size();
        for (int i = 0; i < kidCount; ++i) {
            SegmentWithKids kidSwk = (SegmentWithKids)skids.kids.get(i);
            LinkSegment lseg = kidSwk.segment;
            Vector2D kidRun = lseg.getRun();
            if (kidRun == null || kidRun.isZero() || !this.isOrtho(kidRun)) {
                return null;
            }
            int kidLen = (int)lseg.getLength();
            if (kidSwk.segment.getID() == null && kidLen >= 10) {
                kidLen -= 10;
            }
            if (kidRun.equals(myRun)) {
                MinMax kidmm = this.freeLateralMovementWorldCoord(kidSwk, pinnedPoints);
                if (kidmm == null) {
                    return null;
                }
                if (kidmm.max < retval.max) {
                    retval.max = kidmm.max;
                }
                if (kidmm.min <= retval.min) continue;
                retval.min = kidmm.min;
                continue;
            }
            if (kidRun.equals(LinkPlacementGrid.getTurn(myRun, 0))) {
                if (retval.min >= -kidLen) continue;
                retval.min = -kidLen;
                continue;
            }
            if (kidRun.equals(LinkPlacementGrid.getTurn(myRun, 1))) {
                if (retval.max <= kidLen) continue;
                retval.max = kidLen;
                continue;
            }
            return null;
        }
        return retval;
    }

    private MinMax freeLateralMovement(SegmentWithKids skids, Set pinnedPoints) {
        MinMax retval = this.freeLateralMovementWorldCoord(skids, pinnedPoints);
        if (retval == null) {
            return null;
        }
        if (retval.min != Integer.MIN_VALUE) {
            retval.min /= 10;
        }
        if (retval.max != Integer.MAX_VALUE) {
            retval.max /= 10;
        }
        return retval;
    }

    private SegmentDirections getDirections(SegmentWithKids skids, SegmentWithKids parent) {
        SegmentDirections retval = new SegmentDirections();
        int kidCount = skids.kids.size();
        if (kidCount > 3) {
            return null;
        }
        for (int i = 0; i < kidCount; ++i) {
            Vector2D right;
            SegmentWithKids kidSwk = (SegmentWithKids)skids.kids.get(i);
            LinkSegment lseg = kidSwk.segment;
            Vector2D kidRun = lseg.getRun();
            if (kidRun == null || kidRun.isZero() || !this.isOrtho(kidRun)) {
                return null;
            }
            Vector2D myRun = skids.segment.getRun();
            if ((myRun == null || myRun.isZero() || !this.isOrtho(myRun)) && parent != null) {
                myRun = parent.segment.getRun();
            }
            if (myRun == null || myRun.isZero() || !this.isOrtho(myRun)) {
                return null;
            }
            Vector2D left = LinkPlacementGrid.getTurn(myRun, 0);
            if (left.equals(kidRun)) {
                if (retval.left == null) {
                    retval.left = kidSwk;
                } else {
                    return null;
                }
            }
            if ((right = LinkPlacementGrid.getTurn(myRun, 1)).equals(kidRun)) {
                if (retval.right == null) {
                    retval.right = kidSwk;
                } else {
                    return null;
                }
            }
            if (!myRun.equals(kidRun)) continue;
            if (retval.forward == null) {
                retval.forward = kidSwk;
                continue;
            }
            return null;
        }
        return retval;
    }

    private List getStraightRun(SegmentWithKids skids) {
        ArrayList<SegmentWithKids> retval = new ArrayList<SegmentWithKids>();
        SegmentWithKids currSwk = skids;
        while (true) {
            retval.add(currSwk);
            SegmentDirections directions = this.getDirections(currSwk, null);
            if (directions == null) {
                return null;
            }
            if (directions.forward == null) {
                return retval;
            }
            currSwk = directions.forward;
        }
    }

    private Integer endCornerIsSimple(SegmentWithKids skids) {
        if (skids.kids.size() != 1) {
            return null;
        }
        Vector2D kidRun = ((SegmentWithKids)skids.kids.get((int)0)).segment.getRun();
        if (kidRun == null || kidRun.isZero() || !this.isOrtho(kidRun)) {
            return null;
        }
        Vector2D myRun = skids.segment.getRun();
        if (myRun == null || myRun.isZero() || !this.isOrtho(myRun)) {
            return null;
        }
        Vector2D left = LinkPlacementGrid.getTurn(myRun, 0);
        if (left.equals(kidRun)) {
            return new Integer(0);
        }
        Vector2D right = LinkPlacementGrid.getTurn(myRun, 1);
        if (right.equals(kidRun)) {
            return new Integer(1);
        }
        return null;
    }

    private boolean isOrtho(Vector2D vector) {
        int vecX = (int)vector.getX();
        int vecY = (int)vector.getY();
        return vecX == -1 && vecY == 0 || vecX == 0 && vecY == 1 || vecX == 1 && vecY == 0 || vecX == 0 && vecY == -1;
    }

    private static class DispResult {
        LinkPlacementGrid.InkValues inkVals;
        int crossingCount;
        Vector2D dispVec;
        double dispLen;

        DispResult() {
            this.inkVals = new LinkPlacementGrid.InkValues();
        }

        DispResult(DispResult other) {
            this();
            this.copy(other);
        }

        DispResult(LinkPlacementGrid.InkValues inkVals, int crossingCount, Vector2D dispVec, double dispLen) {
            this.setValues(inkVals, crossingCount, dispVec, dispLen);
        }

        static DispResult merge(DispResult origFull, DispResult origSub, DispResult modSub) {
            DispResult retval = new DispResult(modSub);
            retval.inkVals = LinkPlacementGrid.InkValues.merge(origFull.inkVals, origSub.inkVals, modSub.inkVals);
            retval.crossingCount = origFull.crossingCount - origSub.crossingCount + modSub.crossingCount;
            return retval;
        }

        void setValues(LinkPlacementGrid.InkValues inkVals, int crossingCount, Vector2D dispVec, double dispLen) {
            this.inkVals = new LinkPlacementGrid.InkValues(inkVals);
            this.crossingCount = crossingCount;
            this.dispVec = new Vector2D(dispVec);
            this.dispLen = dispLen;
        }

        void copy(DispResult other) {
            this.inkVals.copy(other.inkVals);
            this.crossingCount = other.crossingCount;
            this.dispVec = new Vector2D(other.dispVec);
            this.dispLen = other.dispLen;
        }
    }

    private static class OrthoSubrun {
        SegmentWithKids orthoStart;
        int subrunDirection;
        SegmentDirections terminalJunction;
        Point2D terminalPoint;
        List straightRun;
        List branchAways;
        List branchBacks;
        MinMax bounds;

        private OrthoSubrun() {
        }

        public String toString() {
            return "orthoStart = " + this.orthoStart + " subrunDirection = " + this.subrunDirection + " terminalJunction = " + this.terminalJunction + " terminalPoint = " + this.terminalPoint + " straightRun = " + this.straightRun + " branchAways = " + this.branchAways + " branchBacks = " + this.branchBacks + " bounds = " + this.bounds;
        }
    }

    private static class OrthoRunResult {
        SegmentWithKids runStart;
        SegmentDirections firstJunction;
        OrthoSubrun leftRun;
        OrthoSubrun rightRun;
        MinMax combinedBounds;

        private OrthoRunResult() {
        }

        public String toString() {
            return "runStart = " + this.runStart + " firstJunction = " + this.firstJunction + " leftRun = " + this.leftRun + " rightRun = " + this.rightRun + " combinedBounds = " + this.combinedBounds;
        }
    }

    public static class StaggeredRunResult {
        SegmentWithKids runStart;
        SegmentDirections firstJunction;
        SegmentDirections secondJunction;
        SegmentDirections thirdJunction;
        List straightRun;
        List branchAways;
        List branchBacks;
        int slideAmount;
        int firstDirection;
    }

    private static class SegmentDirections {
        SegmentWithKids left;
        SegmentWithKids forward;
        SegmentWithKids right;

        private SegmentDirections() {
        }

        public String toString() {
            return "left = " + this.left + " right = " + this.right + " forward = " + this.forward;
        }
    }

    private static class BridgeResult {
        LinkProperties.ClosestAnswer ca;
        Point2D segPoint;
        LinkSegment segment;
        boolean splitMe;
        boolean splitHim;

        private BridgeResult() {
        }

        public String toString() {
            return "closest = " + this.ca + " point = " + this.segPoint + " segment " + this.segment + " splitMe = " + this.splitMe + " splitHim = " + this.splitHim;
        }
    }
}

