/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.CornerOracle;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SegmentWithKids;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.ui.freerender.DrawTree;
import org.systemsbiology.biotapestry.ui.freerender.DrawTreeModelDataSource;
import org.systemsbiology.biotapestry.ui.layouts.ortho.FixOrthoOptions;
import org.systemsbiology.biotapestry.ui.layouts.ortho.TreeStrategy;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public abstract class LinkProperties
implements Cloneable,
CornerOracle {
    public static final int SAME = 0;
    public static final int ANCESTOR = 1;
    public static final int DECENDANT = 2;
    public static final int SIBLING = 3;
    public static final int OTHER = 4;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    public static final String LEFT_STR_ = "left";
    public static final String RIGHT_STR_ = "right";
    public static final String UP_STR_ = "up";
    public static final String DOWN_STR_ = "down";
    public static final int NONE = -1;
    public static final int SOLID = 0;
    public static final int THIN = 1;
    public static final int DASH = 2;
    public static final int THINDASH = 3;
    public static final String NONE_KEY = "NONE";
    public static final String SOLID_KEY = "SOLID";
    public static final String THIN_KEY = "THIN";
    public static final String DASH_KEY = "DASH";
    public static final String THINDASH_KEY = "THINDASH";
    public static final int NOTHING_TO_REPAIR = 0;
    public static final int ALL_REPAIRED = 1;
    public static final int SOME_REPAIRED = 2;
    public static final int COULD_NOT_REPAIR = 3;
    private static int REPAIR_CAP_ = 10000;
    private static int PENULTIMATE_REPAIR_ = REPAIR_CAP_ - 1;
    private static final double INTERSECT_TOL = 5.0;
    protected Point2D textPos_;
    protected int textDir_;
    protected String textDirTag_;
    protected Object myRenderer_;
    protected SuggestedDrawStyle drawStyle_;
    protected String srcTag_;
    protected Map segments_;
    protected List drops_;
    protected UniqueLabeller labels_;

    protected LinkProperties(Object renderer) {
        this.segments_ = new HashMap();
        this.drops_ = new ArrayList();
        this.labels_ = new UniqueLabeller();
        this.drawStyle_ = SuggestedDrawStyle.buildFromLegacy(0);
        this.drawStyle_.setColorName("black");
        this.myRenderer_ = renderer;
    }

    protected LinkProperties(LinkProperties other) {
        this.copySupport(other);
    }

    protected LinkProperties(float tx, float ty, String color, String src, Object renderer) {
        this.textPos_ = new Point2D.Float(tx, ty);
        this.textDir_ = 1;
        this.textDirTag_ = null;
        this.segments_ = new HashMap();
        this.drops_ = new ArrayList();
        this.labels_ = new UniqueLabeller();
        this.myRenderer_ = renderer;
        this.drawStyle_ = SuggestedDrawStyle.buildFromLegacy(0);
        this.drawStyle_.setColorName(color);
        this.srcTag_ = src;
    }

    public LinkProperties breakTreePortionToNewSource(LinkSegmentID segID, Set resolved, String newSourceID, Object extraInfo) {
        LinkProperties newProps = null;
        if (segID.isDirect()) {
            newProps = (LinkProperties)this.clone();
            newProps.srcTag_ = newSourceID;
        } else if (segID.isForDrop()) {
            LinkBusDrop drop = this.getDrop(segID);
            int dropType = drop.getDropType();
            if (dropType == 0) {
                newProps = (LinkProperties)this.clone();
                newProps.srcTag_ = newSourceID;
            } else {
                newProps = this.deriveDirectLink(newSourceID, drop, extraInfo);
            }
        } else {
            LinkSegment seg = this.getSegment(segID.getLinkSegTag());
            HashMap<String, String> identity = new HashMap<String, String>();
            Iterator rit = resolved.iterator();
            while (rit.hasNext()) {
                String res = (String)rit.next();
                identity.put(res, res);
            }
            newProps = this.newTreeBelowSegment(seg, newSourceID, null, identity, extraInfo);
        }
        return newProps;
    }

    public void shiftSegment(String shiftID, Vector2D shift, String parent, List siblings, List children) {
        LinkSegment seg;
        String segID;
        int i;
        double dx = shift.getX();
        double dy = shift.getY();
        LinkSegment shiftSeg = this.getSegment(shiftID);
        shiftSeg.shiftBoth(dx, dy);
        if (parent != null) {
            LinkSegment parentSeg = this.getSegment(parent);
            if (parentSeg.isDegenerate()) {
                parentSeg.shiftStart(dx, dy);
            } else {
                parentSeg.shiftEnd(dx, dy);
            }
        }
        int size = siblings.size();
        for (i = 0; i < size; ++i) {
            segID = (String)siblings.get(i);
            seg = this.getSegment(segID);
            seg.shiftStart(dx, dy);
        }
        size = children.size();
        for (i = 0; i < size; ++i) {
            segID = (String)children.get(i);
            seg = this.getSegment(segID);
            seg.shiftStart(dx, dy);
        }
    }

    public void shiftStraightSegmentRunFromList(List straight, Vector2D shift, SegmentWithKids rootSK) {
        this.shiftStraightSegmentRunFromListCore(straight, shift, rootSK);
        this.dropAllZeroSegments();
    }

    public void shiftStraightSegmentRunFromLists(List straight, List straight2, Vector2D shift, SegmentWithKids rootSK) {
        if (straight != null && straight2 == null) {
            this.shiftStraightSegmentRunFromList(straight, shift, rootSK);
            return;
        }
        if (straight == null && straight2 != null) {
            this.shiftStraightSegmentRunFromList(straight2, shift, rootSK);
            return;
        }
        if (straight == null && straight2 == null) {
            throw new IllegalArgumentException();
        }
        this.shiftStraightSegmentRunFromListCore(straight, shift, rootSK);
        if (straight2.size() > 1) {
            ArrayList reduced = new ArrayList(straight2);
            reduced.remove(0);
            this.shiftStraightSegmentRunFromListCore(reduced, shift, rootSK);
            this.dropAllZeroSegments();
            return;
        }
        double dx = shift.getX();
        double dy = shift.getY();
        SegmentWithKids swk = (SegmentWithKids)straight2.get(0);
        swk.segment.shiftEnd(dx, dy);
        List children = swk.getChildrenIDs();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String segID = (String)children.get(i);
            LinkSegment seg = this.getSegment(segID);
            seg.shiftStart(dx, dy);
        }
        this.dropAllZeroSegments();
    }

    public void shiftStraightSegmentRun(List straight, Vector2D shift, String parent, List attached) {
        double dx = shift.getX();
        double dy = shift.getY();
        int numStr = straight.size();
        for (int i = 0; i < numStr; ++i) {
            String segID = (String)straight.get(i);
            LinkSegment shiftSeg = this.getSegment(segID);
            shiftSeg.shiftBoth(dx, dy);
        }
        if (parent != null) {
            LinkSegment parentSeg = this.getSegment(parent);
            if (parentSeg.isDegenerate()) {
                parentSeg.shiftStart(dx, dy);
            } else {
                parentSeg.shiftEnd(dx, dy);
            }
        }
        int size = attached.size();
        for (int i = 0; i < size; ++i) {
            String segID = (String)attached.get(i);
            LinkSegment seg = this.getSegment(segID);
            seg.shiftStart(dx, dy);
        }
    }

    public boolean cleanupJaggedTee(double[] shifts, SegmentWithKids rootSK, List firstRun, List secondRun, SegmentWithKids eliminate) {
        Vector2D currShift;
        if (shifts[0] != 0.0) {
            currShift = new Vector2D(eliminate.segment.getRun());
            currShift.scale(shifts[0]);
            this.shiftStraightSegmentRunFromList(firstRun, currShift, rootSK);
        }
        if (shifts[1] != 0.0) {
            currShift = new Vector2D(eliminate.segment.getRun());
            currShift.scale(shifts[1]);
            this.shiftStraightSegmentRunFromList(secondRun, currShift, rootSK);
        }
        this.dropAllZeroSegments();
        return true;
    }

    public boolean dropAllZeroSegments() {
        ArrayList<LinkSegment> deadList = new ArrayList<LinkSegment>();
        Iterator sit = this.getSegments();
        int deadSize = 0;
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            if (ls.isDegenerate() || ls.getLength() != 0.0) continue;
            deadList.add(ls);
            ++deadSize;
        }
        for (int i = 0; i < deadSize; ++i) {
            this.dropZeroSegment((LinkSegment)deadList.get(i));
        }
        return deadSize > 0;
    }

    public void dropZeroSegment(LinkSegment eliminate) {
        if (eliminate.isDegenerate() || eliminate.getLength() != 0.0) {
            throw new IllegalArgumentException();
        }
        String elimID = eliminate.getID();
        if (elimID == null) {
            throw new IllegalArgumentException();
        }
        this.labels_.removeLabel(elimID);
        this.segments_.remove(elimID);
        String parent = eliminate.getParent();
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            String myparent = ls.getParent();
            if (myparent == null || !myparent.equals(elimID)) continue;
            ls.setParent(parent);
        }
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            String ref = nextDrop.getConnectionTag();
            if (!elimID.equals(ref)) continue;
            nextDrop.setConnectionTag(parent);
            LinkSegment parSeg = this.getSegment(parent);
            nextDrop.setConnectionSense(parSeg.isDegenerate() ? 0 : 1);
        }
    }

    public boolean cleanupStaggeredRun(double shift, SegmentWithKids rootSK, List straightRun, SegmentWithKids eliminate) {
        if (shift != 0.0) {
            Vector2D currShift = new Vector2D(eliminate.segment.getRun());
            currShift.scale(-shift);
            this.shiftStraightSegmentRunFromList(straightRun, currShift, rootSK);
        }
        this.dropAllZeroSegments();
        return true;
    }

    public void compress(SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds) {
        if (this.textPos_ != null) {
            LinkProperties.shiftSupport(this.textPos_, emptyRows, emptyCols, bounds, -1.0, 1);
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            this.segmentShiftSupport(seg, emptyRows, emptyCols, bounds, -1.0, 1);
        }
        this.shiftDropEndsForExpandCompressOps(emptyRows, emptyCols, bounds, -1.0, 1);
    }

    public void expand(SortedSet newRows, SortedSet newCols, int mult) {
        if (this.textPos_ != null) {
            LinkProperties.shiftSupport(this.textPos_, newRows, newCols, null, 1.0, mult);
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            this.segmentShiftSupport(seg, newRows, newCols, null, 1.0, mult);
        }
        this.shiftDropEndsForExpandCompressOps(newRows, newCols, null, 1.0, mult);
    }

    public void fullShift(double dx, double dy) {
        if (this.textPos_ != null) {
            this.textPos_.setLocation(this.textPos_.getX() + dx, this.textPos_.getY() + dy);
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            seg.shiftBoth(dx, dy);
        }
        this.shiftDropEnds(dx, dy, null);
    }

    public void shiftPerMap(Map mappedPositions, boolean forceToGrid) {
        Point2D mapped;
        if (this.textPos_ != null && (mapped = (Point2D)mappedPositions.get(this.textPos_)) != null) {
            this.textPos_.setLocation(mapped.getX(), mapped.getY());
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            Point2D oldPoint = seg.getStart();
            Point2D mapped2 = (Point2D)mappedPositions.get(oldPoint);
            if (mapped2 != null) {
                seg.setStart((Point2D)mapped2.clone());
            }
            if (seg.isDegenerate() || (mapped2 = (Point2D)mappedPositions.get(oldPoint = seg.getEnd())) == null) continue;
            seg.setEnd((Point2D)mapped2.clone());
        }
        this.moveDropEndsPerMap(mappedPositions, forceToGrid);
    }

    public void shiftSelectedSegmentsAndDrops(double dx, double dy, LinkFragmentShifts fragShifts) {
        Iterator sit = this.segments_.keySet().iterator();
        while (sit.hasNext()) {
            String segID = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(segID);
            LinkFragmentData lfd = (LinkFragmentData)fragShifts.segmentStarts.get(segID);
            if (lfd != null) {
                seg.shiftStart(dx, dy);
                if (lfd.expComp != null) {
                    seg.shiftStart(lfd.expComp.getX(), lfd.expComp.getY());
                }
            }
            if ((lfd = (LinkFragmentData)fragShifts.segmentEnds.get(segID)) == null) continue;
            seg.shiftEnd(dx, dy);
            if (lfd.expComp == null) continue;
            seg.shiftEnd(lfd.expComp.getX(), lfd.expComp.getY());
        }
        this.shiftSelectedDropEnds(dx, dy, fragShifts);
    }

    public static void expandCompressSelectedSegmentsAndDrops(SortedSet rows, SortedSet cols, Rectangle bounds, boolean expand, int mult, LinkFragmentShifts fragShifts) {
        LinkFragmentData lfd;
        double sign = expand ? 1.0 : -1.0;
        int modMult = expand ? mult : 1;
        Iterator sit = fragShifts.segmentStarts.values().iterator();
        while (sit.hasNext()) {
            lfd = (LinkFragmentData)sit.next();
            lfd.expandContract(rows, cols, bounds, sign, modMult);
        }
        sit = fragShifts.segmentEnds.values().iterator();
        while (sit.hasNext()) {
            lfd = (LinkFragmentData)sit.next();
            lfd.expandContract(rows, cols, bounds, sign, modMult);
        }
        sit = fragShifts.drops.values().iterator();
        while (sit.hasNext()) {
            lfd = (LinkFragmentData)sit.next();
            lfd.expandContract(rows, cols, bounds, sign, modMult);
        }
        if (fragShifts.doSource != null) {
            fragShifts.doSource.expandContract(rows, cols, bounds, sign, modMult);
        }
    }

    public LinkSegmentID simpleIntersect(Point2D point) {
        Iterator sit = this.segments_.keySet().iterator();
        while (sit.hasNext()) {
            String segKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(segKey);
            if (seg.getStart().equals(point)) {
                LinkSegmentID lsid = LinkSegmentID.buildIDForType(segKey, 3);
                lsid.tagIDWithEndpoint("S");
                return lsid;
            }
            if (seg.isDegenerate() || !seg.getEnd().equals(point)) continue;
            LinkSegmentID lsid = LinkSegmentID.buildIDForType(segKey, 3);
            lsid.tagIDWithEndpoint("E");
            return lsid;
        }
        return null;
    }

    public DistancedLinkSegID intersectBusSegment(Genome genome, OverlayStateOracle oso, Layout layout, Point2D pt, FontRenderContext frc, Set omittedDrops, double intersectTol) {
        String segID;
        LinkSegment seg;
        ThickInfo ti = this.maxThickForIntersect(genome, oso, intersectTol);
        int upperBound = ti.maxThick;
        boolean twoPass = ti.twoPass;
        double upperTol = (double)upperBound / 2.0;
        TreeMap<Double, DistancedLinkSegID> bestFits = new TreeMap<Double, DistancedLinkSegID>();
        if (this.isDirect()) {
            String targRef = this.getTargetDrop().getTargetRef();
            if (omittedDrops != null && omittedDrops.contains(targRef)) {
                return null;
            }
            if (!this.linkIsInModel(genome, oso, targRef)) {
                return null;
            }
            LinkSegment fakeDirect = this.getDirectLinkPath(genome, layout, frc);
            return this.twoPassCheckSegmentIntersect(fakeDirect, pt, 2, targRef, genome, intersectTol, upperTol, twoPass, false, oso);
        }
        HashSet set = new HashSet();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            int dropType;
            LinkSegment dropSeg;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            if (omittedDrops != null && dropRef != null && omittedDrops.contains(dropRef) || dropRef != null && !this.linkIsInModel(genome, oso, dropRef)) continue;
            if (dropRef == null) {
                dropSeg = this.getSourceDropSegment(genome, layout, frc, true);
                dropType = 0;
            } else {
                dropSeg = this.getTargetDropSegment(drop, genome, layout, frc);
                dropType = 1;
            }
            DistancedLinkSegID retval = this.twoPassCheckSegmentIntersect(dropSeg, pt, dropType, dropRef, genome, intersectTol, upperTol, twoPass, false, oso);
            if (retval != null) {
                bestFits.put(new Double(retval.distance), retval);
            }
            set.addAll(this.getSegmentsToRoot(drop));
        }
        Iterator sit = set.iterator();
        while (sit.hasNext()) {
            DistancedLinkSegID retval;
            seg = (LinkSegment)sit.next();
            if (seg.isDegenerate() || (retval = this.twoPassCheckSegmentIntersect(seg, pt, 3, segID = seg.getID(), genome, intersectTol, upperTol, twoPass, false, oso)) == null) continue;
            bestFits.put(new Double(retval.distance), retval);
        }
        if (!bestFits.isEmpty()) {
            return (DistancedLinkSegID)bestFits.get(bestFits.firstKey());
        }
        sit = set.iterator();
        while (sit.hasNext()) {
            DistancedLinkSegID retval;
            seg = (LinkSegment)sit.next();
            if (seg.isDegenerate() || (retval = this.twoPassCheckSegmentIntersect(seg, pt, 3, segID = seg.getID(), genome, intersectTol, upperTol, twoPass, true, oso)) == null) continue;
            bestFits.put(new Double(retval.distance), retval);
        }
        if (!bestFits.isEmpty()) {
            return (DistancedLinkSegID)bestFits.get(bestFits.firstKey());
        }
        return null;
    }

    protected ThickInfo maxThickForIntersectSupport(Genome genome, OverlayStateOracle oso, boolean forModules, double intersectTol) {
        SuggestedDrawStyle sds;
        int defaultThick;
        int maxThick = defaultThick = SuggestedDrawStyle.trueThick(this.getDrawStyle().getThickness(), forModules);
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            int nextThick;
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            String dropRef = bd.getTargetRef();
            if (dropRef != null && !this.linkIsInModel(genome, oso, dropRef)) continue;
            if (bd.getDropType() != 0) {
                int nextThick2;
                SuggestedDrawStyle sdsFl;
                PerLinkDrawStyle plds = bd.getDrawStyleForLink();
                SuggestedDrawStyle suggestedDrawStyle = sdsFl = plds == null ? null : plds.getDrawStyle();
                if (sdsFl != null && sdsFl.getThickness() != -4 && (nextThick2 = SuggestedDrawStyle.trueThick(sdsFl.getThickness(), forModules)) > maxThick) {
                    maxThick = nextThick2;
                }
            }
            if ((sds = bd.getSpecialDropDrawStyle()) == null || sds.getThickness() == -4 || (nextThick = SuggestedDrawStyle.trueThick(sds.getThickness(), forModules)) <= maxThick) continue;
            maxThick = nextThick;
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            int nextThick;
            LinkSegment seg = (LinkSegment)sit.next();
            sds = seg.getSpecialDrawStyle();
            if (sds == null || sds.getThickness() == -4 || (nextThick = SuggestedDrawStyle.trueThick(sds.getThickness(), forModules)) <= maxThick) continue;
            maxThick = nextThick;
        }
        ThickInfo retval = new ThickInfo();
        retval.maxThick = maxThick;
        retval.twoPass = maxThick > SuggestedDrawStyle.drawThick(forModules) && (double)maxThick > intersectTol * 2.0;
        return retval;
    }

    public PerLinkDrawStyle getDrawStyleForLinkage(String linkID) {
        LinkBusDrop drop = this.getTargetDrop(linkID);
        return drop.getDrawStyleForLink();
    }

    public void setDrawStyleForLinkage(String linkID, PerLinkDrawStyle plds) {
        LinkBusDrop drop = this.getTargetDrop(linkID);
        drop.setDrawStyleForLink(plds);
    }

    public LinkSegment getSegmentGeometryForParent(LinkSegmentID segID, Genome genome, Layout layout, FontRenderContext frc, boolean forceToGrid) {
        if (segID.isDirect()) {
            return null;
        }
        if (segID.isForStartDrop()) {
            return null;
        }
        if (segID.isForEndDrop()) {
            LinkBusDrop bd = this.getTargetDrop(segID);
            String lsId = bd.getConnectionTag();
            LinkSegment dropParent = this.getSegment(lsId);
            String dropParentID = dropParent.getID();
            int sense = bd.getConnectionSense();
            if (sense == 0) {
                String metaParent = dropParent.getParent();
                if (metaParent != null) {
                    dropParentID = metaParent;
                } else {
                    return this.getSourceDropSegment(genome, layout, frc, forceToGrid);
                }
            }
            return new LinkSegment(this.getSegment(dropParentID));
        }
        LinkSegment thisSeg = this.getSegment(segID);
        String linkSegParent = thisSeg.getParent();
        if (thisSeg.isDegenerate() || linkSegParent == null) {
            return this.getSourceDropSegment(genome, layout, frc, forceToGrid);
        }
        return new LinkSegment(this.getSegment(linkSegParent));
    }

    public List intersectBusSegmentsWithRect(Genome genome, OverlayStateOracle oso, Layout layout, Rectangle2D testRect, boolean includeRoot, FontRenderContext frc) {
        return this.intersectBusSegmentsWithShape(genome, oso, layout, testRect, includeRoot, frc);
    }

    public List intersectBusSegmentsWithShape(Genome genome, OverlayStateOracle oso, Layout layout, Shape testShape, boolean includeRoot, FontRenderContext frc) {
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        if (this.isDirect()) {
            String targRef = this.getTargetDrop().getTargetRef();
            if (targRef != null && !this.linkIsInModel(genome, oso, targRef)) {
                return retval;
            }
            LinkSegment fakeDirect = this.getDirectLinkPath(genome, layout, frc);
            LinkSegmentID result = this.checkForSegmentInShape(fakeDirect, testShape, 2, targRef);
            if (result != null) {
                retval.add(result);
            }
            return retval;
        }
        HashSet set = new HashSet();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            int dropType;
            LinkSegment dropSeg;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            if (dropRef != null && !this.linkIsInModel(genome, oso, dropRef)) continue;
            if (dropRef == null) {
                dropSeg = this.getSourceDropSegment(genome, layout, frc, true);
                dropType = 0;
            } else {
                dropSeg = this.getTargetDropSegment(drop, genome, layout, frc);
                dropType = 1;
            }
            LinkSegmentID result = this.checkForSegmentInShape(dropSeg, testShape, dropType, dropRef);
            if (result != null) {
                retval.add(result);
            }
            set.addAll(this.getSegmentsToRoot(drop));
        }
        Iterator sit = set.iterator();
        while (sit.hasNext()) {
            String segID;
            LinkSegmentID result;
            LinkSegment seg = (LinkSegment)sit.next();
            if (seg.isDegenerate() || (result = this.checkForSegmentInShape(seg, testShape, 3, segID = seg.getID())) == null) continue;
            retval.add(result);
        }
        return retval;
    }

    public void moveBusLinkSegments(LinkSegmentID[] segIDs, Point2D strt, double dx, double dy) {
        int num = segIDs.length;
        if (num == 1 && segIDs[0].isDirect()) {
            return;
        }
        HashSet seenCookies = new HashSet();
        for (int i = 0; i < num; ++i) {
            this.moveBusLinkCore(segIDs[i], strt, dx, dy, seenCookies);
        }
    }

    public void addSegmentInSeries(LinkSegment newSeg) {
        if (this.drops_.size() != 2) {
            throw new IllegalStateException();
        }
        if (this.segments_.size() == 0) {
            LinkSegment rootSeg = new LinkSegment(newSeg.getStart(), null);
            this.addSegment(rootSeg);
            String rootID = rootSeg.getID();
            boolean rootOnly = newSeg.isDegenerate();
            String addID = null;
            if (!rootOnly) {
                LinkSegment addSeg = new LinkSegment(newSeg);
                addSeg.setID(null);
                addSeg.setParent(rootID);
                this.addSegment(addSeg);
                addID = addSeg.getID();
            }
            Iterator dit = this.drops_.iterator();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (drop.getDropType() == 0) {
                    drop.setConnectionSense(0);
                    drop.setConnectionTag(rootID);
                    continue;
                }
                if (rootOnly) {
                    drop.setConnectionSense(0);
                    drop.setConnectionTag(rootID);
                    continue;
                }
                drop.setConnectionSense(1);
                drop.setConnectionTag(addID);
            }
            return;
        }
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String tag = drop.getConnectionTag();
            LinkSegment addSeg = new LinkSegment(newSeg);
            addSeg.setID(null);
            addSeg.setParent(tag);
            this.addSegment(addSeg);
            drop.setConnectionSense(1);
            drop.setConnectionTag(addSeg.getID());
        }
    }

    public void addSegment(LinkSegment newSeg) {
        if (newSeg.getID() == null) {
            newSeg.setID(this.labels_.getNextLabel());
        } else if (!this.labels_.addExistingLabel(newSeg.getID())) {
            System.err.println(newSeg.getID() + " is not unique");
            throw new IllegalArgumentException();
        }
        this.segments_.put(newSeg.getID(), newSeg);
    }

    public boolean isDirect() {
        return this.segments_.isEmpty();
    }

    public List getSegmentIDsToRootForEndDrop(LinkBusDrop drop) {
        if (drop.getDropType() != 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        if (this.isDirect()) {
            List allLinks = this.getLinkageList();
            String linkRef = (String)allLinks.get(0);
            retval.add(LinkSegmentID.buildIDForDirect(linkRef));
            return retval;
        }
        retval.add(LinkSegmentID.buildIDForEndDrop(drop.getTargetRef()));
        List segsToRoot = this.getSegmentsToRoot(drop);
        int segSize = segsToRoot.size();
        for (int j = 0; j < segSize; ++j) {
            LinkSegment seg = (LinkSegment)segsToRoot.get(j);
            if (seg.isDegenerate()) continue;
            retval.add(LinkSegmentID.buildIDForSegment(seg.getID()));
        }
        retval.add(LinkSegmentID.buildIDForStartDrop());
        return retval;
    }

    public List getLinkageList() {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)drops.next();
            if (drop.getDropType() == 0) continue;
            retval.add(drop.getTargetRef());
        }
        return retval;
    }

    public List getSegmentsToRoot(LinkBusDrop drop) {
        LinkSegment parent;
        String segID = drop.getConnectionTag();
        if (segID == null) {
            return new ArrayList();
        }
        LinkSegment need = (LinkSegment)this.segments_.get(segID);
        if (drop.getConnectionSense() == 0 && drop.getDropType() == 1 && (parent = (LinkSegment)this.segments_.get(need.getParent())) != null) {
            need = parent;
        }
        return this.getSegmentsToRoot(need);
    }

    public List getSegmentsToRoot(LinkSegment seg) {
        ArrayList<LinkSegment> retval = new ArrayList<LinkSegment>();
        LinkSegment curr = seg;
        retval.add(curr);
        String parent = curr.getParent();
        while (parent != null) {
            curr = (LinkSegment)this.segments_.get(parent);
            retval.add(curr);
            parent = curr.getParent();
        }
        return retval;
    }

    public Set getPointsToRoot(LinkSegmentID segID) {
        HashSet<Object> retval = new HashSet<Object>();
        if (segID.isDirect() || segID.isForStartDrop()) {
            return retval;
        }
        List s2r = segID.isForSegment() ? this.getSegmentsToRoot(this.getSegment(segID)) : this.getSegmentsToRoot(this.getDrop(segID));
        int numS = s2r.size();
        for (int i = 0; i < numS; ++i) {
            LinkSegment seg = (LinkSegment)s2r.get(i);
            retval.add(seg.getStart().clone());
        }
        return retval;
    }

    public Set getAllPointsToLeaves(LinkSegmentID segID) {
        HashSet<Object> retval = new HashSet<Object>();
        if (segID.isDirect()) {
            return retval;
        }
        if (segID.isForStartDrop()) {
            return this.getAllTreePoints();
        }
        if (segID.isForEndDrop()) {
            return retval;
        }
        String targSeg = segID.getLinkSegTag();
        Set linksThru = this.resolveLinkagesThroughSegment(segID);
        Iterator bdit = this.getDrops();
        block0: while (bdit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)bdit.next();
            String ref = drop.getTargetRef();
            if (ref == null || !linksThru.contains(ref)) continue;
            List s2r = this.getSegmentsToRoot(drop);
            int numS = s2r.size();
            for (int i = 0; i < numS; ++i) {
                LinkSegment seg = (LinkSegment)s2r.get(i);
                retval.add(seg.getEnd().clone());
                if (seg.getID().equals(targSeg)) continue block0;
                retval.add(seg.getStart().clone());
            }
        }
        return retval;
    }

    public Set getAllTreePoints() {
        HashSet<Object> retval = new HashSet<Object>();
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            retval.add(seg.getStart().clone());
            if (seg.isDegenerate()) continue;
            retval.add(seg.getEnd().clone());
        }
        return retval;
    }

    public void splitTreePoints(LinkSegmentID lsid, Set below, Set notBelow) {
        below.clear();
        notBelow.clear();
        below.addAll(this.getAllPointsToLeaves(lsid));
        notBelow.addAll(this.getAllTreePoints());
        notBelow.removeAll(below);
    }

    public LinkSegment getSegmentGeometryForID(LinkSegmentID segID, Genome genome, Layout layout, FontRenderContext frc, boolean forceToGrid) {
        if (segID.isDirect()) {
            if (!this.isDirect()) {
                throw new IllegalArgumentException();
            }
            return this.getDirectLinkPath(genome, layout, frc);
        }
        if (segID.isForStartDrop()) {
            return this.getSourceDropSegment(genome, layout, frc, forceToGrid);
        }
        if (segID.isForEndDrop()) {
            LinkBusDrop drop = this.getTargetDrop(segID);
            return this.getTargetDropSegment(drop, genome, layout, frc);
        }
        LinkSegment seg = this.getSegment(segID);
        return new LinkSegment(seg);
    }

    public LinkSegment getSegment(LinkSegmentID lsid) {
        if (!lsid.isForSegment()) {
            throw new IllegalArgumentException();
        }
        String id = lsid.getLinkSegTag();
        return (LinkSegment)this.segments_.get(id);
    }

    public LinkBusDrop getTargetDrop(LinkSegmentID segID) {
        if (segID.isDirect()) {
            return this.getTargetDrop();
        }
        if (segID.isForEndDrop()) {
            String targID = segID.getEndDropLinkRef();
            return this.getTargetDrop(targID);
        }
        throw new IllegalArgumentException();
    }

    public LinkBusDrop getTargetDrop(String linkID) {
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            String tref = bd.getTargetRef();
            if (tref == null || !tref.equals(linkID)) continue;
            return bd;
        }
        throw new IllegalArgumentException();
    }

    public LinkBusDrop getTargetDrop() {
        if (!this.isSingleDropTree()) {
            throw new IllegalStateException();
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            String tref = bd.getTargetRef();
            if (tref == null) continue;
            return bd;
        }
        throw new IllegalArgumentException();
    }

    public boolean isSingleDropTree() {
        return this.drops_.size() == 2;
    }

    public Iterator getDrops() {
        return this.drops_.iterator();
    }

    public LinkProperties buildReducedProperties(Set remainingLinks) {
        LinkProperties retval = (LinkProperties)this.clone();
        HashMap<String, String> dummyLinkMap = new HashMap<String, String>();
        Iterator sit = remainingLinks.iterator();
        while (sit.hasNext()) {
            String linkID = (String)sit.next();
            dummyLinkMap.put(linkID, linkID);
        }
        HashMap<String, String> dummyNodeMap = new HashMap<String, String>();
        dummyNodeMap.put(this.srcTag_, this.srcTag_);
        retval.mapToNewLink(dummyLinkMap, dummyNodeMap);
        return retval;
    }

    public void mapToNewLink(Map linkMap, Map nodeMap) {
        this.srcTag_ = (String)nodeMap.get(this.srcTag_);
        ArrayList<LinkBusDrop> newDrops = new ArrayList<LinkBusDrop>();
        int size = this.drops_.size();
        for (int i = 0; i < size; ++i) {
            LinkBusDrop bd = (LinkBusDrop)this.drops_.get(i);
            if (!bd.mapToNewLink(linkMap, nodeMap)) continue;
            newDrops.add(bd);
        }
        this.drops_ = newDrops;
        this.removeDanglingSegments();
    }

    public void removeDanglingSegments() {
        LinkBusDrop bd;
        int i;
        HashSet deadSet = new HashSet(this.segments_.keySet());
        int size = this.drops_.size();
        for (i = 0; i < size; ++i) {
            bd = (LinkBusDrop)this.drops_.get(i);
            if (bd.getDropType() == 0) continue;
            List seg2root = this.getSegmentsToRoot(bd);
            int segSize = seg2root.size();
            for (int j = 0; j < segSize; ++j) {
                String id = ((LinkSegment)seg2root.get(j)).getID();
                if (!deadSet.contains(id)) continue;
                deadSet.remove(id);
            }
        }
        for (i = 0; i < size; ++i) {
            String connectTag;
            bd = (LinkBusDrop)this.drops_.get(i);
            if (bd.getDropType() == 0 || bd.getConnectionSense() != 0 || !deadSet.contains(connectTag = bd.getConnectionTag())) continue;
            LinkSegment lseg = this.getSegment(connectTag);
            String parent = lseg.getParent();
            if (parent == null) {
                throw new IllegalStateException();
            }
            LinkSegment pseg = this.getSegment(parent);
            if (!pseg.isDegenerate()) {
                bd.setConnectionSense(1);
            }
            bd.setConnectionTag(parent);
        }
        Iterator dsit = deadSet.iterator();
        while (dsit.hasNext()) {
            String dead = (String)dsit.next();
            this.labels_.removeLabel(dead);
            this.segments_.remove(dead);
        }
    }

    public LinkBusDrop getDrop(LinkSegmentID segID) {
        if (!segID.isForDrop()) {
            throw new IllegalArgumentException();
        }
        boolean isForStart = segID.isForStartDrop();
        boolean isForEnd = segID.isForEndDrop();
        String idDropRef = isForEnd ? segID.getEndDropLinkRef() : null;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            int dropType = drop.getDropType();
            if (isForStart && dropType == 0) {
                return drop;
            }
            if (!isForEnd || dropType != 1 || !dropRef.equals(idDropRef)) continue;
            return drop;
        }
        throw new IllegalArgumentException();
    }

    public void mergeSinglePathTree(LinkProperties spTree, Genome genome, Layout lo, FontRenderContext frc) {
        if (!spTree.getSourceTag().equals(this.getSourceTag()) || !spTree.isSingleDropTree()) {
            throw new IllegalArgumentException();
        }
        if (spTree.isDirect()) {
            spTree.splitNoSegmentBus(genome, lo, frc);
        }
        if (this.isDirect()) {
            this.splitNoSegmentBus(genome, lo, frc);
        }
        LinkSegment myRoot = this.getRootSegment();
        LinkSegment hisRoot = spTree.getRootSegment();
        Point2D myStrt = myRoot.getStart();
        Point2D hisStrt = hisRoot.getStart();
        double delX = 0.0;
        double delY = 0.0;
        if (!myStrt.equals(hisStrt)) {
            delX = myStrt.getX() - hisStrt.getX();
            delY = myStrt.getY() - hisStrt.getY();
            Iterator sit = spTree.getSegments();
            while (sit.hasNext()) {
                LinkSegment seg = (LinkSegment)sit.next();
                seg.shiftBoth(delX, delY);
            }
        }
        this.chop(spTree);
        spTree.chop(this);
        LinkBusDrop spDrop = spTree.getTargetDrop();
        List pathToRoot = spTree.getSegmentsToRoot(spDrop);
        int pathSize = pathToRoot.size();
        if (pathSize == 1) {
            LinkBusDrop drop = this.generateBusDrop(spDrop, myRoot.getID(), 1, 0);
            drop.transferSpecialStyles(spDrop);
            this.addDrop(drop);
            return;
        }
        String lastMatch = myRoot.getID();
        boolean matching = true;
        for (int i = pathSize - 2; i >= 0; --i) {
            LinkSegment spTreeSeg = (LinkSegment)pathToRoot.get(i);
            if (matching) {
                Point2D slpStrt = spTreeSeg.getStart();
                Point2D slpEnd = spTreeSeg.getEnd();
                Iterator vit = this.getSegments();
                boolean hadMatch = false;
                while (vit.hasNext()) {
                    LinkSegment bpSeg = (LinkSegment)vit.next();
                    if (bpSeg.isDegenerate()) continue;
                    Point2D bpStrt = bpSeg.getStart();
                    Point2D bpEnd = bpSeg.getEnd();
                    if (!lastMatch.equals(bpSeg.getParent()) || !bpStrt.equals(slpStrt) || !bpEnd.equals(slpEnd)) continue;
                    hadMatch = true;
                    lastMatch = bpSeg.getID();
                    break;
                }
                if (!hadMatch) {
                    matching = false;
                }
            }
            if (matching) continue;
            String newId = this.labels_.getNextLabel();
            spTreeSeg.setID(newId);
            spTreeSeg.setParent(lastMatch);
            this.segments_.put(newId, spTreeSeg);
            lastMatch = newId;
        }
        LinkBusDrop drop = this.generateBusDrop(spDrop, lastMatch, 1, 1);
        drop.transferSpecialStyles(spDrop);
        this.addDrop(drop);
    }

    public void chop(LinkProperties other) {
        ArrayList<ChopRequest> chopRequests = new ArrayList<ChopRequest>();
        Iterator osit = other.getSegments();
        while (osit.hasNext()) {
            LinkSegment seg = (LinkSegment)osit.next();
            Point2D testPoint = seg.isDegenerate() ? seg.getStart() : seg.getEnd();
            Vector2D trav = seg.getRun();
            Iterator msit = this.getSegments();
            while (msit.hasNext()) {
                ChopRequest chp;
                LinkSegment mseg = (LinkSegment)msit.next();
                Vector2D travM = mseg.getRun();
                if (trav != null && travM != null && (trav.isZero() || travM.isZero() || !trav.equals(travM)) || (chp = this.intersectForChop(mseg, testPoint)) == null) continue;
                chopRequests.add(chp);
            }
        }
        int chopNum = chopRequests.size();
        for (int i = 0; i < chopNum; ++i) {
            ChopRequest cr = (ChopRequest)chopRequests.get(i);
            if (cr.segmentID == null) continue;
            LinkSegment ls = this.getSegment(cr.segmentID);
            LinkSegment[] newSegs = ls.split(cr.splitPt);
            if (newSegs.length == 1) {
                throw new IllegalStateException();
            }
            this.replaceSegment(ls, newSegs[0], newSegs[1]);
            for (int j = i + 1; j < chopNum; ++j) {
                ChopRequest cr2 = (ChopRequest)chopRequests.get(j);
                if (cr2.segmentID == null || !cr2.segmentID.equals(cr.segmentID)) continue;
                ChopRequest chp = this.intersectForChop(newSegs[0], cr2.splitPt);
                cr2.segmentID = chp != null ? newSegs[0].getID() : ((chp = this.intersectForChop(newSegs[1], cr2.splitPt)) != null ? newSegs[1].getID() : null);
            }
        }
    }

    private ChopRequest intersectForChop(LinkSegment mseg, Point2D testPoint) {
        if (mseg.intersectsStart(testPoint, 0.01) != null) {
            return null;
        }
        if (mseg.isDegenerate()) {
            return null;
        }
        if (mseg.intersectsEnd(testPoint, 0.01) != null) {
            return null;
        }
        if (mseg.intersects(testPoint, 0.01) != null) {
            return new ChopRequest(testPoint, mseg.getID());
        }
        return null;
    }

    public List orderSegmentsParentToChild(List segments, boolean omitRoot) {
        int numSegs = segments.size();
        if (numSegs == 0) {
            return new ArrayList();
        }
        HashSet<String> segIDs = new HashSet<String>();
        for (int i = 0; i < numSegs; ++i) {
            LinkSegment seg = (LinkSegment)segments.get(i);
            segIDs.add(seg.getID());
        }
        LinkSegment firstSeg = null;
        HashSet<String> seenParents = new HashSet<String>();
        boolean rootIsParent = false;
        for (int i = 0; i < numSegs; ++i) {
            LinkSegment seg = (LinkSegment)segments.get(i);
            String parent = seg.getParent();
            if (parent == null) {
                if (rootIsParent) {
                    throw new IllegalArgumentException();
                }
                rootIsParent = true;
            } else {
                if (seenParents.contains(parent)) {
                    throw new IllegalArgumentException();
                }
                seenParents.add(parent);
            }
            if (parent != null && segIDs.contains(parent)) continue;
            if (firstSeg != null) {
                throw new IllegalArgumentException();
            }
            firstSeg = seg;
        }
        if (firstSeg == null) {
            throw new IllegalArgumentException();
        }
        String currParent = firstSeg.getID();
        ArrayList<LinkSegment> retval = new ArrayList<LinkSegment>();
        retval.add(firstSeg);
        block2: while (retval.size() < numSegs) {
            for (int i = 0; i < numSegs; ++i) {
                LinkSegment seg = (LinkSegment)segments.get(i);
                String parent = seg.getParent();
                if (parent == null || !currParent.equals(parent)) continue;
                retval.add(seg);
                currParent = seg.getID();
                continue block2;
            }
        }
        if (rootIsParent && omitRoot) {
            retval.remove(0);
        }
        return retval;
    }

    public List findHomologousLinkChain(LinkSegment seedSegment, boolean omitRoot) {
        String seedID = seedSegment.getID();
        HashSet<String> seedLinks = new HashSet<String>();
        HashMap<String, HashSet<String>> segIDToLinks = new HashMap<String, HashSet<String>>();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String rootRef = drop.getTargetRef();
            if (rootRef == null) continue;
            List segsToRoot = this.getSegmentsToRoot(drop);
            int segSize = segsToRoot.size();
            for (int j = 0; j < segSize; ++j) {
                String id = ((LinkSegment)segsToRoot.get(j)).getID();
                HashSet<String> linksForSeg = (HashSet<String>)segIDToLinks.get(id);
                if (linksForSeg == null) {
                    linksForSeg = new HashSet<String>();
                    segIDToLinks.put(id, linksForSeg);
                }
                linksForSeg.add(rootRef);
                if (!id.equals(seedID)) continue;
                seedLinks.add(rootRef);
            }
        }
        ArrayList<LinkSegment> matches = new ArrayList<LinkSegment>();
        Iterator stlit = segIDToLinks.keySet().iterator();
        while (stlit.hasNext()) {
            String id = (String)stlit.next();
            Set linksForSeg = (Set)segIDToLinks.get(id);
            if (!((Object)linksForSeg).equals(seedLinks)) continue;
            matches.add(this.getSegment(id));
        }
        List pToC = this.orderSegmentsParentToChild(matches, omitRoot);
        return pToC;
    }

    public Point2D getSplitPoint(LinkSegmentID segID, Point2D splitPtIn, Genome genome, Layout layout, FontRenderContext frc) {
        Point2D splitPt = (Point2D)splitPtIn.clone();
        LinkSegment lseg = this.getSegmentGeometryForID(segID, genome, layout, frc, true);
        double frac = lseg.fractionOfRun(splitPtIn);
        splitPt = lseg.pointAtFraction(frac);
        return splitPt;
    }

    public LinkSegmentID findSegmentSupportingLinkSet(BusProperties rootBus, LinkSegmentID rootMatchingSegID, Layout rootLayout, Genome rootGenome, Set linksToMatch, Layout layout, Genome genome, FontRenderContext frc) {
        LinkSegment currSeg;
        int i;
        LinkSegment currRootSeg;
        int j;
        LinkSegment currSeg2;
        int i2;
        LinkSegment rootMatchingSeg = rootBus.getSegmentGeometryForID(rootMatchingSegID, rootGenome, rootLayout, frc, true);
        HashSet allLinks = new HashSet(this.getLinkageList());
        boolean rootDropOK = allLinks.equals(linksToMatch);
        if (this.isDirect()) {
            if (!rootDropOK) {
                throw new IllegalStateException();
            }
            String linkRef = (String)allLinks.iterator().next();
            return LinkSegmentID.buildIDForDirect(linkRef);
        }
        LinkSegment myRoot = this.getRootSegment();
        String myRootID = myRoot.getID();
        HashMap<String, HashSet<String>> segIDToLinks = new HashMap<String, HashSet<String>>();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String rootRef = drop.getTargetRef();
            if (rootRef == null) continue;
            List segsToRoot = this.getSegmentsToRoot(drop);
            int segSize = segsToRoot.size();
            for (int j2 = 0; j2 < segSize; ++j2) {
                String id = ((LinkSegment)segsToRoot.get(j2)).getID();
                HashSet<String> linksForSeg = (HashSet<String>)segIDToLinks.get(id);
                if (linksForSeg == null) {
                    linksForSeg = new HashSet<String>();
                    segIDToLinks.put(id, linksForSeg);
                }
                linksForSeg.add(rootRef);
            }
        }
        HashSet<String> retvals = new HashSet<String>();
        Iterator stlit = segIDToLinks.keySet().iterator();
        while (stlit.hasNext()) {
            String id = (String)stlit.next();
            Set linksForSeg = (Set)segIDToLinks.get(id);
            if (!((Object)linksForSeg).equals(linksToMatch)) continue;
            retvals.add(id);
        }
        if (retvals.isEmpty()) {
            if (rootDropOK) {
                throw new IllegalStateException();
            }
            if (linksToMatch.size() == 1) {
                String matchLink = (String)linksToMatch.iterator().next();
                return LinkSegmentID.buildIDForEndDrop(matchLink);
            }
            return null;
        }
        if (retvals.size() == 1) {
            String segID = (String)retvals.iterator().next();
            if (segID.equals(myRootID)) {
                if (!rootDropOK) {
                    throw new IllegalStateException();
                }
                return LinkSegmentID.buildIDForStartDrop();
            }
            return LinkSegmentID.buildIDForSegment(segID);
        }
        ArrayList<LinkSegment> chainMembers = new ArrayList<LinkSegment>();
        Iterator rit = retvals.iterator();
        while (rit.hasNext()) {
            String id = (String)rit.next();
            chainMembers.add(this.getSegment(id));
        }
        List myChain = this.orderSegmentsParentToChild(chainMembers, true);
        int mcNum = myChain.size();
        for (i2 = 0; i2 < mcNum; ++i2) {
            currSeg2 = (LinkSegment)myChain.get(i2);
            if (!currSeg2.isSimpleTranslation(rootMatchingSeg)) continue;
            return LinkSegmentID.buildIDForSegment(currSeg2.getID());
        }
        for (i2 = 0; i2 < mcNum; ++i2) {
            currSeg2 = (LinkSegment)myChain.get(i2);
            if (!currSeg2.isSimpleScaling(rootMatchingSeg)) continue;
            return LinkSegmentID.buildIDForSegment(currSeg2.getID());
        }
        List rootChain = rootBus.findHomologousLinkChain(rootMatchingSeg, true);
        int numRC = rootChain.size();
        for (j = 0; j < numRC; ++j) {
            currRootSeg = (LinkSegment)rootChain.get(j);
            for (i = 0; i < mcNum; ++i) {
                currSeg = (LinkSegment)myChain.get(i);
                if (!currSeg.isSimpleTranslation(currRootSeg)) continue;
                return LinkSegmentID.buildIDForSegment(currSeg.getID());
            }
        }
        for (j = 0; j < numRC; ++j) {
            currRootSeg = (LinkSegment)rootChain.get(j);
            for (i = 0; i < mcNum; ++i) {
                currSeg = (LinkSegment)myChain.get(i);
                if (!currSeg.isSimpleScaling(currRootSeg)) continue;
                return LinkSegmentID.buildIDForSegment(currSeg.getID());
            }
        }
        if (rootDropOK) {
            return LinkSegmentID.buildIDForStartDrop();
        }
        LinkSegment topSeg = (LinkSegment)myChain.get(0);
        return LinkSegmentID.buildIDForSegment(topSeg.getID());
    }

    public LinkSegmentID findBestSegmentForLabel(Set linksToMatch, int cardinality, Genome genome, OverlayStateOracle oso) {
        HashSet allLinks = new HashSet(this.getLinkageList());
        if (this.isDirect()) {
            String linkRef = (String)allLinks.iterator().next();
            return LinkSegmentID.buildIDForDirect(linkRef);
        }
        Set labelLinks = this.getLabelLinkages(genome, oso);
        HashMap cardinalities = new HashMap();
        HashSet conforming = new HashSet();
        HashSet bestFit = new HashSet();
        HashSet matchDefLinks = new HashSet();
        int minDiff = Integer.MAX_VALUE;
        Iterator sit = this.segments_.keySet().iterator();
        while (sit.hasNext()) {
            String segKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(segKey);
            if (seg.isDegenerate()) continue;
            LinkSegmentID lsid = LinkSegmentID.buildIDForType(segKey, 3);
            minDiff = this.collectSegmentCandidates(linksToMatch, labelLinks, lsid, genome, cardinalities, conforming, bestFit, matchDefLinks, minDiff, null, seg);
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String ref = drop.getTargetRef();
            LinkSegmentID lsid = ref == null ? LinkSegmentID.buildIDForType(null, 0) : LinkSegmentID.buildIDForType(ref, 1);
            minDiff = this.collectSegmentCandidates(linksToMatch, labelLinks, lsid, genome, cardinalities, conforming, bestFit, matchDefLinks, minDiff, drop, null);
        }
        HashSet checkCard = null;
        if (conforming.size() == 1) {
            return (LinkSegmentID)conforming.iterator().next();
        }
        if (conforming.size() > 1) {
            checkCard = conforming;
        } else {
            if (bestFit.size() == 1) {
                return (LinkSegmentID)bestFit.iterator().next();
            }
            if (bestFit.size() > 1) {
                checkCard = bestFit;
            } else {
                if (matchDefLinks.size() == 1) {
                    return (LinkSegmentID)matchDefLinks.iterator().next();
                }
                if (matchDefLinks.size() > 1) {
                    checkCard = matchDefLinks;
                }
            }
        }
        if (checkCard != null) {
            int minConformDiff = Integer.MAX_VALUE;
            LinkSegmentID bestCand = null;
            Iterator cit = checkCard.iterator();
            while (cit.hasNext()) {
                LinkSegmentID lsid = (LinkSegmentID)cit.next();
                Integer cardVal = (Integer)cardinalities.get(lsid);
                int diff = Math.abs(cardVal - cardinality);
                if (diff == 0) {
                    return lsid;
                }
                if (diff >= minConformDiff) continue;
                minConformDiff = diff;
                bestCand = lsid;
            }
            return bestCand;
        }
        return LinkSegmentID.buildIDForStartDrop();
    }

    public Set resolveLinkagesThroughSegment(LinkSegmentID segID, Genome genome) {
        return this.resolveLinkagesThroughSegment(segID);
    }

    public Set resolveLinkagesThroughSegment(LinkSegmentID segID) {
        HashSet<String> retval = new HashSet<String>();
        if (segID.isForStartDrop() || segID.isDirect()) {
            retval.addAll(this.getLinkageList());
            return retval;
        }
        if (segID.isForEndDrop()) {
            retval.add(segID.getEndDropLinkRef());
            return retval;
        }
        String segTag = segID.getLinkSegTag();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (!this.isSegmentAnAncestor(segTag, drop)) continue;
            retval.add(drop.getTargetRef());
        }
        return retval;
    }

    public int segRelationship(LinkSegmentID segID, LinkSegmentID otherSegID) {
        LinkSegment curr;
        String nextID;
        if (segID.equals(otherSegID)) {
            return 0;
        }
        if (segID.isForStartDrop()) {
            return 2;
        }
        if (otherSegID.isForStartDrop()) {
            return 1;
        }
        LinkSegmentID myParent = this.getSegmentIDForParent(segID);
        LinkSegmentID otherParent = this.getSegmentIDForParent(otherSegID);
        if (myParent.isForStartDrop()) {
            return 3;
        }
        if (myParent.equals(otherParent)) {
            return 3;
        }
        if (segID.isForEndDrop() && otherSegID.isForEndDrop()) {
            return 4;
        }
        if (otherParent.equals(segID)) {
            return 2;
        }
        if (myParent.equals(otherSegID)) {
            return 1;
        }
        if (myParent.isForStartDrop()) {
            return 2;
        }
        if (otherParent.isForStartDrop()) {
            return 1;
        }
        if (otherSegID.isForSegment()) {
            String myPLST = myParent.getLinkSegTag();
            String oLST = otherSegID.getLinkSegTag();
            nextID = myPLST;
            do {
                if (!oLST.equals((curr = (LinkSegment)this.segments_.get(nextID)).getID())) continue;
                return 1;
            } while ((nextID = curr.getParent()) != null);
        }
        if (segID.isForSegment()) {
            String oPLST;
            String myLST = segID.getLinkSegTag();
            nextID = oPLST = otherParent.getLinkSegTag();
            do {
                if (!myLST.equals((curr = (LinkSegment)this.segments_.get(nextID)).getID())) continue;
                return 2;
            } while ((nextID = curr.getParent()) != null);
        }
        return 4;
    }

    public int collectSegmentCandidates(Set linksToMatch, Set labelLinks, LinkSegmentID lsid, Genome genome, HashMap cardinalities, HashSet conforming, HashSet bestFit, HashSet matchDefLinks, int minDiff, LinkBusDrop drop, LinkSegment seg) {
        int myCard;
        Set resLinks = this.resolveLinkagesThroughSegment(lsid, genome);
        int n = myCard = seg != null ? this.getSegmentsToRoot(seg).size() : this.getSegmentsToRoot(drop).size() + 1;
        if (((Object)resLinks).equals(linksToMatch)) {
            conforming.add(lsid);
            cardinalities.put(lsid, new Integer(myCard));
        } else {
            boolean haveAFit = false;
            HashSet union = new HashSet(linksToMatch);
            union.addAll(resLinks);
            if (union.size() == linksToMatch.size()) {
                HashSet diff = new HashSet(linksToMatch);
                diff.removeAll(resLinks);
                int numDiff = diff.size();
                if (numDiff < minDiff) {
                    bestFit.clear();
                    bestFit.add(lsid);
                    minDiff = numDiff;
                    cardinalities.put(lsid, new Integer(myCard));
                    haveAFit = true;
                } else if (numDiff == minDiff) {
                    bestFit.add(lsid);
                    cardinalities.put(lsid, new Integer(myCard));
                    haveAFit = true;
                }
            }
            if (!haveAFit && ((Object)resLinks).equals(labelLinks)) {
                matchDefLinks.add(lsid);
                cardinalities.put(lsid, new Integer(myCard));
            }
        }
        return minDiff;
    }

    public List getPointListForSinglePath() {
        if (this.drops_.size() != 2) {
            throw new IllegalStateException();
        }
        LinkBusDrop targDrop = null;
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            if (nextDrop.getDropType() != 1) continue;
            targDrop = nextDrop;
            break;
        }
        if (targDrop == null) {
            throw new IllegalStateException();
        }
        ArrayList<Point2D> retval = new ArrayList<Point2D>();
        List pathToRoot = this.getSegmentsToRoot(targDrop);
        Iterator sit = pathToRoot.iterator();
        while (sit.hasNext()) {
            LinkSegment segToRoot = (LinkSegment)sit.next();
            if (segToRoot.isDegenerate()) {
                retval.add(segToRoot.getStart());
                continue;
            }
            retval.add(segToRoot.getEnd());
        }
        Collections.reverse(retval);
        return retval;
    }

    public List getSegIDListForSinglePath() {
        if (this.drops_.size() != 2) {
            throw new IllegalStateException();
        }
        LinkBusDrop targDrop = null;
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            if (nextDrop.getDropType() != 1) continue;
            targDrop = nextDrop;
            break;
        }
        if (targDrop == null) {
            throw new IllegalStateException();
        }
        List retval = this.getSegmentIDsToRootForEndDrop(targDrop);
        Collections.reverse(retval);
        return retval;
    }

    public boolean hasSimpleConnectivity(LinkSegmentID segID) {
        if (this.isDirect()) {
            return false;
        }
        if (!segID.isTaggedWithEndpoint()) {
            return false;
        }
        if (segID.isForSegment()) {
            LinkSegment seg = this.getSegment(segID);
            if (!seg.isDegenerate()) {
                if (segID.endEndpointIsTagged()) {
                    return !this.hasMultipleChildren(seg);
                }
                if (segID.startEndpointIsTagged()) {
                    return !this.hasSiblings(seg);
                }
            } else {
                return !this.hasMultipleChildren(seg);
            }
        }
        if (segID.isForStartDrop()) {
            LinkSegment root = this.getRootSegment();
            return !this.hasMultipleChildren(root);
        }
        LinkBusDrop drop = this.getTargetDrop(segID);
        if (drop == null) {
            return false;
        }
        String parentID = drop.getConnectionTag();
        LinkSegment seg = this.getSegment(parentID);
        return !this.hasMultipleChildren(seg);
    }

    public LinkBusDrop treeIsDegenerate() {
        if (this.segments_.size() != 1 || this.drops_.size() != 2) {
            return null;
        }
        LinkSegment seg = (LinkSegment)this.segments_.values().iterator().next();
        if (!seg.isDegenerate()) {
            throw new IllegalStateException();
        }
        Iterator dit = this.getDrops();
        boolean haveStart = false;
        boolean haveEnd = false;
        LinkBusDrop retval = null;
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) {
                haveStart = true;
                continue;
            }
            if (drop.getDropType() != 1) continue;
            haveEnd = true;
            retval = drop;
        }
        if (haveStart && haveEnd) {
            return retval;
        }
        throw new IllegalStateException();
    }

    private LinkSegmentID normalizeSimpleConnectedSegmentID(LinkSegmentID segID) {
        if (segID.isBusNodeConnection()) {
            throw new IllegalArgumentException();
        }
        if (!segID.isTaggedWithEndpoint()) {
            throw new IllegalArgumentException();
        }
        LinkSegment root = this.getRootSegment();
        String rootID = root.getID();
        if (segID.isForSegment()) {
            String linkRef = segID.getLinkSegTag();
            if (segID.startEndpointIsTagged() && !linkRef.equals(rootID)) {
                return segID;
            }
            Iterator sit = this.segments_.values().iterator();
            while (sit.hasNext()) {
                String nextParent;
                LinkSegment nextSeg = (LinkSegment)sit.next();
                if (segID.equals(nextSeg.getID()) || (nextParent = nextSeg.getParent()) == null || !nextParent.equals(linkRef)) continue;
                LinkSegmentID retval = LinkSegmentID.buildIDForSegment(nextSeg.getID());
                retval.tagIDWithEndpoint("S");
                return retval;
            }
            throw new IllegalArgumentException();
        }
        if (segID.isForStartDrop()) {
            LinkBusDrop drop = this.getRootDrop();
            String rootTag = drop.getConnectionTag();
            Iterator sit = this.segments_.values().iterator();
            while (sit.hasNext()) {
                LinkSegment nextSeg = (LinkSegment)sit.next();
                String nextParent = nextSeg.getParent();
                if (nextParent == null || !nextParent.equals(rootTag)) continue;
                LinkSegmentID retval = LinkSegmentID.buildIDForSegment(nextSeg.getID());
                retval.tagIDWithEndpoint("S");
                return retval;
            }
        }
        throw new IllegalArgumentException();
    }

    public String haveLeafCase(LinkSegmentID segID) {
        if (segID.isForEndDrop()) {
            LinkBusDrop drop = this.getDrop(segID);
            return drop.getConnectionTag();
        }
        if (segID.isForSegment() && segID.endEndpointIsTagged()) {
            String linkRef = segID.getLinkSegTag();
            Iterator dit = this.getDrops();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (drop.getDropType() != 1 || !drop.getConnectionTag().equals(linkRef)) continue;
                return linkRef;
            }
        }
        return null;
    }

    public void makeDirect() {
        if (!this.isSingleDropTree()) {
            throw new IllegalArgumentException();
        }
        this.clearOutAllSegments();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            SuggestedDrawStyle sds;
            LinkBusDrop currDrop = (LinkBusDrop)dit.next();
            if (currDrop.getDropType() == 0 && (sds = currDrop.getSpecialDropDrawStyle()) != null) {
                SuggestedDrawStyle sdsM = this.getDrawStyle();
                this.setDrawStyle(sdsM.mergeOverrides(sds));
            }
            currDrop.setConnectionSense(2);
            currDrop.setConnectionTag(null);
            currDrop.setDrawStyleForDrop(null);
        }
    }

    protected void clearOutAllSegments() {
        Iterator kit = this.segments_.keySet().iterator();
        while (kit.hasNext()) {
            String deadID = (String)kit.next();
            this.labels_.removeLabel(deadID);
        }
        this.segments_.clear();
    }

    public void removeCorner(LinkSegmentID segID) {
        if (!this.hasSimpleConnectivity(segID)) {
            throw new IllegalArgumentException();
        }
        LinkBusDrop drop = this.treeIsDegenerate();
        if (drop != null) {
            this.clearOutAllSegments();
            if (this.drops_.size() != 2) {
                throw new IllegalStateException();
            }
            Iterator dit = this.getDrops();
            while (dit.hasNext()) {
                SuggestedDrawStyle sds;
                LinkBusDrop currDrop = (LinkBusDrop)dit.next();
                if (currDrop.getDropType() == 0 && (sds = currDrop.getSpecialDropDrawStyle()) != null) {
                    SuggestedDrawStyle sdsM = this.getDrawStyle();
                    this.setDrawStyle(sdsM.mergeOverrides(sds));
                }
                currDrop.setConnectionSense(2);
                currDrop.setConnectionTag(null);
                currDrop.setDrawStyleForDrop(null);
            }
            return;
        }
        String leafResult = this.haveLeafCase(segID);
        if (leafResult != null) {
            LinkSegment seg = (LinkSegment)this.segments_.get(leafResult);
            String parentID = seg.getParent();
            if (parentID == null) {
                throw new IllegalArgumentException();
            }
            LinkSegment parentSeg = (LinkSegment)this.segments_.get(parentID);
            this.handleLeafCase(seg, parentSeg.isDegenerate());
            return;
        }
        LinkSegment seg = this.getSegment(segID = this.normalizeSimpleConnectedSegmentID(segID));
        String parentID = seg.getParent();
        if (parentID == null) {
            throw new IllegalArgumentException();
        }
        LinkSegment parentSeg = (LinkSegment)this.segments_.get(parentID);
        this.reparentChildrenAndDelete(seg, parentSeg.isDegenerate());
    }

    public boolean dropZeroLengthSeg(LinkSegmentID segID) {
        if (this.hasSimpleConnectivity(segID)) {
            throw new IllegalArgumentException();
        }
        if (segID.isForStartDrop()) {
            return false;
        }
        String leafResult = this.haveLeafCase(segID);
        if (leafResult != null) {
            LinkSegment seg = (LinkSegment)this.segments_.get(leafResult);
            if (this.hasMultipleChildren(seg)) {
                return false;
            }
            String parentID = seg.getParent();
            if (parentID == null) {
                return false;
            }
            LinkSegment parentSeg = (LinkSegment)this.segments_.get(parentID);
            this.handleLeafCase(seg, parentSeg.isDegenerate());
            return true;
        }
        LinkSegment seg = this.getSegment(segID = this.normalizeSimpleConnectedSegmentID(segID));
        String parentID = seg.getParent();
        if (parentID == null) {
            return false;
        }
        LinkSegment parentSeg = (LinkSegment)this.segments_.get(parentID);
        this.reparentChildrenAndDelete(seg, parentSeg.isDegenerate());
        return true;
    }

    public LinkSegment getRootSegment() {
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment test = (LinkSegment)sit.next();
            if (test.getParent() != null) continue;
            return test;
        }
        System.err.println("No root segment " + this.getSourceTag());
        throw new IllegalStateException();
    }

    public void addDrop(LinkBusDrop newDrop) {
        this.drops_.add(newDrop);
    }

    public String[] replaceSegment(LinkSegment oldSeg, LinkSegment newSeg1, LinkSegment newSeg2) {
        String oldID = oldSeg.getID();
        this.labels_.removeLabel(oldID);
        this.segments_.remove(oldID);
        String newId1 = this.labels_.getNextLabel();
        newSeg1.setID(newId1);
        newSeg1.setParent(oldSeg.getParent());
        String newId2 = this.labels_.getNextLabel();
        newSeg2.setID(newId2);
        newSeg2.setParent(newId1);
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            String parent = seg.getParent();
            if (parent == null || !parent.equals(oldID)) continue;
            seg.setParent(newId2);
        }
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (!drop.getConnectionTag().equals(oldID)) continue;
            int sense = drop.getConnectionSense();
            drop.setConnectionTag(sense == 1 ? newId2 : newId1);
        }
        this.segments_.put(newId1, newSeg1);
        this.segments_.put(newId2, newSeg2);
        String[] retval = new String[]{newId1, newId2};
        return retval;
    }

    public void writeXMLSupport(PrintWriter out, Indenter ind) {
        if (this.textPos_ != null) {
            out.print("labelX=\"");
            out.print(this.textPos_.getX());
            out.print("\" labelY=\"");
            out.print(this.textPos_.getY());
            out.print("\" ");
        }
        if (this.textDirTag_ != null) {
            out.print("labelDir=\"");
            out.print(this.textDirTag_);
            out.print("\" ");
        }
        out.print("src=\"");
        out.print(this.srcTag_);
        out.println("\" >");
        ind.up();
        this.drawStyle_.writeXML(out, ind);
        ind.indent();
        out.println("<segments>");
        ind.up();
        Iterator segs = this.segments_.values().iterator();
        while (segs.hasNext()) {
            LinkSegment link = (LinkSegment)segs.next();
            link.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</segments>");
        ind.indent();
        out.println("<drops>");
        ind.up();
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)drops.next();
            drop.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</drops>");
    }

    public Object getRenderer() {
        return this.myRenderer_;
    }

    public void setDrawStyle(SuggestedDrawStyle drawStyle) {
        this.drawStyle_ = drawStyle;
    }

    public SuggestedDrawStyle getDrawStyle() {
        return this.drawStyle_;
    }

    public Object clone() {
        try {
            LinkProperties retval = (LinkProperties)super.clone();
            retval.copySupport(this);
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void setColor(String colorName) {
        this.drawStyle_.setColorName(colorName);
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        if (this.drawStyle_.getColorName().equals(oldID)) {
            this.drawStyle_.setColorName(newID);
            retval = true;
        }
        if (this.replaceCustomColors(oldID, newID)) {
            retval = true;
        }
        return retval;
    }

    public Color getColor() {
        return Database.getDB().getColor(this.drawStyle_.getColorName());
    }

    public String getColorName() {
        return this.drawStyle_.getColorName();
    }

    public Point2D getTextPosition() {
        return this.textPos_;
    }

    public void setTextPosition(Point2D newPos) {
        this.textPos_ = newPos == null ? null : (Point2D)newPos.clone();
    }

    public int getTextDirection() {
        return this.textDir_;
    }

    public void setTextDirection(int dir) {
        this.textDir_ = dir;
        switch (this.textDir_) {
            case 1: {
                this.textDirTag_ = "";
                break;
            }
            case 2: {
                this.textDirTag_ = RIGHT_STR_;
                break;
            }
            case 3: {
                this.textDirTag_ = UP_STR_;
                break;
            }
            case 4: {
                this.textDirTag_ = DOWN_STR_;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean haveTargetDrop(String linkID) {
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            String tref = bd.getTargetRef();
            if (tref == null || !tref.equals(linkID)) continue;
            return true;
        }
        return false;
    }

    public LinkSegment getSegment(String id) {
        return (LinkSegment)this.segments_.get(id);
    }

    public int getSegmentCount() {
        return this.segments_.size();
    }

    public boolean isCornerPoint(Point2D point) {
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            if (seg.getStart().equals(point)) {
                return true;
            }
            if (seg.getEnd() == null || !seg.getEnd().equals(point)) continue;
            return true;
        }
        return false;
    }

    public Set getNonOrthoSegments(Genome genome, Layout lo, FontRenderContext frc) {
        HashSet<LinkSegmentID> retval = new HashSet<LinkSegmentID>();
        if (this.isDirect()) {
            LinkSegment directSeg = this.getDirectLinkPath(genome, lo, frc);
            Point2D startPt = directSeg.getStart();
            Point2D endPt = directSeg.getEnd();
            if (startPt.getX() != endPt.getX() && startPt.getY() != endPt.getY()) {
                retval.add(LinkSegmentID.buildIDForDirect(this.getSingleLinkage()));
            }
            return retval;
        }
        if (this.srcDropIsNonOrtho(genome, lo, frc)) {
            retval.add(LinkSegmentID.buildIDForStartDrop());
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() == 0 || !this.targetDropIsNonOrtho(bd, genome, lo, frc)) continue;
            retval.add(LinkSegmentID.buildIDForEndDrop(bd.getTargetRef()));
        }
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            if (seg.isOrthogonal()) continue;
            retval.add(LinkSegmentID.buildIDForSegment(seg.getID()));
        }
        return retval;
    }

    public String getSingleLinkage() {
        if (this.drops_.size() != 2) {
            throw new IllegalStateException();
        }
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)drops.next();
            if (drop.getDropType() == 0) continue;
            return drop.getTargetRef();
        }
        throw new IllegalStateException();
    }

    public String getSourceTag() {
        return this.srcTag_;
    }

    public String getReferenceTag() {
        return this.srcTag_;
    }

    public LinkSegmentID getSegmentIDForParent(LinkSegmentID segID) {
        if (segID.isDirect()) {
            return null;
        }
        if (segID.isForStartDrop()) {
            return null;
        }
        if (segID.isForEndDrop()) {
            LinkBusDrop bd = this.getTargetDrop(segID);
            String lsId = bd.getConnectionTag();
            LinkSegment dropParent = this.getSegment(lsId);
            String dropParentID = dropParent.getID();
            int sense = bd.getConnectionSense();
            if (sense == 0) {
                String metaParent = dropParent.getParent();
                if (metaParent != null) {
                    dropParentID = metaParent;
                } else {
                    return LinkSegmentID.buildIDForStartDrop();
                }
            }
            return LinkSegmentID.buildIDForSegment(dropParentID);
        }
        LinkSegment thisSeg = this.getSegment(segID);
        String linkSegParent = thisSeg.getParent();
        if (thisSeg.isDegenerate() || linkSegParent == null) {
            return LinkSegmentID.buildIDForStartDrop();
        }
        return LinkSegmentID.buildIDForSegment(linkSegParent);
    }

    public List getAllBusLinkSegments(Genome genome, OverlayStateOracle oso, Layout layout, boolean includeRoot, FontRenderContext frc) {
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        if (this.isDirect()) {
            String targRef = this.getTargetDrop().getTargetRef();
            if (!this.linkIsInModel(genome, oso, targRef)) {
                return retval;
            }
            retval.add(LinkSegmentID.buildIDForType(targRef, 2));
            return retval;
        }
        HashSet set = new HashSet();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            if (dropRef != null && !this.linkIsInModel(genome, oso, dropRef)) continue;
            int dropType = dropRef == null ? 0 : 1;
            retval.add(LinkSegmentID.buildIDForType(dropRef, dropType));
            set.addAll(this.getSegmentsToRoot(drop));
        }
        Iterator sit = set.iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            if (seg.isDegenerate() && !includeRoot) continue;
            String segID = seg.getID();
            retval.add(LinkSegmentID.buildIDForType(segID, 3));
        }
        return retval;
    }

    public List getBusLinkSegmentsForOneLink(Genome genome, OverlayStateOracle oso, String linkID) {
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        if (this.isDirect()) {
            String targRef = this.getTargetDrop().getTargetRef();
            if (!targRef.equals(linkID)) {
                return retval;
            }
            if (!this.linkIsInModel(genome, oso, targRef)) {
                return retval;
            }
            retval.add(LinkSegmentID.buildIDForType(targRef, 2));
            return retval;
        }
        HashSet set = new HashSet();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            if (dropRef != null && !dropRef.equals(linkID) || dropRef != null && !this.linkIsInModel(genome, oso, dropRef)) continue;
            int dropType = dropRef == null ? 0 : 1;
            retval.add(LinkSegmentID.buildIDForType(dropRef, dropType));
            set.addAll(this.getSegmentsToRoot(drop));
        }
        Iterator sit = set.iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            String segID = seg.getID();
            retval.add(LinkSegmentID.buildIDForType(segID, 3));
        }
        return retval;
    }

    public SuggestedDrawStyle getDrawStyleForID(LinkSegmentID segID) {
        if (segID.isDirect()) {
            if (!this.isDirect()) {
                throw new IllegalArgumentException();
            }
            LinkBusDrop targDrop = this.getTargetDrop();
            return targDrop.getSpecialDropDrawStyle();
        }
        if (segID.isForStartDrop()) {
            LinkBusDrop drop = this.getRootDrop();
            return drop.getSpecialDropDrawStyle();
        }
        if (segID.isForEndDrop()) {
            LinkBusDrop drop = this.getTargetDrop(segID);
            return drop.getSpecialDropDrawStyle();
        }
        LinkSegment seg = this.getSegment(segID);
        return seg.getSpecialDrawStyle();
    }

    public void setDrawStyleForID(LinkSegmentID segID, SuggestedDrawStyle sds) {
        if (segID.isDirect()) {
            if (!this.isDirect()) {
                throw new IllegalArgumentException();
            }
            LinkBusDrop targDrop = this.getTargetDrop();
            targDrop.setDrawStyleForDrop(sds);
        } else if (segID.isForStartDrop()) {
            LinkBusDrop drop = this.getRootDrop();
            drop.setDrawStyleForDrop(sds);
        } else if (segID.isForEndDrop()) {
            LinkBusDrop drop = this.getTargetDrop(segID);
            drop.setDrawStyleForDrop(sds);
        } else {
            LinkSegment seg = this.getSegment(segID);
            seg.setDrawStyle(sds);
        }
    }

    public LinkBusDrop getRootDrop() {
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() != 0) continue;
            return bd;
        }
        throw new IllegalStateException();
    }

    public Iterator getSegments() {
        return this.segments_.values().iterator();
    }

    public Map buildSegmentToLinksMap() {
        HashMap<LinkPlacementGrid.PointPair, ArrayList<String>> retval = new HashMap<LinkPlacementGrid.PointPair, ArrayList<String>>();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String tref = drop.getTargetRef();
            if (tref == null) continue;
            Iterator sit = this.getSegments();
            while (sit.hasNext()) {
                Point2D end;
                LinkSegment seg = (LinkSegment)sit.next();
                if (!this.isSegmentAnAncestor(seg.getID(), drop)) continue;
                Point2D start = seg.getStart();
                LinkPlacementGrid.PointPair pair = new LinkPlacementGrid.PointPair(start, end = seg.getEnd());
                ArrayList<String> links = (ArrayList<String>)retval.get(pair);
                if (links == null) {
                    links = new ArrayList<String>();
                    retval.put(pair, links);
                }
                links.add(tref);
            }
        }
        return retval;
    }

    public boolean isSegmentAnAncestor(String segTag, LinkBusDrop drop) {
        LinkSegment curr;
        if (drop.getDropType() == 0) {
            return false;
        }
        String nextID = drop.getConnectionTag();
        do {
            if (!segTag.equals((curr = (LinkSegment)this.segments_.get(nextID)).getID())) continue;
            return true;
        } while ((nextID = curr.getParent()) != null);
        return false;
    }

    public void mergeSingleToTreeAtSegment(LinkProperties slp, Genome genome, Layout lo, FontRenderContext frc, LinkSegmentID sid) {
        if (!slp.isSingleDropTree()) {
            throw new IllegalArgumentException();
        }
        if (this.isDirect()) {
            if (sid != null) {
                throw new IllegalArgumentException();
            }
            this.splitNoSegmentBus(genome, lo, frc);
        }
        if (sid == null) {
            sid = LinkSegmentID.buildIDForStartDrop();
            sid.tagIDWithEndpoint("E");
        }
        this.sourceSanityCheck(genome, slp);
        SegResolve segr = this.segmentResolution(sid);
        LinkBusDrop targDrop = slp.getTargetDrop();
        if (slp.isDirect() || slp.getSegmentCount() == 1) {
            LinkBusDrop drop = this.generateBusDrop(targDrop, segr.seg.getID(), 1, segr.connectEnd);
            drop.transferSpecialStyles(targDrop);
            this.addDrop(drop);
            return;
        }
        LinkBusDrop singleTarg = slp.getTargetDrop();
        List segsToRoot = slp.getSegmentsToRoot(singleTarg);
        int strNum = segsToRoot.size();
        segsToRoot.remove(strNum-- - 1);
        Collections.reverse(segsToRoot);
        String currParent = segr.seg.getID();
        String newId = null;
        for (int i = 0; i < strNum; ++i) {
            LinkSegment lseg = (LinkSegment)segsToRoot.get(i);
            LinkSegment newLseg = new LinkSegment(lseg);
            newId = this.labels_.getNextLabel();
            newLseg.setID(newId);
            newLseg.setParent(currParent);
            if (i == 0) {
                newLseg.setStart((Point2D)segr.ourConnectPos.clone());
            }
            this.segments_.put(newId, newLseg);
            currParent = newId;
        }
        LinkBusDrop drop = this.generateBusDrop(targDrop, newId, 1, 1);
        drop.transferSpecialStyles(targDrop);
        this.addDrop(drop);
    }

    public ClosestAnswer findClosestSegment(Point2D pt, List omit) {
        ClosestAnswer retval = new ClosestAnswer();
        Iterator sit = this.segments_.keySet().iterator();
        retval.distance = Double.POSITIVE_INFINITY;
        while (sit.hasNext()) {
            Vector2D ortho;
            double offset;
            Point2D closest;
            String nextKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(nextKey);
            if (omit.contains(seg.getID()) || (closest = seg.getClosestPoint(pt)) == null || !((offset = (ortho = new Vector2D(closest, pt)).length()) < retval.distance)) continue;
            retval.distance = offset;
            retval.segID = seg.getID();
            retval.point = closest;
        }
        return retval.point == null ? null : retval;
    }

    public Map copySegments() {
        HashMap<String, LinkSegment> retval = new HashMap<String, LinkSegment>();
        Iterator sit = this.segments_.keySet().iterator();
        while (sit.hasNext()) {
            String nextKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(nextKey);
            retval.put(nextKey, new LinkSegment(seg));
        }
        return retval;
    }

    public void restoreSegments(Map oldSegments, SegmentWithKids rootSK) {
        this.clearOutAllSegments();
        Iterator sit = oldSegments.keySet().iterator();
        while (sit.hasNext()) {
            String nextKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)oldSegments.get(nextKey);
            Point2D segEnd = seg.getEnd();
            SegmentWithKids swk = rootSK.getSwkChild(nextKey);
            LinkSegment restore = swk.segment;
            restore.setBoth((Point2D)seg.getStart().clone(), segEnd == null ? null : (Point2D)segEnd.clone());
            restore.setParent(seg.getParent());
            this.segments_.put(nextKey, restore);
            if (this.labels_.addExistingLabel(nextKey)) continue;
            throw new IllegalStateException();
        }
    }

    public void splitADrop(LinkBusDrop drop, Point2D endpt) {
        if (drop.getDropType() == 0) {
            this.reparentTree(endpt);
            return;
        }
        String newId = this.labels_.getNextLabel();
        String segID = drop.getConnectionTag();
        LinkSegment seg = (LinkSegment)this.segments_.get(segID);
        int sense = drop.getConnectionSense();
        Point2D strt = sense == 1 ? seg.getEnd() : seg.getStart();
        strt = (Point2D)strt.clone();
        endpt = (Point2D)endpt.clone();
        LinkSegment newSeg = new LinkSegment(newId, segID, strt, endpt);
        SuggestedDrawStyle sds = drop.getSpecialDropDrawStyle();
        if (sds != null) {
            newSeg.setDrawStyle((SuggestedDrawStyle)sds.clone());
        }
        this.segments_.put(newId, newSeg);
        drop.setConnectionTag(newId);
        drop.setConnectionSense(1);
    }

    public void reparentTree(Point2D splitPt) {
        LinkSegment oldRootSeg = this.getRootSegment();
        String oldRootId = oldRootSeg.getID();
        String newId = this.labels_.getNextLabel();
        LinkSegment newRootSeg = new LinkSegment(newId, null, splitPt, null);
        this.segments_.put(newId, newRootSeg);
        Point2D end = oldRootSeg.getStart();
        oldRootSeg.setStart(splitPt);
        oldRootSeg.setEnd(end);
        oldRootSeg.setParent(newId);
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) {
                drop.setConnectionTag(newId);
                continue;
            }
            String segID = drop.getConnectionTag();
            if (!segID.equals(oldRootId) || drop.getConnectionSense() != 0) continue;
            drop.setConnectionSense(1);
        }
    }

    public List generateAllIDs() {
        ArrayList<LinkSegmentID> idList = new ArrayList<LinkSegmentID>();
        if (this.isDirect()) {
            List allLinks = this.getLinkageList();
            String linkRef = (String)allLinks.get(0);
            idList.add(LinkSegmentID.buildIDForDirect(linkRef));
        } else {
            Iterator dit = this.drops_.iterator();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (drop.getDropType() == 0) {
                    idList.add(LinkSegmentID.buildIDForStartDrop());
                    continue;
                }
                String linkRef = drop.getTargetRef();
                idList.add(LinkSegmentID.buildIDForEndDrop(linkRef));
            }
            Iterator sit = this.getSegments();
            while (sit.hasNext()) {
                LinkSegment seg = (LinkSegment)sit.next();
                idList.add(LinkSegmentID.buildIDForSegment(seg.getID()));
            }
        }
        return idList;
    }

    public Map getAllSegmentGeometries(Genome genome, Layout layout, FontRenderContext frc, boolean noDegen) {
        List idList = this.generateAllIDs();
        HashMap<LinkSegmentID, LinkSegment> allGeoms = new HashMap<LinkSegmentID, LinkSegment>();
        Iterator idit = idList.iterator();
        while (idit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)idit.next();
            if (lsid.isForSegment()) {
                LinkSegment seg = this.getSegment(lsid);
                if (noDegen && seg.isDegenerate()) continue;
            }
            LinkSegment fakeSeg = this.getSegmentGeometryForID(lsid, genome, layout, frc, false);
            allGeoms.put(lsid, fakeSeg);
        }
        return allGeoms;
    }

    public double getNonOrthogonalArea(Genome genome, Layout layout, FontRenderContext frc) {
        Map geoms = this.getAllSegmentGeometries(genome, layout, frc, true);
        double retval = 0.0;
        Iterator git = geoms.values().iterator();
        while (git.hasNext()) {
            LinkSegment fakeSeg = (LinkSegment)git.next();
            retval += fakeSeg.getNonOrthogonalArea();
        }
        return retval;
    }

    public static double getNonOrthogonalArea(Map geoms) {
        double retval = 0.0;
        Iterator git = geoms.values().iterator();
        while (git.hasNext()) {
            LinkSegment fakeSeg = (LinkSegment)git.next();
            retval += fakeSeg.getNonOrthogonalArea();
        }
        return retval;
    }

    public LinkSegmentID[] linkSplitSupport(LinkSegmentID segID, Point2D pt) {
        LinkSegmentID[] retval = new LinkSegmentID[2];
        if (segID.isDirect()) {
            LinkSegment newRoot = new LinkSegment((Point2D)pt.clone(), null);
            this.addSegmentInSeries(newRoot);
            retval[0] = LinkSegmentID.buildIDForStartDrop();
            retval[1] = this.getRootSegmentID();
            return retval;
        }
        if (segID.isForDrop()) {
            LinkBusDrop drop = this.getDrop(segID);
            this.splitADrop(drop, pt);
            String dropRef = drop.getTargetRef();
            if (dropRef == null) {
                retval[0] = LinkSegmentID.buildIDForStartDrop();
                retval[1] = this.getRootSegmentID();
            } else {
                retval[1] = LinkSegmentID.buildIDForEndDrop(dropRef);
                drop = this.getDrop(retval[1]);
                retval[0] = LinkSegmentID.buildIDForSegment(drop.getConnectionTag());
            }
        } else {
            LinkSegment seg = this.getSegment(segID);
            if (seg == null) {
                System.err.println("SEGMENT NOT FOUND " + segID);
            }
            if (seg.isDegenerate()) {
                return null;
            }
            LinkSegment[] newSegs = seg.split(pt);
            if (newSegs.length == 1) {
                return null;
            }
            String[] newIDs = this.replaceSegment(seg, newSegs[0], newSegs[1]);
            retval[0] = LinkSegmentID.buildIDForSegment(newIDs[0]);
            retval[1] = LinkSegmentID.buildIDForSegment(newIDs[1]);
        }
        return retval;
    }

    public LinkSegmentID getRootSegmentID() {
        return this.isDirect() ? null : LinkSegmentID.buildIDForSegment(this.getRootSegment().getID());
    }

    public void splitNoSegmentBus(Genome genome, Layout lo, FontRenderContext frc) {
        LinkSegment directSeg = this.getDirectLinkPath(genome, lo, frc);
        Vector2D dropRun = new Vector2D(directSeg.getStart(), directSeg.getEnd());
        dropRun.scale(0.5);
        Point2D halfPoint = dropRun.add(directSeg.getStart());
        UiUtil.forceToGrid(halfPoint, 10.0);
        LinkSegment newRoot = new LinkSegment(halfPoint, null);
        this.addSegmentInSeries(newRoot);
    }

    public boolean fixNonOrtho(LinkSegmentID segID, Genome genome, Layout lo, FontRenderContext frc, boolean minCorners, OverlayStateOracle oso, String overID, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LinkSegment noSeg = this.getSegmentGeometryForID(segID, genome, lo, frc, false);
        if (noSeg.isOrthogonal() || noSeg.isDegenerate()) {
            return false;
        }
        LinkRouter router = new LinkRouter();
        LinkPlacementGrid initialGrid = this.initGridForOrthoFix(router, genome, lo, frc, oso, overID, monitor);
        TreeMap<TreeStrategy.PlanRanking, ArrayList<TreeStrategy.StratAndVar>> rankOptions = new TreeMap<TreeStrategy.PlanRanking, ArrayList<TreeStrategy.StratAndVar>>();
        double startRank = this.getNonOrthogonalArea(genome, lo, frc);
        FixOrthoOptions.FixOrthoTreeInfo foti = this.generateTreeInfo(genome, lo, frc, oso);
        FixOrthoOptions fixOps = new FixOrthoOptions(segID, foti);
        Iterator foit = fixOps.getStrategies();
        int count = 0;
        block0: while (foit.hasNext()) {
            TreeStrategy tstr = (TreeStrategy)foit.next();
            int varNum = tstr.generatePlans(genome, lo, frc, this, foti);
            for (int i = 0; i < varNum; ++i) {
                if (!tstr.canApply(i, initialGrid, genome, lo, frc, this, foti, overID)) continue;
                TreeStrategy.PlanRanking rankObj = tstr.getRanking(i, minCorners, this, genome, lo, frc, foti);
                if (rankObj.distRank == 0.0 || rankObj.nonOrthoArea > startRank) continue;
                ArrayList<TreeStrategy.StratAndVar> forRank = (ArrayList<TreeStrategy.StratAndVar>)rankOptions.get(rankObj);
                if (forRank == null) {
                    forRank = new ArrayList<TreeStrategy.StratAndVar>();
                    rankOptions.put(rankObj, forRank);
                }
                forRank.add(new TreeStrategy.StratAndVar(tstr, i));
                if (varNum > 1) continue block0;
                if (monitor != null && !monitor.keepGoing()) {
                    throw new AsynchExitRequestException();
                }
                ++count;
            }
        }
        if (rankOptions.isEmpty()) {
            return false;
        }
        TreeStrategy.PlanRanking bestRank = (TreeStrategy.PlanRanking)rankOptions.firstKey();
        ArrayList bestGuys = (ArrayList)rankOptions.get(bestRank);
        TreeStrategy.StratAndVar bestOfBest = (TreeStrategy.StratAndVar)bestGuys.get(0);
        bestOfBest.strat.applyPlan(bestOfBest.varNum, this, foti);
        return true;
    }

    public static int mergeRepairStates(int oldState, int newState) {
        switch (oldState) {
            case 0: {
                switch (newState) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                switch (newState) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 2;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 2: {
                switch (newState) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 2;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                switch (newState) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public int repairLinkTree(Genome genome, Layout lo, FontRenderContext frc, BTProgressMonitor monitor, double minFrac, double maxFrac) throws AsynchExitRequestException {
        boolean found = false;
        double inc = (maxFrac - minFrac) / (double)REPAIR_CAP_;
        double currFrac = minFrac;
        for (int j = 0; j < REPAIR_CAP_; ++j) {
            boolean keepGoing;
            List repReq = this.findOverlapErrors(genome, lo, frc);
            int numRR = repReq.size();
            if (numRR == 0) {
                return j == 0 ? 0 : 1;
            }
            for (int i = 0; i < numRR; ++i) {
                RepairRequest rr = (RepairRequest)repReq.get(i);
                if (rr.isUseless) {
                    LinkSegmentID rmCor = (LinkSegmentID)rr.myID.clone();
                    rmCor.tagIDWithEndpoint("E");
                    if (this.hasSimpleConnectivity(rmCor)) {
                        this.removeCorner(rmCor);
                    } else if (!this.dropZeroLengthSeg(rmCor)) {
                        return 3;
                    }
                    found = true;
                    break;
                }
                if (!this.repairOverlapErrors(genome, lo, frc, rr)) continue;
                found = true;
                break;
            }
            if (monitor != null && !(keepGoing = monitor.updateProgress((int)((currFrac += inc) * 100.0)))) {
                throw new AsynchExitRequestException();
            }
            if (j != PENULTIMATE_REPAIR_) continue;
            System.err.println("Repair is not converging");
        }
        return found ? 2 : 3;
    }

    private List findOverlapErrors(Genome genome, Layout lo, FontRenderContext frc) {
        ArrayList<RepairRequest> retval = new ArrayList<RepairRequest>();
        if (this.isDirect()) {
            return retval;
        }
        HashMap<LinkSegmentID, LinkSegment> geom = new HashMap<LinkSegmentID, LinkSegment>();
        HashMap<LinkSegmentID, LinkSegmentID> parents = new HashMap<LinkSegmentID, LinkSegmentID>();
        HashMap<LinkSegmentID, HashSet<LinkSegmentID>> kids = new HashMap<LinkSegmentID, HashSet<LinkSegmentID>>();
        LinkSegmentID rootID = LinkSegmentID.buildIDForType(null, 0);
        LinkSegment rootSeg = this.getSegmentGeometryForID(rootID, genome, lo, frc, false);
        if (rootSeg.getLength() == 0.0) {
            RepairRequest request = new RepairRequest(rootID);
            retval.add(request);
            return retval;
        }
        geom.put(rootID, rootSeg);
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkSegment parSeg;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String tRef = drop.getTargetRef();
            if (tRef == null) continue;
            LinkSegmentID dropID = LinkSegmentID.buildIDForType(tRef, 1);
            LinkSegment seg = this.getSegmentGeometryForID(dropID, genome, lo, frc, false);
            if (seg.getLength() == 0.0) {
                RepairRequest request = new RepairRequest(dropID);
                retval.add(request);
                return retval;
            }
            geom.put(dropID, seg);
            String ctag = drop.getConnectionTag();
            LinkSegmentID parSegID = drop.getConnectionSense() == 0 ? ((parSeg = this.getSegment(ctag)).isDegenerate() ? rootID : LinkSegmentID.buildIDForType(parSeg.getParent(), 3)) : LinkSegmentID.buildIDForType(ctag, 3);
            parents.put(dropID, parSegID);
            HashSet<LinkSegmentID> kidSet = (HashSet<LinkSegmentID>)kids.get(parSegID);
            if (kidSet == null) {
                kidSet = new HashSet<LinkSegmentID>();
                kids.put(parSegID, kidSet);
            }
            kidSet.add(dropID);
        }
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            if (seg.isDegenerate()) continue;
            LinkSegmentID segID = LinkSegmentID.buildIDForType(seg.getID(), 3);
            if (seg.getLength() == 0.0) {
                RepairRequest request = new RepairRequest(segID);
                retval.add(request);
                return retval;
            }
            geom.put(segID, seg);
            LinkSegment parSeg = this.getSegment(seg.getParent());
            LinkSegmentID parSegID = parSeg.isDegenerate() ? rootID : LinkSegmentID.buildIDForType(parSeg.getID(), 3);
            parents.put(segID, parSegID);
            HashSet<LinkSegmentID> kidSet = (HashSet<LinkSegmentID>)kids.get(parSegID);
            if (kidSet == null) {
                kidSet = new HashSet<LinkSegmentID>();
                kids.put(parSegID, kidSet);
            }
            kidSet.add(segID);
        }
        Set allSegs = geom.keySet();
        Iterator asito = allSegs.iterator();
        while (asito.hasNext()) {
            LinkSegmentID lsido = (LinkSegmentID)asito.next();
            LinkSegment outerGeom = (LinkSegment)geom.get(lsido);
            LinkSegmentID outerParent = (LinkSegmentID)parents.get(lsido);
            Set outerKids = (Set)kids.get(lsido);
            Iterator asiti = allSegs.iterator();
            while (asiti.hasNext()) {
                LinkSegment.OverlapResult ovr;
                LinkSegmentID lsidi = (LinkSegmentID)asiti.next();
                if (lsidi.equals(lsido)) continue;
                LinkSegment innerGeom = (LinkSegment)geom.get(lsidi);
                LinkSegmentID innerParent = (LinkSegmentID)parents.get(lsidi);
                Set innerKids = (Set)kids.get(lsidi);
                int sharedOK = 0;
                if (outerParent != null && outerParent.equals(innerParent)) {
                    sharedOK = 1;
                } else if (outerKids != null && outerKids.contains(lsidi)) {
                    sharedOK = 3;
                } else if (innerKids != null && innerKids.contains(lsido)) {
                    sharedOK = 2;
                }
                if ((ovr = outerGeom.overlaps(innerGeom, sharedOK)) == null) continue;
                RepairRequest request = new RepairRequest(lsido, lsidi, ovr);
                retval.add(request);
            }
        }
        return retval;
    }

    public LinkSegmentID getDeepestNonOrtho(Genome genome, Layout lo, FontRenderContext frc, Set skipIDs) {
        Set nonOrtho = this.getNonOrthoSegments(genome, lo, frc);
        if (nonOrtho.isEmpty()) {
            return null;
        }
        if (this.isDirect()) {
            LinkSegmentID dirID = LinkSegmentID.buildIDForDirect(this.getALinkID(genome));
            return skipIDs.contains(dirID) ? null : dirID;
        }
        TreeMap depths = new TreeMap(Collections.reverseOrder());
        Iterator noit = nonOrtho.iterator();
        while (noit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)noit.next();
            if (skipIDs.contains(lsid)) continue;
            int myDist = this.getSegmentDepth(lsid);
            Integer mdVal = new Integer(myDist);
            TreeSet<LinkSegmentID> perD = (TreeSet<LinkSegmentID>)depths.get(mdVal);
            if (perD == null) {
                perD = new TreeSet<LinkSegmentID>();
                depths.put(mdVal, perD);
            }
            perD.add(lsid);
        }
        if (depths.isEmpty()) {
            return null;
        }
        TreeSet deep = (TreeSet)depths.get(depths.firstKey());
        return (LinkSegmentID)deep.first();
    }

    public int getSegmentDepth(LinkSegmentID myID) {
        return myID.isForDrop() ? this.getSegmentsToRoot(this.getDrop(myID)).size() : this.getSegmentsToRoot(this.getSegment(myID)).size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CornerDoF getCornerDoF(LinkSegmentID lsid, Genome genome, Layout lo, FontRenderContext frc, boolean doDrops) {
        LinkSegment useSeg;
        LinkSegment startGeom = null;
        LinkSegment matchSeg = null;
        if (!lsid.isForSegment()) {
            if (!lsid.isForStartDrop()) return null;
            startGeom = this.getSegmentGeometryForID(lsid, genome, lo, frc, false);
        } else {
            matchSeg = this.getSegment(lsid);
        }
        LinkSegment linkSegment = useSeg = startGeom == null ? matchSeg : startGeom;
        if (useSeg.getLength() == 0.0) {
            return null;
        }
        CornerDoF retval = new CornerDoF(lsid);
        retval.runVector = useSeg.getRun();
        retval.inboundIsCanonical = retval.runVector.isCanonical();
        if (!retval.inboundIsCanonical) {
            retval.runVector = retval.runVector.canonical().normalized();
        }
        retval.backupVector = retval.runVector.scaled(-1.0);
        retval.normVector = retval.runVector.normal();
        retval.antiNormVector = retval.normVector.scaled(-1.0);
        if (retval.inboundIsCanonical) {
            if (matchSeg == null) {
                retval.backupPoint = null;
                retval.backDrop = true;
            } else {
                String parent = matchSeg.getParent();
                if (parent == null) {
                    retval.backupPoint = null;
                } else {
                    retval.backupPoint = LinkSegmentID.buildIDForSegment(parent);
                    LinkSegment backSeg = this.getSegment(retval.backupPoint);
                    Point2D backGeom = backSeg.getStart();
                    Vector2D inboundVec = new Vector2D(backGeom, useSeg.getStart()).normalized();
                    retval.backupPointIsInBackupDir = inboundVec.equals(retval.runVector);
                }
            }
        }
        String matchID = startGeom == null ? matchSeg.getID() : this.getRootSegment().getID();
        ArrayList<LinkSegment> kidSegs = new ArrayList<LinkSegment>();
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            String parent = ls.getParent();
            if (parent == null || !parent.equals(matchID)) continue;
            if (ls.getLength() == 0.0) {
                return null;
            }
            kidSegs.add(ls);
        }
        ArrayList<LinkSegment> kidDrops = new ArrayList<LinkSegment>();
        if (doDrops) {
            Iterator bdit = this.getDrops();
            while (bdit.hasNext()) {
                LinkBusDrop bd = (LinkBusDrop)bdit.next();
                if (bd.getDropType() == 0) continue;
                LinkSegment bdseg = this.getTargetDropSegment(bd, genome, lo, frc);
                String lsId = bd.getConnectionTag();
                LinkSegment dropParent = this.getSegment(lsId);
                String dropParentID = dropParent.getID();
                int sense = bd.getConnectionSense();
                if (sense == 0 && (dropParentID = dropParent.getParent()) == null) {
                    dropParentID = this.getRootSegment().getID();
                }
                if (!matchID.equals(dropParentID)) continue;
                if (bdseg.getLength() == 0.0) {
                    return null;
                }
                kidDrops.add(bdseg);
            }
        }
        double normMin = Double.POSITIVE_INFINITY;
        double antiNormMin = Double.POSITIVE_INFINITY;
        double runMin = Double.POSITIVE_INFINITY;
        double backupMin = Double.POSITIVE_INFINITY;
        Iterator ksit = kidSegs.iterator();
        while (ksit.hasNext()) {
            double length;
            LinkSegment ls = (LinkSegment)ksit.next();
            Vector2D kidRun = ls.getRun();
            if (kidRun.equals(retval.backupVector)) {
                if (retval.inboundIsCanonical || !((length = ls.getLength()) < backupMin)) continue;
                backupMin = length;
                retval.backupPoint = LinkSegmentID.buildIDForSegment(ls.getID());
                continue;
            }
            if (kidRun.equals(retval.runVector)) {
                length = ls.getLength();
                if (!(length < runMin)) continue;
                runMin = length;
                retval.runPoint = LinkSegmentID.buildIDForSegment(ls.getID());
                continue;
            }
            if (kidRun.equals(retval.normVector)) {
                length = ls.getLength();
                if (!(length < normMin)) continue;
                normMin = length;
                retval.normPoint = LinkSegmentID.buildIDForSegment(ls.getID());
                continue;
            }
            if (!kidRun.equals(retval.antiNormVector) || !((length = ls.getLength()) < antiNormMin)) continue;
            antiNormMin = length;
            retval.antiNormPoint = LinkSegmentID.buildIDForSegment(ls.getID());
        }
        if (!doDrops) return (CornerDoF)retval.clone();
        Iterator kdit = kidDrops.iterator();
        while (kdit.hasNext()) {
            LinkSegment ls = (LinkSegment)kdit.next();
            Vector2D kidRun = ls.getRun();
            if (kidRun.equals(retval.runVector)) {
                retval.runDrop = true;
            }
            if (kidRun.equals(retval.normVector)) {
                retval.normDrop = true;
            }
            if (!kidRun.equals(retval.antiNormVector)) continue;
            retval.antiDrop = true;
        }
        return (CornerDoF)retval.clone();
    }

    private boolean repairOverlapErrors(Genome genome, Layout lo, FontRenderContext frc, RepairRequest request) {
        LinkSegment.OverlapResult ovrRes = request.ovrRes;
        LinkSegment mySeg = this.getSegmentGeometryForID(request.myID, genome, lo, frc, false);
        LinkSegment otherSeg = this.getSegmentGeometryForID(request.otherID, genome, lo, frc, false);
        int myDist = this.getSegmentDepth(request.myID);
        int otherDist = this.getSegmentDepth(request.otherID);
        if ((request.relation == 3 || request.relation == 2 || request.relation == 4) && ovrRes.myOverlapByStart != null) {
            LinkSegmentID attachID;
            boolean needMeSplit;
            Point2D splitPoint = otherSeg.getStart();
            boolean intersectsMyStart = splitPoint.equals(mySeg.getStart());
            boolean intersectsMyEnd = splitPoint.equals(mySeg.getEnd());
            if (intersectsMyStart) {
                return false;
            }
            if (request.relation == 4 && myDist > otherDist) {
                return false;
            }
            boolean bl = needMeSplit = !intersectsMyEnd;
            if (needMeSplit) {
                LinkSegmentID[] res = this.linkSplitSupport(request.myID, splitPoint);
                attachID = (LinkSegmentID)res[0].clone();
            } else {
                attachID = (LinkSegmentID)request.myID.clone();
            }
            attachID.tagIDWithEndpoint("E");
            LinkSegmentID reattachID = (LinkSegmentID)request.otherID.clone();
            reattachID.tagIDWithEndpoint("S");
            this.moveSegmentOnTree(reattachID, attachID);
            return true;
        }
        if (request.relation == 1 && ovrRes.myOverlapByEnd != null) {
            LinkSegmentID reattachID;
            boolean needMeSplit;
            Point2D splitPoint = otherSeg.getEnd();
            boolean intersectsMyStart = splitPoint.equals(mySeg.getStart());
            boolean intersectsMyEnd = splitPoint.equals(mySeg.getEnd());
            if (intersectsMyEnd) {
                return false;
            }
            boolean bl = needMeSplit = !intersectsMyStart;
            if (needMeSplit) {
                LinkSegmentID[] res = this.linkSplitSupport(request.myID, splitPoint);
                reattachID = (LinkSegmentID)res[0].clone();
            } else {
                reattachID = (LinkSegmentID)request.myID.clone();
            }
            reattachID.tagIDWithEndpoint("S");
            LinkSegmentID attachID = (LinkSegmentID)request.otherID.clone();
            attachID.tagIDWithEndpoint("E");
            this.moveSegmentOnTree(reattachID, attachID);
            return true;
        }
        if (request.relation == 2 && ovrRes.otherOverlapByEnd != null) {
            LinkSegmentID attachID;
            boolean needOtherSplit;
            Point2D splitPoint = mySeg.getEnd();
            boolean intersectsOtherStart = splitPoint.equals(otherSeg.getStart());
            boolean intersectsOtherEnd = splitPoint.equals(otherSeg.getEnd());
            if (intersectsOtherStart) {
                return false;
            }
            boolean bl = needOtherSplit = !intersectsOtherEnd;
            if (needOtherSplit) {
                LinkSegmentID[] res = this.linkSplitSupport(request.otherID, splitPoint);
                attachID = (LinkSegmentID)res[1].clone();
            } else {
                attachID = (LinkSegmentID)request.otherID.clone();
            }
            attachID.tagIDWithEndpoint("S");
            LinkSegmentID reattachID = (LinkSegmentID)request.myID.clone();
            reattachID.tagIDWithEndpoint("E");
            this.moveSegmentOnTree(reattachID, attachID);
            return true;
        }
        if ((request.relation == 3 || request.relation == 1 || request.relation == 4) && ovrRes.otherOverlapByStart != null) {
            LinkSegmentID attachID;
            boolean needOtherSplit;
            Point2D splitPoint = mySeg.getStart();
            boolean intersectsOtherStart = splitPoint.equals(otherSeg.getStart());
            boolean intersectsOtherEnd = splitPoint.equals(otherSeg.getEnd());
            if (intersectsOtherStart) {
                return false;
            }
            if (request.relation == 4 && otherDist > myDist) {
                return false;
            }
            boolean bl = needOtherSplit = !intersectsOtherEnd;
            if (needOtherSplit) {
                LinkSegmentID[] res = this.linkSplitSupport(request.otherID, splitPoint);
                attachID = (LinkSegmentID)res[0].clone();
            } else {
                attachID = (LinkSegmentID)request.otherID.clone();
            }
            attachID.tagIDWithEndpoint("E");
            LinkSegmentID reattachID = (LinkSegmentID)request.myID.clone();
            reattachID.tagIDWithEndpoint("S");
            this.moveSegmentOnTree(reattachID, attachID);
            return true;
        }
        if ((request.relation == 2 || request.relation == 4) && ovrRes.nonEndOverlap != null) {
            if (request.relation == 4 && otherDist > myDist) {
                return false;
            }
            LinkSegmentID[] res = this.linkSplitSupport(request.otherID, ovrRes.nonEndOverlap);
            LinkSegmentID attachID = (LinkSegmentID)res[1].clone();
            LinkSegmentID[] res2 = this.linkSplitSupport(request.myID, ovrRes.nonEndOverlap);
            LinkSegmentID reattachID = (LinkSegmentID)res2[0].clone();
            attachID.tagIDWithEndpoint("S");
            reattachID.tagIDWithEndpoint("E");
            this.moveSegmentOnTree(reattachID, attachID);
            return true;
        }
        return false;
    }

    private FixOrthoOptions.FixOrthoTreeInfo generateTreeInfo(Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso) {
        FixOrthoOptions.FixOrthoTreeInfo retval = new FixOrthoOptions.FixOrthoTreeInfo();
        List allIDs = this.getAllBusLinkSegments(genome, oso, lo, true, frc);
        Iterator aiit = allIDs.iterator();
        while (aiit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)aiit.next();
            retval.allSegIDs.add(lsid);
            CornerDoF cdof = this.getCornerDoF(lsid, genome, lo, frc, true);
            if (cdof != null) {
                retval.cornerDofs.put(lsid, cdof);
            }
            LinkSegment noSeg = this.getSegmentGeometryForID(lsid, genome, lo, frc, false);
            retval.segGeoms.put(lsid, noSeg);
            LinkSegmentID psid = this.getSegmentIDForParent(lsid);
            if (psid != null) {
                retval.parentIDs.put(lsid, psid);
            }
            FixOrthoOptions.ForceDirsAndMatches forceDirs = this.fixNonOrthoForDirs(lsid, noSeg, genome, lo);
            retval.forceDirs.put(lsid, forceDirs);
        }
        retval.prepare(this);
        return retval;
    }

    private FixOrthoOptions.ForceDirsAndMatches fixNonOrthoForDirs(LinkSegmentID segID, LinkSegment noSeg, Genome genome, Layout lo) {
        boolean needTrgDir;
        boolean isDirect = segID.isDirect();
        boolean forStart = segID.isForStartDrop();
        boolean forEnd = segID.isForEndDrop();
        int type = isDirect ? 0 : (forStart ? 1 : (forEnd ? 2 : -1));
        FixOrthoOptions.ForceDirsAndMatches retval = new FixOrthoOptions.ForceDirsAndMatches(type, segID);
        boolean needSrcDir = forStart || isDirect;
        boolean bl = needTrgDir = forEnd || isDirect;
        if (needSrcDir) {
            retval.forceDirs[0] = this.getSourceForcedDir(genome, lo);
            retval.matches[0] = noSeg.getRun().equals(retval.forceDirs[0]);
        }
        if (needTrgDir) {
            retval.forceDirs[1] = this.getTargetForcedDir(genome, lo, segID, isDirect);
            retval.matches[1] = noSeg.getRun().equals(retval.forceDirs[1]);
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SegResolve segmentResolution(LinkSegmentID sid) {
        SegResolve retval = new SegResolve();
        if (sid.isForSegment()) {
            retval.seg = this.getSegment(sid);
            if (sid.startEndpointIsTagged()) {
                retval.connectEnd = 0;
                retval.ourConnectPos = (Point2D)retval.seg.getStart().clone();
                String parentID = retval.seg.getParent();
                if (parentID == null) return retval;
                retval.seg = (LinkSegment)this.segments_.get(parentID);
                if (retval.seg.isDegenerate()) return retval;
                retval.connectEnd = 1;
                retval.ourConnectPos = (Point2D)retval.seg.getEnd().clone();
                return retval;
            }
            if (!sid.endEndpointIsTagged()) {
                System.err.println("BAD SEGID " + sid);
                throw new IllegalArgumentException();
            }
            retval.connectEnd = 1;
            retval.ourConnectPos = retval.seg.isDegenerate() ? (Point2D)retval.seg.getStart().clone() : (Point2D)retval.seg.getEnd().clone();
            return retval;
        }
        if (sid.isForStartDrop()) {
            LinkBusDrop drop = this.getRootDrop();
            retval.seg = this.getSegment(drop.getConnectionTag());
            retval.connectEnd = 0;
            retval.ourConnectPos = (Point2D)retval.seg.getStart().clone();
            return retval;
        }
        if (!sid.isForEndDrop()) {
            System.err.println("BAD SEGID " + sid);
            throw new IllegalArgumentException();
        }
        LinkBusDrop drop = this.getTargetDrop(sid);
        retval.seg = this.getSegment(drop.getConnectionTag());
        retval.ourConnectPos = (Point2D)retval.seg.getStart().clone();
        retval.connectEnd = drop.getConnectionSense();
        if (retval.connectEnd == 0) {
            String parentID = retval.seg.getParent();
            if (parentID == null) return retval;
            retval.seg = (LinkSegment)this.segments_.get(parentID);
            if (retval.seg.isDegenerate()) return retval;
            retval.connectEnd = 1;
            retval.ourConnectPos = (Point2D)retval.seg.getEnd().clone();
            return retval;
        }
        if (retval.connectEnd == 1) {
            retval.ourConnectPos = (Point2D)retval.seg.getEnd().clone();
            return retval;
        }
        System.err.println("BAD SEGID " + sid);
        throw new IllegalArgumentException();
    }

    public void mergeTreeToTreeAtSegment(LinkProperties obp, Genome genome, FontRenderContext frc, LinkSegmentID sid) {
        SegResolve segr = this.segmentResolution(sid);
        if (obp.isDirect()) {
            LinkBusDrop targDrop = obp.getTargetDrop();
            LinkBusDrop drop = this.generateBusDrop(targDrop, segr.seg.getID(), 1, segr.connectEnd);
            drop.transferSpecialStyles(targDrop);
            this.addDrop(drop);
            return;
        }
        HashMap<String, String> segIDMap = new HashMap<String, String>();
        Iterator sit = obp.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            String oldID = seg.getID();
            String newID = this.labels_.getNextLabel();
            segIDMap.put(oldID, newID);
        }
        sit = obp.getSegments();
        String rootTag = null;
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            String oldID = seg.getID();
            String newID = (String)segIDMap.get(oldID);
            seg.setID(newID);
            String oldParent = seg.getParent();
            if (oldParent == null) {
                rootTag = oldID;
                seg.setParent(segr.seg.getID());
                seg.setEnd((Point2D)seg.getStart().clone());
                seg.setStart((Point2D)segr.ourConnectPos.clone());
            } else {
                seg.setParent((String)segIDMap.get(oldParent));
            }
            this.segments_.put(newID, seg);
        }
        Iterator dit = obp.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String oldTag = drop.getConnectionTag();
            drop.setConnectionTag((String)segIDMap.get(oldTag));
            if (oldTag.equals(rootTag) && drop.getConnectionSense() == 0) {
                drop.setConnectionSense(1);
            }
            this.addDrop(drop);
        }
    }

    public void mergeReplacementSubTreesToTreeAtSegment(List glueJobs, Genome genome, FontRenderContext frc) {
        HashSet<String> refLinks = new HashSet<String>();
        int numJobs = glueJobs.size();
        for (int i = 0; i < numJobs; ++i) {
            GlueJob currJob = (GlueJob)glueJobs.get(i);
            LinkProperties obp = currJob.newProps;
            LinkSegmentID sid = currJob.taggedWhip;
            SegResolve segr = this.segmentResolution(sid);
            if (obp.isDirect()) {
                throw new IllegalArgumentException();
            }
            HashMap<String, String> segIDMap = new HashMap<String, String>();
            Iterator sit = obp.getSegments();
            while (sit.hasNext()) {
                LinkSegment seg = (LinkSegment)sit.next();
                String oldID = seg.getID();
                String newID = this.labels_.getNextLabel();
                segIDMap.put(oldID, newID);
            }
            sit = obp.getSegments();
            String rootTag = null;
            while (sit.hasNext()) {
                LinkSegment seg = (LinkSegment)sit.next();
                String oldID = seg.getID();
                String newID = (String)segIDMap.get(oldID);
                seg.setID(newID);
                String oldParent = seg.getParent();
                if (oldParent == null) {
                    rootTag = oldID;
                    seg.setParent(segr.seg.getID());
                    seg.setEnd((Point2D)seg.getStart().clone());
                    seg.setStart((Point2D)segr.ourConnectPos.clone());
                } else {
                    seg.setParent((String)segIDMap.get(oldParent));
                }
                this.segments_.put(newID, seg);
            }
            HashSet<String> replacingLinks = new HashSet<String>();
            Iterator dit = obp.getDrops();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (drop.getDropType() == 0) continue;
                replacingLinks.add(drop.getTargetRef());
            }
            Iterator rlit = replacingLinks.iterator();
            block4: while (rlit.hasNext()) {
                String linkID = (String)rlit.next();
                dit = this.getDrops();
                while (dit.hasNext()) {
                    LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
                    String tRef = nextDrop.getTargetRef();
                    if (tRef == null || !tRef.equals(linkID)) continue;
                    refLinks.add(nextDrop.getConnectionTag());
                    this.drops_.remove(nextDrop);
                    continue block4;
                }
            }
            dit = obp.getDrops();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (drop.getDropType() == 0) continue;
                String oldTag = drop.getConnectionTag();
                drop.setConnectionTag((String)segIDMap.get(oldTag));
                if (oldTag.equals(rootTag) && drop.getConnectionSense() == 0) {
                    drop.setConnectionSense(1);
                }
                this.addDrop(drop);
            }
        }
        Iterator reflit = refLinks.iterator();
        block7: while (reflit.hasNext()) {
            LinkSegment curr;
            String nextID = (String)reflit.next();
            while ((curr = (LinkSegment)this.segments_.get(nextID)) != null) {
                boolean mustKeep = false;
                Iterator dit = this.getDrops();
                while (dit.hasNext()) {
                    LinkBusDrop drop = (LinkBusDrop)dit.next();
                    if (!this.isSegmentAnAncestor(nextID, drop)) continue;
                    mustKeep = true;
                    break;
                }
                if (!mustKeep) {
                    this.labels_.removeLabel(nextID);
                    this.segments_.remove(nextID);
                }
                if ((nextID = curr.getParent()) != null) continue;
                continue block7;
            }
        }
    }

    public boolean moveSegmentOnTree(LinkSegment moveSeg, LinkSegment targSeg, boolean useEnd) {
        return this.moveSegmentOnTreeGuts(moveSeg, false, null, targSeg, false, null, useEnd);
    }

    public boolean moveSegmentOnTree(LinkSegmentID moveSegID, LinkSegmentID targSegID) {
        LinkSegment moveSeg = null;
        LinkSegment targSeg = null;
        boolean isDrop = false;
        String dropID = null;
        boolean targIsDrop = false;
        String targDropID = null;
        if (moveSegID.isForSegment()) {
            moveSeg = this.getSegment(moveSegID);
        } else if (moveSegID.isForStartDrop()) {
            isDrop = true;
            dropID = null;
        } else if (moveSegID.isForEndDrop()) {
            isDrop = true;
            dropID = moveSegID.getEndDropLinkRef();
        } else {
            throw new IllegalArgumentException();
        }
        if (targSegID.isForSegment()) {
            targSeg = this.getSegment(targSegID);
        } else if (targSegID.isForStartDrop()) {
            targIsDrop = true;
            targDropID = null;
        } else if (targSegID.isForEndDrop()) {
            targIsDrop = true;
            targDropID = targSegID.getEndDropLinkRef();
        } else {
            throw new IllegalArgumentException();
        }
        boolean toEnd = targSegID.endEndpointIsTagged();
        return this.moveSegmentOnTreeGuts(moveSeg, isDrop, dropID, targSeg, targIsDrop, targDropID, toEnd);
    }

    public void removeLinkSupport(String linkageID) {
        LinkSegment curr;
        String refLink = null;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            String tRef = nextDrop.getTargetRef();
            if (tRef == null || !tRef.equals(linkageID)) continue;
            refLink = nextDrop.getConnectionTag();
            this.drops_.remove(nextDrop);
            break;
        }
        if (this.isDirect()) {
            return;
        }
        String nextID = refLink;
        do {
            curr = (LinkSegment)this.segments_.get(nextID);
            boolean mustKeep = false;
            dit = this.getDrops();
            while (dit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)dit.next();
                if (!this.isSegmentAnAncestor(nextID, drop)) continue;
                mustKeep = true;
                break;
            }
            if (mustKeep) continue;
            this.labels_.removeLabel(nextID);
            this.segments_.remove(nextID);
        } while ((nextID = curr.getParent()) != null);
    }

    public SegmentWithKids buildSegmentTree(Genome genome, Layout lo, FontRenderContext frc) {
        if (this.isDirect()) {
            return null;
        }
        LinkSegment topSegment = this.getSourceDropSegment(genome, lo, frc, true);
        SegmentWithKids retval = new SegmentWithKids(topSegment);
        HashMap<String, SegmentWithKids> skMap = new HashMap<String, SegmentWithKids>();
        LinkSegment rootSeg = this.getRootSegment();
        SegmentWithKids rootsk = new SegmentWithKids(rootSeg);
        retval.kids.add(rootsk);
        skMap.put(rootSeg.getID(), rootsk);
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            SegmentWithKids parentSK;
            LinkSegment ls = (LinkSegment)sit.next();
            String parent = ls.getParent();
            if (parent == null) continue;
            SegmentWithKids mySk = (SegmentWithKids)skMap.get(ls.getID());
            if (mySk == null) {
                mySk = new SegmentWithKids(ls);
                skMap.put(ls.getID(), mySk);
            }
            if ((parentSK = (SegmentWithKids)skMap.get(parent)) == null) {
                parentSK = new SegmentWithKids(this.getSegment(parent));
                skMap.put(parent, parentSK);
            }
            if (parentSK.kids.contains(mySk)) continue;
            parentSK.kids.add(mySk);
        }
        Iterator bdit = this.getDrops();
        while (bdit.hasNext()) {
            String dropParentID;
            LinkBusDrop bd = (LinkBusDrop)bdit.next();
            if (bd.getDropType() == 0) continue;
            LinkSegment bdseg = this.getTargetDropSegment(bd, genome, lo, frc);
            String lsId = bd.getConnectionTag();
            LinkSegment dropParent = this.getSegment(lsId);
            int sense = bd.getConnectionSense();
            if (sense == 0 && (dropParentID = dropParent.getParent()) != null) {
                dropParent = this.getSegment(dropParentID);
            }
            SegmentWithKids parentSK = (SegmentWithKids)skMap.get(dropParent.getID());
            bdseg.setParent(dropParent.getID());
            parentSK.kids.add(new SegmentWithKids(bdseg));
        }
        return retval;
    }

    public List getChildSegs(LinkSegmentID lsid) {
        ArrayList<LinkSegmentID> retval = new ArrayList<LinkSegmentID>();
        if (lsid.isDirectOrEndDrop()) {
            return retval;
        }
        String matchID = lsid.isForStartDrop() ? this.getRootSegment().getID() : this.getSegment(lsid).getID();
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            String parent = ls.getParent();
            if (parent == null || !parent.equals(matchID)) continue;
            retval.add(LinkSegmentID.buildIDForSegment(ls.getID()));
        }
        Iterator bdit = this.getDrops();
        while (bdit.hasNext()) {
            String metaParent;
            LinkBusDrop bd = (LinkBusDrop)bdit.next();
            if (bd.getDropType() == 0) continue;
            String lsId = bd.getConnectionTag();
            LinkSegment dropParent = this.getSegment(lsId);
            String dropParentID = dropParent.getID();
            int sense = bd.getConnectionSense();
            if (sense == 0 && (metaParent = dropParent.getParent()) != null) {
                dropParentID = metaParent;
            }
            if (!matchID.equals(dropParentID)) continue;
            retval.add(LinkSegmentID.buildIDForEndDrop(bd.getTargetRef()));
        }
        return retval;
    }

    public List getBreadthFirstOrder() {
        ArrayList<String> retval = new ArrayList<String>();
        Map tree = this.invertTree();
        if (tree == null) {
            LinkBusDrop bd = this.getTargetDrop();
            retval.add(bd.getTargetRef());
            return retval;
        }
        ArrayList<LinkSegmentID> searchList = new ArrayList<LinkSegmentID>();
        searchList.add(LinkSegmentID.buildIDForSegment(this.getRootSegment().getID()));
        while (!searchList.isEmpty()) {
            LinkSegmentID nextID = (LinkSegmentID)searchList.remove(0);
            SortedSet kids = (SortedSet)tree.get(nextID);
            Iterator kit = kids.iterator();
            while (kit.hasNext()) {
                LinkSegmentID kidID = (LinkSegmentID)kit.next();
                if (kidID.isForDrop()) {
                    retval.add(kidID.getEndDropLinkRef());
                    continue;
                }
                searchList.add(kidID);
            }
        }
        return retval;
    }

    public String getDepthFirstDebug(Genome genome, Layout lo, FontRenderContext frc) {
        StringBuffer retval = new StringBuffer();
        Map tree = this.invertTree();
        if (tree == null) {
            LinkBusDrop bd = this.getTargetDrop();
            retval.append(bd.getTargetRef());
            return retval.toString();
        }
        ArrayList<LinkSegmentID> searchList = new ArrayList<LinkSegmentID>();
        searchList.add(LinkSegmentID.buildIDForSegment(this.getRootSegment().getID()));
        while (!searchList.isEmpty()) {
            LinkSegmentID nextID = (LinkSegmentID)searchList.remove(0);
            LinkSegment lseg = this.getSegment(nextID);
            int depth = this.getSegmentsToRoot(lseg).size() - 1;
            for (int i = 0; i < depth; ++i) {
                retval.append("   ");
            }
            if (lseg.isDegenerate()) {
                retval.append(lseg.getStart());
            } else {
                retval.append(lseg.getStart() + " - " + lseg.getEnd() + " " + lseg.getRun());
            }
            retval.append("[");
            retval.append(lseg.getID());
            retval.append("]\n");
            SortedSet kids = (SortedSet)tree.get(nextID);
            Iterator kit = kids.iterator();
            while (kit.hasNext()) {
                LinkSegmentID kidID = (LinkSegmentID)kit.next();
                if (kidID.isForDrop()) {
                    for (int i = 0; i <= depth; ++i) {
                        retval.append("   ");
                    }
                    retval.append(kidID.getEndDropLinkRef());
                    retval.append("->");
                    LinkSegment mySeg = this.getSegmentGeometryForID(kidID, genome, lo, frc, false);
                    retval.append(mySeg.getRun());
                    retval.append("\n");
                    continue;
                }
                searchList.add(0, kidID);
            }
        }
        return retval.toString();
    }

    public Map getSegmentToLinkMap(Genome genome) {
        Map invert = this.invertTree();
        if (invert == null) {
            return null;
        }
        HashMap<LinkSegmentID, Set> retval = new HashMap<LinkSegmentID, Set>();
        Iterator segit = invert.keySet().iterator();
        while (segit.hasNext()) {
            LinkSegmentID lsid = (LinkSegmentID)segit.next();
            Set res = this.resolveLinkagesThroughSegment(lsid, genome);
            retval.put(lsid, res);
        }
        return retval;
    }

    public Map invertTree() {
        if (this.isDirect()) {
            return null;
        }
        HashMap<LinkSegmentID, TreeSet<LinkSegmentID>> retval = new HashMap<LinkSegmentID, TreeSet<LinkSegmentID>>();
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            String parent = ls.getParent();
            if (parent == null) continue;
            LinkSegmentID kidID = LinkSegmentID.buildIDForSegment(ls.getID());
            LinkSegmentID parentID = LinkSegmentID.buildIDForSegment(parent);
            TreeSet<LinkSegmentID> kids = (TreeSet<LinkSegmentID>)retval.get(parentID);
            if (kids == null) {
                kids = new TreeSet<LinkSegmentID>();
                retval.put(parentID, kids);
            }
            kids.add(kidID);
        }
        Iterator bdit = this.getDrops();
        while (bdit.hasNext()) {
            String metaParent;
            LinkBusDrop bd = (LinkBusDrop)bdit.next();
            if (bd.getDropType() == 0) continue;
            String lsId = bd.getConnectionTag();
            LinkSegment dropParent = this.getSegment(lsId);
            String dropParentID = dropParent.getID();
            int sense = bd.getConnectionSense();
            if (sense == 0 && (metaParent = dropParent.getParent()) != null) {
                dropParentID = metaParent;
            }
            LinkSegmentID kidID = LinkSegmentID.buildIDForEndDrop(bd.getTargetRef());
            LinkSegmentID parentID = LinkSegmentID.buildIDForSegment(dropParentID);
            TreeSet<LinkSegmentID> kids = (TreeSet<LinkSegmentID>)retval.get(parentID);
            if (kids == null) {
                kids = new TreeSet<LinkSegmentID>();
                retval.put(parentID, kids);
            }
            kids.add(kidID);
        }
        return retval;
    }

    public String toString() {
        return " textPos = " + this.textPos_ + " textDirTag = " + this.textDirTag_ + " srcTag = " + this.srcTag_ + " segments = " + this.segments_ + " drops = " + this.drops_ + " labels = " + this.labels_;
    }

    public boolean emptyLabels() {
        return this.labels_.isEmpty();
    }

    public List copyDrops() {
        ArrayList<Object> retval = new ArrayList<Object>();
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            retval.add(nextDrop.clone());
        }
        return retval;
    }

    public void restoreDrops(List oldDrops) {
        this.drops_.clear();
        Iterator dit = oldDrops.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            this.drops_.add(nextDrop.clone());
        }
    }

    protected abstract LinkPlacementGrid initGridForOrthoFix(LinkRouter var1, Genome var2, Layout var3, FontRenderContext var4, OverlayStateOracle var5, String var6, BTProgressMonitor var7) throws AsynchExitRequestException;

    public abstract LinkProperties deriveDirectLink(String var1, LinkBusDrop var2, Object var3);

    public abstract LinkSegment getDirectLinkPath(Genome var1, Layout var2, FontRenderContext var3);

    protected abstract LinkSegment getSourceDropSegment(Genome var1, Layout var2, FontRenderContext var3, boolean var4);

    protected abstract LinkSegment getTargetDropSegment(LinkBusDrop var1, Genome var2, Layout var3, FontRenderContext var4);

    protected abstract boolean srcDropIsNonOrtho(Genome var1, Layout var2, FontRenderContext var3);

    protected abstract boolean targetDropIsNonOrtho(LinkBusDrop var1, Genome var2, Layout var3, FontRenderContext var4);

    public abstract boolean linkIsInModel(Genome var1, OverlayStateOracle var2, String var3);

    protected abstract void sourceSanityCheck(Genome var1, LinkProperties var2);

    protected abstract String getLinkLabel(Genome var1, String var2);

    public abstract String getLinkTarget(Genome var1, String var2);

    protected abstract LinkBusDrop generateBusDrop(LinkBusDrop var1, String var2, int var3, int var4);

    protected abstract LinkBusDrop generateBusDrop(String var1, String var2, int var3, int var4, Object var5);

    protected abstract ThickInfo maxThickForIntersect(Genome var1, OverlayStateOracle var2, double var3);

    protected abstract void moveSource(Object var1);

    public abstract void writeXML(PrintWriter var1, Indenter var2);

    protected abstract void shiftDropEnds(double var1, double var3, Vector2D var5);

    protected abstract void moveDropEndsPerMap(Map var1, boolean var2);

    protected abstract void shiftSelectedDropEnds(double var1, double var3, LinkFragmentShifts var5);

    protected abstract void shiftDropEndsForExpandCompressOps(SortedSet var1, SortedSet var2, Rectangle var3, double var4, int var6);

    protected abstract Vector2D getSourceForcedDir(Genome var1, Layout var2);

    protected abstract Vector2D getTargetForcedDir(Genome var1, Layout var2, LinkSegmentID var3, boolean var4);

    public abstract boolean canRelocateSegmentOnTree(LinkSegmentID var1);

    public abstract String getALinkID(Genome var1);

    protected void loadFromXML(String color, String ourSource, String lineStyle, String txtX, String txtY, String txtDir) throws IOException {
        if (txtX != null && txtY != null) {
            float tx = 0.0f;
            float ty = 0.0f;
            try {
                tx = Float.parseFloat(txtX);
                ty = Float.parseFloat(txtY);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            this.textPos_ = new Point2D.Float(tx, ty);
        }
        this.textDir_ = 1;
        if (txtDir != null) {
            if ((txtDir = txtDir.trim()).equals("")) {
                this.textDir_ = 1;
            } else if (txtDir.equalsIgnoreCase(LEFT_STR_)) {
                this.textDir_ = 1;
            } else if (txtDir.equalsIgnoreCase(RIGHT_STR_)) {
                this.textDir_ = 2;
            } else if (txtDir.equalsIgnoreCase(UP_STR_)) {
                this.textDir_ = 3;
            } else if (txtDir.equalsIgnoreCase(DOWN_STR_)) {
                this.textDir_ = 4;
            } else {
                throw new IOException();
            }
        }
        this.textDirTag_ = txtDir;
        this.setLegacyStyle(color, lineStyle);
        this.segments_ = new HashMap();
        this.drops_ = new ArrayList();
        this.labels_ = new UniqueLabeller();
        this.srcTag_ = ourSource;
    }

    protected void setLegacyStyle(String color, String lineStyle) {
        if (color != null) {
            if (lineStyle == null) {
                lineStyle = "";
            }
            this.drawStyle_ = SuggestedDrawStyle.buildFromLegacy(LinkProperties.mapFromStyleTag(lineStyle));
            this.drawStyle_.setColorName(color);
        }
    }

    protected List getChildSegments(LinkSegment seg) {
        ArrayList<LinkSegment> retval = new ArrayList<LinkSegment>();
        String segID = seg.getID();
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            String nextParent;
            LinkSegment nextSeg = (LinkSegment)sit.next();
            if (seg == nextSeg || (nextParent = nextSeg.getParent()) == null || !nextParent.equals(segID)) continue;
            retval.add(nextSeg);
        }
        return retval;
    }

    protected List getChildDrops(LinkSegment seg, List childSegs) {
        ArrayList<LinkBusDrop> retval = new ArrayList<LinkBusDrop>();
        String segID = seg.getID();
        int numKids = childSegs.size();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String conTag = drop.getConnectionTag();
            int sense = drop.getConnectionSense();
            if (sense == 1 && conTag.equals(segID)) {
                retval.add(drop);
                continue;
            }
            if (sense != 0) continue;
            for (int i = 0; i < numKids; ++i) {
                LinkSegment kidSeg = (LinkSegment)childSegs.get(i);
                if (!kidSeg.getID().equals(conTag)) continue;
                retval.add(drop);
            }
            if (!seg.isDegenerate() || !conTag.equals(segID)) continue;
            retval.add(drop);
        }
        return retval;
    }

    protected boolean moveSegmentOnTreeGuts(LinkSegment moveSeg, boolean isDrop, String dropID, LinkSegment targSeg, boolean targIsDrop, String targDropID, boolean toEnd) {
        int sense;
        Point2D mergePt;
        if (targIsDrop) {
            if (targDropID == null) {
                targSeg = this.getRootSegment();
                toEnd = false;
            } else {
                Iterator drit = this.getDrops();
                while (drit.hasNext()) {
                    LinkBusDrop drop = (LinkBusDrop)drit.next();
                    String ref = drop.getTargetRef();
                    if (ref == null || !ref.equals(targDropID)) continue;
                    targSeg = this.getSegment(drop.getConnectionTag());
                    toEnd = drop.getConnectionSense() == 1;
                    break;
                }
            }
        }
        if (!isDrop) {
            List path = this.getSegmentsToRoot(targSeg);
            Iterator pit = path.iterator();
            String msid = moveSeg.getID();
            while (pit.hasNext()) {
                LinkSegment ls = (LinkSegment)pit.next();
                if (!msid.equals(ls.getID())) continue;
                return false;
            }
        }
        if (!toEnd) {
            String parent = targSeg.getParent();
            if (parent != null) {
                targSeg = this.getSegment(parent);
                if (targSeg.isDegenerate()) {
                    mergePt = targSeg.getStart();
                    sense = 0;
                } else {
                    mergePt = targSeg.getEnd();
                    sense = 1;
                }
            } else {
                mergePt = targSeg.getStart();
                sense = 0;
            }
        } else {
            mergePt = targSeg.getEnd();
            sense = 1;
        }
        if (!isDrop) {
            String parentID = targSeg.getID();
            moveSeg.setParent(parentID);
            moveSeg.setStart((Point2D)mergePt.clone());
        } else {
            if (dropID == null) {
                return false;
            }
            Iterator drit = this.getDrops();
            while (drit.hasNext()) {
                LinkBusDrop drop = (LinkBusDrop)drit.next();
                String ref = drop.getTargetRef();
                if (ref == null || !ref.equals(dropID)) continue;
                drop.setConnectionTag(targSeg.getID());
                drop.setConnectionSense(sense);
                break;
            }
        }
        HashSet<String> discardedSegments = new HashSet<String>();
        Iterator lsit = this.getSegments();
        while (lsit.hasNext()) {
            LinkSegment ls = (LinkSegment)lsit.next();
            discardedSegments.add(ls.getID());
        }
        Iterator drit = this.getDrops();
        while (drit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)drit.next();
            List path = this.getSegmentsToRoot(drop);
            Iterator pit = path.iterator();
            while (pit.hasNext()) {
                LinkSegment ls = (LinkSegment)pit.next();
                discardedSegments.remove(ls.getID());
            }
        }
        Iterator dsit = discardedSegments.iterator();
        while (dsit.hasNext()) {
            String lsid = (String)dsit.next();
            this.labels_.removeLabel(lsid);
            this.segments_.remove(lsid);
        }
        return true;
    }

    protected void shiftStraightSegmentRunFromListCore(List straight, Vector2D shift, SegmentWithKids rootSK) {
        ArrayList<String> straightSegs = new ArrayList<String>();
        ArrayList attached = new ArrayList();
        String parentID = null;
        int numStr = straight.size();
        if (numStr == 0) {
            throw new IllegalArgumentException();
        }
        int last = numStr - 1;
        SegmentWithKids swk = (SegmentWithKids)straight.get(0);
        straightSegs.add(swk.segment.getID());
        parentID = swk.getParentID();
        attached.addAll(swk.getSiblingIDs(rootSK));
        for (int i = 0; i < numStr; ++i) {
            List children = swk.getChildrenIDs();
            if (i < last) {
                SegmentWithKids nextSwk = (SegmentWithKids)straight.get(i + 1);
                String nextID = nextSwk.segment.getID();
                straightSegs.add(nextID);
                children.remove(nextID);
                swk = nextSwk;
            }
            attached.addAll(children);
        }
        this.shiftStraightSegmentRun(straightSegs, shift, parentID, attached);
    }

    protected Point2D getFixedDropPoint(LinkSegmentID segID) {
        if (!segID.isForDrop() || segID.isDirect()) {
            throw new IllegalArgumentException();
        }
        LinkBusDrop drop = segID.isForStartDrop() ? this.getRootDrop() : this.getTargetDrop(segID);
        String parent = drop.getConnectionTag();
        LinkSegment parentSeg = this.getSegment(parent);
        int type = drop.getConnectionSense();
        if (type == 1) {
            return (Point2D)parentSeg.getEnd().clone();
        }
        if (type == 0) {
            return (Point2D)parentSeg.getStart().clone();
        }
        throw new IllegalArgumentException();
    }

    protected void moveBusLinkCore(LinkSegmentID segID, Point2D strt, double dx, double dy, HashSet cookies) {
        block16: {
            LinkSegment seg;
            block17: {
                block15: {
                    boolean forDrop = segID.isForDrop();
                    LinkSegment linkSegment = seg = forDrop ? null : this.getSegment(segID.getLinkSegTag());
                    if (!forDrop) break block15;
                    Point2D matching = this.getFixedDropPoint(segID);
                    Iterator sit = this.getSegments();
                    while (sit.hasNext()) {
                        LinkSegment tseg = (LinkSegment)sit.next();
                        Point2D endpt = tseg.getEnd();
                        SegCookie sc = new SegCookie(tseg.getID(), false);
                        if (endpt != null && endpt.equals(matching) && !cookies.contains(sc)) {
                            tseg.shiftEnd(dx, dy);
                            cookies.add(sc);
                        }
                        sc = new SegCookie(tseg.getID(), true);
                        if (!tseg.getStart().equals(matching) || cookies.contains(sc)) continue;
                        tseg.shiftStart(dx, dy);
                        cookies.add(sc);
                    }
                    break block16;
                }
                if (!segID.endEndpointIsTagged() && (strt == null || seg.intersectsEnd(strt, 5.0) == null)) break block17;
                if (!segID.endEndpointIsTagged()) {
                    System.err.println("Unexpected non-tagged endpoint");
                }
                if (seg.isDegenerate()) break block16;
                Point2D matching = (Point2D)seg.getEnd().clone();
                Iterator sit = this.getSegments();
                while (sit.hasNext()) {
                    LinkSegment tseg = (LinkSegment)sit.next();
                    Point2D endpt = tseg.getEnd();
                    SegCookie sc = new SegCookie(tseg.getID(), false);
                    if (endpt != null && endpt.equals(matching) && !cookies.contains(sc)) {
                        tseg.shiftEnd(dx, dy);
                        cookies.add(sc);
                    }
                    sc = new SegCookie(tseg.getID(), true);
                    if (!tseg.getStart().equals(matching) || cookies.contains(sc)) continue;
                    tseg.shiftStart(dx, dy);
                    cookies.add(sc);
                }
                break block16;
            }
            if (segID.startEndpointIsTagged() || strt != null && seg.intersectsStart(strt, 5.0) != null) {
                if (!segID.startEndpointIsTagged()) {
                    System.err.println("Unexpected non-tagged start point");
                }
                Point2D matching = (Point2D)seg.getStart().clone();
                Iterator sit = this.getSegments();
                while (sit.hasNext()) {
                    LinkSegment tseg = (LinkSegment)sit.next();
                    Point2D endpt = tseg.getEnd();
                    SegCookie sc = new SegCookie(tseg.getID(), false);
                    if (endpt != null && endpt.equals(matching) && !cookies.contains(sc)) {
                        tseg.shiftEnd(dx, dy);
                        cookies.add(sc);
                    }
                    sc = new SegCookie(tseg.getID(), true);
                    if (!tseg.getStart().equals(matching) || cookies.contains(sc)) continue;
                    tseg.shiftStart(dx, dy);
                    cookies.add(sc);
                }
            } else if (seg.getEnd() != null) {
                Point2D matching1 = (Point2D)seg.getStart().clone();
                Point2D matching2 = (Point2D)seg.getEnd().clone();
                Iterator sit = this.getSegments();
                while (sit.hasNext()) {
                    LinkSegment tseg = (LinkSegment)sit.next();
                    Point2D endpt = tseg.getEnd();
                    SegCookie sc = new SegCookie(tseg.getID(), false);
                    if (endpt != null && !cookies.contains(sc) && (endpt.equals(matching1) || endpt.equals(matching2))) {
                        tseg.shiftEnd(dx, dy);
                        cookies.add(sc);
                    }
                    if (cookies.contains(sc = new SegCookie(tseg.getID(), true)) || !tseg.getStart().equals(matching1) && !tseg.getStart().equals(matching2)) continue;
                    tseg.shiftStart(dx, dy);
                    cookies.add(sc);
                }
            } else {
                Point2D matching1 = (Point2D)seg.getStart().clone();
                Iterator sit = this.getSegments();
                while (sit.hasNext()) {
                    LinkSegment tseg = (LinkSegment)sit.next();
                    SegCookie sc = new SegCookie(tseg.getID(), true);
                    if (cookies.contains(sc) || !tseg.getStart().equals(matching1)) continue;
                    tseg.shiftStart(dx, dy);
                    cookies.add(sc);
                }
            }
        }
    }

    protected boolean replaceCustomColors(String oldID, String newID) {
        boolean retval = false;
        Iterator sit = this.getSegments();
        while (sit.hasNext()) {
            String colorTag;
            LinkSegment ls = (LinkSegment)sit.next();
            SuggestedDrawStyle sds = ls.getSpecialDrawStyle();
            if (sds == null || (colorTag = sds.getColorName()) == null || !colorTag.equals(oldID)) continue;
            sds.setColorName(newID);
            retval = true;
        }
        Iterator bdit = this.getDrops();
        while (bdit.hasNext()) {
            SuggestedDrawStyle plsds;
            String colorTag;
            PerLinkDrawStyle plds;
            String colorTag2;
            LinkBusDrop bd = (LinkBusDrop)bdit.next();
            SuggestedDrawStyle sds = bd.getSpecialDropDrawStyle();
            if (sds != null && (colorTag2 = sds.getColorName()) != null && colorTag2.equals(oldID)) {
                sds.setColorName(newID);
                retval = true;
            }
            if (bd.getDropType() == 0 || (plds = bd.getDrawStyleForLink()) == null || (colorTag = (plsds = plds.getDrawStyle()).getColorName()) == null || !colorTag.equals(oldID)) continue;
            plsds.setColorName(newID);
            retval = true;
        }
        return retval;
    }

    protected void handleLeafCase(LinkSegment seg, boolean parentIsDegenerate) {
        String segID = seg.getID();
        int sense = parentIsDegenerate ? 0 : 1;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String conTag;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0 || !(conTag = drop.getConnectionTag()).equals(segID)) continue;
            drop.setConnectionTag(seg.getParent());
            drop.setConnectionSense(sense);
        }
        this.labels_.removeLabel(segID);
        this.segments_.remove(segID);
    }

    protected boolean hasSiblings(LinkSegment seg) {
        String parentID = seg.getParent();
        if (parentID == null) {
            return false;
        }
        String segID = seg.getID();
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            String nextParent;
            LinkSegment nextSeg = (LinkSegment)sit.next();
            if (seg == nextSeg || (nextParent = nextSeg.getParent()) == null || !nextParent.equals(parentID)) continue;
            return true;
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String conTag = drop.getConnectionTag();
            if (drop.getConnectionSense() == 1 && conTag.equals(parentID)) {
                return true;
            }
            if (drop.getConnectionSense() != 0 || !conTag.equals(segID)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMultipleChildren(LinkSegment seg) {
        String segID = seg.getID();
        String childID = null;
        int childCount = 0;
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            String nextParent;
            LinkSegment nextSeg = (LinkSegment)sit.next();
            if (seg == nextSeg || (nextParent = nextSeg.getParent()) == null || !nextParent.equals(segID)) continue;
            if (childID != null) {
                return true;
            }
            childID = nextSeg.getID();
            ++childCount;
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) continue;
            String conTag = drop.getConnectionTag();
            if (drop.getConnectionSense() == 1 && conTag.equals(segID) && ++childCount > 1) {
                return true;
            }
            if (drop.getConnectionSense() == 0 && childID != null && conTag.equals(childID)) {
                return true;
            }
            if (drop.getConnectionSense() != 0 || !seg.isDegenerate() || !conTag.equals(segID) || ++childCount <= 1) continue;
            return true;
        }
        return false;
    }

    protected void reparentChildrenAndDelete(LinkSegment seg, boolean parentIsDegenerate) {
        String parentID = seg.getParent();
        String segID = seg.getID();
        if (parentID == null) {
            throw new IllegalArgumentException();
        }
        LinkSegment parentSeg = (LinkSegment)this.segments_.get(parentID);
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            String nextParent;
            LinkSegment nextSeg = (LinkSegment)sit.next();
            if (seg == nextSeg || (nextParent = nextSeg.getParent()) == null || !nextParent.equals(segID)) continue;
            nextSeg.setParent(parentID);
        }
        int sense = parentIsDegenerate ? 0 : 1;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String conTag;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0 || !(conTag = drop.getConnectionTag()).equals(segID)) continue;
            drop.setConnectionTag(seg.getParent());
            drop.setConnectionSense(sense);
        }
        this.labels_.removeLabel(segID);
        this.segments_.remove(segID);
        LinkSegment replacement = parentIsDegenerate ? new LinkSegment(parentSeg, seg.getEnd()) : new LinkSegment(parentSeg, seg);
        this.segments_.put(parentID, replacement);
    }

    protected Set getLabelLinkages(Genome genome, OverlayStateOracle oso) {
        HashSet<String> retval = new HashSet<String>();
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            String newLabel;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String busID = drop.getTargetRef();
            if (drop.getDropType() == 0 || !this.linkIsInModel(genome, oso, busID) || (newLabel = this.getLinkLabel(genome, busID)) == null || newLabel.trim().equals("")) continue;
            retval.add(busID);
        }
        return retval;
    }

    protected DistancedLinkSegID twoPassCheckSegmentIntersect(LinkSegment toCheck, Point2D pt, int type, String idTag, Genome genome, double intersectTol, double upperTol, boolean twoPass, boolean endsOnly, OverlayStateOracle oso) {
        DistancedLinkSegID dlLsid;
        boolean needSecond = false;
        double checkDist = intersectTol;
        if (twoPass && (dlLsid = this.checkSegmentIntersect(toCheck, pt, type, idTag, upperTol, endsOnly)) != null) {
            int segThick = DrawTree.getSegThick((DrawTreeModelDataSource)this.myRenderer_, dlLsid.segID, genome, this, oso);
            double segTol = (double)segThick / 2.0;
            if (segTol < intersectTol) {
                segTol = intersectTol;
            }
            if (segTol < upperTol) {
                checkDist = segTol;
                needSecond = true;
            } else {
                return dlLsid;
            }
        }
        if (!twoPass || needSecond) {
            return this.checkSegmentIntersect(toCheck, pt, type, idTag, checkDist, endsOnly);
        }
        return null;
    }

    protected DistancedLinkSegID checkSegmentIntersect(LinkSegment toCheck, Point2D pt, int type, String idTag, double intersectTol, boolean endsOnly) {
        LinkSegmentID retval = null;
        Double haveIntersect = endsOnly ? null : toCheck.intersects(pt, intersectTol);
        Double haveStart = toCheck.intersectsStart(pt, intersectTol);
        Double haveEnd = toCheck.intersectsEnd(pt, intersectTol);
        if ((endsOnly || haveIntersect == null) && haveEnd == null && haveStart == null) {
            return null;
        }
        retval = LinkSegmentID.buildIDForType(idTag, type);
        Double bestPt = null;
        if (haveEnd != null || haveStart != null) {
            if (haveStart == null) {
                bestPt = haveEnd;
                retval.tagIDWithEndpoint("E");
            } else if (haveEnd == null) {
                bestPt = haveStart;
                retval.tagIDWithEndpoint("S");
            } else {
                String tagIt = haveStart < haveEnd ? "S" : "E";
                bestPt = haveStart < haveEnd ? haveStart : haveEnd;
                retval.tagIDWithEndpoint(tagIt);
            }
        }
        double useDist = bestPt == null ? haveIntersect : (haveIntersect == null ? bestPt : Math.min(haveIntersect, bestPt));
        return retval == null ? null : new DistancedLinkSegID(retval, useDist);
    }

    protected LinkSegmentID checkForSegmentInBox(LinkSegment toCheck, Rectangle2D testRect, int type, String idTag) {
        return this.checkForSegmentInShape(toCheck, testRect, type, idTag);
    }

    protected LinkSegmentID checkForSegmentInShape(LinkSegment toCheck, Shape testShape, int type, String idTag) {
        if (!toCheck.insideShape(testShape)) {
            return null;
        }
        return LinkSegmentID.buildIDForType(idTag, type);
    }

    protected static void shiftSupport(Point2D loc, SortedSet rows, SortedSet cols, Rectangle bounds, double sign, int mult) {
        if (bounds != null) {
            double minX = bounds.x;
            double maxX = bounds.x + bounds.width;
            double minY = bounds.y;
            double maxY = bounds.y + bounds.height;
            double locY = loc.getY();
            double locX = loc.getX();
            if (locY < minY || locY > maxY || locX < minX || locX > maxX) {
                return;
            }
        }
        double dVal = 10.0 * (double)mult;
        Iterator rit = rows.iterator();
        double rowDelta = 0.0;
        while (rit.hasNext()) {
            Integer row = (Integer)rit.next();
            if (!((double)row.intValue() * 10.0 < loc.getY())) continue;
            rowDelta += dVal;
        }
        double colDelta = 0.0;
        Iterator cit = cols.iterator();
        while (cit.hasNext()) {
            Integer col = (Integer)cit.next();
            if (!((double)col.intValue() * 10.0 < loc.getX())) continue;
            colDelta += dVal;
        }
        double newX = loc.getX() + colDelta * sign;
        double newY = loc.getY() + rowDelta * sign;
        loc.setLocation(newX, newY);
    }

    protected void segmentShiftSupport(LinkSegment seg, SortedSet rows, SortedSet cols, Rectangle bounds, double sign, int mult) {
        Point2D lsStart = seg.getStart();
        Point2D lsNewStart = (Point2D)lsStart.clone();
        LinkProperties.shiftSupport(lsNewStart, rows, cols, bounds, sign, mult);
        seg.shiftStart(lsNewStart.getX() - lsStart.getX(), lsNewStart.getY() - lsStart.getY());
        Point2D lsEnd = seg.getEnd();
        if (lsEnd == null) {
            return;
        }
        Point2D lsNewEnd = (Point2D)lsEnd.clone();
        LinkProperties.shiftSupport(lsNewEnd, rows, cols, bounds, sign, mult);
        seg.shiftEnd(lsNewEnd.getX() - lsEnd.getX(), lsNewEnd.getY() - lsEnd.getY());
    }

    protected void copySupport(LinkProperties other) {
        this.textPos_ = other.textPos_ != null ? (Point2D)other.textPos_.clone() : null;
        this.textDir_ = other.textDir_;
        this.textDirTag_ = other.textDirTag_;
        this.myRenderer_ = other.myRenderer_;
        this.drawStyle_ = (SuggestedDrawStyle)other.drawStyle_.clone();
        this.srcTag_ = other.srcTag_;
        this.segments_ = new HashMap();
        Iterator sit = other.segments_.keySet().iterator();
        while (sit.hasNext()) {
            String nextKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)other.segments_.get(nextKey);
            this.segments_.put(nextKey, seg.clone());
        }
        this.drops_ = new ArrayList();
        Iterator dit = other.drops_.iterator();
        while (dit.hasNext()) {
            LinkBusDrop nextDrop = (LinkBusDrop)dit.next();
            this.drops_.add(nextDrop.clone());
        }
        this.labels_ = new UniqueLabeller(other.labels_);
    }

    protected LinkSegmentID getSegmentIDForLabel(Genome genome, OverlayStateOracle oso, Layout lo, FontRenderContext frc) {
        if (genome instanceof GenomeInstance && ((GenomeInstance)genome).getVfgParent() != null) {
            throw new IllegalArgumentException();
        }
        Set labelLinks = this.getLabelLinkages(genome, oso);
        if (labelLinks.isEmpty()) {
            return null;
        }
        if (this.textPos_ == null) {
            return null;
        }
        if (this.isDirect()) {
            return LinkSegmentID.buildIDForType(this.getTargetDrop().getTargetRef(), 2);
        }
        double minDist = Double.POSITIVE_INFINITY;
        LinkSegmentID minSegID = null;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            double dist;
            int dropType;
            LinkSegment dropSeg;
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            if (dropRef == null) {
                dropSeg = this.getSourceDropSegment(genome, lo, frc, true);
                dropType = 0;
            } else {
                dropSeg = this.getTargetDropSegment(drop, genome, lo, frc);
                dropType = 1;
            }
            if (!((dist = dropSeg.getDistance(this.textPos_)) < minDist)) continue;
            minSegID = LinkSegmentID.buildIDForType(dropRef, dropType);
            minDist = dist;
        }
        Iterator sit = this.segments_.keySet().iterator();
        while (sit.hasNext()) {
            double dist;
            String segKey = (String)sit.next();
            LinkSegment seg = (LinkSegment)this.segments_.get(segKey);
            if (seg.isDegenerate() || !((dist = seg.getDistance(this.textPos_)) < minDist)) continue;
            minSegID = LinkSegmentID.buildIDForType(segKey, 3);
            minDist = dist;
        }
        return minSegID;
    }

    protected LinkProperties newTreeBelowSegment(LinkSegment oldSeg, String newSourceID, String newLinkToNodeID, Map linkMap, Object extraInfo) {
        LinkProperties retval = (LinkProperties)this.clone();
        retval.srcTag_ = newSourceID;
        List allLinks = this.getLinkageList();
        Set keepLinks = linkMap.keySet();
        int linkNum = allLinks.size();
        for (int i = 0; i < linkNum; ++i) {
            String linkID = (String)allLinks.get(i);
            if (keepLinks.contains(linkID)) continue;
            retval.removeLinkSupport(linkID);
        }
        LinkSegment rootSeg = retval.getRootSegment();
        String oldSegID = oldSeg.getID();
        LinkSegment matchingToOld = retval.getSegment(oldSegID);
        List toRoot = retval.getSegmentsToRoot(matchingToOld);
        int tRNum = toRoot.size();
        for (int i = 0; i < tRNum; ++i) {
            LinkSegment segToRoot = (LinkSegment)toRoot.get(i);
            if (segToRoot.getID().equals(oldSegID)) continue;
            retval.labels_.removeLabel(segToRoot.getID());
            retval.segments_.remove(segToRoot.getID());
        }
        matchingToOld.setParent(null);
        matchingToOld.setStart(matchingToOld.getEnd());
        matchingToOld.setEnd(null);
        Iterator dit = retval.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)dit.next();
            if (drop.getDropType() == 0) {
                drop.setConnectionSense(0);
                drop.setConnectionTag(oldSegID);
                drop.setDrawStyleForDrop(matchingToOld.getSpecialDrawStyle());
                continue;
            }
            if (!drop.getConnectionTag().equals(oldSegID)) continue;
            drop.setConnectionSense(0);
        }
        Iterator drit = retval.getDrops();
        while (drit.hasNext()) {
            LinkBusDrop drop = (LinkBusDrop)drit.next();
            String targRef = drop.getTargetRef();
            if (targRef == null) continue;
            String mappedRef = (String)linkMap.get(targRef);
            drop.setTargetRef(mappedRef);
        }
        if (newLinkToNodeID != null) {
            String parentSeg;
            String myRootSegID = this.getRootSegment().getID();
            int sense = myRootSegID.equals(parentSeg = oldSeg.getParent()) ? 0 : 1;
            SuggestedDrawStyle segStyle = oldSeg.getSpecialDrawStyle();
            LinkBusDrop newDrop = this.generateBusDrop(newLinkToNodeID, parentSeg, 1, sense, extraInfo);
            newDrop.setDrawStyleForDrop(segStyle);
            this.addDrop(newDrop);
        }
        retval.moveSource(extraInfo);
        return retval;
    }

    protected static void buildFromXMLSupport(String elemName, Attributes attrs, LinkProperties emptyProp, FactoryWhiteboard board, String xmlTag) throws IOException {
        String src = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "src", true);
        String color = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "color", false);
        String line = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "line", false);
        String txtX = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "labelX", false);
        String txtY = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "labelY", false);
        String txtDir = AttributeExtractor.extractAttribute(elemName, attrs, xmlTag, "labelDir", false);
        emptyProp.loadFromXML(color, src, line, txtX, txtY, txtDir);
    }

    public static Set labelDirections() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(LEFT_STR_);
        retval.add(RIGHT_STR_);
        retval.add(UP_STR_);
        retval.add(DOWN_STR_);
        return retval;
    }

    public static String mapDirectionToTag(int val) {
        switch (val) {
            case 1: {
                return LEFT_STR_;
            }
            case 2: {
                return RIGHT_STR_;
            }
            case 3: {
                return UP_STR_;
            }
            case 4: {
                return DOWN_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromDirectionTag(String tag) {
        if (tag.equals(LEFT_STR_)) {
            return 1;
        }
        if (tag.equals(RIGHT_STR_)) {
            return 2;
        }
        if (tag.equals(UP_STR_)) {
            return 3;
        }
        if (tag.equals(DOWN_STR_)) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static int mapFromStyleTag(String lineStyle) {
        if ((lineStyle = lineStyle.trim()).equalsIgnoreCase("solid")) {
            return 0;
        }
        if (lineStyle.equalsIgnoreCase("thin")) {
            return 1;
        }
        if (lineStyle.equalsIgnoreCase("dash")) {
            return 2;
        }
        if (lineStyle.equalsIgnoreCase("thindash")) {
            return 3;
        }
        if (lineStyle.equalsIgnoreCase("")) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public static class CornerDoF
    implements Cloneable {
        public boolean inboundIsCanonical;
        public LinkSegmentID backupPoint;
        public LinkSegmentID runPoint;
        public LinkSegmentID normPoint;
        public LinkSegmentID antiNormPoint;
        public Vector2D backupVector;
        public Vector2D runVector;
        public Vector2D normVector;
        public Vector2D antiNormVector;
        public LinkSegmentID myID;
        public boolean runDrop;
        public boolean backDrop;
        public boolean normDrop;
        public boolean antiDrop;
        public boolean backupPointIsInBackupDir;

        public CornerDoF(LinkSegmentID myID) {
            this.myID = myID;
        }

        public Object clone() {
            try {
                CornerDoF retval = (CornerDoF)super.clone();
                retval.myID = this.myID == null ? null : (LinkSegmentID)this.myID.clone();
                retval.runPoint = this.runPoint == null ? null : (LinkSegmentID)this.runPoint.clone();
                retval.backupPoint = this.backupPoint == null ? null : (LinkSegmentID)this.backupPoint.clone();
                retval.normPoint = this.normPoint == null ? null : (LinkSegmentID)this.normPoint.clone();
                retval.antiNormPoint = this.antiNormPoint == null ? null : (LinkSegmentID)this.antiNormPoint.clone();
                retval.runVector = this.runVector == null ? null : (Vector2D)this.runVector.clone();
                retval.backupVector = this.backupVector == null ? null : (Vector2D)this.backupVector.clone();
                retval.normVector = this.normVector == null ? null : (Vector2D)this.normVector.clone();
                retval.antiNormVector = this.antiNormVector == null ? null : (Vector2D)this.antiNormVector.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public String toString() {
            return "CornerDoF: myID [" + this.myID + "] normPoint [" + this.normPoint + "] antiNormPoint = [" + this.antiNormPoint + "] runPoint = [" + this.runPoint + "] backupPoint = [" + this.backupPoint + "] normVector = [" + this.normVector + "] antiNormVector = [" + this.antiNormVector + "] runVector = [" + this.runVector + "] backupVector = [" + this.backupVector + "] inboundIsCanonical = " + this.inboundIsCanonical + " runDrop = " + this.runDrop + " normDrop = " + this.normDrop + " antiDrop = " + this.antiDrop;
        }
    }

    public static class LinkFragmentData {
        Point2D location;
        Vector2D expComp;

        public LinkFragmentData(Point2D location) {
            this.location = (Point2D)location.clone();
        }

        public void expandContract(SortedSet rows, SortedSet cols, Rectangle bounds, double sign, int mult) {
            Point2D lsNewStart = (Point2D)this.location.clone();
            LinkProperties.shiftSupport(lsNewStart, rows, cols, bounds, sign, mult);
            this.expComp = new Vector2D(lsNewStart.getX() - this.location.getX(), lsNewStart.getY() - this.location.getY());
        }
    }

    public static class LinkFragmentShifts {
        HashMap segmentStarts = new HashMap();
        HashMap segmentEnds = new HashMap();
        HashMap drops = new HashMap();
        LinkFragmentData doSource;

        LinkFragmentShifts() {
        }

        public String toString() {
            return "LinkFragmentShifts " + this.segmentStarts + " " + this.segmentEnds + " " + this.drops + " " + this.doSource;
        }
    }

    protected class RepairRequest {
        int relation;
        LinkSegmentID myID;
        LinkSegmentID otherID;
        LinkSegment.OverlapResult ovrRes;
        boolean isUseless;

        RepairRequest(LinkSegmentID myID, LinkSegmentID otherID, LinkSegment.OverlapResult ovrRes) {
            this.relation = LinkProperties.this.segRelationship(myID, otherID);
            this.myID = myID;
            this.otherID = otherID;
            this.ovrRes = ovrRes;
            this.isUseless = false;
        }

        RepairRequest(LinkSegmentID myID) {
            this.myID = myID;
            this.isUseless = true;
        }
    }

    private class ChopRequest {
        Point2D splitPt;
        String segmentID;

        ChopRequest(Point2D splitPt, String segmentID) {
            this.splitPt = splitPt;
            this.segmentID = segmentID;
        }
    }

    private class SegResolve {
        LinkSegment seg;
        int connectEnd;
        Point2D ourConnectPos;

        private SegResolve() {
        }
    }

    public static class DistancedLinkSegID {
        public LinkSegmentID segID;
        public double distance;

        DistancedLinkSegID(LinkSegmentID segID, double distance) {
            this.segID = segID;
            this.distance = distance;
        }
    }

    public static class ClosestAnswer {
        double distance;
        String segID;
        Point2D point;
    }

    public static class GlueJob {
        public LinkProperties newProps;
        public LinkSegmentID taggedWhip;

        public GlueJob(LinkProperties newProps, LinkSegmentID taggedWhip) {
            this.newProps = newProps;
            this.taggedWhip = taggedWhip;
        }
    }

    private class SegCookie {
        String segID;
        boolean isStart;

        SegCookie(String segID, boolean isStart) {
            this.segID = segID;
            this.isStart = isStart;
        }

        public int hashCode() {
            int startInc = this.isStart ? 1 : 0;
            return this.segID == null ? startInc : this.segID.hashCode() + startInc;
        }

        public String toString() {
            return "Seg cookie: " + this.segID + " isStart = " + this.isStart;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof SegCookie)) {
                return false;
            }
            SegCookie otherSC = (SegCookie)other;
            if (this.isStart != otherSC.isStart) {
                return false;
            }
            if (this.segID == null) {
                return otherSC.segID == null;
            }
            return this.segID.equals(otherSC.segID);
        }
    }

    protected static class ThickInfo {
        int maxThick;
        boolean twoPass;

        protected ThickInfo() {
        }
    }
}

