/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutRubberStamper;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.freerender.PlacementGridSupport;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.LayoutFailureTracker;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class LinkRouter {
    public static final int LAYOUT_OK = 0;
    public static final int COLOR_PROBLEM = 1;
    public static final int LAYOUT_PROBLEM = 2;
    public static final int LAYOUT_COULD_NOT_PROCEED = 4;
    public static final int LAYOUT_OVERLAID_SUBSET = 8;

    public LinkPlacementGrid initGridForModules(Genome genome, Layout layout, FontRenderContext frc, Set skipLinks, OverlayStateOracle oso, String overID, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return layout.moduleFillLinkPlacementGrid(genome, frc, skipLinks, oso, overID, monitor);
    }

    public LinkPlacementGrid initGridForModuleGuidedLinks(Map moduleShapes, Map multiLinkData, Map moduleLinkTrees) {
        LinkPlacementGrid retval = new LinkPlacementGrid();
        Iterator sit = moduleShapes.keySet().iterator();
        while (sit.hasNext()) {
            String moduleID = (String)sit.next();
            Rectangle2D rect = (Rectangle2D)moduleShapes.get(moduleID);
            retval.addGroup(UiUtil.rectFromRect2D(rect), moduleID);
        }
        PlacementGridSupport pgs = new PlacementGridSupport();
        Iterator mit = moduleLinkTrees.keySet().iterator();
        while (mit.hasNext()) {
            String treeID = (String)mit.next();
            NetModuleLinkageProperties lp = (NetModuleLinkageProperties)moduleLinkTrees.get(treeID);
            Map multiForTree = (Map)multiLinkData.get(treeID);
            if (multiForTree.isEmpty()) continue;
            pgs.multiRenderToPlacementGrid(lp, retval, multiForTree);
        }
        return retval;
    }

    public LinkPlacementGrid initGrid(Genome genome, Layout layout, FontRenderContext frc, Set skipLinks, int strictness, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return layout.fillLinkPlacementGrid(genome, frc, skipLinks, strictness, monitor);
    }

    public LinkPlacementGrid initLimitedGrid(Genome genome, Layout layout, FontRenderContext frc, Set useNodes, Set skipLinks, int strictness) {
        try {
            return layout.limitedFillLinkPlacementGrid(genome, frc, useNodes, skipLinks, strictness, null);
        }
        catch (AsynchExitRequestException ex) {
            throw new IllegalStateException();
        }
    }

    public RoutingResult multiPassLayout(Genome genome, Set newLinks, Layout lo, FontRenderContext frc, LayoutOptions options, BTProgressMonitor monitor, Set needColors, double startFrac, double endFrac, Map recoveryDataMap, boolean strictOKGroups) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double passFrac = fullFrac / 8.0;
        double currFrac = startFrac;
        HashSet linkSet = new HashSet(newLinks);
        RoutingResult nonLinkRetval = new RoutingResult();
        RoutingResult linkRetval = new RoutingResult();
        block0: for (int i = 0; i < 2 && !linkSet.isEmpty(); ++i) {
            int strictness = i == 0 ? 1 : 3;
            int lastFailCount = -1;
            for (int j = 0; j < 4; ++j) {
                int numTrying = linkSet.size();
                LinkPlacementGrid routerGrid = this.initGrid(genome, lo, frc, linkSet, strictness, monitor);
                double nextFrac = currFrac + passFrac;
                LayoutFailureTracker.recordLayoutPass(i, j);
                RoutingResult holdResult = this.layout(genome, linkSet, lo, routerGrid, frc, options.goodness, monitor, needColors, currFrac, nextFrac, recoveryDataMap, strictOKGroups);
                LayoutFailureTracker.clearLayoutPass();
                lo.dropUselessCorners(genome, frc, null, null, nextFrac, nextFrac, monitor);
                currFrac = nextFrac;
                int numFailed = holdResult.failedLinks.size();
                linkSet.clear();
                linkSet.addAll(holdResult.failedLinks);
                nonLinkRetval.merge(holdResult);
                if (numFailed == 0 || numFailed == lastFailCount || numFailed == numTrying) continue block0;
                lastFailCount = numFailed;
            }
        }
        if (!linkSet.isEmpty()) {
            linkRetval.linkResult |= 2;
            linkRetval.failedLinks.addAll(linkSet);
        }
        nonLinkRetval.linkResult = (nonLinkRetval.linkResult & 1) != 0 ? 1 : 0;
        nonLinkRetval.failedLinks.clear();
        linkRetval.merge(nonLinkRetval);
        if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        return linkRetval;
    }

    private void generatePreExistingDeparts(Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, Map recoveryDataMap, HashMap departurePerLink, HashMap linksPerDeparture) {
        Iterator sit = genome.getAllNodeIterator();
        while (sit.hasNext()) {
            Node node = (Node)sit.next();
            String srcID = node.getID();
            Map depChops = null;
            if (recoveryDataMap != null) {
                LinkPlacementGrid.RecoveryDataForSource rdfs = (LinkPlacementGrid.RecoveryDataForSource)recoveryDataMap.get(srcID);
                depChops = rdfs == null ? null : rdfs.getDepartureRegionChops();
            }
            Set allDrawnLinks = grid.allLinksDrawnForSource(srcID, genome, null);
            Iterator adlit = allDrawnLinks.iterator();
            while (adlit.hasNext()) {
                String linkID = (String)adlit.next();
                LayoutRubberStamper.EdgeMove em = depChops == null ? null : (LayoutRubberStamper.EdgeMove)depChops.get(linkID);
                LinkPlacementGrid.TerminalRegion depart = em == null ? this.generateDeparture(linkID, genome, lo, frc, grid, null) : this.generateRegionBoundary(linkID, genome, em, grid, null, false);
                HashSet<String> linksForDep = (HashSet<String>)linksPerDeparture.get(depart);
                if (linksForDep == null) {
                    linksForDep = new HashSet<String>();
                    linksPerDeparture.put(depart, linksForDep);
                }
                linksForDep.add(linkID);
                departurePerLink.put(linkID, depart);
            }
        }
    }

    private void generateDepartsAndArrives(Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, TreeSet forSource, Map arrChops, Map depChops, HashMap departurePerLink, HashMap linksPerDeparture, HashMap arrivals, HashMap regArrivals, HashSet unseenLinks, HashSet needAltTargs, HashMap okGroupMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Iterator fsit = forSource.iterator();
        while (fsit.hasNext()) {
            LayoutRubberStamper.EdgeMove em;
            LinkPlacementGrid.TerminalRegion depart;
            HashSet<String> linksForDep;
            DistanceRank dr = (DistanceRank)fsit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            String linkID = dr.id;
            HashSet okGroups = null;
            if (genome instanceof GenomeInstance) {
                okGroups = new HashSet();
                okGroupMap.put(linkID, okGroups);
            }
            if ((linksForDep = (HashSet<String>)linksPerDeparture.get(depart = (em = depChops == null ? null : (LayoutRubberStamper.EdgeMove)depChops.get(linkID)) == null ? this.generateDeparture(linkID, genome, lo, frc, grid, okGroups) : this.generateRegionBoundary(linkID, genome, em, grid, okGroups, false))) == null) {
                linksForDep = new HashSet<String>();
                linksPerDeparture.put(depart, linksForDep);
            }
            linksForDep.add(linkID);
            departurePerLink.put(linkID, depart);
            if (!needAltTargs.contains(linkID)) {
                LinkPlacementGrid.TerminalRegion arrive;
                LayoutRubberStamper.EdgeMove ema;
                LayoutRubberStamper.EdgeMove edgeMove = ema = arrChops == null ? null : (LayoutRubberStamper.EdgeMove)arrChops.get(linkID);
                if (ema == null) {
                    arrive = LinkRouter.generateArrival(linkID, genome, lo, frc, grid, null, okGroups);
                    arrivals.put(linkID, arrive);
                } else {
                    arrive = this.generateRegionBoundary(linkID, genome, ema, grid, okGroups, true);
                    regArrivals.put(linkID, arrive);
                }
            }
            unseenLinks.add(linkID);
        }
    }

    private Set reserveTerminalRegions(Genome genome, Set newLinks, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, HashMap departures, HashMap linksPerDeparture, HashMap arrivals, HashMap regArrivals, HashSet needAltTargs, HashMap okGroupMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<LinkPlacementGrid.TerminalRegion> reserved = new HashSet<LinkPlacementGrid.TerminalRegion>();
        Iterator dkit = departures.keySet().iterator();
        while (dkit.hasNext()) {
            String linkID = (String)dkit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            LinkPlacementGrid.TerminalRegion depart = (LinkPlacementGrid.TerminalRegion)departures.get(linkID);
            if (reserved.contains(depart)) continue;
            String srcID = genome.getLinkage(linkID).getSource();
            Set drawnLinksForSource = grid.allLinksDrawnForSource(srcID, genome, null);
            Set linksForThisDeparture = (Set)linksPerDeparture.get(depart);
            HashSet alreadyHandled = new HashSet();
            DataUtil.intersection(drawnLinksForSource, linksForThisDeparture, alreadyHandled);
            if (!alreadyHandled.isEmpty()) continue;
            grid.reserveTerminalRegion(depart, srcID, false);
            reserved.add(depart);
        }
        Iterator akit = arrivals.keySet().iterator();
        while (akit.hasNext()) {
            String linkID = (String)akit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)arrivals.get(linkID);
            grid.reserveTerminalRegion(arrive, linkID, false);
        }
        Iterator rakit = regArrivals.keySet().iterator();
        while (rakit.hasNext()) {
            String linkID = (String)rakit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)regArrivals.get(linkID);
            String srcID = genome.getLinkage(linkID).getSource();
            grid.reserveTerminalRegion(arrive, srcID, true);
        }
        Map gtr = this.generateTerminalRegionsForCollisions(genome, lo, frc, grid, newLinks, needAltTargs, okGroupMap);
        Iterator gkit = gtr.keySet().iterator();
        while (gkit.hasNext()) {
            String linkID = (String)gkit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)gtr.get(linkID);
            arrivals.put(linkID, arrive);
            grid.reserveTerminalRegion(arrive, linkID, false);
        }
        return reserved;
    }

    private RoutingResult layout(Genome genome, Set newLinks, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, LinkPlacementGrid.GoodnessParams goodness, BTProgressMonitor monitor, Set needColors, double startFrac, double endFrac, Map recoveryDataMap, boolean strictOKGroups) throws AsynchExitRequestException {
        Set targCollide = genome.hasLinkTargetPadCollisions();
        HashSet needAltTargs = new HashSet(targCollide);
        needAltTargs.retainAll(newLinks);
        Map links = this.organizeLinks(newLinks, genome, lo, recoveryDataMap);
        HashMap departurePerLink = new HashMap();
        HashMap linksPerDeparture = new HashMap();
        HashMap arrivals = new HashMap();
        HashMap regArrivals = new HashMap();
        HashSet unseenLinks = new HashSet();
        if (monitor != null && !monitor.updateProgress((int)(startFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        this.generatePreExistingDeparts(genome, lo, grid, frc, recoveryDataMap, departurePerLink, linksPerDeparture);
        HashMap okGroupMap = new HashMap();
        Iterator lkit = links.keySet().iterator();
        while (lkit.hasNext()) {
            DistanceRank srcIDDR = (DistanceRank)lkit.next();
            TreeSet forSource = (TreeSet)links.get(srcIDDR);
            Map arrChops = null;
            Map depChops = null;
            if (recoveryDataMap != null) {
                LinkPlacementGrid.RecoveryDataForSource rdfs = (LinkPlacementGrid.RecoveryDataForSource)recoveryDataMap.get(srcIDDR.id);
                arrChops = rdfs.getArrivalRegionChops();
                depChops = rdfs.getDepartureRegionChops();
            }
            this.generateDepartsAndArrives(genome, lo, grid, frc, forSource, arrChops, depChops, departurePerLink, linksPerDeparture, arrivals, regArrivals, unseenLinks, needAltTargs, okGroupMap, monitor);
        }
        Set untouchedDepartures = this.reserveTerminalRegions(genome, newLinks, lo, grid, frc, departurePerLink, linksPerDeparture, arrivals, regArrivals, needAltTargs, okGroupMap, monitor);
        arrivals.putAll(regArrivals);
        int linkCount = links.size();
        double currProg = startFrac;
        double progInc = (endFrac - startFrac) / (double)linkCount;
        RoutingResult nonLinkRetval = new RoutingResult();
        RoutingResult linkRetval = new RoutingResult();
        lkit = links.keySet().iterator();
        while (lkit.hasNext()) {
            DistanceRank srcIDDR = (DistanceRank)lkit.next();
            TreeSet forSource = (TreeSet)links.get(srcIDDR);
            LinkPlacementGrid.RecoveryDataForSource rdfs = null;
            Set linksFromSource = genome.getOutboundLinks(srcIDDR.id);
            if (recoveryDataMap != null) {
                rdfs = (LinkPlacementGrid.RecoveryDataForSource)recoveryDataMap.get(srcIDDR.id);
            }
            HashSet<String> workingSet = new HashSet<String>();
            Iterator fsvit = forSource.iterator();
            while (fsvit.hasNext()) {
                DistanceRank ndr = (DistanceRank)fsvit.next();
                workingSet.add(ndr.id);
            }
            block3: for (int i = 0; i < 2 && !workingSet.isEmpty(); ++i) {
                boolean force = i == 1;
                int lastFailCount = -1;
                for (int j = 0; j < 4; ++j) {
                    RoutingResult holdResult = new RoutingResult();
                    if (rdfs == null) {
                        this.layoutForSource(forSource, workingSet, genome, lo, frc, grid, goodness, departurePerLink, arrivals, okGroupMap, unseenLinks, srcIDDR, untouchedDepartures, force, holdResult, needColors, monitor, linksFromSource);
                    } else {
                        this.recoverForSource(forSource, workingSet, genome, lo, frc, grid, goodness, departurePerLink, arrivals, okGroupMap, unseenLinks, srcIDDR, untouchedDepartures, force, holdResult, needColors, monitor, rdfs, recoveryDataMap, linksFromSource, strictOKGroups);
                    }
                    workingSet.clear();
                    workingSet.addAll(holdResult.failedLinks);
                    nonLinkRetval.merge(holdResult);
                    int numFail = holdResult.failedLinks.size();
                    if (numFail == 0 || numFail == lastFailCount || numFail == forSource.size()) continue block3;
                    lastFailCount = numFail;
                }
            }
            if (!workingSet.isEmpty()) {
                linkRetval.linkResult |= 2;
                linkRetval.failedLinks.addAll(workingSet);
            }
            if (monitor == null || monitor.updateProgress((int)((currProg += progInc) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        nonLinkRetval.linkResult = (nonLinkRetval.linkResult & 1) != 0 ? 1 : 0;
        nonLinkRetval.failedLinks.clear();
        linkRetval.merge(nonLinkRetval);
        if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        return linkRetval;
    }

    private Map generateTerminalRegionsForCollisions(Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, Set links, Set needAltTargs, Map okGroupMap) {
        HashSet<String> inlinks;
        PadCalculatorToo pct = new PadCalculatorToo();
        HashMap<String, HashSet<String>> perTarg = new HashMap<String, HashSet<String>>();
        Iterator lit = links.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            if (!needAltTargs.contains(linkID)) continue;
            Linkage link = genome.getLinkage(linkID);
            String trg = link.getTarget();
            inlinks = (HashSet<String>)perTarg.get(trg);
            if (inlinks == null) {
                inlinks = new HashSet<String>();
                perTarg.put(trg, inlinks);
            }
            inlinks.add(linkID);
        }
        HashMap retval = new HashMap();
        Iterator ptkit = perTarg.keySet().iterator();
        while (ptkit.hasNext()) {
            String targID = (String)ptkit.next();
            inlinks = (HashSet)perTarg.get(targID);
            Map not = pct.generateTerminalRegionsForCollisions(genome, lo, frc, grid, inlinks, targID, needAltTargs, okGroupMap);
            retval.putAll(not);
        }
        return retval;
    }

    private int entryQuadrant(Linkage link, Genome genome, Layout lo) {
        String trgID = link.getTarget();
        Node targNode = genome.getNode(trgID);
        int type = targNode.getNodeType();
        if (type == 4) {
            NodeProperties np = lo.getNodeProperties(trgID);
            if (np.getOrientation() == 2) {
                return 9;
            }
            return 3;
        }
        return 0;
    }

    private void layoutForSource(Set forSource, Set workingSet, Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, LinkPlacementGrid.GoodnessParams goodness, Map departures, Map arrivals, Map okGroupMap, Set unseenLinks, DistanceRank srcIDDR, Set untouchedDepartures, boolean force, RoutingResult result, Set needColors, BTProgressMonitor monitor, Set linksFromSource) throws AsynchExitRequestException {
        Iterator fsit = forSource.iterator();
        while (fsit.hasNext()) {
            DistanceRank dr = (DistanceRank)fsit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            String linkID = dr.id;
            if (!workingSet.contains(linkID)) continue;
            Linkage link = genome.getLinkage(linkID);
            int entryPref = this.entryQuadrant(link, genome, lo);
            Set okGroups = (Set)okGroupMap.get(linkID);
            LinkPlacementGrid.TerminalRegion depart = (LinkPlacementGrid.TerminalRegion)departures.get(linkID);
            if (untouchedDepartures.contains(depart)) {
                if (!this.addFirstForSource(srcIDDR.id, link, genome, lo, grid, frc, departures, arrivals, goodness, okGroups, force, entryPref, linksFromSource)) {
                    result.failedLinks.add(linkID);
                    continue;
                }
                untouchedDepartures.remove(depart);
                unseenLinks.remove(linkID);
                needColors.add(linkID);
                continue;
            }
            if (!this.addAdditionalForSource(srcIDDR.id, link, genome, lo, grid, frc, arrivals, unseenLinks, goodness, okGroups, force, entryPref, linksFromSource)) {
                result.failedLinks.add(linkID);
                continue;
            }
            unseenLinks.remove(linkID);
        }
    }

    private void recoverForSource(Set forSource, Set workingSet, Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, LinkPlacementGrid.GoodnessParams goodness, Map departures, Map arrivals, Map okGroupMap, Set unseenLinks, DistanceRank srcIDDR, Set untouchedDepartures, boolean force, RoutingResult result, Set needColors, BTProgressMonitor monitor, LinkPlacementGrid.RecoveryDataForSource rdfs, Map recoveryDataMap, Set linksFromSource, boolean strictOKGroups) throws AsynchExitRequestException {
        Iterator fsit = forSource.iterator();
        while (fsit.hasNext()) {
            DistanceRank dr = (DistanceRank)fsit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            String linkID = dr.id;
            if (!workingSet.contains(linkID)) continue;
            Linkage link = genome.getLinkage(linkID);
            int entryPref = this.entryQuadrant(link, genome, lo);
            Set okGroups = (Set)okGroupMap.get(linkID);
            LinkPlacementGrid.TerminalRegion depart = (LinkPlacementGrid.TerminalRegion)departures.get(linkID);
            if (untouchedDepartures.contains(depart)) {
                if (!this.recoverFirstForSource(srcIDDR.id, link, genome, lo, grid, frc, departures, arrivals, goodness, okGroups, force, entryPref, rdfs, recoveryDataMap, unseenLinks, strictOKGroups)) {
                    result.failedLinks.add(linkID);
                    continue;
                }
                untouchedDepartures.remove(depart);
                unseenLinks.remove(linkID);
                needColors.add(linkID);
                continue;
            }
            if (!this.recoverAdditionalForSource(srcIDDR.id, link, genome, lo, grid, frc, departures, arrivals, unseenLinks, goodness, okGroups, force, entryPref, rdfs, recoveryDataMap, linksFromSource, strictOKGroups)) {
                result.failedLinks.add(linkID);
                continue;
            }
            unseenLinks.remove(linkID);
        }
    }

    public RoutingResult specialtyLayout(List subsetList, List pointDataList, Map alienSources, Map srcToBetween, NetModuleLinkExtractor.SubsetAnalysis sa, Set newLinks, Layout lo, FontRenderContext frc, Map splicePlans, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        RoutingResult retval = new RoutingResult();
        if (monitor != null && !monitor.updateProgress((int)(startFrac * 100.0))) {
            throw new AsynchExitRequestException();
        }
        int numSub = subsetList.size();
        if (numSub == 0) {
            return retval;
        }
        GenomeSubset firstSubset = (GenomeSubset)subsetList.get(0);
        Genome baseGenome = firstSubset.getBaseGenome();
        this.glueBeforeBuilding(sa, srcToBetween, baseGenome, pointDataList, alienSources, newLinks, lo, frc, splicePlans, monitor, startFrac, endFrac);
        return retval;
    }

    private void glueBeforeBuilding(NetModuleLinkExtractor.SubsetAnalysis sa, Map srcToBetween, Genome baseGenome, List pointDataList, Map alienSources, Set newLinks, Layout lo, FontRenderContext frc, Map splicePlans, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        SpecialtyLayoutLinkData siSrc;
        ArrayList<SpecialtyLayoutLinkData> placeList = new ArrayList<SpecialtyLayoutLinkData>();
        Iterator stiit = sa.getSrcKeys();
        while (stiit.hasNext()) {
            String modName;
            String srcID = (String)stiit.next();
            NetModuleLinkExtractor.PrimaryAndOthers pao = sa.getModulesForSrcID(srcID);
            NetModuleLinkExtractor.ExtractResultForSource interModForSrc = null;
            Map spSolnPerBorder = null;
            if (pao.sourceInModule() && (modName = sa.getPrimaryModuleName(pao)) != null) {
                interModForSrc = sa.getExtractResultForSource(modName);
                spSolnPerBorder = (Map)splicePlans.get(modName);
            }
            SpecialtyLayoutLinkData siBet = (SpecialtyLayoutLinkData)srcToBetween.get(srcID);
            SpecialtyInstructions spSrc = !pao.sourceInModule() ? null : (SpecialtyInstructions)pointDataList.get(sa.getMappedPrimaryModuleIndex(pao));
            siSrc = spSrc == null ? (SpecialtyLayoutLinkData)alienSources.get(srcID) : spSrc.getLinkPointsForSrc(srcID);
            placeList.add(siSrc);
            Iterator oit = pao.getTargetModules();
            while (oit.hasNext()) {
                SpecialtyLayoutLinkData siPlace;
                NetModuleLinkExtractor.ExtractResultForTarg interModPath;
                Integer other = (Integer)oit.next();
                String trgMod = sa.getTargetModuleName(pao, other);
                NetModuleLinkExtractor.ExtractResultForTarg extractResultForTarg = interModPath = interModForSrc == null || trgMod == null ? null : interModForSrc.getResultForTarg(trgMod);
                if (trgMod != null) {
                    SpecialtyInstructions spPlace = (SpecialtyInstructions)pointDataList.get(sa.getMappedTargetModuleIndex(pao, other));
                    siPlace = spPlace.getLinkPointsForSrc(srcID);
                } else {
                    siPlace = (SpecialtyLayoutLinkData)alienSources.get(srcID);
                }
                if (spSrc == null) continue;
                siPlace.setNeedsExitGlue((String)siPlace.getLinkList().get(0));
                Map trgSolnPerBorder = (Map)splicePlans.get(trgMod);
                if (interModPath != null) {
                    siSrc.mergeToStubsWithPoints(srcID, siPlace, spSolnPerBorder, trgSolnPerBorder, interModPath);
                    continue;
                }
                siSrc.mergeToStubsWithBetween(siPlace, siBet, spSolnPerBorder);
            }
        }
        LayoutFailureTracker.reportGluingDone(placeList);
        double currProg = startFrac;
        int linkCount = newLinks.size();
        double perLink = (endFrac - startFrac) / (double)linkCount;
        Iterator plit = placeList.iterator();
        while (plit.hasNext()) {
            siSrc = (SpecialtyLayoutLinkData)plit.next();
            currProg = this.placePointData(baseGenome, null, siSrc, true, lo, frc, currProg, perLink, monitor);
        }
    }

    private double placePointData(Genome baseGenome, SpecialtyLayoutLinkData siPlace, SpecialtyLayoutLinkData siSrc, boolean isFirst, Layout lo, FontRenderContext frc, double currProg, double perLink, BTProgressMonitor monitor) throws AsynchExitRequestException {
        SpecialtyLayoutLinkData si;
        boolean isSource = siPlace == null;
        SpecialtyLayoutLinkData specialtyLayoutLinkData = si = siPlace == null ? siSrc : siPlace;
        if (si != null) {
            si.normalizeLinks();
            LayoutFailureTracker.reportReorder(si);
        }
        int numLinks = si == null ? 0 : si.numLinks();
        for (int i = 0; i < numLinks; ++i) {
            String linkID = si.getLink(i);
            Linkage link = baseGenome.getLinkage(linkID);
            List ptList = si.getCleanedPositionList(linkID);
            LayoutFailureTracker.reportAssembly(si.getSrcID(), linkID, ptList);
            Point2D.Double lpLoc = new Point2D.Double();
            Vector2D lpDir = new Vector2D(0.0, 0.0);
            this.launchPadLoc(baseGenome, link, lo, frc, lpLoc, lpDir);
            Point2D pt = ((SpecialtyLayoutLinkData.TrackPos)ptList.get(0)).getPoint();
            if (pt.equals(lpLoc)) {
                pt = lpDir.scaled(10.0).add(pt);
            }
            if (i == 0) {
                BusProperties bp = lo.getLinkProperties(linkID);
                if (isFirst) {
                    if (isSource) {
                        this.positionRootSegment(linkID, baseGenome, lo, pt, frc);
                    } else if (bp.isDirect()) {
                        LinkSegment newRoot = new LinkSegment(pt, null);
                        bp.addSegmentInSeries(newRoot);
                    } else {
                        this.relocate(linkID, lo, bp.getRootSegment().getStart());
                        this.addAndLocateCorner(link, lo, pt);
                    }
                } else {
                    this.relocate(linkID, lo, bp.getRootSegment().getStart());
                    this.addAndLocateCorner(link, lo, pt);
                }
            } else {
                this.relocate(linkID, lo, pt);
            }
            int numPts = ptList.size();
            for (int k = 1; k < numPts; ++k) {
                pt = ((SpecialtyLayoutLinkData.TrackPos)ptList.get(k)).getPoint();
                this.addAndLocateCorner(link, lo, pt);
            }
            if (monitor == null || monitor.updateProgress((int)((currProg += perLink) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        return currProg;
    }

    public void launchPadLoc(Genome genome, Linkage link, Layout lo, FontRenderContext frc, Point2D loc, Vector2D vec) {
        String srcID = link.getSource();
        Node src = genome.getNode(srcID);
        NodeProperties np = lo.getNodeProperties(srcID);
        INodeRenderer render = np.getRenderer();
        Vector2D launchOff = render.getLaunchPadOffset(link.getLaunchPad(), src, lo, frc);
        Vector2D departDir = render.getDepartureDirection(link.getLaunchPad(), src, lo);
        vec.setXY(departDir.getX(), departDir.getY());
        Point2D nodePoint = np.getLocation();
        Point2D start = launchOff.add(nodePoint);
        UiUtil.forceToGrid(start.getX(), start.getY(), loc, 10.0);
    }

    private boolean recoverFirstForSource(String srcID, Linkage link, Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, Map departures, Map arrivals, LinkPlacementGrid.GoodnessParams goodness, Set okGroups, boolean force, int entryPref, LinkPlacementGrid.RecoveryDataForSource rdfs, Map recoveryDataMap, Set unseenLinks, boolean strictOKGroups) {
        List points;
        int numPoints;
        boolean forBounds;
        LinkPlacementGrid.RecoveryDataForLink rdfl;
        String linkID = link.getID();
        LinkPlacementGrid.TerminalRegion depart = (LinkPlacementGrid.TerminalRegion)departures.get(linkID);
        LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)arrivals.get(linkID);
        String targID = link.getTarget();
        LinkPlacementGrid.RecoveryDataForLink useRdfl = rdfl = new LinkPlacementGrid.RecoveryDataForLink(rdfs, linkID);
        Map depChops = rdfs.getDepartureRegionChops();
        boolean toss = false;
        boolean bl = forBounds = depChops != null && !depChops.isEmpty();
        if (forBounds) {
            LayoutRubberStamper.EdgeMove emov = (LayoutRubberStamper.EdgeMove)depChops.get(linkID);
            Point2D ar = rdfl.getPoint(0);
            boolean bl2 = toss = emov == null || emov.pas == null || emov.pas.isBehind(ar);
            if (toss && rdfl.getPointCount() > 1) {
                LayoutFailureTracker.recordRecoveryToss(srcID, linkID, emov, ar);
                useRdfl = new LinkPlacementGrid.RecoveryDataForLink(rdfl, 1);
            }
        }
        int n = numPoints = (points = grid.recoverValidFirstTrack(srcID, targID, linkID, depart, arrive, goodness, okGroups, force, entryPref, useRdfl, recoveryDataMap, departures, arrivals, unseenLinks, strictOKGroups)) == null ? 0 : points.size();
        if (numPoints == 0) {
            return false;
        }
        if (numPoints > 0) {
            if (toss) {
                Point2D ar = rdfl.getPoint(0);
                points.add(0, ar.clone());
                ++numPoints;
            }
            LayoutFailureTracker.recordRecoveryTrack(srcID, linkID, points);
            this.positionRootSegment(linkID, genome, lo, (Point2D)points.get(0), frc);
        }
        for (int i = 1; i < numPoints; ++i) {
            this.addAndLocateCorner(link, lo, (Point2D)points.get(i));
        }
        return true;
    }

    private boolean recoverAdditionalForSource(String srcID, Linkage link, Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, Map departures, Map arrivals, Set unseenLinks, LinkPlacementGrid.GoodnessParams goodness, Set okGroups, boolean force, int entryPref, LinkPlacementGrid.RecoveryDataForSource rdfs, Map recoveryDataMap, Set linksFromSource, boolean strictOKGroups) {
        String linkID = link.getID();
        String targID = link.getTarget();
        LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)arrivals.get(linkID);
        ArrayList points = new ArrayList();
        LinkPlacementGrid.RecoveryDataForLink rdfl = new LinkPlacementGrid.RecoveryDataForLink(rdfs, linkID);
        LinkPlacementGrid.NewCorner newCorner = grid.recoverValidAddOnTrack(srcID, targID, linkID, lo, arrive, points, goodness, okGroups, force, entryPref, rdfl, recoveryDataMap, departures, arrivals, unseenLinks, genome, frc, linksFromSource, strictOKGroups);
        int numPoints = points.size();
        if (numPoints <= 0) {
            return false;
        }
        if (newCorner.type == 5) {
            if (!this.createCorner(link, genome, lo, newCorner.point, frc, grid, unseenLinks, newCorner.dir)) {
                return false;
            }
        } else {
            grid.addCornerDirection(newCorner.point, srcID, newCorner.dir);
        }
        this.relocate(linkID, lo, newCorner.point);
        for (int i = 0; i < numPoints; ++i) {
            this.addAndLocateCorner(link, lo, (Point2D)points.get(i));
        }
        LayoutFailureTracker.recordRecoveryTrack(srcID, linkID, points);
        return true;
    }

    private boolean addFirstForSource(String srcID, Linkage link, Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, Map departures, Map arrivals, LinkPlacementGrid.GoodnessParams goodness, Set okGroups, boolean force, int entryPref, Set linksFromSource) {
        String linkID = link.getID();
        LinkPlacementGrid.TerminalRegion depart = (LinkPlacementGrid.TerminalRegion)departures.get(linkID);
        LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)arrivals.get(linkID);
        if (arrive == null) {
            return false;
        }
        String targID = link.getTarget();
        List points = grid.getValidFirstTrack(srcID, targID, linkID, depart, arrive, goodness, okGroups, force, entryPref, linksFromSource);
        int numPoints = points.size();
        if (numPoints == 0) {
            return false;
        }
        if (numPoints > 0) {
            this.positionRootSegment(linkID, genome, lo, (Point2D)points.get(0), frc);
        }
        for (int i = 1; i < numPoints; ++i) {
            this.addAndLocateCorner(link, lo, (Point2D)points.get(i));
        }
        return true;
    }

    private boolean addAdditionalForSource(String srcID, Linkage link, Genome genome, Layout lo, LinkPlacementGrid grid, FontRenderContext frc, Map arrivals, Set unseenLinks, LinkPlacementGrid.GoodnessParams goodness, Set okGroups, boolean force, int entryPref, Set linksFromSource) {
        String linkID = link.getID();
        String targID = link.getTarget();
        LinkPlacementGrid.TerminalRegion arrive = (LinkPlacementGrid.TerminalRegion)arrivals.get(linkID);
        ArrayList points = new ArrayList();
        LinkPlacementGrid.NewCorner newCorner = grid.getValidAddOnTrack(srcID, targID, linkID, arrive, points, goodness, okGroups, force, entryPref, genome, lo, frc, unseenLinks, linksFromSource);
        int numPoints = points.size();
        if (numPoints <= 0) {
            return false;
        }
        if (newCorner.type == 5) {
            if (!this.createCorner(link, genome, lo, newCorner.point, frc, grid, unseenLinks, newCorner.dir)) {
                return false;
            }
        } else {
            grid.addCornerDirection(newCorner.point, srcID, newCorner.dir);
        }
        this.relocate(linkID, lo, newCorner.point);
        for (int i = 0; i < numPoints; ++i) {
            this.addAndLocateCorner(link, lo, (Point2D)points.get(i));
        }
        return true;
    }

    private LinkPlacementGrid.TerminalRegion generateDeparture(String linkID, Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, Set okGroups) {
        Linkage link = genome.getLinkage(linkID);
        String srcID = link.getSource();
        if (genome instanceof GenomeInstance && okGroups != null) {
            GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(linkID);
            okGroups.add(tup.getSourceGroup());
        }
        Node src = genome.getNode(srcID);
        NodeProperties np = lo.getNodeProperties(srcID);
        INodeRenderer render = np.getRenderer();
        Vector2D launchOff = render.getLaunchPadOffset(link.getLaunchPad(), src, lo, frc);
        Vector2D departDir = render.getDepartureDirection(link.getLaunchPad(), src, lo);
        Point2D nodePoint = np.getLocation();
        Point2D start = launchOff.add(nodePoint);
        Point2D.Double forced = new Point2D.Double();
        UiUtil.forceToGrid(start.getX(), start.getY(), forced, 10.0);
        Point gridStart = new Point((int)((Point2D)forced).getX() / 10, (int)((Point2D)forced).getY() / 10);
        return grid.getDepartureRegion(srcID, departDir, okGroups, gridStart, 5);
    }

    private LinkPlacementGrid.TerminalRegion generateRegionBoundary(String linkID, Genome genome, LayoutRubberStamper.EdgeMove em, LinkPlacementGrid grid, Set okGroups, boolean forArrival) {
        Linkage link = genome.getLinkage(linkID);
        String srcID = link.getSource();
        if (genome instanceof GenomeInstance && okGroups != null) {
            GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(linkID);
            okGroups.add(tup.getSourceGroup());
        }
        Point2D.Double forced = new Point2D.Double();
        UiUtil.forceToGrid(em.getEdgePoint().getX(), em.getEdgePoint().getY(), forced, 10.0);
        Point gridTerm = new Point((int)((Point2D)forced).getX() / 10, (int)((Point2D)forced).getY() / 10);
        if (forArrival) {
            String targID = link.getTarget();
            return grid.getArrivalRegion(srcID, targID, linkID, okGroups, em.getEdgeDirectionOutbound().scaled(-1.0), gridTerm, 5);
        }
        return grid.getDepartureRegion(srcID, em.getEdgeDirectionOutbound(), okGroups, gridTerm, 5);
    }

    public static LinkPlacementGrid.TerminalRegion generateArrival(String linkID, Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, Integer forcePad, Set okGroups) {
        Linkage link = genome.getLinkage(linkID);
        int landingPad = forcePad != null ? forcePad.intValue() : link.getLandingPad();
        String srcID = link.getSource();
        String targID = link.getTarget();
        if (genome instanceof GenomeInstance && okGroups != null) {
            GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(linkID);
            okGroups.add(tup.getSourceGroup());
            okGroups.add(tup.getTargetGroup());
        }
        Node trg = genome.getNode(targID);
        NodeProperties np = lo.getNodeProperties(targID);
        INodeRenderer render = np.getRenderer();
        Vector2D landOff = render.getLandingPadOffset(landingPad, trg, link.getSign(), lo, frc);
        landOff = landOff.quantizeBigger(10.0);
        Vector2D arriveDir = render.getArrivalDirection(landingPad, trg, lo);
        Point2D nodePoint = np.getLocation();
        Point2D end = landOff.add(nodePoint);
        Point2D.Double forced = new Point2D.Double();
        UiUtil.forceToGrid(end.getX(), end.getY(), forced, 10.0);
        Point gridEnd = new Point((int)((Point2D)forced).getX() / 10, (int)((Point2D)forced).getY() / 10);
        return grid.getArrivalRegion(srcID, targID, linkID, okGroups, arriveDir, gridEnd, 5);
    }

    public static LinkPlacementGrid.TerminalRegion generateEmergencyArrival(String linkID, Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, int landingPad, int horiz, int pass, Set okGroups) {
        Linkage link = genome.getLinkage(linkID);
        String srcID = link.getSource();
        String targID = link.getTarget();
        if (genome instanceof GenomeInstance && okGroups != null) {
            GenomeInstance.GroupTuple tup = ((GenomeInstance)genome).getRegionTuple(linkID);
            okGroups.add(tup.getSourceGroup());
            okGroups.add(tup.getTargetGroup());
        }
        Node trg = genome.getNode(targID);
        NodeProperties np = lo.getNodeProperties(targID);
        INodeRenderer render = np.getRenderer();
        Vector2D landOff = render.getLandingPadOffset(landingPad, trg, link.getSign(), lo, frc);
        landOff = landOff.quantizeBigger(10.0);
        Vector2D arriveDir = render.getArrivalDirection(landingPad, trg, lo);
        Vector2D orthDir = arriveDir.normal();
        Vector2D offsetDir = orthDir.scaled(10.0 * (double)horiz);
        Vector2D passDir = arriveDir.scaled(-10.0 * (double)pass);
        Point2D nodePoint = np.getLocation();
        Point2D end = landOff.add(nodePoint);
        end = offsetDir.add(end);
        Point2D.Double forced = new Point2D.Double();
        UiUtil.forceToGrid(end.getX(), end.getY(), forced, 10.0);
        Point2D passForced = passDir.add(forced);
        Point gridEnd = new Point((int)passForced.getX() / 10, (int)passForced.getY() / 10);
        return grid.getEmergencyArrivalRegion(srcID, targID, linkID, okGroups, arriveDir, gridEnd);
    }

    private void positionRootSegment(String linkID, Genome genome, Layout lo, Point2D point, FontRenderContext frc) {
        BusProperties bp = lo.getLinkProperties(linkID);
        LayoutFailureTracker.forceFailureReport(linkID, "FAILURE_LINK_ID", bp);
        if (bp.isDirect()) {
            bp.splitNoSegmentBus(genome, lo, frc);
        }
        LinkSegment rootSeg = bp.getRootSegment();
        Point2D start = rootSeg.getStart();
        LinkSegmentID[] segIDs = new LinkSegmentID[]{LinkSegmentID.buildIDForSegment(rootSeg.getID())};
        segIDs[0].tagIDWithEndpoint("S");
        double dx = point.getX() - start.getX();
        double dy = point.getY() - start.getY();
        dx = (double)Math.round(dx / 10.0) * 10.0;
        dy = (double)Math.round(dy / 10.0) * 10.0;
        lo.moveBusLink(segIDs, dx, dy, start, bp);
    }

    private void addAndLocateCorner(Linkage link, Layout lo, Point2D point) {
        String linkID = link.getID();
        LinkSegmentID segID = LinkSegmentID.buildIDForEndDrop(linkID);
        BusProperties bp = lo.getLinkProperties(linkID);
        lo.splitBusLink(segID, new Point2D.Double(point.getX(), point.getY()), bp, null);
    }

    private boolean createCorner(Linkage link, Genome genome, Layout lo, Point2D split, FontRenderContext frc, LinkPlacementGrid grid, Set omitted, int dir) {
        BusProperties bp = lo.getLinkProperties(link.getID());
        LinkProperties.DistancedLinkSegID dlsegID = bp.intersectBusSegment(genome, null, lo, split, frc, omitted, 5.0);
        if (dlsegID == null) {
            return false;
        }
        lo.splitBusLink(dlsegID.segID, split, bp, null);
        grid.convertRunToCorner(split, link.getSource(), dir);
        return true;
    }

    private void relocate(String linkID, Layout lo, Point2D reloc) {
        BusProperties bp = lo.getLinkProperties(linkID);
        LayoutFailureTracker.forceFailureReport(linkID, "FAILURE_LINK_ID", bp);
        LinkSegmentID dropID = LinkSegmentID.buildIDForDrop(linkID);
        Iterator sit = bp.getSegments();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            Point2D end = ls.getEnd();
            if (end == null || !end.equals(reloc)) continue;
            LinkSegmentID relocSeg = LinkSegmentID.buildIDForSegment(ls.getID());
            relocSeg.tagIDWithEndpoint("E");
            lo.relocateSegmentOnTree(bp, relocSeg, dropID, null);
            return;
        }
        LinkSegmentID relocSeg = LinkSegmentID.buildIDForStartDrop();
        LayoutFailureTracker.considerFailureReport(linkID, reloc, bp);
        lo.relocateSegmentOnTree(bp, relocSeg, dropID, null);
    }

    private void generateColumnInfo(Set newLinks, Genome genome, Layout lo, Map posMap, Map negMap) {
        Iterator nlit = newLinks.iterator();
        while (nlit.hasNext()) {
            Double trgXPosObj;
            ArrayList<String> trgsForCol;
            NodeProperties trgProp;
            Point2D trgLoc;
            double trgXPos;
            String linkID = (String)nlit.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            String trgID = link.getTarget();
            NodeProperties srcProp = lo.getNodeProperties(srcID);
            Point2D srcLoc = srcProp.getLocation();
            double srcXPos = srcLoc.getX();
            Map useMap = srcXPos > (trgXPos = (trgLoc = (trgProp = lo.getNodeProperties(trgID)).getLocation()).getX()) ? negMap : posMap;
            TreeMap cols = (TreeMap)useMap.get(srcID);
            if (cols == null) {
                cols = srcXPos > trgXPos ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
                useMap.put(srcID, cols);
            }
            if ((trgsForCol = (ArrayList<String>)cols.get(trgXPosObj = new Double(trgXPos))) == null) {
                trgsForCol = new ArrayList<String>();
                cols.put(trgXPosObj, trgsForCol);
            }
            trgsForCol.add(linkID);
        }
    }

    private Point2D findSmallestLeap(String srcID, Genome genome, Layout lo, List col1, List col2, Point2D lastJump) {
        if (col1 == null) {
            Point2D minLocFromSrc = null;
            double minDist = Double.POSITIVE_INFINITY;
            NodeProperties srcProp = lo.getNodeProperties(srcID);
            Point2D srcLoc = srcProp.getLocation();
            int colSize = col2.size();
            for (int i = 0; i < colSize; ++i) {
                String linkID = (String)col2.get(i);
                Linkage link = genome.getLinkage(linkID);
                String trgID = link.getTarget();
                NodeProperties trgProp = lo.getNodeProperties(trgID);
                Point2D trgLoc = trgProp.getLocation();
                double distance = new Vector2D(srcLoc, trgLoc).length();
                if (!(distance < minDist)) continue;
                minLocFromSrc = trgLoc;
                minDist = distance;
            }
            return minLocFromSrc;
        }
        ArrayList<Point2D> minLocs = new ArrayList<Point2D>();
        double minDist = Double.POSITIVE_INFINITY;
        int col1Size = col1.size();
        for (int i = 0; i < col1Size; ++i) {
            String c1linkID = (String)col1.get(i);
            Linkage c1link = genome.getLinkage(c1linkID);
            String c1trgID = c1link.getTarget();
            NodeProperties c1trgProp = lo.getNodeProperties(c1trgID);
            Point2D c1trgLoc = c1trgProp.getLocation();
            int col2Size = col2.size();
            for (int j = 0; j < col2Size; ++j) {
                String c2linkID = (String)col2.get(j);
                Linkage c2link = genome.getLinkage(c2linkID);
                String c2trgID = c2link.getTarget();
                NodeProperties c2trgProp = lo.getNodeProperties(c2trgID);
                Point2D c2trgLoc = c2trgProp.getLocation();
                double distance = new Vector2D(c1trgLoc, c2trgLoc).length();
                if (distance < minDist) {
                    minLocs.clear();
                    minLocs.add(c2trgLoc);
                    minDist = distance;
                    continue;
                }
                if (distance != minDist) continue;
                minLocs.add(c2trgLoc);
            }
        }
        Point2D minLoc = null;
        int minSize = minLocs.size();
        minDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < minSize; ++i) {
            Point2D pt = (Point2D)minLocs.get(i);
            double distance = new Vector2D(lastJump, pt).length();
            if (!(distance < minDist)) continue;
            minLoc = pt;
            minDist = distance;
        }
        return minLoc;
    }

    private Point2D sortFromSmallestLeap(String srcID, Genome genome, Layout lo, List col1, List col2, Point2D lastJump, SortedSet results) {
        Point2D minLoc = this.findSmallestLeap(srcID, genome, lo, col1, col2, lastJump);
        int colSize = col2.size();
        for (int i = 0; i < colSize; ++i) {
            DistanceRank distRank;
            String linkID = (String)col2.get(i);
            Linkage link = genome.getLinkage(linkID);
            String trgID = link.getTarget();
            NodeProperties trgProp = lo.getNodeProperties(trgID);
            Point2D trgLoc = trgProp.getLocation();
            if (minLoc == null || trgLoc == null) {
                distRank = new DistanceRank(linkID, Double.POSITIVE_INFINITY);
                System.err.println("ERROR generating DistanceRank! minloc=" + minLoc + " trgloc=" + trgLoc + " c1=" + col1 + " c2 =" + col2);
            } else {
                double distance = new Vector2D(minLoc, trgLoc).length();
                distRank = new DistanceRank(linkID, distance);
            }
            results.add(distRank);
        }
        return minLoc;
    }

    private SortedMap sortAMap(String srcID, Genome genome, Layout lo, SortedMap theMap, boolean reverse) {
        TreeMap retval = reverse ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        List lastList = null;
        Point2D lastJump = null;
        Iterator tmkit = theMap.keySet().iterator();
        while (tmkit.hasNext()) {
            Double tmKey = (Double)tmkit.next();
            List trgs = (List)theMap.get(tmKey);
            TreeSet forCol = new TreeSet(Collections.reverseOrder());
            lastJump = this.sortFromSmallestLeap(srcID, genome, lo, lastList, trgs, lastJump, forCol);
            lastList = trgs;
            retval.put(tmKey, forCol);
        }
        return retval;
    }

    private double buildDummyRanking(SortedMap ordered, double startDummy, SortedSet result) {
        double dummyDistance = startDummy;
        Iterator okit = ordered.keySet().iterator();
        while (okit.hasNext()) {
            Double trgXPos = (Double)okit.next();
            TreeSet trgsForCol = (TreeSet)ordered.get(trgXPos);
            DistanceRank closestForCol = (DistanceRank)trgsForCol.last();
            DistanceRank dummyRank = new DistanceRank(closestForCol.id, dummyDistance);
            dummyDistance += 1.0;
            result.add(dummyRank);
            if (trgsForCol.size() <= 1) continue;
            Iterator tcit = trgsForCol.iterator();
            while (tcit.hasNext()) {
                DistanceRank drank = (DistanceRank)tcit.next();
                if (drank == closestForCol) continue;
                dummyRank = new DistanceRank(drank.id, dummyDistance);
                dummyDistance += 1.0;
                result.add(dummyRank);
            }
        }
        return dummyDistance;
    }

    private SortedSet mergeMapsForSource(SortedMap negOrdered, SortedMap posOrdered) {
        TreeSet retval = new TreeSet();
        double dummyDistance = 1.0;
        if (negOrdered != null) {
            dummyDistance = this.buildDummyRanking(negOrdered, dummyDistance, retval);
        }
        if (posOrdered != null) {
            dummyDistance = this.buildDummyRanking(posOrdered, dummyDistance, retval);
        }
        return retval;
    }

    private Map reorderByTargetCount(Map retval) {
        TreeMap byTrgCount = new TreeMap(Collections.reverseOrder());
        Iterator rvit = retval.keySet().iterator();
        while (rvit.hasNext()) {
            String srcID = (String)rvit.next();
            TreeSet forSource = (TreeSet)retval.get(srcID);
            DistanceRank rank = new DistanceRank(srcID, forSource.size());
            byTrgCount.put(rank, forSource);
        }
        return byTrgCount;
    }

    private List buildRecoveryForSourceOrder(LinkPlacementGrid.RecoveryDataForSource rdfs) {
        LinkSegmentID rootID = rdfs.getRootSeg();
        Map kidMap = rdfs.getSegmentToKidsMap();
        if (rootID == null) {
            ArrayList<String> retval = new ArrayList<String>();
            retval.add(rdfs.getDirectLinkID());
            return retval;
        }
        return this.recoveryForSourceOrderRecursion(rootID, kidMap, rdfs);
    }

    private List recoveryForSourceOrderRecursion(LinkSegmentID currID, Map kidMap, LinkPlacementGrid.RecoveryDataForSource rdfs) {
        ArrayList<String> retval = new ArrayList<String>();
        if (currID.isForEndDrop()) {
            retval.add(currID.getEndDropLinkRef());
            return retval;
        }
        Point2D currPt = rdfs.getPoint(currID);
        Set kidsOfCurr = (Set)kidMap.get(currID);
        Iterator kocit = kidsOfCurr.iterator();
        while (kocit.hasNext()) {
            LinkSegmentID kidID = (LinkSegmentID)kocit.next();
            List listOfKid = this.recoveryForSourceOrderRecursion(kidID, kidMap, rdfs);
            Point2D kidPt = rdfs.getPoint(kidID);
            if (currPt == null || kidPt == null) {
                retval.addAll(0, listOfKid);
                continue;
            }
            if (rdfs.getInboundOrtho(kidID)) {
                Vector2D toKid = new Vector2D(currPt, kidPt);
                if (!toKid.isCanonical()) {
                    retval.addAll(0, listOfKid);
                    continue;
                }
                retval.addAll(listOfKid);
                continue;
            }
            retval.addAll(listOfKid);
        }
        return retval;
    }

    private Map organizeLinks(Set newLinks, Genome genome, Layout lo, Map recoveryDataMap) {
        HashMap<String, SortedSet> retval = new HashMap<String, SortedSet>();
        if (recoveryDataMap != null) {
            Iterator rdmkit = recoveryDataMap.keySet().iterator();
            while (rdmkit.hasNext()) {
                String srcKey = (String)rdmkit.next();
                double dummyDist = 1.0;
                LinkPlacementGrid.RecoveryDataForSource rdfs = (LinkPlacementGrid.RecoveryDataForSource)recoveryDataMap.get(srcKey);
                rdfs.cleanup();
                List toList = this.buildRecoveryForSourceOrder(rdfs);
                TreeSet<DistanceRank> ordered = new TreeSet<DistanceRank>();
                retval.put(srcKey, ordered);
                int numTarg = toList.size();
                for (int i = 0; i < numTarg; ++i) {
                    String linkID = (String)toList.get(i);
                    if (!newLinks.contains(linkID)) continue;
                    DistanceRank dr = new DistanceRank(linkID, dummyDist);
                    dummyDist += 1.0;
                    ordered.add(dr);
                }
            }
            return this.reorderByTargetCount(retval);
        }
        HashMap posMap = new HashMap();
        HashMap negMap = new HashMap();
        this.generateColumnInfo(newLinks, genome, lo, posMap, negMap);
        HashSet srcKeys = new HashSet(posMap.keySet());
        srcKeys.addAll(negMap.keySet());
        Iterator skit = srcKeys.iterator();
        while (skit.hasNext()) {
            String srcID = (String)skit.next();
            SortedMap pMap = (SortedMap)posMap.get(srcID);
            SortedMap pOrdered = pMap == null ? null : this.sortAMap(srcID, genome, lo, pMap, false);
            SortedMap nMap = (SortedMap)negMap.get(srcID);
            SortedMap nOrdered = nMap == null ? null : this.sortAMap(srcID, genome, lo, nMap, true);
            SortedSet merged = this.mergeMapsForSource(nOrdered, pOrdered);
            retval.put(srcID, merged);
        }
        return this.reorderByTargetCount(retval);
    }

    private class DistanceRank
    implements Comparable {
        String id;
        double distance;

        DistanceRank(String id, double distance) {
            this.id = id;
            this.distance = distance;
        }

        public String toString() {
            return "DistRank: " + this.id + " " + this.distance;
        }

        public int compareTo(Object o) {
            DistanceRank other = (DistanceRank)o;
            double diff = this.distance - other.distance;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return this.id.compareTo(other.id);
        }
    }

    public static class RoutingResult {
        public int linkResult;
        public int colorResult;
        public String collisionSrc1;
        public String collisionSrc2;
        public HashSet failedLinks;

        public RoutingResult() {
            this.linkResult = 0;
            this.colorResult = 0;
            this.collisionSrc1 = null;
            this.collisionSrc2 = null;
            this.failedLinks = new HashSet();
        }

        public RoutingResult(int linkResult) {
            this.linkResult = linkResult;
            this.colorResult = 0;
            this.collisionSrc1 = null;
            this.collisionSrc2 = null;
            this.failedLinks = new HashSet();
        }

        public void merge(RoutingResult other) {
            this.linkResult |= other.linkResult;
            this.colorResult |= other.colorResult;
            this.collisionSrc1 = this.collisionSrc1 == null ? other.collisionSrc1 : this.collisionSrc1;
            this.collisionSrc2 = this.collisionSrc2 == null ? other.collisionSrc2 : this.collisionSrc2;
            this.failedLinks.addAll(other.failedLinks);
        }
    }
}

