/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class LinkSegment
implements Cloneable {
    public static final int NO_SHARED = 0;
    public static final int SHARED_STARTS = 1;
    public static final int THIS_START_OTHER_END_SHARED = 2;
    public static final int THIS_END_OTHER_START_SHARED = 3;
    private String id_;
    private String parent_;
    private Point2D start_;
    private Point2D end_;
    private Vector2D normal_;
    private Vector2D run_;
    private double length_;
    private SuggestedDrawStyle drawStyle_;

    public LinkSegment(LinkSegment current, boolean tossFirst) {
        this.id_ = current.id_;
        this.parent_ = current.parent_;
        this.start_ = tossFirst ? (Point2D)current.end_.clone() : (Point2D)current.start_.clone();
        this.end_ = null;
        if (current.drawStyle_ != null) {
            this.drawStyle_ = (SuggestedDrawStyle)current.drawStyle_.clone();
        }
        this.recalcVecs();
    }

    public LinkSegment(LinkSegment current, Point2D newStart) {
        this.id_ = current.id_;
        this.parent_ = current.parent_;
        this.start_ = (Point2D)newStart.clone();
        this.end_ = null;
        if (current.drawStyle_ != null) {
            this.drawStyle_ = (SuggestedDrawStyle)current.drawStyle_.clone();
        }
        this.recalcVecs();
    }

    public LinkSegment(LinkSegment first, LinkSegment second) {
        this.id_ = first.id_;
        this.parent_ = first.parent_;
        this.start_ = (Point2D)first.start_.clone();
        Point2D point2D = this.end_ = second.end_ == null ? null : (Point2D)second.end_.clone();
        this.drawStyle_ = first.drawStyle_ != null ? (SuggestedDrawStyle)first.drawStyle_.clone() : (second.drawStyle_ != null ? (SuggestedDrawStyle)second.drawStyle_.clone() : null);
        this.recalcVecs();
    }

    public LinkSegment(LinkSegment other) {
        this.id_ = other.id_;
        this.parent_ = other.parent_;
        this.start_ = (Point2D)other.start_.clone();
        Point2D point2D = this.end_ = other.end_ == null ? null : (Point2D)other.end_.clone();
        if (other.drawStyle_ != null) {
            this.drawStyle_ = (SuggestedDrawStyle)other.drawStyle_.clone();
        }
        this.recalcVecs();
    }

    public LinkSegment(String id, String parent, Point2D start, Point2D end) {
        this.id_ = id;
        this.parent_ = parent;
        this.start_ = (Point2D)start.clone();
        this.end_ = end == null ? null : (Point2D)end.clone();
        this.drawStyle_ = null;
        this.recalcVecs();
    }

    public LinkSegment(String id, String parent, Point2D start, Point2D end, String specialLine) throws IOException {
        this.id_ = id;
        this.parent_ = parent;
        this.start_ = (Point2D)start.clone();
        this.end_ = end == null ? null : (Point2D)end.clone();
        try {
            int style;
            if (specialLine != null && (style = LinkProperties.mapFromStyleTag(specialLine)) != -1) {
                this.drawStyle_ = SuggestedDrawStyle.buildFromLegacy(style);
            }
        }
        catch (IllegalArgumentException iaex) {
            throw new IOException();
        }
        this.recalcVecs();
    }

    public LinkSegment(Point2D start, Point2D end) {
        this.id_ = null;
        this.parent_ = null;
        this.start_ = (Point2D)start.clone();
        this.end_ = end == null ? null : (Point2D)end.clone();
        this.drawStyle_ = null;
        this.recalcVecs();
    }

    public LinkSegment(Point2D start, Point2D end, SuggestedDrawStyle drawStyle) {
        this.id_ = null;
        this.parent_ = null;
        this.start_ = (Point2D)start.clone();
        Point2D point2D = this.end_ = end == null ? null : (Point2D)end.clone();
        if (drawStyle != null) {
            this.drawStyle_ = (SuggestedDrawStyle)drawStyle.clone();
        }
        this.recalcVecs();
    }

    public Object clone() {
        try {
            LinkSegment retval = (LinkSegment)super.clone();
            retval.start_ = (Point2D)this.start_.clone();
            retval.end_ = this.end_ == null ? null : (Point2D)this.end_.clone();
            this.recalcVecs();
            if (this.drawStyle_ != null) {
                retval.drawStyle_ = (SuggestedDrawStyle)this.drawStyle_.clone();
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void setDrawStyle(SuggestedDrawStyle drawStyle) {
        this.drawStyle_ = drawStyle;
    }

    public double getNonOrthogonalArea() {
        if (this.end_ == null) {
            return 0.0;
        }
        return 0.5 * Math.abs((this.end_.getX() - this.start_.getX()) * (this.end_.getY() - this.start_.getY()));
    }

    public double getEndpointDistanceSum(LinkSegment other) {
        double distance = this.start_.distance(other.start_);
        if (this.end_ != null && other.end_ != null) {
            distance += this.end_.distance(other.end_);
        }
        return distance;
    }

    public boolean isSimpleTranslation(LinkSegment other, Vector2D translation) {
        boolean otherHasEnd;
        boolean iHaveEnd = this.end_ != null;
        boolean bl = otherHasEnd = other.end_ != null;
        if (iHaveEnd != otherHasEnd) {
            return false;
        }
        Point2D target = translation.add(this.start_);
        if (!target.equals(other.start_)) {
            return false;
        }
        if (!iHaveEnd) {
            return true;
        }
        target = translation.add(this.end_);
        return target.equals(other.end_);
    }

    public boolean isSimpleTranslation(LinkSegment other) {
        boolean otherHasEnd;
        boolean iHaveEnd = this.end_ != null;
        boolean bl = otherHasEnd = other.end_ != null;
        if (iHaveEnd != otherHasEnd) {
            return false;
        }
        if (!iHaveEnd) {
            return true;
        }
        return this.run_.equals(other.run_) && this.length_ == other.length_;
    }

    public boolean isSimpleScaling(LinkSegment other) {
        boolean otherHasEnd;
        boolean iHaveEnd = this.end_ != null;
        boolean bl = otherHasEnd = other.end_ != null;
        if (iHaveEnd != otherHasEnd) {
            return false;
        }
        if (!iHaveEnd) {
            return true;
        }
        return this.run_.equals(other.run_);
    }

    public double fractionOfRun(Point2D pt) {
        if (this.end_ == null) {
            return 0.0;
        }
        Vector2D toPt = new Vector2D(this.start_, pt);
        double normDot = toPt.dot(this.run_);
        return this.length_ == 0.0 ? 0.0 : normDot / this.length_;
    }

    public Point2D pointAtFraction(double fraction) {
        if (this.end_ == null) {
            return (Point2D)this.start_.clone();
        }
        Vector2D fracRun = new Vector2D(this.run_);
        fracRun.scale(this.length_);
        fracRun.scale(fraction);
        Point2D retval = fracRun.add(this.start_);
        UiUtil.forceToGrid(retval, 10.0);
        return retval;
    }

    public double getLength() {
        return this.length_;
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public Point2D getStart() {
        return this.start_;
    }

    public Point2D getEnd() {
        return this.end_;
    }

    public Vector2D getRun() {
        return this.run_;
    }

    public Vector2D getNormal() {
        return this.normal_;
    }

    public String getParent() {
        return this.parent_;
    }

    public void setParent(String parent) {
        this.parent_ = parent;
    }

    public SuggestedDrawStyle getSpecialDrawStyle() {
        return this.drawStyle_;
    }

    public boolean isDegenerate() {
        return this.end_ == null;
    }

    public boolean insideBox(Rectangle2D rect) {
        return this.insideShape(rect);
    }

    public boolean insideShape(Shape shape) {
        if (!shape.contains(this.start_)) {
            return false;
        }
        if (this.end_ != null) {
            return shape.contains(this.end_);
        }
        return true;
    }

    public boolean isOrthogonal() {
        if (this.end_ == null) {
            return true;
        }
        return this.end_.getX() == this.start_.getX() || this.end_.getY() == this.start_.getY();
    }

    public Double intersectsStart(Point2D pt, double tolerance) {
        return LinkSegment.intersectsEndpoint(this.start_, pt, tolerance);
    }

    public Double intersectsEnd(Point2D pt, double tolerance) {
        if (this.end_ == null) {
            return null;
        }
        return LinkSegment.intersectsEndpoint(this.end_, pt, tolerance);
    }

    public Double intersects(Point2D pt, double tolerance) {
        if (this.end_ == null) {
            throw new IllegalStateException();
        }
        if (this.end_.equals(this.start_)) {
            return this.intersectsStart(pt, tolerance);
        }
        Vector2D toPt = new Vector2D(this.start_, pt);
        double dot = this.normal_.dot(toPt);
        if (Math.abs(dot) > Math.abs(tolerance - 1.0E-6)) {
            return null;
        }
        double runDot = this.run_.dot(toPt);
        if (runDot < 0.0 || runDot > this.length_ + 1.0E-6) {
            return null;
        }
        return new Double(dot);
    }

    public boolean intersectsNonEndpoint(Point2D pt, double tolerance) {
        if (this.end_ == null) {
            throw new IllegalStateException();
        }
        Vector2D toPt = new Vector2D(this.start_, pt);
        double dot = this.normal_.dot(toPt);
        double abtolm = Math.abs(tolerance - 1.0E-6);
        if (Math.abs(dot) > abtolm) {
            return false;
        }
        double runDot = this.run_.dot(toPt);
        double abtolp = Math.abs(tolerance + 1.0E-6);
        return !(runDot < abtolm) && !(runDot > this.length_ - abtolp);
    }

    private Point2D generalSegmentOverlap(LinkSegment other, boolean allowEndpoints, boolean ignoreNonCanonical) {
        double x1 = this.start_.getX();
        double y1 = this.start_.getY();
        double x2 = this.end_.getX();
        double y2 = this.end_.getY();
        double x3 = other.start_.getX();
        double y3 = other.start_.getY();
        double x4 = other.end_.getX();
        double y4 = other.end_.getY();
        if (!(!ignoreNonCanonical || this.run_.isCanonical() && other.run_.isCanonical())) {
            return null;
        }
        double denom = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (Math.abs(denom) <= 1.0E-6) {
            return null;
        }
        double uaNum = (x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3);
        double ubNum = (x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3);
        double ua = uaNum / denom;
        double ub = ubNum / denom;
        if (ua < 0.0 || ua > 1.0 || ub < 0.0 || ub > 1.0) {
            return null;
        }
        if (!allowEndpoints) {
            if (Math.abs(ua) <= 1.0E-6) {
                return null;
            }
            if (Math.abs(ub) <= 1.0E-6) {
                return null;
            }
            if (Math.abs(1.0 - ua) <= 1.0E-6) {
                return null;
            }
            if (Math.abs(1.0 - ub) <= 1.0E-6) {
                return null;
            }
        }
        double px = x1 + ua * (x2 - x1);
        double py = y1 + ua * (y2 - y1);
        Point2D.Double retval = new Point2D.Double(px, py);
        UiUtil.forceToGrid(retval, 10.0);
        return retval;
    }

    private void nonSharedEndpointsOverlap(LinkSegment other, int okShared, OverlapResult result) {
        boolean startsMatch = this.intersectsStart(other.start_, 0.0) != null;
        boolean endsMatch = this.intersectsEnd(other.end_, 0.0) != null;
        boolean myStartOtherEndMatch = this.intersectsStart(other.end_, 0.0) != null;
        boolean myEndOtherStartMatch = this.intersectsEnd(other.start_, 0.0) != null;
        switch (okShared) {
            case 0: {
                if (startsMatch || myEndOtherStartMatch) {
                    result.myOverlapByStart = (Point2D)other.start_.clone();
                }
                if (endsMatch || myStartOtherEndMatch) {
                    result.myOverlapByEnd = (Point2D)other.end_.clone();
                }
                return;
            }
            case 1: {
                if (myEndOtherStartMatch) {
                    result.myOverlapByStart = (Point2D)other.start_.clone();
                }
                if (endsMatch || myStartOtherEndMatch) {
                    result.myOverlapByEnd = (Point2D)other.end_.clone();
                }
                return;
            }
            case 2: {
                if (startsMatch || myEndOtherStartMatch) {
                    result.myOverlapByStart = (Point2D)other.start_.clone();
                }
                if (endsMatch) {
                    result.myOverlapByEnd = (Point2D)other.end_.clone();
                }
                return;
            }
            case 3: {
                if (startsMatch) {
                    result.myOverlapByStart = (Point2D)other.start_.clone();
                }
                if (endsMatch || myStartOtherEndMatch) {
                    result.myOverlapByEnd = (Point2D)other.end_.clone();
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean checkDegenerateOverlap(LinkSegment other) {
        return this.end_ == null || other.end_ == null;
    }

    private OverlapResult degenerateOverlap(LinkSegment other, int okShared) {
        OverlapResult retval = new OverlapResult();
        if (this.end_ == null) {
            if (other.end_ == null) {
                switch (okShared) {
                    case 0: {
                        if (this.intersectsStart(other.start_, 0.0) != null) {
                            retval.myOverlapByStart = (Point2D)other.start_.clone();
                        }
                        return retval;
                    }
                    case 1: {
                        return retval;
                    }
                }
                throw new IllegalArgumentException();
            }
            switch (okShared) {
                case 0: {
                    if (other.intersects(this.start_, 0.0) != null) {
                        retval.otherOverlapByStart = (Point2D)this.start_.clone();
                    }
                    return retval;
                }
                case 1: {
                    if (other.intersectsNonEndpoint(this.start_, 0.0) || other.intersectsEnd(this.start_, 0.0) != null) {
                        retval.otherOverlapByStart = (Point2D)this.start_.clone();
                    }
                    return retval;
                }
                case 2: {
                    if (other.intersectsNonEndpoint(this.start_, 0.0) || other.intersectsStart(this.start_, 0.0) != null) {
                        retval.otherOverlapByStart = (Point2D)this.start_.clone();
                    }
                    return retval;
                }
            }
            throw new IllegalArgumentException();
        }
        if (other.end_ == null) {
            switch (okShared) {
                case 0: {
                    if (this.intersects(other.start_, 0.0) != null) {
                        retval.myOverlapByStart = (Point2D)other.start_.clone();
                    }
                    return retval;
                }
                case 1: {
                    if (this.intersectsNonEndpoint(other.start_, 0.0) || this.intersectsEnd(other.start_, 0.0) != null) {
                        retval.myOverlapByStart = (Point2D)other.start_.clone();
                    }
                    return retval;
                }
                case 3: {
                    if (this.intersectsNonEndpoint(other.start_, 0.0) || this.intersectsStart(other.start_, 0.0) != null) {
                        retval.myOverlapByStart = (Point2D)other.start_.clone();
                    }
                    return retval;
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalStateException();
    }

    public OverlapResult overlaps(LinkSegment other, int okShared) {
        Point2D ovp;
        if (this.checkDegenerateOverlap(other)) {
            OverlapResult retval = this.degenerateOverlap(other, okShared);
            return retval.haveEndpointOverlap() ? retval : null;
        }
        OverlapResult retval = new OverlapResult();
        if (this.intersectsNonEndpoint(other.start_, 0.0)) {
            retval.myOverlapByStart = (Point2D)other.start_.clone();
        }
        if (this.intersectsNonEndpoint(other.end_, 0.0)) {
            retval.myOverlapByEnd = (Point2D)other.end_.clone();
        }
        if (other.intersectsNonEndpoint(this.start_, 0.0)) {
            retval.otherOverlapByStart = (Point2D)this.start_.clone();
        }
        if (other.intersectsNonEndpoint(this.end_, 0.0)) {
            retval.otherOverlapByEnd = (Point2D)this.end_.clone();
        }
        this.nonSharedEndpointsOverlap(other, okShared, retval);
        if (!retval.haveEndpointOverlap() && (ovp = this.generalSegmentOverlap(other, false, true)) != null) {
            retval.nonEndOverlap = ovp;
        }
        return retval.haveAnyOverlap() ? retval : null;
    }

    public LinkSegment[] split(Point2D pt) {
        if (this.end_ == null) {
            throw new IllegalStateException();
        }
        Vector2D deltaS = new Vector2D(this.start_, pt);
        Vector2D deltaE = new Vector2D(this.end_, pt);
        if (deltaS.isZero() || deltaE.isZero()) {
            LinkSegment[] retval = new LinkSegment[]{this};
            return retval;
        }
        LinkSegment[] retval = new LinkSegment[2];
        retval[0] = new LinkSegment(this.start_, pt, this.drawStyle_);
        Point2D copy = (Point2D)pt.clone();
        retval[1] = new LinkSegment(copy, this.end_, this.drawStyle_);
        return retval;
    }

    public void setStart(Point2D newStrt) {
        this.start_ = newStrt;
        this.recalcVecs();
    }

    public void setEnd(Point2D newEnd) {
        this.end_ = newEnd;
        this.recalcVecs();
    }

    public void setBoth(Point2D newStrt, Point2D newEnd) {
        this.start_ = newStrt;
        this.end_ = newEnd;
        this.recalcVecs();
    }

    public void shiftStart(double dx, double dy) {
        this.start_.setLocation(this.start_.getX() + dx, this.start_.getY() + dy);
        this.recalcVecs();
    }

    public void shiftEnd(double dx, double dy) {
        this.end_.setLocation(this.end_.getX() + dx, this.end_.getY() + dy);
        this.recalcVecs();
    }

    public void shiftBoth(double dx, double dy) {
        this.start_.setLocation(this.start_.getX() + dx, this.start_.getY() + dy);
        if (this.end_ != null) {
            this.end_.setLocation(this.end_.getX() + dx, this.end_.getY() + dy);
        }
        this.recalcVecs();
    }

    public Point2D getClosestPoint(Point2D pt) {
        if (this.end_ == null || this.run_.isZero()) {
            return (Point2D)this.start_.clone();
        }
        Vector2D toPt = new Vector2D(this.start_, pt);
        double runDot = this.run_.dot(toPt);
        if (runDot < 0.0 || runDot > this.length_) {
            return null;
        }
        Vector2D offset = this.run_.scaled(runDot);
        return offset.add(this.start_);
    }

    public double getDistance(Point2D pt) {
        Point2D closest = this.getClosestPoint(pt);
        if (closest == null) {
            double toStart = new Vector2D(this.start_, pt).length();
            if (this.end_ == null) {
                return toStart;
            }
            double toEnd = new Vector2D(this.end_, pt).length();
            return toEnd < toStart ? toEnd : toStart;
        }
        return new Vector2D(closest, pt).length();
    }

    public String toString() {
        String dss = this.drawStyle_ != null ? this.drawStyle_.toString() : "(no Special Style)";
        return "LinkSegment: start = " + this.start_ + " end = " + this.end_ + " normal = " + this.normal_ + " run = " + this.run_ + " length = " + this.length_ + " id = " + this.id_ + " parent = " + this.parent_ + " specSty = " + dss;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<linkSegment ");
        if (this.id_ != null) {
            out.print("id=\"");
            out.print(this.id_);
            out.print("\" ");
        }
        if (this.parent_ != null) {
            out.print("parent=\"");
            out.print(this.parent_);
            out.print("\" ");
        }
        out.print("strtX=\"");
        out.print(this.start_.getX());
        out.print("\" strtY=\"");
        out.print(this.start_.getY());
        if (this.end_ != null) {
            out.print("\" endX=\"");
            out.print(this.end_.getX());
            out.print("\" endY=\"");
            out.print(this.end_.getY());
        }
        if (this.drawStyle_ != null) {
            out.println("\" >");
            ind.up();
            this.drawStyle_.writeXML(out, ind);
            ind.down().indent();
            out.println("</linkSegment>");
        } else {
            out.println("\" />");
        }
    }

    public static Double intersectsEndpoint(Point2D endpoint, Point2D point, double tolerance) {
        double distance = endpoint.distance(point);
        return distance <= tolerance ? new Double(distance) : null;
    }

    private void recalcVecs() {
        if (this.end_ != null) {
            this.run_ = new Vector2D(this.start_, this.end_);
            this.length_ = this.run_.length();
            this.run_ = this.run_.normalized();
            this.normal_ = this.run_.normal();
        } else {
            this.run_ = null;
            this.length_ = 0.0;
            this.normal_ = null;
        }
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            LinkSegment segment = board.linkSegment;
            SuggestedDrawStyle suggSty = board.suggSty;
            segment.setDrawStyle(suggSty);
            return null;
        }
    }

    public static class LinkSegmentWorker
    extends AbstractFactoryClient {
        public LinkSegmentWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("linkSegment");
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            LinkSegment retval = null;
            if (elemName.equals("linkSegment")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.linkSegment = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private LinkSegment buildFromXML(String elemName, Attributes attrs) throws IOException {
            Point2D.Float end;
            float sy;
            float sx;
            String strtX = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "strtX", true);
            String strtY = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "strtY", true);
            String endX = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "endX", false);
            String endY = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "endY", false);
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "id", false);
            String parent = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "parent", false);
            String specialLine = AttributeExtractor.extractAttribute(elemName, attrs, "linkSegment", "specialLine", false);
            if (endX == null && endY != null || endX != null && endY == null) {
                throw new IOException();
            }
            float ex = 0.0f;
            float ey = 0.0f;
            try {
                sx = Float.parseFloat(strtX);
                sy = Float.parseFloat(strtY);
                if (endX != null) {
                    ex = Float.parseFloat(endX);
                    ey = Float.parseFloat(endY);
                }
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            Point2D.Float start = new Point2D.Float(sx, sy);
            Point2D.Float float_ = end = endX != null ? new Point2D.Float(ex, ey) : null;
            if (id == null && parent == null && specialLine == null) {
                return new LinkSegment(start, (Point2D)end);
            }
            return new LinkSegment(id, parent, start, end, specialLine);
        }
    }

    public static class OverlapResult {
        public Point2D myOverlapByStart;
        public Point2D myOverlapByEnd;
        public Point2D otherOverlapByStart;
        public Point2D otherOverlapByEnd;
        public Point2D nonEndOverlap;

        public boolean haveEndpointOverlap() {
            return this.myOverlapByStart != null || this.myOverlapByEnd != null || this.otherOverlapByStart != null || this.otherOverlapByEnd != null;
        }

        public boolean haveAnyOverlap() {
            return this.haveEndpointOverlap() || this.nonEndOverlap != null;
        }
    }
}

