/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

public class LinkSegmentID
implements Cloneable,
Comparable {
    public static final String START = "S";
    public static final String END = "E";
    public static final int START_DROP = 0;
    public static final int END_DROP = 1;
    public static final int DIRECT_LINK = 2;
    public static final int SEGMENT = 3;
    private boolean isLink;
    private boolean isOnly;
    private String label;
    private String endID;

    private LinkSegmentID(boolean isLink, boolean isOnly, String label, String endID) {
        this.isLink = isLink;
        this.isOnly = isOnly;
        this.label = label;
        this.endID = endID;
    }

    public LinkSegmentID(LinkSegmentID other) {
        this.isLink = other.isLink;
        this.isOnly = other.isOnly;
        this.label = other.label;
        this.endID = other.endID;
    }

    public Object clone() {
        try {
            LinkSegmentID retval = (LinkSegmentID)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "isLink = " + this.isLink + "isOnly = " + this.isOnly + " label = " + this.label + " endID = " + this.endID;
    }

    public int hashCode() {
        int linkInc = this.isLink ? 0 : 1;
        int onlyInc = this.isOnly ? 0 : 1;
        return this.label == null ? linkInc + onlyInc : this.label.hashCode() + linkInc + onlyInc;
    }

    public boolean isForDrop() {
        return !this.isLink;
    }

    public boolean isForSegment() {
        return this.isLink;
    }

    public boolean isForEndDrop() {
        return !this.isLink && !this.isOnly && this.label != null;
    }

    public boolean isForStartDrop() {
        return !this.isLink && !this.isOnly && this.label == null;
    }

    public String getLinkSegTag() {
        if (!this.isLink) {
            throw new IllegalStateException();
        }
        return this.label;
    }

    public String getEndDropLinkRef() {
        if (!this.isForEndDrop()) {
            throw new IllegalStateException();
        }
        return this.label;
    }

    public String getDirectLinkRef() {
        if (!this.isDirect()) {
            throw new IllegalStateException();
        }
        return this.label;
    }

    public boolean isDirect() {
        return this.isOnly;
    }

    public void clearTaggedEndpoint() {
        this.endID = null;
    }

    public boolean isTaggedWithEndpoint() {
        return this.endID != null;
    }

    public boolean startEndpointIsTagged() {
        return this.endID != null && this.endID.equals(START);
    }

    public boolean endEndpointIsTagged() {
        return this.endID != null && this.endID.equals(END);
    }

    public boolean isDirectOrEndDropForTarget(String ref) {
        return (this.isForEndDrop() || this.isDirect()) && this.label != null && this.label.equals(ref);
    }

    public boolean isDirectOrEndDrop() {
        return this.isForEndDrop() || this.isDirect();
    }

    public boolean isBusNodeConnection() {
        return this.isOnly && this.endID != null || !this.isLink && this.label == null && this.endID != null && this.endID.equals(START) || !this.isLink && this.label != null && !this.label.equals(END) && this.endID != null && this.endID.equals(END);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof LinkSegmentID)) {
            return false;
        }
        LinkSegmentID otherSI = (LinkSegmentID)other;
        if (this.isLink != otherSI.isLink) {
            return false;
        }
        if (this.isOnly != otherSI.isOnly) {
            return false;
        }
        if (this.label == null) {
            return otherSI.label == null;
        }
        return this.label.equals(otherSI.label);
    }

    public int compareTo(Object o) {
        LinkSegmentID other = (LinkSegmentID)o;
        if (this.isOnly != other.isOnly) {
            return this.isOnly ? -1 : 1;
        }
        if (this.isOnly && other.isOnly) {
            return 0;
        }
        if (this.isLink != other.isLink) {
            return this.isLink ? -1 : 1;
        }
        if (this.label == null) {
            return other.label == null ? 0 : 1;
        }
        if (other.label == null) {
            return -1;
        }
        return this.label.compareTo(other.label);
    }

    public void tagIDWithEndpoint(String endID) {
        this.endID = endID;
    }

    public static LinkSegmentID buildIDForType(String idTag, int type) {
        switch (type) {
            case 0: {
                return LinkSegmentID.buildIDForStartDrop();
            }
            case 1: {
                return LinkSegmentID.buildIDForEndDrop(idTag);
            }
            case 2: {
                return LinkSegmentID.buildIDForDirect(idTag);
            }
            case 3: {
                return LinkSegmentID.buildIDForSegment(idTag);
            }
        }
        throw new IllegalArgumentException();
    }

    public static LinkSegmentID buildIDForSegment(String segID) {
        return new LinkSegmentID(true, false, segID, null);
    }

    public static LinkSegmentID buildIDForDirect(String linkRef) {
        if (linkRef == null) {
            throw new IllegalArgumentException();
        }
        return new LinkSegmentID(false, true, linkRef, null);
    }

    public static LinkSegmentID buildIDForEndDrop(String linkRef) {
        if (linkRef == null) {
            throw new IllegalArgumentException();
        }
        return new LinkSegmentID(false, false, linkRef, null);
    }

    public static LinkSegmentID buildIDForDrop(String linkRef) {
        return new LinkSegmentID(false, false, linkRef, null);
    }

    public static LinkSegmentID buildIDForStartDrop() {
        return new LinkSegmentID(false, false, null, null);
    }
}

