/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.ModelImagePresentation;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class ModelImagePanel
extends JPanel {
    private ModelImagePresentation myImagePre_ = new ModelImagePresentation();
    private JFrame parent_;
    private AffineTransform transform_;

    public ModelImagePanel(JFrame parent) {
        this.setBackground(Color.white);
        this.parent_ = parent;
        this.transform_ = new AffineTransform();
    }

    public void setImage(BufferedImage bi) {
        this.myImagePre_.setImage(bi);
    }

    public void paintComponent(Graphics g) {
        try {
            this.transform_.setToIdentity();
            Rectangle rect = this.myImagePre_.getRequiredSize();
            Rectangle2D.Double finalRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
            Dimension currentSize = this.getSize();
            double wZoom = (double)currentSize.width / ((RectangularShape)finalRect).getWidth();
            double hZoom = (double)currentSize.height / ((RectangularShape)finalRect).getHeight();
            double zoom = (wZoom > hZoom ? hZoom : wZoom) / 1.5;
            this.transform_.translate((double)currentSize.width / 2.0, (double)currentSize.height / 2.0);
            this.transform_.scale(zoom, zoom);
            double centerX = ((RectangularShape)finalRect).getX() + ((RectangularShape)finalRect).getWidth() / 2.0;
            double centerY = ((RectangularShape)finalRect).getY() + ((RectangularShape)finalRect).getHeight() / 2.0;
            this.transform_.translate(-centerX, -centerY);
            super.paintComponent(g);
            this.drawingGuts(g, this.transform_);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayPaintException(ex);
        }
    }

    private void drawingGuts(Graphics g, AffineTransform useTrans) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.myImagePre_.presentImage(g2, useTrans);
    }
}

