/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.util.DoubMinMax;
import org.systemsbiology.biotapestry.util.PatternPaint;

public abstract class MultiStripChart
extends JPanel {
    public static final int REGULAR = 0;
    public static final int DISQUALIFIED = 1;
    public static final int CALLED_OUT = 2;
    public static final int SOLID_PATTERN = 0;
    public static final int HATCHED_PATTERN = 1;
    public static final int OUTLINE_PATTERN = 2;
    public static final int DOT_PATTERN = 3;
    public static final int COVERAGE_ALL = 0;
    public static final int COVERAGE_LIMITED = 1;
    private static final int NUM_COVERAGE_ = 2;
    protected static final int STRIP_SIZE_ = 16;
    protected static final int STRIPE_SIZE_ = 4;
    protected static final int STRIPE_OFFSET_ = 6;
    protected static final int BUFFER_SIZE_ = 8;
    protected static final int ROW_DELTA_ = 24;
    protected static final int VERTICAL_MARGIN_ = 20;
    protected static final double HEIGHT_HACK_ = 0.75;
    protected List allStrips_ = new ArrayList();
    protected List prunedStrips_ = new ArrayList();
    protected Color vlg_;
    protected FontRenderContext frc_;
    protected Dimension dimForCache_;
    protected ChartTransform transform_;
    protected int coverage_ = 0;

    public MultiStripChart() {
        this.setBackground(Color.white);
        this.vlg_ = new Color(242, 221, 170);
        this.frc_ = new FontRenderContext(new AffineTransform(), true, true);
        this.transform_ = null;
        this.dimForCache_ = null;
    }

    public String getToolTipText(MouseEvent event) {
        double worldX;
        Point tipPoint = event.getPoint();
        int size = this.useStrips().size();
        int minY = 20;
        int ptY = tipPoint.y;
        int ptX = tipPoint.x;
        Dimension dim = this.getSize();
        if (this.dimForCache_ == null || !this.dimForCache_.equals(dim)) {
            this.refreshSizeBasedCache(dim);
        }
        if (this.childRejectTip(worldX = this.convertFromScreenX(ptX, this.transform_))) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            int maxY = minY + 16;
            if (ptY >= minY && ptY <= maxY) {
                Strip intersect = (Strip)this.useStrips().get(i);
                List elem = intersect.elements;
                int elemSize = elem.size();
                for (int j = 0; j < elemSize; ++j) {
                    StripElement se = (StripElement)elem.get(j);
                    if (!(worldX >= se.min) || !(worldX <= se.max)) continue;
                    return se.tipText;
                }
                return null;
            }
            minY = maxY + 8;
        }
        return null;
    }

    public void setCoverage(int coverage) {
        this.coverage_ = coverage;
        this.dimForCache_ = null;
        this.invalidate();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawingGuts(g2);
    }

    public void setStrips(List strips, List prunedStrips) {
        this.dimForCache_ = null;
        this.allStrips_.clear();
        this.allStrips_.addAll(strips);
        this.prunedStrips_.clear();
        this.prunedStrips_.addAll(prunedStrips);
        this.invalidate();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int width = 400;
        int stripSize = this.useStrips().size();
        stripSize = stripSize == 0 ? 1 : stripSize;
        int height = 24 * stripSize + 40;
        return new Dimension(width, height);
    }

    protected List useStrips() {
        return this.coverage_ == 0 ? this.allStrips_ : this.prunedStrips_;
    }

    protected abstract boolean childRejectTip(double var1);

    protected abstract ChartTransform childRefresh(Font var1, Dimension var2);

    protected void refreshSizeBasedCache(Dimension dim) {
        Font mFont = FontManager.getMgr().getFixedFont(2);
        this.transform_ = this.childRefresh(mFont, dim);
        this.dimForCache_ = dim;
    }

    protected void drawingGuts(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Dimension dim = this.getSize();
        if (this.dimForCache_ == null || !this.dimForCache_.equals(dim)) {
            this.refreshSizeBasedCache(dim);
        }
    }

    protected void drawAllStrips(Graphics2D g2, Dimension dim, DoubMinMax range) {
        BasicStroke ghostStroke = new BasicStroke(1.0f, 2, 0);
        int numRows = this.useStrips().size();
        int yDisp = numRows - 1;
        for (int i = 0; i < numRows; ++i) {
            Strip strip = (Strip)this.useStrips().get(yDisp);
            this.drawStrip(g2, yDisp--, dim.height, strip, range, this.transform_, ghostStroke);
        }
    }

    protected void drawStrip(Graphics2D g2, int row, int height, Strip strip, DoubMinMax displayRange, ChartTransform transform, BasicStroke ghostStroke) {
        int numElem = strip.elements.size();
        int y = 20 + row * 24;
        int stripMinX = Integer.MAX_VALUE;
        int stripMaxX = Integer.MIN_VALUE;
        int stripMinY = y;
        int stripMaxY = y + 16;
        int drawnElem = 0;
        for (int i = 0; i < numElem; ++i) {
            boolean doFill;
            StripElement se = (StripElement)strip.elements.get(i);
            Color drawColor = se.color;
            Paint usePaint = null;
            switch (se.pattern) {
                case 0: {
                    usePaint = drawColor;
                    doFill = true;
                    break;
                }
                case 1: {
                    usePaint = new PatternPaint(1, drawColor);
                    doFill = true;
                    break;
                }
                case 3: {
                    usePaint = new PatternPaint(2, drawColor);
                    doFill = true;
                    break;
                }
                case 2: {
                    usePaint = drawColor;
                    doFill = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            g2.setPaint(usePaint);
            double showMin = se.min < displayRange.min ? displayRange.min : se.min;
            double showMax = se.max > displayRange.max ? displayRange.max : se.max;
            int minX = this.convertToScreenX(showMin, transform);
            int maxX = this.convertToScreenX(showMax, transform);
            int width = maxX - minX;
            if (width <= 0) continue;
            ++drawnElem;
            if (minX < stripMinX) {
                stripMinX = minX;
            }
            if (maxX > stripMaxX) {
                stripMaxX = maxX;
            }
            if (doFill) {
                g2.fillRect(minX, y, width, 16);
            } else {
                g2.setStroke(ghostStroke);
                g2.drawRect(minX, y, width, 16);
            }
            if (se.stripeColor != null) {
                g2.setPaint(se.stripeColor);
                g2.fillRect(minX, y + 6, width, 4);
            }
            if (se.decoration == 1) {
                g2.setPaint(Color.black);
                g2.drawLine(minX, y, maxX, y + 16);
                g2.drawLine(minX, y + 16, maxX, y);
                continue;
            }
            if (se.decoration != 2) continue;
            g2.setPaint(Color.black);
            g2.drawRect(minX, y, width - 1, 16);
        }
        if (drawnElem > 0) {
            g2.setPaint(Color.black);
            Font mFont = FontManager.getMgr().getFixedFont(1);
            Rectangle2D bounds = mFont.getStringBounds(strip.name, this.frc_);
            double tWidth = bounds.getWidth();
            double tHeight = bounds.getHeight() * 0.75;
            double x = (double)(stripMaxX + stripMinX) / 2.0 - tWidth / 2.0;
            double by = (double)(stripMaxY + stripMinY) / 2.0 + tHeight / 2.0;
            g2.setFont(mFont);
            g2.drawString(strip.name, (float)x, (float)by);
        }
    }

    protected int convertToScreenX(double xWorld, ChartTransform transform) {
        double xScr = (xWorld - transform.worldMin) * transform.slope + transform.screenMin;
        return Math.round((float)xScr);
    }

    protected double convertFromScreenX(int xScreen, ChartTransform transform) {
        double xWorld = ((double)xScreen - transform.screenMin) / transform.slope + transform.worldMin;
        return xWorld;
    }

    protected class ChartTransform {
        protected double screenMin;
        protected double worldMin;
        protected double slope;

        protected ChartTransform(double slope, int screenMin, double worldMin) {
            this.screenMin = screenMin;
            this.worldMin = worldMin;
            this.slope = slope;
        }
    }

    public static class StripElement {
        public double min;
        public double max;
        public Color color;
        public Color stripeColor;
        public int pattern;
        public String tipText;
        public int decoration;

        public StripElement(double min, double max, Color color, int pattern, String tipText, int decoration) {
            this.min = min;
            this.max = max;
            this.color = color;
            this.stripeColor = null;
            this.pattern = pattern;
            this.tipText = tipText;
            this.decoration = decoration;
        }

        public StripElement(double min, double max, Color color, Color stripeColor, String tipText, int decoration) {
            this.min = min;
            this.max = max;
            this.color = color;
            this.pattern = 0;
            this.stripeColor = stripeColor;
            this.tipText = tipText;
            this.decoration = decoration;
        }
    }

    public static class Strip {
        public List elements;
        public String name;

        public Strip(String name, List elements) {
            this.name = name;
            this.elements = elements;
        }
    }
}

