/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.ui.MultiStripChart;
import org.systemsbiology.biotapestry.util.DoubMinMax;

public class MultiStripGenericChart
extends MultiStripChart {
    private static final int MARGIN_ = 30;
    protected DoubMinMax bounds_ = new DoubMinMax(0.0, 100.0);

    public void setCoverage(int coverage) {
        this.coverage_ = coverage;
        this.boundsCalc();
        super.setCoverage(coverage);
    }

    public void setStrips(List strips, List prunedStrips) {
        super.setStrips(strips, prunedStrips);
        this.boundsCalc();
    }

    protected boolean childRejectTip(double worldX) {
        return false;
    }

    protected MultiStripChart.ChartTransform childRefresh(Font mFont, Dimension dim) {
        return this.buildTransform(this.bounds_, dim);
    }

    protected void drawingGuts(Graphics2D g2) {
        super.drawingGuts(g2);
        Dimension dim = this.getSize();
        this.drawAllStrips(g2, dim, this.bounds_);
    }

    private void boundsCalc() {
        int size = this.useStrips().size();
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            MultiStripChart.Strip intersect = (MultiStripChart.Strip)this.useStrips().get(i);
            List elem = intersect.elements;
            int elemSize = elem.size();
            for (int j = 0; j < elemSize; ++j) {
                MultiStripChart.StripElement se = (MultiStripChart.StripElement)elem.get(j);
                if (se.min < minX) {
                    minX = se.min;
                }
                if (!(se.max > maxX)) continue;
                maxX = se.max;
            }
        }
        this.bounds_ = size == 0 ? new DoubMinMax(0.0, 100.0) : new DoubMinMax(minX, maxX);
    }

    private MultiStripChart.ChartTransform buildTransform(DoubMinMax bounds, Dimension dim) {
        double slope = (double)(dim.width - 60) / (bounds.max - bounds.min);
        return new MultiStripChart.ChartTransform(slope, 30, bounds.min);
    }

    public static void main(String[] argv) {
        MultiStripGenericChart msc = new MultiStripGenericChart();
        ArrayList<MultiStripChart.Strip> strips = new ArrayList<MultiStripChart.Strip>();
        ArrayList<MultiStripChart.StripElement> elements = new ArrayList<MultiStripChart.StripElement>();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.red, 0, null, 0));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.red, 0, null, 0));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.gray, 0, null, 0));
        strips.add(new MultiStripChart.Strip("Krox MASO -> eve", elements));
        elements = new ArrayList();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.gray, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.blue, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.blue, 0, null, 1));
        strips.add(new MultiStripChart.Strip("Krox-En -> eve", elements));
        msc.setStrips(strips, strips);
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(msc);
        frame.pack();
        frame.setSize(new Dimension(300, 400));
        frame.show();
    }
}

