/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.MultiStripChart;
import org.systemsbiology.biotapestry.util.DoubMinMax;
import org.systemsbiology.biotapestry.util.PatternPaint;
import org.systemsbiology.biotapestry.util.UiUtil;

public class MultiStripTimeAxisChart
extends MultiStripChart {
    private static final int AXIS_SIZE_ = 10;
    private static final int AXIS_MARGIN_ = 30;
    private static final int TIC_PADDING_ = 40;
    private int[] ticCandidates_ = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 20, 25, 30, 40, 50, 100, 150, 200, 250, 500, 1000};
    private TimeBounds dataTimeRange_ = new TimeBounds(0, 1, "");
    private TimeBounds focusTimeRange_ = new TimeBounds(0, 1, "");
    private Axis axis_ = null;

    public void setDataTimeRange(TimeBounds tr) {
        this.dimForCache_ = null;
        this.dataTimeRange_ = tr;
    }

    public void setFocusTimeRange(TimeBounds tr) {
        this.focusTimeRange_ = tr;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height += 10;
        return dim;
    }

    protected boolean childRejectTip(double worldX) {
        DoubMinMax dmm = this.axis_.bounds.getDoubleBounds();
        return worldX < dmm.min || worldX > dmm.max;
    }

    protected MultiStripChart.ChartTransform childRefresh(Font mFont, Dimension dim) {
        this.axis_ = this.axisCalc(mFont, this.frc_, this.dataTimeRange_, dim);
        MultiStripChart.ChartTransform transform = this.buildTransform(this.axis_.bounds.getDoubleBounds(), dim);
        return transform;
    }

    protected void drawingGuts(Graphics2D g2) {
        super.drawingGuts(g2);
        BasicStroke selectedStroke = new BasicStroke(1.0f, 0, 1);
        Dimension dim = this.getSize();
        this.drawDataFocus(g2, this.transform_, this.axis_.bounds, dim, selectedStroke, this.focusTimeRange_);
        this.drawAllStrips(g2, dim, this.axis_.bounds.getDoubleBounds());
        this.drawAxis(g2, this.transform_, this.axis_, dim, selectedStroke);
    }

    private void drawAxis(Graphics2D g2, MultiStripChart.ChartTransform transform, Axis axis, Dimension dim, BasicStroke selectedStroke) {
        Font mFont = FontManager.getMgr().getFixedFont(2);
        GeneralPath path = new GeneralPath();
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        boolean isSuffix = tad.unitsAreASuffix();
        int x1 = 30;
        int x2 = dim.width - 30;
        int y1 = dim.height - 20 - 10;
        int y2 = 12;
        path.moveTo(x1, y1);
        path.lineTo(x2, y1);
        path.lineTo(x2, y2);
        path.lineTo(x1, y2);
        path.closePath();
        g2.setStroke(selectedStroke);
        g2.setPaint(Color.black);
        g2.setFont(mFont);
        g2.draw(path);
        StringBuffer ticBuf = new StringBuffer();
        double labY = Double.NEGATIVE_INFINITY;
        int ticLen = 5;
        for (double currTic = axis.bounds.getMinDouble(); currTic <= axis.bounds.getMaxDouble(); currTic += (double)axis.tic) {
            int ticX = this.convertToScreenX(currTic, transform);
            path.moveTo(ticX, y1);
            path.lineTo(ticX, y1 + ticLen);
            g2.draw(path);
            double floor = Math.floor(currTic);
            String ticString = null;
            if (tad.haveNamedStages()) {
                int ticIndex;
                if (floor == currTic && tad.haveNamedStageForIndex(ticIndex = (int)floor)) {
                    ticString = tad.getNamedStageForIndex((int)ticIndex).name;
                }
            } else {
                String string = ticString = floor == currTic ? Long.toString((long)floor) : Double.toString(currTic);
            }
            if (ticString == null) continue;
            ticBuf.setLength(0);
            if (!isSuffix) {
                ticBuf.append(axis.bounds.getUnits());
                ticBuf.append(" ");
            }
            ticBuf.append(ticString);
            if (isSuffix) {
                ticBuf.append(" ");
                ticBuf.append(axis.bounds.getUnits());
            }
            ticString = ticBuf.toString();
            Rectangle2D bounds = mFont.getStringBounds(ticString, this.frc_);
            double tWidth = bounds.getWidth();
            double labX = (double)ticX - tWidth / 2.0;
            if (labY == Double.NEGATIVE_INFINITY) {
                double tHeight = bounds.getHeight() * 0.75;
                labY = (double)(y1 + 10) + tHeight;
            }
            g2.drawString(ticString, (float)labX, (float)labY);
        }
    }

    private void drawDataFocus(Graphics2D g2, MultiStripChart.ChartTransform transform, TimeBounds displayRange, Dimension dim, BasicStroke selectedStroke, TimeBounds focusRange) {
        GeneralPath path = new GeneralPath();
        int x1 = 30;
        int x2 = dim.width - 30;
        int y1 = dim.height - 20 - 10;
        int y2 = 12;
        g2.setStroke(selectedStroke);
        g2.setPaint(new PatternPaint(0, this.vlg_));
        if (focusRange.getMinDouble() > displayRange.getMinDouble()) {
            int minX = this.convertToScreenX(focusRange.getMinDouble(), transform);
            path.moveTo(x1, y1);
            path.lineTo(minX, y1);
            path.lineTo(minX, y2);
            path.lineTo(x1, y2);
            path.closePath();
            g2.fill(path);
        }
        if (focusRange.getMaxDouble() < displayRange.getMaxDouble()) {
            int maxX = this.convertToScreenX(focusRange.getMaxDouble(), transform);
            path.reset();
            path.moveTo(maxX, y1);
            path.lineTo(x2, y1);
            path.lineTo(x2, y2);
            path.lineTo(maxX, y2);
            path.closePath();
            g2.fill(path);
        }
    }

    private Axis axisCalc(Font mFont, FontRenderContext frc, TimeBounds dataBounds, Dimension dim) {
        int ticVal;
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        String biggestLabel = "";
        if (tad.haveNamedStages()) {
            int maxLen = Integer.MIN_VALUE;
            List names = tad.getNamedStages();
            int numNames = names.size();
            for (int i = dataBounds.getMin(); i <= dataBounds.getMax(); ++i) {
                String nextStage;
                int nsLen;
                if (!tad.haveNamedStageForIndex(i) || (nsLen = (nextStage = tad.getNamedStageForIndex((int)i).name).length()) <= maxLen) continue;
                maxLen = nsLen;
                biggestLabel = nextStage;
            }
        } else {
            double currTic = dataBounds.getMaxDouble();
            double floor = Math.floor(dataBounds.getMaxDouble());
            biggestLabel = floor == dataBounds.getMaxDouble() ? Long.toString((long)floor) : Double.toString(dataBounds.getMaxDouble());
        }
        boolean isSuffix = tad.unitsAreASuffix();
        StringBuffer ticBuf = new StringBuffer();
        ticBuf.setLength(0);
        if (!isSuffix) {
            ticBuf.append(dataBounds.getUnits());
            ticBuf.append(" ");
        }
        ticBuf.append(biggestLabel);
        if (isSuffix) {
            ticBuf.append(" ");
            ticBuf.append(dataBounds.getUnits());
        }
        biggestLabel = ticBuf.toString();
        Rectangle2D bounds = mFont.getStringBounds(biggestLabel, frc);
        double tWidth = bounds.getWidth();
        double workingWidth = (double)(dim.width - 60) - (tWidth += 40.0);
        int maxTics = (int)Math.floor(workingWidth / tWidth);
        double axisDelta = dataBounds.getMaxDouble() - dataBounds.getMinDouble();
        TreeMap<Double, TreeSet<Integer>> ticsPerRemainder = new TreeMap<Double, TreeSet<Integer>>();
        int numCandidates = this.ticCandidates_.length;
        for (int i = 0; i < numCandidates; ++i) {
            int ticCand = this.ticCandidates_[i];
            double floorTic = UiUtil.forceToGridValueMin(dataBounds.getMinDouble(), ticCand);
            double ceilTic = UiUtil.forceToGridValueMax(dataBounds.getMaxDouble(), ticCand);
            double axisFullDelta = ceilTic - floorTic;
            int numTics = (int)axisFullDelta / ticCand;
            if (numTics > maxTics) continue;
            double deltaDiff = axisFullDelta - axisDelta;
            Double deltaKey = new Double(deltaDiff);
            TreeSet<Integer> set = (TreeSet<Integer>)ticsPerRemainder.get(deltaKey);
            if (set == null) {
                set = new TreeSet<Integer>();
                ticsPerRemainder.put(deltaKey, set);
            }
            set.add(new Integer(ticCand));
        }
        Double lokey = (Double)ticsPerRemainder.firstKey();
        if (lokey == null) {
            ticVal = this.ticCandidates_[this.ticCandidates_.length - 1];
        } else {
            TreeSet set = (TreeSet)ticsPerRemainder.get(lokey);
            Integer firstTic = (Integer)set.first();
            ticVal = firstTic;
        }
        double axisFloor = UiUtil.forceToGridValueMin(dataBounds.getMinDouble(), ticVal);
        double axisCeil = UiUtil.forceToGridValueMax(dataBounds.getMaxDouble(), ticVal);
        TimeBounds axisBounds = new TimeBounds((int)axisFloor, (int)axisCeil, dataBounds.getUnits());
        Axis retval = new Axis(axisBounds, ticVal);
        return retval;
    }

    private MultiStripChart.ChartTransform buildTransform(DoubMinMax bounds, Dimension dim) {
        double slope = (double)(dim.width - 60) / (bounds.max - bounds.min);
        return new MultiStripChart.ChartTransform(slope, 30, bounds.min);
    }

    public static void main(String[] argv) {
        MultiStripTimeAxisChart msc = new MultiStripTimeAxisChart();
        ArrayList<MultiStripChart.Strip> strips = new ArrayList<MultiStripChart.Strip>();
        ArrayList<MultiStripChart.StripElement> elements = new ArrayList<MultiStripChart.StripElement>();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.red, 0, null, 0));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.red, 0, null, 0));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.gray, 0, null, 0));
        strips.add(new MultiStripChart.Strip("Krox MASO -> eve", elements));
        elements = new ArrayList();
        elements.add(new MultiStripChart.StripElement(12.0, 16.0, Color.gray, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(17.0, 21.0, Color.blue, 0, null, 1));
        elements.add(new MultiStripChart.StripElement(23.0, 28.0, Color.blue, 0, null, 1));
        strips.add(new MultiStripChart.Strip("Krox-En -> eve", elements));
        msc.setStrips(strips, strips);
        TimeBounds focusTimes = new TimeBounds(18, 30, "foo");
        TimeBounds dataTimes = new TimeBounds(0, 72, "foo");
        msc.setDataTimeRange(dataTimes);
        msc.setFocusTimeRange(focusTimes);
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(msc);
        frame.pack();
        frame.setSize(new Dimension(300, 400));
        frame.show();
    }

    private class Axis {
        TimeBounds bounds;
        int tic;

        Axis(TimeBounds bounds, int tic) {
            this.bounds = bounds;
            this.tic = tic;
        }
    }

    public static class TimeBounds
    implements Cloneable {
        private int min_;
        private int max_;
        private String units_;

        public TimeBounds(int min, int max, String units) {
            this.min_ = min;
            this.max_ = max;
            this.units_ = units;
        }

        public Object clone() {
            try {
                TimeBounds retval = (TimeBounds)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int getMin() {
            return this.min_;
        }

        public int getMax() {
            return this.max_;
        }

        public double getMinDouble() {
            return this.min_;
        }

        public double getMaxDouble() {
            return this.max_;
        }

        public DoubMinMax getDoubleBounds() {
            return new DoubMinMax(this.min_, this.max_);
        }

        public String getUnits() {
            return this.units_;
        }
    }
}

