/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import org.systemsbiology.biotapestry.util.ColorListRenderer;

public class NamedColor
implements Comparable,
ColorListRenderer.ColorSource {
    public Color color;
    public String name;
    public String key;
    private static final int H = 0;
    private static final int S = 1;
    private static final int B = 2;

    public NamedColor(String key, Color color, String name) {
        this.key = key;
        this.color = color;
        this.name = name;
    }

    public NamedColor(NamedColor other) {
        this.key = other.key;
        this.color = other.color;
        this.name = other.name;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        NamedColor other = (NamedColor)o;
        Color tCol = this.color;
        Color oCol = other.color;
        if (tCol.equals(oCol)) {
            return this.name.compareToIgnoreCase(other.name);
        }
        float[] tHsb = Color.RGBtoHSB(tCol.getRed(), tCol.getGreen(), tCol.getBlue(), null);
        float[] oHsb = Color.RGBtoHSB(oCol.getRed(), oCol.getGreen(), oCol.getBlue(), null);
        if ((double)oHsb[1] == 0.0 && (double)tHsb[1] == 0.0) {
            float bDiff = tHsb[2] - oHsb[2];
            if (bDiff != 0.0f) {
                return bDiff > 0.0f ? 1 : -1;
            }
            return this.name.compareToIgnoreCase(other.name);
        }
        if ((double)oHsb[1] == 0.0) {
            return 1;
        }
        if ((double)tHsb[1] == 0.0) {
            return -1;
        }
        float hDiff = tHsb[0] - oHsb[0];
        if (Math.abs(hDiff) > 0.05f) {
            return hDiff > 0.0f ? 1 : -1;
        }
        float sDiff = tHsb[1] - oHsb[1];
        if (sDiff != 0.0f) {
            return sDiff > 0.0f ? 1 : -1;
        }
        float bDiff = tHsb[2] - oHsb[2];
        if (bDiff != 0.0f) {
            return bDiff > 0.0f ? 1 : -1;
        }
        if (hDiff != 0.0f) {
            return hDiff > 0.0f ? 1 : -1;
        }
        return this.name.compareToIgnoreCase(other.name);
    }

    public Color getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.name;
    }
}

