/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.PerLinkDrawStyle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class NetModuleBusDrop
extends LinkBusDrop {
    private Point2D end_;
    private int padOffX_;
    private int padOffY_;

    public NetModuleBusDrop(NetModuleBusDrop other) {
        super(other);
        this.end_ = (Point2D)other.end_.clone();
        this.padOffX_ = other.padOffX_;
        this.padOffY_ = other.padOffY_;
    }

    public NetModuleBusDrop(NetModuleBusDrop other, Map modLinkIDMap) {
        super(other);
        this.end_ = (Point2D)other.end_.clone();
        this.padOffX_ = other.padOffX_;
        this.padOffY_ = other.padOffY_;
        this.mapToNewLink(modLinkIDMap, null);
    }

    public NetModuleBusDrop(Layout layout, Genome genome, String startID, Attributes attrs) throws IOException {
        super(layout, genome, startID, attrs);
        String xStr = null;
        String yStr = null;
        String xOffStr = null;
        String yOffStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("x")) {
                    xStr = val;
                    continue;
                }
                if (key.equals("y")) {
                    yStr = val;
                    continue;
                }
                if (key.equals("xoff")) {
                    xOffStr = val;
                    continue;
                }
                if (!key.equals("yoff")) continue;
                yOffStr = val;
            }
        }
        if (xStr == null || yStr == null) {
            throw new IOException();
        }
        if (xOffStr == null || yOffStr == null) {
            xOffStr = "0";
            yOffStr = "0";
        }
        try {
            double xLoc = Double.parseDouble(xStr);
            double yLoc = Double.parseDouble(yStr);
            this.end_ = new Point2D.Double(xLoc, yLoc);
            this.padOffX_ = Integer.parseInt(xOffStr);
            this.padOffY_ = Integer.parseInt(yOffStr);
        }
        catch (NumberFormatException ex) {
            throw new IOException();
        }
    }

    public Object clone() {
        NetModuleBusDrop retval = (NetModuleBusDrop)super.clone();
        retval.end_ = (Point2D)this.end_.clone();
        return retval;
    }

    public String toString() {
        return "NetModuleBusDrop: " + super.toString() + " end = " + this.end_ + " xoff = " + this.padOffX_ + " yoff = " + this.padOffY_;
    }

    public Point2D getEnd(double padOffsetLen) {
        if (padOffsetLen == 0.0) {
            return this.end_;
        }
        Point2D retval = (Point2D)this.end_.clone();
        double retX = retval.getX() + (double)this.padOffX_ * padOffsetLen;
        double retY = retval.getY() + (double)this.padOffY_ * padOffsetLen;
        retval.setLocation(retX, retY);
        return retval;
    }

    public void setEnd(Point2D newEnd, Vector2D sideDir) {
        this.end_ = (Point2D)newEnd.clone();
        this.setOffset(sideDir);
    }

    public void shiftEnd(double dx, double dy, Vector2D sideDir) {
        this.end_.setLocation(this.end_.getX() + dx, this.end_.getY() + dy);
        this.setOffset(sideDir);
    }

    protected void writeExtraXML(PrintWriter out, Indenter ind) {
        out.print("\" x=\"");
        out.print(this.end_.getX());
        out.print("\" y=\"");
        out.print(this.end_.getY());
        out.print("\" xoff=\"");
        out.print(this.padOffX_);
        out.print("\" yoff=\"");
        out.print(this.padOffY_);
    }

    Vector2D getOffset() {
        return new Vector2D(this.padOffX_, this.padOffY_);
    }

    private void setOffset(Vector2D sideDir) {
        if (sideDir != null) {
            double sideX = sideDir.getX();
            sideX = Math.abs(sideX) < 1.0E-4 ? 0.0 : sideX;
            double sideY = sideDir.getY();
            double d = sideY = Math.abs(sideY) < 1.0E-4 ? 0.0 : sideY;
            int n = sideX == 0.0 ? 0 : (this.padOffX_ = sideX < 0.0 ? -1 : 1);
            this.padOffY_ = sideY == 0.0 ? 0 : (sideY < 0.0 ? -1 : 1);
        }
    }

    NetModuleBusDrop(Point2D endpt, Vector2D padDir, String targetRef, String ourConnection, int dropType, int connectionEnd) {
        super(targetRef, ourConnection, dropType, connectionEnd);
        this.end_ = (Point2D)endpt.clone();
        this.setOffset(padDir);
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleBusDrop drop = board.nmBusDrop;
            SuggestedDrawStyle suggSty = board.suggSty;
            drop.setDrawStyleForDrop(suggSty);
            return null;
        }
    }

    public static class MyPerLinkGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleBusDrop drop = board.nmBusDrop;
            PerLinkDrawStyle plds = board.perLinkSty;
            drop.setDrawStyleForLink(plds);
            return null;
        }
    }

    public static class NetModuleBusDropWorker
    extends AbstractFactoryClient {
        public NetModuleBusDropWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("drop");
            this.installWorker(new PerLinkDrawStyle.PerLinkDrawStyleWorker(whiteboard), new MyPerLinkGlue());
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetModuleBusDrop retval = null;
            if (elemName.equals("drop")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.nmBusDrop = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NetModuleBusDrop buildFromXML(String elemName, Attributes attrs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            NetModuleLinkageProperties lprops = board.netModLinkProps;
            String startID = lprops.getSourceTag();
            return new NetModuleBusDrop(board.layout, board.genome, startID, attrs);
        }
    }
}

