/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleBusDrop;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleLinkageFree;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class NetModuleLinkageProperties
extends LinkProperties
implements Cloneable {
    private static Object linkRenderer_ = new NetModuleLinkageFree();
    private String id_;
    private String ovrKey_;

    public NetModuleLinkageProperties(String id, String ovrKey) {
        super(linkRenderer_);
        this.id_ = id;
        this.ovrKey_ = ovrKey;
    }

    public NetModuleLinkageProperties(NetModuleLinkageProperties other) {
        super(other);
        this.id_ = other.id_;
        this.ovrKey_ = other.ovrKey_;
    }

    public NetModuleLinkageProperties(String myID, String ovrKey, String srcID, String linkID, Point2D start, Point2D end, Vector2D startOff, Vector2D endOff) {
        super(linkRenderer_);
        this.srcTag_ = srcID;
        this.id_ = myID;
        this.ovrKey_ = ovrKey;
        NetModuleBusDrop bd = new NetModuleBusDrop((Point2D)start.clone(), startOff, null, null, 0, 2);
        this.drops_.add(bd);
        bd = new NetModuleBusDrop((Point2D)end.clone(), endOff, linkID, null, 1, 2);
        this.drops_.add(bd);
    }

    public NetModuleLinkageProperties(NetModuleLinkageProperties other, String newID, String newOvrKey, Map modIDMap, Map modLinkIDMap) {
        super(other);
        this.id_ = newID;
        this.ovrKey_ = newOvrKey;
        String string = this.srcTag_ = modIDMap == null ? null : (String)modIDMap.get(this.srcTag_);
        if (this.srcTag_ == null) {
            throw new IllegalStateException();
        }
        this.drops_.clear();
        Iterator dit = other.drops_.iterator();
        while (dit.hasNext()) {
            NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
            this.drops_.add(new NetModuleBusDrop(nextDrop, modLinkIDMap));
        }
    }

    public LinkProperties deriveDirectLink(String newSource, LinkBusDrop keepDrop, Object extraInfo) {
        NetModuleLinkageProperties retval = (NetModuleLinkageProperties)this.clone();
        retval.srcTag_ = newSource;
        retval.clearOutAllSegments();
        retval.drops_.clear();
        DirectLinkExtraInfo dlei = (DirectLinkExtraInfo)extraInfo;
        retval.id_ = dlei.treeID;
        NetModuleBusDrop bd = new NetModuleBusDrop(dlei.startPt, dlei.toStartSide, null, null, 0, 2);
        retval.drops_.add(bd);
        NetModuleBusDrop knmbd = (NetModuleBusDrop)keepDrop;
        bd = new NetModuleBusDrop(knmbd.getEnd(0.0), knmbd.getOffset(), keepDrop.getTargetRef(), null, 1, 2);
        retval.drops_.add(bd);
        return retval;
    }

    public Object clone() {
        NetModuleLinkageProperties retval = (NetModuleLinkageProperties)super.clone();
        return retval;
    }

    public String getID() {
        return this.id_;
    }

    public String getOverlayID() {
        return this.ovrKey_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<nModLinkProp id=\"");
        out.print(this.id_);
        out.print("\" ");
        this.writeXMLSupport(out, ind);
        ind.down().indent();
        out.println("</nModLinkProp>");
    }

    public LinkSegment getDirectLinkPath(Genome genome, Layout lo, FontRenderContext frc) {
        NetModuleBusDrop targDrop = (NetModuleBusDrop)this.getTargetDrop();
        NetModuleBusDrop srcDrop = (NetModuleBusDrop)this.getRootDrop();
        Point2D sLoc = srcDrop.getEnd(6.0);
        Point2D eLoc = targDrop.getEnd(6.0);
        LinkSegment retval = new LinkSegment(sLoc, eLoc);
        return retval;
    }

    protected LinkSegment getSourceDropSegment(Genome genome, Layout lo, FontRenderContext frc, boolean forceToGrid) {
        NetModuleBusDrop drop = (NetModuleBusDrop)this.getRootDrop();
        Point2D srcLoc = drop.getEnd(6.0);
        if (forceToGrid) {
            UiUtil.forceToGrid(srcLoc.getX(), srcLoc.getY(), srcLoc, 10.0);
        }
        LinkSegment rootSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? rootSeg.getStart() : rootSeg.getEnd();
        return new LinkSegment(srcLoc, segPt);
    }

    protected LinkSegment getTargetDropSegment(LinkBusDrop drop, Genome genome, Layout lo, FontRenderContext frc) {
        String trg = drop.getTargetRef();
        if (trg == null) {
            throw new IllegalStateException();
        }
        Point2D termLoc = ((NetModuleBusDrop)drop).getEnd(6.0);
        LinkSegment trgSeg = this.getSegment(drop.getConnectionTag());
        Point2D segPt = drop.getConnectionSense() == 0 ? trgSeg.getStart() : trgSeg.getEnd();
        return new LinkSegment(segPt, termLoc);
    }

    protected boolean srcDropIsNonOrtho(Genome genome, Layout lo, FontRenderContext frc) {
        LinkSegment seg = this.getSegmentGeometryForID(LinkSegmentID.buildIDForStartDrop(), genome, lo, frc, false);
        return !seg.getRun().isCanonical();
    }

    protected boolean targetDropIsNonOrtho(LinkBusDrop drop, Genome genome, Layout lo, FontRenderContext frc) {
        LinkSegment seg = this.getSegmentGeometryForID(LinkSegmentID.buildIDForDrop(drop.getTargetRef()), genome, lo, frc, false);
        return !seg.getRun().isCanonical();
    }

    protected LinkBusDrop generateBusDrop(LinkBusDrop spDrop, String ourConnection, int dropType, int connectionEnd) {
        NetModuleBusDrop nmbd = (NetModuleBusDrop)spDrop;
        return new NetModuleBusDrop(nmbd.getEnd(0.0), nmbd.getOffset(), spDrop.getTargetRef(), ourConnection, dropType, connectionEnd);
    }

    protected LinkBusDrop generateBusDrop(String targetRef, String ourConnection, int dropType, int connectionEnd, Object extraInfo) {
        DirectLinkExtraInfo dlei = (DirectLinkExtraInfo)extraInfo;
        return new NetModuleBusDrop(dlei.startPt, dlei.toStartSide, targetRef, ourConnection, dropType, connectionEnd);
    }

    protected LinkProperties.ThickInfo maxThickForIntersect(Genome genome, OverlayStateOracle oso, double intersectTol) {
        return this.maxThickForIntersectSupport(genome, oso, true, intersectTol);
    }

    protected void moveSource(Object extraInfo) {
        DirectLinkExtraInfo dlei = (DirectLinkExtraInfo)extraInfo;
        this.id_ = dlei.treeID;
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)dit.next();
            if (drop.getDropType() != 0) continue;
            drop.setEnd((Point2D)dlei.startPt.clone(), dlei.toStartSide);
            break;
        }
    }

    public boolean canRelocateSegmentOnTree(LinkSegmentID moveID) {
        return true;
    }

    public boolean linkIsInModel(Genome genome, OverlayStateOracle oso, String linkID) {
        TaggedSet currMods = oso.getCurrentNetModules();
        if (currMods == null || currMods.set == null || currMods.set.isEmpty()) {
            return false;
        }
        NetOverlayOwner noo = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID());
        NetworkOverlay ovr = noo.getNetworkOverlay(this.ovrKey_);
        NetModuleLinkage nml = ovr.getLinkage(linkID);
        String src = nml.getSource();
        String trg = nml.getTarget();
        return currMods.set.contains(src) && currMods.set.contains(trg);
    }

    protected void sourceSanityCheck(Genome genome, LinkProperties other) {
    }

    protected String getLinkLabel(Genome genome, String linkID) {
        return null;
    }

    public String getLinkTarget(Genome genome, String linkID) {
        NetworkOverlay ovr = genome.getNetworkOverlay(this.ovrKey_);
        NetModuleLinkage nml = ovr.getLinkage(linkID);
        return nml.getTarget();
    }

    protected void shiftDropEnds(double dx, double dy, Vector2D sideDir) {
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
            Point2D dLoc = nextDrop.getEnd(0.0);
            if (dLoc == null) continue;
            nextDrop.shiftEnd(dx, dy, sideDir);
        }
    }

    protected LinkPlacementGrid initGridForOrthoFix(LinkRouter router, Genome genome, Layout lo, FontRenderContext frc, OverlayStateOracle oso, String overID, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List doNotRender = this.getLinkageList();
        return router.initGridForModules(genome, lo, frc, new HashSet(doNotRender), oso, overID, monitor);
    }

    protected void moveDropEndsPerMap(Map mappedPositions, boolean forceToGrid) {
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            Point2D mapped;
            NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
            Point2D dLoc = nextDrop.getEnd(0.0);
            if (dLoc == null) continue;
            if (forceToGrid) {
                dLoc = (Point2D)dLoc.clone();
                UiUtil.forceToGrid(dLoc, 10.0);
            }
            if ((mapped = (Point2D)mappedPositions.get(dLoc)) != null) {
                nextDrop.setEnd((Point2D)mapped.clone(), nextDrop.getOffset());
                continue;
            }
            Point2D minKey = null;
            double minDist = Double.POSITIVE_INFINITY;
            Iterator kit = mappedPositions.keySet().iterator();
            while (kit.hasNext()) {
                Point2D key = (Point2D)kit.next();
                double dist = key.distance(dLoc);
                if (!(dist < minDist)) continue;
                minKey = key;
                minDist = dist;
            }
            System.err.println("fallback with errval: " + minDist + " " + minKey + " " + dLoc);
            nextDrop.setEnd((Point2D)((Point2D)mappedPositions.get(minKey)).clone(), nextDrop.getOffset());
        }
    }

    public Map mapSegmentsToBounds(Map boundsForGroups, Map groupZOrder) {
        TreeMap sorted = new TreeMap(Collections.reverseOrder());
        Iterator kit = groupZOrder.keySet().iterator();
        while (kit.hasNext()) {
            String grpID = (String)kit.next();
            Integer order = (Integer)groupZOrder.get(grpID);
            sorted.put(order, grpID);
        }
        HashSet<String> assignedSegStarts = new HashSet<String>();
        HashSet<String> assignedSegEnds = new HashSet<String>();
        HashSet<String> assignedDrops = new HashSet<String>();
        boolean assignedSrc = false;
        HashMap<String, LinkProperties.LinkFragmentShifts> retval = new HashMap<String, LinkProperties.LinkFragmentShifts>();
        Iterator bfgit = sorted.values().iterator();
        while (bfgit.hasNext()) {
            String grpID = (String)bfgit.next();
            Rectangle rect = (Rectangle)boundsForGroups.get(grpID);
            if (rect == null) continue;
            LinkProperties.LinkFragmentShifts shiftForGroup = new LinkProperties.LinkFragmentShifts();
            retval.put(grpID, shiftForGroup);
            Iterator sit = this.segments_.keySet().iterator();
            while (sit.hasNext()) {
                LinkProperties.LinkFragmentData lfd;
                String nextKey = (String)sit.next();
                LinkSegment seg = (LinkSegment)this.segments_.get(nextKey);
                if (!assignedSegStarts.contains(nextKey) && rect.contains(seg.getStart())) {
                    lfd = new LinkProperties.LinkFragmentData(seg.getStart());
                    shiftForGroup.segmentStarts.put(nextKey, lfd);
                    assignedSegStarts.add(nextKey);
                }
                if (assignedSegEnds.contains(nextKey) || seg.isDegenerate() || !rect.contains(seg.getEnd())) continue;
                lfd = new LinkProperties.LinkFragmentData(seg.getEnd());
                shiftForGroup.segmentEnds.put(nextKey, lfd);
                assignedSegEnds.add(nextKey);
            }
            Iterator dit = this.drops_.iterator();
            while (dit.hasNext()) {
                NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
                String targRef = nextDrop.getTargetRef();
                if (targRef == null && assignedSrc || !rect.contains(nextDrop.getEnd(0.0))) continue;
                LinkProperties.LinkFragmentData lfd = new LinkProperties.LinkFragmentData(nextDrop.getEnd(0.0));
                if (targRef == null) {
                    shiftForGroup.doSource = lfd;
                    assignedSrc = true;
                    continue;
                }
                if (assignedDrops.contains(targRef)) continue;
                shiftForGroup.drops.put(targRef, lfd);
                assignedDrops.add(targRef);
            }
        }
        return retval;
    }

    protected void shiftSelectedDropEnds(double dx, double dy, LinkProperties.LinkFragmentShifts fragShifts) {
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            Point2D dLoc;
            NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
            String targRef = nextDrop.getTargetRef();
            LinkProperties.LinkFragmentData lfd = targRef == null ? fragShifts.doSource : (LinkProperties.LinkFragmentData)fragShifts.drops.get(targRef);
            if (lfd == null || (dLoc = nextDrop.getEnd(0.0)) == null) continue;
            nextDrop.shiftEnd(dx, dy, null);
            if (lfd.expComp == null) continue;
            nextDrop.shiftEnd(lfd.expComp.getX(), lfd.expComp.getY(), null);
        }
    }

    public void needRowsAndCols(SortedSet needRows, SortedSet needCols) {
        Iterator sit = this.segments_.values().iterator();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            Point2D segPt = seg.getStart();
            needCols.add(new Integer((int)segPt.getX() / 10));
            needRows.add(new Integer((int)segPt.getY() / 10));
            segPt = seg.getEnd();
            if (segPt == null) continue;
            needCols.add(new Integer((int)segPt.getX() / 10));
            needRows.add(new Integer((int)segPt.getY() / 10));
        }
    }

    protected void shiftDropEndsForExpandCompressOps(SortedSet newRows, SortedSet newCols, Rectangle bounds, double sign, int mult) {
        Iterator dit = this.drops_.iterator();
        while (dit.hasNext()) {
            NetModuleBusDrop nextDrop = (NetModuleBusDrop)dit.next();
            Point2D dLoc = nextDrop.getEnd(0.0);
            if (dLoc == null) continue;
            Point2D newLoc = (Point2D)dLoc.clone();
            NetModuleLinkageProperties.shiftSupport(newLoc, newRows, newCols, bounds, sign, mult);
            nextDrop.setEnd(newLoc, null);
        }
    }

    public void shiftEnd(String linkID, double dx, double dy, Vector2D sideDir) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref == null || !ref.equals(linkID)) continue;
            drop.shiftEnd(dx, dy, sideDir);
            return;
        }
    }

    public void setTargetEnd(String linkID, Point2D newTarget, Vector2D sideDir) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref == null || !ref.equals(linkID)) continue;
            drop.setEnd(newTarget, sideDir);
            return;
        }
    }

    public Point2D getTargetEnd(String linkID, double doOffset) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref == null || !ref.equals(linkID)) continue;
            return drop.getEnd(doOffset);
        }
        return null;
    }

    public void setSourceStart(Point2D newSource, Vector2D sideDir) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref != null) continue;
            drop.setEnd(newSource, sideDir);
            return;
        }
    }

    public Point2D getSourceStart(double doOffset) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref != null) continue;
            return drop.getEnd(doOffset);
        }
        return null;
    }

    public void shiftStart(double dx, double dy, Vector2D sideDir) {
        Iterator drops = this.drops_.iterator();
        while (drops.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)drops.next();
            String ref = drop.getTargetRef();
            if (ref != null) continue;
            drop.shiftEnd(dx, dy, sideDir);
            return;
        }
    }

    public String getALinkID(Genome genome) {
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            LinkBusDrop bd = (LinkBusDrop)dit.next();
            if (bd.getDropType() == 0) continue;
            String retval = bd.getTargetRef();
            return retval;
        }
        throw new IllegalStateException();
    }

    protected Vector2D getSourceForcedDir(Genome genome, Layout lo) {
        NetModuleBusDrop drop = (NetModuleBusDrop)this.getDrop(LinkSegmentID.buildIDForStartDrop());
        return drop.getOffset().scaled(-1.0);
    }

    protected Vector2D getTargetForcedDir(Genome genome, Layout lo, LinkSegmentID segID, boolean isDirect) {
        String idDropRef;
        if (segID.isForEndDrop()) {
            idDropRef = segID.getEndDropLinkRef();
        } else if (segID.isDirect()) {
            idDropRef = segID.getDirectLinkRef();
        } else {
            throw new IllegalArgumentException();
        }
        Iterator dit = this.getDrops();
        while (dit.hasNext()) {
            NetModuleBusDrop drop = (NetModuleBusDrop)dit.next();
            String dropRef = drop.getTargetRef();
            int dropType = drop.getDropType();
            if (dropType != 1 || !dropRef.equals(idDropRef)) continue;
            return (Vector2D)drop.getOffset().clone();
        }
        throw new IllegalArgumentException();
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleLinkageProperties nmProps = board.netModLinkProps;
            SuggestedDrawStyle suggSty = board.suggSty;
            nmProps.setDrawStyle(suggSty);
            return null;
        }
    }

    public static class MyBusDropGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleLinkageProperties nmProps = board.netModLinkProps;
            NetOverlayProperties nop = board.netOvrProps;
            NetModuleBusDrop newDrop = board.nmBusDrop;
            Layout lo = board.layout;
            nmProps.addDrop(newDrop);
            if (newDrop.getDropType() == 1) {
                String targetTag = newDrop.getTargetRef();
                lo.tieNetModuleLinkToProperties(targetTag, nmProps.getID(), nop.getReference());
            }
            return null;
        }
    }

    public static class MySegmentGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleLinkageProperties nmProps = board.netModLinkProps;
            LinkSegment seg = board.linkSegment;
            nmProps.addSegment(seg);
            return null;
        }
    }

    public static class NetModuleLinkagePropertiesWorker
    extends AbstractFactoryClient {
        public NetModuleLinkagePropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nModLinkProp");
            this.installWorker(new LinkSegment.LinkSegmentWorker(whiteboard), new MySegmentGlue());
            this.installWorker(new NetModuleBusDrop.NetModuleBusDropWorker(whiteboard), new MyBusDropGlue());
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetModuleLinkageProperties retval = null;
            if (elemName.equals("nModLinkProp")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netModLinkProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NetModuleLinkageProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "nModLinkProp", "id", true);
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            NetModuleLinkageProperties newProp = new NetModuleLinkageProperties(id, board.netOvrProps.getReference());
            LinkProperties.buildFromXMLSupport(elemName, attrs, newProp, board, "nModLinkProp");
            return newProp;
        }
    }

    public static class DirectLinkExtraInfo {
        public String treeID;
        public Point2D startPt;
        public Vector2D toStartSide;

        public DirectLinkExtraInfo(String treeID, Point2D startPt, Vector2D toStartSide) {
            this.treeID = treeID;
            this.startPt = startPt;
            this.toStartSide = toStartSide;
        }
    }
}

