/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.ui.freerender.NodeBounder;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Bounds;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LineBreaker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.SliceAndDicer;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;
import org.xml.sax.Attributes;

public class NetModuleProperties
implements Cloneable {
    public static final int ONE_MODULE_SHAPE = 0;
    public static final int CONTIG_MODULE_SHAPES = 1;
    public static final int ALL_MODULE_SHAPES = 2;
    public static final int CONTIG_RECT = 0;
    public static final int MULTI_RECT = 1;
    public static final int MEMBERS_ONLY = 2;
    private static final int NUM_TYPES_ = 3;
    public static final int INTERIOR = -1;
    public static final int NONE = 0;
    public static final int UPPER_LEFT = 1;
    public static final int TOP = 2;
    public static final int UPPER_RIGHT = 3;
    public static final int RIGHT = 4;
    public static final int LOWER_RIGHT = 5;
    public static final int BOTTOM = 6;
    public static final int LOWER_LEFT = 7;
    public static final int LEFT = 8;
    public static final int FADE_QUICKLY = 0;
    public static final int FADE_SLOWLY = 1;
    private static final int NUM_FADES_ = 2;
    private static NetModuleFree freeRender_ = new NetModuleFree();
    private static final String CONTIG_STR_ = "contig";
    private static final String MULTI_STR_ = "multi";
    private static final String MEMBERS_STR_ = "members";
    private static final int START_ = 1;
    private static final int END_ = 2;
    private static final int MIDDLE_ = 3;
    private static final String FADE_QUICKLY_STR_ = "quick";
    private static final String FADE_SLOWLY_STR_ = "slow";
    private static final double INTERSECT_TOL_ = 0.001;
    private String moduleID_;
    private ArrayList rectList_;
    private int type_;
    private Point2D nameLoc_;
    private boolean hideName_;
    private int nameFadeMode_;
    private String colorTag_;
    private String fillColorTag_;
    private FontManager.FontOverride localFont_;
    private String lineBreakDef_;

    public NetModuleProperties(String moduleID, int type, List shapes, Point2D labelLoc) {
        this.moduleID_ = moduleID;
        this.hideName_ = false;
        this.rectList_ = new ArrayList();
        if (type != 2) {
            this.rectList_.addAll(shapes);
            Rectangle2D firstRect = (Rectangle2D)shapes.get(0);
            double labelX = firstRect.getCenterX();
            double labelY = firstRect.getCenterY();
            this.nameLoc_ = new Point2D.Double(labelX, labelY);
            UiUtil.forceToGrid(this.nameLoc_, 10.0);
        } else if (labelLoc != null) {
            this.nameLoc_ = (Point2D)labelLoc.clone();
            UiUtil.forceToGrid(this.nameLoc_, 10.0);
        } else {
            this.hideName_ = true;
        }
        this.type_ = type;
        this.colorTag_ = "black";
        this.fillColorTag_ = "white";
        this.localFont_ = null;
        this.lineBreakDef_ = null;
        this.nameFadeMode_ = 1;
    }

    public NetModuleProperties(NetModuleProperties other) {
        this.moduleID_ = other.moduleID_;
        this.type_ = other.type_;
        this.rectList_ = new ArrayList();
        int numRect = other.rectList_.size();
        for (int i = 0; i < numRect; ++i) {
            Rectangle2D orect = (Rectangle2D)other.rectList_.get(i);
            this.rectList_.add(orect.clone());
        }
        this.colorTag_ = other.colorTag_;
        this.fillColorTag_ = other.fillColorTag_;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.nameLoc_ = other.nameLoc_ == null ? null : (Point2D)other.nameLoc_.clone();
        this.hideName_ = other.hideName_;
        this.lineBreakDef_ = other.lineBreakDef_;
        this.nameFadeMode_ = other.nameFadeMode_;
    }

    public NetModuleProperties(NetModuleProperties other, String newID, Vector2D offset) {
        this.moduleID_ = newID;
        this.type_ = other.type_;
        this.rectList_ = new ArrayList();
        int numRect = other.rectList_.size();
        for (int i = 0; i < numRect; ++i) {
            Rectangle2D orect = (Rectangle2D)other.rectList_.get(i);
            this.rectList_.add(orect.clone());
        }
        this.colorTag_ = other.colorTag_;
        this.fillColorTag_ = other.fillColorTag_;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.nameLoc_ = other.nameLoc_ == null ? null : (Point2D)other.nameLoc_.clone();
        this.hideName_ = other.hideName_;
        this.lineBreakDef_ = other.lineBreakDef_;
        this.nameFadeMode_ = other.nameFadeMode_;
        if (offset != null) {
            this.moveAllShapes(offset.getX(), offset.getY());
            this.moveName(offset.getX(), offset.getY());
        }
    }

    public NetModuleProperties(String ref, String typStr, String cStr, String fcStr, String lineBreaks, boolean hideLabel, String fadeStr, Point2D nameLoc) throws IOException {
        this.moduleID_ = ref;
        this.colorTag_ = cStr;
        this.fillColorTag_ = fcStr;
        this.rectList_ = new ArrayList();
        this.localFont_ = null;
        try {
            this.type_ = NetModuleProperties.mapFromTypeTag(typStr);
        }
        catch (IllegalArgumentException iax) {
            throw new IOException();
        }
        this.nameLoc_ = nameLoc;
        this.hideName_ = hideLabel;
        this.lineBreakDef_ = lineBreaks;
        if (fadeStr == null) {
            this.nameFadeMode_ = 0;
        } else {
            try {
                this.nameFadeMode_ = NetModuleProperties.mapFromFadeTag(fadeStr);
            }
            catch (IllegalArgumentException iax) {
                throw new IOException();
            }
        }
    }

    public Object clone() {
        try {
            NetModuleProperties retval = (NetModuleProperties)super.clone();
            retval.rectList_ = new ArrayList();
            int numRect = this.rectList_.size();
            for (int i = 0; i < numRect; ++i) {
                Rectangle2D orect = (Rectangle2D)this.rectList_.get(i);
                retval.rectList_.add(orect.clone());
            }
            retval.localFont_ = this.localFont_ == null ? null : (FontManager.FontOverride)this.localFont_.clone();
            retval.nameLoc_ = this.nameLoc_ == null ? null : (Point2D)this.nameLoc_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public NetModuleFree getRenderer() {
        return freeRender_;
    }

    public String getID() {
        return this.moduleID_;
    }

    public int getType() {
        return this.type_;
    }

    public Point2D getNameLoc() {
        return this.nameLoc_;
    }

    public void moveName(double dx, double dy) {
        if (this.nameLoc_ == null) {
            return;
        }
        Point2D.Double newLoc = new Point2D.Double(this.nameLoc_.getX() + dx, this.nameLoc_.getY() + dy);
        UiUtil.forceToGrid(newLoc, 10.0);
        this.nameLoc_ = newLoc;
    }

    public void setNameLocation(Point2D newLoc) {
        UiUtil.forceToGrid(newLoc, 10.0);
        this.nameLoc_ = newLoc;
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        if (this.colorTag_.equals(oldID)) {
            this.colorTag_ = newID;
            retval = true;
        }
        if (this.fillColorTag_.equals(oldID)) {
            this.fillColorTag_ = newID;
            retval = true;
        }
        return retval;
    }

    public boolean isHidingLabel() {
        return this.hideName_;
    }

    public void setHidingLabel(boolean hideName) {
        this.hideName_ = hideName;
    }

    public int getNameFadeMode() {
        return this.nameFadeMode_;
    }

    public void setNameFadeMode(int nameFadeMode) {
        this.nameFadeMode_ = nameFadeMode;
    }

    public String getLineBreakDef() {
        return this.lineBreakDef_;
    }

    public void setLineBreakDef(String lineBreakDef) {
        this.lineBreakDef_ = lineBreakDef;
    }

    public static String trimOps(String lineBreakDef, String untrimmed) {
        String trimmedBreakDef = LineBreaker.fixBreaksForTrim(lineBreakDef, untrimmed);
        return LineBreaker.massageLineBreaks(trimmedBreakDef, untrimmed.trim());
    }

    public void trimAndSetLineBreakDef(String lineBreakDef, String untrimmed) {
        this.lineBreakDef_ = NetModuleProperties.trimOps(lineBreakDef, untrimmed);
    }

    public void applyLineBreakMod(LineBreaker.LineBreakChangeSteps steps, String untrimmed) {
        String resolvedBreakDef = LineBreaker.resolveNameChange(this.lineBreakDef_, steps);
        this.trimAndSetLineBreakDef(resolvedBreakDef, untrimmed);
    }

    public boolean hasShapes() {
        return !this.rectList_.isEmpty();
    }

    public boolean hasOneShape() {
        return this.rectList_.size() == 1;
    }

    public Iterator getShapeIterator() {
        return this.rectList_.iterator();
    }

    public void addShape(Rectangle2D rect) {
        this.rectList_.add(rect);
    }

    public void compress(SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds, List oldAndNew) {
        Point2D newLoc;
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            Rectangle2D newShape = UiUtil.compressRect(oldShape, emptyRows, emptyCols, bounds);
            if (oldAndNew != null) {
                oldAndNew.add(new TaggedShape(oldShape, newShape, false));
            }
            oldShape.setRect(newShape);
        }
        if (this.nameLoc_ != null && (newLoc = UiUtil.compressPoint(this.nameLoc_, emptyRows, emptyCols, bounds)) != null) {
            if (oldAndNew != null) {
                Rectangle2D.Double fakeOld = new Rectangle2D.Double(this.nameLoc_.getX(), this.nameLoc_.getY(), 0.0, 0.0);
                Rectangle2D.Double fakeNew = new Rectangle2D.Double(newLoc.getX(), newLoc.getY(), 0.0, 0.0);
                oldAndNew.add(new TaggedShape(fakeOld, fakeNew, true));
            }
            this.nameLoc_ = newLoc;
        }
    }

    public void expand(SortedSet insertRows, SortedSet insertCols, int mult, List oldAndNew) {
        Point2D newLoc;
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            Rectangle2D newShape = UiUtil.expandRect(oldShape, insertRows, insertCols, mult);
            if (oldAndNew != null) {
                oldAndNew.add(new TaggedShape(oldShape, newShape, false));
            }
            oldShape.setRect(newShape);
        }
        if (this.nameLoc_ != null && (newLoc = UiUtil.expandPoint(this.nameLoc_, insertRows, insertCols, mult)) != null) {
            if (oldAndNew != null) {
                Rectangle2D.Double fakeOld = new Rectangle2D.Double(this.nameLoc_.getX(), this.nameLoc_.getY(), 0.0, 0.0);
                Rectangle2D.Double fakeNew = new Rectangle2D.Double(newLoc.getX(), newLoc.getY(), 0.0, 0.0);
                oldAndNew.add(new TaggedShape(fakeOld, fakeNew, true));
            }
            this.nameLoc_ = newLoc;
        }
    }

    public void clipShapes(Rectangle2D clipBounds, List oldAndNew) {
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            Rectangle2D interRect = clipBounds.createIntersection(oldShape);
            if (interRect.equals(oldShape)) continue;
            if (oldAndNew != null) {
                int numOaN = oldAndNew.size();
                for (int i = 0; i < numOaN; ++i) {
                    TaggedShape ts = (TaggedShape)oldAndNew.get(i);
                    if (!ts.shape.equals(oldShape)) continue;
                    ts.shape = (Rectangle2D)interRect.clone();
                    break;
                }
            }
            oldShape.setRect(interRect);
        }
    }

    public void convertEmptyMemberOnly(Map eachRect) {
        if (!this.rectList_.isEmpty()) {
            throw new IllegalStateException();
        }
        this.type_ = 1;
        Iterator rit = eachRect.values().iterator();
        while (rit.hasNext()) {
            Rectangle eaRect = (Rectangle)rit.next();
            Rectangle2D.Double rect2D = new Rectangle2D.Double(eaRect.getX(), eaRect.getY(), eaRect.getWidth(), eaRect.getHeight());
            this.rectList_.add(rect2D);
        }
    }

    public List convertShapes(int newType, Set nodes, FontRenderContext frc, Genome genome, Layout layout) {
        ArrayList<Rectangle2D> retval = new ArrayList<Rectangle2D>();
        switch (this.type_) {
            case 0: {
                if (newType == 1) {
                    retval.addAll(this.rectList_);
                    break;
                }
                if (newType != 2) break;
                break;
            }
            case 1: {
                if (newType == 0) {
                    int numRect = this.rectList_.size();
                    Rectangle2D newRect = (Rectangle2D)this.rectList_.get(0);
                    for (int i = 1; i < numRect; ++i) {
                        Rectangle2D rect = (Rectangle2D)this.rectList_.get(i);
                        newRect = newRect.createUnion(rect);
                    }
                    retval.add(newRect);
                    break;
                }
                if (newType != 2) break;
                break;
            }
            case 2: {
                Map eachRect = null;
                if (newType != 2) {
                    eachRect = NodeBounder.nodeRects(nodes, genome, layout, frc, 10);
                }
                if (newType != 1 && newType != 0) break;
                Rectangle extent = null;
                Iterator rit = eachRect.values().iterator();
                while (rit.hasNext()) {
                    Rectangle eaRect = (Rectangle)rit.next();
                    if (extent == null) {
                        extent = eaRect;
                        continue;
                    }
                    Bounds.tweakBounds(extent, eaRect);
                }
                Rectangle2D.Double result = new Rectangle2D.Double(extent.getX(), extent.getY(), extent.getWidth(), extent.getHeight());
                retval.add(result);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return retval;
    }

    public boolean removeBiggestShape(NetModuleFree.IntersectionExtraInfo iexi) {
        List extract = this.extractRectangles(iexi);
        if (extract == null) {
            return false;
        }
        if (this.rectList_.size() <= 1) {
            return false;
        }
        Rectangle2D deadRect = null;
        double deadArea = 0.0;
        Iterator eit = extract.iterator();
        while (eit.hasNext()) {
            LocatedIntersection li = (LocatedIntersection)eit.next();
            double chkArea = li.rect.getHeight() * li.rect.getWidth();
            if (deadRect != null && !(chkArea > deadArea)) continue;
            deadRect = li.rect;
            deadArea = chkArea;
        }
        if (deadRect != null) {
            this.rectList_.remove(deadRect);
            return true;
        }
        return false;
    }

    public List initSliceList() {
        ArrayList<Object> retval = new ArrayList<Object>();
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            retval.add(oldShape.clone());
        }
        return retval;
    }

    public void reassembleSlices() {
        this.rectList_ = new ArrayList(new NetModuleFree().newReassemble(this));
    }

    public SliceResult sliceByAllBounds(Map boundsForGroups, Map groupZOrder, Rectangle2D nameBounds) {
        SliceResult retval = new SliceResult();
        SliceAndDicer sad = new SliceAndDicer();
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            List osrList = sad.sliceARectByAllBounds(boundsForGroups, groupZOrder, oldShape, false);
            retval.merge(osrList);
        }
        if (nameBounds != null) {
            List osrList = sad.sliceARectByAllBounds(boundsForGroups, groupZOrder, nameBounds, true);
            retval.merge(osrList);
        }
        return retval;
    }

    public Map moveShape(NetModuleFree.IntersectionExtraInfo iexi, double dx, double dy, Set usedPads) {
        HashMap<Layout.PointNoPoint, Vector2D> retval = new HashMap<Layout.PointNoPoint, Vector2D>();
        if (iexi == null) {
            this.moveAllShapes(dx, dy);
            Vector2D moveVec = new Vector2D(dx, dy);
            Iterator upit = usedPads.iterator();
            while (upit.hasNext()) {
                Layout.PointNoPoint pt = (Layout.PointNoPoint)upit.next();
                retval.put(pt, moveVec);
            }
            return retval;
        }
        if (iexi.contigInfo != null && iexi.contigInfo.intersectedShape != null && !iexi.contigInfo.intersectedShape.isEmpty()) {
            return this.moveMatchingShapes(iexi.contigInfo.intersectedShape, dx, dy, usedPads);
        }
        List extract = this.extractRectangles(iexi);
        if (extract == null) {
            return retval;
        }
        Iterator eit = extract.iterator();
        while (eit.hasNext()) {
            LocatedIntersection li = (LocatedIntersection)eit.next();
            Rectangle2D oldShape = li.rect;
            double orx = oldShape.getX();
            double ory = oldShape.getY();
            double orw = oldShape.getWidth();
            double orh = oldShape.getHeight();
            if (li.extraDelta != null) {
                dx += li.extraDelta.getX();
                dy += li.extraDelta.getY();
            }
            if (iexi.endPt == null && iexi.startPt == null) {
                double nrx = UiUtil.forceToGridValue(orx + dx, 10.0);
                double nry = UiUtil.forceToGridValue(ory + dy, 10.0);
                this.assembleRigidPadVecForRect(oldShape, dx, dy, usedPads, retval, 0);
                oldShape.setRect(nrx, nry, orw, orh);
                continue;
            }
            if (li.where == 1 || li.where == 3 || li.where == 5 || li.where == 7) {
                this.assembleRigidPadVecForRect(oldShape, dx, dy, usedPads, retval, li.where);
                this.moveCorner(li.where, orx, ory, orw, orh, dx, dy, oldShape);
                continue;
            }
            if (li.where != 2 && li.where != 4 && li.where != 6 && li.where != 8) continue;
            this.assembleRigidPadVecForRect(oldShape, dx, dy, usedPads, retval, li.where);
            this.moveEdge(li.where, orx, ory, orw, orh, dx, dy, oldShape);
        }
        return retval;
    }

    private void moveAllShapes(double dx, double dy) {
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            double orx = oldShape.getX();
            double ory = oldShape.getY();
            double orw = oldShape.getWidth();
            double orh = oldShape.getHeight();
            double nrx = UiUtil.forceToGridValue(orx + dx, 10.0);
            double nry = UiUtil.forceToGridValue(ory + dy, 10.0);
            oldShape.setRect(nrx, nry, orw, orh);
        }
    }

    private void assembleRigidPadVecForRect(Rectangle2D oldShape, double dx, double dy, Set usedPads, Map moveMap, int cornerOrSide) {
        Vector2D moveVec = new Vector2D(dx, dy);
        NetModuleFree nmf = new NetModuleFree();
        Map pfr = nmf.padsForRectangle(oldShape, null);
        Iterator upit = usedPads.iterator();
        while (upit.hasNext()) {
            Vector2D padNorm;
            Layout.PointNoPoint pt = (Layout.PointNoPoint)upit.next();
            NetModuleFree.LinkPad pad = (NetModuleFree.LinkPad)pfr.get(pt.point);
            if (pad == null || cornerOrSide != 0 && cornerOrSide != pad.rectSide && !this.cornerMatchesSide(cornerOrSide, pad.rectSide)) continue;
            Vector2D useVec = cornerOrSide != 0 ? ((padNorm = pad.getNormal()).getX() == 0.0 ? new Vector2D(0.0, dy) : (padNorm.getY() == 0.0 ? new Vector2D(dx, 0.0) : moveVec)) : moveVec;
            moveMap.put(pt, useVec);
        }
    }

    private Map moveMatchingShapes(Set toMatch, double dx, double dy, Set usedPads) {
        HashMap retval = new HashMap();
        Iterator sit = this.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D oldShape = (Rectangle2D)sit.next();
            if (!toMatch.contains(oldShape)) continue;
            this.assembleRigidPadVecForRect(oldShape, dx, dy, usedPads, retval, 0);
            double orx = oldShape.getX();
            double ory = oldShape.getY();
            double orw = oldShape.getWidth();
            double orh = oldShape.getHeight();
            double nrx = UiUtil.forceToGridValue(orx + dx, 10.0);
            double nry = UiUtil.forceToGridValue(ory + dy, 10.0);
            oldShape.setRect(nrx, nry, orw, orh);
        }
        return retval;
    }

    public NetModuleFree.ContigBreakdown rectsForContig(List shapePoints, List shapeList) {
        HashSet<Object> shapes = new HashSet<Object>();
        Iterator sit = this.getShapeIterator();
        int numPts = shapePoints.size();
        block0: while (sit.hasNext()) {
            Rectangle2D myshape = (Rectangle2D)sit.next();
            Point2D lastPt = numPts != 0 ? (Point2D)shapePoints.get(numPts - 1) : null;
            for (int i = 0; i < numPts; ++i) {
                Point2D nextPt = (Point2D)shapePoints.get(i);
                int chkMatch = NetModuleProperties.matchRectExact(myshape, nextPt);
                if (chkMatch != 0) {
                    shapes.add(myshape.clone());
                    continue block0;
                }
                if (NetModuleProperties.matchRectSide(myshape, nextPt, lastPt)) {
                    shapes.add(myshape.clone());
                    continue block0;
                }
                lastPt = nextPt;
            }
        }
        Map mr4c = this.otherRectsForContig(shapePoints, shapeList, 2);
        NetModuleFree.ContigBreakdown retval = new NetModuleFree.ContigBreakdown(shapes, mr4c);
        return retval;
    }

    public NetModuleFree.TaggedShape directRectIntersect(Point2D pt, List shapeList) {
        int numSL = shapeList.size();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < numSL; ++i) {
                int chkMatch;
                NetModuleFree.TaggedShape ts = (NetModuleFree.TaggedShape)shapeList.get(i);
                if (j == 0 && ts.shapeClass != 2 || j == 1 && ts.shapeClass != 3 || (chkMatch = NetModuleProperties.matchRect(ts.rect, pt, 5.0)) == 0) continue;
                return ts;
            }
        }
        return null;
    }

    private Map otherRectsForContig(List shapePoints, List shapeList, int type) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        int numPts = shapePoints.size();
        int numSL = shapeList.size();
        block0: for (int i = 0; i < numSL; ++i) {
            NetModuleFree.TaggedShape ts = (NetModuleFree.TaggedShape)shapeList.get(i);
            if (ts.shapeClass != type) continue;
            Point2D lastPt = numPts != 0 ? (Point2D)shapePoints.get(numPts - 1) : null;
            for (int j = 0; j < numPts; ++j) {
                Point2D nextPt = (Point2D)shapePoints.get(j);
                int chkMatch = NetModuleProperties.matchRectExact(ts.rect, nextPt);
                if (chkMatch != 0) {
                    retval.put(ts.memberID, ts.rect.clone());
                    continue block0;
                }
                if (NetModuleProperties.matchRectSide(ts.rect, nextPt, lastPt)) {
                    retval.put(ts.memberID, ts.rect.clone());
                    continue block0;
                }
                lastPt = nextPt;
            }
        }
        return retval;
    }

    public Set rectsForDirect(NetModuleFree.IntersectionExtraInfo iexi) {
        HashSet<Object> retval = new HashSet<Object>();
        List exr = this.extractRectangles(iexi);
        if (exr == null) {
            return retval;
        }
        int numEx = exr.size();
        for (int i = 0; i < numEx; ++i) {
            LocatedIntersection li = (LocatedIntersection)exr.get(i);
            retval.add(li.rect.clone());
        }
        return retval;
    }

    public Set specificRectsForDirect(NetModuleFree.IntersectionExtraInfo iexi, boolean noInterior, boolean noExtraDelta) {
        HashSet<Object> retval = new HashSet<Object>();
        List exr = this.extractRectangles(iexi);
        if (exr == null) {
            return retval;
        }
        int numEx = exr.size();
        for (int i = 0; i < numEx; ++i) {
            LocatedIntersection li = (LocatedIntersection)exr.get(i);
            if (noExtraDelta && li.extraDelta != null || noInterior && li.where == -1) continue;
            retval.add(li.rect.clone());
        }
        return retval;
    }

    public boolean haveInteriorRect(NetModuleFree.IntersectionExtraInfo iexi) {
        List exr = this.extractRectangles(iexi);
        if (exr == null) {
            return false;
        }
        int numEx = exr.size();
        for (int i = 0; i < numEx; ++i) {
            LocatedIntersection li = (LocatedIntersection)exr.get(i);
            if (li.where != -1) continue;
            return true;
        }
        return false;
    }

    public boolean haveExtraDeltaRect(NetModuleFree.IntersectionExtraInfo iexi) {
        List exr = this.extractRectangles(iexi);
        if (exr == null) {
            return false;
        }
        int numEx = exr.size();
        for (int i = 0; i < numEx; ++i) {
            LocatedIntersection li = (LocatedIntersection)exr.get(i);
            if (li.extraDelta == null) continue;
            return true;
        }
        return false;
    }

    public static boolean matchRectSide(Rectangle2D testRect, Point2D pt, Point2D pt2) {
        LinkSegment testSeg = new LinkSegment(pt, pt2);
        Point2D.Double cornerPt = new Point2D.Double(0.0, 0.0);
        double tol = 0.001;
        ((Point2D)cornerPt).setLocation(testRect.getX(), testRect.getY());
        if (NetModuleProperties.checkSeg(testSeg, cornerPt, tol) != 0) {
            return true;
        }
        ((Point2D)cornerPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY());
        if (NetModuleProperties.checkSeg(testSeg, cornerPt, tol) != 0) {
            return true;
        }
        ((Point2D)cornerPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
        if (NetModuleProperties.checkSeg(testSeg, cornerPt, tol) != 0) {
            return true;
        }
        ((Point2D)cornerPt).setLocation(testRect.getX(), testRect.getY() + testRect.getHeight());
        return NetModuleProperties.checkSeg(testSeg, cornerPt, tol) != 0;
    }

    public static int matchRectExact(Rectangle2D testRect, Point2D pt) {
        return NetModuleProperties.matchRect(testRect, pt, 0.001);
    }

    public static int matchRect(Rectangle2D testRect, Point2D pt, double tol) {
        Point2D.Double firstPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double secondPt = new Point2D.Double(0.0, 0.0);
        LinkSegment testSeg = new LinkSegment(firstPt, (Point2D)secondPt);
        ((Point2D)firstPt).setLocation(testRect.getX(), testRect.getY());
        ((Point2D)secondPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY());
        testSeg.setBoth(firstPt, secondPt);
        int which = NetModuleProperties.checkSeg(testSeg, pt, tol);
        switch (which) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ((Point2D)firstPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY());
        ((Point2D)secondPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
        testSeg.setBoth(firstPt, secondPt);
        which = NetModuleProperties.checkSeg(testSeg, pt, tol);
        switch (which) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ((Point2D)firstPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
        ((Point2D)secondPt).setLocation(testRect.getX(), testRect.getY() + testRect.getHeight());
        testSeg.setBoth(firstPt, secondPt);
        which = NetModuleProperties.checkSeg(testSeg, pt, tol);
        switch (which) {
            case 1: {
                return 5;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 6;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ((Point2D)firstPt).setLocation(testRect.getX(), testRect.getY() + testRect.getHeight());
        ((Point2D)secondPt).setLocation(testRect.getX(), testRect.getY());
        testSeg.setBoth(firstPt, secondPt);
        which = NetModuleProperties.checkSeg(testSeg, pt, tol);
        switch (which) {
            case 1: {
                return 7;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 8;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return 0;
    }

    public void replaceShape(Rectangle2D oldRect, Rectangle2D newRect) {
        int index = this.rectList_.indexOf(oldRect);
        this.rectList_.set(index, newRect);
    }

    public String getColorTag() {
        return this.colorTag_;
    }

    public void setColorTag(String cTag) {
        this.colorTag_ = cTag;
    }

    public Color getColor() {
        return Database.getDB().getColor(this.colorTag_);
    }

    public String getFillColorTag() {
        return this.fillColorTag_;
    }

    public void setFillColorTag(String cTag) {
        this.fillColorTag_ = cTag;
    }

    public Color getFillColor() {
        return Database.getDB().getColor(this.fillColorTag_);
    }

    public FontManager.FontOverride getFontOverride() {
        return this.localFont_;
    }

    public void setFontOverride(FontManager.FontOverride fontover) {
        this.localFont_ = fontover;
    }

    public void shift(double dx, double dy) {
        int numRect = this.rectList_.size();
        for (int i = 0; i < numRect; ++i) {
            Rectangle2D rect = (Rectangle2D)this.rectList_.get(i);
            rect.setRect(rect.getX() + dx, rect.getY() + dy, rect.getWidth(), rect.getHeight());
        }
        if (this.nameLoc_ != null) {
            this.nameLoc_.setLocation(this.nameLoc_.getX() + dx, this.nameLoc_.getY() + dy);
        }
    }

    public void replaceTypeAndShapes(int type, List shapes) {
        this.type_ = type;
        this.rectList_ = new ArrayList(shapes);
    }

    public Rectangle shapeOnlyBounds() {
        Rectangle extent = null;
        Iterator rlit = this.rectList_.iterator();
        while (rlit.hasNext()) {
            Rectangle2D rec2 = (Rectangle2D)rlit.next();
            Rectangle rect = UiUtil.rectFromRect2D(rec2);
            if (extent == null) {
                extent = rect;
                continue;
            }
            Bounds.tweakBounds(extent, rect);
        }
        return extent;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<nModProp id=\"");
        out.print(this.moduleID_);
        out.print("\" color=\"");
        out.print(this.colorTag_);
        out.print("\" fillColor=\"");
        out.print(this.fillColorTag_);
        out.print("\" type=\"");
        out.print(NetModuleProperties.mapToTypeTag(this.type_));
        if (this.hideName_) {
            out.print("\" hideLabel=\"true");
        }
        out.print("\" nameFade=\"");
        out.print(NetModuleProperties.mapToFadeTag(this.nameFadeMode_));
        if (this.localFont_ != null) {
            out.print("\" fsize=\"");
            out.print(this.localFont_.size);
            out.print("\" fbold=\"");
            out.print(this.localFont_.makeBold);
            out.print("\" fital=\"");
            out.print(this.localFont_.makeItalic);
            out.print("\" fsans=\"");
            out.print(this.localFont_.makeSansSerif);
        }
        if (this.nameLoc_ != null) {
            out.print("\" labelX=\"");
            out.print(this.nameLoc_.getX());
            out.print("\" labelY=\"");
            out.print(this.nameLoc_.getY());
        }
        if (this.lineBreakDef_ != null) {
            out.print("\" breakDef=\"");
            out.print(this.lineBreakDef_);
        }
        if (this.rectList_.size() == 0) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up().indent();
        out.println("<nModPropShapes>");
        Iterator mi = this.rectList_.iterator();
        ind.up();
        while (mi.hasNext()) {
            Rectangle2D rec = (Rectangle2D)mi.next();
            this.writeRectXML(out, ind, rec);
        }
        ind.down().indent();
        out.println("</nModPropShapes>");
        ind.down().indent();
        out.println("</nModProp>");
    }

    public void writeRectXML(PrintWriter out, Indenter ind, Rectangle2D rect) {
        ind.indent();
        out.print("<nModPropShape x=\"");
        out.print(rect.getX());
        out.print("\" y=\"");
        out.print(rect.getY());
        out.print("\" width=\"");
        out.print(rect.getWidth());
        out.print("\" height=\"");
        out.print(rect.getHeight());
        out.println("\" />");
    }

    private Point2D getClosestPointHandleEndpoints(Point2D firstPt, Point2D secondPt, Point2D pt) {
        LinkSegment testSeg = new LinkSegment(firstPt, secondPt);
        Point2D closest = testSeg.getClosestPoint(pt);
        if (closest == null) {
            double dist2;
            double dist1 = pt.distanceSq(firstPt);
            closest = dist1 < (dist2 = pt.distanceSq(secondPt)) ? firstPt : secondPt;
        }
        return closest;
    }

    private Point2D getClosestPoint(int which, Rectangle2D testRect, Point2D pt) {
        Point2D.Double firstPt = new Point2D.Double(0.0, 0.0);
        Point2D.Double secondPt = new Point2D.Double(0.0, 0.0);
        switch (which) {
            case 0: {
                return null;
            }
            case 1: {
                return new Point2D.Double(testRect.getX(), testRect.getY());
            }
            case 2: {
                ((Point2D)firstPt).setLocation(testRect.getX(), testRect.getY());
                ((Point2D)secondPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY());
                return this.getClosestPointHandleEndpoints(firstPt, secondPt, pt);
            }
            case 3: {
                return new Point2D.Double(testRect.getX() + testRect.getWidth(), testRect.getY());
            }
            case 4: {
                ((Point2D)firstPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY());
                ((Point2D)secondPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
                return this.getClosestPointHandleEndpoints(firstPt, secondPt, pt);
            }
            case 5: {
                return new Point2D.Double(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
            }
            case 6: {
                ((Point2D)firstPt).setLocation(testRect.getX() + testRect.getWidth(), testRect.getY() + testRect.getHeight());
                ((Point2D)secondPt).setLocation(testRect.getX(), testRect.getY() + testRect.getHeight());
                return this.getClosestPointHandleEndpoints(firstPt, secondPt, pt);
            }
            case 7: {
                return new Point2D.Double(testRect.getX(), testRect.getY() + testRect.getHeight());
            }
            case 8: {
                ((Point2D)firstPt).setLocation(testRect.getX(), testRect.getY() + testRect.getHeight());
                ((Point2D)secondPt).setLocation(testRect.getX(), testRect.getY());
                return this.getClosestPointHandleEndpoints(firstPt, secondPt, pt);
            }
        }
        throw new IllegalStateException();
    }

    private boolean cornerMatchesSide(int corner, int side) {
        switch (corner) {
            case 0: {
                return false;
            }
            case 1: {
                return side == 2 || side == 8;
            }
            case 3: {
                return side == 2 || side == 4;
            }
            case 7: {
                return side == 6 || side == 8;
            }
            case 5: {
                return side == 6 || side == 4;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    private void moveCorner(int whichCorner, double orx, double ory, double orw, double orh, double dx, double dy, Rectangle2D rect) {
        double nrh;
        double nrw;
        double nry;
        double nrx;
        dx = UiUtil.forceToGridValue(dx, 10.0);
        dy = UiUtil.forceToGridValue(dy, 10.0);
        switch (whichCorner) {
            case 1: {
                nrx = orx + dx;
                nry = ory + dy;
                nrw = orw - dx;
                nrh = orh - dy;
                break;
            }
            case 3: {
                nrx = orx;
                nry = ory + dy;
                nrw = orw + dx;
                nrh = orh - dy;
                break;
            }
            case 7: {
                nrx = orx + dx;
                nry = ory;
                nrw = orw - dx;
                nrh = orh + dy;
                break;
            }
            case 5: {
                nrx = orx;
                nry = ory;
                nrw = orw + dx;
                nrh = orh + dy;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (nrw == 0.0) {
            nrw = 10.0;
        } else if (nrw < 0.0) {
            nrx += nrw;
            nrw = -nrw;
        }
        if (nrh == 0.0) {
            nrh = 10.0;
        } else if (nrh < 0.0) {
            nry += nrh;
            nrh = -nrh;
        }
        rect.setRect(nrx, nry, nrw, nrh);
    }

    private void moveEdge(int whichEdge, double orx, double ory, double orw, double orh, double dx, double dy, Rectangle2D rect) {
        double nrh;
        double nrw;
        double nry;
        double nrx;
        dx = UiUtil.forceToGridValue(dx, 10.0);
        dy = UiUtil.forceToGridValue(dy, 10.0);
        switch (whichEdge) {
            case 2: {
                nrx = orx;
                nry = ory + dy;
                nrw = orw;
                nrh = orh - dy;
                break;
            }
            case 4: {
                nrx = orx;
                nry = ory;
                nrw = orw + dx;
                nrh = orh;
                break;
            }
            case 8: {
                nrx = orx + dx;
                nry = ory;
                nrw = orw - dx;
                nrh = orh;
                break;
            }
            case 6: {
                nrx = orx;
                nry = ory;
                nrw = orw;
                nrh = orh + dy;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (nrw == 0.0) {
            nrw = 10.0;
        } else if (nrw < 0.0) {
            nrx += nrw;
            nrw = -nrw;
        }
        if (nrh == 0.0) {
            nrh = 10.0;
        } else if (nrh < 0.0) {
            nry += nrh;
            nrh = -nrh;
        }
        rect.setRect(nrx, nry, nrw, nrh);
    }

    private List extractRectangles(NetModuleFree.IntersectionExtraInfo iexi) {
        Point2D pt = iexi.intersectPt;
        ArrayList<LocatedIntersection> retval = new ArrayList<LocatedIntersection>();
        switch (this.getType()) {
            case 0: {
                if (!this.hasOneShape()) {
                    throw new IllegalStateException();
                }
                Rectangle2D rect = (Rectangle2D)this.getShapeIterator().next();
                if (iexi.type == 1) {
                    retval.add(new LocatedIntersection(-1, rect, null));
                    return retval;
                }
                int where = NetModuleProperties.matchRectExact(rect, pt);
                Vector2D extraDelta = null;
                if (where == 0) {
                    where = iexi.outerMatch;
                    Point2D closestPoint = this.getClosestPoint(where, rect, pt);
                    extraDelta = closestPoint == null ? null : new Vector2D(closestPoint, pt);
                }
                retval.add(new LocatedIntersection(where, rect, extraDelta));
                return retval;
            }
            case 1: {
                Iterator sit = this.getShapeIterator();
                while (sit.hasNext()) {
                    Rectangle2D nextRect = (Rectangle2D)sit.next();
                    if (iexi.type == 1) {
                        if (!nextRect.contains(pt)) continue;
                        retval.add(new LocatedIntersection(-1, nextRect, null));
                        continue;
                    }
                    int where2 = NetModuleProperties.matchRectExact(nextRect, pt);
                    if (where2 == 0) continue;
                    retval.add(new LocatedIntersection(where2, nextRect, null));
                }
                return retval.isEmpty() ? null : retval;
            }
            case 2: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int checkSeg(LinkSegment seg, Point2D pt, double tol) {
        if (seg.intersectsStart(pt, tol) != null) {
            return 1;
        }
        if (seg.intersectsEnd(pt, tol) != null) {
            return 2;
        }
        if (seg.intersects(pt, tol) != null) {
            return 3;
        }
        return 0;
    }

    public static Vector getDisplayTypes(boolean includeMemberOnly) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            if (i == 2 && !includeMemberOnly) continue;
            retval.add(NetModuleProperties.typeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent typeForCombo(int type) {
        return new ChoiceContent(NetModuleProperties.mapTypeToDisplay(type), type);
    }

    public static String mapTypeToDisplay(int type) {
        String typeTag = NetModuleProperties.mapToTypeTag(type);
        return ResourceManager.getManager().getString("nModProp." + typeTag);
    }

    public static String mapTypeToInstruction(int type) {
        String typeTag = NetModuleProperties.mapToTypeTag(type);
        return ResourceManager.getManager().getString("nModProp.instruction_" + typeTag);
    }

    public static String mapToTypeTag(int val) {
        switch (val) {
            case 0: {
                return CONTIG_STR_;
            }
            case 1: {
                return MULTI_STR_;
            }
            case 2: {
                return MEMBERS_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromTypeTag(String tag) {
        if (tag.equals(CONTIG_STR_)) {
            return 0;
        }
        if (tag.equals(MULTI_STR_)) {
            return 1;
        }
        if (tag.equals(MEMBERS_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getNameFades() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 2; ++i) {
            retval.add(NetModuleProperties.fadeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent fadeForCombo(int fade) {
        return new ChoiceContent(NetModuleProperties.mapFadeToDisplay(fade), fade);
    }

    public static String mapFadeToDisplay(int fade) {
        String fadeTag = NetModuleProperties.mapToFadeTag(fade);
        return ResourceManager.getManager().getString("nModProp." + fadeTag);
    }

    public static String mapToFadeTag(int val) {
        switch (val) {
            case 0: {
                return FADE_QUICKLY_STR_;
            }
            case 1: {
                return FADE_SLOWLY_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromFadeTag(String tag) {
        if (tag.equals(FADE_QUICKLY_STR_)) {
            return 0;
        }
        if (tag.equals(FADE_SLOWLY_STR_)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    class LocatedIntersection {
        int where;
        Rectangle2D rect;
        Vector2D extraDelta;

        LocatedIntersection(int where, Rectangle2D rect, Vector2D extraDelta) {
            this.where = where;
            this.rect = rect;
            this.extraDelta = extraDelta;
        }
    }

    public static class TaggedShape {
        boolean isName;
        Rectangle2D oldShape;
        Rectangle2D shape;

        TaggedShape(Rectangle2D oldShape, Rectangle2D shape, boolean isName) {
            this.isName = isName;
            this.oldShape = oldShape == null ? null : (Rectangle2D)oldShape.clone();
            this.shape = (Rectangle2D)shape.clone();
        }
    }

    public static class MultiClaim {
        HashSet groups;
        Rectangle2D shape;
        boolean isName;

        MultiClaim(Set allGroups, Rectangle2D shape, boolean isName) {
            this.groups = new HashSet(allGroups);
            this.shape = (Rectangle2D)shape.clone();
            this.isName = isName;
        }
    }

    public static class SliceResult {
        public HashMap ownedByGroup = new HashMap();
        public HashSet unclaimed = new HashSet();
        public ArrayList multiClaimed = new ArrayList();

        SliceResult() {
        }

        void merge(List osrList) {
            int numOsr = osrList.size();
            for (int i = 0; i < numOsr; ++i) {
                SliceAndDicer.OneSliceResult osr = (SliceAndDicer.OneSliceResult)osrList.get(i);
                if (osr.status == 1) {
                    this.unclaimed.add(new TaggedShape(null, osr.shape, osr.isName));
                    continue;
                }
                if (osr.status == 2) {
                    MultiClaim mc = new MultiClaim(osr.groups, osr.shape, osr.isName);
                    this.multiClaimed.add(mc);
                    continue;
                }
                if (osr.status != 0) continue;
                String grpID = (String)osr.groups.iterator().next();
                ArrayList<TaggedShape> obg = (ArrayList<TaggedShape>)this.ownedByGroup.get(grpID);
                if (obg == null) {
                    obg = new ArrayList<TaggedShape>();
                    this.ownedByGroup.put(grpID, obg);
                }
                obg.add(new TaggedShape(null, osr.shape, osr.isName));
            }
        }
    }

    public static class NMPShapeWorker
    extends AbstractFactoryClient {
        public NMPShapeWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nModPropShape");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Rectangle2D retval = null;
            if (elemName.equals("nModPropShape")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.nmpShape = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Rectangle2D buildFromXML(String elemName, Attributes attrs) throws IOException {
            String xStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModPropShape", "x", true);
            String yStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModPropShape", "y", true);
            String wStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModPropShape", "width", true);
            String hStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModPropShape", "height", true);
            try {
                double x = Double.parseDouble(xStr);
                double y = Double.parseDouble(yStr);
                double w = Double.parseDouble(wStr);
                double h = Double.parseDouble(hStr);
                return new Rectangle2D.Double(x, y, w, h);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModuleProperties nmp = board.netModProps;
            Rectangle2D shape = board.nmpShape;
            nmp.addShape(shape);
            return null;
        }
    }

    public static class NetModulePropertiesWorker
    extends AbstractFactoryClient {
        public NetModulePropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nModProp");
            this.installWorker(new NMPShapeWorker(whiteboard), new MyGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetModuleProperties retval = null;
            if (elemName.equals("nModProp")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netModProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NetModuleProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "id", true);
            String color = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "color", true);
            String fillColor = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "fillColor", true);
            String type = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "type", true);
            String hideLabelStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "hideLabel", false);
            String labelXStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "labelX", false);
            String labelYStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "labelY", false);
            String fadeModeStr = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "nameFade", false);
            boolean hideLabel = hideLabelStr == null ? false : Boolean.valueOf(hideLabelStr);
            Point2D.Double labelLoc = null;
            if (labelXStr != null && labelYStr != null) {
                try {
                    double labelX = Double.parseDouble(labelXStr);
                    double labelY = Double.parseDouble(labelYStr);
                    labelLoc = new Point2D.Double(labelX, labelY);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException();
                }
            }
            String breakDef = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "breakDef", false);
            NetModuleProperties retval = new NetModuleProperties(id, type, color, fillColor, breakDef, hideLabel, fadeModeStr, labelLoc);
            String fsize = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "fsize", false);
            String fbold = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "fbold", false);
            String fital = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "fital", false);
            String fsans = AttributeExtractor.extractAttribute(elemName, attrs, "nModProp", "fsans", false);
            if (fsize != null) {
                int size;
                if (fbold == null || fital == null || fsans == null) {
                    throw new IOException();
                }
                boolean makeBold = Boolean.valueOf(fbold);
                boolean makeItalic = Boolean.valueOf(fital);
                boolean makeSansSerif = Boolean.valueOf(fsans);
                try {
                    size = Integer.parseInt(fsize);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException();
                }
                if (size < 6 || size > 40) {
                    throw new IOException();
                }
                FontManager.FontOverride fo = new FontManager.FontOverride(size, makeBold, makeItalic, makeSansSerif);
                retval.setFontOverride(fo);
            }
            return retval;
        }
    }
}

