/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.NodeBounder;
import org.systemsbiology.biotapestry.util.AffineCombination;
import org.systemsbiology.biotapestry.util.RectDefinedByRects;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class NetModuleShapeFixer {
    public ModuleRelocateInfo getModuleRelocInfo(Genome useGenome, Layout layout, NetModule.FullModuleKey fullKey, Point2D center, FontRenderContext frc) {
        Database db = Database.getDB();
        NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
        NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
        NetModule nmod = no.getModule(fullKey.modKey);
        NetOverlayProperties nop = layout.getNetOverlayProperties(fullKey.ovrKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
        Rectangle2D nameBounds = nmp.getRenderer().getNameBounds(nmp, nmod, frc);
        ModuleRelocateInfo mri = new ModuleRelocateInfo(fullKey.modKey, center, nameBounds);
        HashSet<String> nodeSet = new HashSet<String>();
        Iterator memit = nmod.getMemberIterator();
        while (memit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)memit.next();
            String nodeID = nmm.getID();
            nodeSet.add(nodeID);
            NodeProperties np = layout.getNodeProperties(nodeID);
            Point2D nodeLoc = np.getLocation();
            mri.memberLocs.put(nodeID, nodeLoc.clone());
        }
        mri.memberRects = NodeBounder.nodeRects(nodeSet, useGenome, layout, frc, 10);
        int modType = nmp.getType();
        if (modType == 2) {
            return mri;
        }
        Iterator sit = nmp.getShapeIterator();
        while (sit.hasNext()) {
            Rectangle2D nextRect = (Rectangle2D)sit.next();
            mri.oldShapes.add(nextRect.clone());
        }
        return mri;
    }

    public List getModuleRelocInfoForRegions(Map claimedSlices, List unclaimedSlices, NetModule.FullModuleKey fullKey, Point2D useCenter) {
        ArrayList<RectResolution> retval = new ArrayList<RectResolution>();
        HashSet<RectDefinedByRects.TaggedRect> defined = new HashSet<RectDefinedByRects.TaggedRect>();
        ArrayList<Rectangle2D> definedRects = new ArrayList<Rectangle2D>();
        ArrayList<RectDefinedByRects.TaggedRect> remaining = new ArrayList<RectDefinedByRects.TaggedRect>();
        Iterator oit = claimedSlices.keySet().iterator();
        while (oit.hasNext()) {
            String ownerGrpID = (String)oit.next();
            HashMap perGroup = (HashMap)claimedSlices.get(ownerGrpID);
            Layout.DicedModuleInfo shapesPerKey = (Layout.DicedModuleInfo)perGroup.get(fullKey);
            if (shapesPerKey == null) continue;
            int numShape = shapesPerKey.dicedShapes.size();
            for (int i = 0; i < numShape; ++i) {
                NetModuleProperties.TaggedShape tShape = (NetModuleProperties.TaggedShape)shapesPerKey.dicedShapes.get(i);
                GroupTRKey rrKey = new GroupTRKey(ownerGrpID, tShape.isName);
                RectDefinedByRects.TaggedRect tr = new RectDefinedByRects.TaggedRect(tShape.shape, rrKey);
                defined.add(tr);
                definedRects.add(tr.rect);
            }
        }
        int numShape = unclaimedSlices.size();
        for (int i = 0; i < numShape; ++i) {
            NetModuleProperties.TaggedShape tShape = (NetModuleProperties.TaggedShape)unclaimedSlices.get(i);
            GroupTRKey rrKey = new GroupTRKey(i, tShape.isName);
            RectDefinedByRects.TaggedRect tr = new RectDefinedByRects.TaggedRect(tShape.shape, rrKey);
            remaining.add(tr);
        }
        Collections.sort(remaining, new RectDefinedByRects.RectOrdering());
        int lastCount = remaining.size();
        if (lastCount > 0) {
            while (true) {
                Point2D savePoint;
                Point2D usePoint;
                int newCount;
                int index = 0;
                if (!defined.isEmpty()) {
                    while (index < remaining.size()) {
                        RectDefinedByRects.TaggedRect tr = (RectDefinedByRects.TaggedRect)remaining.get(index);
                        RectDefinedByRects rdbr = new RectDefinedByRects(tr.rect, defined);
                        if (rdbr.isDefined()) {
                            retval.add(new RectResolution(2, false, tr.rect, rdbr, tr.tag));
                            defined.add(tr);
                            definedRects.add(tr.rect);
                            remaining.remove(index);
                            continue;
                        }
                        ++index;
                    }
                }
                if ((newCount = remaining.size()) == 0) break;
                if (newCount < lastCount) {
                    lastCount = newCount;
                    continue;
                }
                if (!defined.isEmpty()) {
                    usePoint = this.calcCentroidFromShapes(definedRects);
                    savePoint = null;
                } else {
                    savePoint = usePoint = (Point2D)useCenter.clone();
                }
                RectDefinedByRects.TaggedRect tr = (RectDefinedByRects.TaggedRect)remaining.get(0);
                Point2D.Double rectCenter = new Point2D.Double(tr.rect.getCenterX(), tr.rect.getCenterY());
                UiUtil.forceToGrid(rectCenter, 10.0);
                Vector2D centroidDelta = new Vector2D(usePoint, rectCenter);
                retval.add(new RectResolution(0, false, tr.rect, savePoint, centroidDelta, tr.tag));
                defined.add(tr);
                definedRects.add(tr.rect);
                remaining.remove(0);
            }
        }
        return retval;
    }

    public NetModuleProperties shiftModuleShapesPerParams(Genome useGenome, Layout layout, NetModule.FullModuleKey fullKey, ModuleRelocateInfo mri, FontRenderContext frc, Point2D center) {
        Set nodeSet = this.parameterizeOldShapes(mri, layout, fullKey, frc);
        NetOverlayProperties nop = layout.getNetOverlayProperties(fullKey.ovrKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
        int modType = nmp.getType();
        if (modType == 2) {
            if (mri.newNameLoc != null) {
                NetModuleProperties changedProps = (NetModuleProperties)nmp.clone();
                changedProps.setNameLocation(mri.newNameLoc);
                return changedProps;
            }
            return null;
        }
        Map newMemberRects = NodeBounder.nodeRects(nodeSet, useGenome, layout, frc, 10);
        HashMap<RectDefinedByRects.TaggedRect, Rectangle2D> fixupMap = new HashMap<RectDefinedByRects.TaggedRect, Rectangle2D>();
        Iterator survit = mri.survivingRects.iterator();
        while (survit.hasNext()) {
            RectDefinedByRects.TaggedRect tr = (RectDefinedByRects.TaggedRect)survit.next();
            String nodeID = (String)tr.tag;
            Rectangle2D newMR = (Rectangle2D)newMemberRects.get(nodeID);
            fixupMap.put(tr, newMR);
        }
        ArrayList<Rectangle2D> convertList = new ArrayList<Rectangle2D>();
        Point2D.Double newNameLoc = null;
        int numRes = mri.resolutionList.size();
        block5: for (int i = 0; i < numRes; ++i) {
            RectResolution rectRes = (RectResolution)mri.resolutionList.get(i);
            boolean isName = mri.nameTag != null && rectRes.tag.equals(mri.nameTag);
            switch (rectRes.type) {
                case 1: 
                case 2: {
                    Rectangle2D newDefined = rectRes.rdbr.generateNewRect(fixupMap);
                    if (isName) {
                        newNameLoc = new Point2D.Double(newDefined.getCenterX(), newDefined.getCenterY());
                    } else {
                        convertList.add(newDefined);
                    }
                    fixupMap.put(new RectDefinedByRects.TaggedRect(rectRes.rect, rectRes.tag), newDefined);
                    continue block5;
                }
                case 0: {
                    Point2D usePoint = rectRes.point != null ? center : this.calcCentroidFromShapes(convertList);
                    Point2D newCenter = rectRes.offset.add(usePoint);
                    Point2D.Double newCorner = new Point2D.Double(newCenter.getX() - rectRes.rect.getWidth() / 2.0, newCenter.getY() - rectRes.rect.getHeight() / 2.0);
                    UiUtil.forceToGrid(newCorner, 10.0);
                    Rectangle2D newDefined = new Rectangle2D.Double(((Point2D)newCorner).getX(), ((Point2D)newCorner).getY(), rectRes.rect.getWidth(), rectRes.rect.getHeight());
                    if (isName) {
                        newNameLoc = new Point2D.Double(newDefined.getCenterX(), newDefined.getCenterY());
                    } else {
                        convertList.add(newDefined);
                    }
                    fixupMap.put(new RectDefinedByRects.TaggedRect(rectRes.rect, rectRes.tag), newDefined);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        NetModuleProperties changedProps = null;
        if (!convertList.isEmpty()) {
            changedProps = (NetModuleProperties)nmp.clone();
            changedProps.replaceTypeAndShapes(modType, convertList);
        }
        if (newNameLoc != null) {
            if (changedProps == null) {
                changedProps = (NetModuleProperties)nmp.clone();
            }
            changedProps.setNameLocation(newNameLoc);
        }
        return changedProps;
    }

    private Map buildFixupMapForKey(NetModule.FullModuleKey fullKey, Map oldToNewShapeMap, Map deltas, Map claimedSlices, Map unclaimedSlices) {
        Rectangle2D oldName = this.getOldNameRect(claimedSlices, unclaimedSlices, fullKey);
        HashMap<RectDefinedByRects.TaggedRect, Rectangle2D> retval = new HashMap<RectDefinedByRects.TaggedRect, Rectangle2D>();
        Iterator kit1 = oldToNewShapeMap.keySet().iterator();
        while (kit1.hasNext()) {
            String grpID = (String)kit1.next();
            Map oldToNewForGroup = (Map)oldToNewShapeMap.get(grpID);
            Vector2D delta = (Vector2D)deltas.get(grpID);
            Iterator kit2 = oldToNewForGroup.keySet().iterator();
            while (kit2.hasNext()) {
                String ovrID = (String)kit2.next();
                if (!ovrID.equals(fullKey.ovrKey)) continue;
                Map oldToNewForOverlay = (Map)oldToNewForGroup.get(ovrID);
                Iterator kit3 = oldToNewForOverlay.keySet().iterator();
                while (kit3.hasNext()) {
                    String modID = (String)kit3.next();
                    if (!modID.equals(fullKey.modKey)) continue;
                    List oldAndNew = (List)oldToNewForOverlay.get(modID);
                    Iterator kit4 = oldAndNew.iterator();
                    while (kit4.hasNext()) {
                        NetModuleProperties.TaggedShape ts = (NetModuleProperties.TaggedShape)kit4.next();
                        Rectangle2D newShape = ts.shape;
                        Rectangle2D useShape = (Rectangle2D)newShape.clone();
                        if (delta != null) {
                            useShape.setRect(newShape.getX() + delta.getX(), newShape.getY() + delta.getY(), newShape.getWidth(), newShape.getHeight());
                        }
                        GroupTRKey gtrk = new GroupTRKey(grpID, ts.isName);
                        Rectangle2D oldShape = ts.isName ? oldName : ts.oldShape;
                        if (oldShape == null) continue;
                        oldShape = (Rectangle2D)oldShape.clone();
                        RectDefinedByRects.TaggedRect tr = new RectDefinedByRects.TaggedRect(oldShape, gtrk);
                        retval.put(tr, useShape);
                    }
                }
            }
        }
        return retval;
    }

    private Rectangle2D getOldNameRect(Map claimedSlices, Map unclaimedSlices, NetModule.FullModuleKey fullKey) {
        Layout.DicedModuleInfo dmi = (Layout.DicedModuleInfo)unclaimedSlices.get(fullKey);
        int numRes = dmi.dicedRectByRects.size();
        for (int i = 0; i < numRes; ++i) {
            RectResolution rectRes = (RectResolution)dmi.dicedRectByRects.get(i);
            GroupTRKey gkey = (GroupTRKey)rectRes.tag;
            if (!gkey.isName()) continue;
            return rectRes.rect;
        }
        Iterator oit = claimedSlices.keySet().iterator();
        while (oit.hasNext()) {
            String ownerGrpID = (String)oit.next();
            HashMap perGroup = (HashMap)claimedSlices.get(ownerGrpID);
            Layout.DicedModuleInfo shapesPerKey = (Layout.DicedModuleInfo)perGroup.get(fullKey);
            if (shapesPerKey == null) continue;
            int numShape = shapesPerKey.dicedShapes.size();
            for (int i = 0; i < numShape; ++i) {
                NetModuleProperties.TaggedShape tShape = (NetModuleProperties.TaggedShape)shapesPerKey.dicedShapes.get(i);
                if (!tShape.isName) continue;
                return tShape.oldShape;
            }
        }
        return null;
    }

    private void fillInUndefined(Map unclaimedSlices, Map deltas, Map fixupMap) {
        Iterator uskit = unclaimedSlices.keySet().iterator();
        while (uskit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)uskit.next();
            Layout.DicedModuleInfo dmi = (Layout.DicedModuleInfo)unclaimedSlices.get(fullKey);
            int numRes = dmi.dicedRectByRects.size();
            for (int i = 0; i < numRes; ++i) {
                RectResolution rectRes = (RectResolution)dmi.dicedRectByRects.get(i);
                if (rectRes.type != 2) continue;
                Set needKeys = rectRes.rdbr.definedByKeys();
                Iterator nkit = needKeys.iterator();
                while (nkit.hasNext()) {
                    GroupTRKey gkey;
                    String grpID;
                    RectDefinedByRects.TaggedRect tr = (RectDefinedByRects.TaggedRect)nkit.next();
                    if (fixupMap.get(tr) != null || (grpID = (gkey = (GroupTRKey)tr.tag).getGroupID()) == null) continue;
                    Vector2D delta = (Vector2D)deltas.get(grpID);
                    Rectangle2D useShape = (Rectangle2D)tr.rect.clone();
                    if (delta != null) {
                        useShape.setRect(useShape.getX() + delta.getX(), useShape.getY() + delta.getY(), useShape.getWidth(), useShape.getHeight());
                    }
                    RectDefinedByRects.TaggedRect tr1 = (RectDefinedByRects.TaggedRect)tr.clone();
                    fixupMap.put(tr1, useShape);
                }
            }
        }
    }

    public void pinModuleShapesForGroups(Map oldToNewShapeMap, Map claimedSlices, Map unclaimedSlices, Map deltas, Point2D center) {
        Iterator uskit = unclaimedSlices.keySet().iterator();
        while (uskit.hasNext()) {
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)uskit.next();
            Map fixupMap = this.buildFixupMapForKey(fullKey, oldToNewShapeMap, deltas, claimedSlices, unclaimedSlices);
            this.fillInUndefined(unclaimedSlices, deltas, fixupMap);
            ArrayList<Rectangle2D> justShapes = new ArrayList<Rectangle2D>();
            Iterator oit = claimedSlices.keySet().iterator();
            while (oit.hasNext()) {
                String ownerGrpID = (String)oit.next();
                HashMap perGroup = (HashMap)claimedSlices.get(ownerGrpID);
                Layout.DicedModuleInfo shapesPerKey = (Layout.DicedModuleInfo)perGroup.get(fullKey);
                if (shapesPerKey == null) continue;
                int numShape = shapesPerKey.dicedShapes.size();
                for (int i = 0; i < numShape; ++i) {
                    NetModuleProperties.TaggedShape tShape = (NetModuleProperties.TaggedShape)shapesPerKey.dicedShapes.get(i);
                    Rectangle2D useShape = (Rectangle2D)tShape.shape.clone();
                    Vector2D delta = (Vector2D)deltas.get(ownerGrpID);
                    if (delta != null) {
                        useShape.setRect(useShape.getX() + delta.getX(), useShape.getY() + delta.getY(), useShape.getWidth(), useShape.getHeight());
                    }
                    justShapes.add(useShape);
                }
            }
            Layout.DicedModuleInfo dmi = (Layout.DicedModuleInfo)unclaimedSlices.get(fullKey);
            dmi.dicedShapes = new ArrayList();
            int numRes = dmi.dicedRectByRects.size();
            block7: for (int i = 0; i < numRes; ++i) {
                RectResolution rectRes = (RectResolution)dmi.dicedRectByRects.get(i);
                Rectangle2D oldShape = (Rectangle2D)rectRes.rect.clone();
                GroupTRKey gkey = (GroupTRKey)rectRes.tag;
                switch (rectRes.type) {
                    case 2: {
                        Rectangle2D newDefined = rectRes.rdbr.generateNewRect(fixupMap);
                        UiUtil.force2DToGrid(newDefined, 10.0);
                        NetModuleProperties.TaggedShape ts = new NetModuleProperties.TaggedShape(oldShape, newDefined, gkey.isName());
                        justShapes.add(newDefined);
                        dmi.dicedShapes.add(ts);
                        fixupMap.put(new RectDefinedByRects.TaggedRect(rectRes.rect, rectRes.tag), newDefined);
                        continue block7;
                    }
                    case 0: {
                        Point2D usePoint = rectRes.point != null ? center : this.calcCentroidFromShapes(justShapes);
                        Point2D newCenter = rectRes.offset.add(usePoint);
                        Point2D.Double newCorner = new Point2D.Double(newCenter.getX() - rectRes.rect.getWidth() / 2.0, newCenter.getY() - rectRes.rect.getHeight() / 2.0);
                        UiUtil.forceToGrid(newCorner, 10.0);
                        Rectangle2D newDefined = new Rectangle2D.Double(((Point2D)newCorner).getX(), ((Point2D)newCorner).getY(), rectRes.rect.getWidth(), rectRes.rect.getHeight());
                        NetModuleProperties.TaggedShape ts = new NetModuleProperties.TaggedShape(oldShape, newDefined, gkey.isName());
                        justShapes.add(newDefined);
                        dmi.dicedShapes.add(ts);
                        fixupMap.put(new RectDefinedByRects.TaggedRect(rectRes.rect, rectRes.tag), newDefined);
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private Set parameterizeOldShapes(ModuleRelocateInfo mri, Layout layout, NetModule.FullModuleKey fullKey, FontRenderContext frc) {
        RectDefinedByRects.TaggedRect tr;
        RectDefinedByRects rdbr;
        Database db = Database.getDB();
        NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fullKey.ownerKey);
        NetworkOverlay no = noo.getNetworkOverlay(fullKey.ovrKey);
        NetModule nmod = no.getModule(fullKey.modKey);
        NetOverlayProperties nop = layout.getNetOverlayProperties(fullKey.ovrKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(fullKey.modKey);
        int modType = nmp.getType();
        HashSet<Point2D> oldPointSet = new HashSet<Point2D>();
        HashSet<Object> newPointSet = new HashSet<Object>();
        HashSet<String> nodeSet = new HashSet<String>();
        Iterator memit = nmod.getMemberIterator();
        while (memit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)memit.next();
            String nodeID = nmm.getID();
            nodeSet.add(nodeID);
            if (modType != 2) {
                mri.survivingRects.add(new RectDefinedByRects.TaggedRect((Rectangle)mri.memberRects.get(nodeID), nodeID));
                continue;
            }
            Point2D memberLoc = (Point2D)mri.memberLocs.get(nodeID);
            oldPointSet.add(memberLoc);
            NodeProperties np = layout.getNodeProperties(nodeID);
            Point2D nodeLoc = np.getLocation();
            newPointSet.add(nodeLoc.clone());
        }
        if (modType == 2) {
            if (mri.nameBounds == null) {
                mri.newNameLoc = null;
            } else {
                Point2D.Double nameCenter = new Point2D.Double(mri.nameBounds.getCenterX(), mri.nameBounds.getCenterY());
                UiUtil.forceToGrid(nameCenter, 10.0);
                if (!oldPointSet.isEmpty() && !newPointSet.isEmpty()) {
                    Point2D oldCentroid = AffineCombination.combination(oldPointSet, 10.0);
                    Vector2D nameOffset = new Vector2D(oldCentroid, nameCenter);
                    Point2D newCentroid = AffineCombination.combination(newPointSet, 10.0);
                    mri.newNameLoc = nameOffset.add(newCentroid);
                } else {
                    mri.newNameLoc = nameCenter;
                }
            }
            return nodeSet;
        }
        HashSet<RectDefinedByRects.TaggedRect> defined = new HashSet<RectDefinedByRects.TaggedRect>();
        ArrayList<Rectangle2D> definedRects = new ArrayList<Rectangle2D>();
        ArrayList<RectDefinedByRects.TaggedRect> remaining = new ArrayList<RectDefinedByRects.TaggedRect>();
        mri.nameTag = null;
        int numOld = mri.oldShapes.size();
        int highIndex = mri.nameBounds == null ? numOld : numOld + 1;
        for (int i = 0; i < highIndex; ++i) {
            boolean isName = i == numOld;
            Rectangle2D nextRect = !isName ? (Rectangle2D)mri.oldShapes.get(i) : mri.nameBounds;
            rdbr = new RectDefinedByRects(nextRect, mri.survivingRects);
            Integer rrKey = new Integer(i);
            if (isName) {
                mri.nameTag = rrKey;
            }
            tr = new RectDefinedByRects.TaggedRect(nextRect, rrKey);
            if (rdbr.isDefined()) {
                mri.resolutionList.add(new RectResolution(1, isName, nextRect, rdbr, rrKey));
                defined.add(tr);
                definedRects.add(nextRect);
                continue;
            }
            remaining.add(tr);
        }
        int lastCount = remaining.size();
        if (lastCount > 0) {
            while (true) {
                Point2D savePoint;
                Point2D usePoint;
                int newCount;
                int index = 0;
                if (!defined.isEmpty()) {
                    while (index < remaining.size()) {
                        boolean isName;
                        RectDefinedByRects.TaggedRect tr2 = (RectDefinedByRects.TaggedRect)remaining.get(index);
                        rdbr = new RectDefinedByRects(tr2.rect, defined);
                        boolean bl = isName = mri.nameTag != null && tr2.tag.equals(mri.nameTag);
                        if (rdbr.isDefined()) {
                            mri.resolutionList.add(new RectResolution(2, isName, tr2.rect, rdbr, tr2.tag));
                            defined.add(tr2);
                            definedRects.add(tr2.rect);
                            remaining.remove(index);
                            continue;
                        }
                        ++index;
                    }
                }
                if ((newCount = remaining.size()) == 0) break;
                if (newCount < lastCount) {
                    lastCount = newCount;
                    continue;
                }
                if (!defined.isEmpty()) {
                    usePoint = this.calcCentroidFromShapes(definedRects);
                    savePoint = null;
                } else {
                    savePoint = usePoint = (Point2D)mri.center.clone();
                }
                tr = (RectDefinedByRects.TaggedRect)remaining.get(0);
                Point2D.Double rectCenter = new Point2D.Double(tr.rect.getCenterX(), tr.rect.getCenterY());
                UiUtil.forceToGrid(rectCenter, 10.0);
                Vector2D centroidDelta = new Vector2D(usePoint, rectCenter);
                boolean isName = mri.nameTag != null && tr.tag.equals(mri.nameTag);
                mri.resolutionList.add(new RectResolution(0, isName, tr.rect, savePoint, centroidDelta, tr.tag));
                defined.add(tr);
                definedRects.add(tr.rect);
                remaining.remove(0);
            }
        }
        return nodeSet;
    }

    private Point2D calcCentroidFromShapes(List definedRects) {
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        int numRes = definedRects.size();
        double[] weights = new double[numRes];
        for (int i = 0; i < numRes; ++i) {
            Rectangle2D calcRect = (Rectangle2D)definedRects.get(i);
            Point2D.Double rectCenter = new Point2D.Double(calcRect.getCenterX(), calcRect.getCenterY());
            pointList.add(rectCenter);
            weights[i] = calcRect.getHeight() * calcRect.getWidth();
        }
        if (pointList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Point2D centroid = AffineCombination.combination(pointList, weights, 10.0);
        return centroid;
    }

    public static class GroupTRKey
    implements Cloneable {
        private boolean isName;
        private String groupID;
        private int unclaimedIndex;

        public GroupTRKey(String groupID, boolean isName) {
            this.groupID = groupID;
            this.isName = isName;
        }

        public GroupTRKey(int unclaimedIndex, boolean isName) {
            this.unclaimedIndex = unclaimedIndex;
            this.isName = isName;
        }

        public boolean isName() {
            return this.isName;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public Object clone() {
            try {
                GroupTRKey newVal = (GroupTRKey)super.clone();
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            int baseVal = this.groupID != null ? this.groupID.hashCode() : this.unclaimedIndex;
            int nameInc = this.isName ? 1 : 0;
            return baseVal + nameInc;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof GroupTRKey)) {
                return false;
            }
            GroupTRKey otherTR = (GroupTRKey)other;
            if (this.isName != otherTR.isName) {
                return false;
            }
            if (this.groupID == null) {
                if (otherTR.groupID != null) {
                    return false;
                }
                return this.unclaimedIndex == otherTR.unclaimedIndex;
            }
            return this.groupID.equals(otherTR.groupID);
        }
    }

    public static class RectResolution {
        public static final int BY_CENTROID = 0;
        public static final int BY_MEMBERS = 1;
        public static final int BY_DEFINED_RECTS = 2;
        public int type;
        public Object tag;
        public Rectangle2D rect;
        public RectDefinedByRects rdbr;
        public Point2D point;
        public Vector2D offset;
        public boolean isName;

        RectResolution(int type, boolean isName, Rectangle2D rect, RectDefinedByRects rdbr, Object tag) {
            this.type = type;
            this.tag = tag;
            this.rect = rect;
            this.rdbr = rdbr;
            this.isName = isName;
        }

        RectResolution(int type, boolean isName, Rectangle2D rect, Point2D point, Vector2D offset, Object tag) {
            this.type = type;
            this.tag = tag;
            this.rect = rect;
            this.point = point;
            this.offset = offset;
            this.isName = isName;
        }
    }

    public static class ModuleRelocateInfo {
        String modKey;
        Map memberRects;
        ArrayList oldShapes;
        HashSet survivingRects;
        ArrayList resolutionList;
        Point2D center;
        Point2D newNameLoc;
        Rectangle2D nameBounds;
        HashMap memberLocs;
        Object nameTag;

        ModuleRelocateInfo(String modKey, Point2D center, Rectangle2D nameBounds) {
            this.modKey = modKey;
            this.center = center;
            this.nameBounds = nameBounds;
            this.oldShapes = new ArrayList();
            this.resolutionList = new ArrayList();
            this.survivingRects = new HashSet();
            this.memberLocs = new HashMap();
        }
    }
}

