/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class NetOverlayProperties
implements Cloneable {
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 1;
    public static final int UNDERLAY = 2;
    private static final int NUM_TYPES_ = 3;
    public static final int NO_RELAYOUT_OPTION = -1;
    public static final int RELAYOUT_TO_MEMBER_ONLY = 0;
    public static final int RELAYOUT_SHIFT_AND_RESIZE_SHAPES = 1;
    public static final int RELAYOUT_NO_CHANGE = 2;
    private static final int NUM_RELAYOUT_OPTIONS_ = 3;
    public static final int NO_CPEX_LAYOUT_OPTION = -1;
    public static final int CPEX_LAYOUT_TO_MEMBER_ONLY = 0;
    public static final int CPEX_LAYOUT_APPLY_ALGORITHM = 1;
    private static final int NUM_CPEX_LAYOUT_OPTIONS_ = 2;
    private static final String TRANSPARENT_STR_ = "trans";
    private static final String OPAQUE_STR_ = "opaque";
    private static final String UNDERLAY_STR_ = "underlay";
    private static final String RELAYOUT_TO_MEMBER_ONLY_STR_ = "relayoutMemOnly";
    private static final String RELAYOUT_SHIFT_AND_RESIZE_SHAPES_STR_ = "relayoutShiftResizeShape";
    private static final String RELAYOUT_NO_CHANGE_STR_ = "relayoutNoChange";
    private static final String CPEX_LAYOUT_TO_MEMBER_ONLY_STR_ = "cpexLayoutMemberOnly";
    private static final String CPEX_LAYOUT_APPLY_ALGORITHM_STR_ = "cpexApplyAlgorithm";
    private String ref_;
    private int type_;
    private boolean hideLinks_;
    private HashMap modules_;
    private HashMap linkToTree_;
    private HashMap linkTreeProps_;

    public NetOverlayProperties(String ref, int type, boolean hideLinks) {
        this.ref_ = ref;
        this.type_ = type;
        this.hideLinks_ = hideLinks;
        this.modules_ = new HashMap();
        this.linkToTree_ = new HashMap();
        this.linkTreeProps_ = new HashMap();
    }

    public NetOverlayProperties(String ref, String typeStr, String hideStr) throws IOException {
        if (ref == null || typeStr == null) {
            throw new IOException();
        }
        this.ref_ = ref;
        try {
            this.type_ = NetOverlayProperties.mapFromTypeTag(typeStr);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException();
        }
        this.hideLinks_ = hideStr != null ? Boolean.valueOf(hideStr) : false;
        this.modules_ = new HashMap();
        this.linkToTree_ = new HashMap();
        this.linkTreeProps_ = new HashMap();
    }

    public NetOverlayProperties(NetOverlayProperties other, String newRef, Map modIDMap, Map modLinkIDMap, boolean retainTreeIDs) {
        this.ref_ = newRef;
        this.type_ = other.type_;
        this.hideLinks_ = other.hideLinks_;
        this.modules_ = new HashMap();
        Iterator mpit = other.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String key = (String)mpit.next();
            NetModuleProperties np = (NetModuleProperties)other.modules_.get(key);
            String newKey = modIDMap == null ? null : (String)modIDMap.get(key);
            if (newKey == null) continue;
            NetModuleProperties newNp = new NetModuleProperties(np, newKey, null);
            this.modules_.put(newKey, newNp);
        }
        HashSet<String> treesToRecover = new HashSet<String>();
        Iterator mlkit = other.linkToTree_.keySet().iterator();
        while (mlkit.hasNext()) {
            String oldLinkKey = (String)mlkit.next();
            String newLinkKey = (String)modLinkIDMap.get(oldLinkKey);
            if (newLinkKey == null) continue;
            String oldPropKey = (String)other.linkToTree_.get(oldLinkKey);
            treesToRecover.add(oldPropKey);
        }
        DBGenome rootGenome = (DBGenome)Database.getDB().getGenome();
        HashMap<String, String> treeToTree = new HashMap<String, String>();
        this.linkTreeProps_ = new HashMap();
        Iterator t2rit = treesToRecover.iterator();
        while (t2rit.hasNext()) {
            String key = (String)t2rit.next();
            NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)other.linkTreeProps_.get(key);
            String newKey = retainTreeIDs ? nmlp.getID() : rootGenome.getNextKey();
            NetModuleLinkageProperties newNmlp = new NetModuleLinkageProperties(nmlp, newKey, newRef, modIDMap, modLinkIDMap);
            treeToTree.put(key, newKey);
            this.linkTreeProps_.put(newKey, newNmlp);
        }
        this.linkToTree_ = new HashMap();
        Iterator l2tit = modLinkIDMap.keySet().iterator();
        while (l2tit.hasNext()) {
            String oldLinkKey = (String)l2tit.next();
            String oldPropKey = (String)other.linkToTree_.get(oldLinkKey);
            if (oldPropKey == null) continue;
            String newLinkKey = (String)modLinkIDMap.get(oldLinkKey);
            String newPropKey = (String)treeToTree.get(oldPropKey);
            if (newLinkKey == null || newPropKey == null || oldPropKey == null || oldLinkKey == null) {
                System.err.println("newLinkKey = " + newLinkKey + " newPropKey = " + newPropKey + " oldPropKey = " + oldPropKey + " oldLinkKey = " + oldLinkKey);
                throw new IllegalStateException();
            }
            this.linkToTree_.put(newLinkKey, newPropKey);
        }
    }

    public Object clone() {
        try {
            NetOverlayProperties retval = (NetOverlayProperties)super.clone();
            retval.modules_ = new HashMap();
            Iterator mpit = this.modules_.keySet().iterator();
            while (mpit.hasNext()) {
                String key = (String)mpit.next();
                NetModuleProperties np = (NetModuleProperties)this.modules_.get(key);
                retval.modules_.put(key, (NetModuleProperties)np.clone());
            }
            retval.linkTreeProps_ = new HashMap();
            Iterator ltpit = this.linkTreeProps_.keySet().iterator();
            while (ltpit.hasNext()) {
                String key = (String)ltpit.next();
                NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)this.linkTreeProps_.get(key);
                retval.linkTreeProps_.put(key, (NetModuleLinkageProperties)nmlp.clone());
            }
            retval.linkToTree_ = (HashMap)this.linkToTree_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getReference() {
        return this.ref_;
    }

    public int getType() {
        return this.type_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public boolean hideLinks() {
        return this.hideLinks_;
    }

    public void setHideLinks(boolean hideLinks) {
        this.hideLinks_ = hideLinks;
    }

    public Iterator getNetModulePropertiesKeys() {
        return this.modules_.keySet().iterator();
    }

    public Iterator getNetModuleLinkagePropertiesKeys() {
        return this.linkTreeProps_.keySet().iterator();
    }

    public Iterator getNetModuleLinkagePropertiesLinkKeys() {
        return this.linkToTree_.keySet().iterator();
    }

    public NetModuleProperties getNetModuleProperties(String moduleId) {
        return (NetModuleProperties)this.modules_.get(moduleId);
    }

    public NetModuleLinkageProperties getNetModuleLinkageProperties(String linkID) {
        String treeID = (String)this.linkToTree_.get(linkID);
        NetModuleLinkageProperties props = (NetModuleLinkageProperties)this.linkTreeProps_.get(treeID);
        return props;
    }

    public NetModuleLinkageProperties getNetModuleLinkagePropertiesFromTreeID(String treeID) {
        return (NetModuleLinkageProperties)this.linkTreeProps_.get(treeID);
    }

    public String getNetModuleLinkagePropertiesID(String linkID) {
        return (String)this.linkToTree_.get(linkID);
    }

    public void setNetModuleLinkageProperties(String treeId, NetModuleLinkageProperties nmlp) {
        this.linkTreeProps_.put(treeId, nmlp);
    }

    public void tieNetModuleLinkagePropertiesForLink(String linkId, String treeId) {
        this.linkToTree_.put(linkId, treeId);
    }

    public void untieNetModuleLinkagePropertiesForLink(String linkId) {
        this.linkToTree_.remove(linkId);
    }

    public void setNetModuleProperties(String moduleId, NetModuleProperties nmp) {
        this.modules_.put(moduleId, nmp);
    }

    public void removeNetModuleProperties(String moduleId) {
        this.modules_.remove(moduleId);
    }

    public void removeNetModuleLinkagePropertiesWithTreeID(String treeID) {
        this.linkTreeProps_.remove(treeID);
        ((DBGenome)Database.getDB().getGenome()).removeKey(treeID);
    }

    public String removeNetModuleLinkageProperties(String linkID) {
        String treeID = (String)this.linkToTree_.get(linkID);
        this.linkToTree_.remove(linkID);
        if (!this.linkToTree_.values().contains(treeID)) {
            this.linkTreeProps_.remove(treeID);
            ((DBGenome)Database.getDB().getGenome()).removeKey(treeID);
            return treeID;
        }
        NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)this.linkTreeProps_.get(treeID);
        nmlp.removeLinkSupport(linkID);
        return null;
    }

    public int getOutboundTreeCountForModule(String modID) {
        int count = 0;
        Iterator nmlpit = this.getNetModuleLinkagePropertiesKeys();
        while (nmlpit.hasNext()) {
            String treeID = (String)nmlpit.next();
            NetModuleLinkageProperties nmlp = this.getNetModuleLinkagePropertiesFromTreeID(treeID);
            String src = nmlp.getSourceTag();
            if (!modID.equals(src)) continue;
            ++count;
        }
        return count;
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        Iterator mpit = this.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String key = (String)mpit.next();
            NetModuleProperties np = (NetModuleProperties)this.modules_.get(key);
            if (!np.replaceColor(oldID, newID)) continue;
            retval = true;
        }
        Iterator ltpit = this.linkTreeProps_.keySet().iterator();
        while (ltpit.hasNext()) {
            String key = (String)ltpit.next();
            NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)this.linkTreeProps_.get(key);
            if (!nmlp.replaceColor(oldID, newID)) continue;
            retval = true;
        }
        return retval;
    }

    public void compressOverlay(SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds, Map oldToNewPerOverlay, Map fragMap, String gid) {
        Iterator mpit = this.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String modKey = (String)mpit.next();
            NetModuleProperties np = (NetModuleProperties)this.modules_.get(modKey);
            ArrayList oldAndNew = null;
            if (oldToNewPerOverlay != null) {
                oldAndNew = new ArrayList();
                oldToNewPerOverlay.put(modKey, oldAndNew);
            }
            np.compress(emptyRows, emptyCols, bounds, oldAndNew);
        }
        Iterator ltpit = this.linkTreeProps_.values().iterator();
        while (ltpit.hasNext()) {
            NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)ltpit.next();
            nmlp.compress(emptyRows, emptyCols, bounds);
        }
        if (fragMap != null) {
            Iterator ksit = fragMap.keySet().iterator();
            while (ksit.hasNext()) {
                LinkProperties.LinkFragmentShifts lfs;
                String tkey = (String)ksit.next();
                Map fragForGrps = (Map)fragMap.get(tkey);
                if (fragForGrps == null || (lfs = (LinkProperties.LinkFragmentShifts)fragForGrps.get(gid)) == null) continue;
                NetModuleLinkageProperties.expandCompressSelectedSegmentsAndDrops(emptyRows, emptyCols, bounds, false, 0, lfs);
            }
        }
    }

    public void expandOverlay(SortedSet insertRows, SortedSet insertCols, int mult, Map oldToNewPerOverlay, Map fragMap, String gid) {
        Iterator mpit = this.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String modKey = (String)mpit.next();
            NetModuleProperties np = (NetModuleProperties)this.modules_.get(modKey);
            ArrayList oldAndNew = null;
            if (oldToNewPerOverlay != null) {
                oldAndNew = new ArrayList();
                oldToNewPerOverlay.put(modKey, oldAndNew);
            }
            np.expand(insertRows, insertCols, mult, oldAndNew);
        }
        Iterator ltpit = this.linkTreeProps_.values().iterator();
        while (ltpit.hasNext()) {
            NetModuleLinkageProperties nmlp = (NetModuleLinkageProperties)ltpit.next();
            nmlp.expand(insertRows, insertCols, mult);
        }
        if (fragMap != null) {
            Iterator ksit = fragMap.keySet().iterator();
            while (ksit.hasNext()) {
                LinkProperties.LinkFragmentShifts lfs;
                String tkey = (String)ksit.next();
                Map fragForGrps = (Map)fragMap.get(tkey);
                if (fragForGrps == null || (lfs = (LinkProperties.LinkFragmentShifts)fragForGrps.get(gid)) == null) continue;
                NetModuleLinkageProperties.expandCompressSelectedSegmentsAndDrops(insertRows, insertCols, null, true, mult, lfs);
            }
        }
    }

    public void clipOverlay(Rectangle2D clipBounds, Map oldToNewPerOverlay) {
        Iterator mpit = this.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String modKey = (String)mpit.next();
            NetModuleProperties np = (NetModuleProperties)this.modules_.get(modKey);
            List oldAndNew = oldToNewPerOverlay != null ? (List)oldToNewPerOverlay.get(modKey) : null;
            np.clipShapes(clipBounds, oldAndNew);
        }
    }

    public void fillModAndLinkIdentityMaps(Map modIDMap, Map modLinkIDMap) {
        Iterator mpit = this.modules_.keySet().iterator();
        while (mpit.hasNext()) {
            String key = (String)mpit.next();
            modIDMap.put(key, key);
        }
        Iterator mlkit = this.linkToTree_.keySet().iterator();
        while (mlkit.hasNext()) {
            String key = (String)mlkit.next();
            modLinkIDMap.put(key, key);
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<nOvrProp");
        out.print(" ref=\"");
        out.print(this.ref_);
        out.print("\" type=\"");
        out.print(NetOverlayProperties.mapToTypeTag(this.type_));
        if (this.hideLinks_) {
            out.print("\" hideLinks=\"true");
        }
        if (this.modules_.size() == 0) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up().indent();
        out.println("<nModProps>");
        TreeSet ts = new TreeSet(this.modules_.keySet());
        Iterator mi = ts.iterator();
        ind.up();
        while (mi.hasNext()) {
            String key = (String)mi.next();
            NetModuleProperties mod = (NetModuleProperties)this.modules_.get(key);
            mod.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</nModProps>");
        ind.indent();
        out.println("<nModLinkProps>");
        TreeSet tsl = new TreeSet(this.linkTreeProps_.keySet());
        Iterator liit = tsl.iterator();
        ind.up();
        while (liit.hasNext()) {
            String key = (String)liit.next();
            NetModuleLinkageProperties lprop = (NetModuleLinkageProperties)this.linkTreeProps_.get(key);
            lprop.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</nModLinkProps>");
        ind.down().indent();
        out.println("</nOvrProp>");
    }

    public static Vector getOverlayTypes() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(NetOverlayProperties.typeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent typeForCombo(int type) {
        return new ChoiceContent(NetOverlayProperties.mapTypeToDisplay(type), type);
    }

    public static String mapTypeToDisplay(int type) {
        String typeTag = NetOverlayProperties.mapToTypeTag(type);
        return ResourceManager.getManager().getString("noverlay." + typeTag);
    }

    public static String mapToTypeTag(int val) {
        switch (val) {
            case 0: {
                return TRANSPARENT_STR_;
            }
            case 1: {
                return OPAQUE_STR_;
            }
            case 2: {
                return UNDERLAY_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromTypeTag(String tag) {
        if (tag.equals(TRANSPARENT_STR_)) {
            return 0;
        }
        if (tag.equals(OPAQUE_STR_)) {
            return 1;
        }
        if (tag.equals(UNDERLAY_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getRelayoutOptions() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(NetOverlayProperties.relayoutForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent relayoutForCombo(int option) {
        return new ChoiceContent(NetOverlayProperties.mapRelayoutToDisplay(option), option);
    }

    public static String mapRelayoutToDisplay(int option) {
        String optionTag = NetOverlayProperties.mapToRelayoutTag(option);
        return ResourceManager.getManager().getString("noverlay." + optionTag);
    }

    public static String mapToRelayoutTag(int val) {
        switch (val) {
            case 0: {
                return RELAYOUT_TO_MEMBER_ONLY_STR_;
            }
            case 1: {
                return RELAYOUT_SHIFT_AND_RESIZE_SHAPES_STR_;
            }
            case 2: {
                return RELAYOUT_NO_CHANGE_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromRelayoutTag(String tag) {
        if (tag.equals(RELAYOUT_TO_MEMBER_ONLY_STR_)) {
            return 0;
        }
        if (tag.equals(RELAYOUT_SHIFT_AND_RESIZE_SHAPES_STR_)) {
            return 1;
        }
        if (tag.equals(RELAYOUT_NO_CHANGE_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getCompressExpandLayoutOptions() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 2; ++i) {
            retval.add(NetOverlayProperties.cpexLayoutForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent cpexLayoutForCombo(int option) {
        return new ChoiceContent(NetOverlayProperties.mapCpexLayoutToDisplay(option), option);
    }

    public static String mapCpexLayoutToDisplay(int option) {
        String optionTag = NetOverlayProperties.mapToCpexLayoutTag(option);
        return ResourceManager.getManager().getString("noverlay." + optionTag);
    }

    public static String mapToCpexLayoutTag(int val) {
        switch (val) {
            case 0: {
                return CPEX_LAYOUT_TO_MEMBER_ONLY_STR_;
            }
            case 1: {
                return CPEX_LAYOUT_APPLY_ALGORITHM_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromCpexLayoutTag(String tag) {
        if (tag.equals(CPEX_LAYOUT_TO_MEMBER_ONLY_STR_)) {
            return 0;
        }
        if (tag.equals(CPEX_LAYOUT_APPLY_ALGORITHM_STR_)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static class MyLinkGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            NetOverlayProperties nop = board.netOvrProps;
            NetModuleLinkageProperties nmlp = board.netModLinkProps;
            try {
                ((DBGenome)Database.getDB().getGenome()).addKey(nmlp.getID());
            }
            catch (IllegalStateException isex) {
                throw new IOException();
            }
            layout.setNetModuleLinkageProperties(nmlp.getID(), nmlp, nop.getReference());
            return null;
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Layout layout = board.layout;
            NetOverlayProperties nop = board.netOvrProps;
            NetModuleProperties nmp = board.netModProps;
            layout.setNetModuleProperties(nmp.getID(), nmp, nop.getReference());
            return null;
        }
    }

    public static class NetOverlayPropertiesWorker
    extends AbstractFactoryClient {
        public NetOverlayPropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nOvrProp");
            this.installWorker(new NetModuleProperties.NetModulePropertiesWorker(whiteboard), new MyGlue());
            this.installWorker(new NetModuleLinkageProperties.NetModuleLinkagePropertiesWorker(whiteboard), new MyLinkGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetOverlayProperties retval = null;
            if (elemName.equals("nOvrProp")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netOvrProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NetOverlayProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            String ref = AttributeExtractor.extractAttribute(elemName, attrs, "nOvrProp", "ref", true);
            String type = AttributeExtractor.extractAttribute(elemName, attrs, "nOvrProp", "type", true);
            String hideLinks = AttributeExtractor.extractAttribute(elemName, attrs, "nOvrProp", "hideLinks", false);
            return new NetOverlayProperties(ref, type, hideLinks);
        }
    }
}

