/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.freerender.BareNodeFree;
import org.systemsbiology.biotapestry.ui.freerender.BoxNodeFree;
import org.systemsbiology.biotapestry.ui.freerender.BubbleNodeFree;
import org.systemsbiology.biotapestry.ui.freerender.DiamondNodeFree;
import org.systemsbiology.biotapestry.ui.freerender.GeneFree;
import org.systemsbiology.biotapestry.ui.freerender.IntercellFree;
import org.systemsbiology.biotapestry.ui.freerender.SlashFree;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.LineBreaker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class NodeProperties
implements Cloneable {
    private int orient_;
    private Point2D location_;
    private String colorTag_;
    private String color2Tag_;
    private String nodeTag_;
    private String orientTag_;
    private boolean hideName_;
    private int extraPadGrowth_;
    private FontManager.FontOverride localFont_;
    private INodeRenderer myRenderer_;
    private String lineBreakDef_;
    private static INodeRenderer bareRenderer_ = new BareNodeFree();
    private static INodeRenderer boxRenderer_ = new BoxNodeFree();
    private static INodeRenderer bubRenderer_ = new BubbleNodeFree();
    private static INodeRenderer intRenderer_ = new IntercellFree();
    private static INodeRenderer slashRenderer_ = new SlashFree();
    private static INodeRenderer diaRenderer_ = new DiamondNodeFree();
    private static INodeRenderer geneRenderer_ = new GeneFree();
    public static final int UNDEFINED = -1;
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private static final int NUM_ORIENT_TYPES_ = 5;
    private static final String NONE_TAG_ = "";
    private static final String LEFT_TAG_ = "left";
    private static final String RIGHT_TAG_ = "right";
    private static final String UP_TAG_ = "up";
    private static final String DOWN_TAG_ = "down";
    public static final int UNDEFINED_GROWTH = -1;
    public static final int NO_GROWTH = 0;
    public static final int HORIZONTAL_GROWTH = 1;
    public static final int VERTICAL_GROWTH = 2;
    private static final int NUM_GROWTH_TYPES_ = 3;
    private static final String NO_GROWTH_TAG_ = "none";
    private static final String HORIZONTAL_GROWTH_TAG_ = "horz";
    private static final String VERTICAL_GROWTH_TAG_ = "vert";

    public NodeProperties(NodeProperties other) {
        this.orient_ = other.orient_;
        this.location_ = (Point2D)other.location_.clone();
        this.colorTag_ = other.colorTag_;
        this.color2Tag_ = other.color2Tag_;
        this.nodeTag_ = other.nodeTag_;
        this.orientTag_ = other.orientTag_;
        this.myRenderer_ = other.myRenderer_;
        this.hideName_ = other.hideName_;
        this.extraPadGrowth_ = other.extraPadGrowth_;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.lineBreakDef_ = other.lineBreakDef_;
    }

    public NodeProperties(String newNode, NodeProperties other) {
        this.orient_ = other.orient_;
        this.location_ = (Point2D)other.location_.clone();
        this.colorTag_ = other.colorTag_;
        this.color2Tag_ = other.color2Tag_;
        this.nodeTag_ = newNode;
        this.orientTag_ = other.orientTag_;
        this.myRenderer_ = other.myRenderer_;
        this.hideName_ = other.hideName_;
        this.extraPadGrowth_ = other.extraPadGrowth_;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.lineBreakDef_ = other.lineBreakDef_;
    }

    public NodeProperties(NodeProperties other, int oldType, int newType) {
        this.location_ = (Point2D)other.location_.clone();
        this.colorTag_ = other.colorTag_;
        this.nodeTag_ = other.nodeTag_;
        this.hideName_ = other.hideName_;
        this.myRenderer_ = NodeProperties.chooseRenderer(newType, 2);
        this.orient_ = NodeProperties.orientationMap(oldType, newType, other.orient_);
        this.orientTag_ = NodeProperties.mapOrientTypes(this.orient_);
        this.extraPadGrowth_ = NodeProperties.extraGrowthMap(oldType, newType, other.extraPadGrowth_);
        if (newType == 4) {
            this.hideName_ = false;
        }
        this.color2Tag_ = newType == 5 ? other.color2Tag_ : null;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.lineBreakDef_ = other.lineBreakDef_;
    }

    public NodeProperties(NodeProperties other, Layout layout, int nodeType) {
        this(other);
        this.setRenderer(NodeProperties.chooseRenderer(nodeType, layout.getLayoutType()));
    }

    public NodeProperties(Layout layout, int nodeType, String ref, double xPos, double yPos, boolean hideName) {
        this.colorTag_ = NodeProperties.defaultColor(nodeType);
        this.color2Tag_ = null;
        this.setRenderer(NodeProperties.chooseRenderer(nodeType, layout.getLayoutType()));
        this.orient_ = 2;
        this.orientTag_ = RIGHT_TAG_;
        this.location_ = new Point2D.Float((float)xPos, (float)yPos);
        this.nodeTag_ = ref;
        this.hideName_ = hideName;
        this.extraPadGrowth_ = NodeProperties.usesGrowth(nodeType) ? 1 : 0;
        this.localFont_ = null;
        this.lineBreakDef_ = null;
    }

    public NodeProperties(Layout layout, String ref, String color, String color2, String orient, double xPos, double yPos, boolean hideName, String growth, String lineBreaks) throws IOException {
        if (orient == null || orient.trim().equals(NONE_TAG_)) {
            this.orient_ = 2;
            this.orientTag_ = RIGHT_TAG_;
        } else {
            orient = orient.trim();
            try {
                this.orient_ = NodeProperties.mapOrientTypeTag(orient);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException();
            }
            this.orientTag_ = orient;
        }
        if (growth == null) {
            this.extraPadGrowth_ = 0;
        } else {
            growth = growth.trim();
            try {
                this.extraPadGrowth_ = NodeProperties.mapGrowthTypeTag(growth);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException();
            }
        }
        this.location_ = new Point2D.Float((float)xPos, (float)yPos);
        this.colorTag_ = color;
        this.color2Tag_ = color2;
        this.nodeTag_ = ref;
        this.hideName_ = hideName;
        this.localFont_ = null;
        this.lineBreakDef_ = lineBreaks;
    }

    public Object clone() {
        try {
            NodeProperties retval = (NodeProperties)super.clone();
            retval.location_ = (Point2D)this.location_.clone();
            retval.localFont_ = this.localFont_ == null ? null : (FontManager.FontOverride)this.localFont_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void compressRow(double rowDelta) {
        double newX = this.location_.getX();
        double newY = this.location_.getY() - rowDelta;
        this.location_.setLocation(newX, newY);
    }

    public void compressColumn(double colDelta) {
        double newX = this.location_.getX() - colDelta;
        double newY = this.location_.getY();
        this.location_.setLocation(newX, newY);
    }

    public void expandRow(double rowDelta) {
        double newX = this.location_.getX();
        double newY = this.location_.getY() + rowDelta;
        this.location_.setLocation(newX, newY);
    }

    public void expandColumn(double colDelta) {
        double newX = this.location_.getX() + colDelta;
        double newY = this.location_.getY();
        this.location_.setLocation(newX, newY);
    }

    public void setColor(String colorTag) {
        this.colorTag_ = colorTag;
    }

    public void setSecondColor(String colorTag) {
        this.color2Tag_ = colorTag;
    }

    public Color getColor() {
        return Database.getDB().getColor(this.colorTag_);
    }

    public String getColorName() {
        return this.colorTag_;
    }

    public String getReference() {
        return this.nodeTag_;
    }

    public Color getSecondColor() {
        if (this.color2Tag_ == null) {
            return null;
        }
        return Database.getDB().getColor(this.color2Tag_);
    }

    public String getSecondColorName() {
        return this.color2Tag_;
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        if (this.colorTag_.equals(oldID)) {
            this.colorTag_ = newID;
            retval = true;
        }
        if (this.color2Tag_ != null && this.color2Tag_.equals(oldID)) {
            this.color2Tag_ = newID;
            retval = true;
        }
        return retval;
    }

    public int getOrientation() {
        return this.orient_;
    }

    public void setOrientation(int orient) {
        this.orient_ = orient;
        this.orientTag_ = NodeProperties.mapOrientTypes(orient);
    }

    public FontManager.FontOverride getFontOverride() {
        return this.localFont_;
    }

    public void setFontOverride(FontManager.FontOverride fontover) {
        this.localFont_ = fontover;
    }

    public int getExtraGrowthDirection() {
        return this.extraPadGrowth_;
    }

    public void setExtraGrowthDirection(int growthDir) {
        this.extraPadGrowth_ = growthDir;
    }

    public Point2D getLocation() {
        return this.location_;
    }

    public INodeRenderer getRenderer() {
        return this.myRenderer_;
    }

    public void setLocation(Point2D newLocation) {
        this.location_ = newLocation;
    }

    public boolean getHideName() {
        return this.hideName_;
    }

    public void setHideName(boolean hideName) {
        this.hideName_ = hideName;
    }

    public String getLineBreakDef() {
        return this.lineBreakDef_;
    }

    public void setLineBreakDef(String lineBreakDef) {
        this.lineBreakDef_ = lineBreakDef;
    }

    public void trimAndSetLineBreakDef(String lineBreakDef, String untrimmed) {
        String trimmedBreakDef = LineBreaker.fixBreaksForTrim(lineBreakDef, untrimmed);
        this.lineBreakDef_ = LineBreaker.massageLineBreaks(trimmedBreakDef, untrimmed.trim());
    }

    public void applyLineBreakMod(LineBreaker.LineBreakChangeSteps steps, String untrimmed) {
        String resolvedBreakDef = LineBreaker.resolveNameChange(this.lineBreakDef_, steps);
        this.trimAndSetLineBreakDef(resolvedBreakDef, untrimmed);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<nprop");
        out.print(" id=\"");
        out.print(this.nodeTag_);
        out.print("\" color=\"");
        out.print(this.colorTag_);
        if (this.color2Tag_ != null) {
            out.print("\" color2=\"");
            out.print(this.color2Tag_);
        }
        out.print("\" x=\"");
        out.print(this.location_.getX());
        out.print("\" y=\"");
        out.print(this.location_.getY());
        out.print("\" orient=\"");
        out.print(this.orientTag_);
        if (this.hideName_) {
            out.print("\" hideName=\"true");
        }
        if (this.extraPadGrowth_ != 0) {
            out.print("\" extraGrowth=\"");
            out.print(NodeProperties.mapGrowthTypes(this.extraPadGrowth_));
        }
        if (this.localFont_ != null) {
            out.print("\" fsize=\"");
            out.print(this.localFont_.size);
            out.print("\" fbold=\"");
            out.print(this.localFont_.makeBold);
            out.print("\" fital=\"");
            out.print(this.localFont_.makeItalic);
            out.print("\" fsans=\"");
            out.print(this.localFont_.makeSansSerif);
        }
        if (this.lineBreakDef_ != null) {
            out.print("\" breakDef=\"");
            out.print(this.lineBreakDef_);
        }
        out.println("\" />");
    }

    public static String keywordOfInterest() {
        return "nprop";
    }

    public static Map getFixedPadLimits() {
        HashMap<Integer, PadLimits> retval = new HashMap<Integer, PadLimits>();
        for (int i = 1; i <= 7; ++i) {
            INodeRenderer rend = NodeProperties.chooseRenderer(i, 2);
            Integer key = new Integer(i);
            PadLimits limits = new PadLimits();
            limits.landingPadsCanOverflow = rend.landingPadsCanOverflow();
            limits.sharedNamespace = rend.sharedPadNamespaces();
            limits.launchPadMax = rend.getFixedLaunchPadMax();
            limits.landingPadMax = rend.getFixedLandingPadMax();
            limits.defaultPadCount = DBNode.getDefaultPadCount(i);
            retval.put(key, limits);
        }
        return retval;
    }

    public static INodeRenderer chooseRenderer(int nodeType, int layoutType) {
        if (layoutType != 2) {
            throw new IllegalArgumentException();
        }
        switch (nodeType) {
            case 1: {
                return bareRenderer_;
            }
            case 2: {
                return boxRenderer_;
            }
            case 3: {
                return bubRenderer_;
            }
            case 5: {
                return intRenderer_;
            }
            case 6: {
                return slashRenderer_;
            }
            case 7: {
                return diaRenderer_;
            }
            case 4: {
                return geneRenderer_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String defaultColor(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return "black";
            }
            case 3: 
            case 7: {
                return "white";
            }
            case 2: {
                return "darkGray";
            }
        }
        System.err.println("Bad node type is " + nodeType);
        throw new IllegalArgumentException();
    }

    public static boolean setWithLinkColor(int nodeType) {
        switch (nodeType) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int orientationMap(int oldType, int newType, int oldOrient) {
        int oldCount = NodeProperties.getOrientTypeCount(oldType);
        int newCount = NodeProperties.getOrientTypeCount(newType);
        if (newCount >= oldCount) {
            return oldOrient;
        }
        if (newCount == 1) {
            return 2;
        }
        if (oldOrient == 3 || oldOrient == 4) {
            return 2;
        }
        return oldOrient;
    }

    public static int extraGrowthMap(int oldType, int newType, int oldExtra) {
        boolean oldUses = NodeProperties.usesGrowth(oldType);
        boolean newUses = NodeProperties.usesGrowth(newType);
        if (oldUses && newUses || !oldUses && !newUses) {
            return oldExtra;
        }
        if (!newUses) {
            return 0;
        }
        return 1;
    }

    public static boolean usesGrowth(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
            case 3: 
            case 7: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean canHideName(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getOrientTypeCount(int nodeType) {
        switch (nodeType) {
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 4;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vector getOrientTypeChoices(int nodeType) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        switch (nodeType) {
            case 4: {
                retval.add(NodeProperties.orientTypeForCombo(1));
                retval.add(NodeProperties.orientTypeForCombo(2));
                return retval;
            }
            case 5: 
            case 6: {
                retval.add(NodeProperties.orientTypeForCombo(1));
                retval.add(NodeProperties.orientTypeForCombo(2));
                retval.add(NodeProperties.orientTypeForCombo(3));
                retval.add(NodeProperties.orientTypeForCombo(4));
                return retval;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                retval.add(NodeProperties.orientTypeForCombo(2));
                return retval;
            }
        }
        throw new IllegalArgumentException();
    }

    public static ChoiceContent orientTypeForCombo(int orientType) {
        return new ChoiceContent(ResourceManager.getManager().getString("nprop." + NodeProperties.mapOrientTypes(orientType)), orientType);
    }

    public static String mapOrientTypes(int orientType) {
        switch (orientType) {
            case 0: {
                return NONE_TAG_;
            }
            case 1: {
                return LEFT_TAG_;
            }
            case 2: {
                return RIGHT_TAG_;
            }
            case 3: {
                return UP_TAG_;
            }
            case 4: {
                return DOWN_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapOrientTypeTag(String orientTag) {
        if (orientTag.equalsIgnoreCase(NONE_TAG_)) {
            return 0;
        }
        if (orientTag.equalsIgnoreCase(LEFT_TAG_)) {
            return 1;
        }
        if (orientTag.equalsIgnoreCase(RIGHT_TAG_)) {
            return 2;
        }
        if (orientTag.equalsIgnoreCase(UP_TAG_)) {
            return 3;
        }
        if (orientTag.equalsIgnoreCase(DOWN_TAG_)) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getExtraGrowthChoices(int nodeType) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        switch (nodeType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return retval;
            }
            case 3: 
            case 7: {
                retval.add(NodeProperties.growthTypeForCombo(1));
                retval.add(NodeProperties.growthTypeForCombo(2));
                return retval;
            }
        }
        throw new IllegalArgumentException();
    }

    public static ChoiceContent growthTypeForCombo(int growthType) {
        return new ChoiceContent(ResourceManager.getManager().getString("nprop." + NodeProperties.mapGrowthTypes(growthType)), growthType);
    }

    public static String mapGrowthTypes(int growthType) {
        switch (growthType) {
            case 0: {
                return NO_GROWTH_TAG_;
            }
            case 1: {
                return HORIZONTAL_GROWTH_TAG_;
            }
            case 2: {
                return VERTICAL_GROWTH_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapGrowthTypeTag(String growthTag) {
        if (growthTag.equalsIgnoreCase(NO_GROWTH_TAG_)) {
            return 0;
        }
        if (growthTag.equalsIgnoreCase(HORIZONTAL_GROWTH_TAG_)) {
            return 1;
        }
        if (growthTag.equalsIgnoreCase(VERTICAL_GROWTH_TAG_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private void setRenderer(INodeRenderer render) {
        this.myRenderer_ = render;
    }

    public static class PadLimits {
        public boolean landingPadsCanOverflow;
        public boolean sharedNamespace;
        public int launchPadMax;
        public int landingPadMax;
        public int defaultPadCount;
    }

    public static class NodePropertiesWorker
    extends AbstractFactoryClient {
        public NodePropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("nprop");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NodeProperties retval = null;
            if (elemName.equals("nprop")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.nodeProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NodeProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "id", true);
            String color = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "color", true);
            String color2 = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "color2", false);
            String x = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "x", true);
            String y = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "y", true);
            String orient = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "orient", false);
            if (orient == null) {
                orient = NodeProperties.RIGHT_TAG_;
            }
            String growth = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "extraGrowth", false);
            String doHideVal = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "hideName", false);
            if (doHideVal == null) {
                doHideVal = "false";
            }
            String fsize = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "fsize", false);
            String fbold = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "fbold", false);
            String fital = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "fital", false);
            String fsans = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "fsans", false);
            String breakDef = AttributeExtractor.extractAttribute(elemName, attrs, "nprop", "breakDef", false);
            double xPos = -1.0;
            double yPos = -1.0;
            try {
                xPos = Double.parseDouble(x);
                yPos = Double.parseDouble(y);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            boolean doHide = Boolean.valueOf(doHideVal);
            Node theNode = board.genome.getNode(id);
            int nodeType = theNode.getNodeType();
            if (NodeProperties.usesGrowth(nodeType) && growth == null) {
                growth = NodeProperties.HORIZONTAL_GROWTH_TAG_;
            }
            NodeProperties nprop = new NodeProperties(board.layout, id, color, color2, orient, xPos, yPos, doHide, growth, breakDef);
            int layoutType = board.layout.getLayoutType();
            nprop.setRenderer(NodeProperties.chooseRenderer(nodeType, layoutType));
            if (fsize != null) {
                int size;
                boolean makeBold = Boolean.valueOf(fbold);
                boolean makeItalic = Boolean.valueOf(fital);
                boolean makeSansSerif = Boolean.valueOf(fsans);
                try {
                    size = Integer.parseInt(fsize);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException();
                }
                if (size < 6 || size > 40) {
                    throw new IOException();
                }
                FontManager.FontOverride fo = new FontManager.FontOverride(size, makeBold, makeItalic, makeSansSerif);
                nprop.setFontOverride(fo);
            }
            return nprop;
        }
    }
}

