/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.ItemRenderBase;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.PadDotRanking;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public abstract class NodeRenderBase
extends ItemRenderBase
implements INodeRenderer {
    private static float[] inactiveHSV_;
    private static final Color inactiveCol_;
    protected static final double PIE_RADIUS = 8.0;
    protected static final int PIE_STROKE = 1;

    public MinMax getSourcePadRange(GenomeItem item) {
        Node theNode = (Node)item;
        int newPadCount = theNode.getPadCount();
        int minPadNum = 0;
        int defaultPadCount = DBNode.getDefaultPadCount(theNode.getNodeType());
        if (newPadCount > defaultPadCount) {
            minPadNum = defaultPadCount - newPadCount;
        }
        if (minPadNum < 0 && !this.landingPadsCanOverflow()) {
            throw new IllegalStateException();
        }
        int srcMax = this.getFixedLaunchPadMax() - 1;
        int srcMin = this.sharedPadNamespaces() ? minPadNum : 0;
        return new MinMax(srcMin, srcMax);
    }

    public MinMax getTargetPadRange(GenomeItem item) {
        Node theNode = (Node)item;
        int newPadCount = theNode.getPadCount();
        int minPadNum = 0;
        int defaultPadCount = DBNode.getDefaultPadCount(theNode.getNodeType());
        if (newPadCount > defaultPadCount) {
            minPadNum = defaultPadCount - newPadCount;
        }
        if (minPadNum < 0 && !this.landingPadsCanOverflow()) {
            throw new IllegalStateException();
        }
        int padMax = this.getFixedLandingPadMax() - 1;
        return new MinMax(minPadNum, padMax);
    }

    public SortedSet suggestLaunchPad(GenomeItem item, Layout layout, Point2D targPt) {
        MinMax padRange = this.getSourcePadRange(item);
        int srcMax = padRange.max;
        int srcMin = padRange.min;
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D loc = np.getLocation();
        Vector2D diff = new Vector2D(loc, targPt).normalized();
        double maxDot = Double.NEGATIVE_INFINITY;
        int maxPad = Integer.MIN_VALUE;
        for (int i = srcMin; i <= srcMax; ++i) {
            Vector2D depDir = this.getDepartureDirection(i, item, layout);
            double dot = depDir.dot(diff);
            retval.add(new PadDotRanking(i, dot));
        }
        return retval;
    }

    public SortedSet suggestLandingPads(GenomeItem item, Layout layout, Point2D loc) {
        MinMax padRange = this.getTargetPadRange(item);
        int padMax = padRange.max;
        int minPadNum = padRange.min;
        TreeSet retval = new TreeSet(Collections.reverseOrder());
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D myLoc = np.getLocation();
        Vector2D diff = new Vector2D(loc, myLoc).normalized();
        for (int i = minPadNum; i <= padMax; ++i) {
            Vector2D depDir = this.getArrivalDirection(i, item, layout);
            double dot = depDir.dot(diff);
            retval.add(new PadDotRanking(i, dot));
        }
        return retval;
    }

    public abstract Rectangle2D getBoundsForLayout(Genome var1, GenomeItem var2, Layout var3, FontRenderContext var4, int var5, boolean var6, Integer var7);

    public abstract int topPadCount(int var1);

    public abstract Vector2D getLaunchPadOffsetForLayout(GenomeItem var1, Layout var2, FontRenderContext var3, int var4, Integer var5);

    public double getStraightThroughOffset() {
        return 0.0;
    }

    public double getVerticalOffset() {
        return 0.0;
    }

    public boolean landingPadsCanOverflow() {
        return false;
    }

    public boolean sharedPadNamespaces() {
        return true;
    }

    public Vector2D getDepartureDirection(int padNum, GenomeItem item, Layout layout) {
        Vector2D arrDir = this.getArrivalDirection(padNum, item, layout);
        arrDir.scale(-1.0);
        return arrDir;
    }

    public Vector2D getArrivalDirection(int padNum, GenomeItem item, Layout layout) {
        if (padNum >= 0) {
            switch (padNum) {
                case 0: {
                    return new Vector2D(0.0, 1.0);
                }
                case 1: {
                    return new Vector2D(-1.0, 0.0);
                }
                case 2: {
                    return new Vector2D(0.0, -1.0);
                }
                case 3: {
                    return new Vector2D(1.0, 0.0);
                }
            }
            throw new IllegalArgumentException();
        }
        return this.getExtraLandingPadArrivalDirection(padNum, item, layout);
    }

    public double getExtraLength(Node node, Genome genome, int newCount, boolean oneSideOnly) {
        return 0.0;
    }

    public int getBottomPad(GenomeItem item) {
        return 2;
    }

    public int getBestTopPad(GenomeItem item, Set usedPads, int expandDir, int totalNeeded, boolean startFromLeft) {
        if (startFromLeft) {
            int firstOnLeft = (totalNeeded - 1) / 2 * -4;
            Integer firstChoice = new Integer(firstOnLeft);
            if (!usedPads.contains(firstChoice)) {
                usedPads.add(firstChoice);
                return firstOnLeft;
            }
        } else {
            Integer firstChoice = new Integer(0);
            if (!usedPads.contains(firstChoice)) {
                usedPads.add(firstChoice);
                return 0;
            }
        }
        if (expandDir != 1) {
            usedPads.add(new Integer(0));
            return 0;
        }
        if (startFromLeft) {
            int firstOnLeft;
            boolean isOnLeft = true;
            int truePadNum = firstOnLeft = (totalNeeded - 1) / 2 * -4;
            while (true) {
                Integer checkChoice;
                if (!usedPads.contains(checkChoice = new Integer(truePadNum))) {
                    usedPads.add(checkChoice);
                    return truePadNum;
                }
                if (truePadNum == 0) {
                    isOnLeft = false;
                    truePadNum = -1;
                    continue;
                }
                if (isOnLeft) {
                    truePadNum += 4;
                    continue;
                }
                truePadNum -= 4;
            }
        }
        int truePadNum = -1;
        while (true) {
            Integer checkChoice;
            int posPadNum;
            int quadrant;
            if (!((quadrant = ((posPadNum = -truePadNum) - 1) % 4) != 0 && quadrant != 3 || usedPads.contains(checkChoice = new Integer(truePadNum)))) {
                usedPads.add(checkChoice);
                return truePadNum;
            }
            --truePadNum;
        }
    }

    protected boolean haveExtraPads(GenomeItem item) {
        int defaultPadCount;
        Node theNode = (Node)item;
        int newPadCount = theNode.getPadCount();
        return newPadCount > (defaultPadCount = DBNode.getDefaultPadCount(theNode.getNodeType()));
    }

    public List getNearbyPads(GenomeItem item, int startPad, Layout layout) {
        int side;
        if (!this.haveExtraPads(item)) {
            return null;
        }
        boolean TOP = false;
        boolean RIGHT = true;
        int BOTTOM = 2;
        int LEFT = 3;
        Node node = (Node)item;
        boolean horiz = true;
        if (NodeProperties.usesGrowth(node.getNodeType())) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            horiz = np.getExtraGrowthDirection() == 1;
        }
        MinMax range = this.getTargetPadRange(item);
        if (startPad >= 0) {
            side = startPad;
        } else {
            int quadrant = (-startPad - 1) % 4;
            switch (quadrant) {
                case 0: {
                    side = horiz ? 0 : 1;
                    break;
                }
                case 1: {
                    side = horiz ? 2 : 1;
                    break;
                }
                case 2: {
                    side = horiz ? 2 : 3;
                    break;
                }
                case 3: {
                    side = horiz ? 0 : 3;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        int min = range.min;
        int count = 0;
        HashMap<Integer, Integer> distances = new HashMap<Integer, Integer>();
        switch (side) {
            case 0: {
                int i;
                Integer nextPad = new Integer(0);
                Integer nextDist = new Integer(0);
                distances.put(nextPad, nextDist);
                if (!horiz) break;
                count = 0;
                for (i = -1; i >= min + 3; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(++count);
                    distances.put(nextPad, nextDist);
                }
                count = 0;
                for (i = -4; i >= min; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(--count);
                    distances.put(nextPad, nextDist);
                }
                break;
            }
            case 1: {
                int i;
                Integer nextPad = new Integer(1);
                Integer nextDist = new Integer(0);
                distances.put(nextPad, nextDist);
                if (horiz) break;
                count = 0;
                for (i = -1; i >= min + 3; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(++count);
                    distances.put(nextPad, nextDist);
                }
                count = 0;
                for (i = -2; i >= min + 2; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(--count);
                    distances.put(nextPad, nextDist);
                }
                break;
            }
            case 2: {
                int i;
                Integer nextPad = new Integer(2);
                Integer nextDist = new Integer(0);
                distances.put(nextPad, nextDist);
                if (!horiz) break;
                count = 0;
                for (i = -2; i >= min + 2; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(++count);
                    distances.put(nextPad, nextDist);
                }
                count = 0;
                for (i = -3; i >= min + 1; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(--count);
                    distances.put(nextPad, nextDist);
                }
                break;
            }
            case 3: {
                int i;
                Integer nextPad = new Integer(3);
                Integer nextDist = new Integer(0);
                distances.put(nextPad, nextDist);
                if (horiz) break;
                count = 0;
                for (i = -3; i >= min + 1; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(++count);
                    distances.put(nextPad, nextDist);
                }
                count = 0;
                for (i = -4; i >= min; i -= 4) {
                    nextPad = new Integer(i);
                    nextDist = new Integer(--count);
                    distances.put(nextPad, nextDist);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.alternationSupport(distances, startPad);
    }

    protected List alternationSupport(Map distances, int startPad) {
        int baseDist = (Integer)distances.get(new Integer(startPad));
        TreeMap<Integer, Integer[]> byDist = new TreeMap<Integer, Integer[]>();
        Iterator kit = distances.keySet().iterator();
        while (kit.hasNext()) {
            Integer pad = (Integer)kit.next();
            Integer dist = (Integer)distances.get(pad);
            int delta = dist - baseDist;
            Integer delObj = new Integer(Math.abs(delta));
            Integer[] posNeg = (Integer[])byDist.get(delObj);
            if (posNeg == null) {
                posNeg = new Integer[2];
                byDist.put(delObj, posNeg);
            }
            posNeg[delta >= 0 ? 0 : 1] = pad;
        }
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Iterator vit = byDist.values().iterator();
        while (vit.hasNext()) {
            Integer[] posNeg = (Integer[])vit.next();
            if (posNeg[0] != null) {
                retval.add(posNeg[0]);
            }
            if (posNeg[1] == null) continue;
            retval.add(posNeg[1]);
        }
        return retval;
    }

    public int comparePads(int padOne, int padTwo) {
        return padOne - padTwo;
    }

    public NodeInsertionDirective getInsertionDirective(Vector2D travel, Point2D insertion) {
        if (travel.getX() == 0.0) {
            if (travel.getY() < 0.0) {
                return new NodeInsertionDirective(2, 0);
            }
            return new NodeInsertionDirective(0, 2);
        }
        if (travel.getY() == 0.0) {
            if (travel.getX() < 0.0) {
                return new NodeInsertionDirective(1, 3);
            }
            return new NodeInsertionDirective(3, 1);
        }
        if (Math.abs(travel.getX()) >= Math.abs(travel.getY())) {
            if (travel.getX() > 0.0) {
                return new NodeInsertionDirective(3, 1);
            }
            return new NodeInsertionDirective(1, 3);
        }
        if (travel.getY() > 0.0) {
            return new NodeInsertionDirective(0, 2);
        }
        return new NodeInsertionDirective(2, 0);
    }

    public Rectangle getModuleBounds(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, int extraPad, Object miscInfo) {
        Rectangle basic = this.getBounds(genome, item, layout, frc, miscInfo);
        basic.setBounds(basic.x - extraPad, basic.y - extraPad, basic.width + 2 * extraPad, basic.height + 2 * extraPad);
        UiUtil.force2DToGrid(basic, 10.0);
        return basic;
    }

    protected int spiralComparePads(int padOne, int padTwo) {
        int twoY;
        int twoX;
        int oneY;
        int oneX;
        block17: {
            block16: {
                block15: {
                    block14: {
                        if (padOne == padTwo) {
                            return 0;
                        }
                        if (padOne < 0) break block14;
                        switch (padOne) {
                            case 0: {
                                oneX = 0;
                                oneY = Integer.MIN_VALUE;
                                break block15;
                            }
                            case 2: {
                                oneX = 0;
                                oneY = Integer.MAX_VALUE;
                                break block15;
                            }
                            case 1: {
                                oneX = Integer.MAX_VALUE;
                                oneY = 0;
                                break block15;
                            }
                            case 3: {
                                oneX = Integer.MIN_VALUE;
                                oneY = 0;
                                break block15;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    Vector2D offOne = this.getExtraLandingPadOffset(padOne, 0.0, true, 10.0);
                    oneX = (int)offOne.getX();
                    oneY = (int)offOne.getY();
                }
                if (padTwo < 0) break block16;
                switch (padTwo) {
                    case 0: {
                        twoX = 0;
                        twoY = Integer.MIN_VALUE;
                        break block17;
                    }
                    case 2: {
                        twoX = 0;
                        twoY = Integer.MAX_VALUE;
                        break block17;
                    }
                    case 1: {
                        twoX = Integer.MAX_VALUE;
                        twoY = 0;
                        break block17;
                    }
                    case 3: {
                        twoX = Integer.MIN_VALUE;
                        twoY = 0;
                        break block17;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            Vector2D offTwo = this.getExtraLandingPadOffset(padTwo, 0.0, true, 10.0);
            twoX = (int)offTwo.getX();
            twoY = (int)offTwo.getY();
        }
        if (twoX == oneX) {
            return twoY > oneY ? -1 : 1;
        }
        return twoX > oneX ? -1 : 1;
    }

    protected Vector2D getExtraLandingPadArrivalDirection(int padNum, GenomeItem item, Layout layout) {
        if (padNum >= 0) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)item;
        boolean horiz = true;
        if (NodeProperties.usesGrowth(node.getNodeType())) {
            NodeProperties np = layout.getNodeProperties(item.getID());
            horiz = np.getExtraGrowthDirection() == 1;
        }
        padNum = -padNum;
        int quadrant = (padNum - 1) % 4;
        switch (quadrant) {
            case 0: {
                return horiz ? new Vector2D(0.0, 1.0) : new Vector2D(-1.0, 0.0);
            }
            case 1: {
                return horiz ? new Vector2D(0.0, -1.0) : new Vector2D(-1.0, 0.0);
            }
            case 2: {
                return horiz ? new Vector2D(0.0, -1.0) : new Vector2D(1.0, 0.0);
            }
            case 3: {
                return horiz ? new Vector2D(0.0, 1.0) : new Vector2D(1.0, 0.0);
            }
        }
        throw new IllegalStateException();
    }

    protected void selectionSupport(Graphics2D g2, Intersection selected, int x, int y, int width, int height) {
        if (selected != null) {
            g2.setPaint(Color.orange);
            Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
            g2.fill(rect);
        }
    }

    protected void roundSelectionSupport(Graphics2D g2, Intersection selected, double x, double y, double radius) {
        if (selected != null) {
            g2.setPaint(Color.orange);
            Ellipse2D.Double circ = new Ellipse2D.Double(x - radius, y - radius, 2.0 * radius, 2.0 * radius);
            g2.fill(circ);
        }
    }

    public void renderToPatternGrid(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, PatternGrid grid) {
        Rectangle rect = this.getBounds(genome, item, layout, frc, null);
        Pattern pat = new Pattern(rect.width / 10, rect.height / 10);
        pat.fillAll(item.getID());
        grid.place(pat, rect.x / 10, rect.y / 10);
    }

    public void renderToPlacementGrid(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc, LinkPlacementGrid grid, Map targetCounts, Map minPads, int strictness) {
        int offset;
        int extra;
        Rectangle rect = this.getBounds(genome, item, layout, frc, null);
        Point2D.Double forcedUL = new Point2D.Double();
        UiUtil.forceToGrid(rect.x, rect.y, forcedUL, 10.0);
        Point2D.Double forcedLR = new Point2D.Double();
        UiUtil.forceToGrid(rect.x + rect.width, rect.y + rect.height, forcedLR, 10.0);
        if (strictness == 1 || strictness == 0) {
            extra = 30;
            offset = 10;
        } else {
            extra = 10;
            offset = 0;
        }
        Pattern pat = new Pattern(((int)(((Point2D)forcedLR).getX() - ((Point2D)forcedUL).getX()) + extra) / 10, ((int)(((Point2D)forcedLR).getY() - ((Point2D)forcedUL).getY()) + extra) / 10);
        pat.fillAll(item.getID());
        grid.addNode(pat, null, item.getID(), ((int)((Point2D)forcedUL).getX() - offset) / 10, ((int)((Point2D)forcedUL).getY() - offset) / 10, strictness);
    }

    public abstract Vector2D getLandingPadOffset(int var1, GenomeItem var2, int var3, Layout var4, FontRenderContext var5);

    protected Dimension firstLineBounds(FontRenderContext frc, String text, boolean hideName, Font mFont, String breakDef) {
        return MultiLineRenderSupport.firstLineBounds(frc, text, hideName, mFont, breakDef);
    }

    protected Point2D renderText(Graphics2D g2, float x, float y, String text, boolean hideName, Font mFont, String breakDef) {
        return MultiLineRenderSupport.renderText(g2, x, y, text, hideName, mFont, breakDef);
    }

    protected Rectangle2D getTextBounds(FontRenderContext frc, float x, float y, String text, boolean hideName, Font mFont, String breakDef) {
        return MultiLineRenderSupport.getTextBounds(frc, x, y, text, hideName, mFont, breakDef);
    }

    private Dimension getSimpleTextDims(FontRenderContext frc, String text, boolean hideName, Font mFont, String breakDef) {
        return MultiLineRenderSupport.getSimpleTextDims(frc, text, hideName, mFont, breakDef);
    }

    protected Vector2D getExtraLandingPadOffset(int padNum, double offVal, boolean horizontal, double padSpacing) {
        if (padNum >= 0) {
            throw new IllegalArgumentException();
        }
        padNum = -padNum;
        int spiral = (padNum - 1) / 4 + 1;
        int quadrant = (padNum - 1) % 4;
        double spiralOffset = (double)spiral * padSpacing;
        switch (quadrant) {
            case 0: {
                return horizontal ? new Vector2D(spiralOffset, -offVal) : new Vector2D(offVal, -spiralOffset);
            }
            case 1: {
                return horizontal ? new Vector2D(spiralOffset, offVal) : new Vector2D(offVal, spiralOffset);
            }
            case 2: {
                return horizontal ? new Vector2D(-spiralOffset, offVal) : new Vector2D(-offVal, spiralOffset);
            }
            case 3: {
                return horizontal ? new Vector2D(-spiralOffset, -offVal) : new Vector2D(-offVal, -spiralOffset);
            }
        }
        throw new IllegalStateException();
    }

    protected void renderPads(Graphics2D g2, Color col, GenomeItem item, Layout layout, FontRenderContext frc, int maxPads, double padWidth) {
        int defaultPads;
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        g2.setPaint(col);
        g2.setStroke(new BasicStroke(1.0f));
        double padRadius = padWidth / 2.0 + 1.0;
        for (int i = 0; i < maxPads; ++i) {
            Vector2D lpo = this.getLandingPadOffset(i, item, 1, layout, frc);
            double x = origin.getX() + lpo.getX();
            double y = origin.getY() + lpo.getY();
            Ellipse2D.Double circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
            g2.draw(circ);
        }
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()))) {
            int extraPads = numPads - defaultPads;
            for (int i = 1; i <= extraPads; ++i) {
                int negPadNum = -i;
                Vector2D lpo = this.getLandingPadOffset(negPadNum, item, 1, layout, frc);
                double x = origin.getX() + lpo.getX();
                double y = origin.getY() + lpo.getY();
                Ellipse2D.Double circ = new Ellipse2D.Double(x - padRadius, y - padRadius, 2.0 * padRadius, 2.0 * padRadius);
                g2.draw(circ);
            }
        }
    }

    protected List calcSharedNamespacePadIntersectSupport(GenomeItem item, Layout layout, FontRenderContext frc, Point2D pt, int maxPads, double padWidth) {
        int defaultPads;
        if (!this.sharedPadNamespaces()) {
            throw new IllegalStateException();
        }
        ArrayList<Intersection.PadVal> retval = new ArrayList<Intersection.PadVal>();
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double padRadius = padWidth / 2.0 + 1.0;
        double prSq = padRadius * padRadius;
        double px = pt.getX();
        double py = pt.getY();
        for (int i = 0; i < maxPads; ++i) {
            double y;
            Vector2D lpo = this.getLandingPadOffset(i, item, 1, layout, frc);
            double x = origin.getX() + lpo.getX();
            double distSq = (px - x) * (px - x) + (py - (y = origin.getY() + lpo.getY())) * (py - y);
            if (!(distSq <= prSq)) continue;
            Intersection.PadVal retpad = new Intersection.PadVal();
            retpad.okEnd = true;
            retpad.okStart = true;
            retpad.padNum = i;
            retpad.distance = Math.sqrt(distSq);
            retval.add(retpad);
        }
        Node theBox = (Node)item;
        int numPads = theBox.getPadCount();
        if (numPads > (defaultPads = DBNode.getDefaultPadCount(theBox.getNodeType()))) {
            int extraPads = numPads - defaultPads;
            for (int i = 1; i <= extraPads; ++i) {
                double y;
                int negPadNum = -i;
                Vector2D lpo = this.getLandingPadOffset(negPadNum, item, 1, layout, frc);
                double x = origin.getX() + lpo.getX();
                double distSq = (px - x) * (px - x) + (py - (y = origin.getY() + lpo.getY())) * (py - y);
                if (!(distSq <= prSq)) continue;
                Intersection.PadVal retpad = new Intersection.PadVal();
                retpad.okEnd = true;
                retpad.okStart = true;
                retpad.padNum = negPadNum;
                retpad.distance = Math.sqrt(distSq);
                retval.add(retpad);
            }
        }
        return retval.isEmpty() ? null : retval;
    }

    protected boolean isTextCandidate(FontRenderContext frc, int fontType, FontManager.FontOverride fo, String text, double xPad, double dx, double distSq, String breakDef, boolean canBeLeft, boolean nameHidden) {
        return MultiLineRenderSupport.isTextCandidate(frc, fontType, fo, text, xPad, dx, distSq, breakDef, canBeLeft, nameHidden);
    }

    protected boolean isSingleLineText(String text, boolean hideName, String breakDef) {
        return MultiLineRenderSupport.isSingleLineText(text, hideName, breakDef);
    }

    protected boolean intersectTextLabel(FontRenderContext frc, float x, float y, String text, Point2D intPt, boolean hideName, int fontType, FontManager.FontOverride fo, String breakDef) {
        return MultiLineRenderSupport.intersectTextLabel(frc, x, y, text, intPt, hideName, fontType, fo, breakDef);
    }

    public Rectangle getNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        return null;
    }

    protected Rectangle getExtraPadNonExpansionRegion(Genome genome, GenomeItem item, Layout layout, FontRenderContext frc) {
        NodeProperties np = layout.getNodeProperties(item.getID());
        Point2D origin = np.getLocation();
        double minX = origin.getX();
        double minY = origin.getY();
        double maxX = minX;
        double maxY = minY;
        Iterator lit = genome.getLinkageIterator();
        String myId = item.getID();
        while (lit.hasNext()) {
            String trg;
            Linkage link = (Linkage)lit.next();
            if (layout.getLinkProperties(link.getID()) == null) continue;
            String src = link.getSource();
            if (src.equals(myId)) {
                Vector2D lpo = this.getLaunchPadOffset(link.getLaunchPad(), item, layout, frc);
                Point2D lPad = lpo.add(origin);
                double padX = lPad.getX();
                double padY = lPad.getY();
                if (padX > maxX) {
                    maxX = padX;
                }
                if (padY > maxY) {
                    maxY = padY;
                }
                if (padX < minX) {
                    minX = padX;
                }
                if (padY < minY) {
                    minY = padY;
                }
            }
            if (!(trg = link.getTarget()).equals(myId)) continue;
            Vector2D lpo = this.getLandingPadOffset(link.getLandingPad(), item, link.getSign(), layout, frc);
            Point2D lPad = lpo.add(origin);
            double padX = lPad.getX();
            double padY = lPad.getY();
            if (padX > maxX) {
                maxX = padX;
            }
            if (padY > maxY) {
                maxY = padY;
            }
            if (padX < minX) {
                minX = padX;
            }
            if (!(padY < minY)) continue;
            minY = padY;
        }
        if (maxX == minX && maxY == minY) {
            return null;
        }
        return new Rectangle((int)minX, (int)minY, (int)maxX - (int)minX, (int)maxY - (int)minY);
    }

    protected Color getVariableActivityColor(GenomeItem item, Color col, boolean forText, DisplayOptions dopt) {
        if (item instanceof DBNode) {
            return col;
        }
        NodeInstance ni = (NodeInstance)item;
        int activity = ni.getActivity();
        switch (activity) {
            case 1: {
                return inactiveCol_;
            }
            case 0: {
                return col;
            }
            case 2: 
            case 3: {
                if (activity == 3 && forText) {
                    return col;
                }
                if (!dopt.changeNodeColorForActivity()) {
                    return col;
                }
                float[] colHSB = new float[3];
                Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), colHSB);
                double level = activity == 3 ? 0.0 : ni.getActivityLevel();
                colHSB[1] = inactiveHSV_[1] + (float)level * (colHSB[1] - inactiveHSV_[1]);
                colHSB[2] = inactiveHSV_[2] + (float)level * (colHSB[2] - inactiveHSV_[2]);
                return Color.getHSBColor(colHSB[0], colHSB[1], colHSB[2]);
            }
        }
        throw new IllegalStateException();
    }

    protected void drawVariableActivityPie(Graphics2D g2, GenomeItem item, Color col, Point2D pieCenter, DisplayOptions dopt) {
        if (item instanceof DBNode) {
            return;
        }
        if (!dopt.showNodePieForActivity()) {
            return;
        }
        NodeInstance ni = (NodeInstance)item;
        int activity = ni.getActivity();
        if (activity != 2) {
            return;
        }
        double x = pieCenter.getX();
        double y = pieCenter.getY();
        Ellipse2D.Double circ = new Ellipse2D.Double(x - 8.0, y - 8.0, 16.0, 16.0);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setPaint(col);
        g2.draw(circ);
        double level = ni.getActivityLevel();
        int endArc = (int)Math.round(360.0 * level);
        Arc2D.Double arc1 = new Arc2D.Double(x - 8.0, y - 8.0, 16.0, 16.0, 90.0, -endArc, 2);
        g2.fill(arc1);
    }

    static {
        inactiveCol_ = Color.LIGHT_GRAY;
        inactiveHSV_ = new float[3];
        Color.RGBtoHSB(inactiveCol_.getRed(), inactiveCol_.getGreen(), inactiveCol_.getBlue(), inactiveHSV_);
    }
}

