/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.freerender.NoteFree;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.xml.sax.Attributes;

public class NoteProperties
implements Cloneable {
    public static final String DEFAULT_COLOR = "EX-red";
    private static IRenderer noteRenderer_ = new NoteFree();
    private String colorTag_;
    private Point2D location_;
    private String noteID_;
    private IRenderer renderer_;
    private FontManager.FontOverride localFont_;
    private int just_;

    public NoteProperties(Layout layout, String ref, String color, double x, double y) {
        this.colorTag_ = color;
        this.location_ = new Point2D.Double(x, y);
        this.noteID_ = ref;
        this.renderer_ = noteRenderer_;
        this.localFont_ = null;
        this.just_ = 1;
    }

    public NoteProperties(NoteProperties other, String newID) {
        this.location_ = (Point2D)other.location_.clone();
        this.colorTag_ = other.colorTag_;
        this.noteID_ = other.noteID_;
        this.renderer_ = other.renderer_;
        this.noteID_ = newID;
        this.localFont_ = other.localFont_ == null ? null : (FontManager.FontOverride)other.localFont_.clone();
        this.just_ = other.just_;
    }

    public NoteProperties(Layout layout, String ref, String color, String noteX, String noteY, int just) throws IOException {
        if (noteX != null && noteY != null) {
            try {
                double x = Double.parseDouble(noteX);
                double y = Double.parseDouble(noteY);
                this.location_ = new Point2D.Double(x, y);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        } else {
            throw new IOException();
        }
        this.colorTag_ = color;
        this.noteID_ = ref;
        this.renderer_ = noteRenderer_;
        this.localFont_ = null;
        this.just_ = just;
    }

    public Object clone() {
        try {
            NoteProperties retval = (NoteProperties)super.clone();
            retval.location_ = (Point2D)this.location_.clone();
            retval.localFont_ = this.localFont_ == null ? null : (FontManager.FontOverride)this.localFont_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getReference() {
        return this.noteID_;
    }

    public Color getColor() {
        return Database.getDB().getColor(this.colorTag_);
    }

    public String getColorName() {
        return this.colorTag_;
    }

    public FontManager.FontOverride getFontOverride() {
        return this.localFont_;
    }

    public void setFontOverride(FontManager.FontOverride fontover) {
        this.localFont_ = fontover;
    }

    public boolean replaceColor(String oldID, String newID) {
        boolean retval = false;
        if (this.colorTag_.equals(oldID)) {
            this.colorTag_ = newID;
            retval = true;
        }
        return retval;
    }

    public void setColor(String newID) {
        this.colorTag_ = newID;
    }

    public Point2D getLocation() {
        return this.location_;
    }

    public void setLocation(Point2D newLocation) {
        this.location_ = newLocation;
    }

    public int getJustification() {
        return this.just_;
    }

    public void setJustification(int just) {
        this.just_ = just;
    }

    public IRenderer getRenderer() {
        return this.renderer_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<ntprop");
        out.print(" id=\"");
        out.print(this.noteID_);
        out.print("\" color=\"");
        out.print(this.colorTag_);
        if (this.location_ != null) {
            out.print("\" x=\"");
            out.print(this.location_.getX());
            out.print("\" y=\"");
            out.print(this.location_.getY());
        }
        if (this.localFont_ != null) {
            out.print("\" fsize=\"");
            out.print(this.localFont_.size);
            out.print("\" fbold=\"");
            out.print(this.localFont_.makeBold);
            out.print("\" fital=\"");
            out.print(this.localFont_.makeItalic);
            out.print("\" fsans=\"");
            out.print(this.localFont_.makeSansSerif);
        }
        if (this.just_ != 1) {
            out.print("\" just=\"");
            out.print(MultiLineRenderSupport.mapToJustTag(this.just_));
        }
        out.println("\" />");
    }

    public static String keywordOfInterest() {
        return "ntprop";
    }

    public static NoteProperties buildFromXML(Layout layout, Attributes attrs) throws IOException {
        String ref = null;
        String color = null;
        String noteX = null;
        String noteY = null;
        String fsize = null;
        String fbold = null;
        String fital = null;
        String fsans = null;
        String justStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    ref = val;
                    continue;
                }
                if (key.equals("color")) {
                    color = val;
                    continue;
                }
                if (key.equals("x")) {
                    noteX = val;
                    continue;
                }
                if (key.equals("y")) {
                    noteY = val;
                    continue;
                }
                if (key.equals("fsize")) {
                    fsize = val;
                    continue;
                }
                if (key.equals("fbold")) {
                    fbold = val;
                    continue;
                }
                if (key.equals("fital")) {
                    fital = val;
                    continue;
                }
                if (key.equals("fsans")) {
                    fsans = val;
                    continue;
                }
                if (!key.equals("just")) continue;
                justStr = val;
            }
        }
        if (ref == null || color == null || noteX == null || noteY == null) {
            throw new IOException();
        }
        int just = 1;
        try {
            if (justStr != null) {
                just = MultiLineRenderSupport.mapFromJustTag(justStr);
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IOException();
        }
        NoteProperties retval = new NoteProperties(layout, ref, color, noteX, noteY, just);
        if (fsize != null) {
            int size;
            boolean makeBold = Boolean.valueOf(fbold);
            boolean makeItalic = Boolean.valueOf(fital);
            boolean makeSansSerif = Boolean.valueOf(fsans);
            try {
                size = Integer.parseInt(fsize);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            if (size < 6 || size > 40) {
                throw new IOException();
            }
            FontManager.FontOverride fo = new FontManager.FontOverride(size, makeBold, makeItalic, makeSansSerif);
            retval.setFontOverride(fo);
        }
        return retval;
    }
}

