/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class PerLinkDrawStyle
implements Cloneable {
    public static final int EXTENT_UNDEFINED = -2;
    public static final int EXTENT_VARIOUS = -1;
    public static final int UNIQUE = 0;
    public static final int SHARED_CONGRUENT = 1;
    public static final int TO_ROOT = 2;
    private static final int NUM_EXTENTS_ = 3;
    public static final String UNIQUE_TAG = "unique";
    public static final String SHARED_CONGRUENT_TAG = "sharedCongruent";
    public static final String TO_ROOT_TAG = "toRoot";
    private SuggestedDrawStyle style_;
    private int extent_;

    public PerLinkDrawStyle(SuggestedDrawStyle style, int extent) {
        this.style_ = style;
        this.extent_ = extent;
    }

    public PerLinkDrawStyle(String extentStr) throws IOException {
        try {
            this.extent_ = PerLinkDrawStyle.mapExtentTag(extentStr);
        }
        catch (IllegalArgumentException iaex) {
            throw new IOException();
        }
    }

    public Object clone() {
        try {
            PerLinkDrawStyle retval = (PerLinkDrawStyle)super.clone();
            retval.style_ = (SuggestedDrawStyle)this.style_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void setDrawStyle(SuggestedDrawStyle style) {
        this.style_ = style;
    }

    public SuggestedDrawStyle getDrawStyle() {
        return this.style_;
    }

    public int getExtent() {
        return this.extent_;
    }

    public void setExtent(int extent) {
        this.extent_ = extent;
    }

    public String getDisplayString() {
        ResourceManager rMan = ResourceManager.getManager();
        String extentName = rMan.getString("perLinkDrawStyle." + PerLinkDrawStyle.mapExtent(this.extent_));
        return this.style_.getDisplayString() + "--" + extentName;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<perLinkDrawStyle extent=\"");
        out.print(PerLinkDrawStyle.mapExtent(this.extent_));
        out.println("\" >");
        ind.up();
        this.style_.writeXML(out, ind);
        ind.down().indent();
        out.println("</perLinkDrawStyle>");
    }

    public static String mapExtent(int extent) {
        switch (extent) {
            case 0: {
                return UNIQUE_TAG;
            }
            case 1: {
                return SHARED_CONGRUENT_TAG;
            }
            case 2: {
                return TO_ROOT_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapExtentTag(String extentTag) {
        if (extentTag.equalsIgnoreCase(UNIQUE_TAG)) {
            return 0;
        }
        if (extentTag.equalsIgnoreCase(SHARED_CONGRUENT_TAG)) {
            return 1;
        }
        if (extentTag.equalsIgnoreCase(TO_ROOT_TAG)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getExtentChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 3; ++i) {
            retval.add(PerLinkDrawStyle.extentForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent extentForCombo(int extent) {
        return new ChoiceContent(ResourceManager.getManager().getString("perLinkDrawStyle." + PerLinkDrawStyle.mapExtent(extent)), extent);
    }

    public static class MyStyleGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            PerLinkDrawStyle plds = board.perLinkSty;
            SuggestedDrawStyle suggSty = board.suggSty;
            plds.setDrawStyle(suggSty);
            return null;
        }
    }

    public static class PerLinkDrawStyleWorker
    extends AbstractFactoryClient {
        public PerLinkDrawStyleWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("perLinkDrawStyle");
            this.installWorker(new SuggestedDrawStyle.SuggestedDrawStyleWorker(whiteboard), new MyStyleGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            PerLinkDrawStyle retval = null;
            if (elemName.equals("perLinkDrawStyle")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.perLinkSty = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private PerLinkDrawStyle buildFromXML(String elemName, Attributes attrs) throws IOException {
            String extentStr = AttributeExtractor.extractAttribute(elemName, attrs, "perLinkDrawStyle", "extent", true);
            return new PerLinkDrawStyle(extentStr);
        }
    }
}

