/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.PopCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.MenuItemTarget;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;

public class PopControl {
    private PopCommands popCmds_;
    private boolean readOnly_;
    private NodePopup genePopupGuts_;
    private NodePopup geneMainGuts_;
    private NodePopup nodePopupGuts_;
    private NodePopup nodeMainGuts_;
    private LinkPopup linkPopupGuts_;
    private LinkPopup linkMainGuts_;
    private LinkPointPopup linkPointPop_;
    private RegionPopup regionPop_;
    private NotePopup notePop_;
    private NetModulePopup modulePop_;
    private NetModuleLinkagePopup moduleLinkPop_;
    private NetModuleLinkPointPopup moduleLinkPointPop_;
    private NetOverlayPopup overlayPop_;
    private SUPanel suPanel_;
    private PopCommands.EditMultiSelections emsa_;

    public PopControl(JFrame parent, CommonView cView, SUPanel suPanel, UndoManager undo, GenomePresentation pre, boolean readOnly) {
        this.popCmds_ = new PopCommands(parent, cView, suPanel, undo, pre);
        this.suPanel_ = suPanel;
        this.readOnly_ = readOnly;
        if (!readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = this.popCmds_;
            popCommands.getClass();
            this.emsa_ = popCommands.new PopCommands.EditMultiSelections(rMan.getString("multiSel.editMultiSelections"), rMan.getChar("multiSel.editMultiSelectionsMnem"));
        }
        this.buildPopups(readOnly);
    }

    public boolean isVisible() {
        return this.genePopupGuts_.isVisible() || this.nodePopupGuts_.isVisible() || this.linkPopupGuts_.isVisible() || this.linkPointPop_.isVisible() || this.regionPop_.isVisible() || this.notePop_.isVisible() || this.modulePop_.isVisible() || this.moduleLinkPop_.isVisible() || this.moduleLinkPointPop_.isVisible() || this.overlayPop_.isVisible();
    }

    public boolean stockMenu(JMenu menu, Genome genome, Layout layout, Intersection intersect) {
        this.popCmds_.setLayout(layout.getName());
        this.popCmds_.setGenome(genome.getID());
        this.popCmds_.setIntersection(intersect);
        this.popCmds_.setAbsScreenPoint(null);
        String objID = intersect.getObjectID();
        Gene gene = genome.getGene(objID);
        if (gene != null) {
            this.geneMainGuts_.prepareNodeMenu(genome, layout, intersect, this.readOnly_, gene);
            menu.removeAll();
            this.geneMainGuts_.installMenuItems(this.readOnly_, new MenuItemTarget(menu));
            return true;
        }
        Node node = genome.getNode(objID);
        if (node != null) {
            this.nodeMainGuts_.prepareNodeMenu(genome, layout, intersect, this.readOnly_, node);
            menu.removeAll();
            this.nodeMainGuts_.installMenuItems(this.readOnly_, new MenuItemTarget(menu));
            return true;
        }
        Linkage link = genome.getLinkage(objID);
        if (link != null) {
            LinkSegmentID segID;
            LinkSegment geomOnly;
            BusProperties linkProps = layout.getLinkProperties(objID);
            LinkSegmentID[] segIDs = intersect.segmentIDsFromIntersect();
            boolean singleSeg = segIDs != null && segIDs.length == 1;
            Point viewPoint = null;
            if (singleSeg && (geomOnly = linkProps.getSegmentGeometryForID(segID = segIDs[0], genome, layout, this.suPanel_.getFontRenderContext(), false)).getLength() >= 30.0) {
                Point2D segSplit = geomOnly.pointAtFraction(0.5);
                viewPoint = this.suPanel_.pointToViewport(new Point((int)segSplit.getX(), (int)segSplit.getY()));
                this.popCmds_.setPopup(viewPoint);
            }
            this.linkMainGuts_.prepareMenu(intersect, this.readOnly_, singleSeg, viewPoint != null);
            menu.removeAll();
            this.linkMainGuts_.installMenuItems(this.readOnly_, new MenuItemTarget(menu));
            return true;
        }
        return false;
    }

    public boolean stockMultiSelMenu(JMenu menu, Genome genome, Layout layout, Map intersects) {
        this.popCmds_.setLayout(layout.getName());
        this.popCmds_.setGenome(genome.getID());
        menu.removeAll();
        if (this.emsa_ != null) {
            menu.add(this.emsa_);
        }
        boolean retval = false;
        HashSet<String> genes = new HashSet<String>();
        HashSet<String> nodes = new HashSet<String>();
        HashSet links = new HashSet();
        Iterator vit = intersects.keySet().iterator();
        while (vit.hasNext()) {
            String objID = (String)vit.next();
            Gene gene = genome.getGene(objID);
            if (gene != null) {
                genes.add(objID);
                retval = true;
                continue;
            }
            Node node = genome.getNode(objID);
            if (node != null) {
                nodes.add(objID);
                retval = true;
                continue;
            }
            Linkage link = genome.getLinkage(objID);
            if (link == null) continue;
            Intersection lint = (Intersection)intersects.get(objID);
            LinkSegmentID[] selsegs = lint.segmentIDsFromIntersect();
            if (selsegs == null) {
                Set shared = layout.getSharedItems(objID);
                links.addAll(shared);
            } else {
                BusProperties lp = layout.getLinkProperties(objID);
                for (int i = 0; i < selsegs.length; ++i) {
                    Set resolved = lp.resolveLinkagesThroughSegment(selsegs[i], genome);
                    links.addAll(resolved);
                }
            }
            retval = true;
        }
        if (this.emsa_ != null) {
            this.emsa_.setSelections(genes, nodes, links);
        }
        return retval;
    }

    public void showPopup(Genome genome, Layout layout, Intersection.AugmentedIntersection aug, int x, int y, Point screenAbs) {
        this.popCmds_.setLayout(layout.getName());
        this.popCmds_.setGenome(genome.getID());
        this.popCmds_.setPopup(new Point2D.Float(x, y));
        this.popCmds_.setIntersection(aug.intersect);
        this.popCmds_.setAbsScreenPoint(screenAbs);
        switch (aug.type) {
            case 1: {
                Gene gene = genome.getGene(aug.intersect.getObjectID());
                if (gene == null) break;
                this.genePopupGuts_.showPopup(genome, layout, aug.intersect, x, y, this.readOnly_, gene);
                break;
            }
            case 2: {
                Node node = genome.getNode(aug.intersect.getObjectID());
                if (genome.getNode(aug.intersect.getObjectID()) == null) break;
                this.nodePopupGuts_.showPopup(genome, layout, aug.intersect, x, y, this.readOnly_, node);
                break;
            }
            case 3: {
                if (genome.getLinkage(aug.intersect.getObjectID()) == null) break;
                LinkSegmentID segID = aug.intersect.segmentIDFromIntersect();
                if (!this.readOnly_ && segID != null && segID.isTaggedWithEndpoint()) {
                    this.linkPointPop_.showPopup(genome, layout, aug.intersect, x, y, this.readOnly_);
                    break;
                }
                this.linkPopupGuts_.showPopup(aug.intersect, x, y, this.readOnly_);
                break;
            }
            case 4: {
                if (this.readOnly_ || genome.getNote(aug.intersect.getObjectID()) == null) break;
                this.notePop_.showPopup(genome, aug.intersect, x, y, this.readOnly_);
                break;
            }
            case 5: {
                if (!(genome instanceof GenomeInstance) || ((GenomeInstance)genome).getGroup(aug.intersect.getObjectID()) == null) break;
                this.regionPop_.showPopup(genome, layout, aug.intersect, x, y, this.readOnly_);
                break;
            }
            case 6: {
                this.modulePop_.showPopup(genome, layout, aug, x, y, this.readOnly_);
                break;
            }
            case 7: {
                LinkSegmentID segID = aug.intersect.segmentIDFromIntersect();
                if (!this.readOnly_ && segID != null && segID.isTaggedWithEndpoint()) {
                    this.moduleLinkPointPop_.showPopup(genome, layout, aug, x, y, this.readOnly_);
                    break;
                }
                this.moduleLinkPop_.showPopup(genome, layout, aug, x, y, this.readOnly_);
                break;
            }
            case 8: {
                if (this.readOnly_) break;
                this.overlayPop_.showPopup(genome, layout, aug, x, y, this.readOnly_);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void buildPopups(boolean readOnly) {
        this.genePopupGuts_ = new NodePopup();
        this.genePopupGuts_.buildGeneMenu(readOnly);
        this.genePopupGuts_.installMenuItems(readOnly, new MenuItemTarget(this.genePopupGuts_.getPopup()));
        this.geneMainGuts_ = new NodePopup();
        this.geneMainGuts_.buildGeneMenu(readOnly);
        this.nodePopupGuts_ = new NodePopup();
        this.nodePopupGuts_.buildNodeMenu(readOnly);
        this.nodePopupGuts_.installMenuItems(readOnly, new MenuItemTarget(this.nodePopupGuts_.getPopup()));
        this.nodeMainGuts_ = new NodePopup();
        this.nodeMainGuts_.buildGeneMenu(readOnly);
        this.linkPopupGuts_ = new LinkPopup();
        this.linkPopupGuts_.buildMenu(readOnly);
        this.linkPopupGuts_.installMenuItems(readOnly, new MenuItemTarget(this.linkPopupGuts_.getPopup()));
        this.linkMainGuts_ = new LinkPopup();
        this.linkMainGuts_.buildMenu(readOnly);
        this.linkPointPop_ = new LinkPointPopup();
        this.linkPointPop_.buildPopup(readOnly);
        this.regionPop_ = new RegionPopup();
        this.regionPop_.buildPopup(readOnly);
        this.notePop_ = new NotePopup();
        this.notePop_.buildPopup();
        this.modulePop_ = new NetModulePopup();
        this.modulePop_.buildPopup();
        this.moduleLinkPop_ = new NetModuleLinkagePopup();
        this.moduleLinkPop_.buildPopup();
        this.moduleLinkPointPop_ = new NetModuleLinkPointPopup();
        this.moduleLinkPointPop_.buildPopup(readOnly);
        this.overlayPop_ = new NetOverlayPopup();
        this.overlayPop_.buildPopup();
    }

    private void subGroupGeneration(Genome genome, Node node, JMenu subGroupMenu) {
        boolean haveInstance = genome instanceof GenomeInstance;
        if (haveInstance) {
            GenomeInstance gi = (GenomeInstance)genome;
            if (gi.getVfgParentRoot() == null) {
                NodeInstance ni = (NodeInstance)node;
                subGroupMenu.removeAll();
                JMenu addMenu = this.generateSubGroupsForAdd(gi, ni);
                int size = addMenu.getMenuComponentCount();
                subGroupMenu.add(addMenu);
                addMenu.setEnabled(size != 0);
                JMenu delMenu = this.generateSubGroupsForDelete(gi, ni);
                size = delMenu.getMenuComponentCount();
                subGroupMenu.add(delMenu);
                delMenu.setEnabled(size != 0);
                subGroupMenu.setEnabled(addMenu.isEnabled() || delMenu.isEnabled());
            } else {
                subGroupMenu.setEnabled(false);
            }
        } else {
            subGroupMenu.setEnabled(false);
        }
    }

    private JMenu generateSubGroupsForAdd(GenomeInstance gi, NodeInstance ni) {
        GroupMembership memb = gi.getNodeGroupMembership(ni);
        if (memb.mainGroups.size() != 1) {
            throw new IllegalStateException();
        }
        String parent = (String)memb.mainGroups.iterator().next();
        List subs = gi.getSubgroupsForGroup(parent);
        ResourceManager rMan = ResourceManager.getManager();
        JMenu retval = new JMenu(rMan.getString("nodePopup.AddToSubGroup"));
        retval.setMnemonic(rMan.getChar("nodePopup.AddToSubGroupMnem"));
        Iterator sit = subs.iterator();
        while (sit.hasNext()) {
            String subID = (String)sit.next();
            if (memb.subGroups.contains(subID)) continue;
            Group group = gi.getGroup(subID);
            PopCommands popCommands = this.popCmds_;
            popCommands.getClass();
            retval.add(popCommands.new PopCommands.AddNodeToSubGroupAction(ni, group, group.getName()));
        }
        return retval;
    }

    private JMenu generateSubGroupsForDelete(GenomeInstance gi, NodeInstance ni) {
        GroupMembership memb = gi.getNodeGroupMembership(ni);
        if (memb.mainGroups.size() != 1) {
            throw new IllegalStateException();
        }
        ResourceManager rMan = ResourceManager.getManager();
        JMenu retval = new JMenu(rMan.getString("nodePopup.RemoveFromSubGroup"));
        retval.setMnemonic(rMan.getChar("nodePopup.RemoveFromSubGroupMnem"));
        Iterator sit = memb.subGroups.iterator();
        while (sit.hasNext()) {
            String subID = (String)sit.next();
            Group group = gi.getGroup(subID);
            PopCommands popCommands = this.popCmds_;
            popCommands.getClass();
            retval.add(popCommands.new PopCommands.DeleteNodeFromSubGroupAction(ni, group, group.getName()));
        }
        return retval;
    }

    private void netModuleGeneration(Genome genome, Node node, JMenu addModuleMenu, JMenu deleteModuleMenu, NetworkOverlay netOvr) {
        String nodeID = node.getID();
        addModuleMenu.removeAll();
        deleteModuleMenu.removeAll();
        boolean inAModule = false;
        boolean notInAModule = false;
        Iterator moit = netOvr.getModuleIterator();
        while (moit.hasNext()) {
            GenomeInstance gi;
            Group group;
            NetModule mod = (NetModule)moit.next();
            boolean canUseMod = true;
            String groupID = mod.getGroupAttachment();
            if (groupID != null && !(group = (gi = (GenomeInstance)genome).getGroup(groupID)).isInGroup(nodeID, gi)) {
                canUseMod = false;
            }
            if (mod.isAMember(nodeID)) {
                inAModule = true;
                PopCommands popCommands = this.popCmds_;
                popCommands.getClass();
                deleteModuleMenu.add(popCommands.new PopCommands.DeleteFromModuleAction(mod.getName(), mod.getID()));
                continue;
            }
            if (!canUseMod) continue;
            notInAModule = true;
            PopCommands popCommands = this.popCmds_;
            popCommands.getClass();
            addModuleMenu.add(popCommands.new PopCommands.AddToModuleAction(mod.getName(), mod.getID()));
        }
        addModuleMenu.setEnabled(notInAModule);
        deleteModuleMenu.setEnabled(inAModule);
    }

    private static class MenuResult {
        JMenu canInclude;
        ArrayList included = new ArrayList();

        MenuResult() {
        }
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            PopControl.this.suPanel_.forceShowingModuleComponents(null);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            PopControl.this.suPanel_.forceShowingModuleComponents(null);
            PopControl.this.suPanel_.requestFocusInWindow();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private class NetOverlayPopup {
        private JPopupMenu overlayPop_;

        private NetOverlayPopup() {
        }

        boolean isVisible() {
            return this.overlayPop_.isVisible();
        }

        void buildPopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.overlayPop_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            PopCommands.EditCurrentOverlay eco = popCommands.new PopCommands.EditCurrentOverlay(rMan.getString("netOverlayPopup.Edit"), rMan.getChar("netOverlayPopup.EditMnem"));
            this.overlayPop_.add(eco);
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            PopCommands.DeleteCurrentOverlay dco = popCommands2.new PopCommands.DeleteCurrentOverlay(rMan.getString("netOverlayPopup.Delete"), rMan.getChar("netOverlayPopup.DeleteMnem"));
            this.overlayPop_.add(dco);
            this.overlayPop_.addPopupMenuListener(new PopupHandler());
        }

        void showPopup(Genome genome, Layout layout, Intersection.AugmentedIntersection ait, int x, int y, boolean readOnly) {
            this.overlayPop_.show(PopControl.this.suPanel_, x, y);
            this.overlayPop_.requestFocusInWindow();
        }
    }

    private class NetModuleLinkPointPopup {
        private JPopupMenu linkModulePointPopup_;
        private PopCommands.DeleteModuleLinkPointAction dlpa_;

        private NetModuleLinkPointPopup() {
        }

        boolean isVisible() {
            return this.linkModulePointPopup_.isVisible();
        }

        void buildPopup(boolean readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            this.linkModulePointPopup_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.dlpa_ = popCommands.new PopCommands.DeleteModuleLinkPointAction(rMan.getString("linkPointPopup.Delete"), rMan.getChar("linkPointPopup.DeleteMnem"));
            this.linkModulePointPopup_.add(this.dlpa_);
            this.linkModulePointPopup_.addPopupMenuListener(new PopupHandler());
        }

        void showPopup(Genome genome, Layout layout, Intersection.AugmentedIntersection ait, int x, int y, boolean readOnly) {
            String overlayKey = PopControl.this.suPanel_.getCurrentOverlay();
            Intersection selected = ait.intersect;
            String treeID = selected.getObjectID();
            NetOverlayProperties nop = layout.getNetOverlayProperties(overlayKey);
            NetModuleLinkageProperties nmp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
            LinkSegmentID segID = selected.segmentIDFromIntersect();
            if (segID.isBusNodeConnection()) {
                this.dlpa_.setEnabled(false);
            } else if (!nmp.hasSimpleConnectivity(segID)) {
                this.dlpa_.setEnabled(false);
            } else {
                this.dlpa_.setEnabled(true);
            }
            this.linkModulePointPopup_.show(PopControl.this.suPanel_, x, y);
            this.linkModulePointPopup_.requestFocusInWindow();
        }
    }

    private class NetModuleLinkagePopup {
        private JPopupMenu moduleLinkPopup_;
        private PopCommands.RelocateSegmentAction rsa_;
        private PopCommands.RelocateSourceAction rsrca_;
        private PopCommands.RelocateTargetAction rta_;
        private JMenu layoutOpsMenu_;
        private PopCommands.RepairLinkTreeAction rlta_;
        private PopCommands.FixNonOrthoSegmentAction fnosamh_;
        private PopCommands.FixNonOrthoSegmentAction fnosams_;
        private PopCommands.FixAllNonOrthoSegmentsInTreeAction fanosetamh_;
        private PopCommands.FixAllNonOrthoSegmentsInTreeAction fanosetams_;

        private NetModuleLinkagePopup() {
        }

        boolean isVisible() {
            return this.moduleLinkPopup_.isVisible();
        }

        void buildPopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.moduleLinkPopup_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            PopCommands.ModuleLinkPropertiesAction mlpa = popCommands.new PopCommands.ModuleLinkPropertiesAction(rMan.getString("modulelinkPopup.Props"), rMan.getChar("modulelinkPopup.PropsMnem"));
            this.moduleLinkPopup_.add(mlpa);
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            PopCommands.DivideAction da = popCommands2.new PopCommands.DivideAction(rMan.getString("modulelinkPopup.Divide"), true, rMan.getChar("modulelinkPopup.DivideMnem"));
            this.moduleLinkPopup_.add(da);
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.rsa_ = popCommands3.new PopCommands.RelocateSegmentAction(rMan.getString("linkPopup.SegReloc"), true, rMan.getChar("linkPopup.SegRelocMnem"));
            this.moduleLinkPopup_.add(this.rsa_);
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.rsrca_ = popCommands4.new PopCommands.RelocateSourceAction(rMan.getString("linkPopup.SrcReloc"), true, rMan.getChar("linkPopup.SrcRelocMnem"));
            this.moduleLinkPopup_.add(this.rsrca_);
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.rta_ = popCommands5.new PopCommands.RelocateTargetAction(rMan.getString("linkPopup.TargReloc"), true, rMan.getChar("linkPopup.TargRelocMnem"));
            this.moduleLinkPopup_.add(this.rta_);
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            PopCommands.DeleteModuleLinkageAction dla = popCommands6.new PopCommands.DeleteModuleLinkageAction(rMan.getString("modulelinkPopup.LinkDelete"), rMan.getChar("modulelinkPopup.LinkDeleteMnem"));
            this.moduleLinkPopup_.add(dla);
            this.layoutOpsMenu_ = new JMenu(rMan.getString("linkPopup.layoutOps"));
            this.layoutOpsMenu_.setMnemonic(rMan.getChar("linkPopup.layoutOpsMnem"));
            this.buildLayoutOpsMenu();
            this.moduleLinkPopup_.add(this.layoutOpsMenu_);
            this.moduleLinkPopup_.addPopupMenuListener(new PopupHandler());
        }

        private void buildLayoutOpsMenu() {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.fanosetamh_ = popCommands.new PopCommands.FixAllNonOrthoSegmentsInTreeAction(rMan.getString("linkPopup.fixAllNonOrthoSegmentsMinShift"), true, false, rMan.getChar("linkPopup.fixAllNonOrthoSegmentsMinShiftMnem"));
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.fanosetams_ = popCommands2.new PopCommands.FixAllNonOrthoSegmentsInTreeAction(rMan.getString("linkPopup.fixAllNonOrthoSegmentsMinSplit"), true, true, rMan.getChar("linkPopup.fixAllNonOrthoSegmentsMinSplitMnem"));
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.fnosamh_ = popCommands3.new PopCommands.FixNonOrthoSegmentAction(rMan.getString("linkPopup.fixNonOrthoMinShift"), true, false, rMan.getChar("linkPopup.fixNonOrthoMinShiftMnem"));
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.fnosams_ = popCommands4.new PopCommands.FixNonOrthoSegmentAction(rMan.getString("linkPopup.fixNonOrthoMinSplit"), true, true, rMan.getChar("linkPopup.fixNonOrthoMinSplitMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.rlta_ = popCommands5.new PopCommands.RepairLinkTreeAction(rMan.getString("linkPopup.TopoRepair"), rMan.getChar("linkPopup.TopoRepairMnem"), true);
            JMenu fixOrthoSubMenu = new JMenu(rMan.getString("command.fixOrthoSubMenu"));
            fixOrthoSubMenu.setMnemonic(rMan.getChar("command.fixOrthoSubMenuMnem"));
            this.layoutOpsMenu_.add(fixOrthoSubMenu);
            fixOrthoSubMenu.add(this.fanosetamh_);
            fixOrthoSubMenu.add(this.fanosetams_);
            JMenu fixOrthoSegSubMenu = new JMenu(rMan.getString("command.fixOrthoSegSubMenu"));
            fixOrthoSegSubMenu.setMnemonic(rMan.getChar("command.fixOrthoSegSubMenuMnem"));
            this.layoutOpsMenu_.add(fixOrthoSegSubMenu);
            fixOrthoSegSubMenu.add(this.fnosamh_);
            fixOrthoSegSubMenu.add(this.fnosams_);
            this.layoutOpsMenu_.add(this.rlta_);
        }

        void showPopup(Genome genome, Layout layout, Intersection.AugmentedIntersection ait, int x, int y, boolean readOnly) {
            if (!readOnly) {
                this.rsa_.setEnabled(this.rsa_.amIValid(ait.intersect));
                this.rsrca_.setEnabled(this.rsrca_.amIValid(ait.intersect));
                this.rta_.setEnabled(this.rta_.amIValid(ait.intersect));
            }
            this.moduleLinkPopup_.show(PopControl.this.suPanel_, x, y);
            this.moduleLinkPopup_.requestFocusInWindow();
        }
    }

    private class NetModulePopup
    implements MenuListener {
        private JPopupMenu modulePopup_;
        private JMenu moveNoContentsMenu_;
        private JMenu moveWithContentsMenu_;
        private PopCommands.AddRegionToNetModule arnm_;
        private PopCommands.SetAsSingleCurrentNetModule scnm_;
        private PopCommands.DropFromCurrentNetModules dfcnm_;
        private PopCommands.DropNetModuleRegion dnmr_;
        private PopCommands.SizeCoreToRegionBounds sctrb_;
        private PopCommands.DetachModuleFromGroup dmfg_;
        private PopCommands.ToggleNetModuleContentDisplay tnmc_;
        private PopCommands.EditModuleMembers emm_;
        private PopCommands.MoveNetModuleRegion simpleMove_;
        private PopCommands.MoveNetModuleRegion mnmrobwc_;
        private PopCommands.MoveNetModuleRegion mnmrcbwc_;
        private PopCommands.MoveNetModuleRegion mnmrabwc_;
        private PopCommands.MoveNetModuleRegion mnmrobnc_;
        private PopCommands.MoveNetModuleRegion mnmrcbnc_;
        private PopCommands.MoveNetModuleRegion mnmrabnc_;
        private String showCompsForModule_;
        private int componentPos1_;
        private int componentPos2_;
        private int componentPos3_;
        private static final int UNDEFINED_BOUND_ = 0;
        private static final int NON_MEMBER_BOUND_ = 1;
        private static final int AUTO_MEMBER_BOUND_ = 2;
        private static final int DEFINED_SHAPE_BOUND_ = 3;
        private static final int CONTIG_EXTENDED_BOUND_ = 4;
        private static final int OPAQUE_INTERIOR_POINT_ = 5;
        private static final int LABEL_BOUND_ = 6;

        private NetModulePopup() {
        }

        boolean isVisible() {
            return this.modulePopup_.isVisible();
        }

        public void menuSelected(MenuEvent e) {
            PopControl.this.suPanel_.forceShowingModuleComponents(this.showCompsForModule_);
        }

        public void menuDeselected(MenuEvent e) {
            PopControl.this.suPanel_.forceShowingModuleComponents(null);
        }

        public void menuCanceled(MenuEvent e) {
            PopControl.this.suPanel_.forceShowingModuleComponents(null);
        }

        void buildPopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.modulePopup_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            PopCommands.ZoomToNetModule z2nm = popCommands.new PopCommands.ZoomToNetModule(rMan.getString("modulePopup.zoomToModule"), rMan.getChar("modulePopup.zoomToModuleMnem"));
            this.modulePopup_.add(z2nm);
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.tnmc_ = popCommands2.new PopCommands.ToggleNetModuleContentDisplay(rMan.getString("modulePopup.toggleShowContents"), rMan.getChar("modulePopup.toggleShowContentsMnem"));
            this.modulePopup_.add(this.tnmc_);
            this.modulePopup_.add(new JSeparator());
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.scnm_ = popCommands3.new PopCommands.SetAsSingleCurrentNetModule(rMan.getString("modulePopup.setCurrent"), rMan.getChar("modulePopup.setCurrentMnem"));
            this.modulePopup_.add(this.scnm_);
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.dfcnm_ = popCommands4.new PopCommands.DropFromCurrentNetModules(rMan.getString("modulePopup.dropFromCurrent"), rMan.getChar("modulePopup.dropFromCurrentMnem"));
            this.modulePopup_.add(this.dfcnm_);
            this.modulePopup_.add(new JSeparator());
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            PopCommands.EditSelectedNetworkModuleAction esnm = popCommands5.new PopCommands.EditSelectedNetworkModuleAction(rMan.getString("modulePopup.editModuleProps"), rMan.getChar("modulePopup.editModulePropsMnem"));
            this.modulePopup_.add(esnm);
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.arnm_ = popCommands6.new PopCommands.AddRegionToNetModule(rMan.getString("modulePopup.addRegionToModule"), rMan.getChar("modulePopup.addRegionToModuleMnem"));
            this.modulePopup_.add(this.arnm_);
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.dmfg_ = popCommands7.new PopCommands.DetachModuleFromGroup(rMan.getString("modulePopup.detachModuleFromGroup"), rMan.getChar("modulePopup.detachModuleFromGroupMnem"));
            this.modulePopup_.add(this.dmfg_);
            PopCommands popCommands8 = PopControl.this.popCmds_;
            popCommands8.getClass();
            PopCommands.RemoveThisNetworkModule rtnm = popCommands8.new PopCommands.RemoveThisNetworkModule(rMan.getString("modulePopup.removeThisNetworkModule"), rMan.getChar("modulePopup.removeThisNetworkModuleMnem"));
            this.modulePopup_.add(rtnm);
            PopCommands popCommands9 = PopControl.this.popCmds_;
            popCommands9.getClass();
            this.emm_ = popCommands9.new PopCommands.EditModuleMembers(rMan.getString("modulePopup.editModuleMemberDisplay"), rMan.getChar("modulePopup.editModuleMemberDisplayMnem"));
            this.modulePopup_.add(this.emm_);
            this.modulePopup_.add(new JSeparator());
            PopCommands popCommands10 = PopControl.this.popCmds_;
            popCommands10.getClass();
            this.sctrb_ = popCommands10.new PopCommands.SizeCoreToRegionBounds(rMan.getString("modulePopup.SizeCoreToRegionBounds"), rMan.getChar("modulePopup.SizeCoreToRegionBoundsMnem"));
            this.modulePopup_.add(this.sctrb_);
            this.componentPos1_ = this.modulePopup_.getComponentCount() - 1;
            JMenuItem dnmi = (JMenuItem)this.modulePopup_.getComponent(this.componentPos1_);
            dnmi.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    boolean armed = ((JMenuItem)NetModulePopup.this.modulePopup_.getComponent(NetModulePopup.this.componentPos1_)).isArmed();
                    PopControl.this.suPanel_.forceShowingModuleComponents(armed ? NetModulePopup.this.showCompsForModule_ : null);
                }
            });
            PopCommands popCommands11 = PopControl.this.popCmds_;
            popCommands11.getClass();
            this.dnmr_ = popCommands11.new PopCommands.DropNetModuleRegion(rMan.getString("modulePopup.DeleteOneBlock"), rMan.getChar("modulePopup.DeleteOneBlockMnem"));
            this.modulePopup_.add(this.dnmr_);
            this.componentPos2_ = this.modulePopup_.getComponentCount() - 1;
            JMenuItem dnmi2 = (JMenuItem)this.modulePopup_.getComponent(this.componentPos2_);
            dnmi2.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    boolean armed = ((JMenuItem)NetModulePopup.this.modulePopup_.getComponent(NetModulePopup.this.componentPos2_)).isArmed();
                    PopControl.this.suPanel_.forceShowingModuleComponents(armed ? NetModulePopup.this.showCompsForModule_ : null);
                }
            });
            PopCommands popCommands12 = PopControl.this.popCmds_;
            popCommands12.getClass();
            this.simpleMove_ = popCommands12.new PopCommands.MoveNetModuleRegion(rMan.getString("modulePopup.fastMove"), true, 2, rMan.getChar("modulePopup.fastMoveMnem"));
            this.modulePopup_.add(this.simpleMove_);
            this.componentPos3_ = this.modulePopup_.getComponentCount() - 1;
            JMenuItem dnmi3 = (JMenuItem)this.modulePopup_.getComponent(this.componentPos3_);
            dnmi3.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    boolean armed = ((JMenuItem)NetModulePopup.this.modulePopup_.getComponent(NetModulePopup.this.componentPos3_)).isArmed();
                    PopControl.this.suPanel_.forceShowingModuleComponents(armed ? NetModulePopup.this.showCompsForModule_ : null);
                }
            });
            JMenu moveMenu = new JMenu(rMan.getString("modulePopup.Move"));
            moveMenu.setMnemonic(rMan.getChar("modulePopup.MoveMnem"));
            this.modulePopup_.add(moveMenu);
            moveMenu.addMenuListener(this);
            this.moveWithContentsMenu_ = new JMenu(rMan.getString("modulePopup.MoveWithContents"));
            this.moveWithContentsMenu_.setMnemonic(rMan.getChar("modulePopup.MoveWithContentsMnem"));
            moveMenu.add(this.moveWithContentsMenu_);
            this.moveNoContentsMenu_ = new JMenu(rMan.getString("modulePopup.MoveNoContents"));
            this.moveNoContentsMenu_.setMnemonic(rMan.getChar("modulePopup.MoveNoContentsMnem"));
            moveMenu.add(this.moveNoContentsMenu_);
            PopCommands popCommands13 = PopControl.this.popCmds_;
            popCommands13.getClass();
            this.mnmrobwc_ = popCommands13.new PopCommands.MoveNetModuleRegion("Dummy", true, 0, 'x');
            PopCommands popCommands14 = PopControl.this.popCmds_;
            popCommands14.getClass();
            this.mnmrcbwc_ = popCommands14.new PopCommands.MoveNetModuleRegion("Dummy", true, 1, 'x');
            PopCommands popCommands15 = PopControl.this.popCmds_;
            popCommands15.getClass();
            this.mnmrabwc_ = popCommands15.new PopCommands.MoveNetModuleRegion("Dummy", true, 2, 'x');
            PopCommands popCommands16 = PopControl.this.popCmds_;
            popCommands16.getClass();
            this.mnmrobnc_ = popCommands16.new PopCommands.MoveNetModuleRegion("Dummy", false, 0, 'x');
            PopCommands popCommands17 = PopControl.this.popCmds_;
            popCommands17.getClass();
            this.mnmrcbnc_ = popCommands17.new PopCommands.MoveNetModuleRegion("Dummy", false, 1, 'x');
            PopCommands popCommands18 = PopControl.this.popCmds_;
            popCommands18.getClass();
            this.mnmrabnc_ = popCommands18.new PopCommands.MoveNetModuleRegion("Dummy", false, 2, 'x');
            this.modulePopup_.addPopupMenuListener(new PopupHandler());
        }

        void showPopup(Genome genome, Layout layout, Intersection.AugmentedIntersection ait, int x, int y, boolean readOnly) {
            String allRegNameKeyMnem;
            String contigNameKeyMnem;
            String oneBlockNameKeyMnem;
            String allRegNameKey;
            String contigNameKey;
            String oneBlockNameKey;
            String overlayKey = PopControl.this.suPanel_.getCurrentOverlay();
            Intersection selected = ait.intersect;
            String moduleID = selected.getObjectID();
            NetworkOverlay nov = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID()).getNetworkOverlay(overlayKey);
            NetModule nmod = nov.getModule(moduleID);
            NetOverlayProperties nop = layout.getNetOverlayProperties(overlayKey);
            NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
            NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)selected.getSubID();
            NetOverlayController noc = MainCommands.getCmds().getOverlayController();
            TaggedSet nmSet = noc.getCurrentModules();
            this.scnm_.setEnabled(nmSet.set.size() > 1);
            this.dfcnm_.setEnabled(nmSet.set.size() > 1);
            this.emm_.setEnabled(genome instanceof DynamicGenomeInstance);
            this.tnmc_.setEnabled(noc.maskingIsActive());
            boolean canBeAttached = !(genome instanceof DBGenome);
            this.dmfg_.setEnabled(canBeAttached && nmod.getGroupAttachment() != null);
            int intersectType = 0;
            boolean labelIsContig = false;
            if (ei == null) {
                intersectType = 6;
            } else if (ei.directShape != null && ei.directShape.shapeClass == 3) {
                intersectType = 1;
            } else if (ei.type == 1) {
                intersectType = 5;
            } else if (nmp.haveExtraDeltaRect(ei)) {
                intersectType = 4;
            } else if (!nmp.rectsForDirect(ei).isEmpty()) {
                intersectType = 3;
            } else if (ei.directShape != null && ei.directShape.shapeClass == 2) {
                intersectType = 2;
            } else if (ei.gotNameBounds) {
                labelIsContig = ei.contigInfo != null && !ei.contigInfo.memberShapes.isEmpty() || !ei.contigInfo.intersectedShape.isEmpty();
                intersectType = 6;
            }
            int displayType = nmp.getType();
            if (displayType == 0) {
                this.sctrb_.setEnabled(layout.coreDefDoesNotMatchVisible(genome.getID(), overlayKey, moduleID, PopControl.this.suPanel_.getFontRenderContext()));
            } else {
                this.sctrb_.setEnabled(false);
            }
            this.arnm_.setEnabled(displayType != 0);
            boolean canDelete = displayType == 0 ? false : (displayType == 2 ? false : !nmp.hasOneShape() && intersectType == 3);
            boolean withMemsOneShape = displayType == 2 && intersectType != 6 || displayType == 1 && intersectType != 1 && intersectType != 6 || displayType == 0 && intersectType == 3;
            boolean withMemsConShape = false;
            if (displayType == 1) {
                withMemsConShape = intersectType != 1 && (intersectType != 6 || labelIsContig);
            }
            boolean withMemsAllShape = true;
            boolean noMemsCommon = intersectType != 5 && intersectType != 5 && displayType != 2;
            boolean noMemsOneShape = noMemsCommon && intersectType == 3;
            boolean noMemsConShape = noMemsCommon;
            if (displayType == 0) {
                noMemsConShape = false;
            } else if (displayType == 1) {
                noMemsConShape = noMemsConShape && intersectType != 1 && intersectType != 6 && intersectType != 2;
            }
            boolean noMemsAllShape = noMemsCommon;
            if (displayType == 0) {
                noMemsAllShape = false;
            }
            this.dnmr_.setEnabled(canDelete);
            ResourceManager rMan = ResourceManager.getManager();
            this.moveWithContentsMenu_.removeAll();
            boolean showWithContents = withMemsOneShape || withMemsConShape || withMemsAllShape;
            this.moveWithContentsMenu_.setEnabled(showWithContents);
            this.moveNoContentsMenu_.removeAll();
            boolean showNoContents = noMemsOneShape || noMemsConShape || noMemsAllShape;
            this.moveNoContentsMenu_.setEnabled(showNoContents);
            if (showWithContents) {
                switch (displayType) {
                    case 0: {
                        oneBlockNameKey = "modulePopup.MoveOneBlockWCforCRType";
                        contigNameKey = "DONT_CARE";
                        allRegNameKey = "modulePopup.MoveAllBlocksWCforCRType";
                        oneBlockNameKeyMnem = "modulePopup.MoveOneBlockWCforCRTypeMnem";
                        contigNameKeyMnem = "DONT_CARE";
                        allRegNameKeyMnem = "modulePopup.MoveAllBlocksWCforCRTypeMnem";
                        break;
                    }
                    case 1: {
                        oneBlockNameKey = "modulePopup.MoveOneBlockWCforMRType";
                        contigNameKey = "modulePopup.MoveContigBlocksWCforMRType";
                        allRegNameKey = "modulePopup.MoveAllBlocksWCforMRType";
                        oneBlockNameKeyMnem = "modulePopup.MoveOneBlockWCforMRTypeMnem";
                        contigNameKeyMnem = "modulePopup.MoveContigBlocksWCforMRTypeMnem";
                        allRegNameKeyMnem = "modulePopup.MoveAllBlocksWCforMRTypeMnem";
                        break;
                    }
                    case 2: {
                        oneBlockNameKey = "modulePopup.MoveOneBlockWCforMOType";
                        contigNameKey = "DONT_CARE";
                        allRegNameKey = "modulePopup.MoveAllBlocksWCforMOType";
                        oneBlockNameKeyMnem = "modulePopup.MoveOneBlockWCforMOTypeMnem";
                        contigNameKeyMnem = "DONT_CARE";
                        allRegNameKeyMnem = "modulePopup.MoveOneBlockWCforMOTypeMnem";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.mnmrobwc_.putValue("Name", rMan.getString(oneBlockNameKey));
                this.mnmrobwc_.putValue("MnemonicKey", new Integer(rMan.getChar(oneBlockNameKeyMnem)));
                this.moveWithContentsMenu_.add(this.mnmrobwc_);
                this.mnmrobwc_.setEnabled(withMemsOneShape);
                if (displayType == 1) {
                    this.mnmrcbwc_.putValue("Name", rMan.getString(contigNameKey));
                    this.mnmrcbwc_.putValue("MnemonicKey", new Integer(rMan.getChar(contigNameKeyMnem)));
                    this.moveWithContentsMenu_.add(this.mnmrcbwc_);
                    this.mnmrcbwc_.setEnabled(withMemsConShape);
                }
                this.mnmrabwc_.putValue("Name", rMan.getString(allRegNameKey));
                this.mnmrabwc_.putValue("MnemonicKey", new Integer(rMan.getChar(allRegNameKeyMnem)));
                this.moveWithContentsMenu_.add(this.mnmrabwc_);
                this.mnmrabwc_.setEnabled(withMemsAllShape);
            }
            if (showNoContents) {
                switch (displayType) {
                    case 0: {
                        oneBlockNameKey = "modulePopup.MoveOneBlockNCforCRType";
                        contigNameKey = "DONT_CARE";
                        allRegNameKey = "DONT_CARE";
                        oneBlockNameKeyMnem = "modulePopup.MoveOneBlockNCforCRTypeMnem";
                        contigNameKeyMnem = "DONT_CARE";
                        allRegNameKeyMnem = "DONT_CARE";
                        break;
                    }
                    case 1: {
                        oneBlockNameKey = "modulePopup.MoveOneBlockNCforMRType";
                        contigNameKey = "modulePopup.MoveContigBlocksNCforMRType";
                        allRegNameKey = "modulePopup.MoveAllBlocksNCforMRType";
                        oneBlockNameKeyMnem = "modulePopup.MoveOneBlockNCforMRTypeMnem";
                        contigNameKeyMnem = "modulePopup.MoveContigBlocksNCforMRTypeMnem";
                        allRegNameKeyMnem = "modulePopup.MoveAllBlocksNCforMRTypeMnem";
                        break;
                    }
                    case 2: {
                        oneBlockNameKey = "DONT_CARE";
                        contigNameKey = "DONT_CARE";
                        allRegNameKey = "DONT_CARE";
                        oneBlockNameKeyMnem = "DONT_CARE";
                        contigNameKeyMnem = "DONT_CARE";
                        allRegNameKeyMnem = "DONT_CARE";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (displayType != 2) {
                    this.mnmrobnc_.putValue("Name", rMan.getString(oneBlockNameKey));
                    this.mnmrobnc_.putValue("MnemonicKey", new Integer(rMan.getChar(oneBlockNameKeyMnem)));
                    this.moveNoContentsMenu_.add(this.mnmrobnc_);
                    this.mnmrobnc_.setEnabled(noMemsOneShape);
                    if (displayType == 1) {
                        this.mnmrcbnc_.putValue("Name", rMan.getString(contigNameKey));
                        this.mnmrcbnc_.putValue("MnemonicKey", new Integer(rMan.getChar(contigNameKeyMnem)));
                        this.moveNoContentsMenu_.add(this.mnmrcbnc_);
                        this.mnmrcbnc_.setEnabled(noMemsConShape);
                        this.mnmrabnc_.putValue("Name", rMan.getString(allRegNameKey));
                        this.mnmrabnc_.putValue("MnemonicKey", new Integer(rMan.getChar(allRegNameKeyMnem)));
                        this.moveNoContentsMenu_.add(this.mnmrabnc_);
                        this.mnmrabnc_.setEnabled(noMemsAllShape);
                    }
                }
            }
            this.showCompsForModule_ = displayType != 2 ? moduleID : null;
            this.modulePopup_.show(PopControl.this.suPanel_, x, y);
            this.modulePopup_.requestFocusInWindow();
        }
    }

    private class NotePopup {
        private JPopupMenu notePopup_;
        private PopCommands.DeleteNoteAction dna_;
        private PopCommands.EditNoteAction ena_;

        private NotePopup() {
        }

        boolean isVisible() {
            return this.notePopup_.isVisible();
        }

        void buildPopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.notePopup_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.ena_ = popCommands.new PopCommands.EditNoteAction(rMan.getString("notePopup.Edit"), rMan.getChar("notePopup.EditMnem"));
            this.notePopup_.add(this.ena_);
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.dna_ = popCommands2.new PopCommands.DeleteNoteAction(rMan.getString("notePopup.Delete"), rMan.getChar("notePopup.DeleteMnem"));
            this.notePopup_.add(this.dna_);
            this.notePopup_.addPopupMenuListener(new PopupHandler());
        }

        void showPopup(Genome genome, Intersection selected, int x, int y, boolean readOnly) {
            this.notePopup_.show(PopControl.this.suPanel_, x, y);
            this.notePopup_.requestFocusInWindow();
        }
    }

    private class RegionPopup {
        private JPopupMenu groupPopup_;
        private PopCommands.DeleteGroupAction dgra_;
        private PopCommands.RaiseGroupAction rgra_;
        private PopCommands.LowerGroupAction lgra_;
        private PopCommands.CopyGroupAction cga_;
        private PopCommands.LayoutGroupAction loga_;
        private PopCommands.CompressOrExpandGroupAction cprga_;
        private PopCommands.CompressOrExpandGroupAction eprga_;
        private PopCommands.IncludeAllForGroupAction iafga_;
        private PopCommands.CreateSubGroupAction csga_;
        private PopCommands.TimeCourseRegionMappingAction tcrma_;
        private PopCommands.TemporalInputRegionMappingAction tirma_;
        private PopCommands.DeleteTimeCourseRegionMapAction dtcrma_;
        private PopCommands.DeleteTemporalInputRegionMapAction dtirma_;
        private PopCommands.MoveGroupAction mga_;
        private JMenu subGroupMenuGroup_;

        private RegionPopup() {
        }

        boolean isVisible() {
            return this.groupPopup_.isVisible();
        }

        void buildPopup(boolean readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            this.groupPopup_ = new JPopupMenu();
            this.groupPopup_.addPopupMenuListener(new PopupHandler());
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.groupPopup_.add(popCommands.new PopCommands.ToggleAction(rMan.getString("groupPopup.Toggle"), rMan.getChar("groupPopup.ToggleMnem")));
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.groupPopup_.add(popCommands2.new PopCommands.ZoomToGroup(rMan.getString("groupPopup.ZoomToGroup"), rMan.getChar("groupPopup.ZoomToGroupMnem")));
            if (readOnly) {
                return;
            }
            this.groupPopup_.add(new JSeparator());
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.groupPopup_.add(popCommands3.new PopCommands.GroupPropertiesAction(rMan.getString("groupPopup.GroupProperties"), rMan.getChar("groupPopup.GroupPropertiesMnem")));
            this.groupPopup_.add(new JSeparator());
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.iafga_ = popCommands4.new PopCommands.IncludeAllForGroupAction(rMan.getString("groupPopup.PullDownAllElements"), rMan.getChar("groupPopup.PullDownAllElementsMnem"));
            this.groupPopup_.add(this.iafga_);
            this.groupPopup_.add(new JSeparator());
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.rgra_ = popCommands5.new PopCommands.RaiseGroupAction(rMan.getString("groupPopup.RaiseGroup"), rMan.getChar("groupPopup.RaiseGroupMnem"));
            this.groupPopup_.add(this.rgra_);
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.lgra_ = popCommands6.new PopCommands.LowerGroupAction(rMan.getString("groupPopup.LowerGroup"), rMan.getChar("groupPopup.LowerGroupMnem"));
            this.groupPopup_.add(this.lgra_);
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.mga_ = popCommands7.new PopCommands.MoveGroupAction(rMan.getString("groupPopup.MoveGroup"), rMan.getChar("groupPopup.MoveGroupMnem"));
            this.groupPopup_.add(this.mga_);
            this.groupPopup_.add(new JSeparator());
            PopCommands popCommands8 = PopControl.this.popCmds_;
            popCommands8.getClass();
            this.loga_ = popCommands8.new PopCommands.LayoutGroupAction(rMan.getString("groupPopup.LayoutGroup"), rMan.getChar("groupPopup.LayoutGroupMnem"));
            this.groupPopup_.add(this.loga_);
            PopCommands popCommands9 = PopControl.this.popCmds_;
            popCommands9.getClass();
            this.cprga_ = popCommands9.new PopCommands.CompressOrExpandGroupAction(rMan.getString("groupPopup.CompressGroup"), true, rMan.getChar("groupPopup.CompressGroupMnem"));
            this.groupPopup_.add(this.cprga_);
            PopCommands popCommands10 = PopControl.this.popCmds_;
            popCommands10.getClass();
            this.eprga_ = popCommands10.new PopCommands.CompressOrExpandGroupAction(rMan.getString("groupPopup.ExpandGroup"), false, rMan.getChar("groupPopup.ExpandGroupMnem"));
            this.groupPopup_.add(this.eprga_);
            this.groupPopup_.add(new JSeparator());
            PopCommands popCommands11 = PopControl.this.popCmds_;
            popCommands11.getClass();
            this.cga_ = popCommands11.new PopCommands.CopyGroupAction(rMan.getString("groupPopup.CopyRegion"), rMan.getChar("groupPopup.CopyRegionMnem"));
            this.groupPopup_.add(this.cga_);
            this.subGroupMenuGroup_ = new JMenu(rMan.getString("groupPopup.SubGroups"));
            this.subGroupMenuGroup_.setMnemonic(rMan.getChar("groupPopup.SubGroupsMnem"));
            this.groupPopup_.add(this.subGroupMenuGroup_);
            PopCommands popCommands12 = PopControl.this.popCmds_;
            popCommands12.getClass();
            this.csga_ = popCommands12.new PopCommands.CreateSubGroupAction(rMan.getString("groupPopup.SubGroups"), rMan.getChar("groupPopup.SubGroupsMnem"));
            PopCommands popCommands13 = PopControl.this.popCmds_;
            popCommands13.getClass();
            this.dgra_ = popCommands13.new PopCommands.DeleteGroupAction(rMan.getString("groupPopup.GroupDelete"), rMan.getChar("groupPopup.GroupDeleteMnem"));
            this.groupPopup_.add(this.dgra_);
            this.groupPopup_.add(new JSeparator());
            JMenu tcManageMenu = new JMenu(rMan.getString("groupPopup.tcManage"));
            tcManageMenu.setMnemonic(rMan.getChar("groupPopup.tcManageMnem"));
            this.groupPopup_.add(tcManageMenu);
            PopCommands popCommands14 = PopControl.this.popCmds_;
            popCommands14.getClass();
            this.tcrma_ = popCommands14.new PopCommands.TimeCourseRegionMappingAction(rMan.getString("groupPopup.RegionMap"), rMan.getChar("groupPopup.RegionMapMnem"));
            tcManageMenu.add(this.tcrma_);
            PopCommands popCommands15 = PopControl.this.popCmds_;
            popCommands15.getClass();
            this.dtcrma_ = popCommands15.new PopCommands.DeleteTimeCourseRegionMapAction(rMan.getString("groupPopup.DeleteRegionMap"), rMan.getChar("groupPopup.DeleteRegionMapMnem"));
            tcManageMenu.add(this.dtcrma_);
            JMenu tiManageMenu = new JMenu(rMan.getString("groupPopup.tiManage"));
            tiManageMenu.setMnemonic(rMan.getChar("groupPopup.tiManageMnem"));
            this.groupPopup_.add(tiManageMenu);
            PopCommands popCommands16 = PopControl.this.popCmds_;
            popCommands16.getClass();
            this.tirma_ = popCommands16.new PopCommands.TemporalInputRegionMappingAction(rMan.getString("groupPopup.InputRegionMap"), rMan.getChar("groupPopup.InputRegionMapMnem"));
            tiManageMenu.add(this.tirma_);
            PopCommands popCommands17 = PopControl.this.popCmds_;
            popCommands17.getClass();
            this.dtirma_ = popCommands17.new PopCommands.DeleteTemporalInputRegionMapAction(rMan.getString("groupPopup.DeleteInputRegionMap"), rMan.getChar("groupPopup.DeleteInputRegionMapMnem"));
            tiManageMenu.add(this.dtirma_);
        }

        void showPopup(Genome genome, Layout layout, Intersection selected, int x, int y, boolean readOnly) {
            if (!readOnly) {
                Database db = Database.getDB();
                GenomeInstance gi = (GenomeInstance)genome;
                Group group = gi.getGroup(selected.getObjectID());
                if (gi.getVfgParent() == null) {
                    this.generateSubGroupMenu(gi, group);
                    this.iafga_.setEnabled(!db.getGenome().isEmpty());
                    int memCount = group.getMemberCount();
                    this.cprga_.setEnabled(memCount != 0);
                    this.eprga_.setEnabled(memCount != 0);
                    this.cga_.setEnabled(true);
                    this.mga_.setEnabled(true);
                    this.loga_.setEnabled(memCount > 1);
                } else {
                    boolean showIt;
                    this.generateSubSetSubGroupMenu(gi, group);
                    boolean bl = showIt = !(gi instanceof DynamicGenomeInstance);
                    if (showIt) {
                        Group parentGroup = group.getGroupInParent(gi);
                        showIt = !parentGroup.inheritedIsEmpty(gi.getVfgParent());
                    }
                    this.iafga_.setEnabled(showIt);
                    this.cprga_.setEnabled(false);
                    this.eprga_.setEnabled(false);
                    this.cga_.setEnabled(false);
                    this.mga_.setEnabled(false);
                    this.loga_.setEnabled(false);
                }
                TimeCourseData tcd = db.getTimeCourseData();
                this.dtcrma_.setEnabled(tcd != null && tcd.haveCustomMapForRegion(Group.getBaseID(selected.getObjectID())));
                TemporalInputRangeData tird = db.getTemporalInputRangeData();
                this.dtirma_.setEnabled(tird != null && tird.haveCustomMapForRegion(Group.getBaseID(selected.getObjectID())));
                int topOrder = layout.getTopGroupOrder();
                int bottomOrder = layout.getBottomGroupOrder();
                GroupProperties gProp = layout.getGroupProperties(Group.getBaseID(selected.getObjectID()));
                int gOrd = gProp.getOrder();
                this.rgra_.setEnabled(topOrder > gOrd);
                this.lgra_.setEnabled(bottomOrder < gOrd);
            }
            this.groupPopup_.show(PopControl.this.suPanel_, x, y);
            this.groupPopup_.requestFocusInWindow();
        }

        void generateSubGroupMenu(GenomeInstance gi, Group parent) {
            this.subGroupMenuGroup_.setEnabled(true);
            this.subGroupMenuGroup_.removeAll();
            this.subGroupMenuGroup_.add(this.csga_);
            List subs = gi.getSubgroupsForGroup(parent.getID());
            Iterator sit = subs.iterator();
            if (sit.hasNext()) {
                this.subGroupMenuGroup_.add(new JSeparator());
            }
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                Group subgroup = gi.getGroup(subID);
                JMenu subMenu = new JMenu(subgroup.getName());
                this.generateSubGroupMenuCore(subMenu, subgroup, "groupPopup.DeleteSubGroup", false, "groupPopup.DeleteSubGroupMnem");
                this.subGroupMenuGroup_.add(subMenu);
            }
        }

        private void generateSubGroupMenuCore(JMenu subMenu, Group subgroup, String delTag, boolean forDeactivation, String mnemTag) {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            subMenu.add(popCommands.new PopCommands.GroupPropertiesAction(subgroup.getID(), rMan.getString("groupPopup.GroupProperties"), rMan.getChar("groupPopup.GroupPropertiesMnem")));
            subMenu.add(new JSeparator());
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            subMenu.add(popCommands2.new PopCommands.DeleteSubGroupAction(subgroup, rMan.getString(delTag), forDeactivation, rMan.getChar(mnemTag)));
            subMenu.add(new JSeparator());
            JMenu tcManageMenu = new JMenu(rMan.getString("groupPopup.tcManage"));
            tcManageMenu.setMnemonic(rMan.getChar("groupPopup.tcManageMnem"));
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            tcManageMenu.add(popCommands3.new PopCommands.TimeCourseRegionMappingAction(subgroup.getID(), rMan.getString("groupPopup.RegionMap"), rMan.getChar("groupPopup.RegionMapMnem")));
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            PopCommands.DeleteTimeCourseRegionMapAction dtcrma = popCommands4.new PopCommands.DeleteTimeCourseRegionMapAction(subgroup.getID(), rMan.getString("groupPopup.DeleteRegionMap"), rMan.getChar("groupPopup.DeleteRegionMapMnem"));
            tcManageMenu.add(dtcrma);
            Database db = Database.getDB();
            TimeCourseData tcd = db.getTimeCourseData();
            dtcrma.setEnabled(tcd != null && tcd.haveCustomMapForRegion(Group.getBaseID(subgroup.getID())));
            subMenu.add(tcManageMenu);
            JMenu tiManageMenu = new JMenu(rMan.getString("groupPopup.tiManage"));
            tiManageMenu.setMnemonic(rMan.getChar("groupPopup.tiManageMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            tiManageMenu.add(popCommands5.new PopCommands.TemporalInputRegionMappingAction(subgroup.getID(), rMan.getString("groupPopup.InputRegionMap"), rMan.getChar("groupPopup.InputRegionMapMnem")));
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            PopCommands.DeleteTemporalInputRegionMapAction dtirma = popCommands6.new PopCommands.DeleteTemporalInputRegionMapAction(subgroup.getID(), rMan.getString("groupPopup.DeleteInputRegionMap"), rMan.getChar("groupPopup.DeleteInputRegionMapMnem"));
            tiManageMenu.add(dtirma);
            TemporalInputRangeData tird = db.getTemporalInputRangeData();
            dtirma.setEnabled(tird != null && tird.haveCustomMapForRegion(Group.getBaseID(subgroup.getID())));
            subMenu.add(tiManageMenu);
        }

        void generateSubSetSubGroupMenu(GenomeInstance gi, Group parent) {
            this.subGroupMenuGroup_.removeAll();
            String active = parent.getActiveSubset();
            boolean haveActive = active != null;
            MenuResult included = this.generateIncludeSubGroups(gi, parent, haveActive);
            boolean haveIncluded = included.included.size() != 0;
            JMenu subMenuA = this.generateActivationSubGroups(gi, parent, haveActive, haveIncluded);
            this.subGroupMenuGroup_.add(subMenuA);
            this.subGroupMenuGroup_.add(included.canInclude);
            if (haveActive) {
                this.subGroupMenuGroup_.add(new JSeparator());
                Group subgroup = gi.getGroup(active);
                String groupName = gi.getInheritedGroupName(active);
                this.subGroupMenuGroup_.add(this.generateActivatedSubGroupMenu(subgroup, groupName));
            } else {
                int intSize = included.included.size();
                if (haveIncluded) {
                    this.subGroupMenuGroup_.add(new JSeparator());
                }
                for (int i = 0; i < intSize; ++i) {
                    this.subGroupMenuGroup_.add((JMenu)included.included.get(i));
                }
            }
            this.subGroupMenuGroup_.setEnabled(haveActive || subMenuA.isEnabled() || haveIncluded || included.canInclude.isEnabled());
        }

        JMenu generateActivationSubGroups(GenomeInstance gi, Group enclosing, boolean haveActive, boolean haveIncluded) {
            ResourceManager rMan = ResourceManager.getManager();
            JMenu retval = new JMenu(rMan.getString("groupPopup.ActivateSubgroup"));
            retval.setMnemonic(rMan.getChar("nodePopup.RemoveFromSubGroupMnem"));
            if (haveActive || haveIncluded) {
                retval.setEnabled(false);
                return retval;
            }
            String enclosingBase = Group.getBaseID(enclosing.getID());
            GenomeInstance parentGI = gi.getVfgParent();
            int genCount = parentGI.getGeneration();
            String parentEnclosing = Group.buildInheritedID(enclosingBase, genCount);
            List subs = parentGI.getSubgroupsForGroup(parentEnclosing);
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                Group group = parentGI.getGroup(subID);
                PopCommands popCommands = PopControl.this.popCmds_;
                popCommands.getClass();
                retval.add(popCommands.new PopCommands.ActivateSubGroupAction(enclosing.getID(), subID, parentGI.getInheritedGroupName(group.getID())));
            }
            int size = retval.getMenuComponentCount();
            retval.setEnabled(size != 0);
            return retval;
        }

        private MenuResult generateIncludeSubGroups(GenomeInstance gi, Group enclosing, boolean haveActive) {
            MenuResult retval = new MenuResult();
            ResourceManager rMan = ResourceManager.getManager();
            retval.canInclude = new JMenu(rMan.getString("groupPopup.IncludeSubgroup"));
            retval.canInclude.setMnemonic(rMan.getChar("groupPopup.IncludeSubgroupMnem"));
            if (haveActive) {
                retval.canInclude.setEnabled(false);
                return retval;
            }
            String enclosingBase = Group.getBaseID(enclosing.getID());
            GenomeInstance parentGI = gi.getVfgParent();
            int genCount = parentGI.getGeneration();
            String parentEnclosing = Group.buildInheritedID(enclosingBase, genCount);
            List subs = parentGI.getSubgroupsForGroup(parentEnclosing);
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                String addGenID = Group.addGeneration(subID);
                Group subgroup = gi.getGroup(addGenID);
                if (subgroup == null) {
                    Group group = parentGI.getGroup(subID);
                    JMenu jMenu = retval.canInclude;
                    PopCommands popCommands = PopControl.this.popCmds_;
                    popCommands.getClass();
                    jMenu.add(popCommands.new PopCommands.IncludeSubGroupAction(enclosing.getID(), subID, parentGI.getInheritedGroupName(group.getID())));
                    continue;
                }
                JMenu subMenu = new JMenu(gi.getInheritedGroupName(addGenID));
                this.generateSubGroupMenuCore(subMenu, subgroup, "groupPopup.DeleteSubGroup", false, "groupPopup.DeleteSubGroupMnem");
                retval.included.add(subMenu);
            }
            int size = retval.canInclude.getMenuComponentCount();
            retval.canInclude.setEnabled(size != 0);
            return retval;
        }

        JMenu generateActivatedSubGroupMenu(Group subgroup, String groupName) {
            JMenu retval = new JMenu(groupName);
            this.generateSubGroupMenuCore(retval, subgroup, "groupPopup.deactivate", true, "groupPopup.deactivateMnem");
            return retval;
        }
    }

    private class LinkPointPopup {
        private JPopupMenu linkPointPopup_;
        private PopCommands.DeleteLinkPointAction dlpa_;

        private LinkPointPopup() {
        }

        void buildPopup(boolean readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            this.linkPointPopup_ = new JPopupMenu();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.dlpa_ = popCommands.new PopCommands.DeleteLinkPointAction(rMan.getString("linkPointPopup.Delete"), rMan.getChar("linkPointPopup.DeleteMnem"));
            this.linkPointPopup_.add(this.dlpa_);
            this.linkPointPopup_.addPopupMenuListener(new PopupHandler());
        }

        void showPopup(Genome genome, Layout layout, Intersection selected, int x, int y, boolean readOnly) {
            BusProperties lp = layout.getLinkProperties(selected.getObjectID());
            LinkSegmentID segID = selected.segmentIDFromIntersect();
            if (segID.isBusNodeConnection()) {
                this.dlpa_.setEnabled(false);
            } else if (!lp.hasSimpleConnectivity(segID)) {
                this.dlpa_.setEnabled(false);
            } else {
                this.dlpa_.setEnabled(true);
            }
            this.linkPointPopup_.show(PopControl.this.suPanel_, x, y);
            this.linkPointPopup_.requestFocusInWindow();
        }

        boolean isVisible() {
            return this.linkPointPopup_.isVisible();
        }
    }

    private class LinkPopup {
        private JPopupMenu popMenu_;
        private JMenu layoutOpsMenu_;
        private JMenu netTopoOpsMenu_;
        private PopCommands.FullSelectionAction lfsa_;
        private PopCommands.LinkPropertiesAction llpa_;
        private PopCommands.DivideAction lda_;
        private PopCommands.DeleteLinkageAction ldla_;
        private PopCommands.DisplayLinkDataAction dlda_;
        private PopCommands.SpecialLineAction sla_;
        private PopCommands.InsertNodeInLinkAction inila_;
        private PopCommands.InsertNodeInLinkAction igila_;
        private PopCommands.RelocateTargetAction rta_;
        private PopCommands.SwapPadsAction spa_;
        private PopCommands.RelocateSourceAction rsrca_;
        private PopCommands.RelocateSegmentAction rsa_;
        private PopCommands.AnalyzePathsAction apa_;
        private PopCommands.ChangeSourceNodeAction csna_;
        private PopCommands.ChangeTargetNodeAction ctna_;
        private PopCommands.SelectLinkSourceAction slsa_;
        private PopCommands.SelectLinkTargetsAction slta_;
        private PopCommands.RepairLinkTreeAction rlta_;
        private PopCommands.RelayoutLinkAction rla_;
        private PopCommands.OptimizeLinkAction ola_;
        private PopCommands.LinkUsagesAction lua_;
        private PopCommands.FixNonOrthoSegmentAction fnosamh_;
        private PopCommands.FixNonOrthoSegmentAction fnosams_;
        private PopCommands.FixAllNonOrthoSegmentsInTreeAction fanosetamh_;
        private PopCommands.FixAllNonOrthoSegmentsInTreeAction fanosetams_;

        private LinkPopup() {
        }

        void buildMenu(boolean readOnly) {
            this.popMenu_ = new JPopupMenu();
            this.popMenu_.addPopupMenuListener(new PopupHandler());
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.dlda_ = popCommands.new PopCommands.DisplayLinkDataAction(rMan.getString("linkPopup.experimentalData"), rMan.getChar("linkPopup.experimentalDataMnem"));
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.lfsa_ = popCommands2.new PopCommands.FullSelectionAction(rMan.getString("linkPopup.SelectAll"), rMan.getChar("linkPopup.SelectAllMnem"));
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.apa_ = popCommands3.new PopCommands.AnalyzePathsAction(rMan.getString("linkPopup.AnalyzePaths"), !readOnly, rMan.getChar("linkPopup.AnalyzePathsMnem"));
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.slsa_ = popCommands4.new PopCommands.SelectLinkSourceAction(rMan.getString("linkPopup.selectSource"), rMan.getChar("linkPopup.selectSourceMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.slta_ = popCommands5.new PopCommands.SelectLinkTargetsAction(rMan.getString("linkPopup.selectTargets"), rMan.getChar("linkPopup.selectTargetsMnem"));
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.lua_ = popCommands6.new PopCommands.LinkUsagesAction(rMan.getString("linkPopup.FindUsages"), rMan.getChar("linkPopup.FindUsagesMnem"));
            if (readOnly) {
                return;
            }
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.llpa_ = popCommands7.new PopCommands.LinkPropertiesAction(rMan.getString("linkPopup.LinkProperties"), rMan.getChar("linkPopup.LinkPropertiesMnem"));
            PopCommands popCommands8 = PopControl.this.popCmds_;
            popCommands8.getClass();
            this.sla_ = popCommands8.new PopCommands.SpecialLineAction(rMan.getString("linkPopup.SpecialLine"), rMan.getChar("linkPopup.SpecialLineMnem"));
            this.netTopoOpsMenu_ = new JMenu(rMan.getString("linkPopup.topoOps"));
            this.netTopoOpsMenu_.setMnemonic(rMan.getChar("linkPopup.topoOpsMnem"));
            PopCommands popCommands9 = PopControl.this.popCmds_;
            popCommands9.getClass();
            this.igila_ = popCommands9.new PopCommands.InsertNodeInLinkAction(rMan.getString("linkPopup.insertGene"), true, rMan.getChar("linkPopup.insertGeneMnem"));
            PopCommands popCommands10 = PopControl.this.popCmds_;
            popCommands10.getClass();
            this.inila_ = popCommands10.new PopCommands.InsertNodeInLinkAction(rMan.getString("linkPopup.insertNode"), false, rMan.getChar("linkPopup.insertNodeMnem"));
            PopCommands popCommands11 = PopControl.this.popCmds_;
            popCommands11.getClass();
            this.csna_ = popCommands11.new PopCommands.ChangeSourceNodeAction(rMan.getString("linkPopup.SrcNodeChange"), rMan.getChar("linkPopup.SrcNodeChangeMnem"));
            PopCommands popCommands12 = PopControl.this.popCmds_;
            popCommands12.getClass();
            this.ctna_ = popCommands12.new PopCommands.ChangeTargetNodeAction(rMan.getString("linkPopup.TargNodeChange"), rMan.getChar("linkPopup.TargNodeChangMnem"));
            this.netTopoOpsMenu_.add(this.igila_);
            this.netTopoOpsMenu_.add(this.inila_);
            this.netTopoOpsMenu_.add(new JSeparator());
            this.netTopoOpsMenu_.add(this.csna_);
            this.netTopoOpsMenu_.add(this.ctna_);
            PopCommands popCommands13 = PopControl.this.popCmds_;
            popCommands13.getClass();
            this.lda_ = popCommands13.new PopCommands.DivideAction(rMan.getString("linkPopup.Divide"), false, rMan.getChar("linkPopup.DivideMnem"));
            PopCommands popCommands14 = PopControl.this.popCmds_;
            popCommands14.getClass();
            this.rsa_ = popCommands14.new PopCommands.RelocateSegmentAction(rMan.getString("linkPopup.SegReloc"), false, rMan.getChar("linkPopup.SegRelocMnem"));
            PopCommands popCommands15 = PopControl.this.popCmds_;
            popCommands15.getClass();
            this.rsrca_ = popCommands15.new PopCommands.RelocateSourceAction(rMan.getString("linkPopup.SrcReloc"), false, rMan.getChar("linkPopup.SrcRelocMnem"));
            PopCommands popCommands16 = PopControl.this.popCmds_;
            popCommands16.getClass();
            this.rta_ = popCommands16.new PopCommands.RelocateTargetAction(rMan.getString("linkPopup.TargReloc"), false, rMan.getChar("linkPopup.TargRelocMnem"));
            PopCommands popCommands17 = PopControl.this.popCmds_;
            popCommands17.getClass();
            this.spa_ = popCommands17.new PopCommands.SwapPadsAction(rMan.getString("linkPopup.SwapPads"), rMan.getChar("linkPopup.SwapPadsMnem"));
            PopCommands popCommands18 = PopControl.this.popCmds_;
            popCommands18.getClass();
            this.ldla_ = popCommands18.new PopCommands.DeleteLinkageAction(rMan.getString("linkPopup.LinkDelete"), rMan.getChar("linkPopup.LinkDeleteMnem"));
            this.layoutOpsMenu_ = new JMenu(rMan.getString("linkPopup.layoutOps"));
            this.layoutOpsMenu_.setMnemonic(rMan.getChar("linkPopup.layoutOpsMnem"));
            this.buildLayoutOpsMenu();
        }

        private void buildLayoutOpsMenu() {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.fanosetamh_ = popCommands.new PopCommands.FixAllNonOrthoSegmentsInTreeAction(rMan.getString("linkPopup.fixAllNonOrthoSegmentsMinShift"), false, false, rMan.getChar("linkPopup.fixAllNonOrthoSegmentsMinShiftMnem"));
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.fanosetams_ = popCommands2.new PopCommands.FixAllNonOrthoSegmentsInTreeAction(rMan.getString("linkPopup.fixAllNonOrthoSegmentsMinSplit"), false, true, rMan.getChar("linkPopup.fixAllNonOrthoSegmentsMinSplitMnem"));
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.fnosamh_ = popCommands3.new PopCommands.FixNonOrthoSegmentAction(rMan.getString("linkPopup.fixNonOrthoMinShift"), false, false, rMan.getChar("linkPopup.fixNonOrthoMinShiftMnem"));
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.fnosams_ = popCommands4.new PopCommands.FixNonOrthoSegmentAction(rMan.getString("linkPopup.fixNonOrthoMinSplit"), false, true, rMan.getChar("linkPopup.fixNonOrthoMinSplitMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.rlta_ = popCommands5.new PopCommands.RepairLinkTreeAction(rMan.getString("linkPopup.TopoRepair"), rMan.getChar("linkPopup.TopoRepairMnem"), false);
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.rla_ = popCommands6.new PopCommands.RelayoutLinkAction(rMan.getString("linkPopup.SegLayout"), rMan.getChar("linkPopup.SegLayoutMnem"));
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.ola_ = popCommands7.new PopCommands.OptimizeLinkAction(rMan.getString("linkPopup.SegOptimize"), rMan.getChar("linkPopup.SegOptimizeMnem"), false);
            JMenu fixOrthoSubMenu = new JMenu(rMan.getString("command.fixOrthoSubMenu"));
            fixOrthoSubMenu.setMnemonic(rMan.getChar("command.fixOrthoSubMenuMnem"));
            this.layoutOpsMenu_.add(fixOrthoSubMenu);
            fixOrthoSubMenu.add(this.fanosetamh_);
            fixOrthoSubMenu.add(this.fanosetams_);
            JMenu fixOrthoSegSubMenu = new JMenu(rMan.getString("command.fixOrthoSegSubMenu"));
            fixOrthoSegSubMenu.setMnemonic(rMan.getChar("command.fixOrthoSegSubMenuMnem"));
            this.layoutOpsMenu_.add(fixOrthoSegSubMenu);
            fixOrthoSegSubMenu.add(this.fnosamh_);
            fixOrthoSegSubMenu.add(this.fnosams_);
            this.layoutOpsMenu_.add(this.rla_);
            this.layoutOpsMenu_.add(this.ola_);
            this.layoutOpsMenu_.add(this.rlta_);
        }

        void installMenuItems(boolean readOnly, MenuItemTarget useMenu) {
            useMenu.add(this.dlda_);
            useMenu.add(new JSeparator());
            useMenu.add(this.lfsa_);
            useMenu.add(new JSeparator());
            useMenu.add(this.apa_);
            useMenu.add(this.slsa_);
            useMenu.add(this.slta_);
            useMenu.add(this.lua_);
            if (readOnly) {
                return;
            }
            useMenu.add(new JSeparator());
            useMenu.add(this.llpa_);
            useMenu.add(this.sla_);
            useMenu.add(new JSeparator());
            useMenu.add(this.netTopoOpsMenu_);
            useMenu.add(new JSeparator());
            useMenu.add(this.lda_);
            useMenu.add(this.rsa_);
            useMenu.add(this.rsrca_);
            useMenu.add(this.rta_);
            useMenu.add(this.spa_);
            useMenu.add(this.ldla_);
            useMenu.add(new JSeparator());
            useMenu.add(this.layoutOpsMenu_);
        }

        void showPopup(Intersection selected, int x, int y, boolean readOnly) {
            this.prepareMenu(selected, readOnly, true, true);
            this.popMenu_.show(PopControl.this.suPanel_, x, y);
            this.popMenu_.requestFocusInWindow();
        }

        void prepareMenu(Intersection selected, boolean readOnly, boolean justASeg, boolean canSplit) {
            if (!justASeg) {
                this.dlda_.setEnabled(false);
                this.lfsa_.setEnabled(false);
                this.apa_.setEnabled(false);
                this.slsa_.setEnabled(false);
                this.slta_.setEnabled(false);
                this.lua_.setEnabled(false);
                if (!readOnly) {
                    this.llpa_.setEnabled(true);
                    this.sla_.setEnabled(false);
                    this.inila_.setEnabled(false);
                    this.igila_.setEnabled(false);
                    this.rta_.setEnabled(false);
                    this.spa_.setEnabled(false);
                    this.rsrca_.setEnabled(false);
                    this.csna_.setEnabled(false);
                    this.ctna_.setEnabled(false);
                    this.rsa_.setEnabled(false);
                    this.rla_.setEnabled(false);
                    this.ola_.setEnabled(false);
                    this.rlta_.setEnabled(false);
                    this.lda_.setEnabled(false);
                    this.ldla_.setEnabled(false);
                    this.fanosetamh_.setEnabled(false);
                    this.fanosetams_.setEnabled(false);
                    this.fnosamh_.setEnabled(false);
                    this.fnosams_.setEnabled(false);
                }
                return;
            }
            this.dlda_.setEnabled(true);
            this.apa_.setEnabled(this.apa_.amIValid(selected));
            this.lfsa_.setEnabled(true);
            this.slsa_.setEnabled(true);
            this.slta_.setEnabled(true);
            this.lua_.setEnabled(true);
            if (!readOnly) {
                this.sla_.setEnabled(this.sla_.amIValid(selected));
                this.inila_.setEnabled(canSplit && this.inila_.amIValid(selected));
                this.igila_.setEnabled(canSplit && this.igila_.amIValid(selected));
                this.rta_.setEnabled(this.rta_.amIValid(selected));
                this.spa_.setEnabled(this.spa_.amIValid(selected));
                this.rsrca_.setEnabled(this.rsrca_.amIValid(selected));
                this.csna_.setEnabled(this.csna_.amIValid(selected));
                this.ctna_.setEnabled(this.ctna_.amIValid(selected));
                this.rsa_.setEnabled(this.rsa_.amIValid(selected));
                this.rla_.setEnabled(this.rla_.amIValid(selected));
                this.rlta_.setEnabled(this.rlta_.amIValid(selected));
                this.ola_.setEnabled(this.ola_.amIValid(selected));
                this.llpa_.setEnabled(true);
                this.lda_.setEnabled(canSplit);
                this.ldla_.setEnabled(true);
                this.fanosetamh_.setEnabled(this.fanosetamh_.amIValid(selected));
                this.fanosetams_.setEnabled(this.fanosetams_.amIValid(selected));
                this.fnosamh_.setEnabled(this.fnosamh_.amIValid(selected));
                this.fnosams_.setEnabled(this.fnosams_.amIValid(selected));
            }
        }

        boolean isVisible() {
            return this.popMenu_.isVisible();
        }

        JPopupMenu getPopup() {
            return this.popMenu_;
        }
    }

    private class NodePopup {
        private JPopupMenu popMenu_;
        private AbstractAction pa_;
        private PopCommands.DisplayDataAction dda_;
        private PopCommands.SimulationPropertiesAction spa_;
        private PopCommands.EditPertAction eqa_;
        private PopCommands.EditPertMapAction eqma_;
        private PopCommands.DeletePertAction dqa_;
        private PopCommands.DeletePertMapAction dqma_;
        private PopCommands.EditTimeCourseAction etca_;
        private PopCommands.EditPerturbedTimeCourseAction eptca_;
        private PopCommands.EditTimeCourseMapAction etcma_;
        private PopCommands.DeleteTimeCourseAction dtca_;
        private PopCommands.DeleteTimeCourseMapAction dtcma_;
        private PopCommands.EditTemporalInputAction etia_;
        private PopCommands.EditTemporalInputMapAction etima_;
        private PopCommands.DeleteTemporalInputAction dtia_;
        private PopCommands.DeleteTemporalInputMapAction dtima_;
        private PopCommands.NodeTypeChangeAction ntca_;
        private PopCommands.NodeSuperAddAction nsaa_;
        private PopCommands.DeleteNodeAction dna_;
        private PopCommands.SelectSourcesAction ssa_;
        private PopCommands.SelectSourcesAction ssaGeneOnly_;
        private PopCommands.SelectTargetsAction sta_;
        private PopCommands.SelectTargetsAction staGeneOnly_;
        private PopCommands.NodeUsagesAction nua_;
        private PopCommands.ChangeNodeGroupMembershipAction cngma_;
        private PopCommands.SelectLinksToggle sltoga_;
        private PopCommands.SelectQueryNodeToggle sqntoga_;
        private PopCommands.AppendToCurrentSelectionToggle sa2ctoga_;
        private JMenu subGroupMenu_;
        private JMenu sourceMenu_;
        private JMenu qpcrSourceMenu_;
        private JMenu addToModuleMenu_;
        private JMenu sourceSearchMenu_;
        private JMenu targetSearchMenu_;
        private JMenu deleteFromModuleMenu_;
        private JMenu pertManageMenu_;
        private JMenu tcManageMenu_;
        private JMenu tiManageMenu_;
        private JCheckBoxMenuItem til_;
        private JCheckBoxMenuItem tqni_;
        private JCheckBoxMenuItem ta2c_;

        private NodePopup() {
        }

        JPopupMenu getPopup() {
            return this.popMenu_;
        }

        boolean isVisible() {
            return this.popMenu_.isVisible();
        }

        void buildGeneMenu(boolean readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.buildPopupCore(readOnly, popCommands.new PopCommands.GenePropertiesAction(rMan.getString("genePopup.Properties"), rMan.getChar("genePopup.PropertiesMnem")));
        }

        void buildNodeMenu(boolean readOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.buildPopupCore(readOnly, popCommands.new PopCommands.NodePropertiesAction(rMan.getString("nodePopup.Properties"), rMan.getChar("nodePopup.PropertiesMnem")));
        }

        void buildPopupCore(boolean readOnly, AbstractAction propCmd) {
            this.popMenu_ = new JPopupMenu();
            this.popMenu_.addPopupMenuListener(new PopupHandler());
            ResourceManager rMan = ResourceManager.getManager();
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.dda_ = popCommands.new PopCommands.DisplayDataAction(rMan.getString("genePopup.ExpData"), rMan.getChar("genePopup.ExpDataMnem"));
            this.sourceMenu_ = new JMenu(rMan.getString("nodePopup.sourceGenes"));
            this.sourceMenu_.setMnemonic(rMan.getChar("nodePopup.sourceGenesMnem"));
            if (!readOnly) {
                this.qpcrSourceMenu_ = new JMenu(rMan.getString("nodePopup.qpcrSourceGenes"));
                this.qpcrSourceMenu_.setMnemonic(rMan.getChar("nodePopup.qpcrSourceGenesMnem"));
            }
            this.sourceSearchMenu_ = new JMenu(rMan.getString("nodePopup.findSrcMenu"));
            this.sourceSearchMenu_.setMnemonic(rMan.getChar("nodePopup.findSrcMenuMnem"));
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.ssa_ = popCommands2.new PopCommands.SelectSourcesAction(rMan.getString("nodePopup.FindSources"), false, rMan.getChar("nodePopup.FindSourcesMnem"));
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.ssaGeneOnly_ = popCommands3.new PopCommands.SelectSourcesAction(rMan.getString("nodePopup.FindSourcesGO"), true, rMan.getChar("nodePopup.FindSourcesGOMnem"));
            this.targetSearchMenu_ = new JMenu(rMan.getString("nodePopup.findTrgMenu"));
            this.targetSearchMenu_.setMnemonic(rMan.getChar("nodePopup.findTrgMenuMnem"));
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.sta_ = popCommands4.new PopCommands.SelectTargetsAction(rMan.getString("nodePopup.FindTargets"), false, rMan.getChar("nodePopup.FindTargetsMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.staGeneOnly_ = popCommands5.new PopCommands.SelectTargetsAction(rMan.getString("nodePopup.FindTargetsGO"), true, rMan.getChar("nodePopup.FindTargetsGOMnem"));
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.sltoga_ = popCommands6.new PopCommands.SelectLinksToggle(rMan.getString("nodePopup.ToggleIncludeLinks"), rMan.getChar("nodePopup.ToggleIncludeLinksMnem"));
            this.til_ = new JCheckBoxMenuItem(this.sltoga_);
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.sqntoga_ = popCommands7.new PopCommands.SelectQueryNodeToggle(rMan.getString("nodePopup.ToggleIncludeQueryNode"), rMan.getChar("nodePopup.ToggleIncludeQueryNodeMnem"));
            this.tqni_ = new JCheckBoxMenuItem(this.sqntoga_);
            PopCommands popCommands8 = PopControl.this.popCmds_;
            popCommands8.getClass();
            this.sa2ctoga_ = popCommands8.new PopCommands.AppendToCurrentSelectionToggle(rMan.getString("nodePopup.ToggleAddToCurrentSelections"), rMan.getChar("nodePopup.ToggleAddToCurrentSelectionsMnem"));
            this.ta2c_ = new JCheckBoxMenuItem(this.sa2ctoga_);
            PopCommands popCommands9 = PopControl.this.popCmds_;
            popCommands9.getClass();
            this.nua_ = popCommands9.new PopCommands.NodeUsagesAction(rMan.getString("nodePopup.FindUsages"), rMan.getChar("nodePopup.FindUsagesMnem"));
            if (readOnly) {
                return;
            }
            this.pa_ = propCmd;
            PopCommands popCommands10 = PopControl.this.popCmds_;
            popCommands10.getClass();
            this.spa_ = popCommands10.new PopCommands.SimulationPropertiesAction(rMan.getString("nodePopup.SimProperties"), rMan.getChar("nodePopup.SimPropertiesMnem"));
            PopCommands popCommands11 = PopControl.this.popCmds_;
            popCommands11.getClass();
            this.nsaa_ = popCommands11.new PopCommands.NodeSuperAddAction(rMan.getString("nodePopup.SuperAdd"), rMan.getChar("nodePopup.SuperAddMnem"));
            PopCommands popCommands12 = PopControl.this.popCmds_;
            popCommands12.getClass();
            this.ntca_ = popCommands12.new PopCommands.NodeTypeChangeAction(rMan.getString("nodePopup.ChangeType"), rMan.getChar("nodePopup.ChangeTypeMnem"));
            PopCommands popCommands13 = PopControl.this.popCmds_;
            popCommands13.getClass();
            this.cngma_ = popCommands13.new PopCommands.ChangeNodeGroupMembershipAction(rMan.getString("nodePopup.ChangeNodeGroup"), rMan.getChar("nodePopup.ChangeNodeGroupMnem"));
            this.subGroupMenu_ = new JMenu(rMan.getString("nodePopup.SubGroups"));
            this.subGroupMenu_.setMnemonic(rMan.getChar("nodePopup.SubGroupsMnem"));
            PopCommands popCommands14 = PopControl.this.popCmds_;
            popCommands14.getClass();
            this.dna_ = popCommands14.new PopCommands.DeleteNodeAction(rMan.getString("nodePopup.NodeDelete"), rMan.getChar("nodePopup.NodeDeleteMnem"));
            this.addToModuleMenu_ = new JMenu(rMan.getString("nodePopup.addToNetModule"));
            this.addToModuleMenu_.setMnemonic(rMan.getChar("nodePopup.addToNetModuleMnem"));
            this.deleteFromModuleMenu_ = new JMenu(rMan.getString("nodePopup.deleteFromNetModule"));
            this.deleteFromModuleMenu_.setMnemonic(rMan.getChar("nodePopup.deleteFromNetModuleMnem"));
            this.buildDataManagementMenus();
        }

        void installMenuItems(boolean readOnly, MenuItemTarget useMenu) {
            useMenu.add(this.dda_);
            useMenu.add(new JSeparator());
            useMenu.add(this.sourceSearchMenu_);
            this.sourceSearchMenu_.add(this.ssaGeneOnly_);
            this.sourceSearchMenu_.add(this.ssa_);
            useMenu.add(this.targetSearchMenu_);
            this.targetSearchMenu_.add(this.staGeneOnly_);
            this.targetSearchMenu_.add(this.sta_);
            useMenu.add(this.til_);
            useMenu.add(this.tqni_);
            useMenu.add(this.ta2c_);
            useMenu.add(this.nua_);
            useMenu.add(new JSeparator());
            useMenu.add(this.sourceMenu_);
            if (!readOnly) {
                useMenu.add(this.qpcrSourceMenu_);
            }
            if (readOnly) {
                return;
            }
            useMenu.add(new JSeparator());
            useMenu.add(this.pa_);
            useMenu.add(this.spa_);
            useMenu.add(new JSeparator());
            useMenu.add(this.nsaa_);
            useMenu.add(this.ntca_);
            useMenu.add(this.cngma_);
            useMenu.add(this.subGroupMenu_);
            useMenu.add(this.dna_);
            useMenu.add(new JSeparator());
            useMenu.add(this.addToModuleMenu_);
            useMenu.add(this.deleteFromModuleMenu_);
            useMenu.add(new JSeparator());
            useMenu.add(this.pertManageMenu_);
            useMenu.add(this.tcManageMenu_);
            useMenu.add(this.tiManageMenu_);
        }

        private void buildDataManagementMenus() {
            ResourceManager rMan = ResourceManager.getManager();
            this.pertManageMenu_ = new JMenu(rMan.getString("genePopup.pertManage"));
            this.pertManageMenu_.setMnemonic(rMan.getChar("genePopup.pertManageMnem"));
            PopCommands popCommands = PopControl.this.popCmds_;
            popCommands.getClass();
            this.eqa_ = popCommands.new PopCommands.EditPertAction(rMan.getString("genePopup.EditPert"), rMan.getChar("genePopup.EditPertMnem"));
            this.pertManageMenu_.add(this.eqa_);
            PopCommands popCommands2 = PopControl.this.popCmds_;
            popCommands2.getClass();
            this.dqa_ = popCommands2.new PopCommands.DeletePertAction(rMan.getString("genePopup.DeletePert"), rMan.getChar("genePopup.DeletePertMnem"));
            this.pertManageMenu_.add(this.dqa_);
            this.pertManageMenu_.add(new JSeparator());
            PopCommands popCommands3 = PopControl.this.popCmds_;
            popCommands3.getClass();
            this.eqma_ = popCommands3.new PopCommands.EditPertMapAction(rMan.getString("genePopup.EditPertMap"), rMan.getChar("genePopup.EditPertMapMnem"));
            this.pertManageMenu_.add(this.eqma_);
            PopCommands popCommands4 = PopControl.this.popCmds_;
            popCommands4.getClass();
            this.dqma_ = popCommands4.new PopCommands.DeletePertMapAction(rMan.getString("genePopup.DeletePertMap"), rMan.getChar("genePopup.DeletePertMapMnem"));
            this.pertManageMenu_.add(this.dqma_);
            this.tcManageMenu_ = new JMenu(rMan.getString("genePopup.timeCourseManage"));
            this.tcManageMenu_.setMnemonic(rMan.getChar("genePopup.timeCourseManageMnem"));
            PopCommands popCommands5 = PopControl.this.popCmds_;
            popCommands5.getClass();
            this.etca_ = popCommands5.new PopCommands.EditTimeCourseAction(rMan.getString("nodePopup.EditTimeCourse"), rMan.getChar("nodePopup.EditTimeCourseMnem"));
            this.tcManageMenu_.add(this.etca_);
            PopCommands popCommands6 = PopControl.this.popCmds_;
            popCommands6.getClass();
            this.dtca_ = popCommands6.new PopCommands.DeleteTimeCourseAction(rMan.getString("genePopup.DeleteTimeCourse"), rMan.getChar("genePopup.DeleteTimeCourseMnem"));
            this.tcManageMenu_.add(this.dtca_);
            PopCommands popCommands7 = PopControl.this.popCmds_;
            popCommands7.getClass();
            this.eptca_ = popCommands7.new PopCommands.EditPerturbedTimeCourseAction(rMan.getString("nodePopup.ManagePerturbedTimeCourses"), rMan.getChar("nodePopup.ManagePerturbedTimeCoursesMnem"));
            this.tcManageMenu_.add(this.eptca_);
            this.tcManageMenu_.add(new JSeparator());
            PopCommands popCommands8 = PopControl.this.popCmds_;
            popCommands8.getClass();
            this.etcma_ = popCommands8.new PopCommands.EditTimeCourseMapAction(rMan.getString("genePopup.EditTimeCourseMap"), rMan.getChar("genePopup.EditTimeCourseMapMnem"));
            this.tcManageMenu_.add(this.etcma_);
            PopCommands popCommands9 = PopControl.this.popCmds_;
            popCommands9.getClass();
            this.dtcma_ = popCommands9.new PopCommands.DeleteTimeCourseMapAction(rMan.getString("genePopup.DeleteTimeCourseMap"), rMan.getChar("genePopup.DeleteTimeCourseMapMnem"));
            this.tcManageMenu_.add(this.dtcma_);
            this.tiManageMenu_ = new JMenu(rMan.getString("genePopup.TemporalInputManage"));
            this.tiManageMenu_.setMnemonic(rMan.getChar("genePopup.TemporalInputManageMnem"));
            PopCommands popCommands10 = PopControl.this.popCmds_;
            popCommands10.getClass();
            this.etia_ = popCommands10.new PopCommands.EditTemporalInputAction(rMan.getString("nodePopup.EditTemporalInput"), rMan.getChar("nodePopup.EditTemporalInputMnem"));
            this.tiManageMenu_.add(this.etia_);
            PopCommands popCommands11 = PopControl.this.popCmds_;
            popCommands11.getClass();
            this.dtia_ = popCommands11.new PopCommands.DeleteTemporalInputAction(rMan.getString("genePopup.DeleteTemporalInput"), rMan.getChar("genePopup.DeleteTemporalInputMnem"));
            this.tiManageMenu_.add(this.dtia_);
            this.tiManageMenu_.add(new JSeparator());
            PopCommands popCommands12 = PopControl.this.popCmds_;
            popCommands12.getClass();
            this.etima_ = popCommands12.new PopCommands.EditTemporalInputMapAction(rMan.getString("genePopup.EditTemporalInputMap"), rMan.getChar("genePopup.EditTemporalInputMapMnem"));
            this.tiManageMenu_.add(this.etima_);
            PopCommands popCommands13 = PopControl.this.popCmds_;
            popCommands13.getClass();
            this.dtima_ = popCommands13.new PopCommands.DeleteTemporalInputMapAction(rMan.getString("genePopup.DeleteTemporalInputMap"), rMan.getChar("genePopup.DeleteTemporalInputMapMnem"));
            this.tiManageMenu_.add(this.dtima_);
        }

        void showPopup(Genome genome, Layout layout, Intersection selected, int x, int y, boolean readOnly, Node node) {
            this.prepareNodeMenu(genome, layout, selected, readOnly, node);
            this.popMenu_.show(PopControl.this.suPanel_, x, y);
            this.popMenu_.requestFocusInWindow();
        }

        void prepareNodeMenu(Genome genome, Layout layout, Intersection selected, boolean readOnly, Node node) {
            this.sourceSearchMenu_.setEnabled(true);
            this.ssa_.setEnabled(this.ssa_.amIValid(selected));
            this.ssaGeneOnly_.setEnabled(this.ssaGeneOnly_.amIValid(selected));
            this.targetSearchMenu_.setEnabled(true);
            this.sta_.setEnabled(this.sta_.amIValid(selected));
            this.staGeneOnly_.setEnabled(this.staGeneOnly_.amIValid(selected));
            this.til_.setEnabled(this.sltoga_.amIValid(selected));
            this.sltoga_.setToUpdate(true);
            this.til_.setSelected(this.sltoga_.shouldCheck());
            this.sltoga_.setToUpdate(false);
            this.tqni_.setEnabled(this.sqntoga_.amIValid(selected));
            this.sqntoga_.setToUpdate(true);
            this.tqni_.setSelected(this.sqntoga_.shouldCheck());
            this.sqntoga_.setToUpdate(false);
            this.ta2c_.setEnabled(this.sa2ctoga_.amIValid(selected));
            this.sa2ctoga_.setToUpdate(true);
            this.ta2c_.setSelected(this.sa2ctoga_.shouldCheck());
            this.sa2ctoga_.setToUpdate(false);
            if (!readOnly) {
                Database db = Database.getDB();
                this.spa_.setEnabled(genome instanceof DBGenome);
                if (!(genome instanceof DynamicGenomeInstance)) {
                    this.dna_.setEnabled(true);
                } else {
                    String proxID = ((DynamicGenomeInstance)genome).getProxyID();
                    DynamicInstanceProxy prox = db.getDynamicProxy(proxID);
                    this.dna_.setEnabled(prox.hasAddedNode(selected.getObjectID()));
                }
                this.cngma_.setEnabled(this.cngma_.amIValid(selected));
                this.eptca_.setEnabled(this.eptca_.amIValid(selected));
                this.qpcrSourceGeneration(genome, node, this.qpcrSourceMenu_, !readOnly);
                PopControl.this.subGroupGeneration(genome, node, this.subGroupMenu_);
                this.setDataManageViz(selected);
                String overlayKey = PopControl.this.suPanel_.getCurrentOverlay();
                if (overlayKey != null) {
                    NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genome.getID());
                    NetworkOverlay novr = owner.getNetworkOverlay(overlayKey);
                    PopControl.this.netModuleGeneration(genome, node, this.addToModuleMenu_, this.deleteFromModuleMenu_, novr);
                } else {
                    this.addToModuleMenu_.setEnabled(false);
                    this.deleteFromModuleMenu_.setEnabled(false);
                }
            }
            this.sourceGeneration(genome, node, this.sourceMenu_, !readOnly);
        }

        private void setDataManageViz(Intersection selected) {
            String baseID = GenomeItemInstance.getBaseID(selected.getObjectID());
            Database db = Database.getDB();
            PerturbationData pd = db.getPertData();
            this.dqa_.setEnabled(pd.haveDataForNode(baseID, null));
            this.dqma_.setEnabled(pd.haveCustomMapForNode(baseID));
            TimeCourseData tcd = db.getTimeCourseData();
            this.dtca_.setEnabled(tcd != null && tcd.haveDataForNode(baseID));
            this.dtcma_.setEnabled(tcd != null && tcd.haveCustomMapForNode(baseID));
            TemporalInputRangeData tird = db.getTemporalInputRangeData();
            this.dtia_.setEnabled(tird != null && tird.haveDataForNode(baseID));
            this.dtima_.setEnabled(tird != null && tird.haveCustomMapForNode(baseID));
        }

        private void sourceGeneration(Genome genome, Node targNode, JMenu sourceMenu, boolean showQPCR) {
            Set sources = genome.getNodeSources(targNode.getID());
            if (sources.size() == 0) {
                sourceMenu.setEnabled(false);
                return;
            }
            ResourceManager rMan = ResourceManager.getManager();
            sourceMenu.removeAll();
            Iterator sit = sources.iterator();
            while (sit.hasNext()) {
                String sid = (String)sit.next();
                Node sourceNode = genome.getNode(sid);
                String nodeName = sourceNode.getName();
                if (nodeName == null || nodeName.trim().equals("")) {
                    nodeName = rMan.getString("tip.noname");
                }
                PopCommands popCommands = PopControl.this.popCmds_;
                popCommands.getClass();
                sourceMenu.add(popCommands.new PopCommands.AnalyzePathsForNodeAction(targNode.getID(), sourceNode.getID(), nodeName, showQPCR));
            }
            sourceMenu.setEnabled(true);
        }

        private void qpcrSourceGeneration(Genome genome, Node targNode, JMenu sourceMenu, boolean showPert) {
            if (genome instanceof GenomeInstance) {
                sourceMenu.setEnabled(false);
                return;
            }
            PerturbationData pd = Database.getDB().getPertData();
            Set sources = pd.getPerturbationSources(targNode.getID());
            if (sources.size() == 0) {
                sourceMenu.setEnabled(false);
                return;
            }
            ResourceManager rMan = ResourceManager.getManager();
            sourceMenu.removeAll();
            Iterator sit = sources.iterator();
            while (sit.hasNext()) {
                String sid = (String)sit.next();
                Node sourceNode = genome.getNode(sid);
                String nodeName = sourceNode.getName();
                if (nodeName == null || nodeName.trim().equals("")) {
                    nodeName = rMan.getString("tip.noname");
                }
                PopCommands popCommands = PopControl.this.popCmds_;
                popCommands.getClass();
                sourceMenu.add(popCommands.new PopCommands.PerturbPathCompareAction(targNode.getID(), sourceNode.getID(), nodeName, showPert));
            }
            sourceMenu.setEnabled(true);
        }
    }
}

