/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.CrossingReducer;
import org.systemsbiology.biotapestry.analysis.CycleFinder;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.LayerAssignment;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.TransReducer;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.PatternPlacerMinimizeHeight;
import org.systemsbiology.biotapestry.util.PatternPlacerVerticalFit;
import org.systemsbiology.biotapestry.util.SimpleLink;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.Vector2D;

public class RectangularTreeEngine {
    private Grid.SlotTracker tracker_;

    public String[] layout(Set nodes, String genomeKey, boolean targsFirst) {
        ArrayList rankedList;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        TreeSet<TargetRank> ranking = new TreeSet<TargetRank>();
        Iterator nit = nodes.iterator();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            int count = 0;
            ArrayList<String> list = new ArrayList<String>();
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                String trgID;
                Linkage link = (Linkage)lit.next();
                if (!link.getSource().equals(nodeID) || !nodes.contains(trgID = link.getTarget())) continue;
                list.add(trgID);
                ++count;
            }
            TargetRank tr = new TargetRank(nodeID, count, list);
            ranking.add(tr);
        }
        HashSet<String> placed = new HashSet<String>();
        int numNodes = nodes.size();
        String[] positions = new String[numNodes];
        int currPos = 0;
        if (targsFirst) {
            TargetRank trank;
            int i;
            rankedList = new ArrayList(ranking);
            int rankSize = rankedList.size();
            for (i = rankSize - 1; i >= 0; --i) {
                trank = (TargetRank)rankedList.get(i);
                if (trank.targets.size() <= 0 || placed.contains(trank.nodeID)) continue;
                positions[currPos++] = trank.nodeID;
                placed.add(trank.nodeID);
                Iterator trgit = trank.targets.iterator();
                while (trgit.hasNext()) {
                    String targID = (String)trgit.next();
                    if (placed.contains(targID)) continue;
                    positions[currPos++] = targID;
                    placed.add(targID);
                }
            }
            for (i = rankSize - 1; i >= 0; --i) {
                trank = (TargetRank)rankedList.get(i);
                if (placed.contains(trank.nodeID)) continue;
                positions[currPos++] = trank.nodeID;
                placed.add(trank.nodeID);
            }
        } else {
            TargetRank trank;
            int i;
            rankedList = new ArrayList(ranking);
            int rankSize = rankedList.size();
            for (i = rankSize - 1; i >= 0; --i) {
                trank = (TargetRank)rankedList.get(i);
                if (trank.targets.size() <= 0 || placed.contains(trank.nodeID)) continue;
                positions[currPos++] = trank.nodeID;
                placed.add(trank.nodeID);
            }
            for (i = rankSize - 1; i >= 0; --i) {
                trank = (TargetRank)rankedList.get(i);
                Iterator trgit = trank.targets.iterator();
                while (trgit.hasNext()) {
                    String targID = (String)trgit.next();
                    if (placed.contains(targID)) continue;
                    positions[currPos++] = targID;
                    placed.add(targID);
                }
            }
            for (i = rankSize - 1; i >= 0; --i) {
                trank = (TargetRank)rankedList.get(i);
                if (placed.contains(trank.nodeID)) continue;
                positions[currPos++] = trank.nodeID;
                placed.add(trank.nodeID);
            }
        }
        return positions;
    }

    public Grid layoutMotifsHier(List motifList, Set nodesToPlace, String genomeKey, LayoutOptions options, boolean incremental, String forceCore, boolean forceToLeft) {
        HashSet<String> allNodes = new HashSet<String>();
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            allNodes.add(node.getID());
        }
        HashSet<Link> linksWithFeedback = new HashSet<Link>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            Link slink = new Link(src, trg);
            linksWithFeedback.add(slink);
        }
        return this.layoutMotifsHierCore(allNodes, linksWithFeedback, motifList, nodesToPlace, options, incremental, forceCore, forceToLeft);
    }

    private Grid layoutMotifsHierCore(Set allNodes, Set allLinks, List motifList, Set nodesToPlace, LayoutOptions options, boolean incremental, String forceCore, boolean forceToLeft) {
        TreeSet nodes = new TreeSet(allNodes);
        ArrayList<Link> preLinks = new ArrayList<Link>();
        ArrayList<DialogBuiltMotif> sortedMList = new ArrayList<DialogBuiltMotif>();
        Iterator mit = motifList.iterator();
        while (mit.hasNext()) {
            DialogBuiltMotif dbm = (DialogBuiltMotif)mit.next();
            int lcount = dbm.getLinkCount();
            for (int i = 0; i < lcount; ++i) {
                Link cfl = dbm.getLink(i);
                preLinks.add(cfl);
            }
            sortedMList.add(dbm);
        }
        Collections.sort(sortedMList, new DialogBuiltMotif.DBMComparator());
        TreeSet<Link> links = new TreeSet<Link>();
        Iterator prit = preLinks.iterator();
        while (prit.hasNext()) {
            Link cfl = (Link)prit.next();
            links.add(cfl);
            CycleFinder cf = new CycleFinder(nodes, links);
            if (!cf.hasACycle()) continue;
            links.remove(cfl);
        }
        GraphSearcher searcher = new GraphSearcher(nodes, links);
        Map topoSort = searcher.topoSort(options.topoCompress);
        if (forceCore != null) {
            topoSort = GraphSearcher.topoSortReposition(topoSort, forceCore, forceToLeft);
        }
        PatternGrid grid = new PatternGrid();
        HashSet<SimpleLink> simpleLinks = new HashSet<SimpleLink>();
        Iterator lit = allLinks.iterator();
        while (lit.hasNext()) {
            Link slink = (Link)lit.next();
            String src = slink.getSrc();
            String trg = slink.getTrg();
            simpleLinks.add(new SimpleLink(src, trg));
        }
        topoSort = options.layeringMethod == 2 ? this.squashSort(topoSort, options.maxPerLayer) : this.layerAssignment(simpleLinks, topoSort, options.maxPerLayer, options.layeringMethod);
        if (!options.firstPass) {
            HashSet placed = new HashSet();
            int mSize = motifList.size();
            for (int i = 0; i < mSize; ++i) {
                DialogBuiltMotif dbm = (DialogBuiltMotif)sortedMList.get(i);
                this.placeMotifInPattern(dbm, grid, placed, allNodes, topoSort);
            }
        } else {
            if (!options.firstPass) {
                throw new IllegalStateException();
            }
            this.recursivePlaceMotifInPattern(sortedMList, grid, allNodes, topoSort);
        }
        Grid retGrid = this.patternToGrid(grid, nodesToPlace, simpleLinks, options, topoSort);
        if (options.normalizeRows || incremental) {
            retGrid = this.normalizeGrid(retGrid);
        }
        return retGrid;
    }

    public Grid layoutFanInOutHier(Set allNodes, Set allLinks, Set nodesToPlace, List motifList, LayoutOptions options, String forceCore, boolean forceToLeft) {
        return this.layoutMotifsHierCore(allNodes, allLinks, motifList, nodesToPlace, options, false, forceCore, forceToLeft);
    }

    private Grid patternToGrid(PatternGrid grid, Set nodesToPlace, Set allLinks, LayoutOptions options, Map topoSort) {
        MinMax xRange = grid.getMinMaxXForRange(null);
        MinMax yRange = grid.getMinMaxYForRange(null);
        if (xRange == null || yRange == null) {
            return new Grid(new String[0][0], null, null, topoSort);
        }
        String[][] retval = new String[xRange.max - xRange.min + 1][yRange.max - yRange.min + 1];
        String refID = null;
        Point refPt = null;
        for (int x = xRange.min; x <= xRange.max; ++x) {
            for (int y = yRange.min; y <= yRange.max; ++y) {
                String nodeID = grid.getValue(x, y);
                if (nodesToPlace.contains(nodeID)) {
                    retval[x - xRange.min][y - yRange.min] = nodeID;
                    continue;
                }
                if (refID != null) continue;
                refID = nodeID;
                refPt = new Point(x - xRange.min, y - yRange.min);
            }
        }
        Grid retvalGrid = new Grid(retval, refID, refPt, topoSort);
        if (options.doCrossingReduction) {
            this.minimizeCrossingsInGrid(retvalGrid, allLinks);
        }
        return retvalGrid;
    }

    private Set placeMotifInPattern(DialogBuiltMotif dbm, PatternGrid grid, Set placed, Set toPlace, Map columnsForNodes) {
        Object pp;
        DialogBuiltMotif.Placement pInfo = dbm.getPlacementInfo(columnsForNodes, placed, toPlace, grid);
        if (pInfo == null) {
            return new HashSet();
        }
        if (pInfo.suggestedRow == null) {
            pp = new PatternPlacerMinimizeHeight(grid, pInfo.pattern, pInfo.leftColumn);
            ((PatternPlacerMinimizeHeight)pp).placePattern();
        } else {
            pp = new PatternPlacerVerticalFit(grid, pInfo.pattern, pInfo.suggestedRow, pInfo.leftColumn);
            ((PatternPlacerVerticalFit)pp).placePattern();
        }
        Set newlyPlaced = pInfo.pattern.getValues();
        Iterator npit = newlyPlaced.iterator();
        while (npit.hasNext()) {
            String nodeID = (String)npit.next();
            placed.add(nodeID);
        }
        return newlyPlaced;
    }

    private void recursivePlaceMotifInPattern(List motifList, PatternGrid grid, Set toPlace, Map columnsForNodes) {
        HashSet placed = new HashSet();
        int mSize = motifList.size();
        if (mSize == 0) {
            return;
        }
        ArrayList workingList = new ArrayList(motifList);
        while (!workingList.isEmpty()) {
            DialogBuiltMotif dbm = (DialogBuiltMotif)workingList.remove(0);
            this.recursivePlaceMotifInPatternCore(dbm, placed, workingList, grid, toPlace, columnsForNodes);
        }
    }

    private void recursivePlaceMotifInPatternCore(DialogBuiltMotif dbm, Set placed, List motifList, PatternGrid grid, Set toPlace, Map columnsForNodes) {
        Set newlyPlaced = this.placeMotifInPattern(dbm, grid, placed, toPlace, columnsForNodes);
        Iterator npit = newlyPlaced.iterator();
        while (npit.hasNext()) {
            String nodeID = (String)npit.next();
            int index = 0;
            while (index < motifList.size()) {
                dbm = (DialogBuiltMotif)motifList.get(index);
                if (dbm.getSourceId().equals(nodeID)) {
                    motifList.remove(index);
                    this.recursivePlaceMotifInPatternCore(dbm, placed, motifList, grid, toPlace, columnsForNodes);
                    continue;
                }
                ++index;
            }
        }
    }

    private Map squashSort(Map columnsForNodes, int maxRows) {
        Integer maxColumn = new Integer(Integer.MIN_VALUE);
        HashMap<Integer, TreeSet<String>> invert = new HashMap<Integer, TreeSet<String>>();
        Iterator cfnit = columnsForNodes.keySet().iterator();
        while (cfnit.hasNext()) {
            String nodeID = (String)cfnit.next();
            Integer col = (Integer)columnsForNodes.get(nodeID);
            TreeSet<String> nodes = (TreeSet<String>)invert.get(col);
            if (nodes == null) {
                nodes = new TreeSet<String>();
                invert.put(col, nodes);
            }
            nodes.add(nodeID);
            if (col.compareTo(maxColumn) <= 0) continue;
            maxColumn = col;
        }
        int max = maxColumn;
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        int newCol = 0;
        for (int i = 0; i <= max; ++i) {
            Integer currCol = new Integer(i);
            TreeSet nodes = (TreeSet)invert.get(currCol);
            if (nodes == null) {
                ++newCol;
                continue;
            }
            int size = nodes.size();
            int numCols = (int)Math.ceil((double)size / (double)maxRows);
            int numPerCol = (int)Math.round((double)size / (double)numCols);
            int currNodeIndex = 0;
            Iterator nit = nodes.iterator();
            while (nit.hasNext()) {
                String node = (String)nit.next();
                retval.put(node, new Integer(newCol));
                if (++currNodeIndex % numPerCol != 0) continue;
                ++newCol;
            }
        }
        return retval;
    }

    private Map layerAssignment(Set linksWithFeedback, Map topoSort, int max, int method) {
        Set<SimpleLink> links = new HashSet();
        Iterator lit = linksWithFeedback.iterator();
        while (lit.hasNext()) {
            SimpleLink slink = (SimpleLink)lit.next();
            String src = slink.getSrc();
            String trg = slink.getTrg();
            Integer srcLayer = (Integer)topoSort.get(src);
            Integer trgLayer = (Integer)topoSort.get(trg);
            if (srcLayer >= trgLayer) continue;
            links.add(new SimpleLink(src, trg));
        }
        TransReducer tr = new TransReducer();
        links = tr.reduceGraph(links);
        LayerAssignment la = new LayerAssignment();
        return la.assignLayers(topoSort, links, max, method == 0);
    }

    public int buildBus(String srcID, String[] positions, Dimension dims, Genome genome, Layout layout, int lastColor, Set linkSet, FontRenderContext frc, int layoutMode, Layout colorRef) {
        int myPos = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i].equals(srcID)) continue;
            myPos = i;
            break;
        }
        if (myPos == -1) {
            throw new IllegalStateException();
        }
        Grid grid = new Grid(positions, dims, layoutMode);
        return this.buildBusGuts(srcID, grid, myPos, dims, genome, layout, lastColor, linkSet, frc, layoutMode, colorRef);
    }

    public int buildBus(String srcID, Grid grid, Dimension dims, Genome genome, Layout layout, int lastColor, Set linkSet, FontRenderContext frc, int layoutMode, Layout colorRef) {
        int myPos = grid.findPosition(srcID);
        return this.buildBusGuts(srcID, grid, myPos, dims, genome, layout, lastColor, linkSet, frc, layoutMode, colorRef);
    }

    private int buildBusGuts(String srcID, Grid grid, int myPos, Dimension dims, Genome genome, Layout layout, int lastColor, Set linkSet, FontRenderContext frc, int layoutMode, Layout colorRef) {
        Grid.GridBounds gridBounds;
        if (this.tracker_ == null) {
            this.tracker_ = new Grid.SlotTracker(grid);
        }
        if ((gridBounds = grid.buildBounds(genome, layout, srcID, myPos, linkSet)).noTargets()) {
            return -1;
        }
        String targLink = null;
        HashMap splitPoints = new HashMap();
        Grid.RowData minRD = gridBounds.getMinRowData();
        boolean didMinRow = false;
        boolean didMaxRow = false;
        if (minRD.rowNum <= gridBounds.srcRow) {
            targLink = grid.splitLinksUp(minRD, -1, gridBounds.srcRow, genome, layout, splitPoints, frc, gridBounds.srcCol, this.tracker_, gridBounds);
            didMinRow = true;
        }
        Grid.RowData maxRD = gridBounds.getMaxRowData();
        if (maxRD.rowNum > gridBounds.srcRow) {
            targLink = grid.splitLinksUp(maxRD, 1, gridBounds.srcRow, genome, layout, splitPoints, frc, gridBounds.srcCol, this.tracker_, gridBounds);
            didMaxRow = true;
        }
        if (targLink == null) {
            throw new IllegalStateException();
        }
        int minRow = didMinRow ? minRD.rowNum + 1 : minRD.rowNum;
        int maxRow = didMaxRow ? maxRD.rowNum - 1 : maxRD.rowNum;
        for (int i = minRow; i <= maxRow; ++i) {
            Grid.RowData rd = gridBounds.getRowData(i);
            if (rd == null) continue;
            grid.reattachMiddleLinks(splitPoints, rd, genome, layout, frc, i, gridBounds.srcRow, grid.getRowSpace(), this.tracker_);
        }
        lastColor = this.changeColors(targLink, genome, layout, lastColor, colorRef);
        this.positionRootSegment(targLink, genome, layout, gridBounds.srcCol, this.tracker_, frc);
        return lastColor;
    }

    public Point2D placePoint(int i, String[] positions, Point2D center, Dimension dims, int layoutMode) {
        Grid grid = new Grid(positions, dims, layoutMode);
        return this.placePoint(i, grid, center, dims);
    }

    public Point2D placePoint(int i, Grid grid, Point2D center, Dimension dims) {
        Grid.RowAndColumn cAndR = grid.getRowAndColumn(i);
        int col = cAndR.col;
        int row = cAndR.row;
        Point2D.Double loc = new Point2D.Double();
        double x = center.getX() - (double)dims.height / 2.0 + grid.getColSpace() * (double)col;
        double y = center.getY() - (double)dims.width / 2.0 + grid.getRowSpace() * (double)(row + 2);
        UiUtil.forceToGrid(x, y, loc, 10.0);
        return loc;
    }

    public Point2D placePointMultiPass(int i, Grid grid, Point2D corner) {
        Grid.RowAndColumn cAndR = grid.getRowAndColumn(i);
        int col = cAndR.col;
        int row = cAndR.row;
        Point2D.Double loc = new Point2D.Double();
        double x = corner.getX() + grid.getColSpace() * (double)col;
        double y = corner.getY() + grid.getRowSpace() * (double)row;
        UiUtil.forceToGrid(x, y, loc, 10.0);
        return loc;
    }

    private boolean newBlockToRight(Dimension oldBlock, Dimension newBlock) {
        int rightHeight = oldBlock.height > newBlock.height ? oldBlock.height : newBlock.height;
        int rightWidth = oldBlock.width + newBlock.width;
        int bottomHeight = oldBlock.height + newBlock.height;
        int bottomWidth = oldBlock.width > newBlock.width ? oldBlock.width : newBlock.width;
        double aspectRight = (double)rightWidth / (double)rightHeight;
        double aspectBot = (double)bottomWidth / (double)bottomHeight;
        double botBottom = 1.0 / aspectBot * 1.3333333333333333;
        double botDiff = Math.abs(botBottom - 1.0);
        double rightRight = aspectRight * 1.3333333333333333;
        double rightDiff = Math.abs(rightRight - 1.3333333333333333);
        return rightDiff < botDiff;
    }

    private void positionRootSegment(String linkID, Genome genome, Layout lo, int colNum, Grid.SlotTracker tracker, FontRenderContext frc) {
        Linkage link = genome.getLinkage(linkID);
        BusProperties lp = lo.getLinkProperties(linkID);
        String source = link.getSource();
        NodeProperties np = lo.getNodeProperties(source);
        Point2D loc = np.getLocation();
        BusProperties bp = lp;
        LinkSegment rootSeg = bp.getRootSegment();
        Point2D start = rootSeg.getStart();
        Vector2D colDelt = new Vector2D(10.0, 0.0);
        int slotNum = tracker.getColSlotForSource(colNum, source);
        colDelt.scale((double)slotNum + 2.0);
        Node node = genome.getNode(source);
        Vector2D lpo = np.getRenderer().getLaunchPadOffset(link.getLaunchPad(), node, lo, frc);
        Point2D newPos = lpo.add(colDelt.add(loc));
        UiUtil.forceToGrid(newPos.getX(), newPos.getY(), newPos, 10.0);
        LinkSegmentID[] segIDs = new LinkSegmentID[]{LinkSegmentID.buildIDForSegment(rootSeg.getID())};
        segIDs[0].tagIDWithEndpoint("S");
        double dx = newPos.getX() - start.getX();
        double dy = newPos.getY() - start.getY();
        dx = (double)Math.round(dx / 10.0) * 10.0;
        dy = (double)Math.round(dy / 10.0) * 10.0;
        lo.moveBusLink(segIDs, dx, dy, start, bp);
    }

    private int changeColors(String linkID, Genome genome, Layout lo, int lastColor, Layout colorRef) {
        Linkage link = genome.getLinkage(linkID);
        BusProperties lp = lo.getLinkProperties(linkID);
        String src = link.getSource();
        Database db = Database.getDB();
        NodeProperties np = lo.getNodeProperties(src);
        if (colorRef == null) {
            if (lastColor >= db.getNumColors()) {
                lastColor = 0;
            }
            String colTag = db.getGeneColor(lastColor);
            np.setColor(colTag);
            lp.setColor(colTag);
        } else {
            NodeProperties tnp = lo.getNodeProperties(link.getTarget());
            NodeProperties refNps = colorRef.getNodeProperties(src);
            NodeProperties refNpt = colorRef.getNodeProperties(link.getTarget());
            BusProperties refLp = colorRef.getLinkProperties(linkID);
            np.setColor(refNps.getColorName());
            tnp.setColor(refNpt.getColorName());
            lp.setColor(refLp.getColorName());
        }
        return ++lastColor;
    }

    private void minimizeCrossingsInGrid(Grid grid, Set links) {
        int cols = grid.getNumCols();
        int rows = grid.getNumRows();
        if (cols <= 1) {
            return;
        }
        Map lastColumn = this.buildAugmentedPseudoColumn(grid, 0);
        CrossingReducer cr = new CrossingReducer();
        for (int i = 1; i < cols; ++i) {
            HashMap<String, Integer> currColumn = new HashMap<String, Integer>();
            for (int j = 0; j < rows; ++j) {
                String node = grid.getCellValue(j, i);
                if (node == null) continue;
                currColumn.put(node, new Integer(j));
            }
            Map permuted = cr.reduceCrossings(lastColumn, currColumn, links);
            Iterator pit = permuted.keySet().iterator();
            while (pit.hasNext()) {
                String node = (String)pit.next();
                Integer row = (Integer)permuted.get(node);
                grid.setCellValue(row, i, node);
            }
            lastColumn = this.buildAugmentedPseudoColumn(grid, i);
        }
    }

    private Grid normalizeGrid(Grid grid) {
        int cols = grid.getNumCols();
        int rows = grid.getNumRows();
        HashMap<Integer, Integer> numsPerCol = new HashMap<Integer, Integer>();
        int maxPerCol = 0;
        for (int i = 0; i < cols; ++i) {
            int numPerCol = 0;
            for (int j = 0; j < rows; ++j) {
                String node = grid.getCellValue(j, i);
                if (node == null) continue;
                ++numPerCol;
            }
            numsPerCol.put(new Integer(i), new Integer(numPerCol));
            if (numPerCol <= maxPerCol) continue;
            maxPerCol = numPerCol;
        }
        String[][] vals = new String[cols][maxPerCol];
        String refID = grid.getReferenceID();
        Point refPt = grid.getReferencePoint();
        for (int i = 0; i < cols; ++i) {
            int numPerCol = (Integer)numsPerCol.get(new Integer(i));
            int currRow = (maxPerCol - numPerCol) / 2;
            for (int j = 0; j < rows; ++j) {
                String nodeID = grid.getCellValue(j, i);
                if (nodeID == null) continue;
                vals[i][currRow] = nodeID;
                if (nodeID.equals(refID)) {
                    refPt = new Point(refPt.x, refPt.y + (currRow - j));
                }
                ++currRow;
            }
        }
        return new Grid(vals, refID, refPt, grid.getTopoSort());
    }

    private Map buildAugmentedPseudoColumn(Grid grid, int column) {
        int rows = grid.getNumRows();
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j <= column; ++j) {
                String node = grid.getCellValue(i, j);
                if (node == null) continue;
                retval.put(node, new Integer(count++));
            }
        }
        return retval;
    }

    private class TargetRank
    implements Comparable {
        String nodeID;
        int targetCount;
        List targets;

        TargetRank(String nodeID, int targetCount, List targets) {
            this.nodeID = nodeID;
            this.targetCount = targetCount;
            this.targets = targets;
        }

        public int compareTo(Object o) {
            TargetRank other = (TargetRank)o;
            int diff = this.targetCount - other.targetCount;
            if (diff != 0) {
                return diff;
            }
            return this.nodeID.compareTo(other.nodeID);
        }
    }
}

