/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class RenderObjectCache {
    private TreeMap cache_ = new TreeMap();

    public void clear() {
        this.cache_.clear();
    }

    public void addObject(ModalShape ms, Integer majorLayer, Integer minorLayer) {
        ArrayList<ModalShape> perMinor;
        TreeMap<Integer, ArrayList<ModalShape>> perMajor = (TreeMap<Integer, ArrayList<ModalShape>>)this.cache_.get(majorLayer);
        if (perMajor == null) {
            perMajor = new TreeMap<Integer, ArrayList<ModalShape>>();
            this.cache_.put(majorLayer, perMajor);
        }
        if ((perMinor = (ArrayList<ModalShape>)perMajor.get(minorLayer)) == null) {
            perMinor = new ArrayList<ModalShape>();
            perMajor.put(minorLayer, perMinor);
        }
        perMinor.add(ms);
    }

    public void render(Graphics2D g2) {
        Iterator vit = this.cache_.values().iterator();
        while (vit.hasNext()) {
            TreeMap perMajor = (TreeMap)vit.next();
            Iterator mit = perMajor.values().iterator();
            while (mit.hasNext()) {
                ArrayList perMinor = (ArrayList)mit.next();
                int size = perMinor.size();
                for (int i = 0; i < size; ++i) {
                    ModalShape ms = (ModalShape)perMinor.get(i);
                    ms.render(g2);
                }
            }
        }
    }

    public void renderALayer(Graphics2D g2, Integer majorLayer) {
        int majVal = majorLayer;
        Iterator kit = this.cache_.keySet().iterator();
        while (kit.hasNext()) {
            Integer majKey = (Integer)kit.next();
            TreeMap perMajor = (TreeMap)this.cache_.get(majKey);
            if (majKey != majVal) continue;
            Iterator kmit = perMajor.keySet().iterator();
            while (kmit.hasNext()) {
                Integer minKey = (Integer)kmit.next();
                ArrayList perMinor = (ArrayList)perMajor.get(minKey);
                int size = perMinor.size();
                for (int i = 0; i < size; ++i) {
                    ModalShape ms = (ModalShape)perMinor.get(i);
                    ms.render(g2);
                }
            }
        }
    }

    public static class ModalShape {
        public static final int DRAW = 0;
        public static final int FILL = 1;
        private boolean isText_;
        private int mode_;
        private Color color_;
        private BasicStroke stroke_;
        private Shape shape_;
        private Font font_;
        private String text_;
        private AffineTransform trans_;
        private float txtX_;
        private float txtY_;

        public ModalShape(int mode, Color color, BasicStroke stroke, Shape shape) {
            this.isText_ = false;
            this.mode_ = mode;
            this.color_ = color;
            this.stroke_ = stroke;
            this.shape_ = shape;
        }

        public ModalShape(String text, Color color, Font font, AffineTransform trans, float txtX, float txtY) {
            this.isText_ = true;
            this.text_ = text;
            this.color_ = color;
            this.font_ = font;
            this.trans_ = trans;
            this.txtX_ = txtX;
            this.txtY_ = txtY;
        }

        public void render(Graphics2D g2) {
            g2.setPaint(this.color_);
            if (this.isText_) {
                this.renderText(g2);
            } else {
                this.renderShape(g2);
            }
        }

        private void renderText(Graphics2D g2) {
            g2.setFont(this.font_);
            AffineTransform saveTrans = g2.getTransform();
            g2.transform(this.trans_);
            g2.drawString(this.text_, this.txtX_, this.txtY_);
            g2.setTransform(saveTrans);
        }

        private void renderShape(Graphics2D g2) {
            g2.setStroke(this.stroke_);
            switch (this.mode_) {
                case 0: {
                    g2.draw(this.shape_);
                    break;
                }
                case 1: {
                    g2.fill(this.shape_);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

