/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;

public class ResolvedDrawStyle
implements Cloneable {
    private static float[] inactiveHSV_;
    private static final Color inactiveCol_;
    public static final int REG_THICK = 3;
    public static final int THIN_THICK = 2;
    public static final int THICK_THICK = 7;
    public static final int REG_THICK_MOD = 5;
    public static final int THIN_THICK_MOD = 3;
    public static final int THICK_THICK_MOD = 9;
    private static final float DOT_ = 4.0f;
    private static final float DOT_SP_ = 6.0f;
    private static final float DASH_ = 10.0f;
    private static final float DASH_SP_ = 6.0f;
    private int style_;
    private Color calculatedColor_;
    private int thickness_;

    public ResolvedDrawStyle(SuggestedDrawStyle currStyle, boolean colorMatters, boolean forModules) {
        this.calculatedColor_ = !colorMatters ? Color.LIGHT_GRAY : currStyle.getColor();
        this.style_ = currStyle.getLineStyle();
        this.thickness_ = SuggestedDrawStyle.trueThick(currStyle.getThickness(), forModules);
    }

    public ResolvedDrawStyle(SuggestedDrawStyle currStyle, boolean colorMatters, int maxThick, int maxStyle, Color newColor, boolean forModules) {
        this(currStyle, colorMatters, forModules);
        if (maxThick != -4) {
            this.thickness_ = SuggestedDrawStyle.trueThick(maxThick, forModules);
        }
        if (maxStyle != 0) {
            this.style_ = maxStyle;
        }
        if (colorMatters && newColor != null) {
            this.calculatedColor_ = newColor;
        }
    }

    public Object clone() {
        try {
            ResolvedDrawStyle retval = (ResolvedDrawStyle)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return this.calculatedColor_.hashCode() + this.style_ * 10 + this.thickness_;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ResolvedDrawStyle)) {
            return false;
        }
        ResolvedDrawStyle otherDS = (ResolvedDrawStyle)other;
        if (this.thickness_ != otherDS.thickness_) {
            return false;
        }
        if (this.style_ != otherDS.style_) {
            return false;
        }
        return this.calculatedColor_.equals(otherDS.calculatedColor_);
    }

    public Color getColor() {
        return this.calculatedColor_;
    }

    public void modulateColor(double level) {
        float[] colHSB = new float[3];
        Color.RGBtoHSB(this.calculatedColor_.getRed(), this.calculatedColor_.getGreen(), this.calculatedColor_.getBlue(), colHSB);
        colHSB[1] = inactiveHSV_[1] + (float)level * (colHSB[1] - inactiveHSV_[1]);
        colHSB[2] = inactiveHSV_[2] + (float)level * (colHSB[2] - inactiveHSV_[2]);
        this.calculatedColor_ = Color.getHSBColor(colHSB[0], colHSB[1], colHSB[2]);
    }

    public void modulateThickness(double level) {
        double modThick = 1.0 + level * ((double)this.thickness_ - 1.0);
        this.thickness_ = (int)Math.round(modThick);
    }

    public void masterUpdate(SuggestedDrawStyle masterDrawStyle, boolean isActive, boolean isGhosted, boolean forModules) {
        int masterStyle;
        int masterThick = masterDrawStyle.getThickness();
        if (masterThick != -4) {
            this.thickness_ = SuggestedDrawStyle.trueThick(masterThick, forModules);
        }
        if ((masterStyle = masterDrawStyle.getLineStyle()) != 0) {
            this.style_ = masterStyle;
        }
        if (!isActive || isGhosted) {
            return;
        }
        Color masterColor = masterDrawStyle.getColor();
        if (masterColor != null) {
            this.calculatedColor_ = masterColor;
        }
    }

    public int getLineStyle() {
        return this.style_;
    }

    public int getThickness() {
        return this.thickness_;
    }

    public BasicStroke calcStroke() {
        float[] patternArray;
        int butt = 0;
        int join = 1;
        float miter = 10.0f;
        if (this.style_ == 0 || this.style_ == 1) {
            patternArray = null;
        } else if (this.style_ == 2) {
            patternArray = new float[]{10.0f, 6.0f};
        } else if (this.style_ == 3) {
            patternArray = new float[]{4.0f, 6.0f};
        } else {
            throw new IllegalStateException();
        }
        if (patternArray == null) {
            return new BasicStroke(this.thickness_, butt, join);
        }
        return new BasicStroke(this.thickness_, butt, join, miter, patternArray, 0.0f);
    }

    static {
        inactiveCol_ = Color.LIGHT_GRAY;
        inactiveHSV_ = new float[3];
        Color.RGBtoHSB(inactiveCol_.getRed(), inactiveCol_.getGreen(), inactiveCol_.getBlue(), inactiveHSV_);
    }
}

