/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.SelectionChangeCmd;
import org.systemsbiology.biotapestry.cmd.ZoomTarget;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeEvent;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.GeneralChangeListener;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeListener;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.gaggle.SelectionSupport;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.OverlayDisplayChange;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.CursorManager;
import org.systemsbiology.biotapestry.ui.FreezeDriedOverlayOracle;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.ImageExporter;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.IntersectionChooser;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.PopControl;
import org.systemsbiology.biotapestry.ui.ZoomTargetSupport;
import org.systemsbiology.biotapestry.ui.dialogs.NodeSearchDialog;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.Vector2D;

public class SUPanel
extends JPanel
implements LayoutChangeListener,
ModelChangeListener,
GeneralChangeListener,
Printable,
ZoomTarget,
OverlayStateOracle {
    public static final int NUDGE_UP = 0;
    public static final int NUDGE_DOWN = 1;
    public static final int NUDGE_LEFT = 2;
    public static final int NUDGE_RIGHT = 3;
    public static final int NO_SWAP = 0;
    public static final int TARGET_SWAP = 1;
    public static final int SOURCE_SWAP = 2;
    public static final int EITHER_SWAP = 3;
    public static final int CANCEL_ADDS_ALL_MODES = 0;
    public static final int CANCEL_ADDS_SKIP_PULLDOWNS = 1;
    public static final int CANCEL_ADDS_SKIP_MODULE_ADDS = 2;
    public static final int ENABLE_NONE = 0;
    public static final int ENABLE_PULLDOWNS = 1;
    public static final int ENABLE_MODULE_ADDS = 2;
    public static final int NO_MODE = 0;
    public static final int ADD_GENE = 1;
    public static final int DRAW_NET_MODULE = 2;
    public static final int DRAW_NET_MODULE_LINK = 3;
    public static final int ADD_TO_NET_MODULE = 4;
    public static final int DRAW_GROUP = 5;
    public static final int MOVE_GROUP = 6;
    public static final int MOVE_NET_MODULE = 7;
    public static final int ADD_LINK = 8;
    public static final int ADD_NODE = 9;
    public static final int RELOCATE = 10;
    public static final int CHANGE_SOURCE_NODE = 11;
    public static final int CHANGE_TARGET_NODE = 12;
    public static final int ADD_NOTE = 13;
    public static final int ADD_SUB_GROUP = 14;
    public static final int RELOCATE_TARGET = 15;
    public static final int RELOCATE_SOURCE = 16;
    public static final int SWAP_PADS = 17;
    public static final int ADD_EXTRA_PROXY_NODE = 18;
    public static final int PULL_DOWN = 19;
    public static final int PULL_DOWN_ROOT_INSTANCE = 20;
    public static final int RELOCATE_NET_MOD_LINK = 21;
    public static final int RELOCATE_NET_MOD_TARGET = 22;
    public static final int RELOCATE_NET_MOD_SOURCE = 23;
    public static final int CHANGE_GROUP_MEMBERSHIP = 24;
    private static final int NUM_MODES_ = 25;
    private CommonView cView_;
    private JScrollPane myScrollPane_;
    private Point lastPress_ = null;
    private Point lastView_ = null;
    private Point lastAbs_ = null;
    private boolean dragSelect_ = false;
    private boolean lastShifted_ = false;
    private boolean lastCtrl_ = false;
    private Layout dragLayout_ = null;
    private Layout multiMoveLayout_ = null;
    private ArrayList dragFloater_;
    private GenomePresentation.RunningMove rmov_;
    private GenomePresentation myGenomePre_;
    private JFrame parent_;
    private String layout_ = null;
    private String genomeKey_ = null;
    private boolean showingNetModuleComponents_ = false;
    private String menuDrivenShowComponentModule_ = null;
    private JDialog pullFrame_;
    private boolean pushedShowBubbles_ = false;
    private boolean showBubbles_ = false;
    private boolean accept_;
    private boolean readOnly_;
    private String currentOverlay_;
    private NetModuleFree.CurrentSettings currOvrSettings_;
    private TaggedSet currentNetMods_;
    private TaggedSet revealed_;
    private UndoManager undom_;
    private PopControl popCtrl_;
    private MouseMotionHandler motionHandle_;
    private CursorManager cursorMgr_;
    private TextBoxManager textMgr_;
    private ZoomTargetSupport zoomer_;
    private int currentMode_;
    private HashMap clickHandlers_;
    private BufferedImage bim_;
    private JMenu currSelMenu_;
    private static final int REJECT_ = 0;
    private static final int OK_ = 1;
    private static final int SELECTED_ = 0;
    private static final int CANCELLED_ = 1;
    private static final int UNSELECTED_ = 2;
    private static final int ERROR_ = 3;
    private static final int PRESENT_ = 4;
    private static final int DELAYED_ = 5;

    public SUPanel(JFrame parent, CommonView cView, UndoManager undo, boolean readOnly) {
        Database db = Database.getDB();
        this.myGenomePre_ = new GenomePresentation(0.38, readOnly, undo, true);
        this.zoomer_ = new ZoomTargetSupport(this.myGenomePre_, this, db, db, db);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.readOnly_ = readOnly;
        this.cView_ = cView;
        this.popCtrl_ = new PopControl(parent, this.cView_, this, undo, this.myGenomePre_, readOnly);
        this.addMouseListener(new MouseHandler());
        this.motionHandle_ = new MouseMotionHandler();
        this.addMouseMotionListener(this.motionHandle_);
        EventManager em = EventManager.getManager();
        em.addLayoutChangeListener(this);
        em.addGeneralChangeListener(this);
        em.addModelChangeListener(this);
        this.setBackground(new Color(240, 240, 240));
        this.undom_ = undo;
        this.parent_ = parent;
        this.textMgr_ = new TextBoxManager();
        this.accept_ = true;
        this.dragFloater_ = new ArrayList();
        this.cursorMgr_ = new CursorManager(this, parent == null);
        this.currentNetMods_ = new TaggedSet();
        this.revealed_ = new TaggedSet();
        this.clickHandlers_ = this.initHandlers();
        this.currentMode_ = 0;
        ResourceManager rMan = ResourceManager.getManager();
        this.currSelMenu_ = new JMenu(rMan.getString("command.selectedItemMenu"));
        this.currSelMenu_.setMnemonic(rMan.getChar("command.selectedItemMenuMnem"));
    }

    public void setCurrClipRect(Rectangle2D clipRect) {
        this.zoomer_.setCurrClipRect(clipRect);
    }

    public void incrementToNextSelection() {
        this.myGenomePre_.bumpNextSelection(this.genomeKey_);
    }

    public void decrementToPreviousSelection() {
        this.myGenomePre_.bumpPreviousSelection(this.genomeKey_);
    }

    public GenomePresentation getPresentation() {
        return this.myGenomePre_;
    }

    public JMenu getSelectedMenu() {
        return this.currSelMenu_;
    }

    public void stockSelectedMenu() {
        String genomeID = this.getGenome();
        if (this.hasASelection() && genomeID != null) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeID);
            String loKey = this.getLayoutKey();
            Layout lo = db.getLayout(loKey);
            Map selmap = this.myGenomePre_.getSelections();
            if (selmap.size() == 1) {
                Intersection intersect = (Intersection)selmap.values().iterator().next();
                boolean canUse = this.popCtrl_.stockMenu(this.currSelMenu_, genome, lo, intersect);
                this.currSelMenu_.setEnabled(canUse);
            } else {
                boolean canUse = this.popCtrl_.stockMultiSelMenu(this.currSelMenu_, genome, lo, selmap);
                this.currSelMenu_.setEnabled(canUse);
            }
        } else {
            this.currSelMenu_.setEnabled(false);
        }
    }

    public boolean linksAreHidden() {
        Database db = Database.getDB();
        Layout layout = db.getLayout(this.layout_);
        return this.myGenomePre_.linksAreHidden(layout, this);
    }

    public CursorManager getCursorMgr() {
        return this.cursorMgr_;
    }

    public TextBoxManager getTextBoxManager() {
        return this.textMgr_;
    }

    public void giveErrorFeedback() {
        this.cursorMgr_.signalError();
        Toolkit.getDefaultToolkit().beep();
    }

    public void acceptKeystrokes(boolean accept) {
        this.accept_ = accept;
    }

    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            this.drawingGuts(g, false, false, null, this.showBubbles_, true, null);
            this.textMgr_.refresh();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayPaintException(ex);
        }
    }

    public void setScrollPane(JScrollPane jsp) {
        this.myScrollPane_ = jsp;
    }

    public ExternalSelectionChangeEvent getExternalSelectionEvent() {
        return this.myGenomePre_.selectionsForExternalEvents(this.genomeKey_, this.layout_);
    }

    public String getSingleNodeSelection() {
        return this.myGenomePre_.getSingleNodeSelection(this.genomeKey_);
    }

    public void selectIntersectionList(List intersections) {
        this.myGenomePre_.selectIntersectionList(intersections, this.genomeKey_, this.layout_);
        this.repaint();
    }

    public boolean doNetworkSearch() {
        Genome genome = Database.getDB().getGenome(this.genomeKey_);
        String selectedID = this.myGenomePre_.getSingleNodeSelection(this.genomeKey_);
        NodeSearchDialog nsd = new NodeSearchDialog(this.parent_, genome, this.layout_, this.myGenomePre_, this.getFontRenderContext(), selectedID, this.currentOverlay_, this.linksAreHidden(), this.undom_);
        nsd.setVisible(true);
        this.repaint();
        return nsd.itemWasFound();
    }

    public void selectFromGaggle(SelectionSupport.SelectionsForSpecies sfs) {
        HashSet<String> found = new HashSet<String>();
        Genome genome = Database.getDB().getGenome(this.genomeKey_);
        Iterator sit = sfs.selections.iterator();
        while (sit.hasNext()) {
            String nextSel = (String)sit.next();
            Iterator git = genome.getGeneIterator();
            while (git.hasNext()) {
                Gene gene = (Gene)git.next();
                if (!DataUtil.keysEqual(nextSel, gene.getName())) continue;
                found.add(gene.getID());
            }
            Iterator nit = genome.getNodeIterator();
            while (nit.hasNext()) {
                Node node = (Node)nit.next();
                if (!DataUtil.keysEqual(nextSel, node.getName())) continue;
                found.add(node.getID());
            }
        }
        if (!found.isEmpty()) {
            this.myGenomePre_.appendToSelectNodes(found, genome.getID(), this.layout_);
            this.repaint();
        }
    }

    public void clearFromGaggle() {
        Genome genome = Database.getDB().getGenome(this.genomeKey_);
        UndoSupport support = new UndoSupport(this.undom_, "undo.selection");
        this.myGenomePre_.clearSelections(genome.getID(), this.layout_, support);
        support.finish();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.zoomer_.getPreferredSize();
    }

    public Dimension getCanvasSize() {
        Rectangle rect = Database.getDB().getWorkspace().getWorkspace();
        return new Dimension(rect.width, rect.height);
    }

    public Rectangle getWorkspaceBounds() {
        return this.zoomer_.getWorkspaceBounds();
    }

    public void setWorkspace(Rectangle rect, UndoSupport support) {
        Workspace ws;
        Database db = Database.getDB();
        DatabaseChange dc = db.setWorkspace(ws = new Workspace(rect));
        if (dc != null) {
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
            support.addEvent(new LayoutChangeEvent(this.layout_, 1));
            support.finish();
        }
    }

    public void setWorkspaceToModelBounds(UndoSupport support) {
        Rectangle allBounds = this.getAllModelBounds();
        Workspace boundWs = Workspace.setToModelBounds(allBounds);
        Database db = Database.getDB();
        DatabaseChange dc = db.setWorkspace(boundWs);
        if (dc != null) {
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
            support.addEvent(new LayoutChangeEvent(this.layout_, 1));
        }
    }

    public boolean modelIsOutsideWorkspaceBounds() {
        Database db = Database.getDB();
        return !db.getWorkspace().contains(this.getAllModelBounds());
    }

    public double getCanvasAspectRatio() {
        return 1.3333333333333333;
    }

    public Point2D getCanvasCenter() {
        Rectangle rect = Database.getDB().getWorkspace().getWorkspace();
        return new Point2D.Double(rect.getWidth() / 2.0, rect.getHeight() / 2.0);
    }

    public Point getCenterPoint() {
        return this.zoomer_.getCenterPoint();
    }

    public Point2D getRawCenterPoint() {
        return this.zoomer_.getRawCenterPoint();
    }

    public void setRawCenterPoint(Point2D rawPt, UndoSupport support, boolean closeIt) {
        this.zoomer_.setRawCenterPoint(rawPt, support, closeIt);
    }

    public void setRawOrigin(Point2D rawPt, UndoSupport support, boolean closeIt) {
        this.zoomer_.setRawOrigin(rawPt, support, closeIt);
    }

    public void fixCenterPoint(boolean doComplete, UndoSupport support, boolean closeIt) {
        this.zoomer_.fixCenterPoint(doComplete, support, closeIt);
    }

    public Dimension getBasicSize(boolean doComplete, boolean doBuffer, int moduleHandling) {
        return this.zoomer_.getBasicSize(doComplete, doBuffer, moduleHandling);
    }

    public Rectangle getBasicBounds(String genomeKey, String layout, boolean doComplete, boolean doBuffer, int moduleHandling) {
        if (moduleHandling == 1) {
            throw new IllegalArgumentException();
        }
        boolean doModules = false;
        Map allKeys = null;
        if (moduleHandling == 2) {
            doModules = true;
            allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        }
        return this.myGenomePre_.getRequiredSize(genomeKey, layout, doComplete, doBuffer, doModules, doModules, null, null, allKeys);
    }

    public Rectangle getCurrentBasicBounds(boolean doComplete, boolean doBuffer, int moduleHandling) {
        return this.zoomer_.getCurrentBasicBounds(doComplete, doBuffer, moduleHandling);
    }

    public Rectangle getSelectedBounds() {
        return this.zoomer_.getSelectedBounds();
    }

    public boolean haveCurrentSelectionForBounds() {
        return this.zoomer_.haveCurrentSelectionForBounds();
    }

    public boolean haveMultipleSelectionsForBounds() {
        return this.zoomer_.haveMultipleSelectionsForBounds();
    }

    public Rectangle getCurrentSelectedBounds() {
        return this.zoomer_.getCurrentSelectedBounds();
    }

    public Rectangle getAllModelBounds() {
        return this.zoomer_.getAllModelBounds();
    }

    public Point pointToViewport(Point worldPoint) {
        return this.zoomer_.pointToViewport(worldPoint);
    }

    public Point2D viewToWorld(Point viewPoint) {
        return this.zoomer_.viewToWorld(viewPoint);
    }

    public void setGenomeForUndo(String key) {
        this.genomeKey_ = key;
        this.textMgr_.setMessageSource(this.genomeKey_, 0, true);
        NetOverlayController noc = MainCommands.getCmds().getOverlayController();
        noc.setForNewGenome(this.genomeKey_, null, null);
        this.zoomer_.setGenome(key);
    }

    public void setGenome(String key, UndoSupport support) {
        this.cancelAddMode();
        boolean updateModules = false;
        if (key == null || this.genomeKey_ != null && !this.genomeKey_.equals(key)) {
            this.myGenomePre_.clearSelections(this.genomeKey_, this.layout_, support);
            updateModules = true;
        }
        OverlayDisplayChange odc = null;
        NetOverlayController noc = MainCommands.getCmds().getOverlayController();
        if (updateModules || this.genomeKey_ == null && key != null || noc.hasPreloadForNextGenome(key)) {
            updateModules = true;
            odc = new OverlayDisplayChange();
            odc.oldGenomeID = this.genomeKey_;
            odc.oldOvrKey = this.currentOverlay_;
            odc.oldModKeys = (TaggedSet)this.currentNetMods_.clone();
            odc.oldRevealedKeys = (TaggedSet)this.revealed_.clone();
        }
        this.genomeKey_ = key;
        this.textMgr_.setMessageSource(this.genomeKey_, 0, true);
        if (updateModules) {
            noc.setForNewGenome(this.genomeKey_, support, odc);
        }
        this.zoomer_.setGenome(key);
    }

    public SelectionChangeCmd.Bundle setCurrentOverlay(String key, NetModuleFree.CurrentSettings settings, boolean forUndo) {
        NetOverlayProperties nop;
        this.currentOverlay_ = key;
        Database db = Database.getDB();
        Layout lo = db.getLayout(this.layout_);
        SelectionChangeCmd.Bundle bundle = null;
        if (this.currentOverlay_ != null && !forUndo && (nop = lo.getNetOverlayProperties(this.currentOverlay_)).hideLinks()) {
            bundle = this.dropLinkSelections(true);
        }
        this.currOvrSettings_ = settings;
        this.textMgr_.setMessageSource(this.currentOverlay_, 1, forUndo);
        this.zoomer_.setOverlay(key);
        return bundle;
    }

    public String getCurrentOverlay() {
        return this.currentOverlay_;
    }

    public void setCurrentNetModules(TaggedSet keys, boolean forUndo) {
        this.currentNetMods_ = new TaggedSet(keys);
        String currKey = this.currentNetMods_.set.size() == 1 ? (String)this.currentNetMods_.set.iterator().next() : null;
        this.textMgr_.setMessageSource(currKey, 2, forUndo);
        this.zoomer_.setCurrentNetModules(keys);
    }

    public void setRevealedModules(TaggedSet keys, boolean forUndo) {
        this.revealed_ = new TaggedSet(keys);
    }

    public TaggedSet getCurrentNetModules() {
        return new TaggedSet(this.currentNetMods_);
    }

    public NetModuleFree.CurrentSettings getCurrentOverlaySettings() {
        return this.currOvrSettings_;
    }

    public TaggedSet getRevealedModules() {
        return this.revealed_;
    }

    public boolean showingModuleComponents() {
        return this.showingNetModuleComponents_;
    }

    public String getGenome() {
        return this.genomeKey_;
    }

    public void selectAll() {
        NetOverlayProperties nop;
        Database db = Database.getDB();
        Layout lo = db.getLayout(this.layout_);
        if (this.currentOverlay_ != null && (nop = lo.getNetOverlayProperties(this.currentOverlay_)).hideLinks()) {
            this.myGenomePre_.selectAllNodes(this.genomeKey_, this.layout_);
            return;
        }
        this.myGenomePre_.selectAll(this.genomeKey_, this.layout_);
    }

    public void selectNone() {
        this.myGenomePre_.selectNone(this.genomeKey_, this.layout_);
    }

    public void dropNodeSelections(Integer type) {
        this.myGenomePre_.dropNodeSelections(this.genomeKey_, this.layout_, type);
    }

    public SelectionChangeCmd.Bundle dropLinkSelections(boolean recordBundle) {
        SelectionChangeCmd.Bundle bundle = recordBundle ? new SelectionChangeCmd.Bundle() : null;
        this.myGenomePre_.dropLinkSelections(this.genomeKey_, this.layout_, bundle);
        return bundle;
    }

    public void toggleTargetBubbles() {
        boolean bl = this.showBubbles_ = !this.showBubbles_;
        if (this.isShowBubbleMode(this.currentMode_)) {
            this.pushedShowBubbles_ = this.showBubbles_;
        }
    }

    public void toggleModuleComponents() {
        this.showingNetModuleComponents_ = !this.showingNetModuleComponents_;
    }

    public void forceShowingModuleComponents(String moduleID) {
        this.menuDrivenShowComponentModule_ = moduleID;
        this.repaint();
    }

    public boolean isShowBubbleMode(int mode) {
        return mode == 8 || mode == 3 || mode == 21 || mode == 23 || mode == 22 || mode == 11 || mode == 12 || mode == 10 || mode == 16 || mode == 15 || mode == 17;
    }

    public void setGraphLayout(String key) {
        this.layout_ = key;
        this.zoomer_.setGraphLayout(key);
    }

    public FontRenderContext getFontRenderContext() {
        return this.myGenomePre_.getFontRenderContext();
    }

    public boolean hasASelection() {
        return this.myGenomePre_.hasASelection();
    }

    public String getLayoutKey() {
        return this.layout_;
    }

    public void setZoomFactor(double zoom) {
        this.zoomer_.setZoomFactor(zoom);
    }

    public void setWideZoomFactor(double zoom, Dimension viewportDim) {
        this.zoomer_.setWideZoomFactor(zoom, viewportDim);
    }

    public void adjustWideZoomForSize(Dimension viewportDim) {
        this.zoomer_.adjustWideZoomForSize(viewportDim);
    }

    public double getWorkspaceZoom(Dimension viewportDim, double percent) {
        return this.zoomer_.getWorkspaceZoom(viewportDim, percent);
    }

    public double getZoomFactor() {
        return this.zoomer_.getZoomFactor();
    }

    public void propagateDown() {
        Map selections = this.myGenomePre_.getSelections();
        ArrayList toDown = new ArrayList(selections.values());
        if (toDown.size() > 0) {
            new AddCommands(this.parent_, this.undom_).propagateDown(this.genomeKey_, this.layout_, toDown, this.myGenomePre_.getFontRenderContext());
        }
    }

    public boolean isModal() {
        return this.currentMode_ != 0;
    }

    public void cancelAddMode() {
        this.cancelAddMode(0);
    }

    public void cancelAddMode(int which) {
        if (!this.accept_) {
            return;
        }
        this.textMgr_.clearCurrentMouseOver();
        this.textMgr_.clearMessageSource(3);
        if (this.isShowBubbleMode(this.currentMode_)) {
            this.showBubbles_ = this.pushedShowBubbles_;
        }
        Integer key = new Integer(this.currentMode_);
        ModeHandler handler = (ModeHandler)this.clickHandlers_.get(key);
        handler.cancelMode(null);
        this.currentMode_ = 0;
        if (this.pullFrame_ != null) {
            JDialog holdFrame = this.pullFrame_;
            this.pullFrame_ = null;
            holdFrame.setVisible(false);
            holdFrame.dispose();
        }
        this.myGenomePre_.setFloater(null);
        this.myGenomePre_.clearTargets();
        this.myGenomePre_.clearRootOverlays();
        this.cursorMgr_.showDefaultCursor();
        this.cView_.enableControls();
        this.cView_.cancelModals(which);
        this.repaint();
    }

    public Set getSelectedNodes() {
        Database db = Database.getDB();
        Genome genome = db.getGenome(this.genomeKey_);
        Map selmap = this.myGenomePre_.getSelections();
        HashSet<String> retval = new HashSet<String>();
        Iterator selKeys = selmap.keySet().iterator();
        while (selKeys.hasNext()) {
            String key = (String)selKeys.next();
            Node node = genome.getNode(key);
            if (node == null) continue;
            retval.add(key);
        }
        return retval;
    }

    public void deleteSelected() {
        if (!this.accept_) {
            return;
        }
        Database db = Database.getDB();
        Genome genome = db.getGenome(this.genomeKey_);
        Layout layout = db.getLayout(this.layout_);
        Map selmap = this.myGenomePre_.getSelections();
        FontRenderContext frc = this.myGenomePre_.getFontRenderContext();
        HashMap<String, Intersection> nodeInter = new HashMap<String, Intersection>();
        HashMap<String, Intersection> linkInter = new HashMap<String, Intersection>();
        LinkageFree rend = new LinkageFree();
        Iterator selKeys = selmap.keySet().iterator();
        while (selKeys.hasNext()) {
            Node node;
            String key = (String)selKeys.next();
            Intersection inter = (Intersection)selmap.get(key);
            Linkage link = genome.getLinkage(key);
            if (link != null) {
                if (inter.getSubID() == null) {
                    inter = rend.fullIntersection(genome, link, layout, frc, true);
                }
                linkInter.put(key, inter);
            }
            if ((node = genome.getNode(key)) == null) continue;
            nodeInter.put(key, inter);
        }
        if (nodeInter.isEmpty() && linkInter.isEmpty()) {
            return;
        }
        DeleteCommands dc = new DeleteCommands(this.parent_, this.undom_);
        dc.deleteWarningHelper(this.genomeKey_, this.parent_);
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        UndoSupport support = new UndoSupport(this.undom_, "undo.deleteSelected");
        this.myGenomePre_.clearSelections(this.genomeKey_, this.layout_, support);
        boolean didDelete = false;
        if (dc.deleteLinksFromModel(linkInter, this.genomeKey_, this.layout_, support)) {
            didDelete = true;
        }
        Iterator nit = nodeInter.values().iterator();
        int runningUserValue = 1;
        while (nit.hasNext()) {
            Intersection inter = (Intersection)nit.next();
            int useReply = dc.deleteNodeFromModel(inter, this.genomeKey_, support, runningUserValue, true);
            didDelete |= useReply != 0;
            if (useReply == 3) {
                runningUserValue = 2;
                continue;
            }
            if (useReply != 2) continue;
            runningUserValue = 3;
        }
        if (globalPadNeeds != null) {
            mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        }
        if (didDelete) {
            support.addEvent(new ModelChangeEvent(this.genomeKey_, 1));
        }
        support.finish();
    }

    public void nudgeSelected(int direction) {
        if (!this.accept_) {
            return;
        }
        double dx = 0.0;
        double dy = 0.0;
        switch (direction) {
            case 0: {
                dx = 0.0;
                dy = -10.0;
                break;
            }
            case 1: {
                dx = 0.0;
                dy = 10.0;
                break;
            }
            case 2: {
                dx = -10.0;
                dy = 0.0;
                break;
            }
            case 3: {
                dx = 10.0;
                dy = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Layout lo = Database.getDB().getLayout(this.layout_);
        FontRenderContext frc = this.myGenomePre_.getFontRenderContext();
        Layout.PadNeedsForLayout padFixups = lo.findAllNetModuleLinkPadRequirements(frc);
        Layout.PropChange[] pca = this.myGenomePre_.nudgeSelectedItems(dx, dy, this.genomeKey_, lo, padFixups);
        if (pca != null) {
            UndoSupport support = new UndoSupport(this.undom_, "undo.nudgeSelected");
            PropChangeCmd mov = new PropChangeCmd(pca);
            support.addEdit(mov);
            support.addEvent(new LayoutChangeEvent(this.layout_, 1));
            Map orpho = lo.orphansOnlyForAll(false);
            Layout.PropChange[] padLpc = lo.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho);
            if (padLpc != null && padLpc.length != 0) {
                PropChangeCmd padC = new PropChangeCmd(padLpc);
                support.addEdit(padC);
            }
            support.finish();
        }
    }

    public void setToMode(int mode, Object args) {
        Integer key = new Integer(mode);
        ModeHandler handler = (ModeHandler)this.clickHandlers_.get(key);
        int newMode = handler.setToMode(args);
        if (newMode == 0) {
            return;
        }
        this.currentMode_ = newMode;
    }

    private boolean convertToAddRegionsToNetworkModule(String modID) {
        Integer key = new Integer(4);
        AddToNetModuleHandler handler = (AddToNetModuleHandler)this.clickHandlers_.get(key);
        int newMode = handler.convertToMode(modID);
        if (newMode == 0) {
            return false;
        }
        this.currentMode_ = newMode;
        return true;
    }

    public void registerPullFrame(JDialog pullFrame) {
        this.pullFrame_ = pullFrame;
    }

    public JDialog getPullFrame() {
        return this.pullFrame_;
    }

    public void pullDownsFromFrame(Set nodeIDs, Set linkIDs, String groupID1, String groupID2) {
        AddCommands ac = new AddCommands(this.parent_, this.undom_);
        ac.propagateDownElementsFromRootToGroup(nodeIDs, linkIDs, this.genomeKey_, this.layout_, groupID1, groupID2, this.myGenomePre_.getFontRenderContext());
        this.repaint();
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        double px = pf.getImageableX();
        double py = pf.getImageableY();
        double pw = pf.getImageableWidth();
        double ph = pf.getImageableHeight();
        boolean doModules = this.currentOverlay_ != null && !this.currentNetMods_.set.isEmpty();
        Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
        Rectangle origRect = this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, true, true, doModules, doModules, this.currentOverlay_, this.currentNetMods_, allKeys);
        Point2D oldCenter = this.getRawCenterPoint();
        this.fixCenterPoint(true, null, false);
        double wFrac = (double)origRect.width / pw;
        double hFrac = (double)origRect.height / ph;
        double frac = 1.0 / (hFrac > wFrac ? hFrac : wFrac);
        Vector2D preTrans = new Vector2D(px + pw / 2.0, py + ph / 2.0);
        Point2D center = this.getRawCenterPoint();
        Vector2D postTrans = new Vector2D(-center.getX(), -center.getY());
        OverrideTransform otr = new OverrideTransform(preTrans, frac, postTrans, true);
        int orx = 0;
        int ory = 0;
        int orw = (int)(pw / 72.0 * 300.0);
        int orh = (int)(ph / 72.0 * 300.0);
        Rectangle imgView = new Rectangle(orx, ory, orw, orh);
        this.drawingGuts(g, false, false, otr, false, false, imgView);
        this.setRawCenterPoint(oldCenter, null, false);
        return 0;
    }

    public BoundsMaps exportToFile(File saveFile, boolean calcMap, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        return this.exportGuts(saveFile, calcMap, format, res, zoom, size);
    }

    public BoundsMaps exportToStream(OutputStream stream, boolean calcMap, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        return this.exportGuts(stream, calcMap, format, res, zoom, size);
    }

    private BoundsMaps exportGuts(Object outObj, boolean calcMap, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        int height;
        int width;
        if (size == null) {
            boolean doModules = this.currentOverlay_ != null && !this.currentNetMods_.set.isEmpty();
            Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
            Rectangle rect = this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, true, true, doModules, doModules, this.currentOverlay_, this.currentNetMods_, allKeys);
            width = (int)((double)rect.width * zoom);
            height = (int)((double)rect.height * zoom);
        } else {
            width = size.width;
            height = size.height;
        }
        Point2D oldCenter = this.getRawCenterPoint();
        this.fixCenterPoint(true, null, false);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        Vector2D preTrans = new Vector2D((double)width / 2.0, (double)height / 2.0);
        Point2D center = this.getRawCenterPoint();
        Vector2D postTrans = new Vector2D(-center.getX(), -center.getY());
        OverrideTransform otr = new OverrideTransform(preTrans, zoom, postTrans, false);
        Rectangle imgView = new Rectangle(0, 0, width, height);
        BoundsMaps retval = null;
        if (calcMap) {
            retval = this.drawingGuts(g2, true, true, otr, false, false, imgView);
            retval.convert(otr.buildTransform());
        } else {
            this.drawingGuts(g2, false, false, otr, false, false, imgView);
        }
        BufferedImage birgb = new BufferedImage(width, height, 1);
        Graphics2D g2rgb = birgb.createGraphics();
        g2rgb.drawImage((Image)bi, 0, 0, null);
        ImageExporter iex = new ImageExporter();
        iex.export(outObj, birgb, format, res);
        this.setRawCenterPoint(oldCenter, null, false);
        return retval;
    }

    public void modelHasChanged(ModelChangeEvent event, int remaining) {
        this.modelHasChanged(event);
    }

    public void modelHasChanged(ModelChangeEvent event) {
        this.textMgr_.checkForChanges(event);
        this.repaint();
    }

    public void layoutHasChanged(LayoutChangeEvent event) {
        this.repaint();
    }

    public void generalChangeOccurred(GeneralChangeEvent gcev) {
        if (gcev.getChangeType() == 2) {
            this.repaint();
        }
    }

    public String getToolTipText(MouseEvent event) {
        GenomeInstance gi;
        Group grp;
        Point tipPoint = event.getPoint();
        ResourceManager rMan = ResourceManager.getManager();
        this.zoomer_.transformPoint(tipPoint);
        Database db = Database.getDB();
        Layout lo = db.getLayout(this.layout_);
        List augs = this.myGenomePre_.intersectItem(tipPoint.x, tipPoint.y, this.genomeKey_, lo, this.zoomer_.currentPixelDiameter(), false, false, this);
        Intersection.AugmentedIntersection ai = new IntersectionChooser(true, this.genomeKey_, lo).selectionRanker(augs);
        if (ai == null || ai.intersect == null) {
            return null;
        }
        String objID = ai.intersect.getObjectID();
        Genome genome = db.getGenome(this.genomeKey_);
        Linkage link = genome.getLinkage(objID);
        if (link == null) {
            return null;
        }
        Node srcNode = genome.getNode(link.getSource());
        String src = srcNode.getName();
        if (src == null || src.trim().equals("")) {
            src = rMan.getString("tip.noname");
        }
        if (genome instanceof GenomeInstance && (grp = (gi = (GenomeInstance)genome).getGroupForNode(srcNode.getID(), 1)) != null) {
            String grpName = grp.getInheritedTrueName(gi);
            src = src + " [" + grpName + "]";
        }
        String format = rMan.getString("tip.source");
        String desc = MessageFormat.format(format, src);
        return desc;
    }

    private BoundsMaps drawingGuts(Graphics g, boolean getNoteBounds, boolean getNodeBounds, OverrideTransform ovrTra, boolean showBubbles, boolean doRect, Rectangle imgView) {
        BoundsMaps retval = null;
        if (this.genomeKey_ != null) {
            NetOverlayProperties nop;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            AffineTransform saveTrans = g2.getTransform();
            AffineTransform useTrans = ovrTra == null ? null : ovrTra.buildTransform();
            this.zoomer_.installTransform(g2, useTrans);
            if (doRect) {
                Workspace ws = Database.getDB().getWorkspace();
                Point2D origin = ws.getOrigin();
                Rectangle2D.Double rect = new Rectangle2D.Double(origin.getX(), origin.getY(), ws.getWidth(), ws.getHeight());
                g2.setPaint(Color.white);
                g2.fill(rect);
                g2.setPaint(Color.black);
                g2.draw(rect);
            }
            Database db = Database.getDB();
            Layout useLayout = this.dragLayout_ != null ? this.dragLayout_ : (this.multiMoveLayout_ != null ? this.multiMoveLayout_ : db.getLayout(this.layout_));
            Rectangle viewRect = null;
            GenomePresentation.OpaqueOverlayInfo ooi = null;
            Graphics2D ig2 = null;
            if (this.currentOverlay_ != null && (nop = useLayout.getNetOverlayProperties(this.currentOverlay_)).getType() == 1) {
                AffineTransform overTrans;
                viewRect = imgView == null ? this.myScrollPane_.getViewport().getViewRect() : imgView;
                if (this.bim_ == null || this.bim_.getHeight() != viewRect.height || this.bim_.getWidth() != viewRect.width) {
                    this.bim_ = new BufferedImage(viewRect.width, viewRect.height, 2);
                }
                ig2 = this.bim_.createGraphics();
                ig2.setTransform(new AffineTransform());
                Color drawCol = new Color(1.0f, 1.0f, 1.0f, (float)this.currOvrSettings_.backgroundOverlayAlpha);
                ig2.setBackground(drawCol);
                ig2.clearRect(0, 0, viewRect.width, viewRect.height);
                ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ig2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                if (ovrTra == null) {
                    AffineTransform otp = new AffineTransform();
                    overTrans = new AffineTransform(this.zoomer_.getTransform());
                    otp.translate(-viewRect.getX(), -viewRect.getY());
                    overTrans.preConcatenate(otp);
                } else {
                    overTrans = ovrTra.buildTransform();
                }
                ig2.setTransform(overTrans);
                AffineTransform ooit = ovrTra != null ? (ovrTra.forPrinter ? saveTrans : new AffineTransform()) : saveTrans;
                ooi = new GenomePresentation.OpaqueOverlayInfo(viewRect, this.bim_, ig2, ooit);
            }
            HashSet<String> showModuleComponents = null;
            if (this.showingNetModuleComponents_) {
                showModuleComponents = this.currentNetMods_.set;
            } else if (this.currentMode_ == 7) {
                MultiMoveModeHandler handler = (MultiMoveModeHandler)this.clickHandlers_.get(new Integer(this.currentMode_));
                GenomePresentation.RunningMove[] movs = handler.getMultiMov();
                for (int i = 0; i < movs.length; ++i) {
                    if (movs[i].type != 5) continue;
                    showModuleComponents = new HashSet();
                    showModuleComponents.add(movs[i].modIntersect.getObjectID());
                    break;
                }
            } else if (this.rmov_ != null && this.rmov_.type == 4) {
                showModuleComponents = new HashSet();
                showModuleComponents.add(this.rmov_.modIntersect.getObjectID());
            } else if (this.menuDrivenShowComponentModule_ != null) {
                showModuleComponents = new HashSet<String>();
                showModuleComponents.add(this.menuDrivenShowComponentModule_);
            }
            Rectangle2D clipRect = this.zoomer_.getCurrentWorldClipRect();
            double pixDiam = this.zoomer_.currentPixelDiameter();
            this.myGenomePre_.presentGenomeWithOverlay(g2, ooi, this.genomeKey_, useLayout, showBubbles, this.currentMode_ != 19, this, showModuleComponents, clipRect, pixDiam);
            if (getNoteBounds || getNodeBounds) {
                retval = new BoundsMaps();
                Genome genome = db.getGenome(this.genomeKey_);
                if (getNoteBounds) {
                    retval.noteBounds = this.myGenomePre_.getNoteBounds(g2, genome, useLayout);
                }
                if (getNodeBounds) {
                    retval.nodeBounds = this.myGenomePre_.getNodeBounds(g2, genome, useLayout);
                }
            }
            g2.setTransform(saveTrans);
        }
        return retval;
    }

    public void transformClick(int x, int y, Point pt) {
        this.zoomer_.transformClick(x, y, pt);
    }

    public double currentPixelDiameter() {
        return this.zoomer_.currentPixelDiameter();
    }

    public void transformClick(double x, double y, Point pt) {
        this.zoomer_.transformClick(x, y, pt);
    }

    void forceToGrid(int x, int y, Point pt) {
        pt.x = (int)((double)Math.round((double)x / 10.0) * 10.0);
        pt.y = (int)((double)Math.round((double)y / 10.0) * 10.0);
    }

    private HashMap initHandlers() {
        HashMap<Integer, ModeHandler> retval = new HashMap<Integer, ModeHandler>();
        retval.put(new Integer(0), new DefaultHandler());
        retval.put(new Integer(1), new AddNodeHandler(true));
        retval.put(new Integer(2), new DrawNetModuleHandler());
        retval.put(new Integer(3), new DrawNetModuleLinkHandler());
        retval.put(new Integer(4), new AddToNetModuleHandler());
        retval.put(new Integer(5), new DrawGroupHandler());
        retval.put(new Integer(6), new MoveGroupHandler());
        retval.put(new Integer(7), new MoveNetModuleHandler());
        retval.put(new Integer(8), new AddLinkHandler());
        retval.put(new Integer(9), new AddNodeHandler(false));
        retval.put(new Integer(10), new RelocateHandler());
        retval.put(new Integer(11), new ChangeSourceNodeHandler());
        retval.put(new Integer(12), new ChangeTargetNodeHandler());
        retval.put(new Integer(13), new AddNoteHandler());
        retval.put(new Integer(14), new AddSubGroupHandler());
        retval.put(new Integer(15), new RelocateTargetHandler());
        retval.put(new Integer(16), new RelocateSourceHandler());
        retval.put(new Integer(17), new SwapPadsHandler());
        retval.put(new Integer(18), new AddExtraProxyNodeHandler());
        retval.put(new Integer(19), new PullDownHandler(false));
        retval.put(new Integer(20), new PullDownHandler(true));
        retval.put(new Integer(21), new RelocateNetModLinkHandler());
        retval.put(new Integer(22), new RelocateNetModTargetHandler());
        retval.put(new Integer(23), new RelocateNetModSourceHandler());
        retval.put(new Integer(24), new ChangeGroupMembershipHandler());
        return retval;
    }

    private BlackHoleResults droppingIntoABlackHole(int x, int y, String genomeKey, String layoutKey, boolean needModAdd) {
        BlackHoleResults retval = new BlackHoleResults();
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        Set nbh = this.myGenomePre_.nonBlackHoles(genomeKey, layout, this);
        List intersected = null;
        if (needModAdd || nbh != null) {
            intersected = new NetModuleIntersector(genome, layoutKey).netModuleIntersections(x, y, 0.0);
        }
        List list = retval.modCandidates = needModAdd ? intersected : null;
        retval.intoABlackHole = nbh != null ? intersected.isEmpty() || !nbh.containsAll(intersected) : false;
        return retval;
    }

    private static class OverrideTransform {
        Vector2D preTrans;
        double zoom;
        Vector2D postTrans;
        boolean forPrinter;

        OverrideTransform(Vector2D preTrans, double zoom, Vector2D postTrans, boolean forPrinter) {
            this.preTrans = preTrans;
            this.zoom = zoom;
            this.postTrans = postTrans;
            this.forPrinter = forPrinter;
        }

        AffineTransform buildTransform() {
            AffineTransform retval = new AffineTransform();
            retval.translate(this.preTrans.getX(), this.preTrans.getY());
            retval.scale(this.zoom, this.zoom);
            retval.translate(this.postTrans.getX(), this.postTrans.getY());
            return retval;
        }
    }

    public static class BoundsMaps {
        public Map noteBounds;
        public Map nodeBounds;

        void convert(AffineTransform expTrans) {
            if (this.noteBounds != null) {
                this.convertMap(this.noteBounds, expTrans);
            }
            if (this.nodeBounds != null) {
                this.convertMap(this.nodeBounds, expTrans);
            }
        }

        private void convertMap(Map boundsMap, AffineTransform expTrans) {
            Iterator rit = boundsMap.values().iterator();
            while (rit.hasNext()) {
                Rectangle brect = (Rectangle)rit.next();
                Point2D.Double originPoint = new Point2D.Double(brect.x, brect.y);
                expTrans.transform(originPoint, originPoint);
                Point2D.Double extentPoint = new Point2D.Double(brect.x + brect.width, brect.y + brect.height);
                expTrans.transform(extentPoint, extentPoint);
                brect.width = (int)Math.round(((Point2D)extentPoint).getX() - ((Point2D)originPoint).getX());
                brect.height = (int)Math.round(((Point2D)extentPoint).getY() - ((Point2D)originPoint).getY());
                brect.x = (int)Math.round(((Point2D)originPoint).getX());
                brect.y = (int)Math.round(((Point2D)originPoint).getY());
            }
        }
    }

    private class DefaultHandler
    extends ModeHandler {
        private DefaultHandler() {
        }

        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            if (SUPanel.this.genomeKey_ != null) {
                Intersection intersect = null;
                Layout lo = Database.getDB().getLayout(SUPanel.this.layout_);
                intersect = SUPanel.this.myGenomePre_.selectItem(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, isShifted, false, SUPanel.this);
                String currNoteID = null;
                if (intersect != null) {
                    String itemID = intersect.getObjectID();
                    Genome genome = Database.getDB().getGenome(SUPanel.this.genomeKey_);
                    Note note = genome.getNote(itemID);
                    if (note != null && note.isInteractive()) {
                        currNoteID = itemID;
                    }
                }
                SUPanel.this.myGenomePre_.setFloater(null);
                if (currNoteID != null) {
                    SUPanel.this.textMgr_.setMessageSource(currNoteID, 3, false);
                } else {
                    SUPanel.this.textMgr_.clearMessageSource(3);
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
        }

        int setToMode(Object args) {
            return 0;
        }
    }

    public static class MoveNetModuleArgs {
        Intersection intersect;
        Point pt;
        boolean moveGuts;
        int moveMode;
        Point warpedPt;

        public MoveNetModuleArgs(Intersection intersect, Point pt, boolean moveGuts, int moveMode, Point warpedPt) {
            this.intersect = intersect;
            this.pt = pt;
            this.moveGuts = moveGuts;
            this.moveMode = moveMode;
            this.warpedPt = warpedPt;
        }
    }

    private class MoveNetModuleHandler
    extends MultiMoveModeHandler {
        private MoveNetModuleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            boolean result = false;
            try {
                result = this.doNetModuleMoveFinish(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_);
            }
            finally {
                SUPanel.this.currentMode_ = 0;
                this.multiMov_ = null;
                this.multiMovStartPt_ = null;
                SUPanel.this.cView_.enableControls();
                SUPanel.this.myGenomePre_.setFloater(null);
                SUPanel.this.cursorMgr_.showDefaultCursor();
            }
            if (!result) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        int setToMode(Object args) {
            MoveNetModuleArgs mnma = (MoveNetModuleArgs)args;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            SUPanel.this.cView_.disableControls(2, false);
            NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)mnma.intersect.getSubID();
            if (ei != null) {
                ei.endPt = null;
                ei.startPt = null;
            }
            Layout layout = db.getLayout(SUPanel.this.layout_);
            this.multiMov_ = SUPanel.this.myGenomePre_.getRunningMovesForNetModule(mnma.intersect, mnma.pt, SUPanel.this.genomeKey_, layout, SUPanel.this.currentOverlay_, mnma.moveGuts, mnma.moveMode);
            this.multiMovStartPt_ = mnma.warpedPt;
            return 7;
        }

        private boolean doNetModuleMoveFinish(int x, int y, String genomeKey, String layoutKey) {
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
            int needFixups = SUPanel.this.myGenomePre_.needPadFixupsForMoves(this.multiMov_);
            Layout.PadNeedsForLayout padFixups = null;
            if (needFixups == 1) {
                String ownerID = db.getOverlayOwnerFromGenomeKey(genomeKey).getID();
                padFixups = layout.findAllNetModuleLinkPadRequirementsForOverlay(frc, ownerID, SUPanel.this.currentOverlay_);
            } else if (needFixups == 2) {
                padFixups = layout.findAllNetModuleLinkPadRequirements(frc);
            }
            Layout.PropChange[] allLpc = this.doMultiMoveFinishCore(x, y, genomeKey, layoutKey, padFixups);
            if (allLpc != null) {
                Map orpho;
                Layout.PropChange[] padLpc;
                UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.moveNetModule");
                PropChangeCmd mov = new PropChangeCmd(allLpc);
                support.addEdit(mov);
                support.addEvent(new LayoutChangeEvent(layoutKey, 1));
                if (padFixups != null && (padLpc = layout.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho = layout.orphansOnlyForAll(false))) != null && padLpc.length != 0) {
                    PropChangeCmd padC = new PropChangeCmd(padLpc);
                    support.addEdit(padC);
                }
                support.finish();
            }
            return true;
        }
    }

    private abstract class MultiMoveModeHandler
    extends ModeHandler {
        protected GenomePresentation.RunningMove[] multiMov_;
        protected Point multiMovStartPt_;

        private MultiMoveModeHandler() {
        }

        void cancelMode(Object args) {
            this.multiMov_ = null;
            this.multiMovStartPt_ = null;
        }

        GenomePresentation.RunningMove[] getMultiMov() {
            return this.multiMov_;
        }

        void handleMouseMotion(Point pt) {
            if (this.multiMov_ != null) {
                if (this.multiMovStartPt_ == null) {
                    for (int i = 0; i < this.multiMov_.length; ++i) {
                        this.multiMov_[i].resetStart(pt);
                    }
                    this.multiMovStartPt_ = pt;
                }
                Database db = Database.getDB();
                Layout origLo = db.getLayout(SUPanel.this.layout_);
                FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                int needFixups = SUPanel.this.myGenomePre_.needPadFixupsForMoves(this.multiMov_);
                Layout.PadNeedsForLayout padFixups = null;
                if (needFixups != 0) {
                    String ownerID = db.getOverlayOwnerFromGenomeKey(SUPanel.this.genomeKey_).getID();
                    padFixups = origLo.findAllNetModuleLinkPadRequirementsForOverlay(frc, ownerID, SUPanel.this.currentOverlay_);
                }
                SUPanel.this.multiMoveLayout_ = new Layout(origLo);
                for (int i = 0; i < this.multiMov_.length; ++i) {
                    SUPanel.this.myGenomePre_.moveItem(this.multiMov_[i], pt, SUPanel.this.genomeKey_, SUPanel.this.multiMoveLayout_, padFixups);
                }
                if (padFixups != null) {
                    Map orpho = SUPanel.this.multiMoveLayout_.orphansOnlyForAll(false);
                    SUPanel.this.multiMoveLayout_.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho);
                }
            }
            SUPanel.this.repaint();
        }

        protected Layout.PropChange[] doMultiMoveFinishCore(int x, int y, String genomeKey, String layoutKey, Layout.PadNeedsForLayout padFixups) {
            Layout.PropChange[] allLpc = null;
            Database db = Database.getDB();
            Layout lo = db.getLayout(layoutKey);
            Point end = new Point(x, y);
            ArrayList<Layout.PropChange[]> allChanges = new ArrayList<Layout.PropChange[]>();
            int numPC = 0;
            if (this.multiMov_ != null) {
                int i;
                if (this.multiMovStartPt_ == null) {
                    for (i = 0; i < this.multiMov_.length; ++i) {
                        this.multiMov_[i].resetStart(end);
                    }
                    this.multiMovStartPt_ = end;
                }
                for (i = 0; i < this.multiMov_.length; ++i) {
                    Layout.PropChange[] lpc = SUPanel.this.myGenomePre_.moveItem(this.multiMov_[i], end, genomeKey, lo, padFixups);
                    if (lpc == null) continue;
                    allChanges.add(lpc);
                    numPC += lpc.length;
                }
                this.multiMov_ = null;
                this.multiMovStartPt_ = null;
            }
            boolean blank = true;
            if (numPC != 0) {
                allLpc = new Layout.PropChange[numPC];
                int numac = allChanges.size();
                int count = 0;
                for (int j = 0; j < numac; ++j) {
                    Layout.PropChange[] lpc = (Layout.PropChange[])allChanges.get(j);
                    for (int i = 0; i < lpc.length; ++i) {
                        if (lpc[i] != null) {
                            blank = false;
                        }
                        allLpc[count++] = lpc[i];
                    }
                }
            }
            return blank ? null : allLpc;
        }
    }

    public static class MoveGroupArgs {
        String groupID;
        Point pt;
        Point warpedPt;

        public MoveGroupArgs(String groupID, Point pt, Point warpedPt) {
            this.groupID = groupID;
            this.pt = pt;
            this.warpedPt = warpedPt;
        }
    }

    private class MoveGroupHandler
    extends MultiMoveModeHandler {
        private MoveGroupHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            boolean result = false;
            try {
                result = this.doGroupMoveFinish(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_);
            }
            finally {
                SUPanel.this.currentMode_ = 0;
                this.multiMov_ = null;
                this.multiMovStartPt_ = null;
                SUPanel.this.cView_.enableControls();
                SUPanel.this.myGenomePre_.setFloater(null);
                SUPanel.this.cursorMgr_.showDefaultCursor();
            }
            if (!result) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        int setToMode(Object args) {
            MoveGroupArgs mga = (MoveGroupArgs)args;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (!(genome instanceof GenomeInstance)) {
                return 0;
            }
            SUPanel.this.cView_.disableControls(2, false);
            Layout layout = db.getLayout(SUPanel.this.layout_);
            this.multiMov_ = SUPanel.this.myGenomePre_.getRunningMovesForGroup(mga.pt, SUPanel.this.genomeKey_, layout, mga.groupID);
            this.multiMovStartPt_ = mga.warpedPt;
            return 6;
        }

        private boolean doGroupMoveFinish(int x, int y, String genomeKey, String layoutKey) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            if (!(genome instanceof GenomeInstance)) {
                throw new IllegalArgumentException();
            }
            Layout layout = db.getLayout(layoutKey);
            FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
            int needFixups = SUPanel.this.myGenomePre_.needPadFixupsForMoves(this.multiMov_);
            Layout.PadNeedsForLayout padFixups = null;
            if (needFixups == 1) {
                String ownerID = db.getOverlayOwnerFromGenomeKey(SUPanel.this.genomeKey_).getID();
                padFixups = layout.findAllNetModuleLinkPadRequirementsForOverlay(frc, ownerID, SUPanel.this.currentOverlay_);
            } else if (needFixups == 2) {
                padFixups = layout.findAllNetModuleLinkPadRequirements(frc);
            }
            Layout.PropChange[] allLpc = this.doMultiMoveFinishCore(x, y, genomeKey, layoutKey, padFixups);
            if (allLpc != null) {
                UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.moveGroup");
                PropChangeCmd mov = new PropChangeCmd(allLpc);
                support.addEdit(mov);
                support.addEvent(new LayoutChangeEvent(layoutKey, 1));
                Map orpho = layout.orphansOnlyForAll(false);
                Layout.PropChange[] padLpc = layout.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho);
                if (padLpc != null && padLpc.length != 0) {
                    PropChangeCmd padC = new PropChangeCmd(padLpc);
                    support.addEdit(padC);
                }
                support.finish();
            }
            return true;
        }
    }

    public static class SwapPadArgs {
        int swapType;
        Intersection inter;

        public SwapPadArgs(int swapType, Intersection inter) {
            this.swapType = swapType;
            this.inter = inter;
        }
    }

    private class SwapPadsHandler
    extends LinkManipulatorHandler {
        private int swapType_;

        private SwapPadsHandler() {
            this.swapType_ = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.swapPads(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, this.swapType_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    this.swapType_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        void cancelMode(Object args) {
            super.cancelMode(args);
            this.swapType_ = 0;
        }

        int setToMode(Object args) {
            GenomeInstance parent;
            SUPanel.this.cancelAddMode();
            SwapPadArgs spa = (SwapPadArgs)args;
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                return 0;
            }
            this.swapType_ = spa.swapType;
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = spa.inter;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 17;
        }

        private int swapPads(int x, int y, Intersection cro, String genomeKey, String layoutKey, int swapType, double pixDiam) {
            ModificationCommands mcmd;
            Intersection.PadVal pad;
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, layout, pixDiam, true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String id = inter.getObjectID();
            Node node = genome.getNode(id);
            if (node == null) {
                return 0;
            }
            if (!(sub instanceof Intersection.PadVal)) {
                return 0;
            }
            String myLinkId = null;
            if (swapType != 2) {
                LinkSegmentID[] linkIDs;
                String lid = cro.getObjectID();
                BusProperties lp = layout.getLinkProperties(lid);
                BusProperties bp = lp;
                Set throughSeg = bp.resolveLinkagesThroughSegment((linkIDs = cro.segmentIDsFromIntersect())[0], genome);
                if (throughSeg.size() != 1) {
                    throw new IllegalStateException();
                }
                myLinkId = (String)throughSeg.iterator().next();
                if (swapType == 3) {
                    Linkage link = genome.getLinkage(myLinkId);
                    String src = link.getSource();
                    String trg = link.getTarget();
                    if (id.equals(src)) {
                        swapType = 2;
                    } else if (id.equals(trg)) {
                        swapType = 1;
                    } else {
                        return 0;
                    }
                }
            }
            List pads = inter.getPadCand();
            int numCand = pads.size();
            Intersection.PadVal winner = null;
            if (swapType == 1) {
                for (int i = 0; i < numCand; ++i) {
                    pad = (Intersection.PadVal)pads.get(i);
                    if (!pad.okEnd || winner != null && !(winner.distance > pad.distance)) continue;
                    winner = pad;
                }
                if (winner == null) {
                    return 0;
                }
                Linkage link = genome.getLinkage(myLinkId);
                if (!link.getTarget().equals(id)) {
                    return 0;
                }
            } else if (swapType == 2) {
                for (int i = 0; i < numCand; ++i) {
                    pad = (Intersection.PadVal)pads.get(i);
                    if (!pad.okStart || winner != null && !(winner.distance > pad.distance)) continue;
                    winner = pad;
                }
                if (winner == null) {
                    return 0;
                }
                String lid = cro.getObjectID();
                Set allLinks = layout.getSharedItems(lid);
                myLinkId = (String)allLinks.iterator().next();
                Linkage firstLink = genome.getLinkage(myLinkId);
                if (!firstLink.getSource().equals(id)) {
                    return 0;
                }
            } else {
                throw new IllegalArgumentException();
            }
            if ((mcmd = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_)).swapLinkPads(cro, inter, winner, id, layout, genome, swapType, myLinkId)) {
                return 1;
            }
            return 0;
        }
    }

    private class RelocateSourceHandler
    extends LinkManipulatorHandler {
        private RelocateSourceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateSource(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        int setToMode(Object args) {
            GenomeInstance parent;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 16;
        }

        private int relocateSource(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, layout, pixDiam, true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String id = inter.getObjectID();
            Node node = genome.getNode(id);
            if (node == null) {
                return 0;
            }
            if (!(sub instanceof Intersection.PadVal)) {
                return 0;
            }
            List pads = inter.getPadCand();
            ModificationCommands mcmd = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            if (mcmd.changeLinkSource(cro, inter, pads, id, layout, genome)) {
                return 1;
            }
            return 0;
        }
    }

    private class RelocateTargetHandler
    extends LinkManipulatorHandler {
        private RelocateTargetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateTarget(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        int setToMode(Object args) {
            GenomeInstance parent;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 15;
        }

        private int relocateTarget(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, layout, pixDiam, true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String id = inter.getObjectID();
            Node node = genome.getNode(id);
            if (node == null) {
                return 0;
            }
            if (!(sub instanceof Intersection.PadVal)) {
                return 0;
            }
            List pads = inter.getPadCand();
            ModificationCommands mcmd = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            if (mcmd.changeLinkTarget(cro, inter, pads, id, layout, genome)) {
                return 1;
            }
            return 0;
        }
    }

    private class RelocateHandler
    extends LinkManipulatorHandler {
        private RelocateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateLink(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        int setToMode(Object args) {
            GenomeInstance parent;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 10;
        }

        private int relocateLink(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            Layout lo = Database.getDB().getLayout(layoutKey);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, lo, pixDiam, false, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String id = inter.getObjectID();
            if (genome.getLinkage(id) == null) {
                BusProperties lp;
                String src;
                Node node = genome.getNode(id);
                if (node != null && !id.equals(src = (lp = layout.getLinkProperties(cro.getObjectID())).getSourceTag())) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString("linkSrcChange.useNodeSwitch"), rMan.getString("linkSrcChange.useNodeSwitchTitle"), 0);
                }
                return 0;
            }
            LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
            if (!segIDs[0].isTaggedWithEndpoint()) {
                return 0;
            }
            BusProperties bp = layout.getLinkProperties(id);
            if (bp != layout.getLinkProperties(cro.getObjectID())) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString("linkSrcChange.useNodeSwitch"), rMan.getString("linkSrcChange.useNodeSwitchTitle"), 0);
                return 0;
            }
            LinkSegmentID[] moveIDs = cro.segmentIDsFromIntersect();
            Layout.PropChange lpc = layout.relocateSegmentOnTree(bp, segIDs[0], moveIDs[0], null);
            if (lpc != null) {
                UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.linkrelocate");
                PropChangeCmd mov = new PropChangeCmd(new Layout.PropChange[]{lpc});
                support.addEdit(mov);
                support.addEvent(new ModelChangeEvent(SUPanel.this.genomeKey_, 1));
                SUPanel.this.myGenomePre_.clearSelections(SUPanel.this.genomeKey_, SUPanel.this.layout_, support);
                support.finish();
                return 1;
            }
            return 0;
        }
    }

    private class ChangeTargetNodeHandler
    extends LinkManipulatorHandler {
        private ChangeTargetNodeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.changeLinkTargetNode(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    if (result != 5) {
                        SUPanel.this.cView_.enableControls();
                    }
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (!(genome instanceof DBGenome)) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 12;
        }

        private int changeLinkTargetNode(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, layout, pixDiam, true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String lid = cro.getObjectID();
            LinkSegmentID[] linkIDs = cro.segmentIDsFromIntersect();
            BusProperties bp = layout.getLinkProperties(lid);
            Set throughSeg = bp.resolveLinkagesThroughSegment(linkIDs[0], genome);
            if (throughSeg.size() != 1) {
                return 0;
            }
            lid = (String)throughSeg.iterator().next();
            Linkage currentLinkage = genome.getLinkage(lid);
            String currentTarget = currentLinkage.getTarget();
            String id = inter.getObjectID();
            Node node = genome.getNode(id);
            if (node == null) {
                return 0;
            }
            if (id.equals(currentTarget)) {
                return 0;
            }
            String targetID = id;
            if (!(sub instanceof Intersection.PadVal)) {
                return 0;
            }
            INodeRenderer render = layout.getNodeProperties(targetID).getRenderer();
            List pads = inter.getPadCand();
            int numCand = pads.size();
            Intersection.PadVal winner = null;
            if (!(genome instanceof DBGenome)) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < numCand; ++i) {
                Intersection.PadVal pad = (Intersection.PadVal)pads.get(i);
                if (!pad.okEnd || !this.targPadIsClear(genome, targetID, pad.padNum, render.sharedPadNamespaces()) || winner != null && !(winner.distance > pad.distance)) continue;
                winner = pad;
            }
            if (winner == null) {
                return 0;
            }
            int padNum = winner.padNum;
            ModificationCommands mcmd = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            if (!mcmd.changeLinkTargetNode(currentLinkage, targetID, padNum, (DBGenome)genome)) {
                return 1;
            }
            return 2;
        }
    }

    private class ChangeSourceNodeHandler
    extends LinkManipulatorHandler {
        private ChangeSourceNodeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.changeLinkSourceNode(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    if (result != 5) {
                        SUPanel.this.cView_.enableControls();
                    }
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (!(genome instanceof DBGenome)) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 11;
        }

        private int changeLinkSourceNode(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            int padNum;
            String sourceID;
            Intersection inter;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, layout, pixDiam, true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, layout).selectionRanker(augs);
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (inter == null) {
                return 0;
            }
            Object sub = inter.getSubID();
            if (sub == null) {
                return 0;
            }
            String lid = cro.getObjectID();
            Linkage currentLinkage = genome.getLinkage(lid);
            String currentSource = currentLinkage.getSource();
            LinkSegmentID[] linkIDs = cro.segmentIDsFromIntersect();
            BusProperties bp = layout.getLinkProperties(lid);
            Set throughSeg = bp.resolveLinkagesThroughSegment(linkIDs[0], genome);
            LinkSegmentID segID = null;
            String id = inter.getObjectID();
            Linkage link = genome.getLinkage(id);
            Node node = genome.getNode(id);
            if (link != null) {
                LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
                segID = segIDs[0];
                if (!segID.isTaggedWithEndpoint()) {
                    return 0;
                }
                sourceID = link.getSource();
                if (sourceID.equals(currentSource)) {
                    return 0;
                }
                padNum = link.getLaunchPad();
            } else if (node != null) {
                if (id.equals(currentSource)) {
                    return 0;
                }
                sourceID = id;
                if (!(sub instanceof Intersection.PadVal)) {
                    return 0;
                }
                INodeRenderer render = layout.getNodeProperties(sourceID).getRenderer();
                List pads = inter.getPadCand();
                int numCand = pads.size();
                Intersection.PadVal winner = null;
                if (!(genome instanceof DBGenome)) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < numCand; ++i) {
                    Intersection.PadVal pad = (Intersection.PadVal)pads.get(i);
                    if (!pad.okStart || !this.sourcePadIsClear(genome, sourceID, pad.padNum, render.sharedPadNamespaces()) || winner != null && !(winner.distance > pad.distance)) continue;
                    winner = pad;
                }
                if (winner == null) {
                    return 0;
                }
                padNum = winner.padNum;
            } else {
                return 0;
            }
            ModificationCommands mcmd = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            if (mcmd.changeLinkSourceNode(throughSeg, linkIDs[0], inter, padNum, segID, sourceID, layout, (DBGenome)genome, SUPanel.this.cView_, SUPanel.this.myGenomePre_.getFontRenderContext())) {
                return 5;
            }
            return 2;
        }
    }

    private class PullDownHandler
    extends ModeHandler {
        private boolean rootInstance_;
        private AddCommands pendingAdd_;

        PullDownHandler(boolean rootInstance) {
            this.rootInstance_ = rootInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            GenomeInstance parent;
            if (this.rootInstance_) {
                SUPanel.this.giveErrorFeedback();
                return;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                int result = 2;
                if (genome instanceof DynamicGenomeInstance) {
                    result = this.doGroupAdd(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
                } else {
                    result = this.doGroupAdd(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
                    if (result == 2 || result == 4) {
                        result = this.doLinkPulldown(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
                    }
                    if (result == 2) {
                        result = this.doNodePulldown(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
                    }
                }
                if (result == 3 || result == 2) {
                    SUPanel.this.giveErrorFeedback();
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode(1);
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (!(genome instanceof GenomeInstance)) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.cView_.disableControls(6, false);
            if (!this.rootInstance_) {
                SUPanel.this.cursorMgr_.showModeCursor();
            }
            return !this.rootInstance_ ? 19 : 20;
        }

        private int doGroupAdd(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            GenomeInstance parent;
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                int genCount;
                Intersection inter = SUPanel.this.myGenomePre_.selectGroupFromParent(x, y, genomeKey, layoutKey, pixDiam);
                if (inter == null) {
                    return 2;
                }
                String startID = inter.getObjectID();
                String inherit = Group.buildInheritedID(startID, genCount = parent.getGeneration());
                Group subsetGroup = parent.getGroup(inherit);
                if (subsetGroup == null) {
                    return 3;
                }
                genCount = ((GenomeInstance)genome).getGeneration();
                inherit = Group.buildInheritedID(startID, genCount);
                Group checkGroup = ((GenomeInstance)genome).getGroup(inherit);
                if (checkGroup != null) {
                    return 4;
                }
                this.pendingAdd_.addNewGroupToSubsetInstance(genomeKey, subsetGroup, null);
                return 0;
            }
            throw new IllegalArgumentException();
        }

        private int doNodePulldown(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            GenomeInstance parent;
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                List itemList = SUPanel.this.myGenomePre_.selectFromParent(x, y, genomeKey, layoutKey, pixDiam);
                Layout layout = db.getLayout(layoutKey);
                Intersection inter = new IntersectionChooser(true, genomeKey, layout).intersectionRanker(itemList);
                if (inter == null) {
                    return 2;
                }
                String startID = inter.getObjectID();
                NodeInstance subsetNode = (NodeInstance)parent.getNode(startID);
                if (subsetNode == null) {
                    return 2;
                }
                Group group = parent.getGroupForNode(startID, 2);
                if (group == null) {
                    return 2;
                }
                int genCount = ((GenomeInstance)genome).getGeneration();
                String inherit = Group.buildInheritedID(group.getID(), genCount);
                Group checkGroup = ((GenomeInstance)genome).getGroup(inherit);
                if (checkGroup == null) {
                    return 2;
                }
                NodeInstance checkNode = (NodeInstance)genome.getNode(startID);
                if (checkNode != null) {
                    int activity = checkNode.getActivity();
                    if (activity != 0) {
                        ResourceManager rMan = ResourceManager.getManager();
                        boolean doGene = checkNode.getNodeType() == 4;
                        JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString(doGene ? "addGene.PresentButInactive" : "addNode.PresentButInactive"), rMan.getString(doGene ? "addGene.MakeActiveTitle" : "addNode.MakeActiveTitle"), 0);
                        return 1;
                    }
                    return 3;
                }
                boolean doGene = subsetNode.getNodeType() == 4;
                List modCandidates = null;
                if (this.moduleOnDisplay(genome)) {
                    Layout lo = db.getLayout(layoutKey);
                    NodeProperties np = lo.getNodeProperties(startID);
                    Point2D nodeLoc = np.getLocation();
                    NetModuleIntersector nmi = new NetModuleIntersector(genome, layoutKey);
                    modCandidates = nmi.netModuleIntersections((int)nodeLoc.getX(), (int)nodeLoc.getY(), 0.0);
                }
                UndoSupport support = new UndoSupport(SUPanel.this.undom_, doGene ? "undo.addGene" : "undo.addNode");
                this.pendingAdd_.addNewNodeToSubsetInstance(genomeKey, subsetNode, support);
                if (modCandidates != null) {
                    Node inSub = genome.getNode(startID);
                    this.pendingAdd_.drawIntoNetModuleSupport(inSub, modCandidates, genome, SUPanel.this.currentOverlay_, support);
                }
                support.finish();
                return 0;
            }
            throw new IllegalArgumentException();
        }

        private boolean moduleOnDisplay(Genome genome) {
            if (SUPanel.this.currentOverlay_ == null) {
                return false;
            }
            return !((SUPanel)SUPanel.this).currentNetMods_.set.isEmpty();
        }

        private int doLinkPulldown(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            GenomeInstance parent;
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            Layout layout = db.getLayout(layoutKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                List itemList = SUPanel.this.myGenomePre_.selectFromParent(x, y, genomeKey, layoutKey, pixDiam);
                Intersection inter = new IntersectionChooser(true, genomeKey, layout).intersectionRanker(itemList);
                if (inter == null) {
                    return 2;
                }
                Linkage lnk = parent.getLinkage(inter.getObjectID());
                if (lnk == null) {
                    return 2;
                }
                HashSet linkagesToPull = new HashSet();
                BusProperties lp = layout.getLinkProperties(inter.getObjectID());
                LinkSegmentID segID = inter.segmentIDFromIntersect();
                Set resolved = lp.resolveLinkagesThroughSegment(segID, parent);
                linkagesToPull.addAll(resolved);
                HashSet<LinkageInstance> pullSurvivors = new HashSet<LinkageInstance>();
                HashSet<String> nodesToAdd = new HashSet<String>();
                Iterator pit = linkagesToPull.iterator();
                while (pit.hasNext()) {
                    Group trgGrpInChild;
                    Group trgGrpInParent;
                    Group srcGrpInChild;
                    Group srcGrpInParent;
                    LinkageInstance checkLink;
                    String linkageID = (String)pit.next();
                    LinkageInstance subsetLink = (LinkageInstance)parent.getLinkage(linkageID);
                    if (subsetLink == null || (checkLink = (LinkageInstance)genome.getLinkage(linkageID)) != null) continue;
                    String srcKey = subsetLink.getSource();
                    String trgKey = subsetLink.getTarget();
                    NodeInstance srcNode = (NodeInstance)genome.getNode(srcKey);
                    NodeInstance trgNode = (NodeInstance)genome.getNode(trgKey);
                    if (!(srcNode != null && trgNode != null || (srcGrpInParent = parent.getGroupForNode(srcKey, 2)) != null && (srcGrpInChild = ((GenomeInstance)genome).getGroup(Group.addGeneration(srcGrpInParent.getID()))) != null && (trgGrpInParent = parent.getGroupForNode(trgKey, 2)) != null && (trgGrpInChild = ((GenomeInstance)genome).getGroup(Group.addGeneration(trgGrpInParent.getID()))) != null)) continue;
                    pullSurvivors.add(subsetLink);
                    if (srcNode == null) {
                        nodesToAdd.add(srcKey);
                    }
                    if (trgNode != null) continue;
                    nodesToAdd.add(trgKey);
                }
                if (pullSurvivors.size() == 0) {
                    return 3;
                }
                if (nodesToAdd.size() > 0) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int include = JOptionPane.showConfirmDialog(SUPanel.this.parent_, rMan.getString("addLink.NeedSrcTarg"), rMan.getString("addLink.NeedSrcTargTitle"), 1);
                    if (include != 0) {
                        return 1;
                    }
                }
                this.pendingAdd_.addNewLinkWithNodesToSubsetInstance(genomeKey, parent, pullSurvivors, nodesToAdd);
                return 0;
            }
            throw new IllegalArgumentException();
        }
    }

    private class AddLinkHandler
    extends LinkManipulatorHandler {
        private AddCommands.LinkCandidate currentLinkCandidate_;
        private AddCommands pendingAdd_;

        private AddLinkHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            Point submit = null;
            if (this.currentLinkCandidate_.buildState == 1 && isShifted) {
                int x = UiUtil.forceToGridValueInt(pt.x, 10.0);
                int y = UiUtil.forceToGridValueInt(pt.y, 10.0);
                submit = new Point(x, y);
                ArrayList ptList = this.currentLinkCandidate_.points;
                Point2D lastPoint = (Point2D)ptList.get(ptList.size() - 1);
                Vector2D vec = new Vector2D(lastPoint, submit).canonical();
                Point2D canonicalPt = vec.add(lastPoint);
                submit = new Point((int)canonicalPt.getX(), (int)canonicalPt.getY());
            } else {
                submit = pt;
            }
            int result = this.growOrFinishLink(submit.x, submit.y, this.currentLinkCandidate_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            if (result == 0) {
                SUPanel.this.giveErrorFeedback();
            } else {
                int state = this.currentLinkCandidate_.buildState;
                if (state == 2) {
                    try {
                        FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                        this.pendingAdd_.addNewLinkFinish(SUPanel.this.genomeKey_, SUPanel.this.layout_, this.currentLinkCandidate_, frc);
                    }
                    finally {
                        SUPanel.this.currentMode_ = 0;
                        SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                        SUPanel.this.cView_.enableControls();
                        SUPanel.this.myGenomePre_.setFloater(null);
                        SUPanel.this.myGenomePre_.clearTargets();
                        SUPanel.this.myGenomePre_.clearRootOverlays();
                        SUPanel.this.cursorMgr_.showDefaultCursor();
                    }
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            super.cancelMode(args);
            this.currentLinkCandidate_ = null;
            this.pendingAdd_ = null;
        }

        Object getFloater(int x, int y) {
            if (this.currentLinkCandidate_.buildState == 1) {
                return this.currentLinkCandidate_.points;
            }
            return null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            Database db = Database.getDB();
            this.currentLinkCandidate_ = this.pendingAdd_.addNewLinkStart(SUPanel.this.genomeKey_, SUPanel.this.layout_, SUPanel.this.myGenomePre_.getFontRenderContext());
            if (this.currentLinkCandidate_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            boolean gotRegions = genome instanceof GenomeInstance;
            if (gotRegions) {
                GenomeInstance rootParent;
                Map okstm = this.pendingAdd_.getOKSrcTrgMap();
                if (okstm != null) {
                    Set okTargs = okstm.keySet();
                    if (okTargs == null) {
                        throw new IllegalStateException();
                    }
                    HashSet okTargLinks = new HashSet();
                    Iterator oktit = okTargs.iterator();
                    while (oktit.hasNext()) {
                        String nodeID = (String)oktit.next();
                        okTargLinks.addAll(genome.getOutboundLinks(nodeID));
                    }
                    HashSet allOk = new HashSet(okTargs);
                    allOk.addAll(okTargLinks);
                    SUPanel.this.myGenomePre_.setTargets(allOk);
                }
                if ((rootParent = ((GenomeInstance)genome).getVfgParentRoot()) != null) {
                    Iterator anit;
                    Set oversrcs;
                    HashSet overlays = new HashSet();
                    if (okstm != null) {
                        oversrcs = okstm.keySet();
                    } else {
                        oversrcs = new HashSet();
                        anit = genome.getAllNodeIterator();
                        while (anit.hasNext()) {
                            Node node = (Node)anit.next();
                            oversrcs.add(node.getID());
                        }
                    }
                    anit = oversrcs.iterator();
                    while (anit.hasNext()) {
                        String nodeID = (String)anit.next();
                        overlays.addAll(rootParent.getOutboundLinks(nodeID));
                    }
                    SUPanel.this.myGenomePre_.setRootOverlays(overlays);
                }
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            SUPanel.this.cursorMgr_.showModeCursor();
            SUPanel.this.repaint();
            return 8;
        }

        private int growOrFinishLink(int x, int y, AddCommands.LinkCandidate lc, String genomeKey, String layoutKey, double pixDiam) {
            String id;
            Object sub;
            Intersection inter;
            List augs;
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            boolean gotRegions = genome instanceof GenomeInstance;
            if (lc.buildState == 2) {
                throw new IllegalStateException();
            }
            int checkX = (int)((double)Math.round((double)x / 10.0) * 10.0);
            int checkY = (int)((double)Math.round((double)y / 10.0) * 10.0);
            Point checkPt = new Point(checkX, checkY);
            Iterator pit = lc.points.iterator();
            while (pit.hasNext()) {
                Point pt = (Point)pit.next();
                if (!pt.equals(checkPt)) continue;
                return 0;
            }
            Layout lo = Database.getDB().getLayout(layoutKey);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, genomeKey, lo).selectionRanker(augs = SUPanel.this.myGenomePre_.intersectItem(x, y, genomeKey, lo, pixDiam, true, false, SUPanel.this));
            Intersection intersection = inter = ai == null || ai.intersect == null ? null : ai.intersect;
            if (gotRegions && inter != null && ((GenomeInstance)genome).getGroup(inter.getObjectID()) != null) {
                inter = null;
            }
            boolean atSubsetLayer = false;
            GenomeInstance rootParent = null;
            if (gotRegions) {
                rootParent = ((GenomeInstance)genome).getVfgParent();
                atSubsetLayer = rootParent != null;
            }
            boolean linkFromRoot = false;
            if (inter == null && lc.buildState == 0 && gotRegions && ((GenomeInstance)genome).getVfgParent() != null) {
                List itemList;
                Set okTargs;
                HashSet okLinks = new HashSet();
                Map okstm = this.pendingAdd_.getOKSrcTrgMap();
                if (okstm != null) {
                    okTargs = okstm.keySet();
                } else {
                    okTargs = new HashSet();
                    Iterator sit = genome.getAllNodeIterator();
                    while (sit.hasNext()) {
                        Node node = (Node)sit.next();
                        okTargs.add(node.getID());
                    }
                }
                Iterator idit = okTargs.iterator();
                while (idit.hasNext()) {
                    String nodeID = (String)idit.next();
                    okLinks.addAll(rootParent.getOutboundLinks(nodeID));
                }
                Layout layout = db.getLayout(layoutKey);
                inter = new IntersectionChooser(true, genomeKey, layout).intersectionRanker(itemList = SUPanel.this.myGenomePre_.selectLinkFromRootParent(x, y, genomeKey, layoutKey, okLinks, pixDiam));
                if (inter != null) {
                    linkFromRoot = true;
                }
            }
            if (lc.buildState == 0) {
                if (inter == null) {
                    return 0;
                }
                sub = inter.getSubID();
                if (sub == null) {
                    return 0;
                }
                id = inter.getObjectID();
                Linkage link = genome.getLinkage(id);
                if (link == null && linkFromRoot) {
                    link = rootParent.getLinkage(id);
                }
                boolean recenter = true;
                if (link != null) {
                    LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
                    if (!segIDs[0].isTaggedWithEndpoint()) {
                        return 0;
                    }
                    lc.srcID = link.getSource();
                } else {
                    if (!(sub instanceof Intersection.PadVal)) {
                        return 0;
                    }
                    NodeProperties nprop = lo.getNodeProperties(id);
                    INodeRenderer render = nprop.getRenderer();
                    List pads = inter.getPadCand();
                    int numCand = pads.size();
                    Intersection.PadVal winner = null;
                    for (int i = 0; i < numCand; ++i) {
                        Intersection.PadVal pad = (Intersection.PadVal)pads.get(i);
                        if (!pad.okStart || !this.sourcePadIsClear(genome, id, pad.padNum, render.sharedPadNamespaces()) || atSubsetLayer && !this.sourcePadIsClear(rootParent, id, pad.padNum, render.sharedPadNamespaces()) || winner != null && !(winner.distance > pad.distance)) continue;
                        winner = pad;
                    }
                    if (winner == null) {
                        return 0;
                    }
                    Vector2D loff = render.getLaunchPadOffset(winner.padNum, genome.getNode(id), lo, SUPanel.this.myGenomePre_.getFontRenderContext());
                    Point2D cent = loff.add(nprop.getLocation());
                    x = (int)cent.getX();
                    y = (int)cent.getY();
                    recenter = false;
                    lc.srcID = id;
                }
                if (gotRegions) {
                    Map okstm = this.pendingAdd_.getOKSrcTrgMap();
                    if (okstm != null) {
                        Set okTargs = (Set)okstm.get(lc.srcID);
                        if (okTargs == null) {
                            return 0;
                        }
                        SUPanel.this.myGenomePre_.setTargets(okTargs);
                    }
                    SUPanel.this.myGenomePre_.clearRootOverlays();
                }
                lc.source = inter;
                lc.buildState = 1;
                if (recenter) {
                    x = (int)((double)Math.round((double)x / 10.0) * 10.0);
                    y = (int)((double)Math.round((double)y / 10.0) * 10.0);
                }
                lc.points.add(new Point(x, y));
                SUPanel.this.myGenomePre_.setFloater(lc.points);
                return 1;
            }
            if (lc.buildState == 1) {
                Map okstm;
                if (inter == null) {
                    x = (int)((double)Math.round((double)x / 10.0) * 10.0);
                    y = (int)((double)Math.round((double)y / 10.0) * 10.0);
                    lc.points.add(new Point(x, y));
                    return 1;
                }
                sub = inter.getSubID();
                if (sub == null || !(sub instanceof Intersection.PadVal)) {
                    return 0;
                }
                id = inter.getObjectID();
                INodeRenderer render = lo.getNodeProperties(id).getRenderer();
                List pads = inter.getPadCand();
                int numCand = pads.size();
                Intersection.PadVal winner = null;
                for (int i = 0; i < numCand; ++i) {
                    Intersection.PadVal pad = (Intersection.PadVal)pads.get(i);
                    if (!pad.okEnd || !this.targPadIsClear(genome, id, pad.padNum, render.sharedPadNamespaces()) || atSubsetLayer && !this.targPadIsClear(rootParent, id, pad.padNum, render.sharedPadNamespaces()) || winner != null && !(winner.distance > pad.distance)) continue;
                    winner = pad;
                }
                if (winner == null) {
                    return 0;
                }
                if (lc.points.size() == 1 && lc.source.getObjectID().equals(inter.getObjectID())) {
                    Point firstPt = (Point)lc.points.get(0);
                    if (Math.abs(checkPt.x - firstPt.x) <= 20 && Math.abs(checkPt.y - firstPt.y) <= 20) {
                        return 0;
                    }
                }
                ArrayList<Intersection.PadVal> onePad = new ArrayList<Intersection.PadVal>();
                onePad.add(winner);
                lc.target = new Intersection(inter.getObjectID(), onePad);
                if (gotRegions && (okstm = this.pendingAdd_.getOKSrcTrgMap()) != null) {
                    Set okTargs = (Set)okstm.get(lc.srcID);
                    if (okTargs == null) {
                        throw new IllegalStateException();
                    }
                    if (!okTargs.contains(inter.getObjectID())) {
                        return 0;
                    }
                }
                lc.buildState = 2;
                SUPanel.this.myGenomePre_.setFloater(null);
                return 1;
            }
            return 0;
        }
    }

    private abstract class LinkManipulatorHandler
    extends ModeHandler {
        protected Intersection currentRelocateObject_;

        private LinkManipulatorHandler() {
        }

        void cancelMode(Object args) {
            this.currentRelocateObject_ = null;
        }

        protected boolean sourcePadIsClear(Genome genome, String id, int padNum, boolean shared) {
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage lnk = (Linkage)lit.next();
                if (lnk.getSource().equals(id)) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString("addLink.onlyOneSourcePad"), rMan.getString("addLink.placementErrorTitle"), 0);
                    return false;
                }
                if (!shared || !lnk.getTarget().equals(id) || lnk.getLandingPad() != padNum) continue;
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString("addLink.cannotShareSourcePad"), rMan.getString("addLink.placementErrorTitle"), 0);
                return false;
            }
            return true;
        }

        protected boolean targPadIsClear(Genome genome, String id, int padNum, boolean shared) {
            if (!shared) {
                return true;
            }
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage lnk = (Linkage)lit.next();
                if (!lnk.getSource().equals(id) || lnk.getLaunchPad() != padNum) continue;
                return false;
            }
            return true;
        }
    }

    private class ChangeGroupMembershipHandler
    extends ModeHandler {
        private Intersection inter_;
        private ModificationCommands pending_;

        private ChangeGroupMembershipHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            boolean done = false;
            try {
                done = this.doNodeRegionChange(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (!done) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    this.inter_ = null;
                    this.pending_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                    SUPanel.this.repaint();
                }
            }
        }

        void cancelMode(Object args) {
            this.inter_ = null;
            this.pending_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.inter_ = (Intersection)args;
            this.pending_ = new ModificationCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            SUPanel.this.cView_.disableControls(2, false);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 24;
        }

        private boolean doNodeRegionChange(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            int genCount;
            x = UiUtil.forceToGridValueInt(x, 10.0);
            y = UiUtil.forceToGridValueInt(y, 10.0);
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            GenomeInstance gi = (GenomeInstance)db.getGenome(genomeKey);
            GenomeInstance parent = gi.getVfgParent();
            Intersection newReg = parent != null ? SUPanel.this.myGenomePre_.selectGroupFromParent(x, y, genomeKey, layoutKey, pixDiam) : SUPanel.this.myGenomePre_.selectGroupForRootInstance(x, y, genomeKey, layoutKey, pixDiam);
            if (newReg == null) {
                return false;
            }
            String groupID = newReg.getObjectID();
            String baseGrpID = Group.getBaseID(groupID);
            String inherit = Group.buildInheritedID(baseGrpID, genCount = gi.getGeneration());
            Group intersectGroup = gi.getGroup(inherit);
            if (intersectGroup == null) {
                return false;
            }
            boolean changeViz = false;
            if (this.pending_.inModuleAttachedToGroup(this.inter_.getObjectID(), gi)) {
                BlackHoleResults bhr = SUPanel.this.droppingIntoABlackHole(x, y, genomeKey, layoutKey, false);
                if (bhr.intoABlackHole) {
                    ResourceManager rMan = ResourceManager.getManager();
                    String message = UiUtil.convertMessageToHtml(rMan.getString("intoBlackHole.resetVizMoved"));
                    int changeVizVal = JOptionPane.showConfirmDialog(SUPanel.this.parent_, message, rMan.getString("intoBlackHole.resetVizTitle"), 1);
                    if (changeVizVal == 2) {
                        return false;
                    }
                    boolean bl = changeViz = changeVizVal == 0;
                }
            }
            if (changeViz) {
                NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                noc.setSliderValue(50);
            }
            return this.pending_.changeNodeRegion(this.inter_.getObjectID(), x, y, newReg.getObjectID(), layout, gi, SUPanel.this.myGenomePre_.getFontRenderContext());
        }
    }

    private class AddSubGroupHandler
    extends ModeHandler {
        private AddCommands pendingAdd_;

        private AddSubGroupHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            boolean done = false;
            try {
                done = this.doSubGroupAdd(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_);
            }
            finally {
                SUPanel.this.currentMode_ = 0;
                SUPanel.this.cView_.enableControls();
                SUPanel.this.cursorMgr_.showDefaultCursor();
            }
            if (!done) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = (AddCommands)args;
            SUPanel.this.cView_.disableControls(2, false);
            return 14;
        }

        private boolean doSubGroupAdd(int x, int y, String genomeKey, String layoutKey) {
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            this.pendingAdd_.locateNewSubGroup(x, y, layoutKey, genomeKey);
            return true;
        }
    }

    private class AddNoteHandler
    extends ModeHandler {
        private AddCommands.NoteCandidate ntCand_;
        private AddCommands pendingAdd_;

        private AddNoteHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            boolean done = false;
            try {
                done = this.doNoteAdd(pt.x, pt.y);
            }
            finally {
                SUPanel.this.currentMode_ = 0;
                SUPanel.this.myGenomePre_.setFloater(null);
                this.ntCand_ = null;
                SUPanel.this.cView_.enableControls();
                SUPanel.this.cursorMgr_.showDefaultCursor();
            }
            if (!done) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.ntCand_ = null;
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            this.ntCand_ = this.pendingAdd_.addNewNoteToGenome(SUPanel.this.genomeKey_, SUPanel.this.layout_);
            if (this.ntCand_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.cView_.disableControls(2, false);
            String noteID = this.ntCand_.newNote.getID();
            SUPanel.this.myGenomePre_.setFloater(this.ntCand_.newNote);
            Layout flay = SUPanel.this.myGenomePre_.getFloaterLayout();
            NoteProperties nprop = new NoteProperties(flay, noteID, this.ntCand_.newNoteColor, 0.0, 0.0);
            if (this.ntCand_.newNoteFont != null) {
                nprop.setFontOverride(this.ntCand_.newNoteFont);
            }
            flay.setNoteProperties(noteID, nprop);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 13;
        }

        private boolean doNoteAdd(int x, int y) {
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            this.pendingAdd_.locateNewNote(this.ntCand_, x, y);
            return true;
        }
    }

    private class AddExtraProxyNodeHandler
    extends ModeHandler {
        private AddCommands pendingAdd_;

        private AddExtraProxyNodeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 2;
            try {
                result = this.doExtraProxyNodeAdd(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                SUPanel.this.currentMode_ = 0;
                SUPanel.this.cView_.enableControls();
                SUPanel.this.cursorMgr_.showDefaultCursor();
            }
            if (result == 3 || result == 2) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (!(genome instanceof DynamicGenomeInstance)) {
                return 0;
            }
            SUPanel.this.cView_.disableControls(2, false);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 18;
        }

        private int doExtraProxyNodeAdd(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            GenomeInstance parent;
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            if (genome instanceof DynamicGenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                String proxID;
                DynamicInstanceProxy prox;
                List itemList;
                Layout layout = db.getLayout(layoutKey);
                Intersection inter = new IntersectionChooser(true, genomeKey, layout).intersectionRanker(itemList = SUPanel.this.myGenomePre_.selectFromParent(x, y, genomeKey, layoutKey, pixDiam));
                if (inter == null) {
                    return 2;
                }
                String startID = inter.getObjectID();
                NodeInstance subsetNode = (NodeInstance)parent.getNode(startID);
                if (subsetNode == null) {
                    return 2;
                }
                if (parent instanceof DynamicGenomeInstance) {
                    String parentProxID = ((DynamicGenomeInstance)parent).getProxyID();
                    DynamicInstanceProxy parProx = db.getDynamicProxy(parentProxID);
                    if (parProx.getGroupForExtraNode(startID) == null) {
                        return 2;
                    }
                } else {
                    Group nodeGroup = parent.getGroupForNode(startID, 0);
                    if (nodeGroup != null) {
                        int generation = parent.getGeneration();
                        String myID = Group.buildInheritedID(nodeGroup.getID(), generation + 1);
                        Group myGroup = ((GenomeInstance)genome).getGroup(myID);
                        if (myGroup != null) {
                            String activeID = myGroup.getActiveSubset();
                            if (activeID == null) {
                                return 2;
                            }
                            String mysubID = Group.buildInheritedID(activeID, generation);
                            if (parent.getGroup(mysubID).isInGroup(startID, parent)) {
                                return 2;
                            }
                        }
                    }
                }
                if ((prox = db.getDynamicProxy(proxID = ((DynamicGenomeInstance)genome).getProxyID())).hasAddedNode(startID)) {
                    return 3;
                }
                String useGroupID = null;
                if (parent instanceof DynamicGenomeInstance) {
                    String parentProxID = ((DynamicGenomeInstance)parent).getProxyID();
                    DynamicInstanceProxy parProx = db.getDynamicProxy(parentProxID);
                    useGroupID = parProx.getGroupForExtraNode(startID);
                } else {
                    Group parGroup = parent.getGroupForNode(startID, 2);
                    if (parGroup != null) {
                        useGroupID = parGroup.getID();
                    }
                    ObjChoiceContent defObj = null;
                    Iterator grit = parent.getGroupIterator();
                    ArrayList<ObjChoiceContent> choices = new ArrayList<ObjChoiceContent>();
                    while (grit.hasNext()) {
                        Group group = (Group)grit.next();
                        String groupID = group.getID();
                        ObjChoiceContent ccont = new ObjChoiceContent(group.getDisplayName(), Group.getBaseID(groupID));
                        choices.add(ccont);
                        if (!groupID.equals(useGroupID)) continue;
                        defObj = ccont;
                    }
                    ResourceManager rMan = ResourceManager.getManager();
                    Object piggyGroup = JOptionPane.showInputDialog(SUPanel.this.parent_, rMan.getString("addExtraProxyNode.PiggyBackGroup"), rMan.getString("addExtraProxyNode.Title"), 3, null, choices.toArray(), defObj == null ? (ObjChoiceContent)choices.get(0) : defObj);
                    if (piggyGroup == null) {
                        return 1;
                    }
                    useGroupID = ((ObjChoiceContent)piggyGroup).val;
                }
                this.pendingAdd_.addExtraProxyNode(genomeKey, subsetNode, useGroupID);
                return 0;
            }
            throw new IllegalArgumentException();
        }
    }

    private class AddToNetModuleHandler
    extends ModeHandler {
        private AddCommands.NetModuleToModify currentModuleToModify_;
        private AddCommands pendingAdd_;

        private AddToNetModuleHandler() {
        }

        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            int result = this.continueNetModuleAdding(pt.x, pt.y, this.currentModuleToModify_, pixDiam);
            if (result == 0) {
                SUPanel.this.giveErrorFeedback();
            } else {
                int state = this.currentModuleToModify_.buildState;
                if (state == 2) {
                    UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.addToNetworkModule");
                    this.pendingAdd_.finishAddRegionsToNetworkModule(support, this.currentModuleToModify_, SUPanel.this.myGenomePre_.getFontRenderContext());
                    support.finish();
                    this.currentModuleToModify_.reset();
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.currentModuleToModify_ = null;
            this.pendingAdd_ = null;
        }

        Object getFloater(int x, int y) {
            return this.currentModuleToModify_.getCurrentRect(x, y);
        }

        Color getFloaterColor() {
            return this.currentModuleToModify_.color;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode(2);
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            String moduleID = args == null ? (String)((SUPanel)SUPanel.this).currentNetMods_.set.iterator().next() : (String)args;
            this.currentModuleToModify_ = this.pendingAdd_.beginAddRegionsToNetworkModule(SUPanel.this.genomeKey_, SUPanel.this.layout_, SUPanel.this.currentOverlay_, moduleID);
            if (this.currentModuleToModify_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.cView_.disableControls(26, false);
            SUPanel.this.myGenomePre_.setFloater(null);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 4;
        }

        int convertToMode(String arg) {
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            String moduleID = arg;
            this.currentModuleToModify_ = this.pendingAdd_.beginAddRegionsToNetworkModule(SUPanel.this.genomeKey_, SUPanel.this.layout_, SUPanel.this.currentOverlay_, moduleID);
            if (this.currentModuleToModify_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.cView_.enableModals(2);
            SUPanel.this.cView_.enableControls();
            SUPanel.this.cView_.disableControls(26, false);
            return 4;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int continueNetModuleAdding(int x, int y, AddCommands.NetModuleToModify nmtm, double pixDiam) {
            x = UiUtil.forceToGridValueInt(x, 10.0);
            y = UiUtil.forceToGridValueInt(y, 10.0);
            if (nmtm.buildState == 2) {
                throw new IllegalStateException();
            }
            if (nmtm.buildState == 0) {
                String checkGroup;
                Intersection group;
                if (nmtm.displayType == 2) {
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(SUPanel.this.layout_);
                    List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, SUPanel.this.genomeKey_, layout, pixDiam, true, false, SUPanel.this);
                    Intersection.AugmentedIntersection ai = new IntersectionChooser(true, SUPanel.this.genomeKey_, layout).selectionRanker(augs);
                    if (ai == null || ai.intersect == null) {
                        return 0;
                    }
                    String objID = ai.intersect.getObjectID();
                    Genome gen = db.getGenome(SUPanel.this.genomeKey_);
                    Node node = gen.getNode(objID);
                    if (node == null) return 0;
                    if (nmtm.attachedGroup != null) {
                        GenomeInstance gi = (GenomeInstance)gen;
                        Group group2 = gi.getGroup(nmtm.attachedGroup);
                        if (!group2.isInGroup(objID, gi)) return 0;
                        nmtm.nodes.add(objID);
                    } else {
                        nmtm.nodes.add(objID);
                    }
                    nmtm.buildState = 2;
                    return 1;
                }
                if (nmtm.attachedGroup != null && (group = SUPanel.this.myGenomePre_.selectGroup(x, y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam)) != null && !nmtm.attachedGroup.equals(checkGroup = group.getObjectID())) {
                    return 0;
                }
                nmtm.points.add(new Point(x, y));
                nmtm.buildState = 1;
                SUPanel.this.myGenomePre_.setFloater(new Rectangle2D.Double(x, y, 0.0, 0.0), nmtm.color);
                return 1;
            }
            if (nmtm.buildState != 1) throw new IllegalStateException();
            Rectangle2D nextRect = nmtm.getCurrentRect(x, y);
            if (nextRect.getHeight() == 0.0 || nextRect.getWidth() == 0.0) {
                return 0;
            }
            Rectangle rect = new Rectangle((int)nextRect.getX(), (int)nextRect.getY(), (int)nextRect.getWidth(), (int)nextRect.getHeight());
            FreezeDriedOverlayOracle fdoo = new FreezeDriedOverlayOracle(null, null, 0, null);
            List intersects = SUPanel.this.myGenomePre_.intersectItems(rect, SUPanel.this.genomeKey_, SUPanel.this.layout_, fdoo);
            Genome gen = Database.getDB().getGenome(SUPanel.this.genomeKey_);
            int numInter = intersects.size();
            for (int i = 0; i < numInter; ++i) {
                Intersection inter = (Intersection)intersects.get(i);
                String iID = inter.getObjectID();
                Node node = gen.getNode(iID);
                if (node == null) continue;
                if (nmtm.attachedGroup != null) {
                    GenomeInstance gi = (GenomeInstance)gen;
                    Group group = gi.getGroup(nmtm.attachedGroup);
                    if (!group.isInGroup(iID, gi)) continue;
                    nmtm.nodes.add(iID);
                    continue;
                }
                nmtm.nodes.add(iID);
            }
            nmtm.allRects.add(nextRect);
            nmtm.buildState = 2;
            SUPanel.this.myGenomePre_.setFloater(null);
            return 1;
        }
    }

    private class RelocateNetModSourceHandler
    extends ModeHandler {
        private Intersection currentRelocateObject_;

        private RelocateNetModSourceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateSource(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        void cancelMode(Object args) {
            this.currentRelocateObject_ = null;
        }

        int setToMode(Object args) {
            GenomeInstance parent;
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 23;
        }

        private int relocateSource(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            x = UiUtil.forceToGridValueInt(x, 10.0);
            y = UiUtil.forceToGridValueInt(y, 10.0);
            Intersection intersected = SUPanel.this.myGenomePre_.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, SUPanel.this, 1);
            if (intersected == null) {
                return 0;
            }
            String id = intersected.getObjectID();
            NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
            NetworkOverlay novr = owner.getNetworkOverlay(SUPanel.this.currentOverlay_);
            NetModule nm = novr.getModule(id);
            if (nm == null) {
                return 0;
            }
            NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)intersected.getSubID();
            if (ei == null) {
                return 0;
            }
            if (ei.type != 2) {
                return 0;
            }
            Point2D padPt = (Point2D)ei.intersectPt.clone();
            UiUtil.forceToGrid(padPt, 10.0);
            Vector2D toSide = ei.padNorm.scaled(-1.0);
            String treeID = this.currentRelocateObject_.getObjectID();
            NetModuleLinkageProperties nmlp = layout.getNetOverlayProperties(SUPanel.this.currentOverlay_).getNetModuleLinkagePropertiesFromTreeID(treeID);
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            LinkSegmentID[] linkIDs = this.currentRelocateObject_.segmentIDsFromIntersect();
            Set throughSeg = nmlp.resolveLinkagesThroughSegment(linkIDs[0], genome);
            int totalLinks = nmlp.getLinkageList().size();
            if (throughSeg.size() != totalLinks) {
                return 0;
            }
            String myLinkId = (String)throughSeg.iterator().next();
            NetModuleLinkage myLink = novr.getLinkage(myLinkId);
            if (!myLink.getSource().equals(id)) {
                return 0;
            }
            Iterator tsit = throughSeg.iterator();
            while (tsit.hasNext()) {
                Point2D targPt;
                String linkID = (String)tsit.next();
                if (!novr.linkIsFeedback(linkID) || !padPt.equals(targPt = nmlp.getTargetEnd(linkID, 0.0))) continue;
                return 0;
            }
            UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.changeModuleLinkSource");
            Layout.PropChange lpc = layout.changeNetModuleSource(SUPanel.this.currentOverlay_, treeID, padPt, toSide);
            if (lpc != null) {
                PropChangeCmd mov = new PropChangeCmd(lpc);
                support.addEdit(mov);
                support.addEvent(new LayoutChangeEvent(layoutKey, 1));
                support.finish();
                return 1;
            }
            return 0;
        }
    }

    private class RelocateNetModTargetHandler
    extends ModeHandler {
        private Intersection currentRelocateObject_;

        private RelocateNetModTargetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateTarget(pt.x, pt.y, this.currentRelocateObject_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        void cancelMode(Object args) {
            this.currentRelocateObject_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 22;
        }

        private int relocateTarget(int x, int y, Intersection cro, String genomeKey, String layoutKey, double pixDiam) {
            Point2D startPoint;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            x = UiUtil.forceToGridValueInt(x, 10.0);
            y = UiUtil.forceToGridValueInt(y, 10.0);
            Intersection intersected = SUPanel.this.myGenomePre_.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, SUPanel.this, 1);
            if (intersected == null) {
                return 0;
            }
            String id = intersected.getObjectID();
            NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
            NetworkOverlay novr = owner.getNetworkOverlay(SUPanel.this.currentOverlay_);
            NetModule nm = novr.getModule(id);
            if (nm == null) {
                return 0;
            }
            NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)intersected.getSubID();
            if (ei == null) {
                return 0;
            }
            if (ei.type != 2) {
                return 0;
            }
            Point2D padPt = (Point2D)ei.intersectPt.clone();
            UiUtil.forceToGrid(padPt, 10.0);
            Vector2D toSide = ei.padNorm.scaled(-1.0);
            String treeID = this.currentRelocateObject_.getObjectID();
            NetModuleLinkageProperties nmlp = layout.getNetOverlayProperties(SUPanel.this.currentOverlay_).getNetModuleLinkagePropertiesFromTreeID(treeID);
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            LinkSegmentID[] linkIDs = this.currentRelocateObject_.segmentIDsFromIntersect();
            Set throughSeg = nmlp.resolveLinkagesThroughSegment(linkIDs[0], genome);
            if (throughSeg.size() != 1) {
                return 0;
            }
            String myLinkId = (String)throughSeg.iterator().next();
            NetModuleLinkage myLink = novr.getLinkage(myLinkId);
            if (!myLink.getTarget().equals(id)) {
                return 0;
            }
            if (novr.linkIsFeedback(myLinkId) && padPt.equals(startPoint = nmlp.getSourceStart(0.0))) {
                return 0;
            }
            UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.changeModuleLinkTarget");
            Layout.PropChange lpc = layout.changeNetModuleTarget(SUPanel.this.currentOverlay_, myLinkId, padPt, toSide);
            if (lpc != null) {
                PropChangeCmd mov = new PropChangeCmd(lpc);
                support.addEdit(mov);
                support.addEvent(new LayoutChangeEvent(layoutKey, 1));
                support.finish();
                return 1;
            }
            return 0;
        }
    }

    private class RelocateNetModLinkHandler
    extends ModeHandler {
        private Intersection currentRelocateObject_;
        private AddCommands pendingAdd_;

        private RelocateNetModLinkHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 3;
            try {
                result = this.relocateLink(pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.giveErrorFeedback();
                } else {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                    this.currentRelocateObject_ = null;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            SUPanel.this.repaint();
        }

        void cancelMode(Object args) {
            this.currentRelocateObject_ = null;
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            Database db = Database.getDB();
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(2, false);
            this.currentRelocateObject_ = (Intersection)args;
            SUPanel.this.cursorMgr_.showModeCursor();
            return 21;
        }

        private int relocateLink(int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            Point2D sourcePt;
            Database db = Database.getDB();
            Layout layout = db.getLayout(layoutKey);
            Genome genome = db.getGenome(genomeKey);
            x = UiUtil.forceToGridValueInt(x, 10.0);
            y = UiUtil.forceToGridValueInt(y, 10.0);
            boolean gotAModule = true;
            Intersection intersected = SUPanel.this.myGenomePre_.intersectANetModuleElement(x, y, genomeKey, layout, pixDiam, SUPanel.this, 1);
            if (intersected == null) {
                gotAModule = false;
                intersected = SUPanel.this.myGenomePre_.intersectNetModuleLinks(x, y, genomeKey, layout, SUPanel.this, pixDiam);
            }
            if (intersected == null) {
                return 0;
            }
            NetOverlayProperties nop = layout.getNetOverlayProperties(SUPanel.this.currentOverlay_);
            String movingTreeID = this.currentRelocateObject_.getObjectID();
            NetModuleLinkageProperties movLp = nop.getNetModuleLinkagePropertiesFromTreeID(movingTreeID);
            String modSource = movLp.getSourceTag();
            LinkSegmentID[] moveIDs = this.currentRelocateObject_.segmentIDsFromIntersect();
            Set resolved = movLp.resolveLinkagesThroughSegment(moveIDs[0], genome);
            String targetID = intersected.getObjectID();
            Point2D padPt = null;
            Vector2D toSide = null;
            LinkSegmentID segID = null;
            boolean jumpingTrees = false;
            if (gotAModule) {
                if (!targetID.equals(modSource)) {
                    return 0;
                }
                NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)intersected.getSubID();
                if (ei == null) {
                    return 0;
                }
                if (ei.type != 2) {
                    return 0;
                }
                if (moveIDs[0].isDirect() || moveIDs[0].isForStartDrop()) {
                    return 0;
                }
                padPt = (Point2D)ei.intersectPt.clone();
                UiUtil.forceToGrid(padPt, 10.0);
                sourcePt = padPt;
                toSide = ei.padNorm.scaled(-1.0);
            } else {
                LinkSegmentID[] segIDs;
                NetModuleLinkageProperties targlp = nop.getNetModuleLinkagePropertiesFromTreeID(targetID);
                String targSource = targlp.getSourceTag();
                if (!targSource.equals(modSource)) {
                    return 0;
                }
                if (!targetID.equals(movingTreeID)) {
                    jumpingTrees = true;
                }
                if (!(segID = (segIDs = intersected.segmentIDsFromIntersect())[0]).isTaggedWithEndpoint()) {
                    return 0;
                }
                sourcePt = targlp.getSourceStart(0.0);
            }
            NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
            NetworkOverlay novr = owner.getNetworkOverlay(SUPanel.this.currentOverlay_);
            NetModuleLinkageProperties nmlp = movLp;
            Iterator tsit = resolved.iterator();
            while (tsit.hasNext()) {
                Point2D targPt;
                String linkID = (String)tsit.next();
                if (!novr.linkIsFeedback(linkID) || !sourcePt.equals(targPt = nmlp.getTargetEnd(linkID, 0.0))) continue;
                return 0;
            }
            Layout.PropChange[] lpcm = null;
            if (gotAModule) {
                lpcm = layout.supportModuleLinkTreeSwitch(moveIDs[0], resolved, SUPanel.this.currentOverlay_, movingTreeID, null, null, genome, SUPanel.this.myGenomePre_.getFontRenderContext(), padPt, toSide);
            } else if (jumpingTrees) {
                lpcm = layout.supportModuleLinkTreeSwitch(moveIDs[0], resolved, SUPanel.this.currentOverlay_, movingTreeID, targetID, segID, genome, SUPanel.this.myGenomePre_.getFontRenderContext(), null, null);
            } else {
                Layout.PropChange lpc = layout.relocateSegmentOnTree(movLp, segID, moveIDs[0], SUPanel.this.currentOverlay_);
                if (lpc != null) {
                    lpcm = new Layout.PropChange[]{lpc};
                }
            }
            if (lpcm != null && lpcm.length != 0) {
                UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.linkrelocate");
                PropChangeCmd mov = new PropChangeCmd(lpcm);
                support.addEdit(mov);
                support.addEvent(new LayoutChangeEvent(layoutKey, 1));
                support.finish();
                return 1;
            }
            return 0;
        }
    }

    private class DrawNetModuleLinkHandler
    extends ModeHandler {
        private AddCommands.NetModuleLinkCandidate currentModuleLinkCandidate_;
        private AddCommands pendingAdd_;

        private DrawNetModuleLinkHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            Point submit = null;
            if (this.currentModuleLinkCandidate_.buildState == 1 && isShifted) {
                int x = UiUtil.forceToGridValueInt(pt.x, 10.0);
                int y = UiUtil.forceToGridValueInt(pt.y, 10.0);
                submit = new Point(x, y);
                ArrayList ptList = this.currentModuleLinkCandidate_.points;
                Point2D lastPoint = (Point2D)ptList.get(ptList.size() - 1);
                Vector2D vec = new Vector2D(lastPoint, submit).canonical();
                Point2D canonicalPt = vec.add(lastPoint);
                submit = new Point((int)canonicalPt.getX(), (int)canonicalPt.getY());
            } else {
                submit = pt;
            }
            int result = this.growOrFinishLink(submit.x, submit.y, this.currentModuleLinkCandidate_, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            if (result == 0) {
                SUPanel.this.giveErrorFeedback();
            } else {
                int state = this.currentModuleLinkCandidate_.buildState;
                if (state == 2) {
                    try {
                        FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                        this.pendingAdd_.finishDrawNetworkModuleLink(this.currentModuleLinkCandidate_, frc);
                    }
                    finally {
                        SUPanel.this.currentMode_ = 0;
                        SUPanel.this.showBubbles_ = SUPanel.this.pushedShowBubbles_;
                        SUPanel.this.cView_.enableControls();
                        SUPanel.this.myGenomePre_.setFloater(null);
                        SUPanel.this.myGenomePre_.clearTargets();
                        SUPanel.this.myGenomePre_.clearRootOverlays();
                        SUPanel.this.cursorMgr_.showDefaultCursor();
                    }
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.currentModuleLinkCandidate_ = null;
            this.pendingAdd_ = null;
        }

        Object getFloater(int x, int y) {
            if (this.currentModuleLinkCandidate_.buildState == 1) {
                return this.currentModuleLinkCandidate_.points;
            }
            return null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            this.currentModuleLinkCandidate_ = this.pendingAdd_.beginDrawNetworkModuleLink(SUPanel.this.genomeKey_, SUPanel.this.layout_, SUPanel.this.currentOverlay_);
            if (this.currentModuleLinkCandidate_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.pushedShowBubbles_ = SUPanel.this.showBubbles_;
            SUPanel.this.showBubbles_ = true;
            SUPanel.this.cView_.disableControls(18, false);
            SUPanel.this.myGenomePre_.setFloater(null);
            SUPanel.this.cursorMgr_.showModeCursor();
            SUPanel.this.repaint();
            return 3;
        }

        private int growOrFinishLink(int x, int y, AddCommands.NetModuleLinkCandidate lc, String genomeKey, String layoutKey, double pixDiam) {
            Database db = Database.getDB();
            if (lc.buildState == 2) {
                throw new IllegalStateException();
            }
            int checkX = UiUtil.forceToGridValueInt(x, 10.0);
            int checkY = UiUtil.forceToGridValueInt(y, 10.0);
            Point checkPt = new Point(checkX, checkY);
            Iterator pit = lc.points.iterator();
            while (pit.hasNext()) {
                Point pt = (Point)pit.next();
                if (!pt.equals(checkPt)) continue;
                return 0;
            }
            Layout lo = db.getLayout(layoutKey);
            boolean gotAModule = true;
            Intersection intersected = SUPanel.this.myGenomePre_.intersectANetModuleElement(x, y, genomeKey, lo, pixDiam, SUPanel.this, 1);
            if (intersected == null) {
                gotAModule = false;
                intersected = SUPanel.this.myGenomePre_.intersectNetModuleLinks(x, y, genomeKey, lo, SUPanel.this, pixDiam);
            }
            if (lc.buildState == 0) {
                if (intersected == null) {
                    return 0;
                }
                Object sub = intersected.getSubID();
                if (sub == null) {
                    return 0;
                }
                String id = intersected.getObjectID();
                if (!gotAModule) {
                    LinkSegmentID[] segIDs = intersected.segmentIDsFromIntersect();
                    if (!segIDs[0].isTaggedWithEndpoint()) {
                        return 0;
                    }
                    NetOverlayProperties nop = lo.getNetOverlayProperties(SUPanel.this.currentOverlay_);
                    NetModuleLinkageProperties currNmlp = nop.getNetModuleLinkagePropertiesFromTreeID(id);
                    lc.srcMod = currNmlp.getSourceTag();
                } else {
                    NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)intersected.getSubID();
                    if (ei.type != 2) {
                        return 0;
                    }
                    x = (int)ei.intersectPt.getX();
                    y = (int)ei.intersectPt.getY();
                    lc.srcMod = id;
                }
                lc.source = intersected;
                lc.srcIsModule = gotAModule;
                lc.buildState = 1;
                x = UiUtil.forceToGridValueInt(x, 10.0);
                y = UiUtil.forceToGridValueInt(y, 10.0);
                lc.points.add(new Point(x, y));
                SUPanel.this.myGenomePre_.setFloater(lc.points);
                return 1;
            }
            if (lc.buildState == 1) {
                if (intersected == null) {
                    x = UiUtil.forceToGridValueInt(x, 10.0);
                    y = UiUtil.forceToGridValueInt(y, 10.0);
                    lc.points.add(new Point(x, y));
                    return 1;
                }
                if (!gotAModule) {
                    return 0;
                }
                NetModuleFree.IntersectionExtraInfo ei = (NetModuleFree.IntersectionExtraInfo)intersected.getSubID();
                if (ei.type != 2) {
                    return 0;
                }
                x = (int)ei.intersectPt.getX();
                y = (int)ei.intersectPt.getY();
                x = UiUtil.forceToGridValueInt(x, 10.0);
                y = UiUtil.forceToGridValueInt(y, 10.0);
                Point padPt = new Point(x, y);
                if (lc.srcMod.equals(intersected.getObjectID())) {
                    Point srcPad;
                    if (lc.srcIsModule) {
                        srcPad = (Point)lc.points.get(0);
                    } else {
                        NetOverlayProperties nop = lo.getNetOverlayProperties(SUPanel.this.currentOverlay_);
                        String treeID = lc.source.getObjectID();
                        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
                        Point2D startPt = nmlp.getSourceStart(0.0);
                        srcPad = new Point((int)startPt.getX(), (int)startPt.getY());
                    }
                    if (srcPad.equals(padPt)) {
                        return 0;
                    }
                }
                lc.points.add(padPt);
                lc.trgMod = intersected.getObjectID();
                lc.target = intersected;
                lc.buildState = 2;
                SUPanel.this.myGenomePre_.setFloater(null);
                return 1;
            }
            return 0;
        }
    }

    private class DrawNetModuleHandler
    extends ModeHandler {
        private AddCommands.NetModuleCandidate currentModuleCandidate_;
        private AddCommands pendingAdd_;

        private DrawNetModuleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            Database db = Database.getDB();
            int result = this.continueNetModuleDrawing(pt.x, pt.y, this.currentModuleCandidate_, pixDiam);
            if (result == 0) {
                SUPanel.this.giveErrorFeedback();
            } else {
                int state = this.currentModuleCandidate_.buildState;
                if (state == 2) {
                    boolean timeToBail = true;
                    try {
                        UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.newNetworkModule");
                        FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                        String newMod = this.pendingAdd_.drawNetworkModuleFinish(support, this.currentModuleCandidate_, SUPanel.this.currentOverlay_, frc);
                        if (newMod != null) {
                            NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                            noc.addToCurrentModules(newMod, support);
                            support.finish();
                            if (this.currentModuleCandidate_.keepGoing) {
                                SUPanel.this.currentMode_ = 0;
                                this.currentModuleCandidate_ = null;
                                if (SUPanel.this.convertToAddRegionsToNetworkModule(newMod)) {
                                    timeToBail = false;
                                }
                            }
                        }
                    }
                    finally {
                        if (timeToBail) {
                            SUPanel.this.currentMode_ = 0;
                            this.currentModuleCandidate_ = null;
                            SUPanel.this.cView_.enableControls();
                            SUPanel.this.myGenomePre_.setFloater(null);
                            SUPanel.this.cursorMgr_.showDefaultCursor();
                        }
                    }
                }
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.currentModuleCandidate_ = null;
            this.pendingAdd_ = null;
        }

        Object getFloater(int x, int y) {
            return this.currentModuleCandidate_.getCurrentRect(x, y);
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            this.currentModuleCandidate_ = this.pendingAdd_.beginDrawNetworkModule(SUPanel.this.genomeKey_, SUPanel.this.layout_, SUPanel.this.currentOverlay_);
            if (this.currentModuleCandidate_ == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.currentMode_ = 2;
            SUPanel.this.cView_.disableControls(18, false);
            SUPanel.this.myGenomePre_.setFloater(null);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int continueNetModuleDrawing(int x, int y, AddCommands.NetModuleCandidate nmc, double pixDiam) {
            Intersection group;
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            if (nmc.buildState == 2) {
                throw new IllegalStateException();
            }
            if (nmc.buildState == 0) {
                Intersection group2;
                if (nmc.attachToGroup && (group2 = SUPanel.this.myGenomePre_.selectGroup(x, y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam)) != null) {
                    nmc.attachedGroup = group2.getObjectID();
                }
                if (nmc.displayType == 2) {
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(SUPanel.this.layout_);
                    List augs = SUPanel.this.myGenomePre_.intersectItem(x, y, SUPanel.this.genomeKey_, layout, pixDiam, true, false, SUPanel.this);
                    Intersection.AugmentedIntersection ai = new IntersectionChooser(true, SUPanel.this.genomeKey_, layout).selectionRanker(augs);
                    if (ai == null || ai.intersect == null) {
                        return 0;
                    }
                    String objID = ai.intersect.getObjectID();
                    Genome gen = db.getGenome(SUPanel.this.genomeKey_);
                    Node node = gen.getNode(objID);
                    if (node == null) return 0;
                    if (nmc.attachedGroup != null) {
                        GenomeInstance gi = (GenomeInstance)gen;
                        Group group3 = gi.getGroup(nmc.attachedGroup);
                        if (!group3.isInGroup(objID, gi)) return 0;
                        nmc.nodes.add(objID);
                    } else {
                        nmc.nodes.add(objID);
                    }
                    nmc.buildState = 2;
                    return 1;
                }
                nmc.points.add(new Point(x, y));
                nmc.buildState = 1;
                SUPanel.this.myGenomePre_.setFloater(new Rectangle2D.Double(x, y, 0.0, 0.0));
                return 1;
            }
            if (nmc.buildState != 1) throw new IllegalStateException();
            Rectangle2D nextRect = nmc.getCurrentRect(x, y);
            if (nextRect.getHeight() == 0.0 || nextRect.getWidth() == 0.0) {
                return 0;
            }
            if (nmc.attachToGroup && (group = SUPanel.this.myGenomePre_.selectGroup(x, y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam)) != null) {
                String checkGroup = group.getObjectID();
                if (nmc.attachedGroup != null) {
                    if (!nmc.attachedGroup.equals(checkGroup)) {
                        return 0;
                    }
                } else {
                    nmc.attachedGroup = checkGroup;
                }
            }
            FreezeDriedOverlayOracle fdoo = new FreezeDriedOverlayOracle(null, null, 0, null);
            Rectangle rect = new Rectangle((int)nextRect.getX(), (int)nextRect.getY(), (int)nextRect.getWidth(), (int)nextRect.getHeight());
            List intersects = SUPanel.this.myGenomePre_.intersectItems(rect, SUPanel.this.genomeKey_, SUPanel.this.layout_, fdoo);
            Genome gen = Database.getDB().getGenome(SUPanel.this.genomeKey_);
            int numInter = intersects.size();
            for (int i = 0; i < numInter; ++i) {
                GenomeInstance gi;
                Intersection inter = (Intersection)intersects.get(i);
                String iID = inter.getObjectID();
                Node node = gen.getNode(iID);
                if (node == null) continue;
                if (nmc.attachedGroup != null) {
                    gi = (GenomeInstance)gen;
                    Group group4 = gi.getGroup(nmc.attachedGroup);
                    if (!group4.isInGroup(iID, gi)) continue;
                    nmc.nodes.add(iID);
                    continue;
                }
                if (nmc.attachToGroup) {
                    gi = (GenomeInstance)gen;
                    Group grp = gi.getGroupForNode(iID, 1);
                    if (grp != null) {
                        nmc.attachedGroup = grp.getID();
                    }
                    nmc.nodes.add(iID);
                    continue;
                }
                nmc.nodes.add(iID);
            }
            nmc.allRects.add(nextRect);
            nmc.buildState = 2;
            SUPanel.this.myGenomePre_.setFloater(null);
            return 1;
        }
    }

    private class DrawGroupHandler
    extends ModeHandler {
        private AddCommands pendingAdd_;

        private DrawGroupHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 2;
            try {
                result = this.doGroupDrawAdd(pt.x, pt.y, SUPanel.this.genomeKey_);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.currentMode_ = 0;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.myGenomePre_.setFloater(null);
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            if (result == 3 || result == 2) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.pendingAdd_ = null;
        }

        int setToMode(Object args) {
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            Group newGroup = null;
            if (genome instanceof GenomeInstance) {
                newGroup = this.pendingAdd_.drawGroupInInstance(SUPanel.this.genomeKey_, SUPanel.this.layout_);
            }
            if (newGroup == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            SUPanel.this.cView_.disableControls(2, false);
            SUPanel.this.myGenomePre_.setFloater(newGroup);
            Layout flay = SUPanel.this.myGenomePre_.getFloaterLayout();
            int order = flay.getTopGroupOrder() + 1;
            int groupCount = ((GenomeInstance)genome).groupCount();
            GroupProperties gprop = new GroupProperties(groupCount + 1, newGroup.getID(), new Point2D.Double(0.0, 0.0), order);
            flay.setGroupProperties(Group.getBaseID(newGroup.getID()), gprop);
            SUPanel.this.cursorMgr_.showModeCursor();
            return 5;
        }

        private int doGroupDrawAdd(int x, int y, String genomeKey) {
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            if (genome instanceof GenomeInstance && !this.pendingAdd_.drawGroupInInstanceFinish(x, y)) {
                return 3;
            }
            return 0;
        }
    }

    static class BlackHoleResults {
        boolean intoABlackHole;
        List modCandidates;

        BlackHoleResults() {
        }
    }

    private class AddNodeHandler
    extends ModeHandler {
        private boolean doGene_;
        private AddCommands pendingAdd_;
        private boolean pendingModAdd_;

        AddNodeHandler(boolean doGene) {
            this.doGene_ = doGene;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMouseClick(Point pt, boolean isShifted, double pixDiam) {
            int result = 2;
            try {
                result = this.doNodeAdd(this.doGene_, pt.x, pt.y, SUPanel.this.genomeKey_, SUPanel.this.layout_, pixDiam);
            }
            finally {
                if (result == 0) {
                    SUPanel.this.currentMode_ = 0;
                    this.pendingModAdd_ = false;
                    SUPanel.this.cView_.enableControls();
                    SUPanel.this.myGenomePre_.setFloater(null);
                    SUPanel.this.cursorMgr_.showDefaultCursor();
                }
            }
            if (result == 3 || result == 2) {
                SUPanel.this.giveErrorFeedback();
            } else {
                SUPanel.this.repaint();
            }
        }

        void cancelMode(Object args) {
            this.pendingAdd_ = null;
            this.pendingModAdd_ = false;
        }

        int setToMode(Object args) {
            Node newNode;
            AddCommands.NodeCandidate cand;
            SUPanel.this.cancelAddMode();
            this.pendingAdd_ = new AddCommands(SUPanel.this.parent_, SUPanel.this.undom_);
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            boolean addToModule = false;
            FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
            if (genome instanceof GenomeInstance) {
                NetModuleIntersector nmi = new NetModuleIntersector(genome, SUPanel.this.layout_);
                cand = this.pendingAdd_.drawNewNodeToInstance(this.doGene_, SUPanel.this.genomeKey_, SUPanel.this.layout_, nmi, SUPanel.this.currentOverlay_, ((SUPanel)SUPanel.this).currentNetMods_.set, frc);
            } else {
                cand = this.pendingAdd_.addNewNodeToRoot(this.doGene_, SUPanel.this.layout_, SUPanel.this.currentOverlay_, ((SUPanel)SUPanel.this).currentNetMods_.set);
            }
            if (cand == null) {
                newNode = null;
                addToModule = false;
            } else {
                newNode = cand.node;
                addToModule = cand.addToModule;
            }
            if (newNode == null) {
                this.pendingAdd_ = null;
                return 0;
            }
            this.pendingModAdd_ = addToModule;
            SUPanel.this.cView_.disableControls(2, false);
            SUPanel.this.myGenomePre_.setFloater(newNode);
            Layout flay = SUPanel.this.myGenomePre_.getFloaterLayout();
            NodeProperties nprop = new NodeProperties(flay, newNode.getNodeType(), newNode.getID(), 0.0, 0.0, false);
            flay.setNodeProperties(newNode.getID(), nprop);
            SUPanel.this.cursorMgr_.showModeCursor();
            return this.doGene_ ? 1 : 9;
        }

        private int doNodeAdd(boolean doGene, int x, int y, String genomeKey, String layoutKey, double pixDiam) {
            x = (int)((double)Math.round((double)x / 10.0) * 10.0);
            y = (int)((double)Math.round((double)y / 10.0) * 10.0);
            Database db = Database.getDB();
            Genome genome = db.getGenome(genomeKey);
            boolean changeViz = false;
            FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
            if (genome instanceof GenomeInstance) {
                int genCount;
                GenomeInstance gi = (GenomeInstance)genome;
                GenomeInstance parent = gi.getVfgParent();
                Intersection inter = parent != null ? SUPanel.this.myGenomePre_.selectGroupFromParent(x, y, genomeKey, layoutKey, pixDiam) : SUPanel.this.myGenomePre_.selectGroupForRootInstance(x, y, genomeKey, layoutKey, pixDiam);
                if (inter == null) {
                    return 2;
                }
                String groupID = inter.getObjectID();
                String baseGrpID = Group.getBaseID(groupID);
                String inherit = Group.buildInheritedID(baseGrpID, genCount = gi.getGeneration());
                Group intersectGroup = gi.getGroup(inherit);
                if (intersectGroup == null) {
                    return 3;
                }
                int nodeReuse = this.pendingAdd_.checkForNodeReuseInGroup(intersectGroup);
                if (nodeReuse == 0) {
                    return 0;
                }
                if (nodeReuse == 1) {
                    intersectGroup = null;
                }
                BlackHoleResults bhr = SUPanel.this.droppingIntoABlackHole(x, y, genomeKey, layoutKey, this.pendingModAdd_);
                Boolean addRes = this.pendingAdd_.finishDrawNewNodeAddToInstance(doGene, x, y, intersectGroup, bhr.modCandidates, SUPanel.this.currentOverlay_, frc, bhr.intoABlackHole);
                if (addRes == null) {
                    return 3;
                }
                changeViz = addRes;
            } else {
                BlackHoleResults bhr = SUPanel.this.droppingIntoABlackHole(x, y, genomeKey, layoutKey, this.pendingModAdd_);
                changeViz = this.pendingAdd_.locateNewNode(doGene, x, y, bhr.modCandidates, SUPanel.this.currentOverlay_, frc, bhr.intoABlackHole);
            }
            if (changeViz) {
                NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                noc.setSliderValue(50);
            }
            return 0;
        }
    }

    private abstract class ModeHandler {
        private ModeHandler() {
        }

        abstract int setToMode(Object var1);

        abstract void cancelMode(Object var1);

        abstract void handleMouseClick(Point var1, boolean var2, double var3);

        Object getFloater(int x, int y) {
            return null;
        }

        Color getFloaterColor() {
            return null;
        }
    }

    public class NetModuleIntersector {
        private Genome nmiGenome_;
        private String nmiLayoutKey_;

        NetModuleIntersector(Genome genome, String layoutKey) {
            this.nmiGenome_ = genome;
            this.nmiLayoutKey_ = layoutKey;
        }

        public List netModuleIntersections(int x, int y, double pixDiam) {
            List intersected = null;
            if (SUPanel.this.currentOverlay_ == null) {
                throw new IllegalStateException();
            }
            Layout layout = Database.getDB().getLayout(this.nmiLayoutKey_);
            intersected = SUPanel.this.myGenomePre_.intersectNetModules(x, y, this.nmiGenome_.getID(), layout, SUPanel.this.currentOverlay_, ((SUPanel)SUPanel.this).currentNetMods_.set, pixDiam);
            return intersected;
        }
    }

    public class LazyJTextPane
    extends JTextPane {
        private boolean stale_ = false;
        private TextBoxManager textMgr_;

        LazyJTextPane(TextBoxManager textMgr) {
            this.textMgr_ = textMgr;
        }

        public void paint(Graphics gr) {
            if (this.stale_) {
                this.setText(this.textMgr_.getFreshText());
                this.stale_ = false;
            }
            super.paint(gr);
        }

        public void makeStale() {
            this.stale_ = true;
        }
    }

    public class TextBoxManager {
        static final int MODEL_MESSAGE = 0;
        static final int OVERLAY_MESSAGE = 1;
        static final int NETMOD_MESSAGE = 2;
        static final int SELECTED_ITEM_MESSAGE = 3;
        private static final int NUM_TYPES_ = 4;
        private String[] currText_;
        private String[] currSourceKeys_;
        private String currMouseOver_;
        private LazyJTextPane textPane_;

        TextBoxManager() {
            this.textPane_ = new LazyJTextPane(this);
            this.currText_ = new String[4];
            this.currSourceKeys_ = new String[4];
            this.currMouseOver_ = null;
        }

        public JTextPane getTextPane() {
            return this.textPane_;
        }

        public void refresh() {
            this.textPane_.repaint();
        }

        public String getFreshText() {
            for (int i = 0; i < 4; ++i) {
                this.updateMessage(i);
            }
            return this.chooseText();
        }

        public void checkForChanges(ModelChangeEvent mcev) {
            for (int i = 0; i < 4; ++i) {
                this.updateMessage(i);
            }
            this.textPane_.setText(this.chooseText());
        }

        void clearMessageSource(int which) {
            this.currText_[which] = null;
            this.currSourceKeys_[which] = null;
            this.textPane_.setText(this.chooseText());
        }

        void setMessageSource(String messageSourceKey, int which, boolean skipSync) {
            this.currSourceKeys_[which] = messageSourceKey;
            this.currText_[which] = null;
            if (!skipSync) {
                this.updateMessage(which);
                this.textPane_.setText(this.chooseText());
            } else {
                this.textPane_.makeStale();
            }
        }

        void setCurrentMouseOver(String noteText) {
            this.currMouseOver_ = noteText;
            this.textPane_.setText(this.chooseText());
        }

        void clearCurrentMouseOver() {
            this.currMouseOver_ = null;
            this.textPane_.setText(this.chooseText());
        }

        private String chooseText() {
            if (this.currMouseOver_ != null) {
                return this.currMouseOver_;
            }
            for (int i = 3; i >= 0; --i) {
                if (this.currText_[i] == null) continue;
                return this.currText_[i];
            }
            return "";
        }

        private void updateMessage(int which) {
            switch (which) {
                case 0: {
                    if (this.currSourceKeys_[0] == null) {
                        this.currText_[0] = null;
                        break;
                    }
                    Genome genome = Database.getDB().getGenome(this.currSourceKeys_[0]);
                    this.currText_[0] = genome.getDescription();
                    break;
                }
                case 1: {
                    if (this.currSourceKeys_[0] == null || this.currSourceKeys_[1] == null) {
                        this.currText_[1] = null;
                        break;
                    }
                    NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(this.currSourceKeys_[0]);
                    NetworkOverlay nol = owner.getNetworkOverlay(this.currSourceKeys_[1]);
                    this.currText_[1] = nol.getDescription();
                    break;
                }
                case 2: {
                    if (this.currSourceKeys_[0] == null || this.currSourceKeys_[1] == null || this.currSourceKeys_[2] == null) {
                        this.currText_[2] = null;
                        break;
                    }
                    NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(this.currSourceKeys_[0]);
                    NetworkOverlay nol = owner.getNetworkOverlay(this.currSourceKeys_[1]);
                    NetModule nmod = nol.getModule(this.currSourceKeys_[2]);
                    this.currText_[2] = nmod.getDescription();
                    break;
                }
                case 3: {
                    if (this.currSourceKeys_[0] == null || this.currSourceKeys_[3] == null) {
                        this.currText_[3] = null;
                        break;
                    }
                    this.currText_[3] = null;
                    Genome genome = Database.getDB().getGenome(this.currSourceKeys_[0]);
                    Note note = genome.getNote(this.currSourceKeys_[3]);
                    if (note == null) break;
                    this.currText_[3] = note.getTextWithBreaksReplaced();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (this.currText_[which] != null && this.currText_[which].trim().equals("")) {
                this.currText_[which] = null;
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent me) {
            try {
                int offmask;
                int onmask;
                SUPanel.this.textMgr_.clearCurrentMouseOver();
                if (SUPanel.this.lastView_ == null || SUPanel.this.lastAbs_ == null || SUPanel.this.lastPress_ == null) {
                    return;
                }
                int mods = me.getModifiers();
                if ((mods & ((onmask = 16) | (offmask = 12))) != onmask) {
                    return;
                }
                if ((mods & 0x800) != 0) {
                    return;
                }
                Point currPt = me.getPoint();
                if (me.isControlDown()) {
                    Point compLoc = me.getComponent().getLocationOnScreen();
                    Point currAbs = new Point(compLoc.x + currPt.x, compLoc.y + currPt.y);
                    JScrollBar hsb = SUPanel.this.myScrollPane_.getHorizontalScrollBar();
                    int hMax = hsb.getMaximum() - hsb.getVisibleAmount();
                    int hMin = hsb.getMinimum();
                    int newX = ((SUPanel)SUPanel.this).lastView_.x - (currAbs.x - ((SUPanel)SUPanel.this).lastAbs_.x);
                    if (newX > hMax) {
                        newX = hMax;
                    }
                    if (newX < hMin) {
                        newX = hMin;
                    }
                    JScrollBar vsb = SUPanel.this.myScrollPane_.getVerticalScrollBar();
                    int vMax = vsb.getMaximum() - vsb.getVisibleAmount();
                    int vMin = vsb.getMinimum();
                    int newY = ((SUPanel)SUPanel.this).lastView_.y - (currAbs.y - ((SUPanel)SUPanel.this).lastAbs_.y);
                    if (newY > vMax) {
                        newY = vMax;
                    }
                    if (newY < vMin) {
                        newY = vMin;
                    }
                    SUPanel.this.myScrollPane_.getViewport().setViewPosition(new Point(newX, newY));
                    SUPanel.this.myScrollPane_.getViewport().invalidate();
                    SUPanel.this.myScrollPane_.revalidate();
                    return;
                }
                if (SUPanel.this.isModal() && SUPanel.this.currentMode_ != 20) {
                    return;
                }
                Point pt0 = new Point();
                SUPanel.this.transformClick(me.getX(), me.getY(), pt0);
                SUPanel.this.forceToGrid(pt0.x, pt0.y, pt0);
                Point pt2 = new Point();
                SUPanel.this.transformClick(SUPanel.this.lastPress_.getX(), SUPanel.this.lastPress_.getY(), pt2);
                SUPanel.this.forceToGrid(pt2.x, pt2.y, pt2);
                double pixDiam = SUPanel.this.zoomer_.currentPixelDiameter();
                if (SUPanel.this.dragSelect_) {
                    SUPanel.this.dragFloater_.clear();
                    SUPanel.this.dragFloater_.add(pt0);
                    Point pt1 = new Point(pt2.x, pt0.y);
                    SUPanel.this.dragFloater_.add(pt1);
                    SUPanel.this.dragFloater_.add(pt2);
                    Point pt3 = new Point(pt0.x, pt2.y);
                    SUPanel.this.dragFloater_.add(pt3);
                    SUPanel.this.myGenomePre_.setFloater(SUPanel.this.dragFloater_);
                } else if (!SUPanel.this.readOnly_) {
                    Database db = Database.getDB();
                    Layout origLo = db.getLayout(SUPanel.this.layout_);
                    SUPanel.this.dragLayout_ = new Layout(origLo);
                    if (SUPanel.this.rmov_ == null) {
                        List newMoves = SUPanel.this.myGenomePre_.getRunningMove(pt2, SUPanel.this.genomeKey_, origLo, pixDiam, SUPanel.this);
                        SUPanel.this.rmov_ = new IntersectionChooser(false, SUPanel.this.genomeKey_, origLo).runningMoveRanker(newMoves);
                    }
                    if (SUPanel.this.rmov_ != null) {
                        if (((SUPanel)SUPanel.this).rmov_.notPermitted) {
                            SUPanel.this.giveErrorFeedback();
                            return;
                        }
                        FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                        Layout.PadNeedsForLayout padFixups = null;
                        int needFixups = SUPanel.this.myGenomePre_.needPadFixupsForMove(SUPanel.this.rmov_);
                        if (needFixups != 0) {
                            String ownerID = db.getOverlayOwnerFromGenomeKey(SUPanel.this.genomeKey_).getID();
                            padFixups = SUPanel.this.dragLayout_.findAllNetModuleLinkPadRequirementsForOverlay(frc, ownerID, SUPanel.this.currentOverlay_);
                        }
                        SUPanel.this.myGenomePre_.moveItem(SUPanel.this.rmov_, pt0, SUPanel.this.genomeKey_, SUPanel.this.dragLayout_, padFixups);
                        if (padFixups != null) {
                            Map orpho = SUPanel.this.dragLayout_.orphansOnlyForAll(false);
                            SUPanel.this.dragLayout_.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho);
                        }
                    }
                }
                SUPanel.this.myGenomePre_.setFloaterPosition(pt0);
                SUPanel.this.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseMoved(MouseEvent me) {
            try {
                String mouseOverText = null;
                if (SUPanel.this.readOnly_) {
                    mouseOverText = this.getMouseOverText(me);
                    if (mouseOverText != null) {
                        SUPanel.this.textMgr_.setCurrentMouseOver(mouseOverText);
                    } else {
                        SUPanel.this.textMgr_.clearCurrentMouseOver();
                    }
                    return;
                }
                if (SUPanel.this.myGenomePre_.isFloaterActive()) {
                    Point pt = new Point();
                    SUPanel.this.transformClick(me.getX(), me.getY(), pt);
                    Integer key = new Integer(SUPanel.this.readOnly_ ? 0 : SUPanel.this.currentMode_);
                    ModeHandler handler = (ModeHandler)SUPanel.this.clickHandlers_.get(key);
                    if (!(SUPanel.this.currentMode_ != 2 && SUPanel.this.currentMode_ != 4 || SUPanel.this.readOnly_)) {
                        int x = UiUtil.forceToGridValueInt(pt.x, 10.0);
                        int y = UiUtil.forceToGridValueInt(pt.y, 10.0);
                        SUPanel.this.myGenomePre_.setFloater(handler.getFloater(x, y), handler.getFloaterColor());
                    } else {
                        int y;
                        int x;
                        ArrayList ptList;
                        if ((SUPanel.this.currentMode_ == 8 || SUPanel.this.currentMode_ == 3) && !SUPanel.this.readOnly_ && (ptList = (ArrayList)handler.getFloater(x = UiUtil.forceToGridValueInt(pt.x, 10.0), y = UiUtil.forceToGridValueInt(pt.y, 10.0))) != null && me.isShiftDown()) {
                            Point2D lastPoint = (Point2D)ptList.get(ptList.size() - 1);
                            Vector2D vec = new Vector2D(lastPoint, new Point(x, y)).canonical();
                            Point2D canonicalPt = vec.add(lastPoint);
                            pt = new Point((int)canonicalPt.getX(), (int)canonicalPt.getY());
                        }
                        SUPanel.this.myGenomePre_.setFloaterPosition(pt);
                    }
                    SUPanel.this.repaint();
                } else if (!(SUPanel.this.currentMode_ != 7 && SUPanel.this.currentMode_ != 6 || SUPanel.this.readOnly_)) {
                    Point pt = new Point();
                    SUPanel.this.transformClick(me.getX(), me.getY(), pt);
                    Integer key = new Integer(SUPanel.this.currentMode_);
                    MultiMoveModeHandler handler = (MultiMoveModeHandler)SUPanel.this.clickHandlers_.get(key);
                    handler.handleMouseMotion(pt);
                } else if (!SUPanel.this.isModal()) {
                    mouseOverText = this.getMouseOverText(me);
                }
                if (mouseOverText != null) {
                    SUPanel.this.textMgr_.setCurrentMouseOver(mouseOverText);
                } else {
                    SUPanel.this.textMgr_.clearCurrentMouseOver();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private String getMouseOverText(MouseEvent me) {
            String itemID;
            Note note;
            if (SUPanel.this.genomeKey_ == null) {
                return null;
            }
            Database db = Database.getDB();
            Layout layout = db.getLayout(SUPanel.this.layout_);
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            Point pt = new Point();
            SUPanel.this.transformClick(me.getX(), me.getY(), pt);
            double pixDiam = SUPanel.this.zoomer_.currentPixelDiameter();
            Point2D.Float pt2d = new Point2D.Float(pt.x, pt.y);
            List itemList = SUPanel.this.myGenomePre_.intersectNotes(genome, layout, pt2d, true, SUPanel.this, pixDiam);
            Intersection intersect = new IntersectionChooser(true, SUPanel.this.genomeKey_, layout).intersectionRanker(itemList);
            if (intersect != null && (note = genome.getNote(itemID = intersect.getObjectID())) != null) {
                return note.getTextWithBreaksReplaced();
            }
            return null;
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private static final int CLICK_SLOP_ = 2;

        public void mousePressed(MouseEvent me) {
            try {
                int mods = me.getModifiers();
                int onmask = 16;
                int offmask = 12;
                boolean oneOnly = false;
                if ((mods & (onmask | offmask)) == onmask) {
                    oneOnly = true;
                }
                if (!me.isPopupTrigger()) {
                    SUPanel.this.requestFocusInWindow();
                }
                if (me.isPopupTrigger()) {
                    Point pscreenLoc = me.getComponent().getLocationOnScreen();
                    Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                    this.triggerPopup(me.getX(), me.getY(), abs);
                } else if (oneOnly) {
                    SUPanel.this.lastPress_ = new Point(me.getX(), me.getY());
                    SUPanel.this.lastShifted_ = me.isShiftDown();
                    SUPanel.this.lastView_ = SUPanel.this.myScrollPane_.getViewport().getViewPosition();
                    Point screenLoc = me.getComponent().getLocationOnScreen();
                    SUPanel.this.lastAbs_ = new Point(me.getX() + screenLoc.x, me.getY() + screenLoc.y);
                    SUPanel.this.lastCtrl_ = me.isControlDown();
                    SUPanel.this.dragLayout_ = null;
                    SUPanel.this.rmov_ = null;
                    Point pt = new Point();
                    SUPanel.this.transformClick(me.getX(), me.getY(), pt);
                    Database db = Database.getDB();
                    Layout lo = db.getLayout(SUPanel.this.layout_);
                    SUPanel.this.dragSelect_ = this.nothingHit(pt, lo);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                Point pscreenLoc = me.getComponent().getLocationOnScreen();
                Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                this.triggerPopup(me.getX(), me.getY(), abs);
            }
        }

        public void mouseEntered(MouseEvent me) {
            try {
                SUPanel.this.motionHandle_.mouseMoved(me);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseReleased(MouseEvent me) {
            try {
                int mods = me.getModifiers();
                int onmask = 16;
                int offmask = 12;
                boolean oneOnly = false;
                if ((mods & (onmask | offmask)) == onmask) {
                    oneOnly = true;
                }
                SUPanel.this.lastView_ = null;
                SUPanel.this.lastAbs_ = null;
                SUPanel.this.dragLayout_ = null;
                SUPanel.this.multiMoveLayout_ = null;
                if (me.isPopupTrigger()) {
                    Point pscreenLoc = me.getComponent().getLocationOnScreen();
                    Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                    this.triggerPopup(me.getX(), me.getY(), abs);
                    SUPanel.this.myGenomePre_.setFloater(null);
                } else if (oneOnly) {
                    int currX = me.getX();
                    int currY = me.getY();
                    SUPanel.this.dragSelect_ = false;
                    SUPanel.this.myGenomePre_.setNullRender(null);
                    if (SUPanel.this.lastPress_ == null) {
                        return;
                    }
                    int lastX = ((SUPanel)SUPanel.this).lastPress_.x;
                    int lastY = ((SUPanel)SUPanel.this).lastPress_.y;
                    int diffX = Math.abs(currX - lastX);
                    int diffY = Math.abs(currY - lastY);
                    if (diffX <= 2 && diffY <= 2) {
                        this.clickResult(lastX, lastY, SUPanel.this.lastShifted_, SUPanel.this.lastCtrl_);
                    } else if (diffX >= 2 || diffY >= 2) {
                        this.dragResult(lastX, lastY, currX, currY, SUPanel.this.lastShifted_, SUPanel.this.lastCtrl_);
                    } else {
                        SUPanel.this.myGenomePre_.setFloater(null);
                    }
                }
                if (!SUPanel.this.popCtrl_.isVisible()) {
                    SUPanel.this.requestFocusInWindow();
                }
                SUPanel.this.rmov_ = null;
                SUPanel.this.lastPress_ = null;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean nothingHit(Point pt, Layout lo) {
            GroupFree grend;
            String groupID;
            GenomeInstance gi;
            List augs = SUPanel.this.myGenomePre_.intersectItem(pt.x, pt.y, SUPanel.this.genomeKey_, lo, SUPanel.this.zoomer_.currentPixelDiameter(), true, false, SUPanel.this);
            Intersection.AugmentedIntersection ai = new IntersectionChooser(true, SUPanel.this.genomeKey_, lo).selectionRanker(augs);
            Intersection intersect = ai == null || ai.intersect == null ? null : ai.intersect;
            Database db = Database.getDB();
            Genome genome = db.getGenome(SUPanel.this.genomeKey_);
            return intersect == null ? this.nothingMiscHit(pt, genome, lo) : genome instanceof GenomeInstance && (gi = (GenomeInstance)genome).getGroup(intersect.getObjectID()) != null && (groupID = (grend = new GroupFree()).getLabelID(intersect)) == null && this.nothingMiscHit(pt, genome, lo);
        }

        private boolean nothingMiscHit(Point pt, Genome genome, Layout lo) {
            double pixDiam = SUPanel.this.zoomer_.currentPixelDiameter();
            return SUPanel.this.myGenomePre_.intersectModelData(genome, lo, pt, SUPanel.this.currentOverlay_, ((SUPanel)SUPanel.this).currentNetMods_.set, ((SUPanel)SUPanel.this).currOvrSettings_.intersectionMask) == null && !SUPanel.this.myGenomePre_.intersectLinkageLabels(genome, lo, pt, SUPanel.this, pixDiam) && SUPanel.this.myGenomePre_.intersectANetModuleElement(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, SUPanel.this, 2) == null && (!SUPanel.this.showingNetModuleComponents_ || SUPanel.this.myGenomePre_.intersectANetModuleElement(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, SUPanel.this, 4) == null) && SUPanel.this.myGenomePre_.intersectNetModuleLinks(pt.x, pt.y, SUPanel.this.genomeKey_, lo, SUPanel.this, pixDiam) == null && SUPanel.this.myGenomePre_.intersectANetModuleElement(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, SUPanel.this, 3) == null;
        }

        private void clickResult(int x, int y, boolean isShifted, boolean isCtrl) {
            if (isCtrl) {
                SUPanel.this.myGenomePre_.setFloater(null);
                return;
            }
            Point pt = new Point();
            SUPanel.this.transformClick(x, y, pt);
            double pixDiam = SUPanel.this.currentPixelDiameter();
            Integer key = new Integer(SUPanel.this.readOnly_ ? 0 : SUPanel.this.currentMode_);
            ModeHandler handler = (ModeHandler)SUPanel.this.clickHandlers_.get(key);
            handler.handleMouseClick(pt, isShifted, pixDiam);
        }

        private void dragResult(int sx, int sy, int ex, int ey, boolean isShifted, boolean isCtrl) {
            if (isCtrl) {
                return;
            }
            if (SUPanel.this.isModal() && SUPanel.this.currentMode_ != 20 && !SUPanel.this.readOnly_) {
                if (SUPanel.this.currentMode_ == 8) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(SUPanel.this.parent_, rMan.getString("addLink.noDragMessage"), rMan.getString("addLink.placementErrorTitle"), 0);
                }
                return;
            }
            Point spt = new Point();
            SUPanel.this.transformClick(sx, sy, spt);
            Point ept = new Point();
            SUPanel.this.transformClick(ex, ey, ept);
            double pixDiam = SUPanel.this.zoomer_.currentPixelDiameter();
            if (SUPanel.this.genomeKey_ != null) {
                Point2D.Double start = new Point2D.Double(spt.x, spt.y);
                Point2D.Double end = new Point2D.Double(ept.x, ept.y);
                Layout.PropChange[] lpc = null;
                Database db = Database.getDB();
                Layout lo = db.getLayout(SUPanel.this.layout_);
                FontRenderContext frc = SUPanel.this.myGenomePre_.getFontRenderContext();
                Layout.PadNeedsForLayout padFixups = null;
                if (!SUPanel.this.readOnly_) {
                    if (SUPanel.this.rmov_ == null) {
                        List newMoves = SUPanel.this.myGenomePre_.getRunningMove(start, SUPanel.this.genomeKey_, lo, pixDiam, SUPanel.this);
                        SUPanel.this.rmov_ = new IntersectionChooser(false, SUPanel.this.genomeKey_, lo).runningMoveRanker(newMoves);
                    }
                    if (SUPanel.this.rmov_ != null) {
                        if (((SUPanel)SUPanel.this).rmov_.notPermitted) {
                            SUPanel.this.giveErrorFeedback();
                            return;
                        }
                        int needFixups = SUPanel.this.myGenomePre_.needPadFixupsForMove(SUPanel.this.rmov_);
                        if (needFixups == 2) {
                            padFixups = lo.findAllNetModuleLinkPadRequirements(frc);
                        } else if (needFixups == 1) {
                            String ownerID = db.getOverlayOwnerFromGenomeKey(SUPanel.this.genomeKey_).getID();
                            padFixups = lo.findAllNetModuleLinkPadRequirementsForOverlay(frc, ownerID, SUPanel.this.currentOverlay_);
                        }
                        lpc = SUPanel.this.myGenomePre_.moveItem(SUPanel.this.rmov_, end, SUPanel.this.genomeKey_, lo, padFixups);
                        SUPanel.this.rmov_ = null;
                    }
                }
                if (lpc != null) {
                    boolean blank = true;
                    for (int i = 0; i < lpc.length; ++i) {
                        if (lpc[i] == null) continue;
                        blank = false;
                        break;
                    }
                    if (!blank) {
                        Map orpho;
                        Layout.PropChange[] padLpc;
                        UndoSupport support = new UndoSupport(SUPanel.this.undom_, "undo.moveItem");
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        support.addEvent(new LayoutChangeEvent(SUPanel.this.layout_, 1));
                        if (padFixups != null && (padLpc = lo.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho = lo.orphansOnlyForAll(false))) != null && padLpc.length != 0) {
                            PropChangeCmd padC = new PropChangeCmd(padLpc);
                            support.addEdit(padC);
                        }
                        support.finish();
                    }
                } else {
                    int x = (int)((Point2D)start).getX();
                    int y = (int)((Point2D)start).getY();
                    int width = (int)((Point2D)end).getX() - x;
                    int height = (int)((Point2D)end).getY() - y;
                    if (width != 0 && height != 0) {
                        int rh;
                        int ry;
                        int rw;
                        int rx;
                        if (width < 0) {
                            rx = (int)((Point2D)end).getX();
                            rw = -width;
                        } else {
                            rx = x;
                            rw = width;
                        }
                        if (height < 0) {
                            ry = (int)((Point2D)end).getY();
                            rh = -height;
                        } else {
                            ry = y;
                            rh = height;
                        }
                        Rectangle rect = new Rectangle(rx, ry, rw, rh);
                        SUPanel.this.myGenomePre_.selectItems(rect, SUPanel.this.genomeKey_, SUPanel.this.layout_, isShifted, SUPanel.this);
                    }
                }
                SUPanel.this.myGenomePre_.setFloater(null);
                SUPanel.this.textMgr_.clearMessageSource(3);
                SUPanel.this.repaint();
            }
        }

        private void triggerPopup(int x, int y, Point screenAbs) {
            try {
                if (SUPanel.this.isModal()) {
                    return;
                }
                if (SUPanel.this.genomeKey_ != null) {
                    Point pt = new Point();
                    SUPanel.this.transformClick(x, y, pt);
                    double pixDiam = SUPanel.this.zoomer_.currentPixelDiameter();
                    Database db = Database.getDB();
                    Layout lo = db.getLayout(SUPanel.this.layout_);
                    Genome genome = db.getGenome(SUPanel.this.genomeKey_);
                    List itemList = SUPanel.this.myGenomePre_.intersectItem(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, true, SUPanel.this.currentOverlay_ != null, SUPanel.this);
                    Intersection.AugmentedIntersection aug = new IntersectionChooser(false, SUPanel.this.genomeKey_, lo).selectionRanker(itemList);
                    if (aug == null || aug.intersect == null) {
                        if (SUPanel.this.currentOverlay_ == null) {
                            return;
                        }
                        if (SUPanel.this.myGenomePre_.intersectANetModuleElement(pt.x, pt.y, SUPanel.this.genomeKey_, lo, pixDiam, SUPanel.this, 0) == null) {
                            aug = new Intersection.AugmentedIntersection(null, 8);
                        } else {
                            return;
                        }
                    }
                    SUPanel.this.popCtrl_.showPopup(genome, lo, aug, x, y, screenAbs);
                }
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }
    }
}

