/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.util.ArrayList;
import java.util.List;
import org.systemsbiology.biotapestry.ui.LinkSegment;

public class SegmentWithKids {
    LinkSegment segment;
    ArrayList kids;

    SegmentWithKids(LinkSegment seg) {
        this.segment = seg;
        this.kids = new ArrayList();
    }

    String getParentID() {
        return this.segment.getParent();
    }

    List getChildrenIDs() {
        ArrayList<String> retval = new ArrayList<String>();
        int size = this.kids.size();
        for (int i = 0; i < size; ++i) {
            SegmentWithKids child = (SegmentWithKids)this.kids.get(i);
            String kidID = child.segment.getID();
            if (kidID == null) continue;
            retval.add(kidID);
        }
        return retval;
    }

    SegmentWithKids getSwkChild(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals(this.segment.getID())) {
            return this;
        }
        int size = this.kids.size();
        for (int i = 0; i < size; ++i) {
            SegmentWithKids child = (SegmentWithKids)this.kids.get(i);
            String kidID = child.segment.getID();
            SegmentWithKids result = child.getSwkChild(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    List getSiblingIDs(SegmentWithKids rootSwk) {
        ArrayList<String> retval = new ArrayList<String>();
        String parentID = this.segment.getParent();
        if (parentID == null) {
            return retval;
        }
        SegmentWithKids parent = rootSwk.getSwkChild(parentID);
        int size = parent.kids.size();
        for (int i = 0; i < size; ++i) {
            String sibID;
            SegmentWithKids sibling = (SegmentWithKids)parent.kids.get(i);
            if (sibling == this || (sibID = sibling.segment.getID()) == null) continue;
            retval.add(sibID);
        }
        return retval;
    }
}

