/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.io.IOException;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.xml.sax.Attributes;

public class SingleLinkProperties {

    public static class MySegmentGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            BusProperties busProps = board.busProps;
            LinkSegment seg = board.linkSegment;
            busProps.addSegmentInSeries(seg);
            return null;
        }
    }

    public static class SingleLinkPropertiesWorker
    extends AbstractFactoryClient {
        public SingleLinkPropertiesWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("lprop");
            this.installWorker(new LinkSegment.LinkSegmentWorker(whiteboard), new MySegmentGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BusProperties retval = null;
            if (elemName.equals("lprop")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.busProps = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private BusProperties buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "id", true);
            String color = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "color", true);
            String line = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "line", true);
            String txtX = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "labelX", false);
            String txtY = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "labelY", false);
            String txtDir = AttributeExtractor.extractAttribute(elemName, attrs, "lprop", "labelDir", false);
            FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
            Linkage link = board.genome.getLinkage(id);
            if (link == null) {
                System.err.println("Failed to get " + id + " from " + board.genome.getName());
                throw new IOException();
            }
            return new BusProperties(board.genome, color, line, txtX, txtY, txtDir, link);
        }
    }
}

