/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class SourceAndTargetSelector {
    public static final int TARGET_SELECT = 0;
    public static final int SOURCE_SELECT = 1;
    public static final int DIRECT_SELECT = 2;
    private Genome genome_;
    private String layoutID_;
    private GenomePresentation pre_;
    private JFrame parent_;
    private UndoManager undom_;
    private FontRenderContext frc_;

    public SourceAndTargetSelector(JFrame parent, Genome genome, String layoutID, GenomePresentation pre, FontRenderContext frc, UndoManager undo) {
        this.genome_ = genome;
        this.layoutID_ = layoutID;
        this.pre_ = pre;
        this.parent_ = parent;
        this.undom_ = undo;
        this.frc_ = frc;
    }

    public boolean doCriteriaSelection(String nodeID, int selectType, boolean includeItem, boolean includeLinks, boolean clearCurrent, GraphSearcher.CriteriaJudge judge) {
        ArrayList linkIntersections = includeLinks ? new ArrayList() : null;
        HashSet<String> startNodes = new HashSet<String>();
        startNodes.add(nodeID);
        HashSet<String> found = new HashSet<String>();
        switch (selectType) {
            case 2: {
                found.addAll(startNodes);
                break;
            }
            case 0: {
                found.addAll(this.findCriteriaSelections(startNodes, false, judge));
                break;
            }
            case 1: {
                found.addAll(this.findCriteriaSelections(startNodes, true, judge));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.installSelections(found, linkIntersections, clearCurrent);
    }

    public boolean doSelection(Set nodeIDs, int selectType, boolean includeItem, boolean includeLinks, boolean clearCurrent) {
        List<Intersection> linkIntersections = includeLinks ? new ArrayList() : null;
        HashSet<String> linksFromSources = includeLinks ? new HashSet<String>() : null;
        HashSet<String> found = new HashSet<String>();
        switch (selectType) {
            case 2: {
                found.addAll(nodeIDs);
                break;
            }
            case 0: {
                Iterator lit = this.genome_.getLinkageIterator();
                HashMap<String, Intersection> linkInters = new HashMap<String, Intersection>();
                while (lit.hasNext()) {
                    Linkage link = (Linkage)lit.next();
                    String src = link.getSource();
                    if (!nodeIDs.contains(src)) continue;
                    found.add(link.getTarget());
                    if (includeItem) {
                        found.add(src);
                    }
                    if (!includeLinks || linkInters.get(src) != null) continue;
                    Intersection aLinkInter = new Intersection(link.getID(), null, 0.0, true);
                    linkInters.put(src, aLinkInter);
                    linkIntersections.add(aLinkInter);
                }
                break;
            }
            case 1: {
                Iterator slit = this.genome_.getLinkageIterator();
                while (slit.hasNext()) {
                    Linkage link = (Linkage)slit.next();
                    String targ = link.getTarget();
                    if (!nodeIDs.contains(targ)) continue;
                    found.add(link.getSource());
                    if (includeItem) {
                        found.add(targ);
                    }
                    if (!includeLinks) continue;
                    linksFromSources.add(link.getID());
                }
                if (!includeLinks) break;
                Layout lo = Database.getDB().getLayout(this.layoutID_);
                linkIntersections = lo.getIntersectionsForLinks(this.genome_, this.frc_, linksFromSources, false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.installSelections(found, linkIntersections, clearCurrent);
    }

    public boolean doLinkSelection(Set linkIDs, boolean clearCurrent) {
        List linkIntersections = new ArrayList();
        HashSet<String> linksFromSources = new HashSet<String>();
        HashSet<String> found = new HashSet<String>();
        Iterator slit = this.genome_.getLinkageIterator();
        while (slit.hasNext()) {
            Linkage link = (Linkage)slit.next();
            String linkID = link.getID();
            if (!linkIDs.contains(linkID)) continue;
            found.add(link.getSource());
            found.add(link.getTarget());
            linksFromSources.add(linkID);
        }
        Layout lo = Database.getDB().getLayout(this.layoutID_);
        linkIntersections = lo.getIntersectionsForLinks(this.genome_, this.frc_, linksFromSources, false);
        return this.installSelections(found, linkIntersections, clearCurrent);
    }

    private boolean installSelections(Set found, List linkIntersections, boolean clearCurrent) {
        boolean nodeFound = false;
        if (!found.isEmpty()) {
            this.pre_.selectNodesAndLinks(found, this.genome_.getID(), this.layoutID_, linkIntersections, clearCurrent);
            nodeFound = true;
        } else {
            UndoSupport support = new UndoSupport(this.undom_, "undo.selection");
            this.pre_.clearSelections(this.genome_.getID(), this.layoutID_, support);
            support.finish();
            nodeFound = false;
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("nsearch.nothingFound"), rMan.getString("nsearch.nothingFoundTitle"), 0);
        }
        return nodeFound;
    }

    private Set findCriteriaSelections(Set startNodes, boolean invert, GraphSearcher.CriteriaJudge judge) {
        GraphSearcher gs = new GraphSearcher(this.genome_, invert);
        List results = gs.breadthSearchUntilStopped(startNodes, judge);
        HashSet<String> retval = new HashSet<String>();
        Iterator rit = results.iterator();
        while (rit.hasNext()) {
            GraphSearcher.QueueEntry qe = (GraphSearcher.QueueEntry)rit.next();
            retval.add(qe.name);
        }
        return retval;
    }

    public static interface CriteriaJudge {
        public boolean stopHere(String var1);
    }
}

