/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.SuggestedDrawStyle;

public class SpecialSegmentTracker {
    private HashMap specialLinks_ = new HashMap();
    private HashMap specialDrops_ = new HashMap();
    private SuggestedDrawStyle rootDropIsSpecial_ = null;

    public void analyzeSpecialLinks(BusProperties bp, Genome genome) {
        Iterator sit = bp.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            SuggestedDrawStyle sds = seg.getSpecialDrawStyle();
            if (sds == null) continue;
            LinkSegmentID sID = LinkSegmentID.buildIDForSegment(seg.getID());
            Set lThruS = bp.resolveLinkagesThroughSegment(sID, genome);
            this.specialLinks_.put(lThruS, sds.clone());
        }
        Iterator dit = bp.getDrops();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            SuggestedDrawStyle sds = drop.getSpecialDropDrawStyle();
            if (sds == null) continue;
            String ref = drop.getTargetRef();
            if (ref == null) {
                this.rootDropIsSpecial_ = (SuggestedDrawStyle)sds.clone();
                continue;
            }
            this.specialDrops_.put(ref, sds.clone());
        }
    }

    public SpecialSegmentTracker buildInheritedSpecialLinks(BusProperties bp, GenomeInstance gi, NodeInstance src) {
        SpecialSegmentTracker retval = new SpecialSegmentTracker();
        Iterator sit = bp.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            LinkSegmentID sID = LinkSegmentID.buildIDForSegment(seg.getID());
            Set lThruS = bp.resolveLinkagesThroughSegment(sID, gi);
            Set reducedLThruS = this.reduceToBaseIDs(lThruS);
            SuggestedDrawStyle rsds = (SuggestedDrawStyle)this.specialLinks_.get(reducedLThruS);
            if (rsds == null) continue;
            retval.specialLinks_.put(reducedLThruS, rsds.clone());
        }
        if (this.rootDropIsSpecial_ != null) {
            retval.rootDropIsSpecial_ = (SuggestedDrawStyle)this.rootDropIsSpecial_.clone();
        }
        Iterator dit = bp.getDrops();
        while (dit.hasNext()) {
            String reduced;
            SuggestedDrawStyle sds;
            BusDrop drop = (BusDrop)dit.next();
            String ref = drop.getTargetRef();
            if (ref == null || (sds = (SuggestedDrawStyle)this.specialDrops_.get(reduced = GenomeItemInstance.getBaseID(ref))) == null) continue;
            retval.specialDrops_.put(ref, sds.clone());
        }
        return retval;
    }

    public boolean hasSpecialLinks() {
        return this.rootDropIsSpecial_ != null || !this.specialLinks_.isEmpty() || !this.specialDrops_.isEmpty();
    }

    public void reapplySpecialLinks(BusProperties bp, Genome genome) {
        SuggestedDrawStyle sds;
        Iterator sit = bp.getSegments();
        while (sit.hasNext()) {
            LinkSegment seg = (LinkSegment)sit.next();
            LinkSegmentID sID = LinkSegmentID.buildIDForSegment(seg.getID());
            Set lThruS = bp.resolveLinkagesThroughSegment(sID, genome);
            sds = (SuggestedDrawStyle)this.specialLinks_.get(lThruS);
            if (sds == null) continue;
            seg.setDrawStyle((SuggestedDrawStyle)sds.clone());
        }
        Iterator dit = bp.getDrops();
        while (dit.hasNext()) {
            BusDrop drop = (BusDrop)dit.next();
            String ref = drop.getTargetRef();
            if (ref == null) {
                if (this.rootDropIsSpecial_ == null) continue;
                drop.setDrawStyleForDrop((SuggestedDrawStyle)this.rootDropIsSpecial_.clone());
                continue;
            }
            sds = (SuggestedDrawStyle)this.specialDrops_.get(ref);
            if (sds == null) continue;
            drop.setDrawStyleForDrop((SuggestedDrawStyle)sds.clone());
        }
    }

    private Set reduceToBaseIDs(Set instances) {
        HashSet<String> retval = new HashSet<String>();
        Iterator iit = instances.iterator();
        while (iit.hasNext()) {
            String linkID = (String)iit.next();
            String redID = GenomeItemInstance.getBaseID(linkID);
            retval.add(redID);
        }
        return retval;
    }
}

