/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class SuggestedDrawStyle
implements Cloneable {
    public static final int UNDEFINED_STYLE = -2;
    public static final int VARIOUS_STYLE = -1;
    public static final int NO_STYLE = 0;
    public static final int SOLID_STYLE = 1;
    public static final int DASH_STYLE = 2;
    public static final int DOTTED_STYLE = 3;
    public static final String NONE_TAG = "none";
    public static final String SOLID_TAG = "solid";
    public static final String DASH_TAG = "dash";
    public static final String DOTTED_TAG = "dot";
    public static final int CUSTOM_THICKNESS = -100;
    public static final String CUSTOM_TAG = "custom";
    public static final int UNDEFINED_THICKNESS = -6;
    public static final int VARIOUS_THICKNESS = -5;
    public static final int NO_THICKNESS_SPECIFIED = -4;
    public static final int REGULAR_THICKNESS = -3;
    public static final int THIN_THICKNESS = -2;
    public static final int THICK_THICKNESS = -1;
    public static final String NO_THICK_TAG = "none";
    public static final String REGULAR_TAG = "regular";
    public static final String THIN_TAG = "thin";
    public static final String THICK_TAG = "thick";
    private int style_;
    private String color_;
    private int thickness_;

    public SuggestedDrawStyle(String color) {
        this.style_ = 0;
        this.color_ = color;
        this.thickness_ = -4;
    }

    public SuggestedDrawStyle(int style, String color, int thickness) {
        this.style_ = style;
        this.color_ = color;
        this.thickness_ = thickness;
    }

    public SuggestedDrawStyle(String color, String style, String thickness) throws IOException {
        this.color_ = color;
        if (style == null) {
            this.style_ = 0;
        } else {
            try {
                this.style_ = SuggestedDrawStyle.mapLineStyleTag(style);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
        if (thickness == null) {
            this.thickness_ = -4;
        } else {
            try {
                this.thickness_ = SuggestedDrawStyle.mapThicknessTag(thickness);
            }
            catch (IllegalArgumentException iaex) {
                throw new IOException();
            }
        }
    }

    public String getDisplayString() {
        String thickName;
        ResourceManager rMan = ResourceManager.getManager();
        Database db = Database.getDB();
        String colorName = this.color_ == null ? rMan.getString("drawStyle.defaultColor") : db.getNamedColor((String)this.color_).name;
        String styName = rMan.getString("drawStyle." + SuggestedDrawStyle.mapLineStyle(this.style_));
        if (SuggestedDrawStyle.customThicknessRequest(this.thickness_)) {
            String form = rMan.getString("drawStyle.customThickFormat");
            thickName = MessageFormat.format(form, new Integer(this.thickness_));
        } else {
            thickName = rMan.getString("drawStyle." + SuggestedDrawStyle.mapThickness(this.thickness_));
        }
        return colorName + "--" + styName + "--" + thickName;
    }

    public Object clone() {
        try {
            SuggestedDrawStyle retval = (SuggestedDrawStyle)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "SuggestedDrawStyle: drawStyle = " + this.style_ + " color = " + this.color_ + " thick = " + this.thickness_;
    }

    public int hashCode() {
        return (this.color_ == null ? 0 : this.color_.hashCode()) + this.style_ * 10 + this.thickness_;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof SuggestedDrawStyle)) {
            return false;
        }
        SuggestedDrawStyle otherDS = (SuggestedDrawStyle)other;
        if (this.thickness_ != otherDS.thickness_) {
            return false;
        }
        if (this.style_ != otherDS.style_) {
            return false;
        }
        if (this.color_ == null) {
            return otherDS.color_ == null;
        }
        return this.color_.equalsIgnoreCase(otherDS.color_);
    }

    public void fillWithDefaults() {
        if (this.style_ == 0) {
            this.style_ = 1;
        }
        if (this.thickness_ == -4) {
            this.thickness_ = -3;
        }
    }

    public String getColorName() {
        return this.color_;
    }

    public void setColorName(String colorName) {
        this.color_ = colorName;
    }

    public Color getColor() {
        if (this.color_ == null) {
            return null;
        }
        return Database.getDB().getColor(this.color_);
    }

    public int getLineStyle() {
        return this.style_;
    }

    public int getThickness() {
        return this.thickness_;
    }

    public void setLineStyle(int style) {
        this.style_ = style;
    }

    public void setThickness(int thickness) {
        this.thickness_ = thickness;
    }

    public SuggestedDrawStyle mergeOverrides(SuggestedDrawStyle other) {
        SuggestedDrawStyle retval = (SuggestedDrawStyle)this.clone();
        String string = retval.color_ = other.color_ != null ? other.color_ : this.color_;
        if (other.thickness_ != -4) {
            retval.thickness_ = other.thickness_;
        }
        if (other.style_ != 0) {
            retval.style_ = other.style_;
        }
        return retval;
    }

    public int returnWinningThick(int currentThick, boolean forModules) {
        if (this.thickness_ == -4) {
            return currentThick;
        }
        int myTrueThick = SuggestedDrawStyle.trueThick(this.thickness_, forModules);
        if (currentThick == -4) {
            return myTrueThick;
        }
        return myTrueThick > currentThick ? myTrueThick : currentThick;
    }

    public int returnWinningStyle(int currentStyle) {
        if (this.style_ == 0) {
            return currentStyle;
        }
        if (currentStyle == 0) {
            return this.style_;
        }
        return currentStyle > this.style_ ? this.style_ : currentStyle;
    }

    public int sumColors(int[] rgbSums, int currentNum) {
        Color myColor = this.getColor();
        if (myColor == null) {
            return currentNum;
        }
        rgbSums[0] = rgbSums[0] + myColor.getRed();
        rgbSums[1] = rgbSums[1] + myColor.getGreen();
        rgbSums[2] = rgbSums[2] + myColor.getBlue();
        return currentNum + 1;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<drawStyle ");
        if (this.color_ != null) {
            out.print("color=\"");
            out.print(this.color_);
            out.print("\" ");
        }
        if (this.style_ != 0) {
            out.print("style=\"");
            out.print(SuggestedDrawStyle.mapLineStyle(this.style_));
            out.print("\" ");
        }
        if (this.thickness_ != -4) {
            out.print("thick=\"");
            out.print(SuggestedDrawStyle.mapThickness(this.thickness_));
            out.print("\" ");
        }
        out.println("/>");
    }

    public static Vector getStyleChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(SuggestedDrawStyle.lineStyleForCombo(1));
        retval.add(SuggestedDrawStyle.lineStyleForCombo(2));
        retval.add(SuggestedDrawStyle.lineStyleForCombo(3));
        return retval;
    }

    public static ChoiceContent lineStyleForCombo(int style) {
        ResourceManager rMan = ResourceManager.getManager();
        if (style == 0) {
            throw new IllegalArgumentException();
        }
        return new ChoiceContent(rMan.getString("drawStyle." + SuggestedDrawStyle.mapLineStyle(style)), style);
    }

    public static boolean customThicknessRequest(int thickVal) {
        return thickVal == -100 || thickVal >= 0;
    }

    public static Vector getThicknessChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(SuggestedDrawStyle.thicknessForCombo(-3));
        retval.add(SuggestedDrawStyle.thicknessForCombo(-2));
        retval.add(SuggestedDrawStyle.thicknessForCombo(-1));
        retval.add(SuggestedDrawStyle.thicknessForCombo(-100));
        return retval;
    }

    public static ChoiceContent thicknessForCombo(int thickness) {
        ResourceManager rMan = ResourceManager.getManager();
        if (SuggestedDrawStyle.customThicknessRequest(thickness)) {
            return new ChoiceContent(rMan.getString("drawStyle.custom"), -100);
        }
        if (thickness == -4) {
            throw new IllegalArgumentException();
        }
        return new ChoiceContent(rMan.getString("drawStyle." + SuggestedDrawStyle.mapThickness(thickness)), thickness);
    }

    public static String mapLineStyle(int style) {
        switch (style) {
            case 0: {
                return "none";
            }
            case 1: {
                return SOLID_TAG;
            }
            case 2: {
                return DASH_TAG;
            }
            case 3: {
                return DOTTED_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String mapThickness(int thickness) {
        switch (thickness) {
            case -100: {
                throw new IllegalArgumentException();
            }
            case -4: {
                return "none";
            }
            case -3: {
                return REGULAR_TAG;
            }
            case -2: {
                return THIN_TAG;
            }
            case -1: {
                return THICK_TAG;
            }
        }
        return Integer.toString(thickness);
    }

    public static int mapThicknessTag(String thickTag) {
        if (thickTag.equalsIgnoreCase(CUSTOM_TAG)) {
            throw new IllegalArgumentException();
        }
        if (thickTag.equalsIgnoreCase("none")) {
            return -4;
        }
        if (thickTag.equalsIgnoreCase(REGULAR_TAG)) {
            return -3;
        }
        if (thickTag.equalsIgnoreCase(THIN_TAG)) {
            return -2;
        }
        if (thickTag.equalsIgnoreCase(THICK_TAG)) {
            return -1;
        }
        try {
            int val = Integer.parseInt(thickTag);
            if (val < 0) {
                throw new IllegalArgumentException();
            }
            return val;
        }
        catch (NumberFormatException nfex) {
            throw new IllegalArgumentException();
        }
    }

    public static int mapLineStyleTag(String styleTag) {
        if (styleTag.equalsIgnoreCase("none")) {
            return 0;
        }
        if (styleTag.equalsIgnoreCase(SOLID_TAG)) {
            return 1;
        }
        if (styleTag.equalsIgnoreCase(DASH_TAG)) {
            return 2;
        }
        if (styleTag.equalsIgnoreCase(DOTTED_TAG)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public static SuggestedDrawStyle buildFromLegacy(int oldStyleTag) {
        switch (oldStyleTag) {
            case -1: {
                return null;
            }
            case 0: {
                return new SuggestedDrawStyle(1, null, -3);
            }
            case 1: {
                return new SuggestedDrawStyle(1, null, -2);
            }
            case 2: {
                return new SuggestedDrawStyle(2, null, -3);
            }
            case 3: {
                return new SuggestedDrawStyle(3, null, -2);
            }
        }
        throw new IllegalStateException();
    }

    public static int trueThick(int thick, boolean forModules) {
        if (thick == -4) {
            throw new IllegalArgumentException();
        }
        if (thick == -3) {
            return forModules ? 5 : 3;
        }
        if (thick == -2) {
            return forModules ? 3 : 2;
        }
        if (thick == -1) {
            return forModules ? 9 : 7;
        }
        return thick;
    }

    public static int drawThick(boolean forModules) {
        return forModules ? 5 : 3;
    }

    public static class SuggestedDrawStyleWorker
    extends AbstractFactoryClient {
        public SuggestedDrawStyleWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("drawStyle");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            SuggestedDrawStyle retval = null;
            if (elemName.equals("drawStyle")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.suggSty = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private SuggestedDrawStyle buildFromXML(String elemName, Attributes attrs) throws IOException {
            String colorStr = AttributeExtractor.extractAttribute(elemName, attrs, "drawStyle", "color", false);
            String styleStr = AttributeExtractor.extractAttribute(elemName, attrs, "drawStyle", "style", false);
            String thickStr = AttributeExtractor.extractAttribute(elemName, attrs, "drawStyle", SuggestedDrawStyle.THICK_TAG, false);
            if (colorStr == null && styleStr == null && thickStr == null) {
                throw new IOException();
            }
            return new SuggestedDrawStyle(colorStr, styleStr, thickStr);
        }
    }
}

