/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.db.LayoutSource;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.db.WorkspaceSource;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.ui.BasicZoomTargetSupport;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.ZoomPresentation;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class ZoomTargetSupport
extends BasicZoomTargetSupport {
    private GenomeSource source_;
    private LayoutSource layoutSource_;
    private TaggedSet currentNetMods_;
    private String currentOverlay_;

    public ZoomTargetSupport(ZoomPresentation genomePre, JPanel paintTarget, GenomeSource source, LayoutSource layoutSource, WorkspaceSource workspaceSource) {
        super(genomePre, paintTarget, workspaceSource);
        this.source_ = source;
        this.genomeKey_ = null;
        this.layoutSource_ = layoutSource;
        this.currentOverlay_ = null;
        this.currentNetMods_ = new TaggedSet();
    }

    public void setGenomeSource(GenomeSource source) {
        this.source_ = source;
    }

    public void setGenome(String key) {
        this.genomeKey_ = key;
    }

    public void setLayoutSource(LayoutSource source) {
        this.layoutSource_ = source;
    }

    public void setGraphLayout(String key) {
        this.layout_ = key;
    }

    public void setWorkspaceSource(WorkspaceSource source) {
        this.workspaceSource_ = source;
    }

    public void setOverlay(String key) {
        this.currentOverlay_ = key;
    }

    public void setCurrentNetModules(TaggedSet keys) {
        this.currentNetMods_ = new TaggedSet(keys);
    }

    public String getGenome() {
        return this.genomeKey_;
    }

    public String getGraphLayout() {
        return this.layout_;
    }

    public void fixCenterPoint(boolean doComplete, UndoSupport support, boolean closeIt) {
        Genome genome = this.source_.getGenome(this.genomeKey_);
        if (genome != null && genome.isEmpty() && genome.getNetworkModuleCount() == 0) {
            if (genome instanceof DBGenome) {
                this.setRawOrigin(new Point2D.Double(0.0, 0.0), support, closeIt);
                return;
            }
            genome = this.source_.getGenome();
            if (genome != null && genome.isEmpty() && genome.getNetworkModuleCount() == 0) {
                this.setRawOrigin(new Point2D.Double(0.0, 0.0), support, closeIt);
                return;
            }
            String rootKey = genome.getID();
            Layout lo = this.layoutSource_.getLayout(this.layoutSource_.mapGenomeKeyToLayoutKey(rootKey));
            boolean doModules = genome.isEmpty();
            Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
            Rectangle rect = this.myGenomePre_.getRequiredSize(rootKey, lo.getName(), doComplete, false, doModules, doModules, null, null, allKeys);
            double cx = rect.getX() + rect.getWidth() / 2.0;
            double cy = rect.getY() + rect.getHeight() / 2.0;
            this.setRawCenterPoint(new Point2D.Double(cx, cy), support, closeIt);
            return;
        }
        boolean doModules = genome.isEmpty() || this.currentOverlay_ != null && !this.currentNetMods_.set.isEmpty();
        Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
        Rectangle rect = this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, doComplete, false, doModules, doModules, this.currentOverlay_, this.currentNetMods_, allKeys);
        double cx = rect.getX() + rect.getWidth() / 2.0;
        double cy = rect.getY() + rect.getHeight() / 2.0;
        this.setRawCenterPoint(new Point2D.Double(cx, cy), support, closeIt);
    }

    public void setRawCenterPoint(Point2D rawPt, UndoSupport support, boolean closeIt) {
        Workspace currWS = this.workspaceSource_.getWorkspace();
        Workspace ws = new Workspace(currWS, rawPt);
        DatabaseChange dc = ((WorkspaceSource)this.workspaceSource_).setWorkspace(ws);
        if (support != null && dc != null) {
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
            if (closeIt) {
                support.addEvent(new LayoutChangeEvent(this.layout_, 1));
                support.finish();
            }
        }
    }

    public void setRawOrigin(Point2D rawPt, UndoSupport support, boolean closeIt) {
        Workspace currWS = this.workspaceSource_.getWorkspace();
        Workspace ws = (Workspace)currWS.clone();
        ws.setOrigin(rawPt);
        DatabaseChange dc = ((WorkspaceSource)this.workspaceSource_).setWorkspace(ws);
        if (support != null && dc != null) {
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
            if (closeIt) {
                support.addEvent(new LayoutChangeEvent(this.layout_, 1));
                support.finish();
            }
        }
    }

    public Dimension getBasicSize(boolean doComplete, boolean doBuffer, int moduleHandling) {
        boolean doModules = false;
        String useOverlay = null;
        TaggedSet useModules = null;
        switch (moduleHandling) {
            case 0: {
                break;
            }
            case 1: {
                if (this.currentOverlay_ == null || this.currentNetMods_.set.isEmpty()) break;
                doModules = true;
                useOverlay = this.currentOverlay_;
                useModules = this.currentNetMods_;
                break;
            }
            case 2: {
                doModules = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
        Rectangle origRect = this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, doComplete, doBuffer, doModules, doModules, useOverlay, useModules, allKeys);
        return new Dimension(origRect.width, origRect.height);
    }

    public Rectangle getCurrentBasicBounds(boolean doComplete, boolean doBuffer, int moduleHandling) {
        boolean doModules = false;
        String useOverlay = null;
        TaggedSet useModules = null;
        switch (moduleHandling) {
            case 0: {
                break;
            }
            case 1: {
                if (this.currentOverlay_ == null || this.currentNetMods_.set.isEmpty()) break;
                doModules = true;
                useOverlay = this.currentOverlay_;
                useModules = this.currentNetMods_;
                break;
            }
            case 2: {
                doModules = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Map allKeys = doModules ? new FullGenomeHierarchyOracle().fullModuleKeysPerLayout() : null;
        return this.myGenomePre_.getRequiredSize(this.genomeKey_, this.layout_, doComplete, doBuffer, doModules, doModules, useOverlay, useModules, allKeys);
    }

    public Rectangle getAllModelBounds() {
        Genome root = this.source_.getGenome();
        String genKey = root.getID();
        Layout lo = this.layoutSource_.getLayout(this.layoutSource_.mapGenomeKeyToLayoutKey(genKey));
        Rectangle rect = this.getBasicBounds(genKey, lo.getName(), true, false);
        Iterator giit = this.source_.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            genKey = gi.getID();
            lo = this.layoutSource_.getLayout(this.layoutSource_.mapGenomeKeyToLayoutKey(genKey));
            Rectangle modRect = this.getBasicBounds(genKey, lo.getName(), true, false);
            rect = rect.union(modRect);
        }
        return rect;
    }

    private Rectangle getBasicBounds(String genomeKey, String layout, boolean doComplete, boolean doBuffer) {
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        return this.myGenomePre_.getRequiredSize(genomeKey, layout, doComplete, doBuffer, true, true, null, null, allKeys);
    }
}

