/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.DataPopupManager;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.dialogs.utils.UsageSelector;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class LinkUsageDisplayFrame
extends JFrame
implements ListSelectionListener {
    private FixedJButton gotoButton_;
    private UsageSelector usageSel_;
    private JList jlist_;
    private Set linkIDs_;
    private boolean processing_;

    public LinkUsageDisplayFrame(JFrame parent, Set linkIDs, GenomePresentation pre, String frameID) {
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        this.setIconImage(new ImageIcon(ugif).getImage());
        this.linkIDs_ = new HashSet(linkIDs);
        this.setWindowTitle();
        final String closeID = frameID;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DataPopupManager.getPopupMgr().dropLinkSelectionWindow(closeID);
            }
        });
        this.usageSel_ = new UsageSelector(this, pre);
        this.processing_ = false;
        this.setSize(800, 500);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        JLabel lab = new JLabel(rMan.getString("ludd.usages"));
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        cp.add((Component)lab, gbc);
        this.jlist_ = new JList();
        this.jlist_.setSelectionMode(0);
        this.refreshList();
        JScrollPane jsp = new JScrollPane(this.jlist_);
        UiUtil.gbcSet(gbc, 0, 1, 1, 20, 1, 0, 0, 0, 0, 0, 0, 17, 1.0, 1.0);
        cp.add((Component)jsp, gbc);
        this.jlist_.addListSelectionListener(this);
        this.gotoButton_ = new FixedJButton(rMan.getString("ludd.goto"));
        this.gotoButton_.setEnabled(false);
        this.gotoButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    LinkUsageDisplayFrame.this.usageSel_.goToModelAndSelectLink();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.close"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DataPopupManager.getPopupMgr().dropLinkSelectionWindow(closeID);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.gotoButton_);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        UiUtil.gbcSet(gbc, 0, 22, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public void valueChanged(ListSelectionEvent lse) {
        try {
            if (this.processing_) {
                return;
            }
            if (lse.getValueIsAdjusting()) {
                return;
            }
            int[] sel = this.jlist_.getSelectedIndices();
            if (sel == null || sel.length != 1) {
                this.usageSel_.setSelected(null);
            } else {
                this.usageSel_.setSelected((UsageSelector.ListEntry)this.jlist_.getModel().getElementAt(sel[0]));
            }
            this.handleButtons();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void updateLinkSet(Set linkIDs) {
        this.linkIDs_ = new HashSet(linkIDs);
        this.refreshList();
    }

    public void refreshList() {
        List usageList = this.generateLinkUsages(this.linkIDs_);
        this.processing_ = true;
        this.jlist_.setListData(usageList.toArray());
        this.setWindowTitle();
        this.processing_ = false;
    }

    private void handleButtons() {
        UsageSelector.ListEntry sel = this.usageSel_.getSelected();
        this.gotoButton_.setEnabled(sel != null && sel.modelID != null);
        this.gotoButton_.revalidate();
    }

    private Linkage getABaseLink(String linkID) {
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        String baseID = GenomeItemInstance.getBaseID(linkID);
        Linkage rootLink = genome.getLinkage(baseID);
        return rootLink;
    }

    private void setWindowTitle() {
        String msg;
        ResourceManager rMan = ResourceManager.getManager();
        String aLinkID = this.linkIDs_.isEmpty() ? null : (String)this.linkIDs_.iterator().next();
        Genome genome = Database.getDB().getGenome();
        if (aLinkID != null) {
            Linkage rootLinkage = this.getABaseLink(aLinkID);
            if (this.linkIDs_.size() == 1) {
                String disp = rootLinkage.getDisplayString(genome, false);
                String titleFormat = rMan.getString("ludd.titleFormatOne");
                msg = MessageFormat.format(titleFormat, disp);
            } else {
                String srcID = rootLinkage.getSource();
                String titleFormat = rMan.getString("ludd.titleFormatMany");
                Node srcNode = genome.getNode(srcID);
                String nodeName = srcNode.getName();
                msg = MessageFormat.format(titleFormat, nodeName);
            }
        } else {
            msg = rMan.getString("ludd.titleFormatNone");
        }
        this.setTitle(msg);
    }

    public List generateLinkUsages(Set linkIDs) {
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        ArrayList<UsageSelector.ListEntry> usageList = new ArrayList<UsageSelector.ListEntry>();
        Iterator lit = linkIDs.iterator();
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            String baseID = GenomeItemInstance.getBaseID(linkID);
            ResourceManager rMan = ResourceManager.getManager();
            String instanceFormatOneGroup = rMan.getString("toolCmd.instanceLinkUsageSingleFormat");
            String instanceFormatTwoGroups = rMan.getString("toolCmd.instanceLinkUsageDoubleFormat");
            String dynMessage = rMan.getString("toolCmd.dynamicLinkUsageFormat");
            String linkFormatMessage = rMan.getString("toolCmd.LinkUsageLinkFormat");
            String noGroup = rMan.getString("toolCmd.noGroup");
            Linkage rootLink = genome.getLinkage(baseID);
            if (rootLink == null) {
                throw new IllegalStateException();
            }
            String src = rootLink.getSource();
            String trg = rootLink.getTarget();
            String linkMsg = MessageFormat.format(linkFormatMessage, genome.getNode(src).getName(), genome.getNode(trg).getName());
            UsageSelector.ListEntry le = new UsageSelector.ListEntry(linkMsg, null, null);
            usageList.add(le);
            String fullUse = "  " + rMan.getString("toolCmd.fullGenomeLinkUsage");
            le = new UsageSelector.ListEntry(fullUse, genome.getID(), baseID);
            usageList.add(le);
            Iterator iit = db.getInstanceIterator();
            while (iit.hasNext()) {
                GenomeInstance gi = (GenomeInstance)iit.next();
                String giName = gi.getName();
                Set liSet = gi.returnLinkInstanceIDsForBacking(baseID);
                Iterator lisit = liSet.iterator();
                while (lisit.hasNext()) {
                    String linkInstID = (String)lisit.next();
                    GenomeInstance.GroupTuple gtup = gi.getRegionTuple(linkInstID);
                    String srcGrp = gtup.getSourceGroup();
                    String trgGrp = gtup.getTargetGroup();
                    String msg = null;
                    if (srcGrp == null) {
                        if (trgGrp == null) {
                            msg = MessageFormat.format(instanceFormatOneGroup, giName, noGroup);
                        } else {
                            String trgGrpName = gi.getGroup(trgGrp).getInheritedDisplayName(gi);
                            msg = MessageFormat.format(instanceFormatTwoGroups, giName, noGroup, trgGrpName);
                        }
                    } else if (srcGrp.equals(trgGrp)) {
                        String grpName = gi.getGroup(trgGrp).getInheritedDisplayName(gi);
                        msg = MessageFormat.format(instanceFormatOneGroup, giName, grpName);
                    } else {
                        String srcGrpName = srcGrp == null ? noGroup : gi.getGroup(srcGrp).getInheritedDisplayName(gi);
                        String trgGrpName = trgGrp == null ? noGroup : gi.getGroup(trgGrp).getInheritedDisplayName(gi);
                        msg = MessageFormat.format(instanceFormatTwoGroups, giName, srcGrpName, trgGrpName);
                    }
                    le = new UsageSelector.ListEntry("  " + msg, gi.getID(), linkInstID);
                    usageList.add(le);
                }
                if (liSet.isEmpty() || !gi.haveProxyDecendant()) continue;
                String msg = MessageFormat.format(dynMessage, giName);
                le = new UsageSelector.ListEntry("  " + msg, null, null);
                usageList.add(le);
            }
        }
        return usageList;
    }
}

