/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class LoginDialog
extends JDialog {
    private JTextField userNameField_;
    private JPasswordField passwordField_;
    private boolean haveResult_ = false;
    private String userName_;
    private char[] passChars_;

    public LoginDialog(JFrame parent) {
        super(parent, ResourceManager.getManager().getString("login.title"), true);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(500, 400);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(rMan.getString("login.user"));
        this.userNameField_ = new JTextField();
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, 0, 5, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.userNameField_, gbc);
        label = new JLabel(rMan.getString("login.password"));
        this.passwordField_ = new JPasswordField();
        this.passwordField_.setEchoChar('*');
        UiUtil.gbcSet(gbc, 0, 1, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, 1, 5, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.passwordField_, gbc);
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    LoginDialog.this.stashResults(true);
                    LoginDialog.this.setVisible(false);
                    LoginDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    LoginDialog.this.stashResults(false);
                    LoginDialog.this.setVisible(false);
                    LoginDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, 9, 6, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public String getUserName() {
        return this.userName_;
    }

    public char[] getPassword() {
        return this.passChars_;
    }

    public boolean haveResult() {
        return this.haveResult_;
    }

    private boolean stashResults(boolean ok) {
        if (ok) {
            this.userName_ = this.userNameField_.getText().trim();
            this.passChars_ = this.passwordField_.getPassword();
            this.haveResult_ = true;
            return true;
        }
        this.userName_ = null;
        this.passChars_ = null;
        this.haveResult_ = false;
        return true;
    }
}

