/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleAlphaBuilder;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class NetOverlayControlPanel
extends JPanel
implements ChangeListener {
    private JSlider modSlider_;
    private ArrayList labels_;
    private CommonView suw_;
    private boolean managing_;
    private NetModuleFree.CurrentSettings currSettings_;
    private NetModuleAlphaBuilder alphaCalc_;
    private NetOverlayController noc_;

    public NetOverlayControlPanel(NetModuleFree.CurrentSettings sett, CommonView suw, NetOverlayController noc) {
        this.currSettings_ = sett;
        this.managing_ = false;
        this.suw_ = suw;
        this.alphaCalc_ = new NetModuleAlphaBuilder();
        this.noc_ = noc;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.labels_ = new ArrayList();
        this.modSlider_ = this.buildSlider(this.labels_);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        this.add((Component)this.modSlider_, gbc);
    }

    public void displayProperties() {
    }

    public NetModuleFree.CurrentSettings getSettings() {
        return this.currSettings_;
    }

    public void setSliderValue(int slideVal) {
        this.modSlider_.setValue(slideVal);
    }

    public boolean getMaskingState() {
        return this.alphaCalc_.modContentsMasked(this.currSettings_);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.modSlider_.setEnabled(enabled);
        for (int i = 0; i < this.labels_.size(); ++i) {
            JLabel label = (JLabel)this.labels_.get(i);
            label.setEnabled(enabled);
        }
    }

    public void stateChanged(ChangeEvent e) {
        try {
            if (this.managing_) {
                return;
            }
            JSlider slider = (JSlider)e.getSource();
            int value = slider.getValue();
            this.alphaCalc_.alphaCalc(value, this.currSettings_);
            boolean maybeMasking = this.alphaCalc_.modContentsMasked(this.currSettings_);
            this.noc_.checkMaskState(maybeMasking);
            SUPanel sup = this.suw_.getSUPanel();
            sup.repaint();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    private JSlider buildSlider(List labels) {
        JSlider slider = new JSlider(0, 0, 100, 100);
        ResourceManager rMan = ResourceManager.getManager();
        Hashtable<Integer, JLabel> labelMap = new Hashtable<Integer, JLabel>();
        JLabel minLabel = new JLabel(rMan.getString("netOverlayController.min"));
        JLabel maxLabel = new JLabel(rMan.getString("netOverlayController.max"));
        labelMap.put(new Integer(0), minLabel);
        labels.add(minLabel);
        labelMap.put(new Integer(100), maxLabel);
        labels.add(maxLabel);
        slider.setLabelTable(labelMap);
        slider.setMajorTickSpacing(100);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.addChangeListener(this);
        return slider;
    }
}

