/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.SourceAndTargetSelector;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class NodeSearchDialog
extends JDialog {
    private static final int FULL_MATCH_ = 0;
    private static final int PARTIAL_MATCH_ = 1;
    private JCheckBox includeItemBox_;
    private JCheckBox includeLinksBox_;
    private JCheckBox addToCurrentBox_;
    private JComboBox matchTypeCombo_;
    private JTextField stringField_;
    private JRadioButton directSearch_;
    private JRadioButton targetSearch_;
    private JRadioButton sourceSearch_;
    private Genome genome_;
    private String layoutID_;
    private String currOvr_;
    private GenomePresentation pre_;
    private JFrame parent_;
    private UndoManager undom_;
    private boolean itemFound_;
    private FontRenderContext frc_;
    private JTabbedPane tabPane_;
    private JComboBox moduleMethodChoices_;
    private JLabel moduleNameLabel_;
    private JComboBox moduleNameChoices_;
    private JLabel moduleValueLabel_;
    private JComboBox moduleValueChoices_;
    private JLabel moduleTagLabel_;
    private JComboBox moduleTagChoices_;
    private Map valsForNames_;
    private boolean linksHidden_;

    public NodeSearchDialog(JFrame parent, Genome genome, String layoutID, GenomePresentation pre, FontRenderContext frc, String selectedID, String currOvr, boolean linksHidden, UndoManager undo) {
        super(parent, ResourceManager.getManager().getString("nsearch.title"), true);
        this.genome_ = genome;
        this.layoutID_ = layoutID;
        this.pre_ = pre;
        this.parent_ = parent;
        this.undom_ = undo;
        this.frc_ = frc;
        this.currOvr_ = currOvr;
        this.linksHidden_ = linksHidden;
        this.itemFound_ = false;
        this.valsForNames_ = new HashMap();
        HashSet globalTags = new HashSet();
        HashSet allNames = new HashSet();
        HashSet allValues = new HashSet();
        FullGenomeHierarchyOracle oracle = new FullGenomeHierarchyOracle();
        oracle.getGlobalTagsAndNVPairsForModules(this.valsForNames_, allNames, allValues, globalTags, null);
        boolean enableModuleSearch = currOvr != null && (allNames.size() > 0 || globalTags.size() > 0);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(600, 500);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.tabPane_ = new JTabbedPane();
        this.tabPane_.addTab(rMan.getString("nsearch.nameSearch"), this.buildNodeSearchTab(selectedID));
        this.tabPane_.addTab(rMan.getString("nsearch.moduleSearch"), this.buildModuleSearchTab(this.valsForNames_, allNames, globalTags, enableModuleSearch));
        this.tabPane_.setEnabledAt(1, enableModuleSearch);
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum, 10, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.tabPane_, gbc);
        rowNum += 8;
        FixedJButton buttonO = new FixedJButton(rMan.getString("nsearch.search"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    NodeSearchDialog.this.itemFound_ = false;
                    if (NodeSearchDialog.this.doSearch()) {
                        NodeSearchDialog.this.setVisible(false);
                        NodeSearchDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    NodeSearchDialog.this.setVisible(false);
                    NodeSearchDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, rowNum, 4, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public boolean itemWasFound() {
        return this.itemFound_;
    }

    private JPanel buildNodeSearchTab(String selectedID) {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel cp = new JPanel();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(rMan.getString("nsearch.searchType"));
        this.directSearch_ = new JRadioButton(rMan.getString("nsearch.directSearch"), true);
        this.targetSearch_ = new JRadioButton(rMan.getString("nsearch.targetSearch"), false);
        this.sourceSearch_ = new JRadioButton(rMan.getString("nsearch.sourceSearch"), false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.directSearch_);
        group.add(this.targetSearch_);
        group.add(this.sourceSearch_);
        ButtonTracker bt = new ButtonTracker();
        this.directSearch_.addActionListener(bt);
        this.targetSearch_.addActionListener(bt);
        this.sourceSearch_.addActionListener(bt);
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.directSearch_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.targetSearch_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.sourceSearch_, gbc);
        label = new JLabel(rMan.getString("nsearch.searchString"));
        if (selectedID != null) {
            String name = this.genome_.getNode(selectedID).getName().trim();
            this.stringField_ = new JTextField(name);
        } else {
            this.stringField_ = new JTextField();
        }
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.stringField_, gbc);
        this.matchTypeCombo_ = new JComboBox(this.getMatchChoices());
        UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        cp.add((Component)this.matchTypeCombo_, gbc);
        JPanel extras = new JPanel();
        extras.setBorder(new EtchedBorder());
        extras.setLayout(new GridBagLayout());
        this.includeItemBox_ = new JCheckBox(rMan.getString("nsearch.includeItem"), true);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        extras.add((Component)this.includeItemBox_, gbc);
        this.includeLinksBox_ = new JCheckBox(rMan.getString("nsearch.includeLinks"), !this.linksHidden_);
        UiUtil.gbcSet(gbc, 0, 1, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        extras.add((Component)this.includeLinksBox_, gbc);
        this.addToCurrentBox_ = new JCheckBox(rMan.getString("nsearch.appendToCurrent"), false);
        UiUtil.gbcSet(gbc, 0, 2, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        extras.add((Component)this.addToCurrentBox_, gbc);
        UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        cp.add((Component)extras, gbc);
        this.includeItemBox_.setEnabled(false);
        this.includeLinksBox_.setEnabled(false);
        return cp;
    }

    private JPanel buildModuleSearchTab(Map nameVals, Set allNames, Set globalTags, boolean enableModSearch) {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel cp = new JPanel();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (!enableModSearch) {
            return cp;
        }
        boolean haveNV = allNames.size() > 0;
        boolean haveTags = globalTags.size() > 0;
        int rowNum = 0;
        JLabel label = new JLabel(rMan.getString("nsearch.moduleMethod"));
        this.moduleMethodChoices_ = new JComboBox(this.getModuleMethods(haveNV, haveTags));
        this.moduleMethodChoices_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ChoiceContent cc = (ChoiceContent)NodeSearchDialog.this.moduleMethodChoices_.getSelectedItem();
                    boolean useTags = cc.val == 0;
                    NodeSearchDialog.this.moduleTagLabel_.setEnabled(useTags);
                    NodeSearchDialog.this.moduleTagChoices_.setEnabled(useTags);
                    NodeSearchDialog.this.moduleNameLabel_.setEnabled(!useTags);
                    NodeSearchDialog.this.moduleNameChoices_.setEnabled(!useTags);
                    NodeSearchDialog.this.moduleValueLabel_.setEnabled(!useTags);
                    NodeSearchDialog.this.moduleValueChoices_.setEnabled(!useTags);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 3, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        cp.add((Component)this.moduleMethodChoices_, gbc);
        this.moduleTagLabel_ = new JLabel(rMan.getString("nsearch.tagChoices"));
        this.moduleTagChoices_ = new JComboBox(this.getTagChoices(globalTags));
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)this.moduleTagLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum++, 3, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        cp.add((Component)this.moduleTagChoices_, gbc);
        this.moduleNameLabel_ = new JLabel(rMan.getString("nsearch.nameChoices"));
        Vector nameChoices = this.getNameChoices(allNames);
        this.moduleNameChoices_ = new JComboBox(nameChoices);
        this.moduleNameChoices_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String name = (String)NodeSearchDialog.this.moduleNameChoices_.getSelectedItem();
                    NodeSearchDialog.this.restockValues(name);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.moduleValueLabel_ = new JLabel(rMan.getString("nsearch.valueChoices"));
        this.moduleValueChoices_ = new JComboBox();
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        cp.add((Component)this.moduleNameLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.moduleNameChoices_, gbc);
        UiUtil.gbcSet(gbc, 2, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        cp.add((Component)this.moduleValueLabel_, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.moduleValueChoices_, gbc);
        ChoiceContent cc = (ChoiceContent)this.moduleMethodChoices_.getSelectedItem();
        boolean useTags = cc.val == 0;
        this.moduleNameLabel_.setEnabled(!useTags);
        this.moduleNameChoices_.setEnabled(!useTags);
        this.moduleValueLabel_.setEnabled(!useTags);
        this.moduleValueChoices_.setEnabled(!useTags);
        if (!useTags || this.moduleMethodChoices_.getItemCount() == 2) {
            String currName = (String)this.moduleNameChoices_.getSelectedItem();
            this.restockValues(currName);
        }
        return cp;
    }

    private void restockValues(String name) {
        this.moduleValueChoices_.removeAllItems();
        Vector vals = this.getValueChoices(name);
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            this.moduleValueChoices_.addItem(vals.get(i));
        }
        this.moduleValueChoices_.validate();
    }

    private Vector getMatchChoices() {
        ResourceManager rMan = ResourceManager.getManager();
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(new ChoiceContent(rMan.getString("nsearch.fullMatch"), 0));
        retval.add(new ChoiceContent(rMan.getString("nsearch.partialMatch"), 1));
        return retval;
    }

    private Vector getModuleMethods(boolean haveNV, boolean haveTags) {
        ResourceManager rMan = ResourceManager.getManager();
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        if (haveTags) {
            retval.add(new ChoiceContent(rMan.getString("nsearch.moduleByKey"), 0));
        }
        if (haveNV) {
            retval.add(new ChoiceContent(rMan.getString("nsearch.moduleByNameVal"), 1));
        }
        return retval;
    }

    private Vector getTagChoices(Set globalTags) {
        Vector<String> retval = new Vector<String>();
        TreeSet tagSet = new TreeSet(globalTags);
        Iterator tsit = tagSet.iterator();
        while (tsit.hasNext()) {
            String tag = (String)tsit.next();
            retval.add(tag);
        }
        return retval;
    }

    private Vector getNameChoices(Set allNames) {
        Vector<String> retval = new Vector<String>();
        TreeSet nameSet = new TreeSet(allNames);
        Iterator nsit = nameSet.iterator();
        while (nsit.hasNext()) {
            String name = (String)nsit.next();
            retval.add(name);
        }
        return retval;
    }

    private Vector getValueChoices(String name) {
        Vector<String> retval = new Vector<String>();
        String normName = DataUtil.normKey(name);
        TreeSet valSet = new TreeSet((Set)this.valsForNames_.get(normName));
        Iterator vsit = valSet.iterator();
        while (vsit.hasNext()) {
            String val = (String)vsit.next();
            retval.add(val);
        }
        return retval;
    }

    private boolean doSearch() {
        int whichTab = this.tabPane_.getSelectedIndex();
        if (whichTab == 0) {
            int selectionType;
            boolean includeLinks;
            boolean includeItem;
            int matchType = ((ChoiceContent)this.matchTypeCombo_.getSelectedItem()).val;
            if (this.directSearch_.isSelected()) {
                includeItem = false;
                includeLinks = false;
                selectionType = 2;
            } else {
                includeItem = this.includeItemBox_.isSelected();
                boolean bl = includeLinks = !this.linksHidden_ && this.includeLinksBox_.isSelected();
                if (this.targetSearch_.isSelected()) {
                    selectionType = 0;
                } else if (this.sourceSearch_.isSelected()) {
                    selectionType = 1;
                } else {
                    throw new IllegalStateException();
                }
            }
            String search = this.normalizeSearchString(this.stringField_.getText().trim());
            SourceAndTargetSelector sats = new SourceAndTargetSelector(this.parent_, this.genome_, this.layoutID_, this.pre_, this.frc_, this.undom_);
            HashSet<String> found = new HashSet<String>();
            Iterator nit = this.genome_.getAllNodeIterator();
            while (nit.hasNext()) {
                Node node = (Node)nit.next();
                if (!this.matches(search, node.getName(), matchType)) continue;
                found.add(node.getID());
            }
            boolean clearCurrent = !this.addToCurrentBox_.isSelected();
            this.itemFound_ = sats.doSelection(found, selectionType, includeItem, includeLinks, clearCurrent);
        } else {
            ChoiceContent cc = (ChoiceContent)this.moduleMethodChoices_.getSelectedItem();
            int searchMode = cc.val;
            boolean useTags = searchMode == 0;
            String tagVal = null;
            NameValuePair nvp = null;
            if (useTags) {
                tagVal = (String)this.moduleTagChoices_.getSelectedItem();
            } else {
                String currName = (String)this.moduleNameChoices_.getSelectedItem();
                String currVal = (String)this.moduleValueChoices_.getSelectedItem();
                nvp = new NameValuePair(currName, currVal);
            }
            NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(this.genome_.getID());
            Map allMatchMods = owner.findMatchingNetworkModules(searchMode, tagVal, nvp);
            Set matchMods = (Set)allMatchMods.get(this.currOvr_);
            boolean bl = this.itemFound_ = matchMods != null && !matchMods.isEmpty();
            if (this.itemFound_) {
                UndoSupport support = new UndoSupport(this.undom_, "undo.networkModuleSearch");
                NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                TaggedSet matches = new TaggedSet(-1, matchMods);
                noc.setFullOverlayState(this.currOvr_, matches, noc.getCurrentRevealed(), support);
                support.finish();
            }
        }
        return this.itemFound_;
    }

    private boolean matches(String searchString, String nodeName, int matchType) {
        String canonicalNodeName = DataUtil.normKey(nodeName);
        switch (matchType) {
            case 0: {
                return canonicalNodeName.equals(searchString);
            }
            case 1: {
                return canonicalNodeName.indexOf(searchString) != -1;
            }
        }
        throw new IllegalArgumentException();
    }

    private String normalizeSearchString(String searchString) {
        return DataUtil.normKey(searchString);
    }

    private class ButtonTracker
    implements ActionListener {
        private ButtonTracker() {
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                boolean isDirect = NodeSearchDialog.this.directSearch_.isSelected();
                NodeSearchDialog.this.includeItemBox_.setEnabled(!isDirect);
                NodeSearchDialog.this.includeLinksBox_.setEnabled(!NodeSearchDialog.this.linksHidden_ && !isDirect);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

