/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.DataPopupManager;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.dialogs.utils.UsageSelector;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class NodeUsageDisplayFrame
extends JFrame
implements ListSelectionListener {
    private FixedJButton gotoButton_;
    private UsageSelector usageSel_;
    private JList jlist_;
    private String nodeID_;
    private boolean processing_;

    public NodeUsageDisplayFrame(JFrame parent, String nodeID, GenomePresentation pre) {
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        this.setIconImage(new ImageIcon(ugif).getImage());
        this.nodeID_ = nodeID;
        this.setNodeTitle();
        final String closeID = nodeID;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DataPopupManager.getPopupMgr().dropSelectionWindow(closeID);
            }
        });
        this.usageSel_ = new UsageSelector(this, pre);
        this.processing_ = false;
        this.setSize(500, 700);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        JLabel lab = new JLabel(rMan.getString("nudd.usages"));
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        cp.add((Component)lab, gbc);
        this.jlist_ = new JList();
        this.jlist_.setSelectionMode(0);
        this.refreshList();
        JScrollPane jsp = new JScrollPane(this.jlist_);
        UiUtil.gbcSet(gbc, 0, 1, 1, 20, 1, 0, 0, 0, 0, 0, 0, 17, 1.0, 1.0);
        cp.add((Component)jsp, gbc);
        this.jlist_.addListSelectionListener(this);
        this.gotoButton_ = new FixedJButton(rMan.getString("nudd.goto"));
        this.gotoButton_.setEnabled(false);
        this.gotoButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    NodeUsageDisplayFrame.this.usageSel_.goToModelAndSelectNode();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonO = new FixedJButton(rMan.getString("dialogs.close"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DataPopupManager.getPopupMgr().dropSelectionWindow(closeID);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.gotoButton_);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        UiUtil.gbcSet(gbc, 0, 22, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public void valueChanged(ListSelectionEvent lse) {
        try {
            if (this.processing_) {
                return;
            }
            if (lse.getValueIsAdjusting()) {
                return;
            }
            int[] sel = this.jlist_.getSelectedIndices();
            if (sel == null || sel.length != 1) {
                this.usageSel_.setSelected(null);
            } else {
                this.usageSel_.setSelected((UsageSelector.ListEntry)this.jlist_.getModel().getElementAt(sel[0]));
            }
            this.handleButtons();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void refreshList() {
        List usageList = this.generateNodeUsages(this.nodeID_);
        this.processing_ = true;
        this.jlist_.setListData(usageList.toArray());
        this.setNodeTitle();
        this.processing_ = false;
    }

    private void handleButtons() {
        UsageSelector.ListEntry sel = this.usageSel_.getSelected();
        this.gotoButton_.setEnabled(sel != null && sel.modelID != null);
        this.gotoButton_.revalidate();
    }

    private Node getTheBaseNode(String nodeID) {
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        Node rootNode = genome.getNode(baseID);
        return rootNode;
    }

    private String getNodeName(Node rootNode) {
        String name = rootNode == null ? "" : rootNode.getName();
        return name;
    }

    private void setNodeTitle() {
        ResourceManager rMan = ResourceManager.getManager();
        String titleFormat = rMan.getString("nudd.titleFormat");
        Node rootNode = this.getTheBaseNode(this.nodeID_);
        String name = this.getNodeName(rootNode);
        String msg = MessageFormat.format(titleFormat, name);
        this.setTitle(msg);
    }

    private List generateNodeUsages(String nodeID) {
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        ArrayList<UsageSelector.ListEntry> usageList = new ArrayList<UsageSelector.ListEntry>();
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        ResourceManager rMan = ResourceManager.getManager();
        String instanceFormat = rMan.getString("toolCmd.instanceNodeUsageFormat");
        String dynMessage = rMan.getString("toolCmd.dynamicNodeUsageFormat");
        String noGroup = rMan.getString("toolCmd.noGroup");
        Node rootNode = genome.getNode(baseID);
        if (rootNode == null) {
            return usageList;
        }
        String fullUse = rMan.getString("toolCmd.fullGenomeNodeUsage");
        UsageSelector.ListEntry le = new UsageSelector.ListEntry(fullUse, genome.getID(), baseID);
        usageList.add(le);
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            String giName = gi.getName();
            Set niSet = gi.getNodeInstances(baseID);
            Iterator nisit = niSet.iterator();
            while (nisit.hasNext()) {
                String nodeInstID = (String)nisit.next();
                Group grp = gi.getGroupForNode(nodeInstID, 1);
                String grpName = grp == null ? noGroup : grp.getInheritedDisplayName(gi);
                String msg = MessageFormat.format(instanceFormat, giName, grpName);
                UsageSelector.ListEntry le1 = new UsageSelector.ListEntry(msg, gi.getID(), nodeInstID);
                usageList.add(le1);
            }
            if (niSet.isEmpty() || !gi.haveProxyDecendant()) continue;
            String msg = MessageFormat.format(dynMessage, giName);
            UsageSelector.ListEntry le1 = new UsageSelector.ListEntry(msg, null, null);
            usageList.add(le1);
        }
        return usageList;
    }
}

