/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.LocalGenomeSource;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.dialogs.PathDisplay;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PathDialog
extends JDialog {
    private PathDisplay pd_;

    public PathDialog(JFrame parent, String giKey, String srcID, String targID, Layout colorRef, FontRenderContext frc, boolean showQPCR) {
        super(parent, ResourceManager.getManager().getString("showPath.title"), true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (PathDialog.this.pd_ != null) {
                    PathDialog.this.pd_.unregister();
                }
            }
        });
        Database db = Database.getDB();
        LocalGenomeSource gSrc = new LocalGenomeSource(db.getGenome(), db.getGenome(giKey));
        this.pd_ = new PathDisplay(gSrc, giKey, srcID, targID, colorRef, frc, showQPCR, false, 4);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(1200, 550);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        cp.setMinimumSize(new Dimension(200, 200));
        cp.setPreferredSize(new Dimension(200, 200));
        GridBagConstraints gbc = new GridBagConstraints();
        UiUtil.gbcSet(gbc, 1, 11, 9, 10, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        cp.add((Component)this.pd_, gbc);
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.close"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    PathDialog.this.setVisible(false);
                    PathDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonC);
        buttonPanel.add(Box.createHorizontalStrut(10));
        UiUtil.gbcSet(gbc, 0, 21, 10, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }
}

