/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.analysis.Path;
import org.systemsbiology.biotapestry.analysis.PathAnalyzer;
import org.systemsbiology.biotapestry.analysis.PathRanker;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.AllPathsLayoutBuilder;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.dialogs.PathDisplayTracker;
import org.systemsbiology.biotapestry.ui.dialogs.PathPanel;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PathDisplay
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final int PLUS_ICON_ = 0;
    private static final int MINUS_ICON_ = 1;
    private static final int QUESTION_ICON_ = 2;
    private static final int AVOID_ICON_ = 3;
    private static final int NUM_ICONS_ = 4;
    private PathPanel pp_;
    private int defaultDepth_;
    private JComboBox depthCombo_;
    private String srcID_;
    private String targID_;
    private GenomeSource gSrc_;
    private String genomeID_;
    private FontRenderContext frc_;
    private Layout colorRef_;
    private Layout aprLayout_;
    private JScrollPane jsp_;
    private JList pathList_;
    private PathRenderer listRenderer_;
    private boolean showQPCR_;
    private boolean ignore_;
    private PathDisplayTracker pathTracker_;
    private PathRanker pathRanker_;
    private int maxDepth_;

    public PathDisplay(GenomeSource gSrc, String genomeID, String srcID, String targID, Layout colorRef, FontRenderContext frc, boolean showQPCR, boolean compressedLayout, int defaultDepth) {
        ArrayList paths;
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/LinkPlus.gif");
        ImageIcon[] icons = new ImageIcon[4];
        icons[0] = new ImageIcon(ugif);
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/LinkMinus.gif");
        icons[1] = new ImageIcon(ugif);
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/LinkQuestion.gif");
        icons[2] = new ImageIcon(ugif);
        ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/LinkAvoid.gif");
        icons[3] = new ImageIcon(ugif);
        ResourceManager rMan = ResourceManager.getManager();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.ignore_ = false;
        this.maxDepth_ = 10;
        this.defaultDepth_ = defaultDepth;
        this.srcID_ = srcID;
        this.targID_ = targID;
        this.frc_ = frc;
        this.colorRef_ = colorRef;
        this.showQPCR_ = showQPCR;
        this.gSrc_ = gSrc;
        this.genomeID_ = genomeID;
        AllPathsResult result = null;
        if (this.srcID_ != null && this.targID_ != null) {
            result = new PathAnalyzer().getAllPaths(genomeID, this.srcID_, this.targID_, this.defaultDepth_, this.gSrc_);
            this.aprLayout_ = new AllPathsLayoutBuilder().buildLayout(result, genomeID, frc, colorRef, this.gSrc_);
        } else {
            this.aprLayout_ = null;
        }
        this.pp_ = new PathPanel(result, showQPCR);
        this.pp_.setGenome(this.gSrc_.getGenome(this.genomeID_));
        this.pp_.setGraphLayout(this.aprLayout_);
        this.pp_.setMinimumSize(new Dimension(200, 200));
        this.pp_.setPreferredSize(new Dimension(200, 200));
        this.jsp_ = new JScrollPane(this.pp_);
        this.jsp_.setHorizontalScrollBarPolicy(30);
        this.jsp_.setVerticalScrollBarPolicy(20);
        UiUtil.gbcSet(gbc, 0, 0, 10, 10, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        this.add((Component)this.jsp_, gbc);
        JLabel label = new JLabel(rMan.getString("showPath.depth"));
        Vector<Integer> depths = new Vector<Integer>();
        for (int i = 1; i <= this.maxDepth_; ++i) {
            depths.add(new Integer(i));
        }
        this.depthCombo_ = new JComboBox(depths);
        this.depthCombo_.setSelectedIndex(this.defaultDepth_ - 1);
        this.depthCombo_.addActionListener(this);
        if (compressedLayout) {
            UiUtil.gbcSet(gbc, 0, 10, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        } else {
            UiUtil.gbcSet(gbc, 0, 10, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        }
        this.add((Component)label, gbc);
        if (compressedLayout) {
            UiUtil.gbcSet(gbc, 1, 10, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        } else {
            UiUtil.gbcSet(gbc, 1, 10, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        }
        this.add((Component)this.depthCombo_, gbc);
        if (result != null) {
            paths = result.getPaths();
            if (this.pathRanker_ != null) {
                this.pathRanker_.rankPaths(paths);
            }
            Collections.sort(paths);
        } else {
            paths = new ArrayList();
        }
        List augPaths = this.buildAugmentedPathList(paths, showQPCR);
        this.pathList_ = new JList<Object>(augPaths.toArray());
        this.pathList_.setSelectionMode(0);
        this.pathList_.addListSelectionListener(this);
        this.listRenderer_ = new PathRenderer(augPaths, icons);
        this.pathList_.setCellRenderer(this.listRenderer_);
        label = new JLabel(rMan.getString("showPath.paths"));
        if (compressedLayout) {
            UiUtil.gbcSet(gbc, 2, 10, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        } else {
            UiUtil.gbcSet(gbc, 0, 11, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        }
        this.add((Component)label, gbc);
        JScrollPane jsp = new JScrollPane(this.pathList_);
        if (compressedLayout) {
            UiUtil.gbcSet(gbc, 3, 10, 7, 6, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        } else {
            UiUtil.gbcSet(gbc, 1, 11, 9, 10, 1, 0, 0, 5, 5, 5, 5, 17, 1.0, 1.0);
        }
        this.add((Component)jsp, gbc);
    }

    public void disableControls() {
        this.depthCombo_.setEnabled(false);
        this.jsp_.setEnabled(false);
        this.pathList_.setEnabled(false);
    }

    public void enableControls() {
        this.depthCombo_.setEnabled(true);
        this.jsp_.setEnabled(true);
        this.pathList_.setEnabled(true);
    }

    public void unregister() {
        this.pp_.unregister();
    }

    public void installNewData(GenomeSource gSrc, String genomeID, String srcID, String targID, Path matchPath) {
        this.genomeID_ = genomeID;
        this.gSrc_ = gSrc;
        this.srcID_ = srcID;
        this.targID_ = targID;
        this.ignore_ = true;
        int currDepth = this.defaultDepth_;
        boolean tooDeep = false;
        if (matchPath != null) {
            int depth = matchPath.getDepth();
            if (depth <= this.maxDepth_) {
                currDepth = depth;
            } else {
                tooDeep = true;
            }
        }
        this.ignore_ = true;
        this.depthCombo_.setSelectedIndex(currDepth - 1);
        this.ignore_ = false;
        AllPathsResult result = new PathAnalyzer().getAllPaths(this.genomeID_, this.srcID_, this.targID_, currDepth, this.gSrc_);
        this.pp_.setResult(result);
        this.pp_.setGenome(this.gSrc_.getGenome(this.genomeID_));
        this.aprLayout_ = new AllPathsLayoutBuilder().buildLayout(result, this.genomeID_, this.frc_, this.colorRef_, this.gSrc_);
        List paths = result.getPaths();
        if (this.pathRanker_ != null) {
            this.pathRanker_.rankPaths(paths);
        }
        Collections.sort(paths);
        List augPaths = this.buildAugmentedPathList(paths, this.showQPCR_);
        this.listRenderer_.setValues(augPaths);
        this.pathList_.setListData(augPaths.toArray());
        this.pathList_.clearSelection();
        this.ignore_ = false;
        this.pp_.setSelectionMap(new HashMap());
        this.pp_.setGraphLayout(this.aprLayout_);
        this.jsp_.getViewport().setViewSize(this.pp_.getPreferredSize());
        this.jsp_.getViewport().invalidate();
        this.jsp_.validate();
        this.pp_.revalidate();
        if (this.pathList_.getModel().getSize() > 0) {
            boolean wasSet = false;
            if (matchPath != null && !tooDeep) {
                String matchStr = matchPath.toString();
                int numAug = augPaths.size();
                for (int i = 0; i < numAug; ++i) {
                    QpcrAugmentedPath augPath = (QpcrAugmentedPath)augPaths.get(i);
                    if (!matchStr.equals(augPath.toString())) continue;
                    this.pathList_.setSelectedIndex(i);
                    wasSet = true;
                    break;
                }
            }
            if (!wasSet) {
                this.pathList_.setSelectedIndex(0);
            }
        }
    }

    public void clear() {
        this.genomeID_ = null;
        this.gSrc_ = null;
        this.srcID_ = null;
        this.targID_ = null;
        this.ignore_ = true;
        int currDepth = this.defaultDepth_;
        this.depthCombo_.setSelectedIndex(currDepth - 1);
        this.pp_.setResult(new AllPathsResult(null, null));
        this.pp_.setGenome(null);
        this.aprLayout_ = null;
        this.listRenderer_.setValues(new ArrayList());
        this.pathList_.setListData(new Object[0]);
        this.pathList_.clearSelection();
        this.pp_.setSelectionMap(new HashMap());
        this.pp_.setGraphLayout(null);
        this.jsp_.getViewport().setViewSize(this.pp_.getPreferredSize());
        this.jsp_.getViewport().invalidate();
        this.jsp_.validate();
        this.pp_.revalidate();
        if (this.pathTracker_ != null) {
            this.pathTracker_.newPathSelected(new ArrayList());
        }
        this.ignore_ = false;
    }

    public void centerView() {
        this.pp_.setupTransform();
        Point pt = this.pp_.getCenterPoint();
        JScrollBar vsb = this.jsp_.getVerticalScrollBar();
        JScrollBar hsb = this.jsp_.getHorizontalScrollBar();
        int vAmt = vsb.getVisibleAmount();
        int hAmt = hsb.getVisibleAmount();
        int newV = pt.y - vAmt / 2;
        int newH = pt.x - hAmt / 2;
        this.jsp_.getViewport().setViewSize(this.pp_.getPreferredSize());
        this.jsp_.getViewport().setViewPosition(new Point(newH, newV));
        this.jsp_.getViewport().invalidate();
        this.jsp_.validate();
        this.pp_.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.ignore_ || this.genomeID_ == null) {
                return;
            }
            int newDepth = this.depthCombo_.getSelectedIndex() + 1;
            AllPathsResult result = new PathAnalyzer().getAllPaths(this.genomeID_, this.srcID_, this.targID_, newDepth, this.gSrc_);
            this.pp_.setResult(result);
            this.aprLayout_ = new AllPathsLayoutBuilder().buildLayout(result, this.genomeID_, this.frc_, this.colorRef_, this.gSrc_);
            List paths = result.getPaths();
            if (this.pathRanker_ != null) {
                this.pathRanker_.rankPaths(paths);
            }
            Collections.sort(paths);
            List augPaths = this.buildAugmentedPathList(paths, this.showQPCR_);
            this.listRenderer_.setValues(augPaths);
            this.pathList_.setListData(augPaths.toArray());
            this.pathList_.clearSelection();
            this.pp_.setSelectionMap(new HashMap());
            this.pp_.setGraphLayout(this.aprLayout_);
            this.jsp_.getViewport().setViewSize(this.pp_.getPreferredSize());
            this.jsp_.getViewport().invalidate();
            this.jsp_.validate();
            this.pp_.revalidate();
            this.pp_.repaint();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.ignore_) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            HashMap<String, Intersection> selectionMap = new HashMap<String, Intersection>();
            QpcrAugmentedPath selected = (QpcrAugmentedPath)this.pathList_.getSelectedValue();
            LinkageFree linkRender = new LinkageFree();
            ArrayList<String> currentPath = new ArrayList<String>();
            if (selected != null) {
                Iterator pit = selected.getPath().pathIterator();
                while (pit.hasNext()) {
                    Linkage link = (Linkage)pit.next();
                    String source = link.getSource();
                    currentPath.add(source);
                    selectionMap.put(source, new Intersection(source, null, 0.0));
                    Intersection linkInt = linkRender.pathIntersection(this.gSrc_.getGenome(this.genomeID_), link, this.aprLayout_, this.frc_);
                    selectionMap.put(link.getID(), linkInt);
                }
                String target = selected.getPath().getEnd();
                currentPath.add(target);
                selectionMap.put(target, new Intersection(target, null, 0.0));
            }
            this.pp_.setSelectionMap(selectionMap);
            this.pp_.repaint();
            if (this.pathTracker_ != null) {
                this.pathTracker_.newPathSelected(currentPath);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void setPathTracker(PathDisplayTracker tracker) {
        this.pathTracker_ = tracker;
    }

    public void setPathRanker(PathRanker ranker) {
        this.pathRanker_ = ranker;
    }

    private List buildAugmentedPathList(List pathList, boolean addQPCR) {
        ArrayList<QpcrAugmentedPath> retval = new ArrayList<QpcrAugmentedPath>();
        Iterator pit = pathList.iterator();
        while (pit.hasNext()) {
            Path path = (Path)pit.next();
            QpcrAugmentedPath qap = new QpcrAugmentedPath(path, addQPCR);
            retval.add(qap);
        }
        return retval;
    }

    class QpcrAugmentedPath {
        private Path path_;
        private String qpcrDataString_;

        QpcrAugmentedPath(Path path, boolean showQPCR) {
            this.path_ = path;
            this.qpcrDataString_ = showQPCR ? this.buildQPCRString() : "";
        }

        public String toString() {
            String spacer = this.qpcrDataString_.length() > 0 ? "       " : "";
            return this.path_.toString() + spacer + this.qpcrDataString_;
        }

        Path getPath() {
            return this.path_;
        }

        private String buildQPCRString() {
            PerturbationData pd = Database.getDB().getPertData();
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            Iterator pit = this.path_.pathIterator();
            while (pit.hasNext()) {
                Linkage link = (Linkage)pit.next();
                double val = pd.getPertAverageValue(GenomeItemInstance.getBaseID(link.getSource()), GenomeItemInstance.getBaseID(link.getTarget()), true);
                val = (double)Math.round(val * 100.0) / 100.0;
                buf.append(val);
                if (!pit.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class PathRenderer
    extends JLabel
    implements ListCellRenderer {
        private List values_;
        private ImageIcon[] icons_;

        PathRenderer(List values, ImageIcon[] icons) {
            this.values_ = values;
            this.icons_ = icons;
        }

        void setValues(List values) {
            this.values_ = values;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            try {
                int iconIndex;
                boolean avoid;
                if (value == null) {
                    return this;
                }
                if (index == -1 && (index = list.getSelectedIndex()) == -1) {
                    return this;
                }
                QpcrAugmentedPath currPath = (QpcrAugmentedPath)this.values_.get(index);
                boolean bl = avoid = PathDisplay.this.pathRanker_ != null && currPath.getPath().getRanking() > 1;
                if (avoid) {
                    iconIndex = 3;
                } else {
                    switch (currPath.getPath().getSign()) {
                        case -1: {
                            iconIndex = 1;
                            break;
                        }
                        case 1: {
                            iconIndex = 0;
                            break;
                        }
                        case 0: {
                            iconIndex = 2;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.setIcon(this.icons_[iconIndex]);
                this.setText(((QpcrAugmentedPath)this.values_.get(index)).toString());
                this.setOpaque(true);
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.setForeground(avoid ? Color.lightGray : Color.black);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }
}

