/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.dialogs.PathPresentation;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class PathPanel
extends JPanel {
    private PathPresentation myPre_;
    private Layout layout_ = null;
    private Genome genome_ = null;
    private AffineTransform transform_;
    private Point2D clickPoint_ = null;
    private boolean showQPCR_;

    public PathPanel(AllPathsResult allPaths, boolean showQPCR) {
        this.myPre_ = allPaths == null ? new PathPresentation() : new PathPresentation(allPaths);
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.setBackground(Color.white);
        this.showQPCR_ = showQPCR;
        if (this.showQPCR_) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        this.transform_ = new AffineTransform();
    }

    public void unregister() {
        if (this.showQPCR_) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public void paintComponent(Graphics g) {
        try {
            this.setupTransform();
            super.paintComponent(g);
            this.drawingGuts(g, this.transform_);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayPaintException(ex);
        }
    }

    public void setupTransform() {
        this.transform_ = new AffineTransform();
        Rectangle rect = this.myPre_.getRequiredSize(this.genome_, this.layout_, this.transform_);
        Dimension currentSize = this.getSize();
        double wZoom = (double)currentSize.width / (double)rect.width;
        double hZoom = (double)currentSize.height / (double)rect.height;
        double zoom = wZoom > hZoom ? hZoom : wZoom;
        this.transform_.translate((double)currentSize.width / 2.0, (double)currentSize.height / 2.0);
        this.transform_.scale(zoom, zoom);
        double centerX = (double)rect.x + (double)rect.width / 2.0;
        double centerY = (double)rect.y + (double)rect.height / 2.0;
        this.transform_.translate(-centerX, -centerY);
    }

    public void setGenome(Genome genome) {
        this.genome_ = genome;
    }

    public void setGraphLayout(Layout layout) {
        this.layout_ = layout;
    }

    public void setResult(AllPathsResult result) {
        this.myPre_.setResult(result);
    }

    public void setSelectionMap(Map selections) {
        this.myPre_.setSelectionMap(selections);
    }

    public void setSize(Dimension dim) {
        this.myPre_.setSize(dim.width, dim.height);
        super.setSize(dim);
    }

    public Point2D getChosenPoint() {
        return this.clickPoint_;
    }

    public String getToolTipText(MouseEvent event) {
        LinkSegmentID segID;
        if (!this.showQPCR_) {
            return null;
        }
        FontRenderContext frc = new FontRenderContext(this.transform_, true, true);
        Point tipPoint = event.getPoint();
        ResourceManager rMan = ResourceManager.getManager();
        try {
            this.transform_.inverseTransform(tipPoint, tipPoint);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        Intersection inter = this.myPre_.intersect(tipPoint.x, tipPoint.y, this.genome_, this.layout_, frc);
        if (inter == null) {
            return null;
        }
        String objID = inter.getObjectID();
        Node node = this.genome_.getNode(objID);
        if (node != null) {
            return node.getName();
        }
        Linkage link = this.genome_.getLinkage(objID);
        if (link == null) {
            return null;
        }
        BusProperties lp = this.layout_.getLinkProperties(objID);
        Set resolved = lp.resolveLinkagesThroughSegment(segID = inter.segmentIDFromIntersect(), this.genome_);
        if (resolved.size() > 1) {
            Node src = this.genome_.getNode(link.getSource());
            String format = rMan.getString("pathpanel.source");
            String desc = MessageFormat.format(format, src.getName());
            return desc;
        }
        objID = (String)resolved.iterator().next();
        link = this.genome_.getLinkage(objID);
        PerturbationData pd = Database.getDB().getPertData();
        String tip = pd.getToolTip(link.getSource(), link.getTarget(), null);
        if (tip == null) {
            return rMan.getString("pathpanel.noqpcr");
        }
        return tip;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public Point getCenterPoint() {
        Rectangle rect = this.myPre_.getRequiredSize(this.genome_, this.layout_, this.transform_);
        double cx = rect.getX() + rect.getWidth() / 2.0;
        double cy = rect.getY() + rect.getHeight() / 2.0;
        Point2D.Double centerPoint = new Point2D.Double(cx, cy);
        this.transform_.transform(centerPoint, centerPoint);
        int x = (int)Math.round(((Point2D)centerPoint).getX());
        int y = (int)Math.round(((Point2D)centerPoint).getY());
        int TWEAK_HACK = 5;
        Point pt = new Point(x, y + TWEAK_HACK);
        return pt;
    }

    private void drawingGuts(Graphics g, AffineTransform useTrans) {
        if (this.genome_ != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            AffineTransform saveTrans = g2.getTransform();
            g2.transform(useTrans);
            this.myPre_.presentPath(g2, this.genome_, this.layout_);
            g2.setTransform(saveTrans);
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            block4: {
                try {
                    if (PathPanel.this.clickPoint_ != null) break block4;
                    Point2D.Double movePoint = new Point2D.Double(me.getX(), me.getY());
                    try {
                        PathPanel.this.transform_.inverseTransform(movePoint, movePoint);
                    }
                    catch (NoninvertibleTransformException nitex) {
                        throw new IllegalStateException();
                    }
                    PathPanel.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private static final int CLICK_SLOP_ = 2;
        private static final int DRAG_SLOP_ = 2;
        private Point lastPress_ = null;

        public void mousePressed(MouseEvent me) {
            try {
                this.lastPress_ = new Point(me.getX(), me.getY());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
            try {
                int currX = me.getX();
                int currY = me.getY();
                if (this.lastPress_ == null) {
                    return;
                }
                int lastX = this.lastPress_.x;
                int lastY = this.lastPress_.y;
                int diffX = Math.abs(currX - lastX);
                int diffY = Math.abs(currY - lastY);
                if (diffX <= 2 && diffY <= 2) {
                    this.lastPress_ = null;
                    this.clickResult(lastX, lastY);
                } else if (diffX >= 2 || diffY >= 2) {
                    this.lastPress_ = null;
                    this.dragResult(lastX, lastY);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private void clickResult(int x, int y) {
            PathPanel.this.clickPoint_ = new Point2D.Double(x, y);
            try {
                PathPanel.this.transform_.inverseTransform(PathPanel.this.clickPoint_, PathPanel.this.clickPoint_);
            }
            catch (NoninvertibleTransformException nitex) {
                throw new IllegalStateException();
            }
            PathPanel.this.repaint();
        }

        private void dragResult(int sx, int sy) {
        }
    }
}

