/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RenderObjectCache;
import org.systemsbiology.biotapestry.ui.freerender.LinkageFree;
import org.systemsbiology.biotapestry.util.Bounds;

public class PathPresentation {
    private Rectangle cachedBounds_ = null;
    private int width_;
    private int height_;
    private AllPathsResult allPaths_;
    private Map selections_;

    public PathPresentation() {
        this.allPaths_ = null;
    }

    public PathPresentation(AllPathsResult allPaths) {
        this.allPaths_ = allPaths;
    }

    public void setResult(AllPathsResult allPaths) {
        this.allPaths_ = allPaths;
    }

    public void setSelectionMap(Map selections) {
        this.selections_ = selections;
    }

    public void presentPath(Graphics2D g2, Genome genome, Layout layout) {
        this.renderPath(g2, genome, layout);
    }

    public Rectangle getRequiredSize(Genome genome, Layout layout, AffineTransform trans) {
        GenomeInstance parentvfg;
        if (this.cachedBounds_ != null) {
            return this.cachedBounds_;
        }
        FontRenderContext frc = new FontRenderContext(trans, true, true);
        Rectangle retval = new Rectangle(0, 0, 0, 0);
        if (genome == null) {
            return retval;
        }
        if (genome instanceof GenomeInstance && (parentvfg = ((GenomeInstance)genome).getVfgParentRoot()) != null) {
            genome = parentvfg;
        }
        if (this.allPaths_ != null) {
            Iterator nit = this.allPaths_.getNodes();
            while (nit.hasNext()) {
                String nodeID = (String)nit.next();
                NodeProperties np = layout.getNodeProperties(nodeID);
                INodeRenderer rend = np.getRenderer();
                Node node = genome.getNode(nodeID);
                Rectangle bounds = rend.getBounds(genome, node, layout, frc, null);
                Bounds.tweakBounds(retval, bounds);
            }
        }
        Bounds.padBounds(retval, 100, 100);
        this.cachedBounds_ = retval;
        return retval;
    }

    public void setSize(int width, int height) {
        if (this.width_ != width || this.height_ != height) {
            this.cachedBounds_ = null;
        }
        this.width_ = width;
        this.height_ = height;
    }

    public void setTransform(AffineTransform transform) {
    }

    public Intersection intersect(int x, int y, Genome genome, Layout layout, FontRenderContext frc) {
        Point2D.Float pt = new Point2D.Float(x, y);
        Iterator lit = this.allPaths_.getLinks();
        while (lit.hasNext()) {
            Linkage link;
            String linkID = (String)lit.next();
            LinkageFree render = (LinkageFree)layout.getLinkProperties(linkID).getRenderer();
            Intersection inter = render.intersects(genome, (GenomeItem)(link = genome.getLinkage(linkID)), layout, frc, pt, 0.0, null);
            if (inter == null) continue;
            return inter;
        }
        Iterator nit = this.allPaths_.getNodes();
        while (nit.hasNext()) {
            Node node;
            String nodeID = (String)nit.next();
            INodeRenderer render = layout.getNodeProperties(nodeID).getRenderer();
            Intersection inter = render.intersects(genome, (GenomeItem)(node = genome.getNode(nodeID)), layout, frc, pt, 0.0, null);
            if (inter == null) continue;
            return inter;
        }
        return null;
    }

    private void renderPath(Graphics2D g2, Genome genome, Layout layout) {
        Intersection inter;
        LinkageFree render;
        Linkage link;
        BusProperties lp;
        String linkID;
        if (this.allPaths_ == null) {
            return;
        }
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions ddopt = dopmgr.getDisplayOptions();
        LinkageFree.AugmentedDisplayOptions adopt = new LinkageFree.AugmentedDisplayOptions(ddopt, null);
        Iterator nit = this.allPaths_.getNodes();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            NodeProperties np = layout.getNodeProperties(nodeID);
            INodeRenderer rend = np.getRenderer();
            Node node = genome.getNode(nodeID);
            Intersection inter2 = this.selections_ == null ? null : (Intersection)this.selections_.get(nodeID);
            rend.render(g2, null, genome, node, layout, inter2, false, false, null, 0.0, ddopt);
        }
        RenderObjectCache roc = new RenderObjectCache();
        HashSet<BusProperties> renderedBuses = new HashSet<BusProperties>();
        if (this.selections_ != null) {
            Iterator slit = this.selections_.keySet().iterator();
            while (slit.hasNext()) {
                linkID = (String)slit.next();
                lp = layout.getLinkProperties(linkID);
                if (lp == null || renderedBuses.contains(lp)) continue;
                renderedBuses.add(lp);
                link = genome.getLinkage(linkID);
                render = (LinkageFree)lp.getRenderer();
                inter = (Intersection)this.selections_.get(linkID);
                render.render(g2, roc, genome, link, layout, inter, false, false, null, 0.0, adopt);
            }
            roc.render(g2);
        }
        roc.clear();
        Iterator lit = this.allPaths_.getLinks();
        while (lit.hasNext()) {
            linkID = (String)lit.next();
            lp = layout.getLinkProperties(linkID);
            if (lp == null) {
                System.err.println("No linkProperties for " + linkID);
                throw new IllegalStateException();
            }
            if (renderedBuses.contains(lp)) continue;
            renderedBuses.add(lp);
            link = genome.getLinkage(linkID);
            render = (LinkageFree)lp.getRenderer();
            inter = this.selections_ == null ? null : (Intersection)this.selections_.get(linkID);
            render.render(g2, roc, genome, link, layout, inter, false, false, null, 0.0, adopt);
        }
        roc.render(g2);
    }
}

