/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.perturb.BatchCollision;
import org.systemsbiology.biotapestry.ui.dialogs.utils.DialogSupport;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class BatchDupReportDialog
extends JDialog
implements DialogSupport.DialogSupportClient {
    private ReadOnlyTable rot_;
    private Map batchDups_;
    private boolean keepGoing_;

    public BatchDupReportDialog(JFrame parent, Map batchDups, String windowTitle, String tableTitle) {
        super(parent, ResourceManager.getManager().getString(windowTitle), true);
        this.batchDups_ = batchDups;
        this.keepGoing_ = false;
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(1000, 650);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        this.rot_ = new ReadOnlyTable(new BatchDupReportModel(), null);
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = true;
        tp.buttons = 0;
        tp.multiTableSelectionSyncing = null;
        tp.tableTitle = rMan.getString(tableTitle);
        tp.titleFont = null;
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 200, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 100, 150, 200));
        colWidths.add(new ReadOnlyTable.ColumnWidths(2, 200, 200, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(3, 200, 200, Integer.MAX_VALUE));
        tp.colWidths = colWidths;
        tp.canMultiSelect = false;
        JPanel tabPan = this.rot_.buildReadOnlyTable(tp);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)tabPan, gbc);
        DialogSupport ds = new DialogSupport(this, rMan, gbc);
        ds.buildAndInstallCenteredButtonBox(cp, rowNum += 8, 1, false, true);
        this.setLocationRelativeTo(parent);
        this.displayProperties();
    }

    public void applyAction() {
        throw new UnsupportedOperationException();
    }

    public void okAction() {
        this.keepGoing_ = true;
        this.setVisible(false);
        this.dispose();
    }

    public void closeAction() {
        this.keepGoing_ = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean keepGoing() {
        return this.keepGoing_;
    }

    private void displayProperties() {
        List tableRows = this.initTableRows();
        ((BatchDupReportModel)this.rot_.getModel()).extractValues(tableRows);
    }

    private List initTableRows() {
        StringBuffer buf = new StringBuffer();
        ArrayList<BatchDupReportModel.TableRow> retval = new ArrayList<BatchDupReportModel.TableRow>();
        ResourceManager rMan = ResourceManager.getManager();
        BatchDupReportModel ctm = (BatchDupReportModel)this.rot_.getModel();
        Iterator nbit = this.batchDups_.keySet().iterator();
        while (nbit.hasNext()) {
            String expDesc = (String)nbit.next();
            Map dups = (Map)this.batchDups_.get(expDesc);
            Iterator tidit = dups.keySet().iterator();
            while (tidit.hasNext()) {
                String targetID = (String)tidit.next();
                Map batches = (Map)dups.get(targetID);
                Iterator bidit = batches.keySet().iterator();
                while (bidit.hasNext()) {
                    String batchID = (String)bidit.next();
                    BatchCollision bc = (BatchCollision)batches.get(batchID);
                    BatchDupReportModel.TableRow tr = ctm.new BatchDupReportModel.TableRow();
                    tr.expDesc = bc.expDesc;
                    tr.targetName = bc.targetName;
                    tr.batchName = bc.batchID;
                    buf.setLength(0);
                    int numVal = bc.vals.size();
                    for (int i = 0; i < numVal; ++i) {
                        buf.append((String)bc.vals.get(i));
                        if (i >= numVal - 1) continue;
                        buf.append(", ");
                    }
                    tr.dataVals = buf.toString();
                    retval.add(tr);
                }
            }
        }
        return retval;
    }

    private class BatchDupReportModel
    extends ReadOnlyTable.TableModel {
        static final int EXPERIMENT_DESC = 0;
        static final int TARGET_NAME = 1;
        static final int BATCH_NAME = 2;
        static final int DATA_VALS = 3;
        private static final int NUM_COL_ = 4;

        BatchDupReportModel() {
            super(4);
            this.colNames_ = new String[]{"batchDupReport.expDesc", "batchDupReport.target", "batchDupReport.batchID", "batchDupReport.dataVals"};
        }

        List getValuesFromTable() {
            ArrayList<TableRow> retval = new ArrayList<TableRow>();
            for (int i = 0; i < this.rowCount_; ++i) {
                TableRow ent = new TableRow(i);
                retval.add(ent);
            }
            return retval;
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            Iterator rit = prsList.iterator();
            while (rit.hasNext()) {
                TableRow ent = (TableRow)rit.next();
                ent.toCols();
            }
        }

        class TableRow {
            String expDesc;
            String targetName;
            String batchName;
            String dataVals;

            TableRow() {
            }

            TableRow(int i) {
                this.expDesc = (String)BatchDupReportModel.this.columns_[0].get(i);
                this.targetName = (String)BatchDupReportModel.this.columns_[1].get(i);
                this.batchName = (String)BatchDupReportModel.this.columns_[2].get(i);
                this.dataVals = (String)BatchDupReportModel.this.columns_[3].get(i);
            }

            void toCols() {
                BatchDupReportModel.this.columns_[0].add(this.expDesc);
                BatchDupReportModel.this.columns_[1].add(this.targetName);
                BatchDupReportModel.this.columns_[2].add(this.batchName);
                BatchDupReportModel.this.columns_[3].add(this.dataVals);
            }
        }
    }
}

