/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.DialogSupport;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;

public class NewbieReportingDialog
extends JDialog
implements DialogSupport.DialogSupportClient {
    private ReadOnlyTable rot_;
    private Map newbies_;
    private Map closest_;
    private boolean keepGoing_;

    public NewbieReportingDialog(JFrame parent, Map newbies, Map newbieClosest) {
        super(parent, ResourceManager.getManager().getString("newbieReport.dialogTitle"), true);
        this.newbies_ = newbies;
        this.closest_ = newbieClosest;
        this.keepGoing_ = false;
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(1000, 650);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        this.rot_ = new ReadOnlyTable(new NewbieReportModel(), null);
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = true;
        tp.buttons = 0;
        tp.multiTableSelectionSyncing = null;
        tp.tableTitle = rMan.getString("newbieReport.tableTitle");
        tp.titleFont = null;
        ArrayList<ReadOnlyTable.ColumnWidths> colWidths = new ArrayList<ReadOnlyTable.ColumnWidths>();
        colWidths.add(new ReadOnlyTable.ColumnWidths(0, 100, 150, 200));
        colWidths.add(new ReadOnlyTable.ColumnWidths(1, 200, 200, Integer.MAX_VALUE));
        colWidths.add(new ReadOnlyTable.ColumnWidths(2, 200, 200, Integer.MAX_VALUE));
        tp.colWidths = colWidths;
        tp.canMultiSelect = false;
        JPanel tabPan = this.rot_.buildReadOnlyTable(tp);
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)tabPan, gbc);
        DialogSupport ds = new DialogSupport(this, rMan, gbc);
        ds.buildAndInstallCenteredButtonBox(cp, rowNum += 8, 1, false, true);
        this.setLocationRelativeTo(parent);
        this.displayProperties();
    }

    public void applyAction() {
        throw new UnsupportedOperationException();
    }

    public void okAction() {
        this.keepGoing_ = true;
        this.setVisible(false);
        this.dispose();
    }

    public void closeAction() {
        this.keepGoing_ = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean keepGoing() {
        return this.keepGoing_;
    }

    private void displayProperties() {
        List tableRows = this.initTableRows();
        ((NewbieReportModel)this.rot_.getModel()).extractValues(tableRows);
    }

    private List initTableRows() {
        ArrayList<NewbieReportModel.TableRow> retval = new ArrayList<NewbieReportModel.TableRow>();
        ResourceManager rMan = ResourceManager.getManager();
        NewbieReportModel ctm = (NewbieReportModel)this.rot_.getModel();
        Iterator nbit = this.newbies_.keySet().iterator();
        while (nbit.hasNext()) {
            String newbieClass = (String)nbit.next();
            Set newbiesForClass = (Set)this.newbies_.get(newbieClass);
            Map closestForClass = (Map)this.closest_.get(newbieClass);
            Iterator nfcit = newbiesForClass.iterator();
            while (nfcit.hasNext()) {
                String newbie = (String)nfcit.next();
                String suggest = null;
                if (closestForClass != null) {
                    suggest = (String)closestForClass.get(newbie);
                }
                NewbieReportModel.TableRow tr = ctm.new NewbieReportModel.TableRow();
                tr.newbieClass = rMan.getString("newbieClass." + newbieClass);
                tr.newbieName = newbie;
                tr.newbieAlt = suggest != null ? suggest : "";
                retval.add(tr);
            }
        }
        return retval;
    }

    private class NewbieReportModel
    extends ReadOnlyTable.TableModel {
        static final int NEWBIE_CLASS = 0;
        static final int NEWBIE_NAME = 1;
        static final int NEWBIE_ALT = 2;
        private static final int NUM_COL_ = 3;

        NewbieReportModel() {
            super(3);
            this.colNames_ = new String[]{"newbieReport.class", "newbieReport.name", "newbieReport.alternative"};
        }

        List getValuesFromTable() {
            ArrayList<TableRow> retval = new ArrayList<TableRow>();
            for (int i = 0; i < this.rowCount_; ++i) {
                TableRow ent = new TableRow(i);
                retval.add(ent);
            }
            return retval;
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            Iterator rit = prsList.iterator();
            while (rit.hasNext()) {
                TableRow ent = (TableRow)rit.next();
                ent.toCols();
            }
        }

        class TableRow {
            String newbieClass;
            String newbieName;
            String newbieAlt;

            TableRow() {
            }

            TableRow(int i) {
                this.newbieClass = (String)NewbieReportModel.this.columns_[0].get(i);
                this.newbieName = (String)NewbieReportModel.this.columns_[1].get(i);
                this.newbieAlt = (String)NewbieReportModel.this.columns_[2].get(i);
            }

            void toCols() {
                NewbieReportModel.this.columns_[0].add(this.newbieClass);
                NewbieReportModel.this.columns_[1].add(this.newbieName);
                NewbieReportModel.this.columns_[2].add(this.newbieAlt);
            }
        }
    }
}

