/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitEditPanel;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.UiUtil;

public class PertAnnotEditPanel
extends AnimatedSplitEditPanel {
    private JComboBox tagCombo_;
    private JTextField messageField_;
    private JComboBox tagComboMrg_;
    private JComboBox messageCombo_;
    private PerturbationData pd_;
    private String currKey_;
    private String copyMsg_;
    private String copyTag_;
    private SortedSet tagOptions_;
    private SortedSet nameOptions_;
    private List allMerge_;
    private String tagResult_;
    private String msgResult_;

    public PertAnnotEditPanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, String myKey) {
        super(parent, pet, myKey, 5);
        this.pd_ = pd;
        this.currKey_ = null;
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        JLabel tagLabel = new JLabel(this.rMan_.getString("pertAnnotEdit.tag"));
        this.tagCombo_ = new JComboBox();
        this.tagCombo_.setEditable(true);
        UiUtil.gbcSet(this.gbc_, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        editPanel.add((Component)tagLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, 0, 4, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        editPanel.add((Component)this.tagCombo_, this.gbc_);
        JLabel messageLabel = new JLabel(this.rMan_.getString("pertAnnotEdit.message"));
        this.messageField_ = new JTextField();
        UiUtil.gbcSet(this.gbc_, 0, 1, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        editPanel.add((Component)messageLabel, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, 1, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        editPanel.add((Component)this.messageField_, this.gbc_);
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        JLabel tagLabel2 = new JLabel(this.rMan_.getString("pertAnnotEdit.tag"));
        this.tagComboMrg_ = new JComboBox();
        this.tagComboMrg_.setEditable(true);
        UiUtil.gbcSet(this.gbc_, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        mergePanel.add((Component)tagLabel2, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, 0, 4, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        mergePanel.add((Component)this.tagComboMrg_, this.gbc_);
        JLabel messageLabel2 = new JLabel(this.rMan_.getString("pertAnnotEdit.message"));
        this.messageCombo_ = new JComboBox();
        this.messageCombo_.setEditable(true);
        UiUtil.gbcSet(this.gbc_, 0, 1, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        mergePanel.add((Component)messageLabel2, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, 1, 4, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        mergePanel.add((Component)this.messageCombo_, this.gbc_);
        this.makeMultiMode(editPanel, mergePanel, 2);
        this.finishConstruction();
    }

    public String getMessageResult() {
        return this.msgResult_;
    }

    public String getTagResult() {
        return this.tagResult_;
    }

    public void setEditAnnotation(String key) {
        this.mode_ = 1;
        this.currKey_ = key;
        this.displayProperties();
    }

    public void setDupAnnotation(String copyTag, String copyName) {
        this.mode_ = 3;
        this.currKey_ = null;
        this.copyMsg_ = copyName;
        this.copyTag_ = copyTag;
        this.displayProperties();
    }

    public void setMergeName(List allKeys, String key, SortedSet nameOptions, SortedSet tagOptions) {
        this.mode_ = 2;
        this.currKey_ = key;
        this.nameOptions_ = nameOptions;
        this.tagOptions_ = tagOptions;
        this.allMerge_ = allKeys;
        this.displayProperties();
    }

    protected AnimatedSplitEditPanel.FreezeDried getFreezeDriedState() {
        return new MyFreezeDried();
    }

    protected void updateOptions() {
        if (this.mode_ == 2) {
            UiUtil.replaceComboItems(this.tagComboMrg_, new Vector(this.tagOptions_));
            UiUtil.replaceComboItems(this.messageCombo_, new Vector(this.nameOptions_));
        } else {
            Vector choices = this.pd_.getPertAnnotations().getAvailableTagChoices();
            UiUtil.replaceComboItems(this.tagCombo_, choices);
        }
    }

    protected boolean stashResults() {
        String newMsg;
        String newTag;
        JTextComponent jtc;
        PertAnnotations pa = this.pd_.getPertAnnotations();
        if (this.mode_ == 2) {
            jtc = (JTextComponent)this.tagComboMrg_.getEditor().getEditorComponent();
            newTag = jtc.getText().trim();
            jtc = (JTextComponent)this.messageCombo_.getEditor().getEditorComponent();
            newMsg = jtc.getText().trim();
        } else {
            jtc = (JTextComponent)this.tagCombo_.getEditor().getEditorComponent();
            newTag = jtc.getText().trim();
            newMsg = this.messageField_.getText().trim();
        }
        if (newTag.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertAnnotEdit.emptyTag"), this.rMan_.getString("pertAnnotEdit.emptyTagTitle"), 0);
            return false;
        }
        SortedMap footToKey = pa.getFootTagToKeyMap();
        String matchKey = (String)footToKey.get(DataUtil.normKey(newTag));
        if (matchKey != null) {
            boolean problem = false;
            if (this.mode_ == 2) {
                problem = !this.allMerge_.contains(matchKey);
            } else {
                boolean bl = problem = this.currKey_ == null || !this.currKey_.equals(matchKey);
            }
            if (problem) {
                JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertAnnotEdit.tagInUse"), this.rMan_.getString("pertAnnotEdit.tagInUseTitle"), 0);
                return false;
            }
        }
        this.tagResult_ = newTag;
        if (newMsg.equals("")) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getString("pertAnnotEdit.emptyMsg"), this.rMan_.getString("pertAnnotEdit.emptyMsgTitle"), 0);
            return false;
        }
        String gotIt = pa.messageExists(newMsg);
        if (gotIt != null) {
            boolean problem = false;
            if (this.mode_ == 2) {
                problem = !this.allMerge_.contains(gotIt);
            } else {
                boolean bl = problem = this.currKey_ == null || !gotIt.equals(this.currKey_);
            }
            if (problem) {
                String gotTag = pa.getTag(gotIt);
                String format = this.rMan_.getString("pertAnnotEdit.dupMessageFormat");
                String desc = MessageFormat.format(format, gotTag);
                int ok = JOptionPane.showConfirmDialog(this.parent_, desc, this.rMan_.getString("pertAnnotEdit.dupMessageTitle"), 0);
                if (ok != 0) {
                    return false;
                }
            }
        }
        this.msgResult_ = newMsg;
        return true;
    }

    private void displayProperties() {
        this.updateOptions();
        PertAnnotations pa = this.pd_.getPertAnnotations();
        switch (this.mode_) {
            case 1: {
                if (this.currKey_ == null) {
                    UiUtil.initCombo(this.tagCombo_);
                    this.messageField_.setText("");
                    this.messageField_.setCaretPosition(0);
                } else {
                    this.tagCombo_.setSelectedItem(pa.getTag(this.currKey_));
                    this.messageField_.setText(pa.getMessage(this.currKey_));
                    this.messageField_.setCaretPosition(0);
                }
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 3: {
                JTextComponent jtc = (JTextComponent)this.tagCombo_.getEditor().getEditorComponent();
                jtc.setText(this.copyTag_);
                this.messageField_.setText(this.copyMsg_);
                this.messageField_.setCaretPosition(0);
                this.cardLayout_.show(this.myCard_, "edit");
                break;
            }
            case 2: {
                JTextComponent jtc = (JTextComponent)this.tagComboMrg_.getEditor().getEditorComponent();
                jtc.setText(pa.getTag(this.currKey_));
                jtc = (JTextComponent)this.tagCombo_.getEditor().getEditorComponent();
                jtc.setText(pa.getMessage(this.currKey_));
                this.cardLayout_.show(this.myCard_, "merge");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public class MyFreezeDried
    implements AnimatedSplitEditPanel.FreezeDried {
        private String messageFieldText;
        private String tagFieldText;

        MyFreezeDried() {
            if (PertAnnotEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertAnnotEditPanel.this.tagComboMrg_.getEditor().getEditorComponent();
                this.tagFieldText = jtc.getText().trim();
                jtc = (JTextComponent)PertAnnotEditPanel.this.messageCombo_.getEditor().getEditorComponent();
                this.messageFieldText = jtc.getText().trim();
            } else {
                JTextComponent jtc = (JTextComponent)PertAnnotEditPanel.this.tagCombo_.getEditor().getEditorComponent();
                this.tagFieldText = jtc.getText().trim();
                this.messageFieldText = PertAnnotEditPanel.this.messageField_.getText().trim();
            }
        }

        public boolean needToCancel() {
            if (PertAnnotEditPanel.this.mode_ == 2) {
                PertAnnotEditPanel.this.closeAction();
                return true;
            }
            if (PertAnnotEditPanel.this.currKey_ != null && PertAnnotEditPanel.this.pd_.getPertAnnotations().getTag(PertAnnotEditPanel.this.currKey_) == null) {
                PertAnnotEditPanel.this.closeAction();
                return true;
            }
            return false;
        }

        public void reInstall() {
            if (PertAnnotEditPanel.this.mode_ == 2) {
                JTextComponent jtc = (JTextComponent)PertAnnotEditPanel.this.tagComboMrg_.getEditor().getEditorComponent();
                jtc.setText(this.tagFieldText);
                jtc = (JTextComponent)PertAnnotEditPanel.this.messageCombo_.getEditor().getEditorComponent();
                jtc.setText(this.messageFieldText);
            } else {
                PertAnnotEditPanel.this.messageField_.setText(this.messageFieldText);
                JTextComponent jtc = (JTextComponent)PertAnnotEditPanel.this.tagCombo_.getEditor().getEditorComponent();
                jtc.setText(this.tagFieldText);
            }
        }
    }
}

