/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.ui.dialogs.pertManage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.DependencyAnalyzer;
import org.systemsbiology.biotapestry.perturb.PertAnnotations;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertAnnotEditPanel;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertFilterExpressionJumpTarget;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertManageHelper;
import org.systemsbiology.biotapestry.ui.dialogs.utils.AnimatedSplitManagePanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.ReadOnlyTable;
import org.systemsbiology.biotapestry.util.PendingEditTracker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TrueObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PertAnnotManagePanel
extends AnimatedSplitManagePanel {
    public static final String MANAGER_KEY = "annotManager";
    public static final String ANNOT_KEY = "editAnnot";
    private ReadOnlyTable rtda_;
    private PerturbationData pd_;
    private UndoManager undom_;
    private PertAnnotEditPanel paep_;
    private String currKey_;
    private PertManageHelper pmh_;
    private List joinKeys_;
    private PertFilterExpressionJumpTarget pfet_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public PertAnnotManagePanel(JFrame parent, PerturbationData pd, PendingEditTracker pet, PertFilterExpressionJumpTarget pfet, UndoManager undo) {
        super(parent, pet, MANAGER_KEY);
        this.pd_ = pd;
        this.undom_ = undo;
        this.pfet_ = pfet;
        this.pmh_ = new PertManageHelper(parent, pd, this.rMan_, this.gbc_, this.pet_);
        JPanel annotPanel = this.buildAnnotPanel();
        UiUtil.gbcSet(this.gbc_, 2, this.rowNum_++, 4, 1, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        this.topPanel_.add((Component)annotPanel, this.gbc_);
        this.paep_ = new PertAnnotEditPanel(this.parent_, this.pd_, this, ANNOT_KEY);
        this.addEditPanel(this.paep_, ANNOT_KEY);
        this.finishConstruction();
        this.displayProperties(true);
    }

    public void editIsComplete(String key, int what) {
        if (key.equals(ANNOT_KEY)) {
            if (this.joinKeys_ == null) {
                this.editAnnot(key, what);
            } else {
                this.joinAnnots(key, what);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void haveAChange(boolean mustDie) {
        this.displayProperties(true);
        this.paep_.hotUpdate(mustDie);
    }

    public void dropPendingEdits() {
        this.paep_.closeAction();
    }

    public void finished() {
        this.rtda_.makeCurrentSelectionVisible();
    }

    public boolean tableRowMatches(String key, Object obj, String tableID) {
        if (tableID.equals(ANNOT_KEY)) {
            AnnotEntry pse = (AnnotEntry)obj;
            return pse.key.equals(key);
        }
        throw new IllegalArgumentException();
    }

    public void setTableSelection(String whichTable, String whichKey) {
        if (whichTable == null) {
            return;
        }
        if (!whichTable.equals(ANNOT_KEY)) {
            throw new IllegalArgumentException();
        }
        this.pmh_.selectTableRow(this.rtda_, whichKey, this, ANNOT_KEY);
    }

    protected void enableTopPane(boolean enable) {
        this.rtda_.setEnabled(enable);
    }

    protected void displayProperties(boolean fireChange) {
        List selKeys = this.rtda_.selectedRows == null ? null : ((AnnotModel)this.rtda_.getModel()).getSelectedKeys(this.rtda_.selectedRows);
        this.rtda_.rowElements.clear();
        PertAnnotations pa = this.pd_.getPertAnnotations();
        Map refCounts = this.pd_.getDependencyAnalyzer().getAllAnnotReferenceCounts();
        Integer noCount = new Integer(0);
        SortedMap n2k = pa.getFootTagToKeyMap();
        Iterator n2kit = n2k.keySet().iterator();
        while (n2kit.hasNext()) {
            String tag = (String)n2kit.next();
            String key = (String)n2k.get(tag);
            String message = pa.getMessage(key);
            Integer refCount = (Integer)refCounts.get(key);
            if (refCount == null) {
                refCount = noCount;
            }
            this.rtda_.rowElements.add(new AnnotEntry(key, tag, message, refCount));
        }
        this.pmh_.updateAndReselect(fireChange, this.rtda_, this, ANNOT_KEY, selKeys);
    }

    protected void doAnAdd(String key) {
        this.currKey_ = null;
        this.rtda_.clearSelections(false);
        this.paep_.setEditAnnotation(this.currKey_);
        this.paep_.startEditing();
    }

    protected void doAnEdit(String key) {
        this.currKey_ = ((AnnotModel)this.rtda_.getModel()).getSelectedKey(this.rtda_.selectedRows);
        this.paep_.setEditAnnotation(this.currKey_);
        this.paep_.startEditing();
    }

    protected void doADelete(String key) {
        String annotKey;
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        DependencyAnalyzer.Dependencies refs = da.getAnnotReferenceSet(annotKey = ((AnnotModel)this.rtda_.getModel()).getSelectedKey(this.rtda_.selectedRows));
        if (!this.pmh_.warnAndAsk(refs)) {
            return;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deletePertAnnot");
        da.killOffDependencies(refs, support);
        PertDataChange pdc = this.pd_.deleteAnnotation(annotKey);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        this.pet_.itemDeleted(ANNOT_KEY);
    }

    public void doADuplication(String key) {
        this.currKey_ = null;
        String dupKey = ((AnnotModel)this.rtda_.getModel()).getSelectedKey(this.rtda_.selectedRows);
        TrueObjChoiceContent tocc = (TrueObjChoiceContent)this.pd_.getPertAnnotations().getAvailableTagChoices().get(0);
        String dupText = this.pd_.getPertAnnotations().getMessage(dupKey);
        this.paep_.setDupAnnotation(tocc.name, dupText);
        this.paep_.startEditing();
    }

    public void doAJoin(String key) {
        this.joinKeys_ = ((AnnotModel)this.rtda_.getModel()).getSelectedKeys(this.rtda_.selectedRows);
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        Map refCounts = da.getAllAnnotReferenceCounts();
        this.currKey_ = this.pmh_.getMostUsedKey(refCounts, this.joinKeys_);
        TreeSet<String> nameOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> tagOptions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        PertAnnotations pa = this.pd_.getPertAnnotations();
        int numk = this.joinKeys_.size();
        for (int i = 0; i < numk; ++i) {
            String nextJk = (String)this.joinKeys_.get(i);
            nameOptions.add(pa.getMessage(nextJk));
            tagOptions.add(pa.getTag(nextJk));
        }
        this.paep_.setMergeName(this.joinKeys_, this.currKey_, nameOptions, tagOptions);
        this.paep_.startEditing();
    }

    public void doAFilterJump(String key) {
        String filterKey = ((AnnotModel)this.rtda_.getModel()).getSelectedKey(this.rtda_.selectedRows);
        PertFilter filter = new PertFilter(13, 0, filterKey);
        PertFilterExpression pfe = new PertFilterExpression(filter);
        this.pfet_.jumpWithNewFilter(pfe);
    }

    private void joinAnnots(String key, int what) {
        String msg = this.paep_.getMessageResult();
        String tag = this.paep_.getTagResult();
        DependencyAnalyzer da = this.pd_.getDependencyAnalyzer();
        UndoSupport support = new UndoSupport(this.undom_, "undo.mergePertAnnot");
        DependencyAnalyzer.Dependencies refs = da.getAnnotMergeSet(new HashSet(this.joinKeys_), this.currKey_);
        da.mergeDependencies(refs, support);
        PertDataChange pdc = this.pd_.mergeAnnotations(this.joinKeys_, this.currKey_, tag, msg);
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        String resultKey = this.currKey_;
        this.currKey_ = null;
        this.joinKeys_ = null;
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    public void editAnnot(String key, int what) {
        String resultKey;
        PertDataChange pdc;
        UndoSupport support;
        String msg = this.paep_.getMessageResult();
        String tag = this.paep_.getTagResult();
        if (this.currKey_ == null) {
            support = new UndoSupport(this.undom_, "undo.createPertAnnot");
            pdc = this.pd_.addAnnotation(tag, msg);
            resultKey = pdc.annotKey;
        } else {
            support = new UndoSupport(this.undom_, "undo.editPertAnnot");
            pdc = this.pd_.editAnnotation(this.currKey_, tag, msg);
            resultKey = this.currKey_;
        }
        this.currKey_ = null;
        support.addEdit(new PertDataChangeCmd(pdc));
        support.addEvent(new GeneralChangeEvent(3));
        this.pet_.editSubmissionBegins();
        support.finish();
        this.pet_.editSubmissionEnds();
        super.editIsComplete(key, what);
        this.setTableSelection(key, resultKey);
    }

    private JPanel buildAnnotPanel() {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel display = new JPanel();
        display.setBorder(new EtchedBorder());
        display.setLayout(new GridBagLayout());
        this.rtda_ = new ReadOnlyTable(new AnnotModel(), new ReadOnlyTable.EmptySelector());
        this.rtda_.setButtonHandler(new AnimatedSplitManagePanel.ButtonHand(ANNOT_KEY));
        ReadOnlyTable.TableParams tp = new ReadOnlyTable.TableParams();
        tp.disableColumnSort = false;
        tp.tableIsUnselectable = false;
        tp.buttons = 7;
        tp.multiTableSelectionSyncing = null;
        tp.tableTitle = rMan.getString("pertSetupManage.annotations");
        tp.canMultiSelect = true;
        tp.titleFont = null;
        tp.colWidths = new ArrayList();
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(0, 50, 100, 200));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(1, 100, 400, Integer.MAX_VALUE));
        tp.colWidths.add(new ReadOnlyTable.ColumnWidths(2, 50, 50, 100));
        this.addExtraButtons(tp, ANNOT_KEY);
        JPanel tabPan = this.rtda_.buildReadOnlyTable(tp);
        GridBagConstraints gbc = new GridBagConstraints();
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        display.add((Component)tabPan, gbc);
        tabPan.setMinimumSize(new Dimension(400, 100));
        return display;
    }

    private class AnnotEntry {
        String key;
        String tag;
        String message;
        Integer refCount;

        AnnotEntry(String key, String tag, String message, Integer refCount) {
            this.key = key;
            this.tag = tag;
            this.message = message;
            this.refCount = refCount;
        }
    }

    class AnnotModel
    extends ReadOnlyTable.TableModel {
        static final int TAG = 0;
        static final int MESSAGE = 1;
        static final int REFCOUNT = 2;
        private static final int NUM_COL_ = 3;
        private static final int HIDDEN_ID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        AnnotModel() {
            super(3);
            this.colNames_ = new String[]{"annotTable.tag", "annotTable.message", "annotTable.refCount"};
            this.colClasses_ = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PertAnnotManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PertAnnotManagePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PertAnnotManagePanel.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.comparators_ = new Comparator[]{new ReadOnlyTable.NumStrComparator(), String.CASE_INSENSITIVE_ORDER, new ReadOnlyTable.IntegerComparator()};
            this.addHiddenColumns(1);
        }

        public void extractValues(List prsList) {
            super.extractValues(prsList);
            this.hiddenColumns_[0].clear();
            Iterator iit = prsList.iterator();
            while (iit.hasNext()) {
                AnnotEntry ae = (AnnotEntry)iit.next();
                this.columns_[0].add(ae.tag);
                this.columns_[1].add(ae.message);
                this.columns_[2].add(ae.refCount);
                this.hiddenColumns_[0].add(ae.key);
            }
        }

        String getSelectedKey(int[] selected) {
            return (String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[0]));
        }

        public List getSelectedKeys(int[] selected) {
            ArrayList<String> retval = new ArrayList<String>();
            for (int i = 0; i < selected.length; ++i) {
                retval.add((String)this.hiddenColumns_[0].get(this.mapSelectionIndex(selected[i])));
            }
            return retval;
        }
    }
}

